package table

import (
	"testing"

	"github.com/jedib0t/go-pretty/v6/text"
)

func TestTable_Render_BiDiText(t *testing.T) {
	// sonar: ignore from here
	table := Table{}
	table.AppendHeader(Row{"תאריך", "סכום", "מחלקה", "תגים"})
	table.AppendRow(Row{"2020-01-01", 5.0, "מחלקה1", []string{"תג1", "תג2"}})
	table.AppendRow(Row{"2021-02-01", 5.0, "מחלקה1", []string{"תג1"}})
	table.AppendRow(Row{"2022-03-01", 5.0, "מחלקה2", []string{"תג1"}})
	table.AppendFooter(Row{"סהכ", 30})
	table.SetAutoIndex(true)

	compareOutput(t, table.Render(), `
+---+------------+------+--------+-----------+
|   | תאריך      | סכום | מחלקה  | תגים      |
+---+------------+------+--------+-----------+
| 1 | 2020-01-01 |    5 | מחלקה1 | [תג1 תג2] |
| 2 | 2021-02-01 |    5 | מחלקה1 | [תג1]     |
| 3 | 2022-03-01 |    5 | מחלקה2 | [תג1]     |
+---+------------+------+--------+-----------+
|   | סהכ        |   30 |        |           |
+---+------------+------+--------+-----------+`)

	table.Style().Format.Direction = text.LeftToRight
	compareOutput(t, table.Render(), "\u202A+---+------------+------+--------+-----------+\n"+
		"\u202A|   | \u202Aתאריך      | \u202Aסכום | \u202Aמחלקה  | \u202Aתגים      |\n"+
		"\u202A+---+------------+------+--------+-----------+\n"+
		"\u202A| 1 | \u202A2020-01-01 |    \u202A5 | \u202Aמחלקה1 | \u202A[תג1 תג2] |\n"+
		"\u202A| 2 | \u202A2021-02-01 |    \u202A5 | \u202Aמחלקה1 | \u202A[תג1]     |\n"+
		"\u202A| 3 | \u202A2022-03-01 |    \u202A5 | \u202Aמחלקה2 | \u202A[תג1]     |\n"+
		"\u202A+---+------------+------+--------+-----------+\n"+
		"\u202A|   | \u202Aסהכ        |   \u202A30 |        |           |\n"+
		"\u202A+---+------------+------+--------+-----------+")

	table.Style().Format.Direction = text.RightToLeft
	compareOutput(t, table.Render(), "\u202B+---+------------+------+--------+-----------+\n"+
		"\u202B|   | \u202Bתאריך      | \u202Bסכום | \u202Bמחלקה  | \u202Bתגים      |\n"+
		"\u202B+---+------------+------+--------+-----------+\n"+
		"\u202B| 1 | \u202B2020-01-01 |    \u202B5 | \u202Bמחלקה1 | \u202B[תג1 תג2] |\n"+
		"\u202B| 2 | \u202B2021-02-01 |    \u202B5 | \u202Bמחלקה1 | \u202B[תג1]     |\n"+
		"\u202B| 3 | \u202B2022-03-01 |    \u202B5 | \u202Bמחלקה2 | \u202B[תג1]     |\n"+
		"\u202B+---+------------+------+--------+-----------+\n"+
		"\u202B|   | \u202Bסהכ        |   \u202B30 |        |           |\n"+
		"\u202B+---+------------+------+--------+-----------+")
	// sonar: ignore to here
}
