// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/answer_record.proto

package dialogflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AnswerRecords_ListAnswerRecords_FullMethodName  = "/google.cloud.dialogflow.v2.AnswerRecords/ListAnswerRecords"
	AnswerRecords_UpdateAnswerRecord_FullMethodName = "/google.cloud.dialogflow.v2.AnswerRecords/UpdateAnswerRecord"
)

// AnswerRecordsClient is the client API for AnswerRecords service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AnswerRecordsClient interface {
	// Returns the list of all answer records in the specified project in reverse
	// chronological order.
	ListAnswerRecords(ctx context.Context, in *ListAnswerRecordsRequest, opts ...grpc.CallOption) (*ListAnswerRecordsResponse, error)
	// Updates the specified answer record.
	UpdateAnswerRecord(ctx context.Context, in *UpdateAnswerRecordRequest, opts ...grpc.CallOption) (*AnswerRecord, error)
}

type answerRecordsClient struct {
	cc grpc.ClientConnInterface
}

func NewAnswerRecordsClient(cc grpc.ClientConnInterface) AnswerRecordsClient {
	return &answerRecordsClient{cc}
}

func (c *answerRecordsClient) ListAnswerRecords(ctx context.Context, in *ListAnswerRecordsRequest, opts ...grpc.CallOption) (*ListAnswerRecordsResponse, error) {
	out := new(ListAnswerRecordsResponse)
	err := c.cc.Invoke(ctx, AnswerRecords_ListAnswerRecords_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *answerRecordsClient) UpdateAnswerRecord(ctx context.Context, in *UpdateAnswerRecordRequest, opts ...grpc.CallOption) (*AnswerRecord, error) {
	out := new(AnswerRecord)
	err := c.cc.Invoke(ctx, AnswerRecords_UpdateAnswerRecord_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnswerRecordsServer is the server API for AnswerRecords service.
// All implementations should embed UnimplementedAnswerRecordsServer
// for forward compatibility
type AnswerRecordsServer interface {
	// Returns the list of all answer records in the specified project in reverse
	// chronological order.
	ListAnswerRecords(context.Context, *ListAnswerRecordsRequest) (*ListAnswerRecordsResponse, error)
	// Updates the specified answer record.
	UpdateAnswerRecord(context.Context, *UpdateAnswerRecordRequest) (*AnswerRecord, error)
}

// UnimplementedAnswerRecordsServer should be embedded to have forward compatible implementations.
type UnimplementedAnswerRecordsServer struct {
}

func (UnimplementedAnswerRecordsServer) ListAnswerRecords(context.Context, *ListAnswerRecordsRequest) (*ListAnswerRecordsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnswerRecords not implemented")
}
func (UnimplementedAnswerRecordsServer) UpdateAnswerRecord(context.Context, *UpdateAnswerRecordRequest) (*AnswerRecord, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAnswerRecord not implemented")
}

// UnsafeAnswerRecordsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AnswerRecordsServer will
// result in compilation errors.
type UnsafeAnswerRecordsServer interface {
	mustEmbedUnimplementedAnswerRecordsServer()
}

func RegisterAnswerRecordsServer(s grpc.ServiceRegistrar, srv AnswerRecordsServer) {
	s.RegisterService(&AnswerRecords_ServiceDesc, srv)
}

func _AnswerRecords_ListAnswerRecords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnswerRecordsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnswerRecordsServer).ListAnswerRecords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnswerRecords_ListAnswerRecords_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnswerRecordsServer).ListAnswerRecords(ctx, req.(*ListAnswerRecordsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnswerRecords_UpdateAnswerRecord_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnswerRecordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnswerRecordsServer).UpdateAnswerRecord(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnswerRecords_UpdateAnswerRecord_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnswerRecordsServer).UpdateAnswerRecord(ctx, req.(*UpdateAnswerRecordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AnswerRecords_ServiceDesc is the grpc.ServiceDesc for AnswerRecords service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AnswerRecords_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.AnswerRecords",
	HandlerType: (*AnswerRecordsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAnswerRecords",
			Handler:    _AnswerRecords_ListAnswerRecords_Handler,
		},
		{
			MethodName: "UpdateAnswerRecord",
			Handler:    _AnswerRecords_UpdateAnswerRecord_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/answer_record.proto",
}
