// Code generated by radius-dict-gen. DO NOT EDIT.

package mikrotik

import (
	"net"
	"strconv"

	"layeh.com/radius"
	"layeh.com/radius/rfc2865"
)

const (
	_Mikrotik_VendorID = 14988
)

func _Mikrotik_AddVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	var vsa radius.Attribute
	vendor := make(radius.Attribute, 2+len(attr))
	vendor[0] = typ
	vendor[1] = byte(len(vendor))
	copy(vendor[2:], attr)
	vsa, err = radius.NewVendorSpecific(_Mikrotik_VendorID, vendor)
	if err != nil {
		return
	}
	p.Add(rfc2865.VendorSpecific_Type, vsa)
	return
}

func _Mikrotik_GetsVendor(p *radius.Packet, typ byte) (values []radius.Attribute) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _Mikrotik_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				values = append(values, vsa[2:int(vsaLen)])
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _Mikrotik_LookupVendor(p *radius.Packet, typ byte) (attr radius.Attribute, ok bool) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _Mikrotik_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				return vsa[2:int(vsaLen)], true
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _Mikrotik_SetVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _Mikrotik_VendorID {
			i++
			continue
		}
		for j := 0; len(vsa[j:]) >= 3; {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa[j:]) || vsaLen < 3 {
				i++
				break
			}
			if vsaTyp == typ {
				vsa = append(vsa[:j], vsa[j+int(vsaLen):]...)
			}
			j += int(vsaLen)
		}
		if len(vsa) > 0 {
			copy(avp.Attribute[4:], vsa)
			i++
		} else {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+i:]...)
		}
	}
	return _Mikrotik_AddVendor(p, typ, attr)
}

func _Mikrotik_DelVendor(p *radius.Packet, typ byte) {
vsaLoop:
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _Mikrotik_VendorID {
			i++
			continue
		}
		offset := 0
		for len(vsa[offset:]) >= 3 {
			vsaTyp, vsaLen := vsa[offset], vsa[offset+1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				continue vsaLoop
			}
			if vsaTyp == typ {
				copy(vsa[offset:], vsa[offset+int(vsaLen):])
				vsa = vsa[:len(vsa)-int(vsaLen)]
			} else {
				offset += int(vsaLen)
			}
		}
		if offset == 0 {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+1:]...)
		} else {
			i++
		}
	}
	return
}

type MikrotikRecvLimit uint32

var MikrotikRecvLimit_Strings = map[MikrotikRecvLimit]string{}

func (a MikrotikRecvLimit) String() string {
	if str, ok := MikrotikRecvLimit_Strings[a]; ok {
		return str
	}
	return "MikrotikRecvLimit(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikRecvLimit_Add(p *radius.Packet, value MikrotikRecvLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 1, a)
}

func MikrotikRecvLimit_Get(p *radius.Packet) (value MikrotikRecvLimit) {
	value, _ = MikrotikRecvLimit_Lookup(p)
	return
}

func MikrotikRecvLimit_Gets(p *radius.Packet) (values []MikrotikRecvLimit, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 1) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikRecvLimit(i))
	}
	return
}

func MikrotikRecvLimit_Lookup(p *radius.Packet) (value MikrotikRecvLimit, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikRecvLimit(i)
	return
}

func MikrotikRecvLimit_Set(p *radius.Packet, value MikrotikRecvLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 1, a)
}

func MikrotikRecvLimit_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 1)
}

type MikrotikXmitLimit uint32

var MikrotikXmitLimit_Strings = map[MikrotikXmitLimit]string{}

func (a MikrotikXmitLimit) String() string {
	if str, ok := MikrotikXmitLimit_Strings[a]; ok {
		return str
	}
	return "MikrotikXmitLimit(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikXmitLimit_Add(p *radius.Packet, value MikrotikXmitLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 2, a)
}

func MikrotikXmitLimit_Get(p *radius.Packet) (value MikrotikXmitLimit) {
	value, _ = MikrotikXmitLimit_Lookup(p)
	return
}

func MikrotikXmitLimit_Gets(p *radius.Packet) (values []MikrotikXmitLimit, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 2) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikXmitLimit(i))
	}
	return
}

func MikrotikXmitLimit_Lookup(p *radius.Packet) (value MikrotikXmitLimit, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 2)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikXmitLimit(i)
	return
}

func MikrotikXmitLimit_Set(p *radius.Packet, value MikrotikXmitLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 2, a)
}

func MikrotikXmitLimit_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 2)
}

func MikrotikGroup_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 3, a)
}

func MikrotikGroup_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 3, a)
}

func MikrotikGroup_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikGroup_Lookup(p)
	return
}

func MikrotikGroup_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikGroup_LookupString(p)
	return
}

func MikrotikGroup_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 3) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikGroup_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 3) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikGroup_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 3)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikGroup_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 3)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikGroup_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 3, a)
}

func MikrotikGroup_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 3, a)
}

func MikrotikGroup_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 3)
}

type MikrotikWirelessForward uint32

var MikrotikWirelessForward_Strings = map[MikrotikWirelessForward]string{}

func (a MikrotikWirelessForward) String() string {
	if str, ok := MikrotikWirelessForward_Strings[a]; ok {
		return str
	}
	return "MikrotikWirelessForward(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikWirelessForward_Add(p *radius.Packet, value MikrotikWirelessForward) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 4, a)
}

func MikrotikWirelessForward_Get(p *radius.Packet) (value MikrotikWirelessForward) {
	value, _ = MikrotikWirelessForward_Lookup(p)
	return
}

func MikrotikWirelessForward_Gets(p *radius.Packet) (values []MikrotikWirelessForward, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 4) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikWirelessForward(i))
	}
	return
}

func MikrotikWirelessForward_Lookup(p *radius.Packet) (value MikrotikWirelessForward, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 4)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikWirelessForward(i)
	return
}

func MikrotikWirelessForward_Set(p *radius.Packet, value MikrotikWirelessForward) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 4, a)
}

func MikrotikWirelessForward_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 4)
}

type MikrotikWirelessSkipDot1x uint32

var MikrotikWirelessSkipDot1x_Strings = map[MikrotikWirelessSkipDot1x]string{}

func (a MikrotikWirelessSkipDot1x) String() string {
	if str, ok := MikrotikWirelessSkipDot1x_Strings[a]; ok {
		return str
	}
	return "MikrotikWirelessSkipDot1x(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikWirelessSkipDot1x_Add(p *radius.Packet, value MikrotikWirelessSkipDot1x) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 5, a)
}

func MikrotikWirelessSkipDot1x_Get(p *radius.Packet) (value MikrotikWirelessSkipDot1x) {
	value, _ = MikrotikWirelessSkipDot1x_Lookup(p)
	return
}

func MikrotikWirelessSkipDot1x_Gets(p *radius.Packet) (values []MikrotikWirelessSkipDot1x, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 5) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikWirelessSkipDot1x(i))
	}
	return
}

func MikrotikWirelessSkipDot1x_Lookup(p *radius.Packet) (value MikrotikWirelessSkipDot1x, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 5)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikWirelessSkipDot1x(i)
	return
}

func MikrotikWirelessSkipDot1x_Set(p *radius.Packet, value MikrotikWirelessSkipDot1x) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 5, a)
}

func MikrotikWirelessSkipDot1x_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 5)
}

type MikrotikWirelessEncAlgo uint32

const (
	MikrotikWirelessEncAlgo_Value_NoEncryption MikrotikWirelessEncAlgo = 0
	MikrotikWirelessEncAlgo_Value_Four0BitWEP  MikrotikWirelessEncAlgo = 1
	MikrotikWirelessEncAlgo_Value_One04BitWEP  MikrotikWirelessEncAlgo = 2
	MikrotikWirelessEncAlgo_Value_AESCCM       MikrotikWirelessEncAlgo = 3
	MikrotikWirelessEncAlgo_Value_TKIP         MikrotikWirelessEncAlgo = 4
)

var MikrotikWirelessEncAlgo_Strings = map[MikrotikWirelessEncAlgo]string{
	MikrotikWirelessEncAlgo_Value_NoEncryption: "No-encryption",
	MikrotikWirelessEncAlgo_Value_Four0BitWEP:  "40-bit-WEP",
	MikrotikWirelessEncAlgo_Value_One04BitWEP:  "104-bit-WEP",
	MikrotikWirelessEncAlgo_Value_AESCCM:       "AES-CCM",
	MikrotikWirelessEncAlgo_Value_TKIP:         "TKIP",
}

func (a MikrotikWirelessEncAlgo) String() string {
	if str, ok := MikrotikWirelessEncAlgo_Strings[a]; ok {
		return str
	}
	return "MikrotikWirelessEncAlgo(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikWirelessEncAlgo_Add(p *radius.Packet, value MikrotikWirelessEncAlgo) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 6, a)
}

func MikrotikWirelessEncAlgo_Get(p *radius.Packet) (value MikrotikWirelessEncAlgo) {
	value, _ = MikrotikWirelessEncAlgo_Lookup(p)
	return
}

func MikrotikWirelessEncAlgo_Gets(p *radius.Packet) (values []MikrotikWirelessEncAlgo, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 6) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikWirelessEncAlgo(i))
	}
	return
}

func MikrotikWirelessEncAlgo_Lookup(p *radius.Packet) (value MikrotikWirelessEncAlgo, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 6)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikWirelessEncAlgo(i)
	return
}

func MikrotikWirelessEncAlgo_Set(p *radius.Packet, value MikrotikWirelessEncAlgo) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 6, a)
}

func MikrotikWirelessEncAlgo_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 6)
}

func MikrotikWirelessEncKey_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 7, a)
}

func MikrotikWirelessEncKey_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 7, a)
}

func MikrotikWirelessEncKey_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikWirelessEncKey_Lookup(p)
	return
}

func MikrotikWirelessEncKey_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikWirelessEncKey_LookupString(p)
	return
}

func MikrotikWirelessEncKey_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 7) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessEncKey_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 7) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessEncKey_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 7)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikWirelessEncKey_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 7)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikWirelessEncKey_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 7, a)
}

func MikrotikWirelessEncKey_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 7, a)
}

func MikrotikWirelessEncKey_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 7)
}

func MikrotikRateLimit_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 8, a)
}

func MikrotikRateLimit_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 8, a)
}

func MikrotikRateLimit_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikRateLimit_Lookup(p)
	return
}

func MikrotikRateLimit_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikRateLimit_LookupString(p)
	return
}

func MikrotikRateLimit_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 8) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikRateLimit_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 8) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikRateLimit_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 8)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikRateLimit_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 8)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikRateLimit_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 8, a)
}

func MikrotikRateLimit_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 8, a)
}

func MikrotikRateLimit_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 8)
}

func MikrotikRealm_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 9, a)
}

func MikrotikRealm_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 9, a)
}

func MikrotikRealm_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikRealm_Lookup(p)
	return
}

func MikrotikRealm_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikRealm_LookupString(p)
	return
}

func MikrotikRealm_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 9) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikRealm_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 9) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikRealm_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 9)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikRealm_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 9)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikRealm_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 9, a)
}

func MikrotikRealm_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 9, a)
}

func MikrotikRealm_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 9)
}

func MikrotikHostIP_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 10, a)
}

func MikrotikHostIP_Get(p *radius.Packet) (value net.IP) {
	value, _ = MikrotikHostIP_Lookup(p)
	return
}

func MikrotikHostIP_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Mikrotik_GetsVendor(p, 10) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikHostIP_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 10)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func MikrotikHostIP_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 10, a)
}

func MikrotikHostIP_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 10)
}

func MikrotikMarkID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 11, a)
}

func MikrotikMarkID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 11, a)
}

func MikrotikMarkID_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikMarkID_Lookup(p)
	return
}

func MikrotikMarkID_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikMarkID_LookupString(p)
	return
}

func MikrotikMarkID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 11) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikMarkID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 11) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikMarkID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 11)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikMarkID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 11)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikMarkID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 11, a)
}

func MikrotikMarkID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 11, a)
}

func MikrotikMarkID_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 11)
}

func MikrotikAdvertiseURL_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 12, a)
}

func MikrotikAdvertiseURL_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 12, a)
}

func MikrotikAdvertiseURL_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikAdvertiseURL_Lookup(p)
	return
}

func MikrotikAdvertiseURL_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikAdvertiseURL_LookupString(p)
	return
}

func MikrotikAdvertiseURL_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 12) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikAdvertiseURL_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 12) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikAdvertiseURL_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 12)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikAdvertiseURL_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 12)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikAdvertiseURL_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 12, a)
}

func MikrotikAdvertiseURL_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 12, a)
}

func MikrotikAdvertiseURL_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 12)
}

type MikrotikAdvertiseInterval uint32

var MikrotikAdvertiseInterval_Strings = map[MikrotikAdvertiseInterval]string{}

func (a MikrotikAdvertiseInterval) String() string {
	if str, ok := MikrotikAdvertiseInterval_Strings[a]; ok {
		return str
	}
	return "MikrotikAdvertiseInterval(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikAdvertiseInterval_Add(p *radius.Packet, value MikrotikAdvertiseInterval) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 13, a)
}

func MikrotikAdvertiseInterval_Get(p *radius.Packet) (value MikrotikAdvertiseInterval) {
	value, _ = MikrotikAdvertiseInterval_Lookup(p)
	return
}

func MikrotikAdvertiseInterval_Gets(p *radius.Packet) (values []MikrotikAdvertiseInterval, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 13) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikAdvertiseInterval(i))
	}
	return
}

func MikrotikAdvertiseInterval_Lookup(p *radius.Packet) (value MikrotikAdvertiseInterval, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 13)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikAdvertiseInterval(i)
	return
}

func MikrotikAdvertiseInterval_Set(p *radius.Packet, value MikrotikAdvertiseInterval) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 13, a)
}

func MikrotikAdvertiseInterval_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 13)
}

type MikrotikRecvLimitGigawords uint32

var MikrotikRecvLimitGigawords_Strings = map[MikrotikRecvLimitGigawords]string{}

func (a MikrotikRecvLimitGigawords) String() string {
	if str, ok := MikrotikRecvLimitGigawords_Strings[a]; ok {
		return str
	}
	return "MikrotikRecvLimitGigawords(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikRecvLimitGigawords_Add(p *radius.Packet, value MikrotikRecvLimitGigawords) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 14, a)
}

func MikrotikRecvLimitGigawords_Get(p *radius.Packet) (value MikrotikRecvLimitGigawords) {
	value, _ = MikrotikRecvLimitGigawords_Lookup(p)
	return
}

func MikrotikRecvLimitGigawords_Gets(p *radius.Packet) (values []MikrotikRecvLimitGigawords, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 14) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikRecvLimitGigawords(i))
	}
	return
}

func MikrotikRecvLimitGigawords_Lookup(p *radius.Packet) (value MikrotikRecvLimitGigawords, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 14)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikRecvLimitGigawords(i)
	return
}

func MikrotikRecvLimitGigawords_Set(p *radius.Packet, value MikrotikRecvLimitGigawords) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 14, a)
}

func MikrotikRecvLimitGigawords_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 14)
}

type MikrotikXmitLimitGigawords uint32

var MikrotikXmitLimitGigawords_Strings = map[MikrotikXmitLimitGigawords]string{}

func (a MikrotikXmitLimitGigawords) String() string {
	if str, ok := MikrotikXmitLimitGigawords_Strings[a]; ok {
		return str
	}
	return "MikrotikXmitLimitGigawords(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikXmitLimitGigawords_Add(p *radius.Packet, value MikrotikXmitLimitGigawords) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 15, a)
}

func MikrotikXmitLimitGigawords_Get(p *radius.Packet) (value MikrotikXmitLimitGigawords) {
	value, _ = MikrotikXmitLimitGigawords_Lookup(p)
	return
}

func MikrotikXmitLimitGigawords_Gets(p *radius.Packet) (values []MikrotikXmitLimitGigawords, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 15) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikXmitLimitGigawords(i))
	}
	return
}

func MikrotikXmitLimitGigawords_Lookup(p *radius.Packet) (value MikrotikXmitLimitGigawords, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 15)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikXmitLimitGigawords(i)
	return
}

func MikrotikXmitLimitGigawords_Set(p *radius.Packet, value MikrotikXmitLimitGigawords) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 15, a)
}

func MikrotikXmitLimitGigawords_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 15)
}

func MikrotikWirelessPSK_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 16, a)
}

func MikrotikWirelessPSK_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 16, a)
}

func MikrotikWirelessPSK_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikWirelessPSK_Lookup(p)
	return
}

func MikrotikWirelessPSK_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikWirelessPSK_LookupString(p)
	return
}

func MikrotikWirelessPSK_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 16) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessPSK_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 16) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessPSK_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 16)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikWirelessPSK_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 16)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikWirelessPSK_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 16, a)
}

func MikrotikWirelessPSK_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 16, a)
}

func MikrotikWirelessPSK_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 16)
}

type MikrotikTotalLimit uint32

var MikrotikTotalLimit_Strings = map[MikrotikTotalLimit]string{}

func (a MikrotikTotalLimit) String() string {
	if str, ok := MikrotikTotalLimit_Strings[a]; ok {
		return str
	}
	return "MikrotikTotalLimit(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikTotalLimit_Add(p *radius.Packet, value MikrotikTotalLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 17, a)
}

func MikrotikTotalLimit_Get(p *radius.Packet) (value MikrotikTotalLimit) {
	value, _ = MikrotikTotalLimit_Lookup(p)
	return
}

func MikrotikTotalLimit_Gets(p *radius.Packet) (values []MikrotikTotalLimit, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 17) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikTotalLimit(i))
	}
	return
}

func MikrotikTotalLimit_Lookup(p *radius.Packet) (value MikrotikTotalLimit, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 17)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikTotalLimit(i)
	return
}

func MikrotikTotalLimit_Set(p *radius.Packet, value MikrotikTotalLimit) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 17, a)
}

func MikrotikTotalLimit_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 17)
}

type MikrotikTotalLimitGigawords uint32

var MikrotikTotalLimitGigawords_Strings = map[MikrotikTotalLimitGigawords]string{}

func (a MikrotikTotalLimitGigawords) String() string {
	if str, ok := MikrotikTotalLimitGigawords_Strings[a]; ok {
		return str
	}
	return "MikrotikTotalLimitGigawords(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikTotalLimitGigawords_Add(p *radius.Packet, value MikrotikTotalLimitGigawords) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 18, a)
}

func MikrotikTotalLimitGigawords_Get(p *radius.Packet) (value MikrotikTotalLimitGigawords) {
	value, _ = MikrotikTotalLimitGigawords_Lookup(p)
	return
}

func MikrotikTotalLimitGigawords_Gets(p *radius.Packet) (values []MikrotikTotalLimitGigawords, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 18) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikTotalLimitGigawords(i))
	}
	return
}

func MikrotikTotalLimitGigawords_Lookup(p *radius.Packet) (value MikrotikTotalLimitGigawords, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 18)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikTotalLimitGigawords(i)
	return
}

func MikrotikTotalLimitGigawords_Set(p *radius.Packet, value MikrotikTotalLimitGigawords) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 18, a)
}

func MikrotikTotalLimitGigawords_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 18)
}

func MikrotikAddressList_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 19, a)
}

func MikrotikAddressList_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 19, a)
}

func MikrotikAddressList_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikAddressList_Lookup(p)
	return
}

func MikrotikAddressList_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikAddressList_LookupString(p)
	return
}

func MikrotikAddressList_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 19) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikAddressList_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 19) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikAddressList_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 19)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikAddressList_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 19)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikAddressList_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 19, a)
}

func MikrotikAddressList_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 19, a)
}

func MikrotikAddressList_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 19)
}

func MikrotikWirelessMPKey_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 20, a)
}

func MikrotikWirelessMPKey_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 20, a)
}

func MikrotikWirelessMPKey_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikWirelessMPKey_Lookup(p)
	return
}

func MikrotikWirelessMPKey_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikWirelessMPKey_LookupString(p)
	return
}

func MikrotikWirelessMPKey_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 20) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessMPKey_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 20) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessMPKey_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 20)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikWirelessMPKey_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 20)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikWirelessMPKey_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 20, a)
}

func MikrotikWirelessMPKey_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 20, a)
}

func MikrotikWirelessMPKey_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 20)
}

func MikrotikWirelessComment_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 21, a)
}

func MikrotikWirelessComment_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 21, a)
}

func MikrotikWirelessComment_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikWirelessComment_Lookup(p)
	return
}

func MikrotikWirelessComment_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikWirelessComment_LookupString(p)
	return
}

func MikrotikWirelessComment_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 21) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessComment_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 21) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessComment_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 21)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikWirelessComment_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 21)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikWirelessComment_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 21, a)
}

func MikrotikWirelessComment_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 21, a)
}

func MikrotikWirelessComment_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 21)
}

func MikrotikDelegatedIPv6Pool_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 22, a)
}

func MikrotikDelegatedIPv6Pool_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 22, a)
}

func MikrotikDelegatedIPv6Pool_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikDelegatedIPv6Pool_Lookup(p)
	return
}

func MikrotikDelegatedIPv6Pool_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikDelegatedIPv6Pool_LookupString(p)
	return
}

func MikrotikDelegatedIPv6Pool_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 22) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikDelegatedIPv6Pool_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 22) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikDelegatedIPv6Pool_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 22)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikDelegatedIPv6Pool_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 22)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikDelegatedIPv6Pool_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 22, a)
}

func MikrotikDelegatedIPv6Pool_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 22, a)
}

func MikrotikDelegatedIPv6Pool_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 22)
}

func MikrotikDHCPOptionSet_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 23, a)
}

func MikrotikDHCPOptionSet_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 23, a)
}

func MikrotikDHCPOptionSet_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikDHCPOptionSet_Lookup(p)
	return
}

func MikrotikDHCPOptionSet_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikDHCPOptionSet_LookupString(p)
	return
}

func MikrotikDHCPOptionSet_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 23) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikDHCPOptionSet_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 23) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikDHCPOptionSet_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 23)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikDHCPOptionSet_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 23)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikDHCPOptionSet_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 23, a)
}

func MikrotikDHCPOptionSet_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 23, a)
}

func MikrotikDHCPOptionSet_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 23)
}

func MikrotikDHCPOptionParamSTR1_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 24, a)
}

func MikrotikDHCPOptionParamSTR1_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 24, a)
}

func MikrotikDHCPOptionParamSTR1_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikDHCPOptionParamSTR1_Lookup(p)
	return
}

func MikrotikDHCPOptionParamSTR1_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikDHCPOptionParamSTR1_LookupString(p)
	return
}

func MikrotikDHCPOptionParamSTR1_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 24) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikDHCPOptionParamSTR1_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 24) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikDHCPOptionParamSTR1_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 24)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikDHCPOptionParamSTR1_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 24)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikDHCPOptionParamSTR1_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 24, a)
}

func MikrotikDHCPOptionParamSTR1_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 24, a)
}

func MikrotikDHCPOptionParamSTR1_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 24)
}

func MikortikDHCPOptionParamSTR2_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 25, a)
}

func MikortikDHCPOptionParamSTR2_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 25, a)
}

func MikortikDHCPOptionParamSTR2_Get(p *radius.Packet) (value []byte) {
	value, _ = MikortikDHCPOptionParamSTR2_Lookup(p)
	return
}

func MikortikDHCPOptionParamSTR2_GetString(p *radius.Packet) (value string) {
	value, _ = MikortikDHCPOptionParamSTR2_LookupString(p)
	return
}

func MikortikDHCPOptionParamSTR2_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 25) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikortikDHCPOptionParamSTR2_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 25) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikortikDHCPOptionParamSTR2_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 25)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikortikDHCPOptionParamSTR2_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 25)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikortikDHCPOptionParamSTR2_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 25, a)
}

func MikortikDHCPOptionParamSTR2_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 25, a)
}

func MikortikDHCPOptionParamSTR2_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 25)
}

type MikrotikWirelessVLANID uint32

var MikrotikWirelessVLANID_Strings = map[MikrotikWirelessVLANID]string{}

func (a MikrotikWirelessVLANID) String() string {
	if str, ok := MikrotikWirelessVLANID_Strings[a]; ok {
		return str
	}
	return "MikrotikWirelessVLANID(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikWirelessVLANID_Add(p *radius.Packet, value MikrotikWirelessVLANID) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 26, a)
}

func MikrotikWirelessVLANID_Get(p *radius.Packet) (value MikrotikWirelessVLANID) {
	value, _ = MikrotikWirelessVLANID_Lookup(p)
	return
}

func MikrotikWirelessVLANID_Gets(p *radius.Packet) (values []MikrotikWirelessVLANID, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 26) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikWirelessVLANID(i))
	}
	return
}

func MikrotikWirelessVLANID_Lookup(p *radius.Packet) (value MikrotikWirelessVLANID, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 26)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikWirelessVLANID(i)
	return
}

func MikrotikWirelessVLANID_Set(p *radius.Packet, value MikrotikWirelessVLANID) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 26, a)
}

func MikrotikWirelessVLANID_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 26)
}

type MikrotikWirelessVLANIDtype uint32

const (
	MikrotikWirelessVLANIDtype_Value_Eight021q  MikrotikWirelessVLANIDtype = 0
	MikrotikWirelessVLANIDtype_Value_Eight021ad MikrotikWirelessVLANIDtype = 1
)

var MikrotikWirelessVLANIDtype_Strings = map[MikrotikWirelessVLANIDtype]string{
	MikrotikWirelessVLANIDtype_Value_Eight021q:  "802.1q",
	MikrotikWirelessVLANIDtype_Value_Eight021ad: "802.1ad",
}

func (a MikrotikWirelessVLANIDtype) String() string {
	if str, ok := MikrotikWirelessVLANIDtype_Strings[a]; ok {
		return str
	}
	return "MikrotikWirelessVLANIDtype(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func MikrotikWirelessVLANIDtype_Add(p *radius.Packet, value MikrotikWirelessVLANIDtype) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_AddVendor(p, 27, a)
}

func MikrotikWirelessVLANIDtype_Get(p *radius.Packet) (value MikrotikWirelessVLANIDtype) {
	value, _ = MikrotikWirelessVLANIDtype_Lookup(p)
	return
}

func MikrotikWirelessVLANIDtype_Gets(p *radius.Packet) (values []MikrotikWirelessVLANIDtype, err error) {
	var i uint32
	for _, attr := range _Mikrotik_GetsVendor(p, 27) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, MikrotikWirelessVLANIDtype(i))
	}
	return
}

func MikrotikWirelessVLANIDtype_Lookup(p *radius.Packet) (value MikrotikWirelessVLANIDtype, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 27)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = MikrotikWirelessVLANIDtype(i)
	return
}

func MikrotikWirelessVLANIDtype_Set(p *radius.Packet, value MikrotikWirelessVLANIDtype) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Mikrotik_SetVendor(p, 27, a)
}

func MikrotikWirelessVLANIDtype_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 27)
}

func MikrotikWirelessMinsignal_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 28, a)
}

func MikrotikWirelessMinsignal_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 28, a)
}

func MikrotikWirelessMinsignal_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikWirelessMinsignal_Lookup(p)
	return
}

func MikrotikWirelessMinsignal_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikWirelessMinsignal_LookupString(p)
	return
}

func MikrotikWirelessMinsignal_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 28) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessMinsignal_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 28) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessMinsignal_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 28)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikWirelessMinsignal_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 28)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikWirelessMinsignal_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 28, a)
}

func MikrotikWirelessMinsignal_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 28, a)
}

func MikrotikWirelessMinsignal_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 28)
}

func MikrotikWirelessMaxsignal_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 29, a)
}

func MikrotikWirelessMaxsignal_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 29, a)
}

func MikrotikWirelessMaxsignal_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikWirelessMaxsignal_Lookup(p)
	return
}

func MikrotikWirelessMaxsignal_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikWirelessMaxsignal_LookupString(p)
	return
}

func MikrotikWirelessMaxsignal_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 29) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessMaxsignal_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 29) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikWirelessMaxsignal_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 29)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikWirelessMaxsignal_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 29)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikWirelessMaxsignal_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 29, a)
}

func MikrotikWirelessMaxsignal_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 29, a)
}

func MikrotikWirelessMaxsignal_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 29)
}

func MikrotikSwitchingFilter_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 30, a)
}

func MikrotikSwitchingFilter_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_AddVendor(p, 30, a)
}

func MikrotikSwitchingFilter_Get(p *radius.Packet) (value []byte) {
	value, _ = MikrotikSwitchingFilter_Lookup(p)
	return
}

func MikrotikSwitchingFilter_GetString(p *radius.Packet) (value string) {
	value, _ = MikrotikSwitchingFilter_LookupString(p)
	return
}

func MikrotikSwitchingFilter_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Mikrotik_GetsVendor(p, 30) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikSwitchingFilter_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Mikrotik_GetsVendor(p, 30) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func MikrotikSwitchingFilter_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 30)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func MikrotikSwitchingFilter_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Mikrotik_LookupVendor(p, 30)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func MikrotikSwitchingFilter_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 30, a)
}

func MikrotikSwitchingFilter_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Mikrotik_SetVendor(p, 30, a)
}

func MikrotikSwitchingFilter_Del(p *radius.Packet) {
	_Mikrotik_DelVendor(p, 30)
}
