// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/scheduler/v1/cloudscheduler.proto

package schedulerpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudScheduler_ListJobs_FullMethodName  = "/google.cloud.scheduler.v1.CloudScheduler/ListJobs"
	CloudScheduler_GetJob_FullMethodName    = "/google.cloud.scheduler.v1.CloudScheduler/GetJob"
	CloudScheduler_CreateJob_FullMethodName = "/google.cloud.scheduler.v1.CloudScheduler/CreateJob"
	CloudScheduler_UpdateJob_FullMethodName = "/google.cloud.scheduler.v1.CloudScheduler/UpdateJob"
	CloudScheduler_DeleteJob_FullMethodName = "/google.cloud.scheduler.v1.CloudScheduler/DeleteJob"
	CloudScheduler_PauseJob_FullMethodName  = "/google.cloud.scheduler.v1.CloudScheduler/PauseJob"
	CloudScheduler_ResumeJob_FullMethodName = "/google.cloud.scheduler.v1.CloudScheduler/ResumeJob"
	CloudScheduler_RunJob_FullMethodName    = "/google.cloud.scheduler.v1.CloudScheduler/RunJob"
)

// CloudSchedulerClient is the client API for CloudScheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudSchedulerClient interface {
	// Lists jobs.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Gets a job.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Creates a job.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates a job.
	//
	// If successful, the updated [Job][google.cloud.scheduler.v1.Job] is
	// returned. If the job does not exist, `NOT_FOUND` is returned.
	//
	// If UpdateJob does not successfully return, it is possible for the
	// job to be in an
	// [Job.State.UPDATE_FAILED][google.cloud.scheduler.v1.Job.State.UPDATE_FAILED]
	// state. A job in this state may not be executed. If this happens, retry the
	// UpdateJob request until a successful response is received.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes a job.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Pauses a job.
	//
	// If a job is paused then the system will stop executing the job
	// until it is re-enabled via
	// [ResumeJob][google.cloud.scheduler.v1.CloudScheduler.ResumeJob]. The state
	// of the job is stored in [state][google.cloud.scheduler.v1.Job.state]; if
	// paused it will be set to
	// [Job.State.PAUSED][google.cloud.scheduler.v1.Job.State.PAUSED]. A job must
	// be in [Job.State.ENABLED][google.cloud.scheduler.v1.Job.State.ENABLED] to
	// be paused.
	PauseJob(ctx context.Context, in *PauseJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Resume a job.
	//
	// This method reenables a job after it has been
	// [Job.State.PAUSED][google.cloud.scheduler.v1.Job.State.PAUSED]. The state
	// of a job is stored in [Job.state][google.cloud.scheduler.v1.Job.state];
	// after calling this method it will be set to
	// [Job.State.ENABLED][google.cloud.scheduler.v1.Job.State.ENABLED]. A job
	// must be in [Job.State.PAUSED][google.cloud.scheduler.v1.Job.State.PAUSED]
	// to be resumed.
	ResumeJob(ctx context.Context, in *ResumeJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Forces a job to run now.
	//
	// When this method is called, Cloud Scheduler will dispatch the job, even
	// if the job is already running.
	RunJob(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*Job, error)
}

type cloudSchedulerClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudSchedulerClient(cc grpc.ClientConnInterface) CloudSchedulerClient {
	return &cloudSchedulerClient{cc}
}

func (c *cloudSchedulerClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, CloudScheduler_ListJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, CloudScheduler_GetJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, CloudScheduler_CreateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, CloudScheduler_UpdateJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, CloudScheduler_DeleteJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) PauseJob(ctx context.Context, in *PauseJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, CloudScheduler_PauseJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) ResumeJob(ctx context.Context, in *ResumeJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, CloudScheduler_ResumeJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudSchedulerClient) RunJob(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, CloudScheduler_RunJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudSchedulerServer is the server API for CloudScheduler service.
// All implementations should embed UnimplementedCloudSchedulerServer
// for forward compatibility
type CloudSchedulerServer interface {
	// Lists jobs.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Gets a job.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Creates a job.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Updates a job.
	//
	// If successful, the updated [Job][google.cloud.scheduler.v1.Job] is
	// returned. If the job does not exist, `NOT_FOUND` is returned.
	//
	// If UpdateJob does not successfully return, it is possible for the
	// job to be in an
	// [Job.State.UPDATE_FAILED][google.cloud.scheduler.v1.Job.State.UPDATE_FAILED]
	// state. A job in this state may not be executed. If this happens, retry the
	// UpdateJob request until a successful response is received.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// Deletes a job.
	DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error)
	// Pauses a job.
	//
	// If a job is paused then the system will stop executing the job
	// until it is re-enabled via
	// [ResumeJob][google.cloud.scheduler.v1.CloudScheduler.ResumeJob]. The state
	// of the job is stored in [state][google.cloud.scheduler.v1.Job.state]; if
	// paused it will be set to
	// [Job.State.PAUSED][google.cloud.scheduler.v1.Job.State.PAUSED]. A job must
	// be in [Job.State.ENABLED][google.cloud.scheduler.v1.Job.State.ENABLED] to
	// be paused.
	PauseJob(context.Context, *PauseJobRequest) (*Job, error)
	// Resume a job.
	//
	// This method reenables a job after it has been
	// [Job.State.PAUSED][google.cloud.scheduler.v1.Job.State.PAUSED]. The state
	// of a job is stored in [Job.state][google.cloud.scheduler.v1.Job.state];
	// after calling this method it will be set to
	// [Job.State.ENABLED][google.cloud.scheduler.v1.Job.State.ENABLED]. A job
	// must be in [Job.State.PAUSED][google.cloud.scheduler.v1.Job.State.PAUSED]
	// to be resumed.
	ResumeJob(context.Context, *ResumeJobRequest) (*Job, error)
	// Forces a job to run now.
	//
	// When this method is called, Cloud Scheduler will dispatch the job, even
	// if the job is already running.
	RunJob(context.Context, *RunJobRequest) (*Job, error)
}

// UnimplementedCloudSchedulerServer should be embedded to have forward compatible implementations.
type UnimplementedCloudSchedulerServer struct {
}

func (UnimplementedCloudSchedulerServer) ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (UnimplementedCloudSchedulerServer) GetJob(context.Context, *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (UnimplementedCloudSchedulerServer) CreateJob(context.Context, *CreateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateJob not implemented")
}
func (UnimplementedCloudSchedulerServer) UpdateJob(context.Context, *UpdateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}
func (UnimplementedCloudSchedulerServer) DeleteJob(context.Context, *DeleteJobRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteJob not implemented")
}
func (UnimplementedCloudSchedulerServer) PauseJob(context.Context, *PauseJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseJob not implemented")
}
func (UnimplementedCloudSchedulerServer) ResumeJob(context.Context, *ResumeJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeJob not implemented")
}
func (UnimplementedCloudSchedulerServer) RunJob(context.Context, *RunJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunJob not implemented")
}

// UnsafeCloudSchedulerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudSchedulerServer will
// result in compilation errors.
type UnsafeCloudSchedulerServer interface {
	mustEmbedUnimplementedCloudSchedulerServer()
}

func RegisterCloudSchedulerServer(s grpc.ServiceRegistrar, srv CloudSchedulerServer) {
	s.RegisterService(&CloudScheduler_ServiceDesc, srv)
}

func _CloudScheduler_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_ListJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_GetJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_CreateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_UpdateJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_DeleteJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_PauseJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).PauseJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_PauseJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).PauseJob(ctx, req.(*PauseJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_ResumeJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).ResumeJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_ResumeJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).ResumeJob(ctx, req.(*ResumeJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudScheduler_RunJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudSchedulerServer).RunJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudScheduler_RunJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudSchedulerServer).RunJob(ctx, req.(*RunJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudScheduler_ServiceDesc is the grpc.ServiceDesc for CloudScheduler service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudScheduler_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.scheduler.v1.CloudScheduler",
	HandlerType: (*CloudSchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListJobs",
			Handler:    _CloudScheduler_ListJobs_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _CloudScheduler_GetJob_Handler,
		},
		{
			MethodName: "CreateJob",
			Handler:    _CloudScheduler_CreateJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _CloudScheduler_UpdateJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _CloudScheduler_DeleteJob_Handler,
		},
		{
			MethodName: "PauseJob",
			Handler:    _CloudScheduler_PauseJob_Handler,
		},
		{
			MethodName: "ResumeJob",
			Handler:    _CloudScheduler_ResumeJob_Handler,
		},
		{
			MethodName: "RunJob",
			Handler:    _CloudScheduler_RunJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/scheduler/v1/cloudscheduler.proto",
}
