// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/speech/v2/cloud_speech.proto

package speechpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Set of states that define the lifecycle of a Recognizer.
type Recognizer_State int32

const (
	// The default value. This value is used if the state is omitted.
	Recognizer_STATE_UNSPECIFIED Recognizer_State = 0
	// The Recognizer is active and ready for use.
	Recognizer_ACTIVE Recognizer_State = 2
	// This Recognizer has been deleted.
	Recognizer_DELETED Recognizer_State = 4
)

// Enum value maps for Recognizer_State.
var (
	Recognizer_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		2: "ACTIVE",
		4: "DELETED",
	}
	Recognizer_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            2,
		"DELETED":           4,
	}
)

func (x Recognizer_State) Enum() *Recognizer_State {
	p := new(Recognizer_State)
	*p = x
	return p
}

func (x Recognizer_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Recognizer_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[0].Descriptor()
}

func (Recognizer_State) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[0]
}

func (x Recognizer_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Recognizer_State.Descriptor instead.
func (Recognizer_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{8, 0}
}

// Supported audio data encodings.
type ExplicitDecodingConfig_AudioEncoding int32

const (
	// Default value. This value is unused.
	ExplicitDecodingConfig_AUDIO_ENCODING_UNSPECIFIED ExplicitDecodingConfig_AudioEncoding = 0
	// Headerless 16-bit signed little-endian PCM samples.
	ExplicitDecodingConfig_LINEAR16 ExplicitDecodingConfig_AudioEncoding = 1
	// Headerless 8-bit companded mulaw samples.
	ExplicitDecodingConfig_MULAW ExplicitDecodingConfig_AudioEncoding = 2
	// Headerless 8-bit companded alaw samples.
	ExplicitDecodingConfig_ALAW ExplicitDecodingConfig_AudioEncoding = 3
	// AMR frames with an rfc4867.5 header.
	ExplicitDecodingConfig_AMR ExplicitDecodingConfig_AudioEncoding = 4
	// AMR-WB frames with an rfc4867.5 header.
	ExplicitDecodingConfig_AMR_WB ExplicitDecodingConfig_AudioEncoding = 5
	// FLAC frames in the "native FLAC" container format.
	ExplicitDecodingConfig_FLAC ExplicitDecodingConfig_AudioEncoding = 6
	// MPEG audio frames with optional (ignored) ID3 metadata.
	ExplicitDecodingConfig_MP3 ExplicitDecodingConfig_AudioEncoding = 7
	// Opus audio frames in an Ogg container.
	ExplicitDecodingConfig_OGG_OPUS ExplicitDecodingConfig_AudioEncoding = 8
	// Opus audio frames in a WebM container.
	ExplicitDecodingConfig_WEBM_OPUS ExplicitDecodingConfig_AudioEncoding = 9
	// AAC audio frames in an MP4 container.
	ExplicitDecodingConfig_MP4_AAC ExplicitDecodingConfig_AudioEncoding = 10
	// AAC audio frames in an M4A container.
	ExplicitDecodingConfig_M4A_AAC ExplicitDecodingConfig_AudioEncoding = 11
	// AAC audio frames in an MOV container.
	ExplicitDecodingConfig_MOV_AAC ExplicitDecodingConfig_AudioEncoding = 12
)

// Enum value maps for ExplicitDecodingConfig_AudioEncoding.
var (
	ExplicitDecodingConfig_AudioEncoding_name = map[int32]string{
		0:  "AUDIO_ENCODING_UNSPECIFIED",
		1:  "LINEAR16",
		2:  "MULAW",
		3:  "ALAW",
		4:  "AMR",
		5:  "AMR_WB",
		6:  "FLAC",
		7:  "MP3",
		8:  "OGG_OPUS",
		9:  "WEBM_OPUS",
		10: "MP4_AAC",
		11: "M4A_AAC",
		12: "MOV_AAC",
	}
	ExplicitDecodingConfig_AudioEncoding_value = map[string]int32{
		"AUDIO_ENCODING_UNSPECIFIED": 0,
		"LINEAR16":                   1,
		"MULAW":                      2,
		"ALAW":                       3,
		"AMR":                        4,
		"AMR_WB":                     5,
		"FLAC":                       6,
		"MP3":                        7,
		"OGG_OPUS":                   8,
		"WEBM_OPUS":                  9,
		"MP4_AAC":                    10,
		"M4A_AAC":                    11,
		"MOV_AAC":                    12,
	}
)

func (x ExplicitDecodingConfig_AudioEncoding) Enum() *ExplicitDecodingConfig_AudioEncoding {
	p := new(ExplicitDecodingConfig_AudioEncoding)
	*p = x
	return p
}

func (x ExplicitDecodingConfig_AudioEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExplicitDecodingConfig_AudioEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[1].Descriptor()
}

func (ExplicitDecodingConfig_AudioEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[1]
}

func (x ExplicitDecodingConfig_AudioEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExplicitDecodingConfig_AudioEncoding.Descriptor instead.
func (ExplicitDecodingConfig_AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{10, 0}
}

// Options for how to recognize multi-channel audio.
type RecognitionFeatures_MultiChannelMode int32

const (
	// Default value for the multi-channel mode. If the audio contains
	// multiple channels, only the first channel will be transcribed; other
	// channels will be ignored.
	RecognitionFeatures_MULTI_CHANNEL_MODE_UNSPECIFIED RecognitionFeatures_MultiChannelMode = 0
	// If selected, each channel in the provided audio is transcribed
	// independently. This cannot be selected if the selected
	// [model][google.cloud.speech.v2.Recognizer.model] is `latest_short`.
	RecognitionFeatures_SEPARATE_RECOGNITION_PER_CHANNEL RecognitionFeatures_MultiChannelMode = 1
)

// Enum value maps for RecognitionFeatures_MultiChannelMode.
var (
	RecognitionFeatures_MultiChannelMode_name = map[int32]string{
		0: "MULTI_CHANNEL_MODE_UNSPECIFIED",
		1: "SEPARATE_RECOGNITION_PER_CHANNEL",
	}
	RecognitionFeatures_MultiChannelMode_value = map[string]int32{
		"MULTI_CHANNEL_MODE_UNSPECIFIED":   0,
		"SEPARATE_RECOGNITION_PER_CHANNEL": 1,
	}
)

func (x RecognitionFeatures_MultiChannelMode) Enum() *RecognitionFeatures_MultiChannelMode {
	p := new(RecognitionFeatures_MultiChannelMode)
	*p = x
	return p
}

func (x RecognitionFeatures_MultiChannelMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RecognitionFeatures_MultiChannelMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[2].Descriptor()
}

func (RecognitionFeatures_MultiChannelMode) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[2]
}

func (x RecognitionFeatures_MultiChannelMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RecognitionFeatures_MultiChannelMode.Descriptor instead.
func (RecognitionFeatures_MultiChannelMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{12, 0}
}

// Possible processing strategies for batch requests.
type BatchRecognizeRequest_ProcessingStrategy int32

const (
	// Default value for the processing strategy. The request is processed as
	// soon as its received.
	BatchRecognizeRequest_PROCESSING_STRATEGY_UNSPECIFIED BatchRecognizeRequest_ProcessingStrategy = 0
	// If selected, processes the request during lower utilization periods for a
	// price discount. The request is fulfilled within 24 hours.
	BatchRecognizeRequest_DYNAMIC_BATCHING BatchRecognizeRequest_ProcessingStrategy = 1
)

// Enum value maps for BatchRecognizeRequest_ProcessingStrategy.
var (
	BatchRecognizeRequest_ProcessingStrategy_name = map[int32]string{
		0: "PROCESSING_STRATEGY_UNSPECIFIED",
		1: "DYNAMIC_BATCHING",
	}
	BatchRecognizeRequest_ProcessingStrategy_value = map[string]int32{
		"PROCESSING_STRATEGY_UNSPECIFIED": 0,
		"DYNAMIC_BATCHING":                1,
	}
)

func (x BatchRecognizeRequest_ProcessingStrategy) Enum() *BatchRecognizeRequest_ProcessingStrategy {
	p := new(BatchRecognizeRequest_ProcessingStrategy)
	*p = x
	return p
}

func (x BatchRecognizeRequest_ProcessingStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BatchRecognizeRequest_ProcessingStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[3].Descriptor()
}

func (BatchRecognizeRequest_ProcessingStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[3]
}

func (x BatchRecognizeRequest_ProcessingStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BatchRecognizeRequest_ProcessingStrategy.Descriptor instead.
func (BatchRecognizeRequest_ProcessingStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{27, 0}
}

// Indicates the type of speech event.
type StreamingRecognizeResponse_SpeechEventType int32

const (
	// No speech event specified.
	StreamingRecognizeResponse_SPEECH_EVENT_TYPE_UNSPECIFIED StreamingRecognizeResponse_SpeechEventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio and will close the gRPC bidirectional
	// stream. This event is only sent if there was a force cutoff due to
	// silence being detected early. This event is only available through the
	// `latest_short` [model][google.cloud.speech.v2.Recognizer.model].
	StreamingRecognizeResponse_END_OF_SINGLE_UTTERANCE StreamingRecognizeResponse_SpeechEventType = 1
	// This event indicates that the server has detected the beginning of human
	// voice activity in the stream. This event can be returned multiple times
	// if speech starts and stops repeatedly throughout the stream. This event
	// is only sent if `voice_activity_events` is set to true.
	StreamingRecognizeResponse_SPEECH_ACTIVITY_BEGIN StreamingRecognizeResponse_SpeechEventType = 2
	// This event indicates that the server has detected the end of human voice
	// activity in the stream. This event can be returned multiple times if
	// speech starts and stops repeatedly throughout the stream. This event is
	// only sent if `voice_activity_events` is set to true.
	StreamingRecognizeResponse_SPEECH_ACTIVITY_END StreamingRecognizeResponse_SpeechEventType = 3
)

// Enum value maps for StreamingRecognizeResponse_SpeechEventType.
var (
	StreamingRecognizeResponse_SpeechEventType_name = map[int32]string{
		0: "SPEECH_EVENT_TYPE_UNSPECIFIED",
		1: "END_OF_SINGLE_UTTERANCE",
		2: "SPEECH_ACTIVITY_BEGIN",
		3: "SPEECH_ACTIVITY_END",
	}
	StreamingRecognizeResponse_SpeechEventType_value = map[string]int32{
		"SPEECH_EVENT_TYPE_UNSPECIFIED": 0,
		"END_OF_SINGLE_UTTERANCE":       1,
		"SPEECH_ACTIVITY_BEGIN":         2,
		"SPEECH_ACTIVITY_END":           3,
	}
)

func (x StreamingRecognizeResponse_SpeechEventType) Enum() *StreamingRecognizeResponse_SpeechEventType {
	p := new(StreamingRecognizeResponse_SpeechEventType)
	*p = x
	return p
}

func (x StreamingRecognizeResponse_SpeechEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamingRecognizeResponse_SpeechEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[4].Descriptor()
}

func (StreamingRecognizeResponse_SpeechEventType) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[4]
}

func (x StreamingRecognizeResponse_SpeechEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamingRecognizeResponse_SpeechEventType.Descriptor instead.
func (StreamingRecognizeResponse_SpeechEventType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{44, 0}
}

// Set of states that define the lifecycle of a CustomClass.
type CustomClass_State int32

const (
	// Unspecified state.  This is only used/useful for distinguishing
	// unset values.
	CustomClass_STATE_UNSPECIFIED CustomClass_State = 0
	// The normal and active state.
	CustomClass_ACTIVE CustomClass_State = 2
	// This CustomClass has been deleted.
	CustomClass_DELETED CustomClass_State = 4
)

// Enum value maps for CustomClass_State.
var (
	CustomClass_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		2: "ACTIVE",
		4: "DELETED",
	}
	CustomClass_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            2,
		"DELETED":           4,
	}
)

func (x CustomClass_State) Enum() *CustomClass_State {
	p := new(CustomClass_State)
	*p = x
	return p
}

func (x CustomClass_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomClass_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[5].Descriptor()
}

func (CustomClass_State) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[5]
}

func (x CustomClass_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomClass_State.Descriptor instead.
func (CustomClass_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{48, 0}
}

// Set of states that define the lifecycle of a PhraseSet.
type PhraseSet_State int32

const (
	// Unspecified state.  This is only used/useful for distinguishing
	// unset values.
	PhraseSet_STATE_UNSPECIFIED PhraseSet_State = 0
	// The normal and active state.
	PhraseSet_ACTIVE PhraseSet_State = 2
	// This PhraseSet has been deleted.
	PhraseSet_DELETED PhraseSet_State = 4
)

// Enum value maps for PhraseSet_State.
var (
	PhraseSet_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		2: "ACTIVE",
		4: "DELETED",
	}
	PhraseSet_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            2,
		"DELETED":           4,
	}
)

func (x PhraseSet_State) Enum() *PhraseSet_State {
	p := new(PhraseSet_State)
	*p = x
	return p
}

func (x PhraseSet_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PhraseSet_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[6].Descriptor()
}

func (PhraseSet_State) Type() protoreflect.EnumType {
	return &file_google_cloud_speech_v2_cloud_speech_proto_enumTypes[6]
}

func (x PhraseSet_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PhraseSet_State.Descriptor instead.
func (PhraseSet_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{49, 0}
}

// Request message for the
// [CreateRecognizer][google.cloud.speech.v2.Speech.CreateRecognizer] method.
type CreateRecognizerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Recognizer to create.
	Recognizer *Recognizer `protobuf:"bytes,1,opt,name=recognizer,proto3" json:"recognizer,omitempty"`
	// If set, validate the request and preview the Recognizer, but do not
	// actually create it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The ID to use for the Recognizer, which will become the final component of
	// the Recognizer's resource name.
	//
	// This value should be 4-63 characters, and valid characters
	// are /[a-z][0-9]-/.
	RecognizerId string `protobuf:"bytes,3,opt,name=recognizer_id,json=recognizerId,proto3" json:"recognizer_id,omitempty"`
	// Required. The project and location where this Recognizer will be created.
	// The expected format is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateRecognizerRequest) Reset() {
	*x = CreateRecognizerRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRecognizerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRecognizerRequest) ProtoMessage() {}

func (x *CreateRecognizerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRecognizerRequest.ProtoReflect.Descriptor instead.
func (*CreateRecognizerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRecognizerRequest) GetRecognizer() *Recognizer {
	if x != nil {
		return x.Recognizer
	}
	return nil
}

func (x *CreateRecognizerRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *CreateRecognizerRequest) GetRecognizerId() string {
	if x != nil {
		return x.RecognizerId
	}
	return ""
}

func (x *CreateRecognizerRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Represents the metadata of a long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The resource path for the target of the operation.
	Resource string `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// The method that triggered the operation.
	Method string `protobuf:"bytes,4,opt,name=method,proto3" json:"method,omitempty"`
	// The [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
	// the content of the Operation is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,6,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// The [KMS key version
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
	// with which content of the Operation is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
	KmsKeyVersionName string `protobuf:"bytes,7,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
	// The request that spawned the Operation.
	//
	// Types that are assignable to Request:
	//
	//	*OperationMetadata_BatchRecognizeRequest
	//	*OperationMetadata_CreateRecognizerRequest
	//	*OperationMetadata_UpdateRecognizerRequest
	//	*OperationMetadata_DeleteRecognizerRequest
	//	*OperationMetadata_UndeleteRecognizerRequest
	//	*OperationMetadata_CreateCustomClassRequest
	//	*OperationMetadata_UpdateCustomClassRequest
	//	*OperationMetadata_DeleteCustomClassRequest
	//	*OperationMetadata_UndeleteCustomClassRequest
	//	*OperationMetadata_CreatePhraseSetRequest
	//	*OperationMetadata_UpdatePhraseSetRequest
	//	*OperationMetadata_DeletePhraseSetRequest
	//	*OperationMetadata_UndeletePhraseSetRequest
	//	*OperationMetadata_UpdateConfigRequest
	Request isOperationMetadata_Request `protobuf_oneof:"request"`
	// The percent progress of the Operation. Values can range from 0-100. If the
	// value is 100, then the operation is finished.
	ProgressPercent int32 `protobuf:"varint,22,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Specific metadata per RPC.
	//
	// Types that are assignable to Metadata:
	//
	//	*OperationMetadata_BatchRecognizeMetadata
	Metadata isOperationMetadata_Metadata `protobuf_oneof:"metadata"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{1}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *OperationMetadata) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *OperationMetadata) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *OperationMetadata) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *OperationMetadata) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

func (m *OperationMetadata) GetRequest() isOperationMetadata_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *OperationMetadata) GetBatchRecognizeRequest() *BatchRecognizeRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_BatchRecognizeRequest); ok {
		return x.BatchRecognizeRequest
	}
	return nil
}

func (x *OperationMetadata) GetCreateRecognizerRequest() *CreateRecognizerRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_CreateRecognizerRequest); ok {
		return x.CreateRecognizerRequest
	}
	return nil
}

func (x *OperationMetadata) GetUpdateRecognizerRequest() *UpdateRecognizerRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UpdateRecognizerRequest); ok {
		return x.UpdateRecognizerRequest
	}
	return nil
}

func (x *OperationMetadata) GetDeleteRecognizerRequest() *DeleteRecognizerRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_DeleteRecognizerRequest); ok {
		return x.DeleteRecognizerRequest
	}
	return nil
}

func (x *OperationMetadata) GetUndeleteRecognizerRequest() *UndeleteRecognizerRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UndeleteRecognizerRequest); ok {
		return x.UndeleteRecognizerRequest
	}
	return nil
}

func (x *OperationMetadata) GetCreateCustomClassRequest() *CreateCustomClassRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_CreateCustomClassRequest); ok {
		return x.CreateCustomClassRequest
	}
	return nil
}

func (x *OperationMetadata) GetUpdateCustomClassRequest() *UpdateCustomClassRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UpdateCustomClassRequest); ok {
		return x.UpdateCustomClassRequest
	}
	return nil
}

func (x *OperationMetadata) GetDeleteCustomClassRequest() *DeleteCustomClassRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_DeleteCustomClassRequest); ok {
		return x.DeleteCustomClassRequest
	}
	return nil
}

func (x *OperationMetadata) GetUndeleteCustomClassRequest() *UndeleteCustomClassRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UndeleteCustomClassRequest); ok {
		return x.UndeleteCustomClassRequest
	}
	return nil
}

func (x *OperationMetadata) GetCreatePhraseSetRequest() *CreatePhraseSetRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_CreatePhraseSetRequest); ok {
		return x.CreatePhraseSetRequest
	}
	return nil
}

func (x *OperationMetadata) GetUpdatePhraseSetRequest() *UpdatePhraseSetRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UpdatePhraseSetRequest); ok {
		return x.UpdatePhraseSetRequest
	}
	return nil
}

func (x *OperationMetadata) GetDeletePhraseSetRequest() *DeletePhraseSetRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_DeletePhraseSetRequest); ok {
		return x.DeletePhraseSetRequest
	}
	return nil
}

func (x *OperationMetadata) GetUndeletePhraseSetRequest() *UndeletePhraseSetRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UndeletePhraseSetRequest); ok {
		return x.UndeletePhraseSetRequest
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
func (x *OperationMetadata) GetUpdateConfigRequest() *UpdateConfigRequest {
	if x, ok := x.GetRequest().(*OperationMetadata_UpdateConfigRequest); ok {
		return x.UpdateConfigRequest
	}
	return nil
}

func (x *OperationMetadata) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (m *OperationMetadata) GetMetadata() isOperationMetadata_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *OperationMetadata) GetBatchRecognizeMetadata() *BatchRecognizeMetadata {
	if x, ok := x.GetMetadata().(*OperationMetadata_BatchRecognizeMetadata); ok {
		return x.BatchRecognizeMetadata
	}
	return nil
}

type isOperationMetadata_Request interface {
	isOperationMetadata_Request()
}

type OperationMetadata_BatchRecognizeRequest struct {
	// The BatchRecognizeRequest that spawned the Operation.
	BatchRecognizeRequest *BatchRecognizeRequest `protobuf:"bytes,8,opt,name=batch_recognize_request,json=batchRecognizeRequest,proto3,oneof"`
}

type OperationMetadata_CreateRecognizerRequest struct {
	// The CreateRecognizerRequest that spawned the Operation.
	CreateRecognizerRequest *CreateRecognizerRequest `protobuf:"bytes,9,opt,name=create_recognizer_request,json=createRecognizerRequest,proto3,oneof"`
}

type OperationMetadata_UpdateRecognizerRequest struct {
	// The UpdateRecognizerRequest that spawned the Operation.
	UpdateRecognizerRequest *UpdateRecognizerRequest `protobuf:"bytes,10,opt,name=update_recognizer_request,json=updateRecognizerRequest,proto3,oneof"`
}

type OperationMetadata_DeleteRecognizerRequest struct {
	// The DeleteRecognizerRequest that spawned the Operation.
	DeleteRecognizerRequest *DeleteRecognizerRequest `protobuf:"bytes,11,opt,name=delete_recognizer_request,json=deleteRecognizerRequest,proto3,oneof"`
}

type OperationMetadata_UndeleteRecognizerRequest struct {
	// The UndeleteRecognizerRequest that spawned the Operation.
	UndeleteRecognizerRequest *UndeleteRecognizerRequest `protobuf:"bytes,12,opt,name=undelete_recognizer_request,json=undeleteRecognizerRequest,proto3,oneof"`
}

type OperationMetadata_CreateCustomClassRequest struct {
	// The CreateCustomClassRequest that spawned the Operation.
	CreateCustomClassRequest *CreateCustomClassRequest `protobuf:"bytes,13,opt,name=create_custom_class_request,json=createCustomClassRequest,proto3,oneof"`
}

type OperationMetadata_UpdateCustomClassRequest struct {
	// The UpdateCustomClassRequest that spawned the Operation.
	UpdateCustomClassRequest *UpdateCustomClassRequest `protobuf:"bytes,14,opt,name=update_custom_class_request,json=updateCustomClassRequest,proto3,oneof"`
}

type OperationMetadata_DeleteCustomClassRequest struct {
	// The DeleteCustomClassRequest that spawned the Operation.
	DeleteCustomClassRequest *DeleteCustomClassRequest `protobuf:"bytes,15,opt,name=delete_custom_class_request,json=deleteCustomClassRequest,proto3,oneof"`
}

type OperationMetadata_UndeleteCustomClassRequest struct {
	// The UndeleteCustomClassRequest that spawned the Operation.
	UndeleteCustomClassRequest *UndeleteCustomClassRequest `protobuf:"bytes,16,opt,name=undelete_custom_class_request,json=undeleteCustomClassRequest,proto3,oneof"`
}

type OperationMetadata_CreatePhraseSetRequest struct {
	// The CreatePhraseSetRequest that spawned the Operation.
	CreatePhraseSetRequest *CreatePhraseSetRequest `protobuf:"bytes,17,opt,name=create_phrase_set_request,json=createPhraseSetRequest,proto3,oneof"`
}

type OperationMetadata_UpdatePhraseSetRequest struct {
	// The UpdatePhraseSetRequest that spawned the Operation.
	UpdatePhraseSetRequest *UpdatePhraseSetRequest `protobuf:"bytes,18,opt,name=update_phrase_set_request,json=updatePhraseSetRequest,proto3,oneof"`
}

type OperationMetadata_DeletePhraseSetRequest struct {
	// The DeletePhraseSetRequest that spawned the Operation.
	DeletePhraseSetRequest *DeletePhraseSetRequest `protobuf:"bytes,19,opt,name=delete_phrase_set_request,json=deletePhraseSetRequest,proto3,oneof"`
}

type OperationMetadata_UndeletePhraseSetRequest struct {
	// The UndeletePhraseSetRequest that spawned the Operation.
	UndeletePhraseSetRequest *UndeletePhraseSetRequest `protobuf:"bytes,20,opt,name=undelete_phrase_set_request,json=undeletePhraseSetRequest,proto3,oneof"`
}

type OperationMetadata_UpdateConfigRequest struct {
	// The UpdateConfigRequest that spawned the Operation.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
	UpdateConfigRequest *UpdateConfigRequest `protobuf:"bytes,21,opt,name=update_config_request,json=updateConfigRequest,proto3,oneof"`
}

func (*OperationMetadata_BatchRecognizeRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_CreateRecognizerRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UpdateRecognizerRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_DeleteRecognizerRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UndeleteRecognizerRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_CreateCustomClassRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UpdateCustomClassRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_DeleteCustomClassRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UndeleteCustomClassRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_CreatePhraseSetRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UpdatePhraseSetRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_DeletePhraseSetRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UndeletePhraseSetRequest) isOperationMetadata_Request() {}

func (*OperationMetadata_UpdateConfigRequest) isOperationMetadata_Request() {}

type isOperationMetadata_Metadata interface {
	isOperationMetadata_Metadata()
}

type OperationMetadata_BatchRecognizeMetadata struct {
	// Metadata specific to the BatchRecognize method.
	BatchRecognizeMetadata *BatchRecognizeMetadata `protobuf:"bytes,23,opt,name=batch_recognize_metadata,json=batchRecognizeMetadata,proto3,oneof"`
}

func (*OperationMetadata_BatchRecognizeMetadata) isOperationMetadata_Metadata() {}

// Request message for the
// [ListRecognizers][google.cloud.speech.v2.Speech.ListRecognizers] method.
type ListRecognizersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location of Recognizers to list. The expected
	// format is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Recognizers to return. The service may return fewer
	// than this value. If unspecified, at most 5 Recognizers will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [ListRecognizers][google.cloud.speech.v2.Speech.ListRecognizers] call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [ListRecognizers][google.cloud.speech.v2.Speech.ListRecognizers] must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether, or not, to show resources that have been deleted.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListRecognizersRequest) Reset() {
	*x = ListRecognizersRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRecognizersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRecognizersRequest) ProtoMessage() {}

func (x *ListRecognizersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRecognizersRequest.ProtoReflect.Descriptor instead.
func (*ListRecognizersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{2}
}

func (x *ListRecognizersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRecognizersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRecognizersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRecognizersRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for the
// [ListRecognizers][google.cloud.speech.v2.Speech.ListRecognizers] method.
type ListRecognizersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested Recognizers.
	Recognizers []*Recognizer `protobuf:"bytes,1,rep,name=recognizers,proto3" json:"recognizers,omitempty"`
	// A token, which can be sent as
	// [page_token][google.cloud.speech.v2.ListRecognizersRequest.page_token] to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages. This token expires after 72 hours.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRecognizersResponse) Reset() {
	*x = ListRecognizersResponse{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRecognizersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRecognizersResponse) ProtoMessage() {}

func (x *ListRecognizersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRecognizersResponse.ProtoReflect.Descriptor instead.
func (*ListRecognizersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{3}
}

func (x *ListRecognizersResponse) GetRecognizers() []*Recognizer {
	if x != nil {
		return x.Recognizers
	}
	return nil
}

func (x *ListRecognizersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the
// [GetRecognizer][google.cloud.speech.v2.Speech.GetRecognizer] method.
type GetRecognizerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Recognizer to retrieve. The expected format is
	// `projects/{project}/locations/{location}/recognizers/{recognizer}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRecognizerRequest) Reset() {
	*x = GetRecognizerRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRecognizerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRecognizerRequest) ProtoMessage() {}

func (x *GetRecognizerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRecognizerRequest.ProtoReflect.Descriptor instead.
func (*GetRecognizerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{4}
}

func (x *GetRecognizerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the
// [UpdateRecognizer][google.cloud.speech.v2.Speech.UpdateRecognizer] method.
type UpdateRecognizerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Recognizer to update.
	//
	// The Recognizer's `name` field is used to identify the Recognizer to update.
	// Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
	Recognizer *Recognizer `protobuf:"bytes,1,opt,name=recognizer,proto3" json:"recognizer,omitempty"`
	// The list of fields to update. If empty, all non-default valued fields are
	// considered for update. Use `*` to update the entire Recognizer resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set, validate the request and preview the updated Recognizer, but do not
	// actually update it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateRecognizerRequest) Reset() {
	*x = UpdateRecognizerRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRecognizerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRecognizerRequest) ProtoMessage() {}

func (x *UpdateRecognizerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRecognizerRequest.ProtoReflect.Descriptor instead.
func (*UpdateRecognizerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateRecognizerRequest) GetRecognizer() *Recognizer {
	if x != nil {
		return x.Recognizer
	}
	return nil
}

func (x *UpdateRecognizerRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateRecognizerRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for the
// [DeleteRecognizer][google.cloud.speech.v2.Speech.DeleteRecognizer] method.
type DeleteRecognizerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Recognizer to delete.
	// Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the deleted Recognizer, but do not
	// actually delete it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the Recognizer is not found, the request will succeed
	// and  be a no-op (no Operation is recorded in this case).
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields. This may be sent on update, undelete, and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteRecognizerRequest) Reset() {
	*x = DeleteRecognizerRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRecognizerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRecognizerRequest) ProtoMessage() {}

func (x *DeleteRecognizerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRecognizerRequest.ProtoReflect.Descriptor instead.
func (*DeleteRecognizerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteRecognizerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRecognizerRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteRecognizerRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteRecognizerRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for the
// [UndeleteRecognizer][google.cloud.speech.v2.Speech.UndeleteRecognizer]
// method.
type UndeleteRecognizerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Recognizer to undelete.
	// Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the undeleted Recognizer, but do
	// not actually undelete it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields. This may be sent on update, undelete, and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *UndeleteRecognizerRequest) Reset() {
	*x = UndeleteRecognizerRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeleteRecognizerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteRecognizerRequest) ProtoMessage() {}

func (x *UndeleteRecognizerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteRecognizerRequest.ProtoReflect.Descriptor instead.
func (*UndeleteRecognizerRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{7}
}

func (x *UndeleteRecognizerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeleteRecognizerRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UndeleteRecognizerRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A Recognizer message. Stores recognition configuration and metadata.
type Recognizer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the Recognizer.
	// Format: `projects/{project}/locations/{location}/recognizers/{recognizer}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System-assigned unique identifier for the Recognizer.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// User-settable, human-readable name for the Recognizer. Must be 63
	// characters or less.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. This field is now deprecated. Prefer the
	// [`model`][google.cloud.speech.v2.RecognitionConfig.model] field in the
	// [`RecognitionConfig`][google.cloud.speech.v2.RecognitionConfig] message.
	//
	// Which model to use for recognition requests. Select the model best suited
	// to your domain to get best results.
	//
	// Guidance for choosing which model to use can be found in the [Transcription
	// Models
	// Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
	// and the models supported in each region can be found in the [Table Of
	// Supported
	// Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
	Model string `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. This field is now deprecated. Prefer the
	// [`language_codes`][google.cloud.speech.v2.RecognitionConfig.language_codes]
	// field in the
	// [`RecognitionConfig`][google.cloud.speech.v2.RecognitionConfig] message.
	//
	// The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	//
	// Supported languages for each model are listed in the [Table of Supported
	// Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
	//
	// If additional languages are provided, recognition result will contain
	// recognition in the most likely language detected. The recognition result
	// will include the language tag of the language detected in the audio.
	// When you create or update a Recognizer, these values are
	// stored in normalized BCP-47 form. For example, "en-us" is stored as
	// "en-US".
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
	LanguageCodes []string `protobuf:"bytes,17,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Default configuration to use for requests with this Recognizer.
	// This can be overwritten by inline configuration in the
	// [RecognizeRequest.config][google.cloud.speech.v2.RecognizeRequest.config]
	// field.
	DefaultRecognitionConfig *RecognitionConfig `protobuf:"bytes,6,opt,name=default_recognition_config,json=defaultRecognitionConfig,proto3" json:"default_recognition_config,omitempty"`
	// Allows users to store small amounts of arbitrary data.
	// Both the key and the value must be 63 characters or less each.
	// At most 100 annotations.
	Annotations map[string]string `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The Recognizer lifecycle state.
	State Recognizer_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.speech.v2.Recognizer_State" json:"state,omitempty"`
	// Output only. Creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time this Recognizer was modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time at which this Recognizer was requested for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which this Recognizer will be purged.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields. This may be sent on update, undelete, and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Whether or not this Recognizer is in the process of being
	// updated.
	Reconciling bool `protobuf:"varint,13,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
	// the Recognizer is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,15,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The [KMS key version
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
	// with which the Recognizer is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
	KmsKeyVersionName string `protobuf:"bytes,16,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
}

func (x *Recognizer) Reset() {
	*x = Recognizer{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Recognizer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Recognizer) ProtoMessage() {}

func (x *Recognizer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Recognizer.ProtoReflect.Descriptor instead.
func (*Recognizer) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{8}
}

func (x *Recognizer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Recognizer) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Recognizer) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
func (x *Recognizer) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
func (x *Recognizer) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

func (x *Recognizer) GetDefaultRecognitionConfig() *RecognitionConfig {
	if x != nil {
		return x.DefaultRecognitionConfig
	}
	return nil
}

func (x *Recognizer) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Recognizer) GetState() Recognizer_State {
	if x != nil {
		return x.State
	}
	return Recognizer_STATE_UNSPECIFIED
}

func (x *Recognizer) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Recognizer) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Recognizer) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Recognizer) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Recognizer) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Recognizer) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Recognizer) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Recognizer) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

// Automatically detected decoding parameters.
// Supported for the following encodings:
//
// * WAV_LINEAR16: 16-bit signed little-endian PCM samples in a WAV container.
//
// * WAV_MULAW: 8-bit companded mulaw samples in a WAV container.
//
// * WAV_ALAW: 8-bit companded alaw samples in a WAV container.
//
// * RFC4867_5_AMR: AMR frames with an rfc4867.5 header.
//
// * RFC4867_5_AMRWB: AMR-WB frames with an rfc4867.5 header.
//
// * FLAC: FLAC frames in the "native FLAC" container format.
//
// * MP3: MPEG audio frames with optional (ignored) ID3 metadata.
//
// * OGG_OPUS: Opus audio frames in an Ogg container.
//
// * WEBM_OPUS: Opus audio frames in a WebM container.
//
// * MP4_AAC: AAC audio frames in an MP4 container.
//
// * M4A_AAC: AAC audio frames in an M4A container.
//
// * MOV_AAC: AAC audio frames in an MOV container.
type AutoDetectDecodingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AutoDetectDecodingConfig) Reset() {
	*x = AutoDetectDecodingConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoDetectDecodingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoDetectDecodingConfig) ProtoMessage() {}

func (x *AutoDetectDecodingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoDetectDecodingConfig.ProtoReflect.Descriptor instead.
func (*AutoDetectDecodingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{9}
}

// Explicitly specified decoding parameters.
type ExplicitDecodingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Encoding of the audio data sent for recognition.
	Encoding ExplicitDecodingConfig_AudioEncoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.cloud.speech.v2.ExplicitDecodingConfig_AudioEncoding" json:"encoding,omitempty"`
	// Optional. Sample rate in Hertz of the audio data sent for recognition.
	// Valid values are: 8000-48000, and 16000 is optimal. For best results, set
	// the sampling rate of the audio source to 16000 Hz. If that's not possible,
	// use the native sample rate of the audio source (instead of resampling).
	// Note that this field is marked as OPTIONAL for backward compatibility
	// reasons. It is (and has always been) effectively REQUIRED.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Optional. Number of channels present in the audio data sent for
	// recognition. Note that this field is marked as OPTIONAL for backward
	// compatibility reasons. It is (and has always been) effectively REQUIRED.
	//
	// The maximum allowed value is 8.
	AudioChannelCount int32 `protobuf:"varint,3,opt,name=audio_channel_count,json=audioChannelCount,proto3" json:"audio_channel_count,omitempty"`
}

func (x *ExplicitDecodingConfig) Reset() {
	*x = ExplicitDecodingConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExplicitDecodingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitDecodingConfig) ProtoMessage() {}

func (x *ExplicitDecodingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitDecodingConfig.ProtoReflect.Descriptor instead.
func (*ExplicitDecodingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{10}
}

func (x *ExplicitDecodingConfig) GetEncoding() ExplicitDecodingConfig_AudioEncoding {
	if x != nil {
		return x.Encoding
	}
	return ExplicitDecodingConfig_AUDIO_ENCODING_UNSPECIFIED
}

func (x *ExplicitDecodingConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *ExplicitDecodingConfig) GetAudioChannelCount() int32 {
	if x != nil {
		return x.AudioChannelCount
	}
	return 0
}

// Configuration to enable speaker diarization.
type SpeakerDiarizationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Minimum number of speakers in the conversation. This range gives
	// you more flexibility by allowing the system to automatically determine the
	// correct number of speakers.
	//
	// To fix the number of speakers detected in the audio, set
	// `min_speaker_count` = `max_speaker_count`.
	MinSpeakerCount int32 `protobuf:"varint,2,opt,name=min_speaker_count,json=minSpeakerCount,proto3" json:"min_speaker_count,omitempty"`
	// Required. Maximum number of speakers in the conversation. Valid values are:
	// 1-6. Must be >= `min_speaker_count`. This range gives you more flexibility
	// by allowing the system to automatically determine the correct number of
	// speakers.
	MaxSpeakerCount int32 `protobuf:"varint,3,opt,name=max_speaker_count,json=maxSpeakerCount,proto3" json:"max_speaker_count,omitempty"`
}

func (x *SpeakerDiarizationConfig) Reset() {
	*x = SpeakerDiarizationConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeakerDiarizationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeakerDiarizationConfig) ProtoMessage() {}

func (x *SpeakerDiarizationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeakerDiarizationConfig.ProtoReflect.Descriptor instead.
func (*SpeakerDiarizationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{11}
}

func (x *SpeakerDiarizationConfig) GetMinSpeakerCount() int32 {
	if x != nil {
		return x.MinSpeakerCount
	}
	return 0
}

func (x *SpeakerDiarizationConfig) GetMaxSpeakerCount() int32 {
	if x != nil {
		return x.MaxSpeakerCount
	}
	return 0
}

// Available recognition features.
type RecognitionFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set to `true`, the server will attempt to filter out profanities,
	// replacing all but the initial character in each filtered word with
	// asterisks, for instance, "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	ProfanityFilter bool `protobuf:"varint,1,opt,name=profanity_filter,json=profanityFilter,proto3" json:"profanity_filter,omitempty"`
	// If `true`, the top result includes a list of words and the start and end
	// time offsets (timestamps) for those words. If `false`, no word-level time
	// offset information is returned. The default is `false`.
	EnableWordTimeOffsets bool `protobuf:"varint,2,opt,name=enable_word_time_offsets,json=enableWordTimeOffsets,proto3" json:"enable_word_time_offsets,omitempty"`
	// If `true`, the top result includes a list of words and the confidence for
	// those words. If `false`, no word-level confidence information is returned.
	// The default is `false`.
	EnableWordConfidence bool `protobuf:"varint,3,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
	// If `true`, adds punctuation to recognition result hypotheses. This feature
	// is only available in select languages. The default `false` value does not
	// add punctuation to result hypotheses.
	EnableAutomaticPunctuation bool `protobuf:"varint,4,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// The spoken punctuation behavior for the call. If `true`, replaces spoken
	// punctuation with the corresponding symbols in the request. For example,
	// "how are you question mark" becomes "how are you?". See
	// https://cloud.google.com/speech-to-text/docs/spoken-punctuation for
	// support. If `false`, spoken punctuation is not replaced.
	EnableSpokenPunctuation bool `protobuf:"varint,14,opt,name=enable_spoken_punctuation,json=enableSpokenPunctuation,proto3" json:"enable_spoken_punctuation,omitempty"`
	// The spoken emoji behavior for the call. If `true`, adds spoken emoji
	// formatting for the request. This will replace spoken emojis with the
	// corresponding Unicode symbols in the final transcript. If `false`, spoken
	// emojis are not replaced.
	EnableSpokenEmojis bool `protobuf:"varint,15,opt,name=enable_spoken_emojis,json=enableSpokenEmojis,proto3" json:"enable_spoken_emojis,omitempty"`
	// Mode for recognizing multi-channel audio.
	MultiChannelMode RecognitionFeatures_MultiChannelMode `protobuf:"varint,17,opt,name=multi_channel_mode,json=multiChannelMode,proto3,enum=google.cloud.speech.v2.RecognitionFeatures_MultiChannelMode" json:"multi_channel_mode,omitempty"`
	// Configuration to enable speaker diarization and set additional
	// parameters to make diarization better suited for your application.
	// When this is enabled, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive STREAMING responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	// For non-streaming requests, the diarization results will be provided only
	// in the top alternative of the FINAL SpeechRecognitionResult.
	DiarizationConfig *SpeakerDiarizationConfig `protobuf:"bytes,9,opt,name=diarization_config,json=diarizationConfig,proto3" json:"diarization_config,omitempty"`
	// Maximum number of recognition hypotheses to be returned.
	// The server may return fewer than `max_alternatives`.
	// Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
	// one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,16,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
}

func (x *RecognitionFeatures) Reset() {
	*x = RecognitionFeatures{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionFeatures) ProtoMessage() {}

func (x *RecognitionFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionFeatures.ProtoReflect.Descriptor instead.
func (*RecognitionFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{12}
}

func (x *RecognitionFeatures) GetProfanityFilter() bool {
	if x != nil {
		return x.ProfanityFilter
	}
	return false
}

func (x *RecognitionFeatures) GetEnableWordTimeOffsets() bool {
	if x != nil {
		return x.EnableWordTimeOffsets
	}
	return false
}

func (x *RecognitionFeatures) GetEnableWordConfidence() bool {
	if x != nil {
		return x.EnableWordConfidence
	}
	return false
}

func (x *RecognitionFeatures) GetEnableAutomaticPunctuation() bool {
	if x != nil {
		return x.EnableAutomaticPunctuation
	}
	return false
}

func (x *RecognitionFeatures) GetEnableSpokenPunctuation() bool {
	if x != nil {
		return x.EnableSpokenPunctuation
	}
	return false
}

func (x *RecognitionFeatures) GetEnableSpokenEmojis() bool {
	if x != nil {
		return x.EnableSpokenEmojis
	}
	return false
}

func (x *RecognitionFeatures) GetMultiChannelMode() RecognitionFeatures_MultiChannelMode {
	if x != nil {
		return x.MultiChannelMode
	}
	return RecognitionFeatures_MULTI_CHANNEL_MODE_UNSPECIFIED
}

func (x *RecognitionFeatures) GetDiarizationConfig() *SpeakerDiarizationConfig {
	if x != nil {
		return x.DiarizationConfig
	}
	return nil
}

func (x *RecognitionFeatures) GetMaxAlternatives() int32 {
	if x != nil {
		return x.MaxAlternatives
	}
	return 0
}

// Transcription normalization configuration. Use transcription normalization
// to automatically replace parts of the transcript with phrases of your
// choosing. For StreamingRecognize, this normalization only applies to stable
// partial transcripts (stability > 0.8) and final transcripts.
type TranscriptNormalization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of replacement entries. We will perform replacement with one entry
	// at a time. For example, the second entry in ["cat" => "dog", "mountain cat"
	// => "mountain dog"] will never be applied because we will always process the
	// first entry before it. At most 100 entries.
	Entries []*TranscriptNormalization_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *TranscriptNormalization) Reset() {
	*x = TranscriptNormalization{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranscriptNormalization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranscriptNormalization) ProtoMessage() {}

func (x *TranscriptNormalization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranscriptNormalization.ProtoReflect.Descriptor instead.
func (*TranscriptNormalization) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{13}
}

func (x *TranscriptNormalization) GetEntries() []*TranscriptNormalization_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Translation configuration. Use to translate the given audio into text for the
// desired language.
type TranslationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The language code to translate to.
	TargetLanguage string `protobuf:"bytes,1,opt,name=target_language,json=targetLanguage,proto3" json:"target_language,omitempty"`
}

func (x *TranslationConfig) Reset() {
	*x = TranslationConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranslationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranslationConfig) ProtoMessage() {}

func (x *TranslationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranslationConfig.ProtoReflect.Descriptor instead.
func (*TranslationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{14}
}

func (x *TranslationConfig) GetTargetLanguage() string {
	if x != nil {
		return x.TargetLanguage
	}
	return ""
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results. PhraseSets can be specified as an inline resource, or a
// reference to an existing PhraseSet resource.
type SpeechAdaptation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of inline or referenced PhraseSets.
	PhraseSets []*SpeechAdaptation_AdaptationPhraseSet `protobuf:"bytes,1,rep,name=phrase_sets,json=phraseSets,proto3" json:"phrase_sets,omitempty"`
	// A list of inline CustomClasses. Existing CustomClass resources can be
	// referenced directly in a PhraseSet.
	CustomClasses []*CustomClass `protobuf:"bytes,2,rep,name=custom_classes,json=customClasses,proto3" json:"custom_classes,omitempty"`
}

func (x *SpeechAdaptation) Reset() {
	*x = SpeechAdaptation{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechAdaptation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechAdaptation) ProtoMessage() {}

func (x *SpeechAdaptation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechAdaptation.ProtoReflect.Descriptor instead.
func (*SpeechAdaptation) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{15}
}

func (x *SpeechAdaptation) GetPhraseSets() []*SpeechAdaptation_AdaptationPhraseSet {
	if x != nil {
		return x.PhraseSets
	}
	return nil
}

func (x *SpeechAdaptation) GetCustomClasses() []*CustomClass {
	if x != nil {
		return x.CustomClasses
	}
	return nil
}

// Denoiser config. May not be supported for all models and may
// have no effect.
type DenoiserConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Denoise audio before sending to the transcription model.
	DenoiseAudio bool `protobuf:"varint,1,opt,name=denoise_audio,json=denoiseAudio,proto3" json:"denoise_audio,omitempty"`
	// Signal-to-Noise Ratio (SNR) threshold for the denoiser. Here SNR means the
	// loudness of the speech signal. Audio with an SNR below this threshold,
	// meaning the speech is too quiet, will be prevented from being sent to the
	// transcription model.
	//
	// If snr_threshold=0, no filtering will be applied.
	SnrThreshold float32 `protobuf:"fixed32,2,opt,name=snr_threshold,json=snrThreshold,proto3" json:"snr_threshold,omitempty"`
}

func (x *DenoiserConfig) Reset() {
	*x = DenoiserConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DenoiserConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenoiserConfig) ProtoMessage() {}

func (x *DenoiserConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenoiserConfig.ProtoReflect.Descriptor instead.
func (*DenoiserConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{16}
}

func (x *DenoiserConfig) GetDenoiseAudio() bool {
	if x != nil {
		return x.DenoiseAudio
	}
	return false
}

func (x *DenoiserConfig) GetSnrThreshold() float32 {
	if x != nil {
		return x.SnrThreshold
	}
	return 0
}

// Provides information to the Recognizer that specifies how to process the
// recognition request.
type RecognitionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Decoding parameters for audio being sent for recognition.
	//
	// Types that are assignable to DecodingConfig:
	//
	//	*RecognitionConfig_AutoDecodingConfig
	//	*RecognitionConfig_ExplicitDecodingConfig
	DecodingConfig isRecognitionConfig_DecodingConfig `protobuf_oneof:"decoding_config"`
	// Optional. Which model to use for recognition requests. Select the model
	// best suited to your domain to get best results.
	//
	// Guidance for choosing which model to use can be found in the [Transcription
	// Models
	// Documentation](https://cloud.google.com/speech-to-text/v2/docs/transcription-model)
	// and the models supported in each region can be found in the [Table Of
	// Supported
	// Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
	Model string `protobuf:"bytes,9,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Language tags are normalized to BCP-47 before they are used eg "en-us"
	// becomes "en-US".
	//
	// Supported languages for each model are listed in the [Table of Supported
	// Models](https://cloud.google.com/speech-to-text/v2/docs/speech-to-text-supported-languages).
	//
	// If additional languages are provided, recognition result will contain
	// recognition in the most likely language detected. The recognition result
	// will include the language tag of the language detected in the audio.
	LanguageCodes []string `protobuf:"bytes,10,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Speech recognition features to enable.
	Features *RecognitionFeatures `protobuf:"bytes,2,opt,name=features,proto3" json:"features,omitempty"`
	// Speech adaptation context that weights recognizer predictions for specific
	// words and phrases.
	Adaptation *SpeechAdaptation `protobuf:"bytes,6,opt,name=adaptation,proto3" json:"adaptation,omitempty"`
	// Optional. Use transcription normalization to automatically replace parts of
	// the transcript with phrases of your choosing. For StreamingRecognize, this
	// normalization only applies to stable partial transcripts (stability > 0.8)
	// and final transcripts.
	TranscriptNormalization *TranscriptNormalization `protobuf:"bytes,11,opt,name=transcript_normalization,json=transcriptNormalization,proto3" json:"transcript_normalization,omitempty"`
	// Optional. Optional configuration used to automatically run translation on
	// the given audio to the desired language for supported models.
	TranslationConfig *TranslationConfig `protobuf:"bytes,15,opt,name=translation_config,json=translationConfig,proto3" json:"translation_config,omitempty"`
	// Optional. Optional denoiser config. May not be supported for all models
	// and may have no effect.
	DenoiserConfig *DenoiserConfig `protobuf:"bytes,16,opt,name=denoiser_config,json=denoiserConfig,proto3" json:"denoiser_config,omitempty"`
}

func (x *RecognitionConfig) Reset() {
	*x = RecognitionConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionConfig) ProtoMessage() {}

func (x *RecognitionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionConfig.ProtoReflect.Descriptor instead.
func (*RecognitionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{17}
}

func (m *RecognitionConfig) GetDecodingConfig() isRecognitionConfig_DecodingConfig {
	if m != nil {
		return m.DecodingConfig
	}
	return nil
}

func (x *RecognitionConfig) GetAutoDecodingConfig() *AutoDetectDecodingConfig {
	if x, ok := x.GetDecodingConfig().(*RecognitionConfig_AutoDecodingConfig); ok {
		return x.AutoDecodingConfig
	}
	return nil
}

func (x *RecognitionConfig) GetExplicitDecodingConfig() *ExplicitDecodingConfig {
	if x, ok := x.GetDecodingConfig().(*RecognitionConfig_ExplicitDecodingConfig); ok {
		return x.ExplicitDecodingConfig
	}
	return nil
}

func (x *RecognitionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *RecognitionConfig) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

func (x *RecognitionConfig) GetFeatures() *RecognitionFeatures {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *RecognitionConfig) GetAdaptation() *SpeechAdaptation {
	if x != nil {
		return x.Adaptation
	}
	return nil
}

func (x *RecognitionConfig) GetTranscriptNormalization() *TranscriptNormalization {
	if x != nil {
		return x.TranscriptNormalization
	}
	return nil
}

func (x *RecognitionConfig) GetTranslationConfig() *TranslationConfig {
	if x != nil {
		return x.TranslationConfig
	}
	return nil
}

func (x *RecognitionConfig) GetDenoiserConfig() *DenoiserConfig {
	if x != nil {
		return x.DenoiserConfig
	}
	return nil
}

type isRecognitionConfig_DecodingConfig interface {
	isRecognitionConfig_DecodingConfig()
}

type RecognitionConfig_AutoDecodingConfig struct {
	// Automatically detect decoding parameters.
	// Preferred for supported formats.
	AutoDecodingConfig *AutoDetectDecodingConfig `protobuf:"bytes,7,opt,name=auto_decoding_config,json=autoDecodingConfig,proto3,oneof"`
}

type RecognitionConfig_ExplicitDecodingConfig struct {
	// Explicitly specified decoding parameters.
	// Required if using headerless PCM audio (linear16, mulaw, alaw).
	ExplicitDecodingConfig *ExplicitDecodingConfig `protobuf:"bytes,8,opt,name=explicit_decoding_config,json=explicitDecodingConfig,proto3,oneof"`
}

func (*RecognitionConfig_AutoDecodingConfig) isRecognitionConfig_DecodingConfig() {}

func (*RecognitionConfig_ExplicitDecodingConfig) isRecognitionConfig_DecodingConfig() {}

// Request message for the
// [Recognize][google.cloud.speech.v2.Speech.Recognize] method. Either
// `content` or `uri` must be supplied. Supplying both or neither returns
// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See [content
// limits](https://cloud.google.com/speech-to-text/quotas#content).
type RecognizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Recognizer to use during recognition. The
	// expected format is
	// `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
	// {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
	Recognizer string `protobuf:"bytes,3,opt,name=recognizer,proto3" json:"recognizer,omitempty"`
	// Features and audio metadata to use for the Automatic Speech Recognition.
	// This field in combination with the
	// [config_mask][google.cloud.speech.v2.RecognizeRequest.config_mask] field
	// can be used to override parts of the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the Recognizer resource.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The list of fields in
	// [config][google.cloud.speech.v2.RecognizeRequest.config] that override the
	// values in the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the recognizer during this recognition request. If no mask is provided,
	// all non-default valued fields in
	// [config][google.cloud.speech.v2.RecognizeRequest.config] override the
	// values in the recognizer for this recognition request. If a mask is
	// provided, only the fields listed in the mask override the config in the
	// recognizer for this recognition request. If a wildcard (`*`) is provided,
	// [config][google.cloud.speech.v2.RecognizeRequest.config] completely
	// overrides and replaces the config in the recognizer for this recognition
	// request.
	ConfigMask *fieldmaskpb.FieldMask `protobuf:"bytes,8,opt,name=config_mask,json=configMask,proto3" json:"config_mask,omitempty"`
	// The audio source, which is either inline content or a Google Cloud
	// Storage URI.
	//
	// Types that are assignable to AudioSource:
	//
	//	*RecognizeRequest_Content
	//	*RecognizeRequest_Uri
	AudioSource isRecognizeRequest_AudioSource `protobuf_oneof:"audio_source"`
}

func (x *RecognizeRequest) Reset() {
	*x = RecognizeRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognizeRequest) ProtoMessage() {}

func (x *RecognizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognizeRequest.ProtoReflect.Descriptor instead.
func (*RecognizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{18}
}

func (x *RecognizeRequest) GetRecognizer() string {
	if x != nil {
		return x.Recognizer
	}
	return ""
}

func (x *RecognizeRequest) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *RecognizeRequest) GetConfigMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ConfigMask
	}
	return nil
}

func (m *RecognizeRequest) GetAudioSource() isRecognizeRequest_AudioSource {
	if m != nil {
		return m.AudioSource
	}
	return nil
}

func (x *RecognizeRequest) GetContent() []byte {
	if x, ok := x.GetAudioSource().(*RecognizeRequest_Content); ok {
		return x.Content
	}
	return nil
}

func (x *RecognizeRequest) GetUri() string {
	if x, ok := x.GetAudioSource().(*RecognizeRequest_Uri); ok {
		return x.Uri
	}
	return ""
}

type isRecognizeRequest_AudioSource interface {
	isRecognizeRequest_AudioSource()
}

type RecognizeRequest_Content struct {
	// The audio data bytes encoded as specified in
	// [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. As
	// with all bytes fields, proto buffers use a pure binary representation,
	// whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,5,opt,name=content,proto3,oneof"`
}

type RecognizeRequest_Uri struct {
	// URI that points to a file that contains audio data bytes as specified in
	// [RecognitionConfig][google.cloud.speech.v2.RecognitionConfig]. The file
	// must not be compressed (for example, gzip). Currently, only Google Cloud
	// Storage URIs are supported, which must be specified in the following
	// format: `gs://bucket_name/object_name` (other URI formats return
	// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more
	// information, see [Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris).
	Uri string `protobuf:"bytes,6,opt,name=uri,proto3,oneof"`
}

func (*RecognizeRequest_Content) isRecognizeRequest_AudioSource() {}

func (*RecognizeRequest_Uri) isRecognizeRequest_AudioSource() {}

// Metadata about the recognition request and response.
type RecognitionResponseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Global request identifier auto-generated by the API.
	RequestId string `protobuf:"bytes,9,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// When available, billed audio seconds for the corresponding request.
	TotalBilledDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=total_billed_duration,json=totalBilledDuration,proto3" json:"total_billed_duration,omitempty"`
}

func (x *RecognitionResponseMetadata) Reset() {
	*x = RecognitionResponseMetadata{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionResponseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionResponseMetadata) ProtoMessage() {}

func (x *RecognitionResponseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionResponseMetadata.ProtoReflect.Descriptor instead.
func (*RecognitionResponseMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{19}
}

func (x *RecognitionResponseMetadata) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *RecognitionResponseMetadata) GetTotalBilledDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalBilledDuration
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative of a non-streaming
	// result or, of a streaming result where
	// [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final] is
	// set to `true`. This field is not guaranteed to be accurate and users should
	// not rely on it to be always provided. The default of 0.0 is a sentinel
	// value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A list of word-specific information for each recognized word.
	// When the
	// [SpeakerDiarizationConfig][google.cloud.speech.v2.SpeakerDiarizationConfig]
	// is set, you will see all the words from the beginning of the audio.
	Words []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
}

func (x *SpeechRecognitionAlternative) Reset() {
	*x = SpeechRecognitionAlternative{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechRecognitionAlternative) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionAlternative) ProtoMessage() {}

func (x *SpeechRecognitionAlternative) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionAlternative.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{20}
}

func (x *SpeechRecognitionAlternative) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *SpeechRecognitionAlternative) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if x != nil {
		return x.Words
	}
	return nil
}

// Word-specific information for recognized words.
type WordInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time offset relative to the beginning of the audio,
	// and corresponding to the start of the spoken word.
	// This field is only set if
	// [enable_word_time_offsets][google.cloud.speech.v2.RecognitionFeatures.enable_word_time_offsets]
	// is `true` and only in the top hypothesis. This is an experimental feature
	// and the accuracy of the time offset can vary.
	StartOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Time offset relative to the beginning of the audio,
	// and corresponding to the end of the spoken word.
	// This field is only set if
	// [enable_word_time_offsets][google.cloud.speech.v2.RecognitionFeatures.enable_word_time_offsets]
	// is `true` and only in the top hypothesis. This is an experimental feature
	// and the accuracy of the time offset can vary.
	EndOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative of a non-streaming
	// result or, of a streaming result where
	// [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final] is
	// set to `true`. This field is not guaranteed to be accurate and users should
	// not rely on it to be always provided. The default of 0.0 is a sentinel
	// value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A distinct label is assigned for every speaker within the audio. This field
	// specifies which one of those speakers was detected to have spoken this
	// word. `speaker_label` is set if
	// [SpeakerDiarizationConfig][google.cloud.speech.v2.SpeakerDiarizationConfig]
	// is given and only in the top alternative.
	SpeakerLabel string `protobuf:"bytes,6,opt,name=speaker_label,json=speakerLabel,proto3" json:"speaker_label,omitempty"`
}

func (x *WordInfo) Reset() {
	*x = WordInfo{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WordInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordInfo) ProtoMessage() {}

func (x *WordInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordInfo.ProtoReflect.Descriptor instead.
func (*WordInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{21}
}

func (x *WordInfo) GetStartOffset() *durationpb.Duration {
	if x != nil {
		return x.StartOffset
	}
	return nil
}

func (x *WordInfo) GetEndOffset() *durationpb.Duration {
	if x != nil {
		return x.EndOffset
	}
	return nil
}

func (x *WordInfo) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

func (x *WordInfo) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *WordInfo) GetSpeakerLabel() string {
	if x != nil {
		return x.SpeakerLabel
	}
	return ""
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// May contain one or more recognition hypotheses. These alternatives are
	// ordered in terms of accuracy, with the top (first) alternative being the
	// most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// For multi-channel audio, this is the channel number corresponding to the
	// recognized result for the audio from that channel.
	// For `audio_channel_count` = `N`, its output values can range from `1` to
	// `N`.
	ChannelTag int32 `protobuf:"varint,2,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// Time offset of the end of this result relative to the beginning of the
	// audio.
	ResultEndOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=result_end_offset,json=resultEndOffset,proto3" json:"result_end_offset,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag of the language in this result. This language code was
	// detected to have the most likelihood of being spoken in the audio.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *SpeechRecognitionResult) Reset() {
	*x = SpeechRecognitionResult{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionResult) ProtoMessage() {}

func (x *SpeechRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionResult.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{22}
}

func (x *SpeechRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if x != nil {
		return x.Alternatives
	}
	return nil
}

func (x *SpeechRecognitionResult) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *SpeechRecognitionResult) GetResultEndOffset() *durationpb.Duration {
	if x != nil {
		return x.ResultEndOffset
	}
	return nil
}

func (x *SpeechRecognitionResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Response message for the
// [Recognize][google.cloud.speech.v2.Speech.Recognize] method.
type RecognizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sequential list of transcription results corresponding to sequential
	// portions of audio.
	Results []*SpeechRecognitionResult `protobuf:"bytes,3,rep,name=results,proto3" json:"results,omitempty"`
	// Metadata about the recognition.
	Metadata *RecognitionResponseMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *RecognizeResponse) Reset() {
	*x = RecognizeResponse{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognizeResponse) ProtoMessage() {}

func (x *RecognizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognizeResponse.ProtoReflect.Descriptor instead.
func (*RecognizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{23}
}

func (x *RecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *RecognizeResponse) GetMetadata() *RecognitionResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Available recognition features specific to streaming recognition requests.
type StreamingRecognitionFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If `true`, responses with voice activity speech events will be returned as
	// they are detected.
	EnableVoiceActivityEvents bool `protobuf:"varint,1,opt,name=enable_voice_activity_events,json=enableVoiceActivityEvents,proto3" json:"enable_voice_activity_events,omitempty"`
	// Whether or not to stream interim results to the client. If set to true,
	// interim results will be streamed to the client. Otherwise, only the final
	// response will be streamed back.
	InterimResults bool `protobuf:"varint,2,opt,name=interim_results,json=interimResults,proto3" json:"interim_results,omitempty"`
	// If set, the server will automatically close the stream after the specified
	// duration has elapsed after the last VOICE_ACTIVITY speech event has been
	// sent. The field `voice_activity_events` must also be set to true.
	VoiceActivityTimeout *StreamingRecognitionFeatures_VoiceActivityTimeout `protobuf:"bytes,3,opt,name=voice_activity_timeout,json=voiceActivityTimeout,proto3" json:"voice_activity_timeout,omitempty"`
}

func (x *StreamingRecognitionFeatures) Reset() {
	*x = StreamingRecognitionFeatures{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionFeatures) ProtoMessage() {}

func (x *StreamingRecognitionFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionFeatures.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{24}
}

func (x *StreamingRecognitionFeatures) GetEnableVoiceActivityEvents() bool {
	if x != nil {
		return x.EnableVoiceActivityEvents
	}
	return false
}

func (x *StreamingRecognitionFeatures) GetInterimResults() bool {
	if x != nil {
		return x.InterimResults
	}
	return false
}

func (x *StreamingRecognitionFeatures) GetVoiceActivityTimeout() *StreamingRecognitionFeatures_VoiceActivityTimeout {
	if x != nil {
		return x.VoiceActivityTimeout
	}
	return nil
}

// Provides configuration information for the StreamingRecognize request.
type StreamingRecognitionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Features and audio metadata to use for the Automatic Speech
	// Recognition. This field in combination with the
	// [config_mask][google.cloud.speech.v2.StreamingRecognitionConfig.config_mask]
	// field can be used to override parts of the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the Recognizer resource.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The list of fields in
	// [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] that
	// override the values in the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the recognizer during this recognition request. If no mask is provided,
	// all non-default valued fields in
	// [config][google.cloud.speech.v2.StreamingRecognitionConfig.config] override
	// the values in the Recognizer for this recognition request. If a mask is
	// provided, only the fields listed in the mask override the config in the
	// Recognizer for this recognition request. If a wildcard (`*`) is provided,
	// [config][google.cloud.speech.v2.StreamingRecognitionConfig.config]
	// completely overrides and replaces the config in the recognizer for this
	// recognition request.
	ConfigMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=config_mask,json=configMask,proto3" json:"config_mask,omitempty"`
	// Speech recognition features to enable specific to streaming audio
	// recognition requests.
	StreamingFeatures *StreamingRecognitionFeatures `protobuf:"bytes,2,opt,name=streaming_features,json=streamingFeatures,proto3" json:"streaming_features,omitempty"`
}

func (x *StreamingRecognitionConfig) Reset() {
	*x = StreamingRecognitionConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionConfig) ProtoMessage() {}

func (x *StreamingRecognitionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionConfig.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{25}
}

func (x *StreamingRecognitionConfig) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *StreamingRecognitionConfig) GetConfigMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ConfigMask
	}
	return nil
}

func (x *StreamingRecognitionConfig) GetStreamingFeatures() *StreamingRecognitionFeatures {
	if x != nil {
		return x.StreamingFeatures
	}
	return nil
}

// Request message for the
// [StreamingRecognize][google.cloud.speech.v2.Speech.StreamingRecognize]
// method. Multiple
// [StreamingRecognizeRequest][google.cloud.speech.v2.StreamingRecognizeRequest]
// messages are sent in one call.
//
// If the [Recognizer][google.cloud.speech.v2.Recognizer] referenced by
// [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer]
// contains a fully specified request configuration then the stream may only
// contain messages with only
// [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
//
// Otherwise the first message must contain a
// [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer] and
// a
// [streaming_config][google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config]
// message that together fully specify the request configuration and must not
// contain [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio]. All
// subsequent messages must only have
// [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] set.
type StreamingRecognizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Recognizer to use during recognition. The
	// expected format is
	// `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
	// {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
	Recognizer string `protobuf:"bytes,3,opt,name=recognizer,proto3" json:"recognizer,omitempty"`
	// Types that are assignable to StreamingRequest:
	//
	//	*StreamingRecognizeRequest_StreamingConfig
	//	*StreamingRecognizeRequest_Audio
	StreamingRequest isStreamingRecognizeRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (x *StreamingRecognizeRequest) Reset() {
	*x = StreamingRecognizeRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognizeRequest) ProtoMessage() {}

func (x *StreamingRecognizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognizeRequest.ProtoReflect.Descriptor instead.
func (*StreamingRecognizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{26}
}

func (x *StreamingRecognizeRequest) GetRecognizer() string {
	if x != nil {
		return x.Recognizer
	}
	return ""
}

func (m *StreamingRecognizeRequest) GetStreamingRequest() isStreamingRecognizeRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (x *StreamingRecognizeRequest) GetStreamingConfig() *StreamingRecognitionConfig {
	if x, ok := x.GetStreamingRequest().(*StreamingRecognizeRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (x *StreamingRecognizeRequest) GetAudio() []byte {
	if x, ok := x.GetStreamingRequest().(*StreamingRecognizeRequest_Audio); ok {
		return x.Audio
	}
	return nil
}

type isStreamingRecognizeRequest_StreamingRequest interface {
	isStreamingRecognizeRequest_StreamingRequest()
}

type StreamingRecognizeRequest_StreamingConfig struct {
	// StreamingRecognitionConfig to be used in this recognition attempt.
	// If provided, it will override the default RecognitionConfig stored in the
	// Recognizer.
	StreamingConfig *StreamingRecognitionConfig `protobuf:"bytes,6,opt,name=streaming_config,json=streamingConfig,proto3,oneof"`
}

type StreamingRecognizeRequest_Audio struct {
	// Inline audio bytes to be Recognized.
	// Maximum size for this field is 15 KB per request.
	Audio []byte `protobuf:"bytes,5,opt,name=audio,proto3,oneof"`
}

func (*StreamingRecognizeRequest_StreamingConfig) isStreamingRecognizeRequest_StreamingRequest() {}

func (*StreamingRecognizeRequest_Audio) isStreamingRecognizeRequest_StreamingRequest() {}

// Request message for the
// [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
// method.
type BatchRecognizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Recognizer to use during recognition. The
	// expected format is
	// `projects/{project}/locations/{location}/recognizers/{recognizer}`. The
	// {recognizer} segment may be set to `_` to use an empty implicit Recognizer.
	Recognizer string `protobuf:"bytes,1,opt,name=recognizer,proto3" json:"recognizer,omitempty"`
	// Features and audio metadata to use for the Automatic Speech Recognition.
	// This field in combination with the
	// [config_mask][google.cloud.speech.v2.BatchRecognizeRequest.config_mask]
	// field can be used to override parts of the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the Recognizer resource.
	Config *RecognitionConfig `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	// The list of fields in
	// [config][google.cloud.speech.v2.BatchRecognizeRequest.config] that override
	// the values in the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the recognizer during this recognition request. If no mask is provided,
	// all given fields in
	// [config][google.cloud.speech.v2.BatchRecognizeRequest.config] override the
	// values in the recognizer for this recognition request. If a mask is
	// provided, only the fields listed in the mask override the config in the
	// recognizer for this recognition request. If a wildcard (`*`) is provided,
	// [config][google.cloud.speech.v2.BatchRecognizeRequest.config] completely
	// overrides and replaces the config in the recognizer for this recognition
	// request.
	ConfigMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=config_mask,json=configMask,proto3" json:"config_mask,omitempty"`
	// Audio files with file metadata for ASR.
	// The maximum number of files allowed to be specified is 15.
	Files []*BatchRecognizeFileMetadata `protobuf:"bytes,3,rep,name=files,proto3" json:"files,omitempty"`
	// Configuration options for where to output the transcripts of each file.
	RecognitionOutputConfig *RecognitionOutputConfig `protobuf:"bytes,6,opt,name=recognition_output_config,json=recognitionOutputConfig,proto3" json:"recognition_output_config,omitempty"`
	// Processing strategy to use for this request.
	ProcessingStrategy BatchRecognizeRequest_ProcessingStrategy `protobuf:"varint,7,opt,name=processing_strategy,json=processingStrategy,proto3,enum=google.cloud.speech.v2.BatchRecognizeRequest_ProcessingStrategy" json:"processing_strategy,omitempty"`
}

func (x *BatchRecognizeRequest) Reset() {
	*x = BatchRecognizeRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeRequest) ProtoMessage() {}

func (x *BatchRecognizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeRequest.ProtoReflect.Descriptor instead.
func (*BatchRecognizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{27}
}

func (x *BatchRecognizeRequest) GetRecognizer() string {
	if x != nil {
		return x.Recognizer
	}
	return ""
}

func (x *BatchRecognizeRequest) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *BatchRecognizeRequest) GetConfigMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ConfigMask
	}
	return nil
}

func (x *BatchRecognizeRequest) GetFiles() []*BatchRecognizeFileMetadata {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *BatchRecognizeRequest) GetRecognitionOutputConfig() *RecognitionOutputConfig {
	if x != nil {
		return x.RecognitionOutputConfig
	}
	return nil
}

func (x *BatchRecognizeRequest) GetProcessingStrategy() BatchRecognizeRequest_ProcessingStrategy {
	if x != nil {
		return x.ProcessingStrategy
	}
	return BatchRecognizeRequest_PROCESSING_STRATEGY_UNSPECIFIED
}

// Output configurations for Cloud Storage.
type GcsOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage URI prefix with which recognition results will be
	// written.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *GcsOutputConfig) Reset() {
	*x = GcsOutputConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsOutputConfig) ProtoMessage() {}

func (x *GcsOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsOutputConfig.ProtoReflect.Descriptor instead.
func (*GcsOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{28}
}

func (x *GcsOutputConfig) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Output configurations for inline response.
type InlineOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InlineOutputConfig) Reset() {
	*x = InlineOutputConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InlineOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InlineOutputConfig) ProtoMessage() {}

func (x *InlineOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InlineOutputConfig.ProtoReflect.Descriptor instead.
func (*InlineOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{29}
}

// Output configurations for serialized `BatchRecognizeResults` protos.
type NativeOutputFileFormatConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *NativeOutputFileFormatConfig) Reset() {
	*x = NativeOutputFileFormatConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NativeOutputFileFormatConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NativeOutputFileFormatConfig) ProtoMessage() {}

func (x *NativeOutputFileFormatConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NativeOutputFileFormatConfig.ProtoReflect.Descriptor instead.
func (*NativeOutputFileFormatConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{30}
}

// Output configurations for [WebVTT](https://www.w3.org/TR/webvtt1/) formatted
// subtitle file.
type VttOutputFileFormatConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VttOutputFileFormatConfig) Reset() {
	*x = VttOutputFileFormatConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VttOutputFileFormatConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VttOutputFileFormatConfig) ProtoMessage() {}

func (x *VttOutputFileFormatConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VttOutputFileFormatConfig.ProtoReflect.Descriptor instead.
func (*VttOutputFileFormatConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{31}
}

// Output configurations [SubRip
// Text](https://www.matroska.org/technical/subtitles.html#srt-subtitles)
// formatted subtitle file.
type SrtOutputFileFormatConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SrtOutputFileFormatConfig) Reset() {
	*x = SrtOutputFileFormatConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SrtOutputFileFormatConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SrtOutputFileFormatConfig) ProtoMessage() {}

func (x *SrtOutputFileFormatConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SrtOutputFileFormatConfig.ProtoReflect.Descriptor instead.
func (*SrtOutputFileFormatConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{32}
}

// Configuration for the format of the results stored to `output`.
type OutputFormatConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the native output format. If this field is set or if no
	// other output format field is set, then transcripts will be written to the
	// sink in the native format.
	Native *NativeOutputFileFormatConfig `protobuf:"bytes,1,opt,name=native,proto3" json:"native,omitempty"`
	// Configuration for the VTT output format. If this field is set, then
	// transcripts will be written to the sink in the VTT format.
	Vtt *VttOutputFileFormatConfig `protobuf:"bytes,2,opt,name=vtt,proto3" json:"vtt,omitempty"`
	// Configuration for the SRT output format. If this field is set, then
	// transcripts will be written to the sink in the SRT format.
	Srt *SrtOutputFileFormatConfig `protobuf:"bytes,3,opt,name=srt,proto3" json:"srt,omitempty"`
}

func (x *OutputFormatConfig) Reset() {
	*x = OutputFormatConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputFormatConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputFormatConfig) ProtoMessage() {}

func (x *OutputFormatConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputFormatConfig.ProtoReflect.Descriptor instead.
func (*OutputFormatConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{33}
}

func (x *OutputFormatConfig) GetNative() *NativeOutputFileFormatConfig {
	if x != nil {
		return x.Native
	}
	return nil
}

func (x *OutputFormatConfig) GetVtt() *VttOutputFileFormatConfig {
	if x != nil {
		return x.Vtt
	}
	return nil
}

func (x *OutputFormatConfig) GetSrt() *SrtOutputFileFormatConfig {
	if x != nil {
		return x.Srt
	}
	return nil
}

// Configuration options for the output(s) of recognition.
type RecognitionOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Output:
	//
	//	*RecognitionOutputConfig_GcsOutputConfig
	//	*RecognitionOutputConfig_InlineResponseConfig
	Output isRecognitionOutputConfig_Output `protobuf_oneof:"output"`
	// Optional. Configuration for the format of the results stored to `output`.
	// If unspecified transcripts will be written in the `NATIVE` format only.
	OutputFormatConfig *OutputFormatConfig `protobuf:"bytes,3,opt,name=output_format_config,json=outputFormatConfig,proto3" json:"output_format_config,omitempty"`
}

func (x *RecognitionOutputConfig) Reset() {
	*x = RecognitionOutputConfig{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecognitionOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecognitionOutputConfig) ProtoMessage() {}

func (x *RecognitionOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecognitionOutputConfig.ProtoReflect.Descriptor instead.
func (*RecognitionOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{34}
}

func (m *RecognitionOutputConfig) GetOutput() isRecognitionOutputConfig_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *RecognitionOutputConfig) GetGcsOutputConfig() *GcsOutputConfig {
	if x, ok := x.GetOutput().(*RecognitionOutputConfig_GcsOutputConfig); ok {
		return x.GcsOutputConfig
	}
	return nil
}

func (x *RecognitionOutputConfig) GetInlineResponseConfig() *InlineOutputConfig {
	if x, ok := x.GetOutput().(*RecognitionOutputConfig_InlineResponseConfig); ok {
		return x.InlineResponseConfig
	}
	return nil
}

func (x *RecognitionOutputConfig) GetOutputFormatConfig() *OutputFormatConfig {
	if x != nil {
		return x.OutputFormatConfig
	}
	return nil
}

type isRecognitionOutputConfig_Output interface {
	isRecognitionOutputConfig_Output()
}

type RecognitionOutputConfig_GcsOutputConfig struct {
	// If this message is populated, recognition results are written to the
	// provided Google Cloud Storage URI.
	GcsOutputConfig *GcsOutputConfig `protobuf:"bytes,1,opt,name=gcs_output_config,json=gcsOutputConfig,proto3,oneof"`
}

type RecognitionOutputConfig_InlineResponseConfig struct {
	// If this message is populated, recognition results are provided in the
	// [BatchRecognizeResponse][google.cloud.speech.v2.BatchRecognizeResponse]
	// message of the Operation when completed. This is only supported when
	// calling [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize]
	// with just one audio file.
	InlineResponseConfig *InlineOutputConfig `protobuf:"bytes,2,opt,name=inline_response_config,json=inlineResponseConfig,proto3,oneof"`
}

func (*RecognitionOutputConfig_GcsOutputConfig) isRecognitionOutputConfig_Output() {}

func (*RecognitionOutputConfig_InlineResponseConfig) isRecognitionOutputConfig_Output() {}

// Response message for
// [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize] that is
// packaged into a longrunning [Operation][google.longrunning.Operation].
type BatchRecognizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map from filename to the final result for that file.
	Results map[string]*BatchRecognizeFileResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// When available, billed audio seconds for the corresponding request.
	TotalBilledDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=total_billed_duration,json=totalBilledDuration,proto3" json:"total_billed_duration,omitempty"`
}

func (x *BatchRecognizeResponse) Reset() {
	*x = BatchRecognizeResponse{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeResponse) ProtoMessage() {}

func (x *BatchRecognizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeResponse.ProtoReflect.Descriptor instead.
func (*BatchRecognizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{35}
}

func (x *BatchRecognizeResponse) GetResults() map[string]*BatchRecognizeFileResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *BatchRecognizeResponse) GetTotalBilledDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalBilledDuration
	}
	return nil
}

// Output type for Cloud Storage of BatchRecognize transcripts. Though this
// proto isn't returned in this API anywhere, the Cloud Storage transcripts will
// be this proto serialized and should be parsed as such.
type BatchRecognizeResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sequential list of transcription results corresponding to sequential
	// portions of audio.
	Results []*SpeechRecognitionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Metadata about the recognition.
	Metadata *RecognitionResponseMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *BatchRecognizeResults) Reset() {
	*x = BatchRecognizeResults{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeResults) ProtoMessage() {}

func (x *BatchRecognizeResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeResults.ProtoReflect.Descriptor instead.
func (*BatchRecognizeResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{36}
}

func (x *BatchRecognizeResults) GetResults() []*SpeechRecognitionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *BatchRecognizeResults) GetMetadata() *RecognitionResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Final results written to Cloud Storage.
type CloudStorageResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage URI to which recognition results were written.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The Cloud Storage URI to which recognition results were written as VTT
	// formatted captions. This is populated only when `VTT` output is requested.
	VttFormatUri string `protobuf:"bytes,2,opt,name=vtt_format_uri,json=vttFormatUri,proto3" json:"vtt_format_uri,omitempty"`
	// The Cloud Storage URI to which recognition results were written as SRT
	// formatted captions. This is populated only when `SRT` output is requested.
	SrtFormatUri string `protobuf:"bytes,3,opt,name=srt_format_uri,json=srtFormatUri,proto3" json:"srt_format_uri,omitempty"`
}

func (x *CloudStorageResult) Reset() {
	*x = CloudStorageResult{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageResult) ProtoMessage() {}

func (x *CloudStorageResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageResult.ProtoReflect.Descriptor instead.
func (*CloudStorageResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{37}
}

func (x *CloudStorageResult) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CloudStorageResult) GetVttFormatUri() string {
	if x != nil {
		return x.VttFormatUri
	}
	return ""
}

func (x *CloudStorageResult) GetSrtFormatUri() string {
	if x != nil {
		return x.SrtFormatUri
	}
	return ""
}

// Final results returned inline in the recognition response.
type InlineResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The transcript for the audio file.
	Transcript *BatchRecognizeResults `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// The transcript for the audio file as VTT formatted captions. This is
	// populated only when `VTT` output is requested.
	VttCaptions string `protobuf:"bytes,2,opt,name=vtt_captions,json=vttCaptions,proto3" json:"vtt_captions,omitempty"`
	// The transcript for the audio file as SRT formatted captions. This is
	// populated only when `SRT` output is requested.
	SrtCaptions string `protobuf:"bytes,3,opt,name=srt_captions,json=srtCaptions,proto3" json:"srt_captions,omitempty"`
}

func (x *InlineResult) Reset() {
	*x = InlineResult{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InlineResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InlineResult) ProtoMessage() {}

func (x *InlineResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InlineResult.ProtoReflect.Descriptor instead.
func (*InlineResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{38}
}

func (x *InlineResult) GetTranscript() *BatchRecognizeResults {
	if x != nil {
		return x.Transcript
	}
	return nil
}

func (x *InlineResult) GetVttCaptions() string {
	if x != nil {
		return x.VttCaptions
	}
	return ""
}

func (x *InlineResult) GetSrtCaptions() string {
	if x != nil {
		return x.SrtCaptions
	}
	return ""
}

// Final results for a single file.
type BatchRecognizeFileResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error if one was encountered.
	Error    *status.Status               `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Metadata *RecognitionResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Types that are assignable to Result:
	//
	//	*BatchRecognizeFileResult_CloudStorageResult
	//	*BatchRecognizeFileResult_InlineResult
	Result isBatchRecognizeFileResult_Result `protobuf_oneof:"result"`
	// Deprecated. Use `cloud_storage_result.native_format_uri` instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Deprecated. Use `inline_result.transcript` instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
	Transcript *BatchRecognizeResults `protobuf:"bytes,4,opt,name=transcript,proto3" json:"transcript,omitempty"`
}

func (x *BatchRecognizeFileResult) Reset() {
	*x = BatchRecognizeFileResult{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeFileResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeFileResult) ProtoMessage() {}

func (x *BatchRecognizeFileResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeFileResult.ProtoReflect.Descriptor instead.
func (*BatchRecognizeFileResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{39}
}

func (x *BatchRecognizeFileResult) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BatchRecognizeFileResult) GetMetadata() *RecognitionResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (m *BatchRecognizeFileResult) GetResult() isBatchRecognizeFileResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *BatchRecognizeFileResult) GetCloudStorageResult() *CloudStorageResult {
	if x, ok := x.GetResult().(*BatchRecognizeFileResult_CloudStorageResult); ok {
		return x.CloudStorageResult
	}
	return nil
}

func (x *BatchRecognizeFileResult) GetInlineResult() *InlineResult {
	if x, ok := x.GetResult().(*BatchRecognizeFileResult_InlineResult); ok {
		return x.InlineResult
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
func (x *BatchRecognizeFileResult) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/speech/v2/cloud_speech.proto.
func (x *BatchRecognizeFileResult) GetTranscript() *BatchRecognizeResults {
	if x != nil {
		return x.Transcript
	}
	return nil
}

type isBatchRecognizeFileResult_Result interface {
	isBatchRecognizeFileResult_Result()
}

type BatchRecognizeFileResult_CloudStorageResult struct {
	// Recognition results written to Cloud Storage. This is
	// populated only when
	// [GcsOutputConfig][google.cloud.speech.v2.GcsOutputConfig] is set in
	// the
	// [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
	CloudStorageResult *CloudStorageResult `protobuf:"bytes,5,opt,name=cloud_storage_result,json=cloudStorageResult,proto3,oneof"`
}

type BatchRecognizeFileResult_InlineResult struct {
	// Recognition results. This is populated only when
	// [InlineOutputConfig][google.cloud.speech.v2.InlineOutputConfig] is set in
	// the
	// [RecognitionOutputConfig][[google.cloud.speech.v2.RecognitionOutputConfig].
	InlineResult *InlineResult `protobuf:"bytes,6,opt,name=inline_result,json=inlineResult,proto3,oneof"`
}

func (*BatchRecognizeFileResult_CloudStorageResult) isBatchRecognizeFileResult_Result() {}

func (*BatchRecognizeFileResult_InlineResult) isBatchRecognizeFileResult_Result() {}

// Metadata about transcription for a single file (for example, progress
// percent).
type BatchRecognizeTranscriptionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How much of the file has been transcribed so far.
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Error if one was encountered.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// The Cloud Storage URI to which recognition results will be written.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *BatchRecognizeTranscriptionMetadata) Reset() {
	*x = BatchRecognizeTranscriptionMetadata{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeTranscriptionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeTranscriptionMetadata) ProtoMessage() {}

func (x *BatchRecognizeTranscriptionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeTranscriptionMetadata.ProtoReflect.Descriptor instead.
func (*BatchRecognizeTranscriptionMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{40}
}

func (x *BatchRecognizeTranscriptionMetadata) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *BatchRecognizeTranscriptionMetadata) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BatchRecognizeTranscriptionMetadata) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Operation metadata for
// [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize].
type BatchRecognizeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map from provided filename to the transcription metadata for that file.
	TranscriptionMetadata map[string]*BatchRecognizeTranscriptionMetadata `protobuf:"bytes,1,rep,name=transcription_metadata,json=transcriptionMetadata,proto3" json:"transcription_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchRecognizeMetadata) Reset() {
	*x = BatchRecognizeMetadata{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeMetadata) ProtoMessage() {}

func (x *BatchRecognizeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeMetadata.ProtoReflect.Descriptor instead.
func (*BatchRecognizeMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{41}
}

func (x *BatchRecognizeMetadata) GetTranscriptionMetadata() map[string]*BatchRecognizeTranscriptionMetadata {
	if x != nil {
		return x.TranscriptionMetadata
	}
	return nil
}

// Metadata about a single file in a batch for BatchRecognize.
type BatchRecognizeFileMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The audio source, which is a Google Cloud Storage URI.
	//
	// Types that are assignable to AudioSource:
	//
	//	*BatchRecognizeFileMetadata_Uri
	AudioSource isBatchRecognizeFileMetadata_AudioSource `protobuf_oneof:"audio_source"`
	// Features and audio metadata to use for the Automatic Speech Recognition.
	// This field in combination with the
	// [config_mask][google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask]
	// field can be used to override parts of the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the Recognizer resource as well as the
	// [config][google.cloud.speech.v2.BatchRecognizeRequest.config] at the
	// request level.
	Config *RecognitionConfig `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	// The list of fields in
	// [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] that
	// override the values in the
	// [default_recognition_config][google.cloud.speech.v2.Recognizer.default_recognition_config]
	// of the recognizer during this recognition request. If no mask is provided,
	// all non-default valued fields in
	// [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config] override
	// the values in the recognizer for this recognition request. If a mask is
	// provided, only the fields listed in the mask override the config in the
	// recognizer for this recognition request. If a wildcard (`*`) is provided,
	// [config][google.cloud.speech.v2.BatchRecognizeFileMetadata.config]
	// completely overrides and replaces the config in the recognizer for this
	// recognition request.
	ConfigMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=config_mask,json=configMask,proto3" json:"config_mask,omitempty"`
}

func (x *BatchRecognizeFileMetadata) Reset() {
	*x = BatchRecognizeFileMetadata{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchRecognizeFileMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRecognizeFileMetadata) ProtoMessage() {}

func (x *BatchRecognizeFileMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRecognizeFileMetadata.ProtoReflect.Descriptor instead.
func (*BatchRecognizeFileMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{42}
}

func (m *BatchRecognizeFileMetadata) GetAudioSource() isBatchRecognizeFileMetadata_AudioSource {
	if m != nil {
		return m.AudioSource
	}
	return nil
}

func (x *BatchRecognizeFileMetadata) GetUri() string {
	if x, ok := x.GetAudioSource().(*BatchRecognizeFileMetadata_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *BatchRecognizeFileMetadata) GetConfig() *RecognitionConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *BatchRecognizeFileMetadata) GetConfigMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ConfigMask
	}
	return nil
}

type isBatchRecognizeFileMetadata_AudioSource interface {
	isBatchRecognizeFileMetadata_AudioSource()
}

type BatchRecognizeFileMetadata_Uri struct {
	// Cloud Storage URI for the audio file.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

func (*BatchRecognizeFileMetadata_Uri) isBatchRecognizeFileMetadata_AudioSource() {}

// A streaming speech recognition result corresponding to a portion of the audio
// that is currently being processed.
type StreamingRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// May contain one or more recognition hypotheses. These alternatives are
	// ordered in terms of accuracy, with the top (first) alternative being the
	// most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// If `false`, this
	// [StreamingRecognitionResult][google.cloud.speech.v2.StreamingRecognitionResult]
	// represents an interim result that may change. If `true`, this is the final
	// time the speech service will return this particular
	// [StreamingRecognitionResult][google.cloud.speech.v2.StreamingRecognitionResult],
	// the recognizer will not return any further hypotheses for this portion of
	// the transcript and corresponding audio.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// An estimate of the likelihood that the recognizer will not change its guess
	// about this interim result. Values range from 0.0 (completely unstable)
	// to 1.0 (completely stable). This field is only provided for interim results
	// ([is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`false`).
	// The default of 0.0 is a sentinel value indicating `stability` was not set.
	Stability float32 `protobuf:"fixed32,3,opt,name=stability,proto3" json:"stability,omitempty"`
	// Time offset of the end of this result relative to the beginning of the
	// audio.
	ResultEndOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=result_end_offset,json=resultEndOffset,proto3" json:"result_end_offset,omitempty"`
	// For multi-channel audio, this is the channel number corresponding to the
	// recognized result for the audio from that channel.
	// For
	// `audio_channel_count` = `N`, its output values can range from `1` to `N`.
	ChannelTag int32 `protobuf:"varint,5,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag of the language in this result. This language code was
	// detected to have the most likelihood of being spoken in the audio.
	LanguageCode string `protobuf:"bytes,6,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *StreamingRecognitionResult) Reset() {
	*x = StreamingRecognitionResult{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionResult) ProtoMessage() {}

func (x *StreamingRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionResult.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{43}
}

func (x *StreamingRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if x != nil {
		return x.Alternatives
	}
	return nil
}

func (x *StreamingRecognitionResult) GetIsFinal() bool {
	if x != nil {
		return x.IsFinal
	}
	return false
}

func (x *StreamingRecognitionResult) GetStability() float32 {
	if x != nil {
		return x.Stability
	}
	return 0
}

func (x *StreamingRecognitionResult) GetResultEndOffset() *durationpb.Duration {
	if x != nil {
		return x.ResultEndOffset
	}
	return nil
}

func (x *StreamingRecognitionResult) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *StreamingRecognitionResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// `StreamingRecognizeResponse` is the only message returned to the client by
// `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
// messages are streamed back to the client. If there is no recognizable
// audio then no messages are streamed back to the client.
//
// Here are some examples of `StreamingRecognizeResponse`s that might
// be returned while processing audio:
//
// 1. results { alternatives { transcript: "tube" } stability: 0.01 }
//
// 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
//
//  3. results { alternatives { transcript: "to be" } stability: 0.9 }
//     results { alternatives { transcript: " or not to be" } stability: 0.01 }
//
//  4. results { alternatives { transcript: "to be or not to be"
//     confidence: 0.92 }
//     alternatives { transcript: "to bee or not to bee" }
//     is_final: true }
//
// 5. results { alternatives { transcript: " that's" } stability: 0.01 }
//
//  6. results { alternatives { transcript: " that is" } stability: 0.9 }
//     results { alternatives { transcript: " the question" } stability: 0.01 }
//
//  7. results { alternatives { transcript: " that is the question"
//     confidence: 0.98 }
//     alternatives { transcript: " that was the question" }
//     is_final: true }
//
// Notes:
//
//   - Only two of the above responses #4 and #7 contain final results; they are
//     indicated by `is_final: true`. Concatenating these together generates the
//     full transcript: "to be or not to be that is the question".
//
//   - The others contain interim `results`. #3 and #6 contain two interim
//     `results`: the first portion has a high stability and is less likely to
//     change; the second portion has a low stability and is very likely to
//     change. A UI designer might choose to show only high stability `results`.
//
//   - The specific `stability` and `confidence` values shown above are only for
//     illustrative purposes. Actual values may vary.
//
//   - In each response, only one of these fields will be set:
//     `error`,
//     `speech_event_type`, or
//     one or more (repeated) `results`.
type StreamingRecognizeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This repeated list contains zero or more results that
	// correspond to consecutive portions of the audio currently being processed.
	// It contains zero or one
	// [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`true`
	// result (the newly settled portion), followed by zero or more
	// [is_final][google.cloud.speech.v2.StreamingRecognitionResult.is_final]=`false`
	// results (the interim results).
	Results []*StreamingRecognitionResult `protobuf:"bytes,6,rep,name=results,proto3" json:"results,omitempty"`
	// Indicates the type of speech event.
	SpeechEventType StreamingRecognizeResponse_SpeechEventType `protobuf:"varint,3,opt,name=speech_event_type,json=speechEventType,proto3,enum=google.cloud.speech.v2.StreamingRecognizeResponse_SpeechEventType" json:"speech_event_type,omitempty"`
	// Time offset between the beginning of the audio and event emission.
	SpeechEventOffset *durationpb.Duration `protobuf:"bytes,7,opt,name=speech_event_offset,json=speechEventOffset,proto3" json:"speech_event_offset,omitempty"`
	// Metadata about the recognition.
	Metadata *RecognitionResponseMetadata `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *StreamingRecognizeResponse) Reset() {
	*x = StreamingRecognizeResponse{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognizeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognizeResponse) ProtoMessage() {}

func (x *StreamingRecognizeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognizeResponse.ProtoReflect.Descriptor instead.
func (*StreamingRecognizeResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{44}
}

func (x *StreamingRecognizeResponse) GetResults() []*StreamingRecognitionResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetSpeechEventType() StreamingRecognizeResponse_SpeechEventType {
	if x != nil {
		return x.SpeechEventType
	}
	return StreamingRecognizeResponse_SPEECH_EVENT_TYPE_UNSPECIFIED
}

func (x *StreamingRecognizeResponse) GetSpeechEventOffset() *durationpb.Duration {
	if x != nil {
		return x.SpeechEventOffset
	}
	return nil
}

func (x *StreamingRecognizeResponse) GetMetadata() *RecognitionResponseMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Message representing the config for the Speech-to-Text API. This includes an
// optional [KMS key](https://cloud.google.com/kms/docs/resource-hierarchy#keys)
// with which incoming data will be encrypted.
type Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The name of the config resource. There is exactly
	// one config resource per project per location. The expected format is
	// `projects/{project}/locations/{location}/config`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) that if
	// present, will be used to encrypt Speech-to-Text resources at-rest. Updating
	// this key will not encrypt existing resources using this key; only new
	// resources will be encrypted using this key. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,2,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The most recent time this resource was modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Config) Reset() {
	*x = Config{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Config) ProtoMessage() {}

func (x *Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Config.ProtoReflect.Descriptor instead.
func (*Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{45}
}

func (x *Config) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Config) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Config) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for the
// [GetConfig][google.cloud.speech.v2.Speech.GetConfig] method.
type GetConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the config to retrieve. There is exactly one config
	// resource per project per location. The expected format is
	// `projects/{project}/locations/{location}/config`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConfigRequest) Reset() {
	*x = GetConfigRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConfigRequest) ProtoMessage() {}

func (x *GetConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConfigRequest.ProtoReflect.Descriptor instead.
func (*GetConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{46}
}

func (x *GetConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the
// [UpdateConfig][google.cloud.speech.v2.Speech.UpdateConfig] method.
type UpdateConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The config to update.
	//
	// The config's `name` field is used to identify the config to be updated.
	// The expected format is `projects/{project}/locations/{location}/config`.
	Config *Config `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateConfigRequest) Reset() {
	*x = UpdateConfigRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConfigRequest) ProtoMessage() {}

func (x *UpdateConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateConfigRequest) GetConfig() *Config {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *UpdateConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// CustomClass for biasing in speech recognition. Used to define a set of words
// or phrases that represents a common concept or theme likely to appear in your
// audio, for example a list of passenger ship names.
type CustomClass struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the CustomClass.
	// Format:
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System-assigned unique identifier for the CustomClass.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. User-settable, human-readable name for the CustomClass. Must be
	// 63 characters or less.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A collection of class items.
	Items []*CustomClass_ClassItem `protobuf:"bytes,5,rep,name=items,proto3" json:"items,omitempty"`
	// Output only. The CustomClass lifecycle state.
	State CustomClass_State `protobuf:"varint,15,opt,name=state,proto3,enum=google.cloud.speech.v2.CustomClass_State" json:"state,omitempty"`
	// Output only. Creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time this resource was modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time at which this resource was requested for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which this resource will be purged.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Optional. Allows users to store small amounts of arbitrary data.
	// Both the key and the value must be 63 characters or less each.
	// At most 100 annotations.
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields. This may be sent on update, undelete, and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Whether or not this CustomClass is in the process of being
	// updated.
	Reconciling bool `protobuf:"varint,12,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
	// the CustomClass is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,13,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The [KMS key version
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
	// with which the CustomClass is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
	KmsKeyVersionName string `protobuf:"bytes,14,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
}

func (x *CustomClass) Reset() {
	*x = CustomClass{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomClass) ProtoMessage() {}

func (x *CustomClass) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomClass.ProtoReflect.Descriptor instead.
func (*CustomClass) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{48}
}

func (x *CustomClass) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomClass) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *CustomClass) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CustomClass) GetItems() []*CustomClass_ClassItem {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *CustomClass) GetState() CustomClass_State {
	if x != nil {
		return x.State
	}
	return CustomClass_STATE_UNSPECIFIED
}

func (x *CustomClass) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CustomClass) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CustomClass) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *CustomClass) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *CustomClass) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *CustomClass) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *CustomClass) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *CustomClass) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *CustomClass) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

// PhraseSet for biasing in speech recognition. A PhraseSet is used to provide
// "hints" to the speech recognizer to favor specific words and phrases in the
// results.
type PhraseSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the PhraseSet.
	// Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System-assigned unique identifier for the PhraseSet.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// A list of word and phrases.
	Phrases []*PhraseSet_Phrase `protobuf:"bytes,3,rep,name=phrases,proto3" json:"phrases,omitempty"`
	// Hint Boost. Positive value will increase the probability that a specific
	// phrase will be recognized over other similar sounding phrases. The higher
	// the boost, the higher the chance of false positive recognition as well.
	// Valid `boost` values are between 0 (exclusive) and 20. We recommend using a
	// binary search approach to finding the optimal value for your use case as
	// well as adding phrases both with and without boost to your requests.
	Boost float32 `protobuf:"fixed32,4,opt,name=boost,proto3" json:"boost,omitempty"`
	// User-settable, human-readable name for the PhraseSet. Must be 63
	// characters or less.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The PhraseSet lifecycle state.
	State PhraseSet_State `protobuf:"varint,15,opt,name=state,proto3,enum=google.cloud.speech.v2.PhraseSet_State" json:"state,omitempty"`
	// Output only. Creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time this resource was modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time at which this resource was requested for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which this resource will be purged.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Allows users to store small amounts of arbitrary data.
	// Both the key and the value must be 63 characters or less each.
	// At most 100 annotations.
	Annotations map[string]string `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. This checksum is computed by the server based on the value of
	// other fields. This may be sent on update, undelete, and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Whether or not this PhraseSet is in the process of being
	// updated.
	Reconciling bool `protobuf:"varint,12,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The [KMS key
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
	// the PhraseSet is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	KmsKeyName string `protobuf:"bytes,13,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. The [KMS key version
	// name](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions)
	// with which the PhraseSet is encrypted. The expected format is
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}`.
	KmsKeyVersionName string `protobuf:"bytes,14,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
}

func (x *PhraseSet) Reset() {
	*x = PhraseSet{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PhraseSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseSet) ProtoMessage() {}

func (x *PhraseSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseSet.ProtoReflect.Descriptor instead.
func (*PhraseSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{49}
}

func (x *PhraseSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PhraseSet) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PhraseSet) GetPhrases() []*PhraseSet_Phrase {
	if x != nil {
		return x.Phrases
	}
	return nil
}

func (x *PhraseSet) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

func (x *PhraseSet) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PhraseSet) GetState() PhraseSet_State {
	if x != nil {
		return x.State
	}
	return PhraseSet_STATE_UNSPECIFIED
}

func (x *PhraseSet) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PhraseSet) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PhraseSet) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *PhraseSet) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *PhraseSet) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PhraseSet) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PhraseSet) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *PhraseSet) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *PhraseSet) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

// Request message for the
// [CreateCustomClass][google.cloud.speech.v2.Speech.CreateCustomClass] method.
type CreateCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CustomClass to create.
	CustomClass *CustomClass `protobuf:"bytes,1,opt,name=custom_class,json=customClass,proto3" json:"custom_class,omitempty"`
	// If set, validate the request and preview the CustomClass, but do not
	// actually create it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The ID to use for the CustomClass, which will become the final component of
	// the CustomClass's resource name.
	//
	// This value should be 4-63 characters, and valid characters
	// are /[a-z][0-9]-/.
	CustomClassId string `protobuf:"bytes,3,opt,name=custom_class_id,json=customClassId,proto3" json:"custom_class_id,omitempty"`
	// Required. The project and location where this CustomClass will be created.
	// The expected format is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateCustomClassRequest) Reset() {
	*x = CreateCustomClassRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomClassRequest) ProtoMessage() {}

func (x *CreateCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomClassRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{50}
}

func (x *CreateCustomClassRequest) GetCustomClass() *CustomClass {
	if x != nil {
		return x.CustomClass
	}
	return nil
}

func (x *CreateCustomClassRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *CreateCustomClassRequest) GetCustomClassId() string {
	if x != nil {
		return x.CustomClassId
	}
	return ""
}

func (x *CreateCustomClassRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for the
// [ListCustomClasses][google.cloud.speech.v2.Speech.ListCustomClasses] method.
type ListCustomClassesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location of CustomClass resources to list. The
	// expected format is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of results per requests. A valid page_size ranges from 0 to 100
	// inclusive. If the page_size is zero or unspecified, a page size of 5 will
	// be chosen. If the page size exceeds 100, it will be coerced down to 100.
	// Note that a call might return fewer results than the requested page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [ListCustomClasses][google.cloud.speech.v2.Speech.ListCustomClasses] call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [ListCustomClasses][google.cloud.speech.v2.Speech.ListCustomClasses] must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether, or not, to show resources that have been deleted.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListCustomClassesRequest) Reset() {
	*x = ListCustomClassesRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCustomClassesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomClassesRequest) ProtoMessage() {}

func (x *ListCustomClassesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomClassesRequest.ProtoReflect.Descriptor instead.
func (*ListCustomClassesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{51}
}

func (x *ListCustomClassesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomClassesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomClassesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCustomClassesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for the
// [ListCustomClasses][google.cloud.speech.v2.Speech.ListCustomClasses] method.
type ListCustomClassesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested CustomClasses.
	CustomClasses []*CustomClass `protobuf:"bytes,1,rep,name=custom_classes,json=customClasses,proto3" json:"custom_classes,omitempty"`
	// A token, which can be sent as
	// [page_token][google.cloud.speech.v2.ListCustomClassesRequest.page_token] to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages. This token expires after 72 hours.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomClassesResponse) Reset() {
	*x = ListCustomClassesResponse{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCustomClassesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomClassesResponse) ProtoMessage() {}

func (x *ListCustomClassesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomClassesResponse.ProtoReflect.Descriptor instead.
func (*ListCustomClassesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{52}
}

func (x *ListCustomClassesResponse) GetCustomClasses() []*CustomClass {
	if x != nil {
		return x.CustomClasses
	}
	return nil
}

func (x *ListCustomClassesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the
// [GetCustomClass][google.cloud.speech.v2.Speech.GetCustomClass] method.
type GetCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomClass to retrieve. The expected format is
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomClassRequest) Reset() {
	*x = GetCustomClassRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomClassRequest) ProtoMessage() {}

func (x *GetCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomClassRequest.ProtoReflect.Descriptor instead.
func (*GetCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{53}
}

func (x *GetCustomClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the
// [UpdateCustomClass][google.cloud.speech.v2.Speech.UpdateCustomClass] method.
type UpdateCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CustomClass to update.
	//
	// The CustomClass's `name` field is used to identify the CustomClass to
	// update. Format:
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`.
	CustomClass *CustomClass `protobuf:"bytes,1,opt,name=custom_class,json=customClass,proto3" json:"custom_class,omitempty"`
	// The list of fields to be updated. If empty, all fields are considered for
	// update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set, validate the request and preview the updated CustomClass, but do
	// not actually update it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateCustomClassRequest) Reset() {
	*x = UpdateCustomClassRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomClassRequest) ProtoMessage() {}

func (x *UpdateCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomClassRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{54}
}

func (x *UpdateCustomClassRequest) GetCustomClass() *CustomClass {
	if x != nil {
		return x.CustomClass
	}
	return nil
}

func (x *UpdateCustomClassRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateCustomClassRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for the
// [DeleteCustomClass][google.cloud.speech.v2.Speech.DeleteCustomClass] method.
type DeleteCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomClass to delete.
	// Format:
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the deleted CustomClass, but do
	// not actually delete it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the CustomClass is not found, the request will succeed
	// and  be a no-op (no Operation is recorded in this case).
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields. This may be sent on update, undelete, and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteCustomClassRequest) Reset() {
	*x = DeleteCustomClassRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCustomClassRequest) ProtoMessage() {}

func (x *DeleteCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCustomClassRequest.ProtoReflect.Descriptor instead.
func (*DeleteCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{55}
}

func (x *DeleteCustomClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCustomClassRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteCustomClassRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteCustomClassRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for the
// [UndeleteCustomClass][google.cloud.speech.v2.Speech.UndeleteCustomClass]
// method.
type UndeleteCustomClassRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomClass to undelete.
	// Format:
	// `projects/{project}/locations/{location}/customClasses/{custom_class}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the undeleted CustomClass, but do
	// not actually undelete it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields. This may be sent on update, undelete, and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *UndeleteCustomClassRequest) Reset() {
	*x = UndeleteCustomClassRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeleteCustomClassRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteCustomClassRequest) ProtoMessage() {}

func (x *UndeleteCustomClassRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteCustomClassRequest.ProtoReflect.Descriptor instead.
func (*UndeleteCustomClassRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{56}
}

func (x *UndeleteCustomClassRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeleteCustomClassRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UndeleteCustomClassRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for the
// [CreatePhraseSet][google.cloud.speech.v2.Speech.CreatePhraseSet] method.
type CreatePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The PhraseSet to create.
	PhraseSet *PhraseSet `protobuf:"bytes,1,opt,name=phrase_set,json=phraseSet,proto3" json:"phrase_set,omitempty"`
	// If set, validate the request and preview the PhraseSet, but do not
	// actually create it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The ID to use for the PhraseSet, which will become the final component of
	// the PhraseSet's resource name.
	//
	// This value should be 4-63 characters, and valid characters
	// are /[a-z][0-9]-/.
	PhraseSetId string `protobuf:"bytes,3,opt,name=phrase_set_id,json=phraseSetId,proto3" json:"phrase_set_id,omitempty"`
	// Required. The project and location where this PhraseSet will be created.
	// The expected format is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreatePhraseSetRequest) Reset() {
	*x = CreatePhraseSetRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePhraseSetRequest) ProtoMessage() {}

func (x *CreatePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*CreatePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{57}
}

func (x *CreatePhraseSetRequest) GetPhraseSet() *PhraseSet {
	if x != nil {
		return x.PhraseSet
	}
	return nil
}

func (x *CreatePhraseSetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *CreatePhraseSetRequest) GetPhraseSetId() string {
	if x != nil {
		return x.PhraseSetId
	}
	return ""
}

func (x *CreatePhraseSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for the
// [ListPhraseSets][google.cloud.speech.v2.Speech.ListPhraseSets] method.
type ListPhraseSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location of PhraseSet resources to list. The
	// expected format is `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of PhraseSets to return. The service may return fewer
	// than this value. If unspecified, at most 5 PhraseSets will be returned.
	// The maximum value is 100; values above 100 will be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [ListPhraseSets][google.cloud.speech.v2.Speech.ListPhraseSets] call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [ListPhraseSets][google.cloud.speech.v2.Speech.ListPhraseSets] must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether, or not, to show resources that have been deleted.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListPhraseSetsRequest) Reset() {
	*x = ListPhraseSetsRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPhraseSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseSetsRequest) ProtoMessage() {}

func (x *ListPhraseSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseSetsRequest.ProtoReflect.Descriptor instead.
func (*ListPhraseSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{58}
}

func (x *ListPhraseSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPhraseSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPhraseSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPhraseSetsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for the
// [ListPhraseSets][google.cloud.speech.v2.Speech.ListPhraseSets] method.
type ListPhraseSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested PhraseSets.
	PhraseSets []*PhraseSet `protobuf:"bytes,1,rep,name=phrase_sets,json=phraseSets,proto3" json:"phrase_sets,omitempty"`
	// A token, which can be sent as
	// [page_token][google.cloud.speech.v2.ListPhraseSetsRequest.page_token] to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages. This token expires after 72 hours.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPhraseSetsResponse) Reset() {
	*x = ListPhraseSetsResponse{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPhraseSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPhraseSetsResponse) ProtoMessage() {}

func (x *ListPhraseSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPhraseSetsResponse.ProtoReflect.Descriptor instead.
func (*ListPhraseSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{59}
}

func (x *ListPhraseSetsResponse) GetPhraseSets() []*PhraseSet {
	if x != nil {
		return x.PhraseSets
	}
	return nil
}

func (x *ListPhraseSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the
// [GetPhraseSet][google.cloud.speech.v2.Speech.GetPhraseSet] method.
type GetPhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PhraseSet to retrieve. The expected format is
	// `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPhraseSetRequest) Reset() {
	*x = GetPhraseSetRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPhraseSetRequest) ProtoMessage() {}

func (x *GetPhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPhraseSetRequest.ProtoReflect.Descriptor instead.
func (*GetPhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{60}
}

func (x *GetPhraseSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the
// [UpdatePhraseSet][google.cloud.speech.v2.Speech.UpdatePhraseSet] method.
type UpdatePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The PhraseSet to update.
	//
	// The PhraseSet's `name` field is used to identify the PhraseSet to update.
	// Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`.
	PhraseSet *PhraseSet `protobuf:"bytes,1,opt,name=phrase_set,json=phraseSet,proto3" json:"phrase_set,omitempty"`
	// The list of fields to update. If empty, all non-default valued fields are
	// considered for update. Use `*` to update the entire PhraseSet resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set, validate the request and preview the updated PhraseSet, but do not
	// actually update it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdatePhraseSetRequest) Reset() {
	*x = UpdatePhraseSetRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePhraseSetRequest) ProtoMessage() {}

func (x *UpdatePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*UpdatePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{61}
}

func (x *UpdatePhraseSetRequest) GetPhraseSet() *PhraseSet {
	if x != nil {
		return x.PhraseSet
	}
	return nil
}

func (x *UpdatePhraseSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePhraseSetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for the
// [DeletePhraseSet][google.cloud.speech.v2.Speech.DeletePhraseSet] method.
type DeletePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PhraseSet to delete.
	// Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the deleted PhraseSet, but do not
	// actually delete it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the PhraseSet is not found, the request will succeed
	// and  be a no-op (no Operation is recorded in this case).
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields. This may be sent on update, undelete, and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeletePhraseSetRequest) Reset() {
	*x = DeletePhraseSetRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePhraseSetRequest) ProtoMessage() {}

func (x *DeletePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*DeletePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{62}
}

func (x *DeletePhraseSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePhraseSetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeletePhraseSetRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeletePhraseSetRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for the
// [UndeletePhraseSet][google.cloud.speech.v2.Speech.UndeletePhraseSet]
// method.
type UndeletePhraseSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PhraseSet to undelete.
	// Format: `projects/{project}/locations/{location}/phraseSets/{phrase_set}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, validate the request and preview the undeleted PhraseSet, but do
	// not actually undelete it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// This checksum is computed by the server based on the value of other
	// fields. This may be sent on update, undelete, and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *UndeletePhraseSetRequest) Reset() {
	*x = UndeletePhraseSetRequest{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UndeletePhraseSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeletePhraseSetRequest) ProtoMessage() {}

func (x *UndeletePhraseSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeletePhraseSetRequest.ProtoReflect.Descriptor instead.
func (*UndeletePhraseSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{63}
}

func (x *UndeletePhraseSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeletePhraseSetRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UndeletePhraseSetRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A single replacement configuration.
type TranscriptNormalization_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What to replace. Max length is 100 characters.
	Search string `protobuf:"bytes,1,opt,name=search,proto3" json:"search,omitempty"`
	// What to replace with. Max length is 100 characters.
	Replace string `protobuf:"bytes,2,opt,name=replace,proto3" json:"replace,omitempty"`
	// Whether the search is case sensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *TranscriptNormalization_Entry) Reset() {
	*x = TranscriptNormalization_Entry{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TranscriptNormalization_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TranscriptNormalization_Entry) ProtoMessage() {}

func (x *TranscriptNormalization_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TranscriptNormalization_Entry.ProtoReflect.Descriptor instead.
func (*TranscriptNormalization_Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{13, 0}
}

func (x *TranscriptNormalization_Entry) GetSearch() string {
	if x != nil {
		return x.Search
	}
	return ""
}

func (x *TranscriptNormalization_Entry) GetReplace() string {
	if x != nil {
		return x.Replace
	}
	return ""
}

func (x *TranscriptNormalization_Entry) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// A biasing PhraseSet, which can be either a string referencing the name of
// an existing PhraseSets resource, or an inline definition of a PhraseSet.
type SpeechAdaptation_AdaptationPhraseSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*SpeechAdaptation_AdaptationPhraseSet_PhraseSet
	//	*SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet
	Value isSpeechAdaptation_AdaptationPhraseSet_Value `protobuf_oneof:"value"`
}

func (x *SpeechAdaptation_AdaptationPhraseSet) Reset() {
	*x = SpeechAdaptation_AdaptationPhraseSet{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechAdaptation_AdaptationPhraseSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechAdaptation_AdaptationPhraseSet) ProtoMessage() {}

func (x *SpeechAdaptation_AdaptationPhraseSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechAdaptation_AdaptationPhraseSet.ProtoReflect.Descriptor instead.
func (*SpeechAdaptation_AdaptationPhraseSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{15, 0}
}

func (m *SpeechAdaptation_AdaptationPhraseSet) GetValue() isSpeechAdaptation_AdaptationPhraseSet_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *SpeechAdaptation_AdaptationPhraseSet) GetPhraseSet() string {
	if x, ok := x.GetValue().(*SpeechAdaptation_AdaptationPhraseSet_PhraseSet); ok {
		return x.PhraseSet
	}
	return ""
}

func (x *SpeechAdaptation_AdaptationPhraseSet) GetInlinePhraseSet() *PhraseSet {
	if x, ok := x.GetValue().(*SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet); ok {
		return x.InlinePhraseSet
	}
	return nil
}

type isSpeechAdaptation_AdaptationPhraseSet_Value interface {
	isSpeechAdaptation_AdaptationPhraseSet_Value()
}

type SpeechAdaptation_AdaptationPhraseSet_PhraseSet struct {
	// The name of an existing PhraseSet resource. The user must have read
	// access to the resource and it must not be deleted.
	PhraseSet string `protobuf:"bytes,1,opt,name=phrase_set,json=phraseSet,proto3,oneof"`
}

type SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet struct {
	// An inline defined PhraseSet.
	InlinePhraseSet *PhraseSet `protobuf:"bytes,2,opt,name=inline_phrase_set,json=inlinePhraseSet,proto3,oneof"`
}

func (*SpeechAdaptation_AdaptationPhraseSet_PhraseSet) isSpeechAdaptation_AdaptationPhraseSet_Value() {
}

func (*SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet) isSpeechAdaptation_AdaptationPhraseSet_Value() {
}

// Events that a timeout can be set on for voice activity.
type StreamingRecognitionFeatures_VoiceActivityTimeout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration to timeout the stream if no speech begins. If this is set and
	// no speech is detected in this duration at the start of the stream, the
	// server will close the stream.
	SpeechStartTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=speech_start_timeout,json=speechStartTimeout,proto3" json:"speech_start_timeout,omitempty"`
	// Duration to timeout the stream after speech ends. If this is set and no
	// speech is detected in this duration after speech was detected, the server
	// will close the stream.
	SpeechEndTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=speech_end_timeout,json=speechEndTimeout,proto3" json:"speech_end_timeout,omitempty"`
}

func (x *StreamingRecognitionFeatures_VoiceActivityTimeout) Reset() {
	*x = StreamingRecognitionFeatures_VoiceActivityTimeout{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRecognitionFeatures_VoiceActivityTimeout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionFeatures_VoiceActivityTimeout) ProtoMessage() {}

func (x *StreamingRecognitionFeatures_VoiceActivityTimeout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionFeatures_VoiceActivityTimeout.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionFeatures_VoiceActivityTimeout) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{24, 0}
}

func (x *StreamingRecognitionFeatures_VoiceActivityTimeout) GetSpeechStartTimeout() *durationpb.Duration {
	if x != nil {
		return x.SpeechStartTimeout
	}
	return nil
}

func (x *StreamingRecognitionFeatures_VoiceActivityTimeout) GetSpeechEndTimeout() *durationpb.Duration {
	if x != nil {
		return x.SpeechEndTimeout
	}
	return nil
}

// An item of the class.
type CustomClass_ClassItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The class item's value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *CustomClass_ClassItem) Reset() {
	*x = CustomClass_ClassItem{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomClass_ClassItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomClass_ClassItem) ProtoMessage() {}

func (x *CustomClass_ClassItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomClass_ClassItem.ProtoReflect.Descriptor instead.
func (*CustomClass_ClassItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{48, 0}
}

func (x *CustomClass_ClassItem) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A Phrase contains words and phrase "hints" so that the speech recognition
// is more likely to recognize them. This can be used to improve the accuracy
// for specific words and phrases, for example, if specific commands are
// typically spoken by the user. This can also be used to add additional words
// to the vocabulary of the recognizer.
//
// List items can also include CustomClass references containing groups of
// words that represent common concepts that occur in natural language.
type PhraseSet_Phrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The phrase itself.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Hint Boost. Overrides the boost set at the phrase set level.
	// Positive value will increase the probability that a specific phrase will
	// be recognized over other similar sounding phrases. The higher the boost,
	// the higher the chance of false positive recognition as well. Negative
	// boost values would correspond to anti-biasing. Anti-biasing is not
	// enabled, so negative boost values will return an error. Boost values must
	// be between 0 and 20. Any values outside that range will return an error.
	// We recommend using a binary search approach to finding the optimal value
	// for your use case as well as adding phrases both with and without boost
	// to your requests.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *PhraseSet_Phrase) Reset() {
	*x = PhraseSet_Phrase{}
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PhraseSet_Phrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseSet_Phrase) ProtoMessage() {}

func (x *PhraseSet_Phrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseSet_Phrase.ProtoReflect.Descriptor instead.
func (*PhraseSet_Phrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP(), []int{49, 0}
}

func (x *PhraseSet_Phrase) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *PhraseSet_Phrase) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

var File_google_cloud_speech_v2_cloud_speech_proto protoreflect.FileDescriptor

var file_google_cloud_speech_v2_cloud_speech_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xb7, 0x10, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x48, 0x0a, 0x0c, 0x6b, 0x6d, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x17, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x15, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6d, 0x0a, 0x19,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x17, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6d, 0x0a, 0x19, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x17, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6d, 0x0a, 0x19, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x17, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x73, 0x0a, 0x1b, 0x75, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x19, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x71,
	0x0a, 0x1b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x18, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x71, 0x0a, 0x1b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x18, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x71, 0x0a, 0x1b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x18, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x77, 0x0a, 0x1d, 0x75, 0x6e, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x1a, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x6b, 0x0a, 0x19, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x16, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a,
	0x19, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x16, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x19, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x16, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x71, 0x0a, 0x1b, 0x75, 0x6e, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x18, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x65, 0x0a, 0x15, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x13, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x6a, 0x0a, 0x18,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x01,
	0x52, 0x16, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xba, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f,
	0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x87, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a,
	0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23,
	0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x92, 0x01, 0x0a, 0x19,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x22, 0x8f, 0x09, 0x0a, 0x0a, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12,
	0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x12, 0x2c, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18,
	0x01, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x67, 0x0a, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4b, 0x0a,
	0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a,
	0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x14, 0x6b, 0x6d,
	0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x3e, 0x0a,
	0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x6a, 0xea, 0x41, 0x67, 0x0a, 0x20, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x40, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x7d, 0x52,
	0x01, 0x01, 0x22, 0x1a, 0x0a, 0x18, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x44, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9e,
	0x03, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x44, 0x65, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x08, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x44, 0x65, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xbe,
	0x01, 0x0a, 0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49,
	0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x4d, 0x55, 0x4c, 0x41, 0x57, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x4c, 0x41,
	0x57, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4d, 0x52, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x4d, 0x52, 0x5f, 0x57, 0x42, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x41, 0x43,
	0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x50, 0x33, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x4f,
	0x47, 0x47, 0x5f, 0x4f, 0x50, 0x55, 0x53, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x57, 0x45, 0x42,
	0x4d, 0x5f, 0x4f, 0x50, 0x55, 0x53, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x50, 0x34, 0x5f,
	0x41, 0x41, 0x43, 0x10, 0x0a, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x34, 0x41, 0x5f, 0x41, 0x41, 0x43,
	0x10, 0x0b, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x56, 0x5f, 0x41, 0x41, 0x43, 0x10, 0x0c, 0x22,
	0x7c, 0x0a, 0x18, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x44, 0x69, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x11, 0x6d,
	0x69, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6d, 0x69, 0x6e,
	0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11,
	0x6d, 0x61, 0x78, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6d, 0x61,
	0x78, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xb5, 0x05,
	0x0a, 0x13, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x66, 0x61, 0x6e, 0x69,
	0x74, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x70, 0x72, 0x6f, 0x66, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x37, 0x0a, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x57, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x40, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x63, 0x5f, 0x70, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x70, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x6f, 0x6b,
	0x65, 0x6e, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a,
	0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65,
	0x6d, 0x6f, 0x6a, 0x69, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x73, 0x12,
	0x6a, 0x0a, 0x12, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x10, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x64,
	0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x44, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x64, 0x69, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x10,
	0x6d, 0x61, 0x78, 0x5f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x41, 0x6c, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x22, 0x5c, 0x0a, 0x10, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x4d,
	0x55, 0x4c, 0x54, 0x49, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x24, 0x0a, 0x20, 0x53, 0x45, 0x50, 0x41, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x47, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x43, 0x48, 0x41, 0x4e,
	0x4e, 0x45, 0x4c, 0x10, 0x01, 0x22, 0xcc, 0x01, 0x0a, 0x17, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x4f, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x1a, 0x60, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x22, 0x41, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0xf6, 0x02, 0x0a, 0x10, 0x53, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0b,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x61, 0x70,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x0a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x1a, 0xb6, 0x01, 0x0a, 0x13, 0x41, 0x64, 0x61, 0x70,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12,
	0x45, 0x0a, 0x0a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x09, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x4f, 0x0a, 0x11, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x5a, 0x0a, 0x0e, 0x44, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x5f, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x64, 0x65, 0x6e, 0x6f, 0x69,
	0x73, 0x65, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6e, 0x72, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c,
	0x73, 0x6e, 0x72, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xf8, 0x05, 0x0a,
	0x11, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x64, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x18, 0x65, 0x78, 0x70, 0x6c,
	0x69, 0x63, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x44, 0x65, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x65, 0x78,
	0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x44, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x2a, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x08, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f,
	0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5d, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54,
	0x0a, 0x0f, 0x64, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x44, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x11, 0x0a, 0x0f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9c, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x0a,
	0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x42, 0x0e, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x1b, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x27, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x4d, 0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x42, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96,
	0x01, 0x0a, 0x1c, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12,
	0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x36, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x22, 0xdb, 0x01, 0x0a, 0x08, 0x57, 0x6f, 0x72, 0x64,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3c, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x77, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x85, 0x02, 0x0a, 0x17, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x58, 0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0c, 0x61,
	0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x61, 0x67, 0x12, 0x45, 0x0a, 0x11,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x64, 0x4f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xaf, 0x01,
	0x0a, 0x11, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x4f,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xb8, 0x03, 0x0a, 0x1c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x12, 0x3f, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x6f,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6d, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x7f, 0x0a, 0x16, 0x76, 0x6f,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x52, 0x14, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x69, 0x74, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x1a, 0xac, 0x01, 0x0a, 0x14,
	0x56, 0x6f, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x12, 0x4b, 0x0a, 0x14, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x12, 0x47, 0x0a, 0x12, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x86, 0x02, 0x0a, 0x1a, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x63,
	0x0a, 0x12, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x52, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x22, 0xf3, 0x01, 0x0a, 0x19, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52,
	0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x10, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x05,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x05, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xdc, 0x04, 0x0a, 0x15, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x41, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x48, 0x0a,
	0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x6b, 0x0a, 0x19, 0x72, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x4f, 0x0a, 0x12, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x23, 0x0a,
	0x1f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x42, 0x41,
	0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x22, 0x23, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x14, 0x0a,
	0x12, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x1e, 0x0a, 0x1c, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x1b, 0x0a, 0x19, 0x56, 0x74, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x1b, 0x0a, 0x19, 0x53, 0x72, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xec, 0x01,
	0x0a, 0x12, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x06, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x6e, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x12, 0x43, 0x0a, 0x03, 0x76, 0x74, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x74, 0x74, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x03, 0x76, 0x74, 0x74, 0x12, 0x43, 0x0a, 0x03, 0x73, 0x72, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x72,
	0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x73, 0x72, 0x74, 0x22, 0xc1, 0x02, 0x0a,
	0x17, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x11, 0x67, 0x63, 0x73, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x63, 0x73,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0f,
	0x67, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x62, 0x0a, 0x16, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x69,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x22, 0xac, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x4d, 0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c,
	0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x6c, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xb3, 0x01, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x72, 0x0a, 0x12, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x24, 0x0a,
	0x0e, 0x76, 0x74, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x74, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x72, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x72, 0x74,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x55, 0x72, 0x69, 0x22, 0xa3, 0x01, 0x0a, 0x0c, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4d, 0x0a, 0x0a, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x0a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x76, 0x74, 0x74,
	0x5f, 0x63, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x76, 0x74, 0x74, 0x43, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x72, 0x74, 0x43, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xb5, 0x03, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x28, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5e, 0x0a, 0x14, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4b, 0x0a, 0x0d, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x51, 0x0a, 0x0a, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x42, 0x08, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x8c, 0x01, 0x0a, 0x23, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xa3, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x80, 0x01, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x15, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x1a, 0x85, 0x01, 0x0a, 0x1a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x51, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc0, 0x01, 0x0a,
	0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x41, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x0e, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0xc1, 0x02, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x58,
	0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0c, 0x61, 0x6c, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x66,
	0x69, 0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x45, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x45,
	0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x22, 0xfe, 0x03, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x6e, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x49, 0x0a, 0x13, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x4f, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x85, 0x01, 0x0a,
	0x0f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x21, 0x0a, 0x1d, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x49,
	0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x49, 0x54, 0x59, 0x5f, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x53,
	0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x45,
	0x4e, 0x44, 0x10, 0x03, 0x22, 0x86, 0x02, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d,
	0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x51, 0xea, 0x41, 0x4e, 0x0a,
	0x1c, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4c, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x13,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd5, 0x08,
	0x0a, 0x0b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x1a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x2e, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x44, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0b, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4b, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x21, 0x0a, 0x09, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x04, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x44, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x7d, 0x52, 0x01, 0x01, 0x22, 0xe6, 0x08, 0x0a, 0x09, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x42, 0x0a, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x52, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x54, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x25,
	0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x4b, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x61, 0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x34, 0x0a, 0x06, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x04, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x7d, 0x52, 0x01, 0x01, 0x22, 0xf7,
	0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x26, 0x0a,
	0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xbc, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x8f, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xc9, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xb7, 0x01,
	0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x94, 0x01, 0x0a, 0x1a, 0x55, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xe9,
	0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x0a, 0x70, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x21, 0x12, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xb9, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x42, 0x0a, 0x0b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x0a, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x52, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xc1, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x0a,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xb3, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x90, 0x01, 0x0a, 0x18,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x32, 0xbf,
	0x25, 0x0a, 0x06, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0xec, 0x01, 0x0a, 0x10, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87,
	0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x2c, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0a, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x22, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x12,
	0xa1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x72, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xee, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16,
	0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x0a, 0x72, 0x65,
	0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x32, 0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc4, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
	0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x60, 0xca, 0x41, 0x1f, 0x0a, 0x0a,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x12,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x72, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0xf9, 0x01, 0x0a, 0x09, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x96, 0x01, 0xda, 0x41, 0x25, 0x72, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x72, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0xda, 0x41, 0x21, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x2c, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2c, 0x75, 0x72, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0x81,
	0x01, 0x0a, 0x12, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01,
	0x30, 0x01, 0x12, 0x84, 0x02, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xa3, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x23, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65,
	0x72, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2c, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x7a, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x7a, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x09, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x37, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a,
	0x12, 0x28, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0xb1, 0x01, 0x0a, 0x0c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x54, 0xda, 0x41, 0x12, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x2f, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0xf7,
	0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x23, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73,
	0x73, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x63, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0xbc, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x12, 0xa6, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x22, 0x40,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xf9, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x18,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x0c,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x32, 0x3e, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc9, 0x01, 0x0a,
	0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x63, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd9, 0x01, 0x0a, 0x13, 0x55, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x12, 0xe8, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x2c,
	0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3c, 0x3a, 0x0a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x22,
	0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12,
	0xb0, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x74, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x0a, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x32, 0x39, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc0, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x5e, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53,
	0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xd0, 0x01, 0x0a, 0x11, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca, 0x41, 0x1e, 0x0a, 0x09,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0x89, 0x03, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41,
	0xa6, 0x01, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b,
	0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79,
	0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x32, 0x42, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x70, 0x62, 0x3b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_speech_v2_cloud_speech_proto_rawDescOnce sync.Once
	file_google_cloud_speech_v2_cloud_speech_proto_rawDescData = file_google_cloud_speech_v2_cloud_speech_proto_rawDesc
)

func file_google_cloud_speech_v2_cloud_speech_proto_rawDescGZIP() []byte {
	file_google_cloud_speech_v2_cloud_speech_proto_rawDescOnce.Do(func() {
		file_google_cloud_speech_v2_cloud_speech_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_speech_v2_cloud_speech_proto_rawDescData)
	})
	return file_google_cloud_speech_v2_cloud_speech_proto_rawDescData
}

var file_google_cloud_speech_v2_cloud_speech_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_speech_v2_cloud_speech_proto_msgTypes = make([]protoimpl.MessageInfo, 74)
var file_google_cloud_speech_v2_cloud_speech_proto_goTypes = []any{
	(Recognizer_State)(0),                                     // 0: google.cloud.speech.v2.Recognizer.State
	(ExplicitDecodingConfig_AudioEncoding)(0),                 // 1: google.cloud.speech.v2.ExplicitDecodingConfig.AudioEncoding
	(RecognitionFeatures_MultiChannelMode)(0),                 // 2: google.cloud.speech.v2.RecognitionFeatures.MultiChannelMode
	(BatchRecognizeRequest_ProcessingStrategy)(0),             // 3: google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy
	(StreamingRecognizeResponse_SpeechEventType)(0),           // 4: google.cloud.speech.v2.StreamingRecognizeResponse.SpeechEventType
	(CustomClass_State)(0),                                    // 5: google.cloud.speech.v2.CustomClass.State
	(PhraseSet_State)(0),                                      // 6: google.cloud.speech.v2.PhraseSet.State
	(*CreateRecognizerRequest)(nil),                           // 7: google.cloud.speech.v2.CreateRecognizerRequest
	(*OperationMetadata)(nil),                                 // 8: google.cloud.speech.v2.OperationMetadata
	(*ListRecognizersRequest)(nil),                            // 9: google.cloud.speech.v2.ListRecognizersRequest
	(*ListRecognizersResponse)(nil),                           // 10: google.cloud.speech.v2.ListRecognizersResponse
	(*GetRecognizerRequest)(nil),                              // 11: google.cloud.speech.v2.GetRecognizerRequest
	(*UpdateRecognizerRequest)(nil),                           // 12: google.cloud.speech.v2.UpdateRecognizerRequest
	(*DeleteRecognizerRequest)(nil),                           // 13: google.cloud.speech.v2.DeleteRecognizerRequest
	(*UndeleteRecognizerRequest)(nil),                         // 14: google.cloud.speech.v2.UndeleteRecognizerRequest
	(*Recognizer)(nil),                                        // 15: google.cloud.speech.v2.Recognizer
	(*AutoDetectDecodingConfig)(nil),                          // 16: google.cloud.speech.v2.AutoDetectDecodingConfig
	(*ExplicitDecodingConfig)(nil),                            // 17: google.cloud.speech.v2.ExplicitDecodingConfig
	(*SpeakerDiarizationConfig)(nil),                          // 18: google.cloud.speech.v2.SpeakerDiarizationConfig
	(*RecognitionFeatures)(nil),                               // 19: google.cloud.speech.v2.RecognitionFeatures
	(*TranscriptNormalization)(nil),                           // 20: google.cloud.speech.v2.TranscriptNormalization
	(*TranslationConfig)(nil),                                 // 21: google.cloud.speech.v2.TranslationConfig
	(*SpeechAdaptation)(nil),                                  // 22: google.cloud.speech.v2.SpeechAdaptation
	(*DenoiserConfig)(nil),                                    // 23: google.cloud.speech.v2.DenoiserConfig
	(*RecognitionConfig)(nil),                                 // 24: google.cloud.speech.v2.RecognitionConfig
	(*RecognizeRequest)(nil),                                  // 25: google.cloud.speech.v2.RecognizeRequest
	(*RecognitionResponseMetadata)(nil),                       // 26: google.cloud.speech.v2.RecognitionResponseMetadata
	(*SpeechRecognitionAlternative)(nil),                      // 27: google.cloud.speech.v2.SpeechRecognitionAlternative
	(*WordInfo)(nil),                                          // 28: google.cloud.speech.v2.WordInfo
	(*SpeechRecognitionResult)(nil),                           // 29: google.cloud.speech.v2.SpeechRecognitionResult
	(*RecognizeResponse)(nil),                                 // 30: google.cloud.speech.v2.RecognizeResponse
	(*StreamingRecognitionFeatures)(nil),                      // 31: google.cloud.speech.v2.StreamingRecognitionFeatures
	(*StreamingRecognitionConfig)(nil),                        // 32: google.cloud.speech.v2.StreamingRecognitionConfig
	(*StreamingRecognizeRequest)(nil),                         // 33: google.cloud.speech.v2.StreamingRecognizeRequest
	(*BatchRecognizeRequest)(nil),                             // 34: google.cloud.speech.v2.BatchRecognizeRequest
	(*GcsOutputConfig)(nil),                                   // 35: google.cloud.speech.v2.GcsOutputConfig
	(*InlineOutputConfig)(nil),                                // 36: google.cloud.speech.v2.InlineOutputConfig
	(*NativeOutputFileFormatConfig)(nil),                      // 37: google.cloud.speech.v2.NativeOutputFileFormatConfig
	(*VttOutputFileFormatConfig)(nil),                         // 38: google.cloud.speech.v2.VttOutputFileFormatConfig
	(*SrtOutputFileFormatConfig)(nil),                         // 39: google.cloud.speech.v2.SrtOutputFileFormatConfig
	(*OutputFormatConfig)(nil),                                // 40: google.cloud.speech.v2.OutputFormatConfig
	(*RecognitionOutputConfig)(nil),                           // 41: google.cloud.speech.v2.RecognitionOutputConfig
	(*BatchRecognizeResponse)(nil),                            // 42: google.cloud.speech.v2.BatchRecognizeResponse
	(*BatchRecognizeResults)(nil),                             // 43: google.cloud.speech.v2.BatchRecognizeResults
	(*CloudStorageResult)(nil),                                // 44: google.cloud.speech.v2.CloudStorageResult
	(*InlineResult)(nil),                                      // 45: google.cloud.speech.v2.InlineResult
	(*BatchRecognizeFileResult)(nil),                          // 46: google.cloud.speech.v2.BatchRecognizeFileResult
	(*BatchRecognizeTranscriptionMetadata)(nil),               // 47: google.cloud.speech.v2.BatchRecognizeTranscriptionMetadata
	(*BatchRecognizeMetadata)(nil),                            // 48: google.cloud.speech.v2.BatchRecognizeMetadata
	(*BatchRecognizeFileMetadata)(nil),                        // 49: google.cloud.speech.v2.BatchRecognizeFileMetadata
	(*StreamingRecognitionResult)(nil),                        // 50: google.cloud.speech.v2.StreamingRecognitionResult
	(*StreamingRecognizeResponse)(nil),                        // 51: google.cloud.speech.v2.StreamingRecognizeResponse
	(*Config)(nil),                                            // 52: google.cloud.speech.v2.Config
	(*GetConfigRequest)(nil),                                  // 53: google.cloud.speech.v2.GetConfigRequest
	(*UpdateConfigRequest)(nil),                               // 54: google.cloud.speech.v2.UpdateConfigRequest
	(*CustomClass)(nil),                                       // 55: google.cloud.speech.v2.CustomClass
	(*PhraseSet)(nil),                                         // 56: google.cloud.speech.v2.PhraseSet
	(*CreateCustomClassRequest)(nil),                          // 57: google.cloud.speech.v2.CreateCustomClassRequest
	(*ListCustomClassesRequest)(nil),                          // 58: google.cloud.speech.v2.ListCustomClassesRequest
	(*ListCustomClassesResponse)(nil),                         // 59: google.cloud.speech.v2.ListCustomClassesResponse
	(*GetCustomClassRequest)(nil),                             // 60: google.cloud.speech.v2.GetCustomClassRequest
	(*UpdateCustomClassRequest)(nil),                          // 61: google.cloud.speech.v2.UpdateCustomClassRequest
	(*DeleteCustomClassRequest)(nil),                          // 62: google.cloud.speech.v2.DeleteCustomClassRequest
	(*UndeleteCustomClassRequest)(nil),                        // 63: google.cloud.speech.v2.UndeleteCustomClassRequest
	(*CreatePhraseSetRequest)(nil),                            // 64: google.cloud.speech.v2.CreatePhraseSetRequest
	(*ListPhraseSetsRequest)(nil),                             // 65: google.cloud.speech.v2.ListPhraseSetsRequest
	(*ListPhraseSetsResponse)(nil),                            // 66: google.cloud.speech.v2.ListPhraseSetsResponse
	(*GetPhraseSetRequest)(nil),                               // 67: google.cloud.speech.v2.GetPhraseSetRequest
	(*UpdatePhraseSetRequest)(nil),                            // 68: google.cloud.speech.v2.UpdatePhraseSetRequest
	(*DeletePhraseSetRequest)(nil),                            // 69: google.cloud.speech.v2.DeletePhraseSetRequest
	(*UndeletePhraseSetRequest)(nil),                          // 70: google.cloud.speech.v2.UndeletePhraseSetRequest
	nil,                                                       // 71: google.cloud.speech.v2.Recognizer.AnnotationsEntry
	(*TranscriptNormalization_Entry)(nil),                     // 72: google.cloud.speech.v2.TranscriptNormalization.Entry
	(*SpeechAdaptation_AdaptationPhraseSet)(nil),              // 73: google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
	(*StreamingRecognitionFeatures_VoiceActivityTimeout)(nil), // 74: google.cloud.speech.v2.StreamingRecognitionFeatures.VoiceActivityTimeout
	nil,                             // 75: google.cloud.speech.v2.BatchRecognizeResponse.ResultsEntry
	nil,                             // 76: google.cloud.speech.v2.BatchRecognizeMetadata.TranscriptionMetadataEntry
	(*CustomClass_ClassItem)(nil),   // 77: google.cloud.speech.v2.CustomClass.ClassItem
	nil,                             // 78: google.cloud.speech.v2.CustomClass.AnnotationsEntry
	(*PhraseSet_Phrase)(nil),        // 79: google.cloud.speech.v2.PhraseSet.Phrase
	nil,                             // 80: google.cloud.speech.v2.PhraseSet.AnnotationsEntry
	(*timestamppb.Timestamp)(nil),   // 81: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),   // 82: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),     // 83: google.protobuf.Duration
	(*status.Status)(nil),           // 84: google.rpc.Status
	(*longrunningpb.Operation)(nil), // 85: google.longrunning.Operation
}
var file_google_cloud_speech_v2_cloud_speech_proto_depIdxs = []int32{
	15,  // 0: google.cloud.speech.v2.CreateRecognizerRequest.recognizer:type_name -> google.cloud.speech.v2.Recognizer
	81,  // 1: google.cloud.speech.v2.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	81,  // 2: google.cloud.speech.v2.OperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	34,  // 3: google.cloud.speech.v2.OperationMetadata.batch_recognize_request:type_name -> google.cloud.speech.v2.BatchRecognizeRequest
	7,   // 4: google.cloud.speech.v2.OperationMetadata.create_recognizer_request:type_name -> google.cloud.speech.v2.CreateRecognizerRequest
	12,  // 5: google.cloud.speech.v2.OperationMetadata.update_recognizer_request:type_name -> google.cloud.speech.v2.UpdateRecognizerRequest
	13,  // 6: google.cloud.speech.v2.OperationMetadata.delete_recognizer_request:type_name -> google.cloud.speech.v2.DeleteRecognizerRequest
	14,  // 7: google.cloud.speech.v2.OperationMetadata.undelete_recognizer_request:type_name -> google.cloud.speech.v2.UndeleteRecognizerRequest
	57,  // 8: google.cloud.speech.v2.OperationMetadata.create_custom_class_request:type_name -> google.cloud.speech.v2.CreateCustomClassRequest
	61,  // 9: google.cloud.speech.v2.OperationMetadata.update_custom_class_request:type_name -> google.cloud.speech.v2.UpdateCustomClassRequest
	62,  // 10: google.cloud.speech.v2.OperationMetadata.delete_custom_class_request:type_name -> google.cloud.speech.v2.DeleteCustomClassRequest
	63,  // 11: google.cloud.speech.v2.OperationMetadata.undelete_custom_class_request:type_name -> google.cloud.speech.v2.UndeleteCustomClassRequest
	64,  // 12: google.cloud.speech.v2.OperationMetadata.create_phrase_set_request:type_name -> google.cloud.speech.v2.CreatePhraseSetRequest
	68,  // 13: google.cloud.speech.v2.OperationMetadata.update_phrase_set_request:type_name -> google.cloud.speech.v2.UpdatePhraseSetRequest
	69,  // 14: google.cloud.speech.v2.OperationMetadata.delete_phrase_set_request:type_name -> google.cloud.speech.v2.DeletePhraseSetRequest
	70,  // 15: google.cloud.speech.v2.OperationMetadata.undelete_phrase_set_request:type_name -> google.cloud.speech.v2.UndeletePhraseSetRequest
	54,  // 16: google.cloud.speech.v2.OperationMetadata.update_config_request:type_name -> google.cloud.speech.v2.UpdateConfigRequest
	48,  // 17: google.cloud.speech.v2.OperationMetadata.batch_recognize_metadata:type_name -> google.cloud.speech.v2.BatchRecognizeMetadata
	15,  // 18: google.cloud.speech.v2.ListRecognizersResponse.recognizers:type_name -> google.cloud.speech.v2.Recognizer
	15,  // 19: google.cloud.speech.v2.UpdateRecognizerRequest.recognizer:type_name -> google.cloud.speech.v2.Recognizer
	82,  // 20: google.cloud.speech.v2.UpdateRecognizerRequest.update_mask:type_name -> google.protobuf.FieldMask
	24,  // 21: google.cloud.speech.v2.Recognizer.default_recognition_config:type_name -> google.cloud.speech.v2.RecognitionConfig
	71,  // 22: google.cloud.speech.v2.Recognizer.annotations:type_name -> google.cloud.speech.v2.Recognizer.AnnotationsEntry
	0,   // 23: google.cloud.speech.v2.Recognizer.state:type_name -> google.cloud.speech.v2.Recognizer.State
	81,  // 24: google.cloud.speech.v2.Recognizer.create_time:type_name -> google.protobuf.Timestamp
	81,  // 25: google.cloud.speech.v2.Recognizer.update_time:type_name -> google.protobuf.Timestamp
	81,  // 26: google.cloud.speech.v2.Recognizer.delete_time:type_name -> google.protobuf.Timestamp
	81,  // 27: google.cloud.speech.v2.Recognizer.expire_time:type_name -> google.protobuf.Timestamp
	1,   // 28: google.cloud.speech.v2.ExplicitDecodingConfig.encoding:type_name -> google.cloud.speech.v2.ExplicitDecodingConfig.AudioEncoding
	2,   // 29: google.cloud.speech.v2.RecognitionFeatures.multi_channel_mode:type_name -> google.cloud.speech.v2.RecognitionFeatures.MultiChannelMode
	18,  // 30: google.cloud.speech.v2.RecognitionFeatures.diarization_config:type_name -> google.cloud.speech.v2.SpeakerDiarizationConfig
	72,  // 31: google.cloud.speech.v2.TranscriptNormalization.entries:type_name -> google.cloud.speech.v2.TranscriptNormalization.Entry
	73,  // 32: google.cloud.speech.v2.SpeechAdaptation.phrase_sets:type_name -> google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet
	55,  // 33: google.cloud.speech.v2.SpeechAdaptation.custom_classes:type_name -> google.cloud.speech.v2.CustomClass
	16,  // 34: google.cloud.speech.v2.RecognitionConfig.auto_decoding_config:type_name -> google.cloud.speech.v2.AutoDetectDecodingConfig
	17,  // 35: google.cloud.speech.v2.RecognitionConfig.explicit_decoding_config:type_name -> google.cloud.speech.v2.ExplicitDecodingConfig
	19,  // 36: google.cloud.speech.v2.RecognitionConfig.features:type_name -> google.cloud.speech.v2.RecognitionFeatures
	22,  // 37: google.cloud.speech.v2.RecognitionConfig.adaptation:type_name -> google.cloud.speech.v2.SpeechAdaptation
	20,  // 38: google.cloud.speech.v2.RecognitionConfig.transcript_normalization:type_name -> google.cloud.speech.v2.TranscriptNormalization
	21,  // 39: google.cloud.speech.v2.RecognitionConfig.translation_config:type_name -> google.cloud.speech.v2.TranslationConfig
	23,  // 40: google.cloud.speech.v2.RecognitionConfig.denoiser_config:type_name -> google.cloud.speech.v2.DenoiserConfig
	24,  // 41: google.cloud.speech.v2.RecognizeRequest.config:type_name -> google.cloud.speech.v2.RecognitionConfig
	82,  // 42: google.cloud.speech.v2.RecognizeRequest.config_mask:type_name -> google.protobuf.FieldMask
	83,  // 43: google.cloud.speech.v2.RecognitionResponseMetadata.total_billed_duration:type_name -> google.protobuf.Duration
	28,  // 44: google.cloud.speech.v2.SpeechRecognitionAlternative.words:type_name -> google.cloud.speech.v2.WordInfo
	83,  // 45: google.cloud.speech.v2.WordInfo.start_offset:type_name -> google.protobuf.Duration
	83,  // 46: google.cloud.speech.v2.WordInfo.end_offset:type_name -> google.protobuf.Duration
	27,  // 47: google.cloud.speech.v2.SpeechRecognitionResult.alternatives:type_name -> google.cloud.speech.v2.SpeechRecognitionAlternative
	83,  // 48: google.cloud.speech.v2.SpeechRecognitionResult.result_end_offset:type_name -> google.protobuf.Duration
	29,  // 49: google.cloud.speech.v2.RecognizeResponse.results:type_name -> google.cloud.speech.v2.SpeechRecognitionResult
	26,  // 50: google.cloud.speech.v2.RecognizeResponse.metadata:type_name -> google.cloud.speech.v2.RecognitionResponseMetadata
	74,  // 51: google.cloud.speech.v2.StreamingRecognitionFeatures.voice_activity_timeout:type_name -> google.cloud.speech.v2.StreamingRecognitionFeatures.VoiceActivityTimeout
	24,  // 52: google.cloud.speech.v2.StreamingRecognitionConfig.config:type_name -> google.cloud.speech.v2.RecognitionConfig
	82,  // 53: google.cloud.speech.v2.StreamingRecognitionConfig.config_mask:type_name -> google.protobuf.FieldMask
	31,  // 54: google.cloud.speech.v2.StreamingRecognitionConfig.streaming_features:type_name -> google.cloud.speech.v2.StreamingRecognitionFeatures
	32,  // 55: google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config:type_name -> google.cloud.speech.v2.StreamingRecognitionConfig
	24,  // 56: google.cloud.speech.v2.BatchRecognizeRequest.config:type_name -> google.cloud.speech.v2.RecognitionConfig
	82,  // 57: google.cloud.speech.v2.BatchRecognizeRequest.config_mask:type_name -> google.protobuf.FieldMask
	49,  // 58: google.cloud.speech.v2.BatchRecognizeRequest.files:type_name -> google.cloud.speech.v2.BatchRecognizeFileMetadata
	41,  // 59: google.cloud.speech.v2.BatchRecognizeRequest.recognition_output_config:type_name -> google.cloud.speech.v2.RecognitionOutputConfig
	3,   // 60: google.cloud.speech.v2.BatchRecognizeRequest.processing_strategy:type_name -> google.cloud.speech.v2.BatchRecognizeRequest.ProcessingStrategy
	37,  // 61: google.cloud.speech.v2.OutputFormatConfig.native:type_name -> google.cloud.speech.v2.NativeOutputFileFormatConfig
	38,  // 62: google.cloud.speech.v2.OutputFormatConfig.vtt:type_name -> google.cloud.speech.v2.VttOutputFileFormatConfig
	39,  // 63: google.cloud.speech.v2.OutputFormatConfig.srt:type_name -> google.cloud.speech.v2.SrtOutputFileFormatConfig
	35,  // 64: google.cloud.speech.v2.RecognitionOutputConfig.gcs_output_config:type_name -> google.cloud.speech.v2.GcsOutputConfig
	36,  // 65: google.cloud.speech.v2.RecognitionOutputConfig.inline_response_config:type_name -> google.cloud.speech.v2.InlineOutputConfig
	40,  // 66: google.cloud.speech.v2.RecognitionOutputConfig.output_format_config:type_name -> google.cloud.speech.v2.OutputFormatConfig
	75,  // 67: google.cloud.speech.v2.BatchRecognizeResponse.results:type_name -> google.cloud.speech.v2.BatchRecognizeResponse.ResultsEntry
	83,  // 68: google.cloud.speech.v2.BatchRecognizeResponse.total_billed_duration:type_name -> google.protobuf.Duration
	29,  // 69: google.cloud.speech.v2.BatchRecognizeResults.results:type_name -> google.cloud.speech.v2.SpeechRecognitionResult
	26,  // 70: google.cloud.speech.v2.BatchRecognizeResults.metadata:type_name -> google.cloud.speech.v2.RecognitionResponseMetadata
	43,  // 71: google.cloud.speech.v2.InlineResult.transcript:type_name -> google.cloud.speech.v2.BatchRecognizeResults
	84,  // 72: google.cloud.speech.v2.BatchRecognizeFileResult.error:type_name -> google.rpc.Status
	26,  // 73: google.cloud.speech.v2.BatchRecognizeFileResult.metadata:type_name -> google.cloud.speech.v2.RecognitionResponseMetadata
	44,  // 74: google.cloud.speech.v2.BatchRecognizeFileResult.cloud_storage_result:type_name -> google.cloud.speech.v2.CloudStorageResult
	45,  // 75: google.cloud.speech.v2.BatchRecognizeFileResult.inline_result:type_name -> google.cloud.speech.v2.InlineResult
	43,  // 76: google.cloud.speech.v2.BatchRecognizeFileResult.transcript:type_name -> google.cloud.speech.v2.BatchRecognizeResults
	84,  // 77: google.cloud.speech.v2.BatchRecognizeTranscriptionMetadata.error:type_name -> google.rpc.Status
	76,  // 78: google.cloud.speech.v2.BatchRecognizeMetadata.transcription_metadata:type_name -> google.cloud.speech.v2.BatchRecognizeMetadata.TranscriptionMetadataEntry
	24,  // 79: google.cloud.speech.v2.BatchRecognizeFileMetadata.config:type_name -> google.cloud.speech.v2.RecognitionConfig
	82,  // 80: google.cloud.speech.v2.BatchRecognizeFileMetadata.config_mask:type_name -> google.protobuf.FieldMask
	27,  // 81: google.cloud.speech.v2.StreamingRecognitionResult.alternatives:type_name -> google.cloud.speech.v2.SpeechRecognitionAlternative
	83,  // 82: google.cloud.speech.v2.StreamingRecognitionResult.result_end_offset:type_name -> google.protobuf.Duration
	50,  // 83: google.cloud.speech.v2.StreamingRecognizeResponse.results:type_name -> google.cloud.speech.v2.StreamingRecognitionResult
	4,   // 84: google.cloud.speech.v2.StreamingRecognizeResponse.speech_event_type:type_name -> google.cloud.speech.v2.StreamingRecognizeResponse.SpeechEventType
	83,  // 85: google.cloud.speech.v2.StreamingRecognizeResponse.speech_event_offset:type_name -> google.protobuf.Duration
	26,  // 86: google.cloud.speech.v2.StreamingRecognizeResponse.metadata:type_name -> google.cloud.speech.v2.RecognitionResponseMetadata
	81,  // 87: google.cloud.speech.v2.Config.update_time:type_name -> google.protobuf.Timestamp
	52,  // 88: google.cloud.speech.v2.UpdateConfigRequest.config:type_name -> google.cloud.speech.v2.Config
	82,  // 89: google.cloud.speech.v2.UpdateConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	77,  // 90: google.cloud.speech.v2.CustomClass.items:type_name -> google.cloud.speech.v2.CustomClass.ClassItem
	5,   // 91: google.cloud.speech.v2.CustomClass.state:type_name -> google.cloud.speech.v2.CustomClass.State
	81,  // 92: google.cloud.speech.v2.CustomClass.create_time:type_name -> google.protobuf.Timestamp
	81,  // 93: google.cloud.speech.v2.CustomClass.update_time:type_name -> google.protobuf.Timestamp
	81,  // 94: google.cloud.speech.v2.CustomClass.delete_time:type_name -> google.protobuf.Timestamp
	81,  // 95: google.cloud.speech.v2.CustomClass.expire_time:type_name -> google.protobuf.Timestamp
	78,  // 96: google.cloud.speech.v2.CustomClass.annotations:type_name -> google.cloud.speech.v2.CustomClass.AnnotationsEntry
	79,  // 97: google.cloud.speech.v2.PhraseSet.phrases:type_name -> google.cloud.speech.v2.PhraseSet.Phrase
	6,   // 98: google.cloud.speech.v2.PhraseSet.state:type_name -> google.cloud.speech.v2.PhraseSet.State
	81,  // 99: google.cloud.speech.v2.PhraseSet.create_time:type_name -> google.protobuf.Timestamp
	81,  // 100: google.cloud.speech.v2.PhraseSet.update_time:type_name -> google.protobuf.Timestamp
	81,  // 101: google.cloud.speech.v2.PhraseSet.delete_time:type_name -> google.protobuf.Timestamp
	81,  // 102: google.cloud.speech.v2.PhraseSet.expire_time:type_name -> google.protobuf.Timestamp
	80,  // 103: google.cloud.speech.v2.PhraseSet.annotations:type_name -> google.cloud.speech.v2.PhraseSet.AnnotationsEntry
	55,  // 104: google.cloud.speech.v2.CreateCustomClassRequest.custom_class:type_name -> google.cloud.speech.v2.CustomClass
	55,  // 105: google.cloud.speech.v2.ListCustomClassesResponse.custom_classes:type_name -> google.cloud.speech.v2.CustomClass
	55,  // 106: google.cloud.speech.v2.UpdateCustomClassRequest.custom_class:type_name -> google.cloud.speech.v2.CustomClass
	82,  // 107: google.cloud.speech.v2.UpdateCustomClassRequest.update_mask:type_name -> google.protobuf.FieldMask
	56,  // 108: google.cloud.speech.v2.CreatePhraseSetRequest.phrase_set:type_name -> google.cloud.speech.v2.PhraseSet
	56,  // 109: google.cloud.speech.v2.ListPhraseSetsResponse.phrase_sets:type_name -> google.cloud.speech.v2.PhraseSet
	56,  // 110: google.cloud.speech.v2.UpdatePhraseSetRequest.phrase_set:type_name -> google.cloud.speech.v2.PhraseSet
	82,  // 111: google.cloud.speech.v2.UpdatePhraseSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	56,  // 112: google.cloud.speech.v2.SpeechAdaptation.AdaptationPhraseSet.inline_phrase_set:type_name -> google.cloud.speech.v2.PhraseSet
	83,  // 113: google.cloud.speech.v2.StreamingRecognitionFeatures.VoiceActivityTimeout.speech_start_timeout:type_name -> google.protobuf.Duration
	83,  // 114: google.cloud.speech.v2.StreamingRecognitionFeatures.VoiceActivityTimeout.speech_end_timeout:type_name -> google.protobuf.Duration
	46,  // 115: google.cloud.speech.v2.BatchRecognizeResponse.ResultsEntry.value:type_name -> google.cloud.speech.v2.BatchRecognizeFileResult
	47,  // 116: google.cloud.speech.v2.BatchRecognizeMetadata.TranscriptionMetadataEntry.value:type_name -> google.cloud.speech.v2.BatchRecognizeTranscriptionMetadata
	7,   // 117: google.cloud.speech.v2.Speech.CreateRecognizer:input_type -> google.cloud.speech.v2.CreateRecognizerRequest
	9,   // 118: google.cloud.speech.v2.Speech.ListRecognizers:input_type -> google.cloud.speech.v2.ListRecognizersRequest
	11,  // 119: google.cloud.speech.v2.Speech.GetRecognizer:input_type -> google.cloud.speech.v2.GetRecognizerRequest
	12,  // 120: google.cloud.speech.v2.Speech.UpdateRecognizer:input_type -> google.cloud.speech.v2.UpdateRecognizerRequest
	13,  // 121: google.cloud.speech.v2.Speech.DeleteRecognizer:input_type -> google.cloud.speech.v2.DeleteRecognizerRequest
	14,  // 122: google.cloud.speech.v2.Speech.UndeleteRecognizer:input_type -> google.cloud.speech.v2.UndeleteRecognizerRequest
	25,  // 123: google.cloud.speech.v2.Speech.Recognize:input_type -> google.cloud.speech.v2.RecognizeRequest
	33,  // 124: google.cloud.speech.v2.Speech.StreamingRecognize:input_type -> google.cloud.speech.v2.StreamingRecognizeRequest
	34,  // 125: google.cloud.speech.v2.Speech.BatchRecognize:input_type -> google.cloud.speech.v2.BatchRecognizeRequest
	53,  // 126: google.cloud.speech.v2.Speech.GetConfig:input_type -> google.cloud.speech.v2.GetConfigRequest
	54,  // 127: google.cloud.speech.v2.Speech.UpdateConfig:input_type -> google.cloud.speech.v2.UpdateConfigRequest
	57,  // 128: google.cloud.speech.v2.Speech.CreateCustomClass:input_type -> google.cloud.speech.v2.CreateCustomClassRequest
	58,  // 129: google.cloud.speech.v2.Speech.ListCustomClasses:input_type -> google.cloud.speech.v2.ListCustomClassesRequest
	60,  // 130: google.cloud.speech.v2.Speech.GetCustomClass:input_type -> google.cloud.speech.v2.GetCustomClassRequest
	61,  // 131: google.cloud.speech.v2.Speech.UpdateCustomClass:input_type -> google.cloud.speech.v2.UpdateCustomClassRequest
	62,  // 132: google.cloud.speech.v2.Speech.DeleteCustomClass:input_type -> google.cloud.speech.v2.DeleteCustomClassRequest
	63,  // 133: google.cloud.speech.v2.Speech.UndeleteCustomClass:input_type -> google.cloud.speech.v2.UndeleteCustomClassRequest
	64,  // 134: google.cloud.speech.v2.Speech.CreatePhraseSet:input_type -> google.cloud.speech.v2.CreatePhraseSetRequest
	65,  // 135: google.cloud.speech.v2.Speech.ListPhraseSets:input_type -> google.cloud.speech.v2.ListPhraseSetsRequest
	67,  // 136: google.cloud.speech.v2.Speech.GetPhraseSet:input_type -> google.cloud.speech.v2.GetPhraseSetRequest
	68,  // 137: google.cloud.speech.v2.Speech.UpdatePhraseSet:input_type -> google.cloud.speech.v2.UpdatePhraseSetRequest
	69,  // 138: google.cloud.speech.v2.Speech.DeletePhraseSet:input_type -> google.cloud.speech.v2.DeletePhraseSetRequest
	70,  // 139: google.cloud.speech.v2.Speech.UndeletePhraseSet:input_type -> google.cloud.speech.v2.UndeletePhraseSetRequest
	85,  // 140: google.cloud.speech.v2.Speech.CreateRecognizer:output_type -> google.longrunning.Operation
	10,  // 141: google.cloud.speech.v2.Speech.ListRecognizers:output_type -> google.cloud.speech.v2.ListRecognizersResponse
	15,  // 142: google.cloud.speech.v2.Speech.GetRecognizer:output_type -> google.cloud.speech.v2.Recognizer
	85,  // 143: google.cloud.speech.v2.Speech.UpdateRecognizer:output_type -> google.longrunning.Operation
	85,  // 144: google.cloud.speech.v2.Speech.DeleteRecognizer:output_type -> google.longrunning.Operation
	85,  // 145: google.cloud.speech.v2.Speech.UndeleteRecognizer:output_type -> google.longrunning.Operation
	30,  // 146: google.cloud.speech.v2.Speech.Recognize:output_type -> google.cloud.speech.v2.RecognizeResponse
	51,  // 147: google.cloud.speech.v2.Speech.StreamingRecognize:output_type -> google.cloud.speech.v2.StreamingRecognizeResponse
	85,  // 148: google.cloud.speech.v2.Speech.BatchRecognize:output_type -> google.longrunning.Operation
	52,  // 149: google.cloud.speech.v2.Speech.GetConfig:output_type -> google.cloud.speech.v2.Config
	52,  // 150: google.cloud.speech.v2.Speech.UpdateConfig:output_type -> google.cloud.speech.v2.Config
	85,  // 151: google.cloud.speech.v2.Speech.CreateCustomClass:output_type -> google.longrunning.Operation
	59,  // 152: google.cloud.speech.v2.Speech.ListCustomClasses:output_type -> google.cloud.speech.v2.ListCustomClassesResponse
	55,  // 153: google.cloud.speech.v2.Speech.GetCustomClass:output_type -> google.cloud.speech.v2.CustomClass
	85,  // 154: google.cloud.speech.v2.Speech.UpdateCustomClass:output_type -> google.longrunning.Operation
	85,  // 155: google.cloud.speech.v2.Speech.DeleteCustomClass:output_type -> google.longrunning.Operation
	85,  // 156: google.cloud.speech.v2.Speech.UndeleteCustomClass:output_type -> google.longrunning.Operation
	85,  // 157: google.cloud.speech.v2.Speech.CreatePhraseSet:output_type -> google.longrunning.Operation
	66,  // 158: google.cloud.speech.v2.Speech.ListPhraseSets:output_type -> google.cloud.speech.v2.ListPhraseSetsResponse
	56,  // 159: google.cloud.speech.v2.Speech.GetPhraseSet:output_type -> google.cloud.speech.v2.PhraseSet
	85,  // 160: google.cloud.speech.v2.Speech.UpdatePhraseSet:output_type -> google.longrunning.Operation
	85,  // 161: google.cloud.speech.v2.Speech.DeletePhraseSet:output_type -> google.longrunning.Operation
	85,  // 162: google.cloud.speech.v2.Speech.UndeletePhraseSet:output_type -> google.longrunning.Operation
	140, // [140:163] is the sub-list for method output_type
	117, // [117:140] is the sub-list for method input_type
	117, // [117:117] is the sub-list for extension type_name
	117, // [117:117] is the sub-list for extension extendee
	0,   // [0:117] is the sub-list for field type_name
}

func init() { file_google_cloud_speech_v2_cloud_speech_proto_init() }
func file_google_cloud_speech_v2_cloud_speech_proto_init() {
	if File_google_cloud_speech_v2_cloud_speech_proto != nil {
		return
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[1].OneofWrappers = []any{
		(*OperationMetadata_BatchRecognizeRequest)(nil),
		(*OperationMetadata_CreateRecognizerRequest)(nil),
		(*OperationMetadata_UpdateRecognizerRequest)(nil),
		(*OperationMetadata_DeleteRecognizerRequest)(nil),
		(*OperationMetadata_UndeleteRecognizerRequest)(nil),
		(*OperationMetadata_CreateCustomClassRequest)(nil),
		(*OperationMetadata_UpdateCustomClassRequest)(nil),
		(*OperationMetadata_DeleteCustomClassRequest)(nil),
		(*OperationMetadata_UndeleteCustomClassRequest)(nil),
		(*OperationMetadata_CreatePhraseSetRequest)(nil),
		(*OperationMetadata_UpdatePhraseSetRequest)(nil),
		(*OperationMetadata_DeletePhraseSetRequest)(nil),
		(*OperationMetadata_UndeletePhraseSetRequest)(nil),
		(*OperationMetadata_UpdateConfigRequest)(nil),
		(*OperationMetadata_BatchRecognizeMetadata)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[17].OneofWrappers = []any{
		(*RecognitionConfig_AutoDecodingConfig)(nil),
		(*RecognitionConfig_ExplicitDecodingConfig)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[18].OneofWrappers = []any{
		(*RecognizeRequest_Content)(nil),
		(*RecognizeRequest_Uri)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[26].OneofWrappers = []any{
		(*StreamingRecognizeRequest_StreamingConfig)(nil),
		(*StreamingRecognizeRequest_Audio)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[34].OneofWrappers = []any{
		(*RecognitionOutputConfig_GcsOutputConfig)(nil),
		(*RecognitionOutputConfig_InlineResponseConfig)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[39].OneofWrappers = []any{
		(*BatchRecognizeFileResult_CloudStorageResult)(nil),
		(*BatchRecognizeFileResult_InlineResult)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[42].OneofWrappers = []any{
		(*BatchRecognizeFileMetadata_Uri)(nil),
	}
	file_google_cloud_speech_v2_cloud_speech_proto_msgTypes[66].OneofWrappers = []any{
		(*SpeechAdaptation_AdaptationPhraseSet_PhraseSet)(nil),
		(*SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_speech_v2_cloud_speech_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   74,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_speech_v2_cloud_speech_proto_goTypes,
		DependencyIndexes: file_google_cloud_speech_v2_cloud_speech_proto_depIdxs,
		EnumInfos:         file_google_cloud_speech_v2_cloud_speech_proto_enumTypes,
		MessageInfos:      file_google_cloud_speech_v2_cloud_speech_proto_msgTypes,
	}.Build()
	File_google_cloud_speech_v2_cloud_speech_proto = out.File
	file_google_cloud_speech_v2_cloud_speech_proto_rawDesc = nil
	file_google_cloud_speech_v2_cloud_speech_proto_goTypes = nil
	file_google_cloud_speech_v2_cloud_speech_proto_depIdxs = nil
}
