// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/billing/v1/cloud_catalog.proto

package billingpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The level at which usage is aggregated to compute cost.
// Example: "ACCOUNT" aggregation level indicates that usage for tiered
// pricing is aggregated across all projects in a single account.
type AggregationInfo_AggregationLevel int32

const (
	AggregationInfo_AGGREGATION_LEVEL_UNSPECIFIED AggregationInfo_AggregationLevel = 0
	AggregationInfo_ACCOUNT                       AggregationInfo_AggregationLevel = 1
	AggregationInfo_PROJECT                       AggregationInfo_AggregationLevel = 2
)

// Enum value maps for AggregationInfo_AggregationLevel.
var (
	AggregationInfo_AggregationLevel_name = map[int32]string{
		0: "AGGREGATION_LEVEL_UNSPECIFIED",
		1: "ACCOUNT",
		2: "PROJECT",
	}
	AggregationInfo_AggregationLevel_value = map[string]int32{
		"AGGREGATION_LEVEL_UNSPECIFIED": 0,
		"ACCOUNT":                       1,
		"PROJECT":                       2,
	}
)

func (x AggregationInfo_AggregationLevel) Enum() *AggregationInfo_AggregationLevel {
	p := new(AggregationInfo_AggregationLevel)
	*p = x
	return p
}

func (x AggregationInfo_AggregationLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregationInfo_AggregationLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes[0].Descriptor()
}

func (AggregationInfo_AggregationLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes[0]
}

func (x AggregationInfo_AggregationLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregationInfo_AggregationLevel.Descriptor instead.
func (AggregationInfo_AggregationLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{5, 0}
}

// The interval at which usage is aggregated to compute cost.
// Example: "MONTHLY" aggregation interval indicates that usage for tiered
// pricing is aggregated every month.
type AggregationInfo_AggregationInterval int32

const (
	AggregationInfo_AGGREGATION_INTERVAL_UNSPECIFIED AggregationInfo_AggregationInterval = 0
	AggregationInfo_DAILY                            AggregationInfo_AggregationInterval = 1
	AggregationInfo_MONTHLY                          AggregationInfo_AggregationInterval = 2
)

// Enum value maps for AggregationInfo_AggregationInterval.
var (
	AggregationInfo_AggregationInterval_name = map[int32]string{
		0: "AGGREGATION_INTERVAL_UNSPECIFIED",
		1: "DAILY",
		2: "MONTHLY",
	}
	AggregationInfo_AggregationInterval_value = map[string]int32{
		"AGGREGATION_INTERVAL_UNSPECIFIED": 0,
		"DAILY":                            1,
		"MONTHLY":                          2,
	}
)

func (x AggregationInfo_AggregationInterval) Enum() *AggregationInfo_AggregationInterval {
	p := new(AggregationInfo_AggregationInterval)
	*p = x
	return p
}

func (x AggregationInfo_AggregationInterval) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregationInfo_AggregationInterval) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes[1].Descriptor()
}

func (AggregationInfo_AggregationInterval) Type() protoreflect.EnumType {
	return &file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes[1]
}

func (x AggregationInfo_AggregationInterval) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregationInfo_AggregationInterval.Descriptor instead.
func (AggregationInfo_AggregationInterval) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{5, 1}
}

// The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
type GeoTaxonomy_Type int32

const (
	// The type is not specified.
	GeoTaxonomy_TYPE_UNSPECIFIED GeoTaxonomy_Type = 0
	// The sku is global in nature, e.g. a license sku. Global skus are
	// available in all regions, and so have an empty region list.
	GeoTaxonomy_GLOBAL GeoTaxonomy_Type = 1
	// The sku is available in a specific region, e.g. "us-west2".
	GeoTaxonomy_REGIONAL GeoTaxonomy_Type = 2
	// The sku is associated with multiple regions, e.g. "us-west2" and
	// "us-east1".
	GeoTaxonomy_MULTI_REGIONAL GeoTaxonomy_Type = 3
)

// Enum value maps for GeoTaxonomy_Type.
var (
	GeoTaxonomy_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GLOBAL",
		2: "REGIONAL",
		3: "MULTI_REGIONAL",
	}
	GeoTaxonomy_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"GLOBAL":           1,
		"REGIONAL":         2,
		"MULTI_REGIONAL":   3,
	}
)

func (x GeoTaxonomy_Type) Enum() *GeoTaxonomy_Type {
	p := new(GeoTaxonomy_Type)
	*p = x
	return p
}

func (x GeoTaxonomy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GeoTaxonomy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes[2].Descriptor()
}

func (GeoTaxonomy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes[2]
}

func (x GeoTaxonomy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GeoTaxonomy_Type.Descriptor instead.
func (GeoTaxonomy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{6, 0}
}

// Encapsulates a single service in Google Cloud Platform.
type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the service.
	// Example: "services/6F81-5844-456A"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The identifier for the service.
	// Example: "6F81-5844-456A"
	ServiceId string `protobuf:"bytes,2,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// A human readable display name for this service.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The business under which the service is offered.
	// Ex. "businessEntities/GCP", "businessEntities/Maps"
	BusinessEntityName string `protobuf:"bytes,4,opt,name=business_entity_name,json=businessEntityName,proto3" json:"business_entity_name,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{0}
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *Service) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Service) GetBusinessEntityName() string {
	if x != nil {
		return x.BusinessEntityName
	}
	return ""
}

// Encapsulates a single SKU in Google Cloud
type Sku struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the SKU.
	// Example: "services/6F81-5844-456A/skus/D041-B8A1-6E0B"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The identifier for the SKU.
	// Example: "D041-B8A1-6E0B"
	SkuId string `protobuf:"bytes,2,opt,name=sku_id,json=skuId,proto3" json:"sku_id,omitempty"`
	// A human readable description of the SKU, has a maximum length of 256
	// characters.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The category hierarchy of this SKU, purely for organizational purpose.
	Category *Category `protobuf:"bytes,4,opt,name=category,proto3" json:"category,omitempty"`
	// List of service regions this SKU is offered at.
	// Example: "asia-east1"
	// Service regions can be found at https://cloud.google.com/about/locations/
	ServiceRegions []string `protobuf:"bytes,5,rep,name=service_regions,json=serviceRegions,proto3" json:"service_regions,omitempty"`
	// A timeline of pricing info for this SKU in chronological order.
	PricingInfo []*PricingInfo `protobuf:"bytes,6,rep,name=pricing_info,json=pricingInfo,proto3" json:"pricing_info,omitempty"`
	// Identifies the service provider.
	// This is 'Google' for first party services in Google Cloud Platform.
	ServiceProviderName string `protobuf:"bytes,7,opt,name=service_provider_name,json=serviceProviderName,proto3" json:"service_provider_name,omitempty"`
	// The geographic taxonomy for this sku.
	GeoTaxonomy *GeoTaxonomy `protobuf:"bytes,8,opt,name=geo_taxonomy,json=geoTaxonomy,proto3" json:"geo_taxonomy,omitempty"`
}

func (x *Sku) Reset() {
	*x = Sku{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sku) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sku) ProtoMessage() {}

func (x *Sku) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sku.ProtoReflect.Descriptor instead.
func (*Sku) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{1}
}

func (x *Sku) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Sku) GetSkuId() string {
	if x != nil {
		return x.SkuId
	}
	return ""
}

func (x *Sku) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Sku) GetCategory() *Category {
	if x != nil {
		return x.Category
	}
	return nil
}

func (x *Sku) GetServiceRegions() []string {
	if x != nil {
		return x.ServiceRegions
	}
	return nil
}

func (x *Sku) GetPricingInfo() []*PricingInfo {
	if x != nil {
		return x.PricingInfo
	}
	return nil
}

func (x *Sku) GetServiceProviderName() string {
	if x != nil {
		return x.ServiceProviderName
	}
	return ""
}

func (x *Sku) GetGeoTaxonomy() *GeoTaxonomy {
	if x != nil {
		return x.GeoTaxonomy
	}
	return nil
}

// Represents the category hierarchy of a SKU.
type Category struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display name of the service this SKU belongs to.
	ServiceDisplayName string `protobuf:"bytes,1,opt,name=service_display_name,json=serviceDisplayName,proto3" json:"service_display_name,omitempty"`
	// The type of product the SKU refers to.
	// Example: "Compute", "Storage", "Network", "ApplicationServices" etc.
	ResourceFamily string `protobuf:"bytes,2,opt,name=resource_family,json=resourceFamily,proto3" json:"resource_family,omitempty"`
	// A group classification for related SKUs.
	// Example: "RAM", "GPU", "Prediction", "Ops", "GoogleEgress" etc.
	ResourceGroup string `protobuf:"bytes,3,opt,name=resource_group,json=resourceGroup,proto3" json:"resource_group,omitempty"`
	// Represents how the SKU is consumed.
	// Example: "OnDemand", "Preemptible", "Commit1Mo", "Commit1Yr" etc.
	UsageType string `protobuf:"bytes,4,opt,name=usage_type,json=usageType,proto3" json:"usage_type,omitempty"`
}

func (x *Category) Reset() {
	*x = Category{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Category) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Category) ProtoMessage() {}

func (x *Category) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Category.ProtoReflect.Descriptor instead.
func (*Category) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{2}
}

func (x *Category) GetServiceDisplayName() string {
	if x != nil {
		return x.ServiceDisplayName
	}
	return ""
}

func (x *Category) GetResourceFamily() string {
	if x != nil {
		return x.ResourceFamily
	}
	return ""
}

func (x *Category) GetResourceGroup() string {
	if x != nil {
		return x.ResourceGroup
	}
	return ""
}

func (x *Category) GetUsageType() string {
	if x != nil {
		return x.UsageType
	}
	return ""
}

// Represents the pricing information for a SKU at a single point of time.
type PricingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp from which this pricing was effective within the requested
	// time range. This is guaranteed to be greater than or equal to the
	// start_time field in the request and less than the end_time field in the
	// request. If a time range was not specified in the request this field will
	// be equivalent to a time within the last 12 hours, indicating the latest
	// pricing info.
	EffectiveTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=effective_time,json=effectiveTime,proto3" json:"effective_time,omitempty"`
	// An optional human readable summary of the pricing information, has a
	// maximum length of 256 characters.
	Summary string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	// Expresses the pricing formula. See `PricingExpression` for an example.
	PricingExpression *PricingExpression `protobuf:"bytes,3,opt,name=pricing_expression,json=pricingExpression,proto3" json:"pricing_expression,omitempty"`
	// Aggregation Info. This can be left unspecified if the pricing expression
	// doesn't require aggregation.
	AggregationInfo *AggregationInfo `protobuf:"bytes,4,opt,name=aggregation_info,json=aggregationInfo,proto3" json:"aggregation_info,omitempty"`
	// Conversion rate used for currency conversion, from USD to the currency
	// specified in the request. This includes any surcharge collected for billing
	// in non USD currency. If a currency is not specified in the request this
	// defaults to 1.0.
	// Example: USD * currency_conversion_rate = JPY
	CurrencyConversionRate float64 `protobuf:"fixed64,5,opt,name=currency_conversion_rate,json=currencyConversionRate,proto3" json:"currency_conversion_rate,omitempty"`
}

func (x *PricingInfo) Reset() {
	*x = PricingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PricingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PricingInfo) ProtoMessage() {}

func (x *PricingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PricingInfo.ProtoReflect.Descriptor instead.
func (*PricingInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{3}
}

func (x *PricingInfo) GetEffectiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EffectiveTime
	}
	return nil
}

func (x *PricingInfo) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *PricingInfo) GetPricingExpression() *PricingExpression {
	if x != nil {
		return x.PricingExpression
	}
	return nil
}

func (x *PricingInfo) GetAggregationInfo() *AggregationInfo {
	if x != nil {
		return x.AggregationInfo
	}
	return nil
}

func (x *PricingInfo) GetCurrencyConversionRate() float64 {
	if x != nil {
		return x.CurrencyConversionRate
	}
	return 0
}

// Expresses a mathematical pricing formula. For Example:-
//
// `usage_unit: GBy`
// `tiered_rates:`
//
//	`[start_usage_amount: 20, unit_price: $10]`
//	`[start_usage_amount: 100, unit_price: $5]`
//
// The above expresses a pricing formula where the first 20GB is free, the
// next 80GB is priced at $10 per GB followed by $5 per GB for additional
// usage.
type PricingExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short hand for unit of usage this pricing is specified in.
	// Example: usage_unit of "GiBy" means that usage is specified in "Gibi Byte".
	UsageUnit string `protobuf:"bytes,1,opt,name=usage_unit,json=usageUnit,proto3" json:"usage_unit,omitempty"`
	// The recommended quantity of units for displaying pricing info. When
	// displaying pricing info it is recommended to display:
	// (unit_price * display_quantity) per display_quantity usage_unit.
	// This field does not affect the pricing formula and is for display purposes
	// only.
	// Example: If the unit_price is "0.0001 USD", the usage_unit is "GB" and
	// the display_quantity is "1000" then the recommended way of displaying the
	// pricing info is "0.10 USD per 1000 GB"
	DisplayQuantity float64 `protobuf:"fixed64,2,opt,name=display_quantity,json=displayQuantity,proto3" json:"display_quantity,omitempty"`
	// The list of tiered rates for this pricing. The total cost is computed by
	// applying each of the tiered rates on usage. This repeated list is sorted
	// by ascending order of start_usage_amount.
	TieredRates []*PricingExpression_TierRate `protobuf:"bytes,3,rep,name=tiered_rates,json=tieredRates,proto3" json:"tiered_rates,omitempty"`
	// The unit of usage in human readable form.
	// Example: "gibi byte".
	UsageUnitDescription string `protobuf:"bytes,4,opt,name=usage_unit_description,json=usageUnitDescription,proto3" json:"usage_unit_description,omitempty"`
	// The base unit for the SKU which is the unit used in usage exports.
	// Example: "By"
	BaseUnit string `protobuf:"bytes,5,opt,name=base_unit,json=baseUnit,proto3" json:"base_unit,omitempty"`
	// The base unit in human readable form.
	// Example: "byte".
	BaseUnitDescription string `protobuf:"bytes,6,opt,name=base_unit_description,json=baseUnitDescription,proto3" json:"base_unit_description,omitempty"`
	// Conversion factor for converting from price per usage_unit to price per
	// base_unit, and start_usage_amount to start_usage_amount in base_unit.
	// unit_price / base_unit_conversion_factor = price per base_unit.
	// start_usage_amount * base_unit_conversion_factor = start_usage_amount in
	// base_unit.
	BaseUnitConversionFactor float64 `protobuf:"fixed64,7,opt,name=base_unit_conversion_factor,json=baseUnitConversionFactor,proto3" json:"base_unit_conversion_factor,omitempty"`
}

func (x *PricingExpression) Reset() {
	*x = PricingExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PricingExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PricingExpression) ProtoMessage() {}

func (x *PricingExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PricingExpression.ProtoReflect.Descriptor instead.
func (*PricingExpression) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{4}
}

func (x *PricingExpression) GetUsageUnit() string {
	if x != nil {
		return x.UsageUnit
	}
	return ""
}

func (x *PricingExpression) GetDisplayQuantity() float64 {
	if x != nil {
		return x.DisplayQuantity
	}
	return 0
}

func (x *PricingExpression) GetTieredRates() []*PricingExpression_TierRate {
	if x != nil {
		return x.TieredRates
	}
	return nil
}

func (x *PricingExpression) GetUsageUnitDescription() string {
	if x != nil {
		return x.UsageUnitDescription
	}
	return ""
}

func (x *PricingExpression) GetBaseUnit() string {
	if x != nil {
		return x.BaseUnit
	}
	return ""
}

func (x *PricingExpression) GetBaseUnitDescription() string {
	if x != nil {
		return x.BaseUnitDescription
	}
	return ""
}

func (x *PricingExpression) GetBaseUnitConversionFactor() float64 {
	if x != nil {
		return x.BaseUnitConversionFactor
	}
	return 0
}

// Represents the aggregation level and interval for pricing of a single SKU.
type AggregationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AggregationLevel    AggregationInfo_AggregationLevel    `protobuf:"varint,1,opt,name=aggregation_level,json=aggregationLevel,proto3,enum=google.cloud.billing.v1.AggregationInfo_AggregationLevel" json:"aggregation_level,omitempty"`
	AggregationInterval AggregationInfo_AggregationInterval `protobuf:"varint,2,opt,name=aggregation_interval,json=aggregationInterval,proto3,enum=google.cloud.billing.v1.AggregationInfo_AggregationInterval" json:"aggregation_interval,omitempty"`
	// The number of intervals to aggregate over.
	// Example: If aggregation_level is "DAILY" and aggregation_count is 14,
	// aggregation will be over 14 days.
	AggregationCount int32 `protobuf:"varint,3,opt,name=aggregation_count,json=aggregationCount,proto3" json:"aggregation_count,omitempty"`
}

func (x *AggregationInfo) Reset() {
	*x = AggregationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregationInfo) ProtoMessage() {}

func (x *AggregationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregationInfo.ProtoReflect.Descriptor instead.
func (*AggregationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{5}
}

func (x *AggregationInfo) GetAggregationLevel() AggregationInfo_AggregationLevel {
	if x != nil {
		return x.AggregationLevel
	}
	return AggregationInfo_AGGREGATION_LEVEL_UNSPECIFIED
}

func (x *AggregationInfo) GetAggregationInterval() AggregationInfo_AggregationInterval {
	if x != nil {
		return x.AggregationInterval
	}
	return AggregationInfo_AGGREGATION_INTERVAL_UNSPECIFIED
}

func (x *AggregationInfo) GetAggregationCount() int32 {
	if x != nil {
		return x.AggregationCount
	}
	return 0
}

// Encapsulates the geographic taxonomy data for a sku.
type GeoTaxonomy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of Geo Taxonomy: GLOBAL, REGIONAL, or MULTI_REGIONAL.
	Type GeoTaxonomy_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.billing.v1.GeoTaxonomy_Type" json:"type,omitempty"`
	// The list of regions associated with a sku. Empty for Global skus, which are
	// associated with all Google Cloud regions.
	Regions []string `protobuf:"bytes,2,rep,name=regions,proto3" json:"regions,omitempty"`
}

func (x *GeoTaxonomy) Reset() {
	*x = GeoTaxonomy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GeoTaxonomy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeoTaxonomy) ProtoMessage() {}

func (x *GeoTaxonomy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeoTaxonomy.ProtoReflect.Descriptor instead.
func (*GeoTaxonomy) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{6}
}

func (x *GeoTaxonomy) GetType() GeoTaxonomy_Type {
	if x != nil {
		return x.Type
	}
	return GeoTaxonomy_TYPE_UNSPECIFIED
}

func (x *GeoTaxonomy) GetRegions() []string {
	if x != nil {
		return x.Regions
	}
	return nil
}

// Request message for `ListServices`.
type ListServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Requested page size. Defaults to 5000.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to return. This should be a
	// `next_page_token` value returned from a previous `ListServices`
	// call. If unspecified, the first page of results is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListServicesRequest) Reset() {
	*x = ListServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesRequest) ProtoMessage() {}

func (x *ListServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesRequest.ProtoReflect.Descriptor instead.
func (*ListServicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{7}
}

func (x *ListServicesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServicesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `ListServices`.
type ListServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of services.
	Services []*Service `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListServices` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServicesResponse) Reset() {
	*x = ListServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServicesResponse) ProtoMessage() {}

func (x *ListServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServicesResponse.ProtoReflect.Descriptor instead.
func (*ListServicesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{8}
}

func (x *ListServicesResponse) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *ListServicesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `ListSkus`.
type ListSkusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the service.
	// Example: "services/6F81-5844-456A"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional inclusive start time of the time range for which the pricing
	// versions will be returned. Timestamps in the future are not allowed.
	// The time range has to be within a single calendar month in
	// America/Los_Angeles timezone. Time range as a whole is optional. If not
	// specified, the latest pricing will be returned (up to 12 hours old at
	// most).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional exclusive end time of the time range for which the pricing
	// versions will be returned. Timestamps in the future are not allowed.
	// The time range has to be within a single calendar month in
	// America/Los_Angeles timezone. Time range as a whole is optional. If not
	// specified, the latest pricing will be returned (up to 12 hours old at
	// most).
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The ISO 4217 currency code for the pricing info in the response proto.
	// Will use the conversion rate as of start_time.
	// Optional. If not specified USD will be used.
	CurrencyCode string `protobuf:"bytes,4,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Requested page size. Defaults to 5000.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results to return. This should be a
	// `next_page_token` value returned from a previous `ListSkus`
	// call. If unspecified, the first page of results is returned.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSkusRequest) Reset() {
	*x = ListSkusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkusRequest) ProtoMessage() {}

func (x *ListSkusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkusRequest.ProtoReflect.Descriptor instead.
func (*ListSkusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{9}
}

func (x *ListSkusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSkusRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ListSkusRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ListSkusRequest) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *ListSkusRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSkusRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `ListSkus`.
type ListSkusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of public SKUs of the given service.
	Skus []*Sku `protobuf:"bytes,1,rep,name=skus,proto3" json:"skus,omitempty"`
	// A token to retrieve the next page of results. To retrieve the next page,
	// call `ListSkus` again with the `page_token` field set to this
	// value. This field is empty if there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSkusResponse) Reset() {
	*x = ListSkusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSkusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSkusResponse) ProtoMessage() {}

func (x *ListSkusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSkusResponse.ProtoReflect.Descriptor instead.
func (*ListSkusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{10}
}

func (x *ListSkusResponse) GetSkus() []*Sku {
	if x != nil {
		return x.Skus
	}
	return nil
}

func (x *ListSkusResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The price rate indicating starting usage and its corresponding price.
type PricingExpression_TierRate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Usage is priced at this rate only after this amount.
	// Example: start_usage_amount of 10 indicates that the usage will be priced
	// at the unit_price after the first 10 usage_units.
	StartUsageAmount float64 `protobuf:"fixed64,1,opt,name=start_usage_amount,json=startUsageAmount,proto3" json:"start_usage_amount,omitempty"`
	// The price per unit of usage.
	// Example: unit_price of amount $10 indicates that each unit will cost $10.
	UnitPrice *money.Money `protobuf:"bytes,2,opt,name=unit_price,json=unitPrice,proto3" json:"unit_price,omitempty"`
}

func (x *PricingExpression_TierRate) Reset() {
	*x = PricingExpression_TierRate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PricingExpression_TierRate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PricingExpression_TierRate) ProtoMessage() {}

func (x *PricingExpression_TierRate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PricingExpression_TierRate.ProtoReflect.Descriptor instead.
func (*PricingExpression_TierRate) Descriptor() ([]byte, []int) {
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP(), []int{4, 0}
}

func (x *PricingExpression_TierRate) GetStartUsageAmount() float64 {
	if x != nil {
		return x.StartUsageAmount
	}
	return 0
}

func (x *PricingExpression_TierRate) GetUnitPrice() *money.Money {
	if x != nil {
		return x.UnitPrice
	}
	return nil
}

var File_google_cloud_billing_v1_cloud_catalog_proto protoreflect.FileDescriptor

var file_google_cloud_billing_v1_cloud_catalog_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xcf, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x3c, 0xea, 0x41, 0x39, 0x0a, 0x23, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x7d, 0x22, 0xc5, 0x03, 0x0a, 0x03, 0x53, 0x6b, 0x75, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x15, 0x0a, 0x06, 0x73, 0x6b, 0x75, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x73, 0x6b, 0x75, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52,
	0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x47, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x15, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x0c, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x52, 0x0b, 0x67, 0x65, 0x6f,
	0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x3a, 0x43, 0xea, 0x41, 0x40, 0x0a, 0x1f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6b, 0x75, 0x12, 0x1d,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x7d, 0x2f, 0x73, 0x6b, 0x75, 0x73, 0x2f, 0x7b, 0x73, 0x6b, 0x75, 0x7d, 0x22, 0xab, 0x01,
	0x0a, 0x08, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46,
	0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a,
	0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x75, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xd4, 0x02, 0x0a, 0x0b,
	0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x41, 0x0a, 0x0e, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0d, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x59, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x11, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x18, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x16, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x61,
	0x74, 0x65, 0x22, 0xe8, 0x03, 0x0a, 0x11, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x45, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x56, 0x0a, 0x0c, 0x74, 0x69, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x52, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x74,
	0x69, 0x65, 0x72, 0x65, 0x64, 0x52, 0x61, 0x74, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x75, 0x73, 0x61, 0x67,
	0x65, 0x55, 0x6e, 0x69, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x61, 0x73, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x32, 0x0a,
	0x15, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x62, 0x61,
	0x73, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3d, 0x0a, 0x1b, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x52, 0x18, 0x62, 0x61, 0x73, 0x65, 0x55, 0x6e, 0x69, 0x74,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x1a, 0x6b, 0x0a, 0x08, 0x54, 0x69, 0x65, 0x72, 0x52, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x12,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x55,
	0x73, 0x61, 0x67, 0x65, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x0a, 0x75, 0x6e,
	0x69, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e,
	0x65, 0x79, 0x52, 0x09, 0x75, 0x6e, 0x69, 0x74, 0x50, 0x72, 0x69, 0x63, 0x65, 0x22, 0xbd, 0x03,
	0x0a, 0x0f, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x66, 0x0a, 0x11, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x6f, 0x0a, 0x14, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x13, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x4f, 0x0a, 0x10, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x1d, 0x41,
	0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x02, 0x22, 0x53, 0x0a, 0x13, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12,
	0x24, 0x0a, 0x20, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x56, 0x41, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x02, 0x22, 0xb2, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x12, 0x3d, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d,
	0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x4a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c,
	0x10, 0x03, 0x22, 0x51, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7c, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a,
	0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xa9, 0x02, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x6c, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x52,
	0x04, 0x73, 0x6b, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xde, 0x03,
	0x0a, 0x0c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x84,
	0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x17, 0xda, 0x41,
	0x00, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0e, 0x12, 0x0c, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b,
	0x75, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x6b, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6b, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x6b, 0x75, 0x73, 0x1a, 0xb5, 0x01, 0xca, 0x41, 0x1b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x93, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x8d,
	0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x11,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62,
	0x3b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x62, 0xa2, 0x02, 0x07, 0x43, 0x4c, 0x44,
	0x43, 0x54, 0x4c, 0x47, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_billing_v1_cloud_catalog_proto_rawDescOnce sync.Once
	file_google_cloud_billing_v1_cloud_catalog_proto_rawDescData = file_google_cloud_billing_v1_cloud_catalog_proto_rawDesc
)

func file_google_cloud_billing_v1_cloud_catalog_proto_rawDescGZIP() []byte {
	file_google_cloud_billing_v1_cloud_catalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_billing_v1_cloud_catalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_billing_v1_cloud_catalog_proto_rawDescData)
	})
	return file_google_cloud_billing_v1_cloud_catalog_proto_rawDescData
}

var file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_billing_v1_cloud_catalog_proto_goTypes = []any{
	(AggregationInfo_AggregationLevel)(0),    // 0: google.cloud.billing.v1.AggregationInfo.AggregationLevel
	(AggregationInfo_AggregationInterval)(0), // 1: google.cloud.billing.v1.AggregationInfo.AggregationInterval
	(GeoTaxonomy_Type)(0),                    // 2: google.cloud.billing.v1.GeoTaxonomy.Type
	(*Service)(nil),                          // 3: google.cloud.billing.v1.Service
	(*Sku)(nil),                              // 4: google.cloud.billing.v1.Sku
	(*Category)(nil),                         // 5: google.cloud.billing.v1.Category
	(*PricingInfo)(nil),                      // 6: google.cloud.billing.v1.PricingInfo
	(*PricingExpression)(nil),                // 7: google.cloud.billing.v1.PricingExpression
	(*AggregationInfo)(nil),                  // 8: google.cloud.billing.v1.AggregationInfo
	(*GeoTaxonomy)(nil),                      // 9: google.cloud.billing.v1.GeoTaxonomy
	(*ListServicesRequest)(nil),              // 10: google.cloud.billing.v1.ListServicesRequest
	(*ListServicesResponse)(nil),             // 11: google.cloud.billing.v1.ListServicesResponse
	(*ListSkusRequest)(nil),                  // 12: google.cloud.billing.v1.ListSkusRequest
	(*ListSkusResponse)(nil),                 // 13: google.cloud.billing.v1.ListSkusResponse
	(*PricingExpression_TierRate)(nil),       // 14: google.cloud.billing.v1.PricingExpression.TierRate
	(*timestamppb.Timestamp)(nil),            // 15: google.protobuf.Timestamp
	(*money.Money)(nil),                      // 16: google.type.Money
}
var file_google_cloud_billing_v1_cloud_catalog_proto_depIdxs = []int32{
	5,  // 0: google.cloud.billing.v1.Sku.category:type_name -> google.cloud.billing.v1.Category
	6,  // 1: google.cloud.billing.v1.Sku.pricing_info:type_name -> google.cloud.billing.v1.PricingInfo
	9,  // 2: google.cloud.billing.v1.Sku.geo_taxonomy:type_name -> google.cloud.billing.v1.GeoTaxonomy
	15, // 3: google.cloud.billing.v1.PricingInfo.effective_time:type_name -> google.protobuf.Timestamp
	7,  // 4: google.cloud.billing.v1.PricingInfo.pricing_expression:type_name -> google.cloud.billing.v1.PricingExpression
	8,  // 5: google.cloud.billing.v1.PricingInfo.aggregation_info:type_name -> google.cloud.billing.v1.AggregationInfo
	14, // 6: google.cloud.billing.v1.PricingExpression.tiered_rates:type_name -> google.cloud.billing.v1.PricingExpression.TierRate
	0,  // 7: google.cloud.billing.v1.AggregationInfo.aggregation_level:type_name -> google.cloud.billing.v1.AggregationInfo.AggregationLevel
	1,  // 8: google.cloud.billing.v1.AggregationInfo.aggregation_interval:type_name -> google.cloud.billing.v1.AggregationInfo.AggregationInterval
	2,  // 9: google.cloud.billing.v1.GeoTaxonomy.type:type_name -> google.cloud.billing.v1.GeoTaxonomy.Type
	3,  // 10: google.cloud.billing.v1.ListServicesResponse.services:type_name -> google.cloud.billing.v1.Service
	15, // 11: google.cloud.billing.v1.ListSkusRequest.start_time:type_name -> google.protobuf.Timestamp
	15, // 12: google.cloud.billing.v1.ListSkusRequest.end_time:type_name -> google.protobuf.Timestamp
	4,  // 13: google.cloud.billing.v1.ListSkusResponse.skus:type_name -> google.cloud.billing.v1.Sku
	16, // 14: google.cloud.billing.v1.PricingExpression.TierRate.unit_price:type_name -> google.type.Money
	10, // 15: google.cloud.billing.v1.CloudCatalog.ListServices:input_type -> google.cloud.billing.v1.ListServicesRequest
	12, // 16: google.cloud.billing.v1.CloudCatalog.ListSkus:input_type -> google.cloud.billing.v1.ListSkusRequest
	11, // 17: google.cloud.billing.v1.CloudCatalog.ListServices:output_type -> google.cloud.billing.v1.ListServicesResponse
	13, // 18: google.cloud.billing.v1.CloudCatalog.ListSkus:output_type -> google.cloud.billing.v1.ListSkusResponse
	17, // [17:19] is the sub-list for method output_type
	15, // [15:17] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_billing_v1_cloud_catalog_proto_init() }
func file_google_cloud_billing_v1_cloud_catalog_proto_init() {
	if File_google_cloud_billing_v1_cloud_catalog_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Sku); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*Category); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*PricingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*PricingExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*AggregationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*GeoTaxonomy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ListServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ListServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ListSkusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ListSkusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*PricingExpression_TierRate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_billing_v1_cloud_catalog_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_billing_v1_cloud_catalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_billing_v1_cloud_catalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_billing_v1_cloud_catalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_billing_v1_cloud_catalog_proto_msgTypes,
	}.Build()
	File_google_cloud_billing_v1_cloud_catalog_proto = out.File
	file_google_cloud_billing_v1_cloud_catalog_proto_rawDesc = nil
	file_google_cloud_billing_v1_cloud_catalog_proto_goTypes = nil
	file_google_cloud_billing_v1_cloud_catalog_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudCatalogClient is the client API for CloudCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudCatalogClient interface {
	// Lists all public cloud services.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Lists all publicly available SKUs for a given cloud service.
	ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error)
}

type cloudCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudCatalogClient(cc grpc.ClientConnInterface) CloudCatalogClient {
	return &cloudCatalogClient{cc}
}

func (c *cloudCatalogClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudCatalog/ListServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudCatalogClient) ListSkus(ctx context.Context, in *ListSkusRequest, opts ...grpc.CallOption) (*ListSkusResponse, error) {
	out := new(ListSkusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.billing.v1.CloudCatalog/ListSkus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudCatalogServer is the server API for CloudCatalog service.
type CloudCatalogServer interface {
	// Lists all public cloud services.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Lists all publicly available SKUs for a given cloud service.
	ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error)
}

// UnimplementedCloudCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedCloudCatalogServer struct {
}

func (*UnimplementedCloudCatalogServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (*UnimplementedCloudCatalogServer) ListSkus(context.Context, *ListSkusRequest) (*ListSkusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSkus not implemented")
}

func RegisterCloudCatalogServer(s *grpc.Server, srv CloudCatalogServer) {
	s.RegisterService(&_CloudCatalog_serviceDesc, srv)
}

func _CloudCatalog_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudCatalogServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudCatalog/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudCatalogServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudCatalog_ListSkus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSkusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudCatalogServer).ListSkus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.billing.v1.CloudCatalog/ListSkus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudCatalogServer).ListSkus(ctx, req.(*ListSkusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.billing.v1.CloudCatalog",
	HandlerType: (*CloudCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _CloudCatalog_ListServices_Handler,
		},
		{
			MethodName: "ListSkus",
			Handler:    _CloudCatalog_ListSkus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/billing/v1/cloud_catalog.proto",
}
