// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package networkconnectivity

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	networkconnectivitypb "cloud.google.com/go/networkconnectivity/apiv1/networkconnectivitypb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/proto"
)

var newDataTransferClientHook clientHook

// DataTransferCallOptions contains the retry settings for each method of DataTransferClient.
type DataTransferCallOptions struct {
	ListMulticloudDataTransferConfigs           []gax.CallOption
	GetMulticloudDataTransferConfig             []gax.CallOption
	CreateMulticloudDataTransferConfig          []gax.CallOption
	UpdateMulticloudDataTransferConfig          []gax.CallOption
	DeleteMulticloudDataTransferConfig          []gax.CallOption
	ListDestinations                            []gax.CallOption
	GetDestination                              []gax.CallOption
	CreateDestination                           []gax.CallOption
	UpdateDestination                           []gax.CallOption
	DeleteDestination                           []gax.CallOption
	GetMulticloudDataTransferSupportedService   []gax.CallOption
	ListMulticloudDataTransferSupportedServices []gax.CallOption
	GetLocation                                 []gax.CallOption
	ListLocations                               []gax.CallOption
	GetIamPolicy                                []gax.CallOption
	SetIamPolicy                                []gax.CallOption
	TestIamPermissions                          []gax.CallOption
	CancelOperation                             []gax.CallOption
	DeleteOperation                             []gax.CallOption
	GetOperation                                []gax.CallOption
	ListOperations                              []gax.CallOption
}

func defaultDataTransferGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("networkconnectivity.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("networkconnectivity.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("networkconnectivity.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://networkconnectivity.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultDataTransferCallOptions() *DataTransferCallOptions {
	return &DataTransferCallOptions{
		ListMulticloudDataTransferConfigs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMulticloudDataTransferConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMulticloudDataTransferConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateMulticloudDataTransferConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteMulticloudDataTransferConfig: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListDestinations: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetDestination: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateDestination: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateDestination: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteDestination: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMulticloudDataTransferSupportedService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListMulticloudDataTransferSupportedServices: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations:     []gax.CallOption{},
	}
}

// internalDataTransferClient is an interface that defines the methods available from Network Connectivity API.
type internalDataTransferClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListMulticloudDataTransferConfigs(context.Context, *networkconnectivitypb.ListMulticloudDataTransferConfigsRequest, ...gax.CallOption) *MulticloudDataTransferConfigIterator
	GetMulticloudDataTransferConfig(context.Context, *networkconnectivitypb.GetMulticloudDataTransferConfigRequest, ...gax.CallOption) (*networkconnectivitypb.MulticloudDataTransferConfig, error)
	CreateMulticloudDataTransferConfig(context.Context, *networkconnectivitypb.CreateMulticloudDataTransferConfigRequest, ...gax.CallOption) (*CreateMulticloudDataTransferConfigOperation, error)
	CreateMulticloudDataTransferConfigOperation(name string) *CreateMulticloudDataTransferConfigOperation
	UpdateMulticloudDataTransferConfig(context.Context, *networkconnectivitypb.UpdateMulticloudDataTransferConfigRequest, ...gax.CallOption) (*UpdateMulticloudDataTransferConfigOperation, error)
	UpdateMulticloudDataTransferConfigOperation(name string) *UpdateMulticloudDataTransferConfigOperation
	DeleteMulticloudDataTransferConfig(context.Context, *networkconnectivitypb.DeleteMulticloudDataTransferConfigRequest, ...gax.CallOption) (*DeleteMulticloudDataTransferConfigOperation, error)
	DeleteMulticloudDataTransferConfigOperation(name string) *DeleteMulticloudDataTransferConfigOperation
	ListDestinations(context.Context, *networkconnectivitypb.ListDestinationsRequest, ...gax.CallOption) *DestinationIterator
	GetDestination(context.Context, *networkconnectivitypb.GetDestinationRequest, ...gax.CallOption) (*networkconnectivitypb.Destination, error)
	CreateDestination(context.Context, *networkconnectivitypb.CreateDestinationRequest, ...gax.CallOption) (*CreateDestinationOperation, error)
	CreateDestinationOperation(name string) *CreateDestinationOperation
	UpdateDestination(context.Context, *networkconnectivitypb.UpdateDestinationRequest, ...gax.CallOption) (*UpdateDestinationOperation, error)
	UpdateDestinationOperation(name string) *UpdateDestinationOperation
	DeleteDestination(context.Context, *networkconnectivitypb.DeleteDestinationRequest, ...gax.CallOption) (*DeleteDestinationOperation, error)
	DeleteDestinationOperation(name string) *DeleteDestinationOperation
	GetMulticloudDataTransferSupportedService(context.Context, *networkconnectivitypb.GetMulticloudDataTransferSupportedServiceRequest, ...gax.CallOption) (*networkconnectivitypb.MulticloudDataTransferSupportedService, error)
	ListMulticloudDataTransferSupportedServices(context.Context, *networkconnectivitypb.ListMulticloudDataTransferSupportedServicesRequest, ...gax.CallOption) *MulticloudDataTransferSupportedServiceIterator
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// DataTransferClient is a client for interacting with Network Connectivity API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// DataTransferService is the service for the Data Transfer API.
type DataTransferClient struct {
	// The internal transport-dependent client.
	internalClient internalDataTransferClient

	// The call options for this service.
	CallOptions *DataTransferCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *DataTransferClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *DataTransferClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *DataTransferClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListMulticloudDataTransferConfigs lists the MulticloudDataTransferConfig resources in a specified project
// and location.
func (c *DataTransferClient) ListMulticloudDataTransferConfigs(ctx context.Context, req *networkconnectivitypb.ListMulticloudDataTransferConfigsRequest, opts ...gax.CallOption) *MulticloudDataTransferConfigIterator {
	return c.internalClient.ListMulticloudDataTransferConfigs(ctx, req, opts...)
}

// GetMulticloudDataTransferConfig gets the details of a MulticloudDataTransferConfig resource.
func (c *DataTransferClient) GetMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.GetMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*networkconnectivitypb.MulticloudDataTransferConfig, error) {
	return c.internalClient.GetMulticloudDataTransferConfig(ctx, req, opts...)
}

// CreateMulticloudDataTransferConfig creates a MulticloudDataTransferConfig resource in a specified project
// and location.
func (c *DataTransferClient) CreateMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.CreateMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*CreateMulticloudDataTransferConfigOperation, error) {
	return c.internalClient.CreateMulticloudDataTransferConfig(ctx, req, opts...)
}

// CreateMulticloudDataTransferConfigOperation returns a new CreateMulticloudDataTransferConfigOperation from a given name.
// The name must be that of a previously created CreateMulticloudDataTransferConfigOperation, possibly from a different process.
func (c *DataTransferClient) CreateMulticloudDataTransferConfigOperation(name string) *CreateMulticloudDataTransferConfigOperation {
	return c.internalClient.CreateMulticloudDataTransferConfigOperation(name)
}

// UpdateMulticloudDataTransferConfig updates a MulticloudDataTransferConfig resource in a specified project
// and location.
func (c *DataTransferClient) UpdateMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.UpdateMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*UpdateMulticloudDataTransferConfigOperation, error) {
	return c.internalClient.UpdateMulticloudDataTransferConfig(ctx, req, opts...)
}

// UpdateMulticloudDataTransferConfigOperation returns a new UpdateMulticloudDataTransferConfigOperation from a given name.
// The name must be that of a previously created UpdateMulticloudDataTransferConfigOperation, possibly from a different process.
func (c *DataTransferClient) UpdateMulticloudDataTransferConfigOperation(name string) *UpdateMulticloudDataTransferConfigOperation {
	return c.internalClient.UpdateMulticloudDataTransferConfigOperation(name)
}

// DeleteMulticloudDataTransferConfig deletes a MulticloudDataTransferConfig resource.
func (c *DataTransferClient) DeleteMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.DeleteMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*DeleteMulticloudDataTransferConfigOperation, error) {
	return c.internalClient.DeleteMulticloudDataTransferConfig(ctx, req, opts...)
}

// DeleteMulticloudDataTransferConfigOperation returns a new DeleteMulticloudDataTransferConfigOperation from a given name.
// The name must be that of a previously created DeleteMulticloudDataTransferConfigOperation, possibly from a different process.
func (c *DataTransferClient) DeleteMulticloudDataTransferConfigOperation(name string) *DeleteMulticloudDataTransferConfigOperation {
	return c.internalClient.DeleteMulticloudDataTransferConfigOperation(name)
}

// ListDestinations lists the Destination resources in a specified project and location.
func (c *DataTransferClient) ListDestinations(ctx context.Context, req *networkconnectivitypb.ListDestinationsRequest, opts ...gax.CallOption) *DestinationIterator {
	return c.internalClient.ListDestinations(ctx, req, opts...)
}

// GetDestination gets the details of a Destination resource.
func (c *DataTransferClient) GetDestination(ctx context.Context, req *networkconnectivitypb.GetDestinationRequest, opts ...gax.CallOption) (*networkconnectivitypb.Destination, error) {
	return c.internalClient.GetDestination(ctx, req, opts...)
}

// CreateDestination creates a Destination resource in a specified project and location.
func (c *DataTransferClient) CreateDestination(ctx context.Context, req *networkconnectivitypb.CreateDestinationRequest, opts ...gax.CallOption) (*CreateDestinationOperation, error) {
	return c.internalClient.CreateDestination(ctx, req, opts...)
}

// CreateDestinationOperation returns a new CreateDestinationOperation from a given name.
// The name must be that of a previously created CreateDestinationOperation, possibly from a different process.
func (c *DataTransferClient) CreateDestinationOperation(name string) *CreateDestinationOperation {
	return c.internalClient.CreateDestinationOperation(name)
}

// UpdateDestination updates a Destination resource in a specified project and location.
func (c *DataTransferClient) UpdateDestination(ctx context.Context, req *networkconnectivitypb.UpdateDestinationRequest, opts ...gax.CallOption) (*UpdateDestinationOperation, error) {
	return c.internalClient.UpdateDestination(ctx, req, opts...)
}

// UpdateDestinationOperation returns a new UpdateDestinationOperation from a given name.
// The name must be that of a previously created UpdateDestinationOperation, possibly from a different process.
func (c *DataTransferClient) UpdateDestinationOperation(name string) *UpdateDestinationOperation {
	return c.internalClient.UpdateDestinationOperation(name)
}

// DeleteDestination deletes a Destination resource.
func (c *DataTransferClient) DeleteDestination(ctx context.Context, req *networkconnectivitypb.DeleteDestinationRequest, opts ...gax.CallOption) (*DeleteDestinationOperation, error) {
	return c.internalClient.DeleteDestination(ctx, req, opts...)
}

// DeleteDestinationOperation returns a new DeleteDestinationOperation from a given name.
// The name must be that of a previously created DeleteDestinationOperation, possibly from a different process.
func (c *DataTransferClient) DeleteDestinationOperation(name string) *DeleteDestinationOperation {
	return c.internalClient.DeleteDestinationOperation(name)
}

// GetMulticloudDataTransferSupportedService gets the details of a service that is supported for Data Transfer
// Essentials.
func (c *DataTransferClient) GetMulticloudDataTransferSupportedService(ctx context.Context, req *networkconnectivitypb.GetMulticloudDataTransferSupportedServiceRequest, opts ...gax.CallOption) (*networkconnectivitypb.MulticloudDataTransferSupportedService, error) {
	return c.internalClient.GetMulticloudDataTransferSupportedService(ctx, req, opts...)
}

// ListMulticloudDataTransferSupportedServices lists the services in the project for a region that are supported for
// Data Transfer Essentials.
func (c *DataTransferClient) ListMulticloudDataTransferSupportedServices(ctx context.Context, req *networkconnectivitypb.ListMulticloudDataTransferSupportedServicesRequest, opts ...gax.CallOption) *MulticloudDataTransferSupportedServiceIterator {
	return c.internalClient.ListMulticloudDataTransferSupportedServices(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *DataTransferClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *DataTransferClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *DataTransferClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *DataTransferClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *DataTransferClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *DataTransferClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *DataTransferClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *DataTransferClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *DataTransferClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// dataTransferGRPCClient is a client for interacting with Network Connectivity API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type dataTransferGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing DataTransferClient
	CallOptions **DataTransferCallOptions

	// The gRPC API client.
	dataTransferClient networkconnectivitypb.DataTransferServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewDataTransferClient creates a new data transfer service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// DataTransferService is the service for the Data Transfer API.
func NewDataTransferClient(ctx context.Context, opts ...option.ClientOption) (*DataTransferClient, error) {
	clientOpts := defaultDataTransferGRPCClientOptions()
	if newDataTransferClientHook != nil {
		hookOpts, err := newDataTransferClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := DataTransferClient{CallOptions: defaultDataTransferCallOptions()}

	c := &dataTransferGRPCClient{
		connPool:           connPool,
		dataTransferClient: networkconnectivitypb.NewDataTransferServiceClient(connPool),
		CallOptions:        &client.CallOptions,
		logger:             internaloption.GetLogger(opts),
		operationsClient:   longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:    iampb.NewIAMPolicyClient(connPool),
		locationsClient:    locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *dataTransferGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *dataTransferGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *dataTransferGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *dataTransferGRPCClient) ListMulticloudDataTransferConfigs(ctx context.Context, req *networkconnectivitypb.ListMulticloudDataTransferConfigsRequest, opts ...gax.CallOption) *MulticloudDataTransferConfigIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMulticloudDataTransferConfigs[0:len((*c.CallOptions).ListMulticloudDataTransferConfigs):len((*c.CallOptions).ListMulticloudDataTransferConfigs)], opts...)
	it := &MulticloudDataTransferConfigIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListMulticloudDataTransferConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.MulticloudDataTransferConfig, string, error) {
		resp := &networkconnectivitypb.ListMulticloudDataTransferConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.dataTransferClient.ListMulticloudDataTransferConfigs, req, settings.GRPC, c.logger, "ListMulticloudDataTransferConfigs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMulticloudDataTransferConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataTransferGRPCClient) GetMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.GetMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*networkconnectivitypb.MulticloudDataTransferConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMulticloudDataTransferConfig[0:len((*c.CallOptions).GetMulticloudDataTransferConfig):len((*c.CallOptions).GetMulticloudDataTransferConfig)], opts...)
	var resp *networkconnectivitypb.MulticloudDataTransferConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.GetMulticloudDataTransferConfig, req, settings.GRPC, c.logger, "GetMulticloudDataTransferConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) CreateMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.CreateMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*CreateMulticloudDataTransferConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMulticloudDataTransferConfig[0:len((*c.CallOptions).CreateMulticloudDataTransferConfig):len((*c.CallOptions).CreateMulticloudDataTransferConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.CreateMulticloudDataTransferConfig, req, settings.GRPC, c.logger, "CreateMulticloudDataTransferConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateMulticloudDataTransferConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataTransferGRPCClient) UpdateMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.UpdateMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*UpdateMulticloudDataTransferConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "multicloud_data_transfer_config.name", url.QueryEscape(req.GetMulticloudDataTransferConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMulticloudDataTransferConfig[0:len((*c.CallOptions).UpdateMulticloudDataTransferConfig):len((*c.CallOptions).UpdateMulticloudDataTransferConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.UpdateMulticloudDataTransferConfig, req, settings.GRPC, c.logger, "UpdateMulticloudDataTransferConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateMulticloudDataTransferConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataTransferGRPCClient) DeleteMulticloudDataTransferConfig(ctx context.Context, req *networkconnectivitypb.DeleteMulticloudDataTransferConfigRequest, opts ...gax.CallOption) (*DeleteMulticloudDataTransferConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMulticloudDataTransferConfig[0:len((*c.CallOptions).DeleteMulticloudDataTransferConfig):len((*c.CallOptions).DeleteMulticloudDataTransferConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.DeleteMulticloudDataTransferConfig, req, settings.GRPC, c.logger, "DeleteMulticloudDataTransferConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteMulticloudDataTransferConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataTransferGRPCClient) ListDestinations(ctx context.Context, req *networkconnectivitypb.ListDestinationsRequest, opts ...gax.CallOption) *DestinationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDestinations[0:len((*c.CallOptions).ListDestinations):len((*c.CallOptions).ListDestinations)], opts...)
	it := &DestinationIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListDestinationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.Destination, string, error) {
		resp := &networkconnectivitypb.ListDestinationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.dataTransferClient.ListDestinations, req, settings.GRPC, c.logger, "ListDestinations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDestinations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataTransferGRPCClient) GetDestination(ctx context.Context, req *networkconnectivitypb.GetDestinationRequest, opts ...gax.CallOption) (*networkconnectivitypb.Destination, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDestination[0:len((*c.CallOptions).GetDestination):len((*c.CallOptions).GetDestination)], opts...)
	var resp *networkconnectivitypb.Destination
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.GetDestination, req, settings.GRPC, c.logger, "GetDestination")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) CreateDestination(ctx context.Context, req *networkconnectivitypb.CreateDestinationRequest, opts ...gax.CallOption) (*CreateDestinationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDestination[0:len((*c.CallOptions).CreateDestination):len((*c.CallOptions).CreateDestination)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.CreateDestination, req, settings.GRPC, c.logger, "CreateDestination")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDestinationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataTransferGRPCClient) UpdateDestination(ctx context.Context, req *networkconnectivitypb.UpdateDestinationRequest, opts ...gax.CallOption) (*UpdateDestinationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "destination.name", url.QueryEscape(req.GetDestination().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDestination[0:len((*c.CallOptions).UpdateDestination):len((*c.CallOptions).UpdateDestination)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.UpdateDestination, req, settings.GRPC, c.logger, "UpdateDestination")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateDestinationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataTransferGRPCClient) DeleteDestination(ctx context.Context, req *networkconnectivitypb.DeleteDestinationRequest, opts ...gax.CallOption) (*DeleteDestinationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDestination[0:len((*c.CallOptions).DeleteDestination):len((*c.CallOptions).DeleteDestination)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.DeleteDestination, req, settings.GRPC, c.logger, "DeleteDestination")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDestinationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataTransferGRPCClient) GetMulticloudDataTransferSupportedService(ctx context.Context, req *networkconnectivitypb.GetMulticloudDataTransferSupportedServiceRequest, opts ...gax.CallOption) (*networkconnectivitypb.MulticloudDataTransferSupportedService, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMulticloudDataTransferSupportedService[0:len((*c.CallOptions).GetMulticloudDataTransferSupportedService):len((*c.CallOptions).GetMulticloudDataTransferSupportedService)], opts...)
	var resp *networkconnectivitypb.MulticloudDataTransferSupportedService
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.dataTransferClient.GetMulticloudDataTransferSupportedService, req, settings.GRPC, c.logger, "GetMulticloudDataTransferSupportedService")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) ListMulticloudDataTransferSupportedServices(ctx context.Context, req *networkconnectivitypb.ListMulticloudDataTransferSupportedServicesRequest, opts ...gax.CallOption) *MulticloudDataTransferSupportedServiceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMulticloudDataTransferSupportedServices[0:len((*c.CallOptions).ListMulticloudDataTransferSupportedServices):len((*c.CallOptions).ListMulticloudDataTransferSupportedServices)], opts...)
	it := &MulticloudDataTransferSupportedServiceIterator{}
	req = proto.Clone(req).(*networkconnectivitypb.ListMulticloudDataTransferSupportedServicesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*networkconnectivitypb.MulticloudDataTransferSupportedService, string, error) {
		resp := &networkconnectivitypb.ListMulticloudDataTransferSupportedServicesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.dataTransferClient.ListMulticloudDataTransferSupportedServices, req, settings.GRPC, c.logger, "ListMulticloudDataTransferSupportedServices")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMulticloudDataTransferSupportedServices(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataTransferGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataTransferGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *dataTransferGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *dataTransferGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataTransferGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateDestinationOperation returns a new CreateDestinationOperation from a given name.
// The name must be that of a previously created CreateDestinationOperation, possibly from a different process.
func (c *dataTransferGRPCClient) CreateDestinationOperation(name string) *CreateDestinationOperation {
	return &CreateDestinationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateMulticloudDataTransferConfigOperation returns a new CreateMulticloudDataTransferConfigOperation from a given name.
// The name must be that of a previously created CreateMulticloudDataTransferConfigOperation, possibly from a different process.
func (c *dataTransferGRPCClient) CreateMulticloudDataTransferConfigOperation(name string) *CreateMulticloudDataTransferConfigOperation {
	return &CreateMulticloudDataTransferConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteDestinationOperation returns a new DeleteDestinationOperation from a given name.
// The name must be that of a previously created DeleteDestinationOperation, possibly from a different process.
func (c *dataTransferGRPCClient) DeleteDestinationOperation(name string) *DeleteDestinationOperation {
	return &DeleteDestinationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteMulticloudDataTransferConfigOperation returns a new DeleteMulticloudDataTransferConfigOperation from a given name.
// The name must be that of a previously created DeleteMulticloudDataTransferConfigOperation, possibly from a different process.
func (c *dataTransferGRPCClient) DeleteMulticloudDataTransferConfigOperation(name string) *DeleteMulticloudDataTransferConfigOperation {
	return &DeleteMulticloudDataTransferConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateDestinationOperation returns a new UpdateDestinationOperation from a given name.
// The name must be that of a previously created UpdateDestinationOperation, possibly from a different process.
func (c *dataTransferGRPCClient) UpdateDestinationOperation(name string) *UpdateDestinationOperation {
	return &UpdateDestinationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateMulticloudDataTransferConfigOperation returns a new UpdateMulticloudDataTransferConfigOperation from a given name.
// The name must be that of a previously created UpdateMulticloudDataTransferConfigOperation, possibly from a different process.
func (c *dataTransferGRPCClient) UpdateMulticloudDataTransferConfigOperation(name string) *UpdateMulticloudDataTransferConfigOperation {
	return &UpdateMulticloudDataTransferConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
