// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package k_m_s

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// KMSKeyStatusOKCode is the HTTP code returned for type KMSKeyStatusOK
const KMSKeyStatusOKCode int = 200

/*
KMSKeyStatusOK A successful response.

swagger:response kMSKeyStatusOK
*/
type KMSKeyStatusOK struct {

	/*
	  In: Body
	*/
	Payload *models.KmsKeyStatusResponse `json:"body,omitempty"`
}

// NewKMSKeyStatusOK creates KMSKeyStatusOK with default headers values
func NewKMSKeyStatusOK() *KMSKeyStatusOK {

	return &KMSKeyStatusOK{}
}

// WithPayload adds the payload to the k m s key status o k response
func (o *KMSKeyStatusOK) WithPayload(payload *models.KmsKeyStatusResponse) *KMSKeyStatusOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the k m s key status o k response
func (o *KMSKeyStatusOK) SetPayload(payload *models.KmsKeyStatusResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *KMSKeyStatusOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
KMSKeyStatusDefault Generic error response.

swagger:response kMSKeyStatusDefault
*/
type KMSKeyStatusDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewKMSKeyStatusDefault creates KMSKeyStatusDefault with default headers values
func NewKMSKeyStatusDefault(code int) *KMSKeyStatusDefault {
	if code <= 0 {
		code = 500
	}

	return &KMSKeyStatusDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the k m s key status default response
func (o *KMSKeyStatusDefault) WithStatusCode(code int) *KMSKeyStatusDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the k m s key status default response
func (o *KMSKeyStatusDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the k m s key status default response
func (o *KMSKeyStatusDefault) WithPayload(payload *models.APIError) *KMSKeyStatusDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the k m s key status default response
func (o *KMSKeyStatusDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *KMSKeyStatusDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
