;; Test all the boolean operators on major boundary values and all special values.

(module
  (func (export "i8x16.any_true") (param $0 v128) (result i32) (v128.any_true (local.get $0)))
  (func (export "i8x16.all_true") (param $0 v128) (result i32) (i8x16.all_true (local.get $0)))
  (func (export "i8x16.bitmask") (param $0 v128) (result i32) (i8x16.bitmask (local.get $0)))

  (func (export "i16x8.any_true") (param $0 v128) (result i32) (v128.any_true (local.get $0)))
  (func (export "i16x8.all_true") (param $0 v128) (result i32) (i16x8.all_true (local.get $0)))
  (func (export "i16x8.bitmask") (param $0 v128) (result i32) (i16x8.bitmask (local.get $0)))

  (func (export "i32x4.any_true") (param $0 v128) (result i32) (v128.any_true (local.get $0)))
  (func (export "i32x4.all_true") (param $0 v128) (result i32) (i32x4.all_true (local.get $0)))
  (func (export "i32x4.bitmask") (param $0 v128) (result i32) (i32x4.bitmask (local.get $0)))

  (func (export "i64x2.all_true") (param $0 v128) (result i32) (i64x2.all_true (local.get $0)))
  (func (export "i64x2.bitmask") (param $0 v128) (result i32) (i64x2.bitmask (local.get $0)))
)

;; i8x16
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                        (i32.const 0))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                        (i32.const 1))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                        (i32.const 1))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                        (i32.const 1))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 -1 0 1 2 3 4 5 6 7 8 9 0xA 0xB 0xC 0xD 0xF))
                                        (i32.const 1))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i8x16.any_true" (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                        (i32.const 0))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                        (i32.const 0))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                        (i32.const 0))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                        (i32.const 1))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 -1 0 1 2 3 4 5 6 7 8 9 0xA 0xB 0xC 0xD 0xF))
                                        (i32.const 0))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i8x16.all_true" (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i8x16.bitmask" (v128.const i8x16 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 0x0000FFFF))
(assert_return (invoke "i8x16.bitmask" (v128.const i8x16 -1 0 1 2 3 4 5 6 7 8 9 0xA 0xB 0xC 0xD 0xF))
                                        (i32.const 0x00000001))

;; i16x8
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                        (i32.const 0))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0 0 0 0 0 0 1 0))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 1 1 1 1 1 1 0 1))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 -1 0 1 2 0xB 0xC 0xD 0xF))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345))
                                        (i32.const 1))
(assert_return (invoke "i16x8.any_true" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234))
                                        (i32.const 1))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                        (i32.const 0))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0 0 0 0 0 0 1 0))
                                        (i32.const 0))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 1 1 1 1 1 1 0 1))
                                        (i32.const 0))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                        (i32.const 1))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 -1 0 1 2 0xB 0xC 0xD 0xF))
                                        (i32.const 0))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345))
                                        (i32.const 1))
(assert_return (invoke "i16x8.all_true" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234))
                                        (i32.const 1))
(assert_return (invoke "i16x8.bitmask" (v128.const i16x8 0xFFFF 0xFFFF 0xFFFF 0xFFFF 0xFFFF 0xFFFF 0xFFFF 0xFFFF))
                                        (i32.const 0x000000FF))
(assert_return (invoke "i16x8.bitmask" (v128.const i16x8 -1 0 1 2 0xB 0xC 0xD 0xF))
                                        (i32.const 0x00000001))

;; i32x4
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0 0 0 0))
                                        (i32.const 0))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0 0 1 0))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 1 1 0 1))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 1 1 1 1))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 -1 0 1 0xF))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0x00 0x00 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0xAB 0xAB 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0x55 0x55 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 01_234_567_890 01_234_567_890 01_234_567_890 01_234_567_890))
                                        (i32.const 1))
(assert_return (invoke "i32x4.any_true" (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678))
                                        (i32.const 1))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0 0 0 0))
                                        (i32.const 0))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0 0 1 0))
                                        (i32.const 0))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 1 1 0 1))
                                        (i32.const 0))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 1 1 1 1))
                                        (i32.const 1))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 -1 0 1 0xF))
                                        (i32.const 0))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0x00 0x00 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0xFF 0xFF 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0xAB 0xAB 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0x55 0x55 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 01_234_567_890 01_234_567_890 01_234_567_890 01_234_567_890))
                                        (i32.const 1))
(assert_return (invoke "i32x4.all_true" (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678))
                                        (i32.const 1))
(assert_return (invoke "i32x4.bitmask" (v128.const i32x4 0xFFFFFFFF 0xFFFFFFFF 0xFFFFFFFF 0xFFFFFFFF))
                                        (i32.const 0x0000000F))
(assert_return (invoke "i32x4.bitmask" (v128.const i32x4 -1 0 1 0xF))
                                        (i32.const 0x00000001))

;; i64x2
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 0 0))
                                        (i32.const 0))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 0 1))
                                        (i32.const 0))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 1 0))
                                        (i32.const 0))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 1 1))
                                        (i32.const 1))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 -1 0))
                                        (i32.const 0))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 0x00 0x00))
                                        (i32.const 0))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 0xFF 0xFF))
                                        (i32.const 1))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 0xAB 0xAB))
                                        (i32.const 1))
(assert_return (invoke "i64x2.all_true" (v128.const i64x2 0x55 0x55))
                                        (i32.const 1))
(assert_return (invoke "i64x2.bitmask" (v128.const i64x2 0xFFFFFFFF_FFFFFFFF 0xFFFFFFFF_FFFFFFFF))
                                        (i32.const 0x00000003))
(assert_return (invoke "i64x2.bitmask" (v128.const i64x2 -1 0xF))
                                        (i32.const 0x00000001))

;; Combination

(module (memory 1)
    ;; as if condition
    (func (export "i8x16_any_true_as_if_cond") (param v128) (result i32)
        (if (result i32) (v128.any_true (local.get 0))
            (then (i32.const 1))
            (else (i32.const 0))
        )
    )
    (func (export "i16x8_any_true_as_if_cond") (param v128) (result i32)
        (if (result i32) (v128.any_true (local.get 0))
            (then (i32.const 1))
            (else (i32.const 0))
        )
    )
    (func (export "i32x4_any_true_as_if_cond") (param v128) (result i32)
        (if (result i32) (v128.any_true (local.get 0))
            (then (i32.const 1))
            (else (i32.const 0))
        )
    )
    (func (export "i8x16_all_true_as_if_cond") (param v128) (result i32)
        (if (result i32) (i8x16.all_true (local.get 0))
            (then (i32.const 1))
            (else (i32.const 0))
        )
    )
    (func (export "i16x8_all_true_as_if_cond") (param v128) (result i32)
        (if (result i32) (i16x8.all_true (local.get 0))
            (then (i32.const 1))
            (else (i32.const 0))
        )
    )
    (func (export "i32x4_all_true_as_if_cond") (param v128) (result i32)
        (if (result i32) (i32x4.all_true (local.get 0))
            (then (i32.const 1))
            (else (i32.const 0))
        )
    )
    ;; any_true as select condition
    (func (export "i8x16_any_true_as_select_cond") (param v128) (result i32)
     (select (i32.const 1) (i32.const 0) (v128.any_true (local.get 0)))
    )
    (func (export "i16x8_any_true_as_select_cond") (param v128) (result i32)
     (select (i32.const 1) (i32.const 0) (v128.any_true (local.get 0)))
    )
    (func (export "i32x4_any_true_as_select_cond") (param v128) (result i32)
     (select (i32.const 1) (i32.const 0) (v128.any_true (local.get 0)))
    )
    ;; all_true as select condition
    (func (export "i8x16_all_true_as_select_cond") (param v128) (result i32)
     (select (i32.const 1) (i32.const 0) (i8x16.all_true (local.get 0)))
    )
    (func (export "i16x8_all_true_as_select_cond") (param v128) (result i32)
     (select (i32.const 1) (i32.const 0) (i16x8.all_true (local.get 0)))
    )
    (func (export "i32x4_all_true_as_select_cond") (param v128) (result i32)
     (select (i32.const 1) (i32.const 0) (i32x4.all_true (local.get 0)))
    )
    ;; any_true as br_if condition
    (func (export "i8x16_any_true_as_br_if_cond") (param $0 v128) (result i32)
      (local $1 i32)
      (local.set $1 (i32.const 2))
      (block
        (local.set $1 (i32.const 1))
        (br_if 0 (v128.any_true (local.get $0)))
        (local.set $1 (i32.const 0))
      )
      (local.get $1)
    )
    (func (export "i16x8_any_true_as_br_if_cond") (param $0 v128) (result i32)
      (local $1 i32)
      (local.set $1 (i32.const 2))
      (block
        (local.set $1 (i32.const 1))
        (br_if 0 (v128.any_true (local.get $0)))
        (local.set $1 (i32.const 0))
      )
      (local.get $1)
    )
    (func (export "i32x4_any_true_as_br_if_cond") (param $0 v128) (result i32)
      (local $1 i32)
      (local.set $1 (i32.const 2))
      (block
        (local.set $1 (i32.const 1))
        (br_if 0 (v128.any_true (local.get $0)))
        (local.set $1 (i32.const 0))
      )
      (local.get $1)
    )
    ;; all_true as br_if condition
    (func (export "i8x16_all_true_as_br_if_cond") (param $0 v128) (result i32)
      (local $1 i32)
      (local.set $1 (i32.const 2))
      (block
        (local.set $1 (i32.const 1))
        (br_if 0 (i8x16.all_true (local.get $0)))
        (local.set $1 (i32.const 0))
      )
      (local.get $1)
    )
    (func (export "i16x8_all_true_as_br_if_cond") (param $0 v128) (result i32)
      (local $1 i32)
      (local.set $1 (i32.const 2))
      (block
        (local.set $1 (i32.const 1))
        (br_if 0 (i16x8.all_true (local.get $0)))
        (local.set $1 (i32.const 0))
      )
      (local.get $1)
    )
    (func (export "i32x4_all_true_as_br_if_cond") (param $0 v128) (result i32)
      (local $1 i32)
      (local.set $1 (i32.const 2))
      (block
        (local.set $1 (i32.const 1))
        (br_if 0 (i32x4.all_true (local.get $0)))
        (local.set $1 (i32.const 0))
      )
      (local.get $1)
    )
    ;; any_true as i32.and operand
    (func (export "i8x16_any_true_as_i32.and_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.and (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
    (func (export "i16x8_any_true_as_i32.and_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.and (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
    (func (export "i32x4_any_true_as_i32.and_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.and (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
     ;; any_true as i32.or operand
    (func (export "i8x16_any_true_as_i32.or_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.or (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
    (func (export "i16x8_any_true_as_i32.or_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.or (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
    (func (export "i32x4_any_true_as_i32.or_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.or (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
     ;; any_true as i32.xor operand
    (func (export "i8x16_any_true_as_i32.xor_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.xor (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
    (func (export "i16x8_any_true_as_i32.xor_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.xor (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
    (func (export "i32x4_any_true_as_i32.xor_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.xor (v128.any_true (local.get $0)) (v128.any_true (local.get $1)))
    )
     ;; all_true as i32.and operand
    (func (export "i8x16_all_true_as_i32.and_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.and (i8x16.all_true (local.get $0)) (i8x16.all_true (local.get $1)))
    )
    (func (export "i16x8_all_true_as_i32.and_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.and (i16x8.all_true (local.get $0)) (i16x8.all_true (local.get $1)))
    )
    (func (export "i32x4_all_true_as_i32.and_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.and (i32x4.all_true (local.get $0)) (i32x4.all_true (local.get $1)))
    )
     ;; all_true as i32.or operand
    (func (export "i8x16_all_true_as_i32.or_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.or (i8x16.all_true (local.get $0)) (i8x16.all_true (local.get $1)))
    )
    (func (export "i16x8_all_true_as_i32.or_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.or (i16x8.all_true (local.get $0)) (i16x8.all_true (local.get $1)))
    )
    (func (export "i32x4_all_true_as_i32.or_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.or (i32x4.all_true (local.get $0)) (i32x4.all_true (local.get $1)))
    )
     ;; all_true as i32.xor operand
    (func (export "i8x16_all_true_as_i32.xor_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.xor (i8x16.all_true (local.get $0)) (i8x16.all_true (local.get $1)))
    )
    (func (export "i16x8_all_true_as_i32.xor_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.xor (i16x8.all_true (local.get $0)) (i16x8.all_true (local.get $1)))
    )
    (func (export "i32x4_all_true_as_i32.xor_operand") (param $0 v128) (param $1 v128) (result i32)
      (i32.xor (i32x4.all_true (local.get $0)) (i32x4.all_true (local.get $1)))
    )
    ;; any_true with v128.not
    (func (export "i8x16_any_true_with_v128.not") (param $0 v128) (result i32)
       (v128.any_true (v128.not (local.get $0)))
    )
    (func (export "i16x8_any_true_with_v128.not") (param $0 v128) (result i32)
       (v128.any_true (v128.not (local.get $0)))
    )
    (func (export "i32x4_any_true_with_v128.not") (param $0 v128) (result i32)
       (v128.any_true (v128.not (local.get $0)))
    )
    ;; any_true with v128.and
    (func (export "i8x16_any_true_with_v128.and") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.and (local.get $0) (local.get $1)))
    )
    (func (export "i16x8_any_true_with_v128.and") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.and (local.get $0) (local.get $1)))
    )
    (func (export "i32x4_any_true_with_v128.and") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.and (local.get $0) (local.get $1)))
    )
    ;; any_true with v128.or
    (func (export "i8x16_any_true_with_v128.or") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.or (local.get $0) (local.get $1)))
    )
    (func (export "i16x8_any_true_with_v128.or") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.or (local.get $0) (local.get $1)))
    )
    (func (export "i32x4_any_true_with_v128.or") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.or (local.get $0) (local.get $1)))
    )
    ;; any_true with v128.xor
    (func (export "i8x16_any_true_with_v128.xor") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.xor (local.get $0) (local.get $1)))
    )
    (func (export "i16x8_any_true_with_v128.xor") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.xor (local.get $0) (local.get $1)))
    )
    (func (export "i32x4_any_true_with_v128.xor") (param $0 v128) (param $1 v128) (result i32)
       (v128.any_true (v128.xor (local.get $0) (local.get $1)))
    )
    ;; any_true with v128.bitselect
    (func (export "i8x16_any_true_with_v128.bitselect") (param $0 v128) (param $1 v128) (param $2 v128) (result i32)
       (v128.any_true (v128.bitselect (local.get $0) (local.get $1) (local.get $2)))
    )
    (func (export "i16x8_any_true_with_v128.bitselect") (param $0 v128) (param $1 v128) (param $2 v128) (result i32)
       (v128.any_true (v128.bitselect (local.get $0) (local.get $1) (local.get $2)))
    )
    (func (export "i32x4_any_true_with_v128.bitselect") (param $0 v128) (param $1 v128) (param $2 v128) (result i32)
       (v128.any_true (v128.bitselect (local.get $0) (local.get $1) (local.get $2)))
    )
    ;; all_true with v128.not
    (func (export "i8x16_all_true_with_v128.not") (param $0 v128) (result i32)
       (i8x16.all_true (v128.not (local.get $0)))
    )
    (func (export "i16x8_all_true_with_v128.not") (param $0 v128) (result i32)
       (i16x8.all_true (v128.not (local.get $0)))
    )
    (func (export "i32x4_all_true_with_v128.not") (param $0 v128) (result i32)
       (i32x4.all_true (v128.not (local.get $0)))
    )
    ;; all_true with v128.and
    (func (export "i8x16_all_true_with_v128.and") (param $0 v128) (param $1 v128) (result i32)
       (i8x16.all_true (v128.and (local.get $0) (local.get $1)))
    )
    (func (export "i16x8_all_true_with_v128.and") (param $0 v128) (param $1 v128) (result i32)
       (i16x8.all_true (v128.and (local.get $0) (local.get $1)))
    )
    (func (export "i32x4_all_true_with_v128.and") (param $0 v128) (param $1 v128) (result i32)
       (i32x4.all_true (v128.and (local.get $0) (local.get $1)))
    )
    ;; all_true with v128.or
    (func (export "i8x16_all_true_with_v128.or") (param $0 v128) (param $1 v128) (result i32)
       (i8x16.all_true (v128.or (local.get $0) (local.get $1)))
    )
    (func (export "i16x8_all_true_with_v128.or") (param $0 v128) (param $1 v128) (result i32)
       (i16x8.all_true (v128.or (local.get $0) (local.get $1)))
    )
    (func (export "i32x4_all_true_with_v128.or") (param $0 v128) (param $1 v128) (result i32)
       (i32x4.all_true (v128.or (local.get $0) (local.get $1)))
    )
    ;; all_true with v128.xor
    (func (export "i8x16_all_true_with_v128.xor") (param $0 v128) (param $1 v128) (result i32)
       (i8x16.all_true (v128.xor (local.get $0) (local.get $1)))
    )
    (func (export "i16x8_all_true_with_v128.xor") (param $0 v128) (param $1 v128) (result i32)
       (i16x8.all_true (v128.xor (local.get $0) (local.get $1)))
    )
    (func (export "i32x4_all_true_with_v128.xor") (param $0 v128) (param $1 v128) (result i32)
       (i32x4.all_true (v128.xor (local.get $0) (local.get $1)))
    )
    ;; all_true with v128.bitselect
    (func (export "i8x16_all_true_with_v128.bitselect") (param $0 v128) (param $1 v128) (param $2 v128) (result i32)
       (i8x16.all_true (v128.bitselect (local.get $0) (local.get $1) (local.get $2)))
    )
    (func (export "i16x8_all_true_with_v128.bitselect") (param $0 v128) (param $1 v128) (param $2 v128) (result i32)
       (i16x8.all_true (v128.bitselect (local.get $0) (local.get $1) (local.get $2)))
    )
    (func (export "i32x4_all_true_with_v128.bitselect") (param $0 v128) (param $1 v128) (param $2 v128) (result i32)
       (i32x4.all_true (v128.bitselect (local.get $0) (local.get $1) (local.get $2)))
    )
)

;; 'any_true' as 'if' condition
;; i8x16
(assert_return (invoke "i8x16_any_true_as_if_cond" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_if_cond" (v128.const i8x16 0 0 1 0 0 0 1 0 0 0 1 0 0 0 1 0))
                                                   (i32.const 1))
(assert_return (invoke "i8x16_any_true_as_if_cond" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (i32.const 1))
;; i16x8
(assert_return (invoke "i16x8_any_true_as_if_cond" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_if_cond" (v128.const i16x8 0 0 1 0 0 0 1 0))
                                                   (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_if_cond" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (i32.const 1))
;; i32x4
(assert_return (invoke "i32x4_any_true_as_if_cond" (v128.const i32x4 0 0 0 0))
                                                   (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_if_cond" (v128.const i32x4 0 0 1 0))
                                                   (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_if_cond" (v128.const i32x4 1 1 1 1))
                                                   (i32.const 1))

;; 'all_true' as 'if' condition
;; i8x16
(assert_return (invoke "i8x16_all_true_as_if_cond" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (i32.const 0))
(assert_return (invoke "i8x16_all_true_as_if_cond" (v128.const i8x16 1 1 1 0 1 1 1 0 1 1 1 0 1 1 1 0))
                                                   (i32.const 0))
(assert_return (invoke "i8x16_all_true_as_if_cond" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                   (i32.const 1))
;; i16x8
(assert_return (invoke "i16x8_all_true_as_if_cond" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                   (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_if_cond" (v128.const i16x8 1 1 1 0 1 1 1 0))
                                                   (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_if_cond" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                   (i32.const 1))
;; i32x4
(assert_return (invoke "i32x4_all_true_as_if_cond" (v128.const i32x4 0 0 0 0))
                                                   (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_if_cond" (v128.const i32x4 1 1 1 0))
                                                   (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_if_cond" (v128.const i32x4 1 1 1 1))
                                                   (i32.const 1))

;; any_true as select condition
(assert_return (invoke "i8x16_any_true_as_select_cond" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                       (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_select_cond" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                       (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_select_cond" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                       (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_select_cond" (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                       (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_select_cond" (v128.const i32x4 0 0 0 0))
                                                       (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_select_cond" (v128.const i32x4 0 0 1 0))
                                                       (i32.const 1))
;; all_true as select condition
(assert_return (invoke "i8x16_all_true_as_select_cond" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                       (i32.const 1))
(assert_return (invoke "i8x16_all_true_as_select_cond" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                                       (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_select_cond" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                       (i32.const 1))
(assert_return (invoke "i16x8_all_true_as_select_cond" (v128.const i16x8 1 1 1 1 1 1 0 1))
                                                       (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_select_cond" (v128.const i32x4 1 1 1 1))
                                                       (i32.const 1))
(assert_return (invoke "i32x4_all_true_as_select_cond" (v128.const i32x4 1 1 0 1))
                                                       (i32.const 0))
;; any_true as br_if condition
(assert_return (invoke "i8x16_any_true_as_br_if_cond" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_br_if_cond" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_br_if_cond" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_br_if_cond" (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_br_if_cond" (v128.const i32x4 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_br_if_cond" (v128.const i32x4 0 0 1 0))
                                                      (i32.const 1))
;; all_true as br_if condition
(assert_return (invoke "i8x16_all_true_as_br_if_cond" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                      (i32.const 1))
(assert_return (invoke "i8x16_all_true_as_br_if_cond" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_br_if_cond" (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_all_true_as_br_if_cond" (v128.const i16x8 1 1 1 1 1 1 0 1))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_br_if_cond" (v128.const i32x4 1 1 1 1))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_all_true_as_br_if_cond" (v128.const i32x4 1 1 0 1))
                                                      (i32.const 0))
;; any_true as and operand
(assert_return (invoke "i8x16_any_true_as_i32.and_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_i32.and_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                           (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_i32.and_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                           (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_i32.and_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_i32.and_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_i32.and_operand" (v128.const i16x8 0 0 0 0 0 0 1 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                           (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_i32.and_operand" (v128.const i32x4 0 0 0 0)
                                                           (v128.const i32x4 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_i32.and_operand" (v128.const i32x4 0 0 0 0)
                                                           (v128.const i32x4 0 0 1 0))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_i32.and_operand" (v128.const i32x4 0 0 1 0)
                                                           (v128.const i32x4 0 0 1 0))
                                                           (i32.const 1))
;; any_true as or operand
(assert_return (invoke "i8x16_any_true_as_i32.or_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                          (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                          (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_i32.or_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                          (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                          (i32.const 1))
(assert_return (invoke "i8x16_any_true_as_i32.or_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)
                                                          (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                          (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_i32.or_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                          (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                          (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_i32.or_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                          (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                          (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_i32.or_operand" (v128.const i16x8 0 0 0 0 0 0 1 0)
                                                          (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                          (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_i32.or_operand" (v128.const i32x4 0 0 0 0)
                                                          (v128.const i32x4 0 0 0 0))
                                                          (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_i32.or_operand" (v128.const i32x4 0 0 0 0)
                                                          (v128.const i32x4 0 0 1 0))
                                                          (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_i32.or_operand" (v128.const i32x4 0 0 1 0)
                                                          (v128.const i32x4 0 0 1 0))
                                                          (i32.const 1))
;; any_true as xor operand
(assert_return (invoke "i8x16_any_true_as_i32.xor_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i8x16_any_true_as_i32.xor_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                           (i32.const 1))
(assert_return (invoke "i8x16_any_true_as_i32.xor_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_i32.xor_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_any_true_as_i32.xor_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                           (i32.const 1))
(assert_return (invoke "i16x8_any_true_as_i32.xor_operand" (v128.const i16x8 0 0 0 0 0 0 1 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_i32.xor_operand" (v128.const i32x4 0 0 0 0)
                                                           (v128.const i32x4 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_any_true_as_i32.xor_operand" (v128.const i32x4 0 0 0 0)
                                                           (v128.const i32x4 0 0 1 0))
                                                           (i32.const 1))
(assert_return (invoke "i32x4_any_true_as_i32.xor_operand" (v128.const i32x4 0 0 1 0)
                                                           (v128.const i32x4 0 0 1 0))
                                                           (i32.const 0))
;; all_true as and operand
(assert_return (invoke "i8x16_all_true_as_i32.and_operand" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                           (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                           (i32.const 1))
(assert_return (invoke "i8x16_all_true_as_i32.and_operand" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                           (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                                           (i32.const 0))
(assert_return (invoke "i8x16_all_true_as_i32.and_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_i32.and_operand" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                           (i32.const 1))
(assert_return (invoke "i16x8_all_true_as_i32.and_operand" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                           (v128.const i16x8 1 1 1 1 1 1 0 1))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_i32.and_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 1 0))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_i32.and_operand" (v128.const i32x4 1 1 1 1)
                                                           (v128.const i32x4 1 1 1 1))
                                                           (i32.const 1))
(assert_return (invoke "i32x4_all_true_as_i32.and_operand" (v128.const i32x4 1 1 1 1)
                                                           (v128.const i32x4 1 1 0 1))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_i32.and_operand" (v128.const i32x4 0 0 0 0)
                                                           (v128.const i32x4 0 0 1 0))
                                                           (i32.const 0))
;; all_true as or operand
(assert_return (invoke "i8x16_all_true_as_i32.or_operand" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                          (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                          (i32.const 1))
(assert_return (invoke "i8x16_all_true_as_i32.or_operand" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                          (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                                          (i32.const 1))
(assert_return (invoke "i8x16_all_true_as_i32.or_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                          (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                          (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_i32.or_operand" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                          (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                          (i32.const 1))
(assert_return (invoke "i16x8_all_true_as_i32.or_operand" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                          (v128.const i16x8 1 1 1 1 1 1 0 1))
                                                          (i32.const 1))
(assert_return (invoke "i16x8_all_true_as_i32.or_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                          (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                          (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_i32.or_operand" (v128.const i32x4 1 1 1 1)
                                                          (v128.const i32x4 1 1 1 1))
                                                          (i32.const 1))
(assert_return (invoke "i32x4_all_true_as_i32.or_operand" (v128.const i32x4 1 1 1 1)
                                                          (v128.const i32x4 1 1 0 1))
                                                          (i32.const 1))
(assert_return (invoke "i32x4_all_true_as_i32.or_operand" (v128.const i32x4 0 0 0 0)
                                                          (v128.const i32x4 0 0 0 0))
                                                          (i32.const 0))
;; all_true as xor operand
(assert_return (invoke "i8x16_all_true_as_i32.xor_operand" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                           (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
                                                           (i32.const 0))
(assert_return (invoke "i8x16_all_true_as_i32.xor_operand" (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
                                                           (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1))
                                                           (i32.const 1))
(assert_return (invoke "i8x16_all_true_as_i32.xor_operand" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_i32.xor_operand" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                                           (i32.const 0))
(assert_return (invoke "i16x8_all_true_as_i32.xor_operand" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                                           (v128.const i16x8 1 1 1 1 1 1 0 1))
                                                           (i32.const 1))
(assert_return (invoke "i16x8_all_true_as_i32.xor_operand" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                           (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_i32.xor_operand" (v128.const i32x4 1 1 1 1)
                                                           (v128.const i32x4 1 1 1 1))
                                                           (i32.const 0))
(assert_return (invoke "i32x4_all_true_as_i32.xor_operand" (v128.const i32x4 1 1 1 1)
                                                           (v128.const i32x4 1 1 0 1))
                                                           (i32.const 1))
(assert_return (invoke "i32x4_all_true_as_i32.xor_operand" (v128.const i32x4 0 0 0 0)
                                                           (v128.const i32x4 0 0 0 0))
                                                           (i32.const 0))
;; any_true with v128.not
(assert_return (invoke "i8x16_any_true_with_v128.not" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 1))
(assert_return (invoke "i8x16_any_true_with_v128.not" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_any_true_with_v128.not" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.not" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.not" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_any_true_with_v128.not" (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.not" (v128.const i32x4 0 0 0 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.not" (v128.const i32x4 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_any_true_with_v128.not" (v128.const i32x4 0 0 -1 0))
                                                      (i32.const 1))
;; any_true with v128.and
(assert_return (invoke "i8x16_any_true_with_v128.and" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_any_true_with_v128.and" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 1))
(assert_return (invoke "i8x16_any_true_with_v128.and" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.and" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_any_true_with_v128.and" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.and" (v128.const i16x8 0 0 0 0 0 0 -1 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.and" (v128.const i32x4 0 0 0 0)
                                                      (v128.const i32x4 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_any_true_with_v128.and" (v128.const i32x4 -1 -1 -1 -1)
                                                      (v128.const i32x4 -1 -1 -1 -1))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.and" (v128.const i32x4 0 0 -1 0)
                                                      (v128.const i32x4 0 0 -1 0))
                                                      (i32.const 1))
;; any_true with v128.or
(assert_return (invoke "i8x16_any_true_with_v128.or" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                     (i32.const 0))
(assert_return (invoke "i8x16_any_true_with_v128.or" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                     (i32.const 1))
(assert_return (invoke "i8x16_any_true_with_v128.or" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0)
                                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                     (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.or" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                     (i32.const 0))
(assert_return (invoke "i16x8_any_true_with_v128.or" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                     (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.or" (v128.const i16x8 0 0 0 0 0 0 -1 0)
                                                     (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                     (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.or" (v128.const i32x4 0 0 0 0)
                                                     (v128.const i32x4 0 0 0 0))
                                                     (i32.const 0))
(assert_return (invoke "i32x4_any_true_with_v128.or" (v128.const i32x4 -1 -1 -1 -1)
                                                     (v128.const i32x4 -1 -1 -1 -1))
                                                     (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.or" (v128.const i32x4 0 0 -1 0)
                                                     (v128.const i32x4 0 0 -1 0))
                                                     (i32.const 1))
;; any_true with v128.xor
(assert_return (invoke "i8x16_any_true_with_v128.xor" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_any_true_with_v128.xor" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_any_true_with_v128.xor" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.xor" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_any_true_with_v128.xor" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_any_true_with_v128.xor" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.xor" (v128.const i32x4 0 0 0 0)
                                                      (v128.const i32x4 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_any_true_with_v128.xor" (v128.const i32x4 -1 -1 -1 -1)
                                                      (v128.const i32x4 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_any_true_with_v128.xor" (v128.const i32x4 0 0 0 0)
                                                      (v128.const i32x4 0 0 -1 0))
                                                      (i32.const 1))
;; any_true with v128.bitselect
(assert_return (invoke "i8x16_any_true_with_v128.bitselect" (v128.const i8x16 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                                            (i32.const 0))
(assert_return (invoke "i8x16_any_true_with_v128.bitselect" (v128.const i8x16 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0xFF 0x55))
                                                            (i32.const 1))
(assert_return (invoke "i16x8_any_true_with_v128.bitselect" (v128.const i16x8 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                                            (i32.const 0))
(assert_return (invoke "i16x8_any_true_with_v128.bitselect" (v128.const i16x8 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0xFF 0x55))
                                                            (i32.const 1))
(assert_return (invoke "i32x4_any_true_with_v128.bitselect" (v128.const i32x4 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i32x4 0x55 0x55 0x55 0x55)
                                                            (v128.const i32x4 0x55 0x55 0x55 0x55))
                                                            (i32.const 0))
(assert_return (invoke "i32x4_any_true_with_v128.bitselect" (v128.const i32x4 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i32x4 0x55 0x55 0x55 0x55)
                                                            (v128.const i32x4 0x55 0x55 0xFF 0x55))
                                                            (i32.const 1))
;; all_true with v128.not
(assert_return (invoke "i8x16_all_true_with_v128.not" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 1))
(assert_return (invoke "i8x16_all_true_with_v128.not" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_all_true_with_v128.not" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.not" (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_all_true_with_v128.not" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.not" (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.not" (v128.const i32x4 0 0 0 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_all_true_with_v128.not" (v128.const i32x4 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.not" (v128.const i32x4 0 0 -1 0))
                                                      (i32.const 0))
;; all_true with v128.and
(assert_return (invoke "i8x16_all_true_with_v128.and" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_all_true_with_v128.and" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 1))
(assert_return (invoke "i8x16_all_true_with_v128.and" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.and" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.and" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_all_true_with_v128.and" (v128.const i16x8 0 0 0 0 0 0 -1 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.and" (v128.const i32x4 0 0 0 0)
                                                      (v128.const i32x4 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.and" (v128.const i32x4 -1 -1 -1 -1)
                                                      (v128.const i32x4 -1 -1 -1 -1))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_all_true_with_v128.and" (v128.const i32x4 0 0 -1 0)
                                                      (v128.const i32x4 0 0 -1 0))
                                                      (i32.const 0))
;; all_true with v128.or
(assert_return (invoke "i8x16_all_true_with_v128.or" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                     (i32.const 0))
(assert_return (invoke "i8x16_all_true_with_v128.or" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                     (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                     (i32.const 1))
(assert_return (invoke "i8x16_all_true_with_v128.or" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0)
                                                     (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0))
                                                     (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.or" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                     (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                     (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.or" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                     (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                     (i32.const 1))
(assert_return (invoke "i16x8_all_true_with_v128.or" (v128.const i16x8 0 0 0 0 0 0 -1 0)
                                                     (v128.const i16x8 0 0 0 0 0 0 -1 0))
                                                     (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.or" (v128.const i32x4 0 0 0 0)
                                                     (v128.const i32x4 0 0 0 0))
                                                     (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.or" (v128.const i32x4 -1 -1 -1 -1)
                                                     (v128.const i32x4 -1 -1 -1 -1))
                                                     (i32.const 1))
(assert_return (invoke "i32x4_all_true_with_v128.or" (v128.const i32x4 0 0 -1 0)
                                                     (v128.const i32x4 0 0 -1 0))
                                                     (i32.const 0))
;; all_true with v128.xor
(assert_return (invoke "i8x16_all_true_with_v128.xor" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_all_true_with_v128.xor" (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i8x16_all_true_with_v128.xor" (v128.const i8x16 0 -1 0 -1 0 -1 0 -1 0 -1 0 -1 0 -1 0 -1)
                                                      (v128.const i8x16 -1 0 -1 0 -1 0 -1 0 -1 0 -1 0 -1 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i16x8_all_true_with_v128.xor" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                                      (v128.const i16x8 0 0 0 0 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.xor" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                                      (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.xor" (v128.const i16x8 0 -1 0 -1 0 -1 0 -1)
                                                      (v128.const i16x8 -1 0 -1 0 -1 0 -1 0))
                                                      (i32.const 1))
(assert_return (invoke "i32x4_all_true_with_v128.xor" (v128.const i32x4 0 0 0 0)
                                                      (v128.const i32x4 0 0 0 0))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.xor" (v128.const i32x4 -1 -1 -1 -1)
                                                      (v128.const i32x4 -1 -1 -1 -1))
                                                      (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.xor" (v128.const i32x4 0 -1 0 -1)
                                                      (v128.const i32x4 -1 0 -1 0))
                                                      (i32.const 1))
;; all_true with v128.bitselect
(assert_return (invoke "i8x16_all_true_with_v128.bitselect" (v128.const i8x16 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                                            (i32.const 0))
(assert_return (invoke "i8x16_all_true_with_v128.bitselect" (v128.const i8x16 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i8x16 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i8x16 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA))
                                                            (i32.const 1))
(assert_return (invoke "i16x8_all_true_with_v128.bitselect" (v128.const i16x8 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55))
                                                            (i32.const 0))
(assert_return (invoke "i16x8_all_true_with_v128.bitselect" (v128.const i16x8 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i16x8 0x55 0x55 0x55 0x55 0x55 0x55 0x55 0x55)
                                                            (v128.const i16x8 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA 0xAA))
                                                            (i32.const 1))
(assert_return (invoke "i32x4_all_true_with_v128.bitselect" (v128.const i32x4 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i32x4 0x55 0x55 0x55 0x55)
                                                            (v128.const i32x4 0x55 0x55 0x55 0x55))
                                                            (i32.const 0))
(assert_return (invoke "i32x4_all_true_with_v128.bitselect" (v128.const i32x4 0xAA 0xAA 0xAA 0xAA)
                                                            (v128.const i32x4 0x55 0x55 0x55 0x55)
                                                            (v128.const i32x4 0xAA 0xAA 0xAA 0xAA))
                                                            (i32.const 1))

;; Type check

(assert_invalid (module (func (result i32) (v128.any_true (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result i32) (i8x16.all_true (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result i32) (v128.any_true (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result i32) (i16x8.all_true (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result i32) (v128.any_true (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result i32) (i32x4.all_true (i32.const 0)))) "type mismatch")

;; Unknown operators

(assert_malformed (module quote "(memory 1) (func (result i32) (f32x4.any_true (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result i32) (f32x4.all_true (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result i32) (f64x2.any_true (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result i32) (f64x2.all_true (v128.const i32x4 0 0 0 0)))") "unknown operator")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $v128.any_true-arg-empty (result v128)
      (v128.any_true)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.all_true-arg-empty (result v128)
      (i8x16.all_true)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $v128.any_true-arg-empty (result v128)
      (v128.any_true)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.all_true-arg-empty (result v128)
      (i16x8.all_true)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $v128.any_true-arg-empty (result v128)
      (v128.any_true)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.all_true-arg-empty (result v128)
      (i32x4.all_true)
    )
  )
  "type mismatch"
)
