;; Tests for i32x4 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i32x4.add") (param v128 v128) (result v128) (i32x4.add (local.get 0) (local.get 1)))
  (func (export "i32x4.sub") (param v128 v128) (result v128) (i32x4.sub (local.get 0) (local.get 1)))
  (func (export "i32x4.mul") (param v128 v128) (result v128) (i32x4.mul (local.get 0) (local.get 1)))
  (func (export "i32x4.neg") (param v128) (result v128) (i32x4.neg (local.get 0)))
)


;; i32x4.add
(assert_return (invoke "i32x4.add" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2 2 2 2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -1 -1 -1 -1)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483646 2147483646 2147483646 2147483646))
(assert_return (invoke "i32x4.add" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 2147483646 2147483646 2147483646 2147483646))
(assert_return (invoke "i32x4.add" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x3fffffff 0x3fffffff 0x3fffffff 0x3fffffff)
                                   (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000)
                                   (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -0x3fffffff -0x3fffffff -0x3fffffff -0x3fffffff)
                                   (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000)
                                   (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.add" (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000)
                                   (v128.const i32x4 -0x40000001 -0x40000001 -0x40000001 -0x40000001))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i32x4 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i8x16 0 0 0 0x80 0 0 0 0x80 0 0 0 0x80 0 0 0 0x80))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i16x8 0 0x8000 0 0x8000 0 0x8000 0 0x8000))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 +0.0 +0.0 +0.0 +0.0))
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
                                   (v128.const i32x4 0xbf800000 0xbf800000 0xbf800000 0xbf800000))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                   (v128.const i32x4 0x3f800000 0x3f800000 0x3f800000 0x3f800000))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const f32x4 +inf +inf +inf +inf))
                                   (v128.const i32x4 0x7f800001 0x7f800001 0x7f800001 0x7f800001))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const i32x4 0xff800001 0xff800001 0xff800001 0xff800001))
(assert_return (invoke "i32x4.add" (v128.const i32x4 1 1 1 1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const i32x4 0x7fc00001 0x7fc00001 0x7fc00001 0x7fc00001))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0 1 2 3)
                                   (v128.const i32x4 0 0xffffffff 0xfffffffe 0xfffffffd))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0 1 2 3)
                                   (v128.const i32x4 0 2 4 6))
                                   (v128.const i32x4 0 3 6 9))
(assert_return (invoke "i32x4.add" (v128.const i32x4 01_234_567_890 01_234_567_890 01_234_567_890 01_234_567_890)
                                   (v128.const i32x4 01_234_567_890 01_234_567_890 01_234_567_890 01_234_567_890))
                                   (v128.const i32x4 02_469_135_780 02_469_135_780 02_469_135_780 02_469_135_780))
(assert_return (invoke "i32x4.add" (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678)
                                   (v128.const i32x4 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef))
                                   (v128.const i32x4 0x0_a2e0_2467 0x0_a2e0_2467 0x0_a2e0_2467 0x0_a2e0_2467))

;; i32x4.sub
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 1 1 1 1)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 1 1 1 1)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 2 2 2 2))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -1 -1 -1 -1)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483644 2147483644 2147483644 2147483644))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483645 2147483645 2147483645 2147483645))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2147483645 -2147483645 -2147483645 -2147483645))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x3fffffff 0x3fffffff 0x3fffffff 0x3fffffff)
                                   (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000)
                                   (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -0x3fffffff -0x3fffffff -0x3fffffff -0x3fffffff)
                                   (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000)
                                   (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000)
                                   (v128.const i32x4 -0x40000001 -0x40000001 -0x40000001 -0x40000001))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 2147483646 2147483646 2147483646 2147483646))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i32x4 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i8x16 0 0 0 0x80 0 0 0 0x80 0 0 0 0x80 0 0 0 0x80))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 1 1 1 1)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i32x4 2 2 2 2))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i16x8 0 0x8000 0 0x8000 0 0x8000 0 0x8000))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 1 1 1 1)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i32x4 0x02 0x02 0x02 0x02))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 +0.0 +0.0 +0.0 +0.0))
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
                                   (v128.const i32x4 0x40800000 0x40800000 0x40800000 0x40800000))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                   (v128.const i32x4 0xc0800000 0xc0800000 0xc0800000 0xc0800000))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x1 0x1 0x1 0x1)
                                   (v128.const f32x4 +inf +inf +inf +inf))
                                   (v128.const i32x4 0x80800001 0x80800001 0x80800001 0x80800001))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x1 0x1 0x1 0x1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const i32x4 0x00800001 0x00800001 0x00800001 0x00800001))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x1 0x1 0x1 0x1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const i32x4 0x80400001 0x80400001 0x80400001 0x80400001))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0 1 2 3)
                                   (v128.const i32x4 0 0xffffffff 0xfffffffe 0xfffffffd))
                                   (v128.const i32x4 0 0x02 0x04 0x06))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0 1 2 3)
                                   (v128.const i32x4 0 2 4 6))
                                   (v128.const i32x4 0 -1 -2 -3))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 03_214_567_890  03_214_567_890  03_214_567_890  03_214_567_890 )
                                   (v128.const i32x4 01_234_567_890  01_234_567_890  01_234_567_890  01_234_567_890 ))
                                   (v128.const i32x4 01_980_000_000 01_980_000_000 01_980_000_000 01_980_000_000))
(assert_return (invoke "i32x4.sub" (v128.const i32x4 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef)
                                   (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678))
                                   (v128.const i32x4 0x0_7e77_7777 0x0_7e77_7777 0x0_7e77_7777 0x0_7e77_7777))

;; i32x4.mul
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 1 1 1 1)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0 0 0 0)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 1 1 1 1)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -1 -1 -1 -1)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 1073741823 1073741823 1073741823 1073741823)
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 1073741824 1073741824 1073741824 1073741824)
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -1073741823 -1073741823 -1073741823 -1073741823)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -1073741825 -1073741825 -1073741825 -1073741825)
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 2147483645 2147483645 2147483645 2147483645)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483645 2147483645 2147483645 2147483645))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 2147483646 2147483646 2147483646 2147483646))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 2147483648 2147483648 2147483648 2147483648)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 2147483646 2147483646 2147483646 2147483646))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647)
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648)
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295)
                                   (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x3fffffff 0x3fffffff 0x3fffffff 0x3fffffff)
                                   (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000))
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000)
                                   (v128.const i32x4 0x40000000 0x40000000 0x40000000 0x40000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -0x3fffffff -0x3fffffff -0x3fffffff -0x3fffffff)
                                   (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000))
                                   (v128.const i32x4 -1073741824 -1073741824 -1073741824 -1073741824))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000)
                                   (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 -0x40000000 -0x40000000 -0x40000000 -0x40000000)
                                   (v128.const i32x4 -0x40000001 -0x40000001 -0x40000001 -0x40000001))
                                   (v128.const i32x4 1073741824 1073741824 1073741824 1073741824))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i32x4 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff)
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x10000000 0x10000000 0x10000000 0x10000000)
                                   (v128.const i8x16 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10 0x10))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i8x16 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000)
                                   (v128.const i16x8 0 0x02 0 0x02 0 0x02 0 0x02))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff)
                                   (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 +0.0 +0.0 +0.0 +0.0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x8000 0x8000 0x8000 0x8000)
                                   (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x1 0x1 0x1 0x1)
                                   (v128.const f32x4 +inf +inf +inf +inf))
                                   (v128.const i32x4 0x7f800000 0x7f800000 0x7f800000 0x7f800000))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x1 0x1 0x1 0x1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const i32x4 0xff800000 0xff800000 0xff800000 0xff800000))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x1 0x1 0x1 0x1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const i32x4 0x7fc00000 0x7fc00000 0x7fc00000 0x7fc00000))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0 1 2 3)
                                   (v128.const i32x4 0 0xffffffff 0xfffffffe 0xfffffffd))
                                   (v128.const i32x4 0 0xffffffff 0xfffffffc 0xfffffff7))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0 1 2 3)
                                   (v128.const i32x4 0 2 4 6))
                                   (v128.const i32x4 0 0x02 0x08 0x12))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0_123_456_789 0_123_456_789 0_123_456_789 0_123_456_789)
                                   (v128.const i32x4 0_987_654_321 0_987_654_321 0_987_654_321 0_987_654_321))
                                   (v128.const i32x4 04_227_814_277 04_227_814_277 04_227_814_277 04_227_814_277))
(assert_return (invoke "i32x4.mul" (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678)
                                   (v128.const i32x4 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef))
                                   (v128.const i32x4 0x0_2a42_d208 0x0_2a42_d208 0x0_2a42_d208 0x0_2a42_d208))

;; i32x4.neg
(assert_return (invoke "i32x4.neg" (v128.const i32x4 0 0 0 0))
                                   (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 1 1 1 1))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 -1 -1 -1 -1))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 2147483646 2147483646 2147483646 2147483646))
                                   (v128.const i32x4 -2147483646 -2147483646 -2147483646 -2147483646))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 4294967295 4294967295 4294967295 4294967295))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 0x01 0x01 0x01 0x01))
                                   (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 -0x01 -0x01 -0x01 -0x01))
                                   (v128.const i32x4 1 1 1 1))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 -0x80000000 -0x80000000 -0x80000000 -0x80000000))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 -0x7fffffff -0x7fffffff -0x7fffffff -0x7fffffff))
                                   (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 0x7fffffff 0x7fffffff 0x7fffffff 0x7fffffff))
                                   (v128.const i32x4 -2147483647 -2147483647 -2147483647 -2147483647))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 0x80000000 0x80000000 0x80000000 0x80000000))
                                   (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
(assert_return (invoke "i32x4.neg" (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                   (v128.const i32x4 1 1 1 1))

;; type check
(assert_invalid (module (func (result v128) (i32x4.neg (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.add (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.sub (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i32x4.mul (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i32x4.neg-arg-empty (result v128)
      (i32x4.neg)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.add-1st-arg-empty (result v128)
      (i32x4.add (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.add-arg-empty (result v128)
      (i32x4.add)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.sub-1st-arg-empty (result v128)
      (i32x4.sub (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.sub-arg-empty (result v128)
      (i32x4.sub)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.mul-1st-arg-empty (result v128)
      (i32x4.mul (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.mul-arg-empty (result v128)
      (i32x4.mul)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "add-sub") (param v128 v128 v128) (result v128)
    (i32x4.add (i32x4.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-add") (param v128 v128 v128) (result v128)
    (i32x4.mul (i32x4.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-sub") (param v128 v128 v128) (result v128)
    (i32x4.mul (i32x4.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sub-add") (param v128 v128 v128) (result v128)
    (i32x4.sub (i32x4.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "add-neg") (param v128 v128) (result v128)
    (i32x4.add (i32x4.neg (local.get 0)) (local.get 1)))
  (func (export "mul-neg") (param v128 v128) (result v128)
    (i32x4.mul (i32x4.neg (local.get 0)) (local.get 1)))
  (func (export "sub-neg") (param v128 v128) (result v128)
    (i32x4.sub (i32x4.neg (local.get 0)) (local.get 1)))
)

(assert_return (invoke "add-sub" (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 0 2 4 6)
                                 (v128.const i32x4 0 2 4 6))
                                 (v128.const i32x4 0 1 2 3))
(assert_return (invoke "mul-add" (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 2 2 2 2))
                                 (v128.const i32x4 0 4 8 12))
(assert_return (invoke "mul-sub" (v128.const i32x4 0 2 4 6)
                                 (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 0 1 2 3))
                                 (v128.const i32x4 0 1 4 9))
(assert_return (invoke "sub-add" (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 0 2 4 6)
                                 (v128.const i32x4 0 2 4 6))
                                 (v128.const i32x4 0 1 2 3))
(assert_return (invoke "add-neg" (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 0 1 2 3))
                                 (v128.const i32x4 0 0 0 0))
(assert_return (invoke "mul-neg" (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 2 2 2 2))
                                 (v128.const i32x4 0 -2 -4 -6))
(assert_return (invoke "sub-neg" (v128.const i32x4 0 1 2 3)
                                 (v128.const i32x4 0 1 2 3))
                                 (v128.const i32x4 0 -2 -4 -6))