package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SQLVulnerabilityAssessmentScansClient is the API spec for Microsoft.Security (Azure Security Center) resource
// provider
type SQLVulnerabilityAssessmentScansClient struct {
	BaseClient
}

// NewSQLVulnerabilityAssessmentScansClient creates an instance of the SQLVulnerabilityAssessmentScansClient client.
func NewSQLVulnerabilityAssessmentScansClient(subscriptionID string, ascLocation string) SQLVulnerabilityAssessmentScansClient {
	return NewSQLVulnerabilityAssessmentScansClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewSQLVulnerabilityAssessmentScansClientWithBaseURI creates an instance of the SQLVulnerabilityAssessmentScansClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewSQLVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) SQLVulnerabilityAssessmentScansClient {
	return SQLVulnerabilityAssessmentScansClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// Get sends the get request.
// Parameters:
// scanID - the scan Id. Type 'latest' to get the scan record for the latest scan.
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentScansClient) Get(ctx context.Context, scanID string, workspaceID string, APIVersion string, resourceID string) (result Scan, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentScansClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scanID, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScansClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SQLVulnerabilityAssessmentScansClient) GetPreparer(ctx context.Context, scanID string, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
		"scanId":     autorest.Encode("path", scanID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentScansClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentScansClient) GetResponder(resp *http.Response) (result Scan, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List sends the list request.
// Parameters:
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentScansClient) List(ctx context.Context, workspaceID string, APIVersion string, resourceID string) (result Scans, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentScansClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScansClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScansClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScansClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client SQLVulnerabilityAssessmentScansClient) ListPreparer(ctx context.Context, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentScansClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentScansClient) ListResponder(resp *http.Response) (result Scans, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
