/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import javax.swing.text.AttributeSet;
import org.netbeans.modules.editor.lib2.highlighting.CoveringHighlightsSequence;
import org.netbeans.modules.editor.lib2.highlighting.HighlightItem;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsList;
import org.netbeans.modules.editor.lib2.highlighting.SplitOffsetHighlightItem;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

public final class HighlightsReader {
    private final HighlightsList highlightsList;
    private final CoveringHighlightsSequence cHighlightsSequence;
    private final int endOffset;

    public HighlightsReader(HighlightsContainer highlightsContainer, int startOffset, int endOffset) {
        this.cHighlightsSequence = (CoveringHighlightsSequence)highlightsContainer.getHighlights(startOffset, endOffset);
        assert (this.cHighlightsSequence.isCovering()) : "Non-covering HS=" + this.cHighlightsSequence;
        this.highlightsList = new HighlightsList(startOffset);
        this.endOffset = endOffset;
    }

    public HighlightsSequence highlightsSequence() {
        return this.cHighlightsSequence;
    }

    public HighlightsList highlightsList() {
        return this.highlightsList;
    }

    public void readUntil(int offset) {
        int hlEndOffset = this.highlightsList.endOffset();
        int hlEndSplitOffset = this.highlightsList.endSplitOffset();
        while (this.cHighlightsSequence.moveNext()) {
            int hlStartOffset = this.cHighlightsSequence.getStartOffset();
            int hlStartSplitOffset = this.cHighlightsSequence.getStartSplitOffset();
            if (hlStartOffset > hlEndOffset || hlStartOffset == hlEndOffset && hlStartSplitOffset > hlEndSplitOffset) {
                HighlightItem fillItem = hlStartSplitOffset != 0 ? new SplitOffsetHighlightItem(hlStartOffset, hlStartSplitOffset, null) : new HighlightItem(hlStartOffset, null);
                this.highlightsList.add(fillItem);
            }
            hlEndOffset = this.cHighlightsSequence.getEndOffset();
            hlEndSplitOffset = this.cHighlightsSequence.getEndSplitOffset();
            AttributeSet attrs = this.cHighlightsSequence.getAttributes();
            HighlightItem item = hlEndSplitOffset != 0 ? new SplitOffsetHighlightItem(hlEndOffset, hlEndSplitOffset, attrs) : new HighlightItem(hlEndOffset, attrs);
            this.highlightsList.add(item);
            if (hlEndOffset < offset) continue;
            return;
        }
        if (hlEndOffset < this.endOffset) {
            this.highlightsList.add(new HighlightItem(this.endOffset, null));
        }
    }
}

