/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting.support;

import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class HighlightsContainers {
    public static HighlightsContainer inlineHintsSettingAwareContainer(final Document doc, final HighlightsContainer delegate) {
        class InlineHintsSettingsAwareContainer
        extends AbstractHighlightsContainer
        implements PreferenceChangeListener {
            private static final String KEY_ENABLE_INLINE_HINTS = "enable.inline.hints";
            private final Preferences prefs;
            private boolean enabled;

            public InlineHintsSettingsAwareContainer() {
                String mimeType = DocumentUtilities.getMimeType((Document)doc);
                this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
                this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
                this.inlineSettingChanged();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HighlightsSequence getHighlights(int startOffset, int endOffset) {
                InlineHintsSettingsAwareContainer inlineHintsSettingsAwareContainer = this;
                synchronized (inlineHintsSettingsAwareContainer) {
                    if (!this.enabled) {
                        return HighlightsSequence.EMPTY;
                    }
                }
                return delegate.getHighlights(startOffset, endOffset);
            }

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (KEY_ENABLE_INLINE_HINTS.equals(evt.getKey())) {
                    this.inlineSettingChanged();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void inlineSettingChanged() {
                InlineHintsSettingsAwareContainer inlineHintsSettingsAwareContainer = this;
                synchronized (inlineHintsSettingsAwareContainer) {
                    boolean newValue = this.prefs.getBoolean(KEY_ENABLE_INLINE_HINTS, false);
                    if (this.enabled == newValue) {
                        return;
                    }
                    this.enabled = newValue;
                }
                this.fireHighlightsChange(0, doc.getLength());
            }
        }
        return new InlineHintsSettingsAwareContainer();
    }
}

