/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.CreateBucketDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateBucketRequest
extends BmcRequest<CreateBucketDetails> {
    private String namespaceName;
    private CreateBucketDetails createBucketDetails;
    private String opcClientRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CreateBucketDetails getCreateBucketDetails() {
        return this.createBucketDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    @InternalSdk
    public CreateBucketDetails getBody$() {
        return this.createBucketDetails;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).createBucketDetails(this.createBucketDetails).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",createBucketDetails=").append(String.valueOf((Object)this.createBucketDetails));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBucketRequest)) {
            return false;
        }
        CreateBucketRequest other = (CreateBucketRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.createBucketDetails, (Object)other.createBucketDetails) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.createBucketDetails == null ? 43 : this.createBucketDetails.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateBucketRequest, CreateBucketDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private CreateBucketDetails createBucketDetails = null;
        private String opcClientRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder createBucketDetails(CreateBucketDetails createBucketDetails) {
            this.createBucketDetails = createBucketDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBucketRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.createBucketDetails(o.getCreateBucketDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBucketRequest build() {
            CreateBucketRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateBucketDetails body) {
            this.createBucketDetails(body);
            return this;
        }

        public CreateBucketRequest buildWithoutInvocationCallback() {
            CreateBucketRequest request = new CreateBucketRequest();
            request.namespaceName = this.namespaceName;
            request.createBucketDetails = this.createBucketDetails;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

