/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class FileStreamSource
extends StreamSource {
    private final FileObject fo;
    private final FileObject baseFo;
    private final Lookup lkp;
    private static StreamSource EMPTY_STREAM_SOURCE = new DummySource("<MISSING>");
    private static StreamSource DIRECTORY_STREAM_SOURCE = new DummySource("<FOLDER>");
    private static final Reader EMPTY_READER = new Reader(){

        @Override
        public int read(char[] chars, int i, int i1) throws IOException {
            return -1;
        }

        @Override
        public void close() throws IOException {
        }
    };

    public static StreamSource create(FileObject fo, FileObject basePath) {
        if (fo != null) {
            if (fo.isData()) {
                return new FileStreamSource(fo, basePath);
            }
            return DIRECTORY_STREAM_SOURCE;
        }
        return EMPTY_STREAM_SOURCE;
    }

    private FileStreamSource(FileObject fo, FileObject baseFo) {
        this.fo = fo;
        this.baseFo = baseFo;
        this.lkp = Lookups.fixed((Object[])new Object[]{fo});
    }

    @Override
    public String getName() {
        return this.fo.getPath().substring(this.baseFo.getPath().length() + 1);
    }

    @Override
    public String getTitle() {
        return this.fo.getPath();
    }

    @Override
    public Lookup getLookup() {
        return this.lkp;
    }

    @Override
    public String getMIMEType() {
        return this.fo.getMIMEType();
    }

    @Override
    public Reader createReader() throws IOException {
        InputStream is = this.fo.getInputStream();
        return new InputStreamReader(is, FileEncodingQuery.getEncoding((FileObject)this.fo));
    }

    @Override
    public Writer createWriter(Difference[] dfrncs) throws IOException {
        OutputStream os = this.fo.getOutputStream();
        return new OutputStreamWriter(os, FileEncodingQuery.getEncoding((FileObject)this.fo));
    }

    @Override
    public boolean isEditable() {
        return this.fo.canWrite();
    }

    @Override
    public void close() {
        if (this.fo != null) {
            try {
                EditorCookie ec;
                DataObject dObj = DataObject.find((FileObject)this.fo);
                if (dObj != null && (ec = (EditorCookie)dObj.getLookup().lookup(EditorCookie.class)) != null && ec.getOpenedPanes() == null && !ec.isModified()) {
                    ec.close();
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        super.close();
    }

    private static class DummySource
    extends StreamSource {
        private final String name;

        public DummySource(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTitle() {
            return this.name;
        }

        @Override
        public String getMIMEType() {
            return "text/plain";
        }

        @Override
        public Reader createReader() throws IOException {
            return EMPTY_READER;
        }

        @Override
        public Writer createWriter(Difference[] dfrncs) throws IOException {
            return null;
        }

        @Override
        public boolean isEditable() {
            return false;
        }
    }
}

