/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.ConnectProfilePanel;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class OracleCloudWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator {
    private static final RequestProcessor RP = new RequestProcessor(OracleCloudWizardIterator.class);
    private static final String TENANCY = "TENANCY";
    private Panel panel;
    private CompletableFuture<List<OCIProfile>> profiles = new CompletableFuture();

    public Set instantiate() throws IOException {
        for (OCIProfile p : this.panel.ui.getSelectedProfiles()) {
            OCIManager.getDefault().addConnectedProfile(p);
        }
        return Collections.emptySet();
    }

    public void initialize(WizardDescriptor wizard) {
        RP.post(() -> {
            ArrayList<OCIProfile> list = new ArrayList<OCIProfile>();
            try {
                for (OCIProfile p : OCIManager.getDefault().listProfiles(null)) {
                    if (!p.getTenancy().isPresent()) continue;
                    list.add(p);
                }
            }
            catch (IOException ex) {
                this.profiles.completeExceptionally(ex);
                return;
            }
            list.removeAll(OCIManager.getDefault().getConnectedProfiles());
            this.profiles.complete(list);
        });
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public WizardDescriptor.Panel current() {
        if (this.panel == null) {
            this.panel = new Panel();
            ((CompletableFuture)this.profiles.thenAccept(l -> SwingUtilities.invokeLater(() -> this.updateProfilesUI((List<OCIProfile>)l)))).exceptionally(ex -> {
                this.panel.ui.showErrorMessage(ex.getLocalizedMessage());
                return null;
            });
        }
        return this.panel;
    }

    public String name() {
        return Bundle.LBL_OC();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
    }

    public void previousPanel() {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private void updateProfilesUI(List<OCIProfile> profiles) {
        if (this.panel == null) {
            return;
        }
        if (profiles.isEmpty()) {
            this.panel.ui.showErrorMessage(Bundle.MSG_OCI_Setup(Bundle.URL_OCI_Setup()));
        } else {
            this.panel.ui.setProfiles(profiles);
            this.panel.ui.setSelectedProfiles(profiles);
        }
    }

    static class Panel
    implements WizardDescriptor.Panel,
    PropertyChangeListener {
        private ChangeSupport changeSupport;
        private ConnectProfilePanel ui = new ConnectProfilePanel();

        Panel() {
        }

        public Component getComponent() {
            return this.ui;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object settings) {
        }

        public void storeSettings(Object settings) {
        }

        public void addChangeListener(ChangeListener l) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport((Object)this);
                this.ui.addPropertyChangeListener(this);
            }
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            if (this.changeSupport != null) {
                this.changeSupport.removeChangeListener(l);
            }
        }

        public boolean isValid() {
            return this.ui.isContentValid();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("contentValid".equals(evt.getPropertyName()) && this.changeSupport != null) {
                this.changeSupport.fireChange();
            }
        }
    }
}

