/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.items;

import com.oracle.bmc.Region;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cloud.oracle.items.OCID;

public abstract class OCIItem {
    private static final Logger LOG = Logger.getLogger(OCIItem.class.getName());
    final OCID id;
    final String name;
    final String compartmentId;
    final String tenancyId;
    final String regionCode;
    String description;
    final transient PropertyChangeSupport changeSupport;

    public OCIItem(OCID id, String compartmentId, String name, String tenancyId, String regionCode) {
        this.id = id;
        this.name = name;
        this.compartmentId = compartmentId;
        this.tenancyId = tenancyId;
        this.regionCode = regionCode;
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public OCIItem() {
        this(null, null, null, null, null);
    }

    public OCID getKey() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTenancyId() {
        return this.tenancyId;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void refresh() {
        this.changeSupport.firePropertyChange("children", 0, 1);
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public int maxInProject() {
        return 1;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.id);
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + Objects.hashCode(this.description);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OCIItem other = (OCIItem)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    public void fireRefNameChanged(String oldRefName, String referenceName) {
        this.changeSupport.firePropertyChange("referenceName", oldRefName, referenceName);
    }

    public String getRegion() {
        if (this.getRegionCode() != null) {
            try {
                Region region = Region.fromRegionCodeOrId((String)this.getRegionCode());
                return region.getRegionId();
            }
            catch (IllegalArgumentException e) {
                LOG.log(Level.INFO, "Unknown Region Code", e);
            }
        }
        return null;
    }
}

