/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.NbBundle;

public class ClassPathContainerResolver {
    public static final String JUNIT_CONTAINER = "org.eclipse.jdt.junit.JUNIT_CONTAINER/";
    public static final String USER_LIBRARY_CONTAINER = "org.eclipse.jdt.USER_LIBRARY/";
    public static final String WEB_CONTAINER = "org.eclipse.jst.j2ee.internal.web.container";
    public static final String J2EE_MODULE_CONTAINER = "org.eclipse.jst.j2ee.internal.module.container";
    public static final String JSF_CONTAINER = "org.eclipse.jst.jsf.core.internal.jsflibrarycontainer/";
    public static final String J2EE_SERVER_CONTAINER = "org.eclipse.jst.server.core.container/";
    public static final String MYECLIPSE_CONTAINERS = "melibrary.com.genuitec.eclipse.";

    public static boolean resolve(Workspace workspace, DotClassPathEntry entry, List<String> importProblems, boolean importInProgress) throws IOException {
        assert (entry.getKind() == DotClassPathEntry.Kind.CONTAINER) : entry;
        String container = entry.getRawPath();
        if (container.startsWith(JUNIT_CONTAINER)) {
            String library = "libs.junit.classpath";
            if (container.substring(JUNIT_CONTAINER.length()).startsWith("4")) {
                library = "libs.junit_4.classpath";
            }
            entry.setContainerMapping(library);
            return true;
        }
        if (container.startsWith(USER_LIBRARY_CONTAINER)) {
            if (importInProgress) {
                ClassPathContainerResolver.createLibrary(workspace, container, importProblems);
            }
            entry.setContainerMapping("libs." + ClassPathContainerResolver.getNetBeansLibraryName(container) + ".classpath");
            return true;
        }
        if (container.startsWith(JSF_CONTAINER)) {
            if (importInProgress) {
                ClassPathContainerResolver.createLibrary(workspace, container, importProblems);
            }
            entry.setContainerMapping("libs." + ClassPathContainerResolver.getNetBeansLibraryName(container) + ".classpath");
            return true;
        }
        if (container.startsWith(J2EE_MODULE_CONTAINER) || container.startsWith(J2EE_SERVER_CONTAINER)) {
            entry.setContainerMapping("");
            return true;
        }
        if (container.startsWith(MYECLIPSE_CONTAINERS)) {
            if (importInProgress) {
                if (workspace != null) {
                    workspace.loadMyEclipseLibraries(importProblems);
                }
                ClassPathContainerResolver.createLibrary(workspace, container, importProblems);
            }
            entry.setContainerMapping("libs." + ClassPathContainerResolver.getNetBeansLibraryName(container) + ".classpath");
            return true;
        }
        if (container.startsWith(WEB_CONTAINER)) {
            if (importInProgress) {
                assert (workspace == null);
                importProblems.add(NbBundle.getMessage(ClassPathContainerResolver.class, (String)"MSG_UnsupportedWebContainer", (Object)container));
                return false;
            }
            return true;
        }
        importProblems.add(NbBundle.getMessage(ClassPathContainerResolver.class, (String)"MSG_UnsupportedContainer", (Object)container));
        return false;
    }

    public static List<DotClassPathEntry> replaceContainerEntry(EclipseProject project, Workspace workspace, DotClassPathEntry entry, List<String> importProblems) {
        assert (entry.getKind() == DotClassPathEntry.Kind.CONTAINER) : entry;
        String container = entry.getRawPath();
        if (container.startsWith(WEB_CONTAINER)) {
            String projectName = null;
            if (container.length() > WEB_CONTAINER.length()) {
                projectName = container.substring(WEB_CONTAINER.length() + 1);
            }
            return ClassPathContainerResolver.createClassPathForWebContainer(project, workspace, projectName);
        }
        return null;
    }

    private static List<DotClassPathEntry> createClassPathForWebContainer(EclipseProject project, Workspace w, String name) {
        File classes;
        EclipseProject p;
        ArrayList<DotClassPathEntry> newEntries = new ArrayList<DotClassPathEntry>();
        EclipseProject eclipseProject = p = name != null ? w.getProjectByName(name) : project;
        if (p == null) {
            return newEntries;
        }
        if (!p.isImportSupported()) {
            return newEntries;
        }
        File location = p.getProjectFileLocation("webinf");
        if (location == null) {
            return newEntries;
        }
        File lib = new File(location, "lib");
        if (lib.exists()) {
            for (File f : lib.listFiles()) {
                if (!f.isFile()) continue;
                newEntries.add(ClassPathContainerResolver.createFileDotClassPathEntry(f));
            }
        }
        if ((classes = new File(location, "classes")).exists() && classes.isDirectory()) {
            newEntries.add(ClassPathContainerResolver.createFileDotClassPathEntry(classes));
        }
        return newEntries;
    }

    private static DotClassPathEntry createFileDotClassPathEntry(File f) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("kind", "lib");
        props.put("path", f.getPath());
        DotClassPathEntry d = new DotClassPathEntry(props, null);
        d.setAbsolutePath(f.getPath());
        return d;
    }

    private static String getNetBeansLibraryName(String container) {
        return PropertyUtils.getUsablePropertyName((String)ClassPathContainerResolver.getEclipseLibraryName(container));
    }

    private static String getEclipseLibraryName(String container) {
        if (container.startsWith(MYECLIPSE_CONTAINERS)) {
            int index = container.indexOf(".MYECLIPSE_");
            if (index == -1) {
                index = container.lastIndexOf(".");
                if (index != -1) {
                    ++index;
                }
            } else {
                index += 11;
            }
            assert (index != -1) : container;
            return container.substring(index);
        }
        String prefix = container.startsWith(USER_LIBRARY_CONTAINER) ? USER_LIBRARY_CONTAINER : JSF_CONTAINER;
        return container.substring(prefix.length());
    }

    private static void createLibrary(Workspace workspace, String container, List<String> importProblems) throws IOException {
        assert (container.startsWith(USER_LIBRARY_CONTAINER) || container.startsWith(JSF_CONTAINER) || container.startsWith(MYECLIPSE_CONTAINERS)) : container;
        String library = ClassPathContainerResolver.getNetBeansLibraryName(container);
        LibraryManager lm = LibraryManager.getDefault();
        if (lm.getLibrary(library) != null) {
            return;
        }
        HashMap<String, List<URL>> content = new HashMap<String, List<URL>>();
        if (workspace == null) {
            importProblems.add(NbBundle.getMessage(ClassPathContainerResolver.class, (String)"MSG_CannotCreateUserLibrary", (Object)library));
            return;
        }
        content.put("classpath", workspace.getJarsForUserLibrary(ClassPathContainerResolver.getEclipseLibraryName(container)));
        List<URL> urls = workspace.getJavadocForUserLibrary(ClassPathContainerResolver.getEclipseLibraryName(container), importProblems);
        if (urls != null) {
            content.put("javadoc", urls);
        }
        if ((urls = workspace.getSourcesForUserLibrary(ClassPathContainerResolver.getEclipseLibraryName(container), importProblems)) != null) {
            content.put("src", urls);
        }
        lm.createLibrary("j2se", library, content);
    }

    public static boolean isJUnit(DotClassPathEntry entry) {
        int i;
        if (entry.getKind() == DotClassPathEntry.Kind.CONTAINER && entry.getRawPath().startsWith(JUNIT_CONTAINER)) {
            return true;
        }
        if ((entry.getKind() == DotClassPathEntry.Kind.LIBRARY || entry.getKind() == DotClassPathEntry.Kind.VARIABLE) && (i = entry.getRawPath().replace('\\', '/').lastIndexOf(47)) != -1) {
            String s = entry.getRawPath().substring(i + 1);
            return s.startsWith("junit") && s.endsWith(".jar");
        }
        return false;
    }
}

