/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DetachVnicRequest
extends BmcRequest<Void> {
    private String vnicAttachmentId;
    private String ifMatch;

    public String getVnicAttachmentId() {
        return this.vnicAttachmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().vnicAttachmentId(this.vnicAttachmentId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vnicAttachmentId=").append(String.valueOf(this.vnicAttachmentId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetachVnicRequest)) {
            return false;
        }
        DetachVnicRequest other = (DetachVnicRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vnicAttachmentId, other.vnicAttachmentId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vnicAttachmentId == null ? 43 : this.vnicAttachmentId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DetachVnicRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vnicAttachmentId = null;
        private String ifMatch = null;

        public Builder vnicAttachmentId(String vnicAttachmentId) {
            this.vnicAttachmentId = vnicAttachmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DetachVnicRequest o) {
            this.vnicAttachmentId(o.getVnicAttachmentId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DetachVnicRequest build() {
            DetachVnicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DetachVnicRequest buildWithoutInvocationCallback() {
            DetachVnicRequest request = new DetachVnicRequest();
            request.vnicAttachmentId = this.vnicAttachmentId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

