/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.EditPanel;
import org.netbeans.modules.web.monitor.client.ParamEditor;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EditPanelQuery
extends DataDisplay {
    private static final boolean debug = false;
    private DisplayTable paramTable = null;
    private MonitorData monitorData = null;
    private boolean setParams = false;
    JButton newParamB;
    JButton deleteParamB;
    JTextField queryStringText;
    JTextField uploadFileText;

    EditPanelQuery() {
    }

    void redisplayData() {
        this.setData(this.monitorData);
        this.revalidate();
        this.repaint();
    }

    void setData(MonitorData md) {
        this.monitorData = md;
        this.removeAll();
        int fullGridWidth = 0;
        int gridy = -1;
        this.addGridBagComponent(this, EditPanelQuery.createTopSpacer(), 0, ++gridy, fullGridWidth, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        final RequestData rd = this.monitorData.getRequestData();
        String method = rd.getAttributeValue("method");
        if ("POST".equals(method)) {
            this.queryStringText = new JTextField(rd.getAttributeValue("queryString"));
            this.queryStringText.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent evt) {
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    rd.setAttributeValue("queryString", EditPanelQuery.this.queryStringText.getText());
                }
            });
            this.addGridBagComponent(this, EditPanelQuery.createHeaderLabel(NbBundle.getBundle(EditPanelQuery.class).getString("MON_Querystring_Header"), NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_QuerystringA11yDesc"), this.paramTable), 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            this.addGridBagComponent(this, this.queryStringText, 0, ++gridy, fullGridWidth, 1, 1.0, 0.0, 17, 2, tableInsets, 0, 0);
        }
        String msg2 = null;
        if ("PUT".equals(method)) {
            msg2 = NbBundle.getBundle(EditPanelQuery.class).getString("MON_Upload_File");
            JLabel msg2Label = EditPanelQuery.createDataLabel(msg2);
            this.addGridBagComponent(this, msg2Label, 0, ++gridy, fullGridWidth, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            String uploadFileMsg = NbBundle.getBundle(EditPanelQuery.class).getString("MON_Upload_File_Not_Supported");
            this.uploadFileText = new JTextField(uploadFileMsg);
            this.uploadFileText.setEnabled(false);
            this.addGridBagComponent(this, this.uploadFileText, 0, ++gridy, fullGridWidth, 1, 1.0, 0.0, 17, 2, labelInsets, 0, 0);
            this.addGridBagComponent(this, EditPanelQuery.createGlue(), 0, ++gridy, 1, 1, 1.0, 1.0, 17, 1, labelInsets, 0, 0);
        } else if (method != null) {
            Param[] params2 = rd.getParam();
            if (params2 == null) {
                params2 = new Param[]{};
            }
            this.setParameters(params2);
            String ad = null;
            if (method.equals("GET")) {
                msg2 = NbBundle.getBundle(EditPanelQuery.class).getString("MON_Query_parameters");
                ad = NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_Query_parametersA11yDesc");
                this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_ParametersTableA11yDesc"));
                this.paramTable.setToolTipText(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_ParametersTableA11yDesc"));
            } else if (method.equals("POST")) {
                msg2 = NbBundle.getBundle(EditPanelQuery.class).getString("MON_Posted_data");
                ad = NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_Posted_dataA11yDesc");
                this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_Posted_dataTableA11yName"));
                this.paramTable.setToolTipText(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_Posted_dataTableA11yDesc"));
            }
            Component msg2Label = EditPanelQuery.createSortButtonLabel(msg2, this.paramTable, ad);
            this.addGridBagComponent(this, msg2Label, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            gridy = this.addParamTable(this, gridy);
            this.setEnablings();
        }
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }

    private int addParamTable(JPanel panel, int gridy) {
        JScrollPane scrollpane = new JScrollPane(this.paramTable);
        this.addGridBagComponent(panel, scrollpane, 0, ++gridy, 0, 1, 1.0, 1.0, 17, 1, tableInsets, 0, 0);
        this.newParamB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.newParamB, (String)NbBundle.getBundle(EditPanel.class).getString("MON_New_param"));
        this.newParamB.setToolTipText(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_New_paramA11yDesc"));
        this.newParamB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamEditor pe = new ParamEditor("", "", ParamEditor.Editable.BOTH, ParamEditor.Condition.NONE, EditPanelQuery.this.newParamB.getText());
                pe.showDialog();
                if (pe.getDialogOK()) {
                    String name = pe.getName();
                    String value = pe.getValue();
                    Param newParam = new Param(name, value);
                    EditPanelQuery.this.monitorData.getRequestData().addParam(newParam);
                    EditPanelQuery.this.redisplayData();
                }
            }
        });
        this.deleteParamB = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteParamB, (String)NbBundle.getBundle(EditPanel.class).getString("MON_Delete_param"));
        this.deleteParamB.setToolTipText(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_Delete_paramA11yDesc"));
        this.deleteParamB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                int numRows = EditPanelQuery.this.paramTable.getRowCount();
                RequestData rd = EditPanelQuery.this.monitorData.getRequestData();
                StringBuffer buf = new StringBuffer(NbBundle.getBundle(EditPanelQuery.class).getString("MON_Confirm_Delete_Params"));
                buf.append("\n");
                for (i = 0; i < numRows; ++i) {
                    if (!EditPanelQuery.this.paramTable.isRowSelected(i)) continue;
                    buf.append(EditPanelQuery.this.paramTable.getValueAt(i, 0));
                    buf.append("=");
                    buf.append(EditPanelQuery.this.paramTable.getValueAt(i, 1));
                    buf.append("\n");
                }
                EditPanelQuery.this.showConfirmDialog(buf.toString());
                if (EditPanelQuery.this.setParams) {
                    for (i = 0; i < numRows; ++i) {
                        if (!EditPanelQuery.this.paramTable.isRowSelected(i)) continue;
                        String name = (String)EditPanelQuery.this.paramTable.getValueAt(i, 0);
                        String value = (String)EditPanelQuery.this.paramTable.getValueAt(i, 1);
                        Param[] params2 = rd.getParam();
                        Param param = EditPanelQuery.this.findParam(params2, name, value);
                        if (param == null) continue;
                        rd.removeParam(param);
                    }
                    EditPanelQuery.this.redisplayData();
                }
            }
        });
        int gridx = -1;
        this.addGridBagComponent(this, EditPanelQuery.createGlue(), ++gridx, ++gridy, 1, 1, 1.0, 0.0, 17, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.newParamB, ++gridx, gridy, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        this.addGridBagComponent(this, this.deleteParamB, ++gridx, gridy, 1, 1, 0.0, 0.0, 13, 0, buttonInsets, 0, 0);
        return gridy;
    }

    void setEnablings() {
        this.newParamB.setEnabled(true);
        int[] selectedRows = this.paramTable.getSelectedRows();
        this.deleteParamB.setEnabled(selectedRows.length > 0);
    }

    void setParameters(Param[] newParams) {
        this.paramTable = new DisplayTable(newParams, 4, true);
        this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_QuerystringTableA11yName"));
        this.paramTable.setToolTipText(NbBundle.getBundle(EditPanelQuery.class).getString("ACS_MON_QuerystringTableA11yDesc"));
        ListSelectionModel selma = this.paramTable.getSelectionModel();
        selma.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EditPanelQuery.this.setEnablings();
            }
        });
        this.paramTable.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                EditPanelQuery.this.updateParams();
            }
        });
    }

    void updateParams() {
        int num = this.paramTable.getRowCount();
        RequestData rd = this.monitorData.getRequestData();
        Param[] params = rd.getParam();
        for (int i = 0; i < num; ++i) {
            String name = (String)this.paramTable.getValueAt(i, 0);
            if ((name = name.trim()).equals("")) {
                this.paramTable.setValueAt(params[i].getName(), i, 0);
                this.showErrorDialog();
                return;
            }
            String value = (String)this.paramTable.getValueAt(i, 1);
            value = value.trim();
            params[i].setName(name);
            params[i].setValue(value);
        }
    }

    void showConfirmDialog(String msg) {
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
        NotifyDescriptor confirmDialog = new NotifyDescriptor((Object)msg, NbBundle.getBundle(EditPanelQuery.class).getString("MON_Confirmation_Required"), 2, 3, options, NotifyDescriptor.CANCEL_OPTION);
        DialogDisplayer.getDefault().notify(confirmDialog);
        this.setParams = confirmDialog.getValue().equals(NotifyDescriptor.OK_OPTION);
    }

    void showErrorDialog() {
        Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
        NotifyDescriptor errorDialog = new NotifyDescriptor((Object)NbBundle.getBundle(EditPanelQuery.class).getString("MON_Bad_param"), NbBundle.getBundle(EditPanelQuery.class).getString("MON_Invalid_input"), -1, 0, options, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(errorDialog);
    }

    @Override
    void log(String s) {
        System.out.println("EditPanelQuery::" + s);
    }
}

