/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.ComponentsFieldFinder;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.RetrievalException;
import org.netbeans.modules.debugger.jpda.visual.actions.ComponentBreakpointActionProvider;
import org.netbeans.modules.debugger.jpda.visual.actions.CreateFixedWatchAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToAddIntoHierarchyAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToFieldDeclarationAction;
import org.netbeans.modules.debugger.jpda.visual.actions.GoToSourceAction;
import org.netbeans.modules.debugger.jpda.visual.actions.ShowListenersAction;
import org.netbeans.modules.debugger.jpda.visual.actions.ToggleComponentBreakpointAction;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.models.ComponentBreakpointsActionsProvider;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RemoteAWTScreenshot {
    private static final Logger logger = Logger.getLogger(RemoteAWTScreenshot.class.getName());
    static final String AWTThreadName = "AWT-EventQueue-";
    private static final RemoteScreenshot[] NO_SCREENSHOTS = new RemoteScreenshot[0];
    static final boolean FAST_SNAPSHOT_RETRIEVAL = RemoteAWTScreenshot.getBooleanProperty("visualDebugger.fastSnapshot", true);
    static final boolean FAST_FIELDS_SEARCH = RemoteAWTScreenshot.getBooleanProperty("visualDebugger.fastFieldsSearch", true);
    private static final char STRING_DELIMITER = '\u0003';

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean result = defaultValue;
        String val = System.getProperty(name);
        if (val != null) {
            result = Boolean.parseBoolean(val);
        }
        return result;
    }

    private RemoteAWTScreenshot() {
    }

    private static RemoteScreenshot createRemoteAWTScreenshot(DebuggerEngine engine, String title, int width, int height, int[] dataArray, AWTComponentInfo componentInfo) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        WritableRaster raster = bi.getRaster();
        raster.setDataElements(0, 0, width, height, dataArray);
        if (FAST_FIELDS_SEARCH) {
            ComponentsFieldFinder.findFieldsForComponents(componentInfo);
        }
        return new RemoteScreenshot(engine, title, width, height, bi, componentInfo);
    }

    public static RemoteScreenshot[] takeCurrent() throws RetrievalException {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            logger.fine("Debugger = " + debugger);
            if (debugger != null) {
                return RemoteAWTScreenshot.takeCurrent(debugger, engine);
            }
        }
        return NO_SCREENSHOTS;
    }

    public static RemoteScreenshot[] takeCurrent(JPDADebugger debugger) throws RetrievalException {
        DebuggerEngine engine = ((JPDADebuggerImpl)debugger).getSession().getCurrentEngine();
        return RemoteAWTScreenshot.takeCurrent(debugger, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RemoteScreenshot[] takeCurrent(JPDADebugger debugger, DebuggerEngine engine) throws RetrievalException {
        List allThreads = debugger.getThreadsCollector().getAllThreads();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Threads = {0}", allThreads);
        }
        RemoteScreenshot[] rs = NO_SCREENSHOTS;
        for (JPDAThread t : allThreads) {
            long t1;
            block5: {
                if (!t.getName().startsWith(AWTThreadName)) continue;
                t1 = System.nanoTime();
                try {
                    RemoteScreenshot[] rst = RemoteAWTScreenshot.take(t, engine);
                    if (rst.length <= 0) break block5;
                    if (rs.length > 0) {
                        RemoteScreenshot[] nrs = new RemoteScreenshot[rs.length + rst.length];
                        System.arraycopy(rs, 0, nrs, 0, rs.length);
                        System.arraycopy(rst, 0, nrs, rs.length, rst.length);
                        rs = nrs;
                        break block5;
                    }
                    rs = rst;
                }
                catch (Throwable throwable) {
                    long t2 = System.nanoTime();
                    long ns = t2 - t1;
                    long ms = ns / 1000000L;
                    logger.info("GUI Snaphot taken in " + (ms > 0L ? ms + " ms " + (ns - ms * 1000000L) + " ns." : ns + " ns."));
                    throw throwable;
                }
            }
            long t2 = System.nanoTime();
            long ns = t2 - t1;
            long ms = ns / 1000000L;
            logger.info("GUI Snaphot taken in " + (ms > 0L ? ms + " ms " + (ns - ms * 1000000L) + " ns." : ns + " ns."));
        }
        return rs;
    }

    public static RemoteScreenshot[] take(final JPDAThread t, final DebuggerEngine engine) throws RetrievalException {
        ClassType serviceClass;
        ClassType windowClass;
        final ThreadReference tawt = ((JPDAThreadImpl)t).getThreadReference();
        final VirtualMachine vm = tawt.virtualMachine();
        try {
            windowClass = RemoteServices.getClass(vm, "java.awt.Window");
        }
        catch (InternalExceptionWrapper ex) {
            return NO_SCREENSHOTS;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return NO_SCREENSHOTS;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return NO_SCREENSHOTS;
        }
        if (windowClass == null) {
            logger.fine("No Window");
            return NO_SCREENSHOTS;
        }
        JPDADebuggerImpl debugger = ((JPDAThreadImpl)t).getDebugger();
        ClassObjectReference serviceClassObject = RemoteServices.getServiceClass((JPDADebugger)debugger, RemoteServices.ServiceType.AWT);
        try {
            serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
        }
        catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            return NO_SCREENSHOTS;
        }
        final ArrayList screenshots = new ArrayList();
        final RetrievalException[] retrievalExceptionPtr = new RetrievalException[]{null};
        try {
            RemoteServices.runOnStoppedThread(t, new Runnable(){
                final /* synthetic */ JPDADebugger val$debugger;
                {
                    this.val$debugger = jPDADebugger;
                }

                @Override
                public void run() {
                    logger.fine("RemoteScreenshot.take(" + t + ")");
                    try {
                        if (FAST_SNAPSHOT_RETRIEVAL) {
                            Method getGUISnapshots = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"getGUISnapshots", (String)"()[Lorg/netbeans/modules/debugger/jpda/visual/remote/RemoteAWTService$Snapshot;");
                            ArrayReference snapshotsArray = (ArrayReference)ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)tawt, (Method)getGUISnapshots, Collections.emptyList(), (int)1);
                            List snapshots = ArrayReferenceWrapper.getValues((ArrayReference)snapshotsArray);
                            for (Value snapshot : snapshots) {
                                ObjectReference snapshotObj = (ObjectReference)snapshot;
                                ReferenceType rt = ObjectReferenceWrapper.referenceType((ObjectReference)snapshotObj);
                                StringReference allIntDataString = (StringReference)ObjectReferenceWrapper.getValue((ObjectReference)snapshotObj, (Field)ReferenceTypeWrapper.fieldByName((ReferenceType)rt, (String)"allIntDataString"));
                                int[] allIntData = RemoteAWTScreenshot.createIntArrayFromString(StringReferenceWrapper.value((StringReference)allIntDataString));
                                StringReference allNamesString = (StringReference)ObjectReferenceWrapper.getValue((ObjectReference)snapshotObj, (Field)ReferenceTypeWrapper.fieldByName((ReferenceType)rt, (String)"allNamesString"));
                                ArrayReference allComponentsArray = (ArrayReference)ObjectReferenceWrapper.getValue((ObjectReference)snapshotObj, (Field)ReferenceTypeWrapper.fieldByName((ReferenceType)rt, (String)"allComponentsArray"));
                                StringReference componentsAddAtString = (StringReference)ObjectReferenceWrapper.getValue((ObjectReference)snapshotObj, (Field)ReferenceTypeWrapper.fieldByName((ReferenceType)rt, (String)"componentsAddAt"));
                                String allNames = StringReferenceWrapper.value((StringReference)allNamesString);
                                String componentsAddAt = StringReferenceWrapper.value((StringReference)componentsAddAtString);
                                int ititle = allNames.indexOf(3);
                                String title = new String(allNames.substring(0, ititle)).intern();
                                if (title.length() == 1 && title.charAt(0) == '\u0000') {
                                    title = null;
                                }
                                int ndata = allIntData[2];
                                int[] dataArray = new int[ndata];
                                System.arraycopy(allIntData, 3, dataArray, 0, ndata);
                                AWTComponentInfo componentInfo = new AWTComponentInfo((JPDAThreadImpl)t, allIntData, new int[]{ndata + 3}, allNames, new int[]{ititle + 1}, allComponentsArray.getValues(), new int[]{0}, componentsAddAt, new int[]{0});
                                screenshots.add(RemoteAWTScreenshot.createRemoteAWTScreenshot(engine, title, allIntData[0], allIntData[1], dataArray, componentInfo));
                            }
                            ClassTypeWrapper.setValue((ClassType)serviceClass, (Field)ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClass, (String)"lastGUISnapshots"), null);
                            return;
                        }
                        Method getWindows = windowClass.concreteMethodByName("getWindows", "()[Ljava/awt/Window;");
                        if (getWindows == null) {
                            logger.fine("No getWindows() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getWindows()");
                            throw new RetrievalException(msg);
                        }
                        ArrayReference windowsArray = (ArrayReference)windowClass.invokeMethod(tawt, getWindows, Collections.emptyList(), 1);
                        List<Value> windows = windowsArray.getValues();
                        logger.fine("Have " + windows.size() + " window(s).");
                        Method isVisible = windowClass.concreteMethodByName("isVisible", "()Z");
                        if (isVisible == null) {
                            logger.fine("No isVisible() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.isVisible()");
                            throw new RetrievalException(msg);
                        }
                        Method getOwner = windowClass.concreteMethodByName("getOwner", "()Ljava/awt/Window;");
                        if (getOwner == null) {
                            logger.fine("No getOwner() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getOwner()");
                            throw new RetrievalException(msg);
                        }
                        Method getSize = windowClass.concreteMethodByName("getSize", "()Ljava/awt/Dimension;");
                        if (getSize == null) {
                            logger.fine("No getSize() method!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Window.getSize()");
                            throw new RetrievalException(msg);
                        }
                        ClassType dimensionClass = RemoteServices.getClass(vm, "java.awt.Dimension");
                        if (dimensionClass == null) {
                            logger.fine("No Dimension");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingClass", (Object)"java.awt.Dimension");
                            throw new RetrievalException(msg);
                        }
                        ClassType bufferedImageClass = RemoteServices.getClass(vm, "java.awt.image.BufferedImage");
                        if (bufferedImageClass == null) {
                            logger.fine("No BufferedImage class.");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingClass", (Object)"java.awt.image.BufferedImage");
                            throw new RetrievalException(msg);
                        }
                        Method bufferedImageConstructor = bufferedImageClass.concreteMethodByName("<init>", "(III)V");
                        Method createGraphics = bufferedImageClass.concreteMethodByName("createGraphics", "()Ljava/awt/Graphics2D;");
                        if (createGraphics == null) {
                            logger.fine("createGraphics() method is not found!");
                            String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.image.BufferedImage.createGraphics()");
                            throw new RetrievalException(msg);
                        }
                        ClassType frameClass = RemoteServices.getClass(vm, "java.awt.Frame");
                        Method getFrameTitle = null;
                        if (frameClass != null) {
                            getFrameTitle = frameClass.concreteMethodByName("getTitle", "()Ljava/lang/String;");
                        }
                        ClassType dialogClass = RemoteServices.getClass(vm, "java.awt.Dialog");
                        Method getDialogTitle = null;
                        if (dialogClass != null) {
                            getDialogTitle = dialogClass.concreteMethodByName("getTitle", "()Ljava/lang/String;");
                        }
                        for (Value windowValue : windows) {
                            StringReference sr;
                            Value v2;
                            Value owner;
                            ObjectReference window = (ObjectReference)windowValue;
                            BooleanValue visible = (BooleanValue)window.invokeMethod(tawt, isVisible, Collections.emptyList(), 1);
                            if (!visible.value()) {
                                // empty if block
                            }
                            if ((owner = window.invokeMethod(tawt, getOwner, Collections.emptyList(), 1)) != null) {
                                // empty if block
                            }
                            ObjectReference sizeDimension = (ObjectReference)window.invokeMethod(tawt, getSize, Collections.emptyList(), 1);
                            Field field = dimensionClass.fieldByName("width");
                            IntegerValue widthValue = (IntegerValue)sizeDimension.getValue(field);
                            int width = widthValue.value();
                            field = dimensionClass.fieldByName("height");
                            IntegerValue heightValue = (IntegerValue)sizeDimension.getValue(field);
                            int height = heightValue.value();
                            logger.log(Level.FINE, "The size is {0} x {1}", new Object[]{width, height});
                            List<IntegerValue> args = Arrays.asList(widthValue, heightValue, vm.mirrorOf(2));
                            ObjectReference bufferedImage = bufferedImageClass.newInstance(tawt, bufferedImageConstructor, args, 1);
                            ObjectReference graphics = (ObjectReference)bufferedImage.invokeMethod(tawt, createGraphics, Collections.emptyList(), 1);
                            Method paint = windowClass.concreteMethodByName("paint", "(Ljava/awt/Graphics;)V");
                            window.invokeMethod(tawt, paint, Arrays.asList(graphics), 1);
                            Method getData = bufferedImageClass.concreteMethodByName("getData", "()Ljava/awt/image/Raster;");
                            ObjectReference raster = (ObjectReference)bufferedImage.invokeMethod(tawt, getData, Collections.emptyList(), 1);
                            Method getDataElements = ((ClassType)raster.referenceType()).concreteMethodByName("getDataElements", "(IIIILjava/lang/Object;)Ljava/lang/Object;");
                            IntegerValue zero = vm.mirrorOf(0);
                            ArrayReference data = (ArrayReference)raster.invokeMethod(tawt, getDataElements, Arrays.asList(zero, zero, widthValue, heightValue, null), 1);
                            logger.log(Level.FINE, "Image data length = {0}", data.length());
                            List<Value> dataValues = data.getValues();
                            int[] dataArray = new int[data.length()];
                            int i = 0;
                            for (Value v2 : dataValues) {
                                dataArray[i++] = ((IntegerValue)v2).value();
                            }
                            String title = null;
                            if (frameClass != null && EvaluatorVisitor.instanceOf((Type)window.referenceType(), (Type)frameClass) && (v2 = window.invokeMethod(tawt, getFrameTitle, Collections.emptyList(), 1)) instanceof StringReference) {
                                sr = (StringReference)v2;
                                title = sr.value();
                            }
                            if (dialogClass != null && EvaluatorVisitor.instanceOf((Type)window.referenceType(), (Type)dialogClass) && (v2 = window.invokeMethod(tawt, getDialogTitle, Collections.emptyList(), 1)) instanceof StringReference) {
                                sr = (StringReference)v2;
                                title = sr.value();
                            }
                            AWTComponentInfo componentInfo = new AWTComponentInfo((JPDAThreadImpl)t, window);
                            screenshots.add(RemoteAWTScreenshot.createRemoteAWTScreenshot(engine, title, width, height, dataArray, componentInfo));
                        }
                    }
                    catch (RetrievalException rex) {
                        retrievalExceptionPtr[0] = rex;
                    }
                    catch (InvocationException iex) {
                        ((JPDAThreadImpl)t).notifyMethodInvokeDone();
                        InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(iex, (JPDADebuggerImpl)this.val$debugger);
                        iextr.setPreferredThread((JPDAThreadImpl)t);
                        iextr.getMessage();
                        iextr.getLocalizedMessage();
                        iextr.getCause();
                        iextr.getStackTrace();
                        logger.log(Level.INFO, iex.getMessage(), (Throwable)iextr);
                        retrievalExceptionPtr[0] = new RetrievalException(iex.getMessage(), (Throwable)iextr);
                    }
                    catch (InvalidTypeException itex) {
                        retrievalExceptionPtr[0] = new RetrievalException(itex.getMessage(), itex);
                    }
                    catch (ClassNotLoadedException cnlex) {
                        return;
                    }
                    catch (IncompatibleThreadStateException itsex) {
                        retrievalExceptionPtr[0] = new RetrievalException(itsex.getMessage(), itsex);
                    }
                    catch (ClassNotPreparedExceptionWrapper cnpex) {
                        return;
                    }
                    catch (InternalExceptionWrapper iex) {
                        return;
                    }
                    catch (ObjectCollectedExceptionWrapper ocex) {
                        Exceptions.printStackTrace((Throwable)ocex);
                        return;
                    }
                    catch (VMDisconnectedExceptionWrapper vmdex) {
                        return;
                    }
                }
            }, RemoteServices.ServiceType.AWT);
        }
        catch (PropertyVetoException pvex) {
            throw new RetrievalException(pvex.getMessage(), pvex);
        }
        if (retrievalExceptionPtr[0] != null) {
            throw retrievalExceptionPtr[0];
        }
        return screenshots.toArray(new RemoteScreenshot[0]);
    }

    private static void retrieveComponents(AWTComponentInfo ci, JPDAThreadImpl t, VirtualMachine vm, ClassType componentClass, ClassType containerClass, ObjectReference component, Method getComponents, Method getBounds, int shiftx, int shifty) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, RetrievalException {
        ClassType rectangleClass;
        ThreadReference tawt = t.getThreadReference();
        ObjectReference rectangle = (ObjectReference)component.invokeMethod(tawt, getBounds, Collections.emptyList(), 1);
        try {
            rectangleClass = RemoteServices.getClass(vm, "java.awt.Rectangle");
        }
        catch (InternalExceptionWrapper ex) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return;
        }
        Field fx = rectangleClass.fieldByName("x");
        Field fy = rectangleClass.fieldByName("y");
        Field fwidth = rectangleClass.fieldByName("width");
        Field fheight = rectangleClass.fieldByName("height");
        Map<Field, Value> rvalues = rectangle.getValues(Arrays.asList(fx, fy, fwidth, fheight));
        Rectangle r = new Rectangle();
        r.x = ((IntegerValue)rvalues.get(fx)).value();
        r.y = ((IntegerValue)rvalues.get(fy)).value();
        r.width = ((IntegerValue)rvalues.get(fwidth)).value();
        r.height = ((IntegerValue)rvalues.get(fheight)).value();
        ci.setBounds(r);
        if (shiftx == Integer.MIN_VALUE && shifty == Integer.MIN_VALUE) {
            shifty = 0;
            shiftx = 0;
        } else {
            ci.setWindowBounds(new Rectangle(shiftx += r.x, shifty += r.y, r.width, r.height));
        }
        Method getName = componentClass.concreteMethodByName("getName", "()Ljava/lang/String;");
        StringReference name = (StringReference)component.invokeMethod(tawt, getName, Collections.emptyList(), 1);
        if (name != null) {
            ci.setName(name.value());
        }
        ci.setComponent(component);
        ci.setType(component.referenceType().name());
        logger.log(Level.FINE, "  Component ''{0}'' class=''{1}'' bounds = {2}", new Object[]{ci.getName(), ci.getType(), r});
        if (RemoteAWTScreenshot.isInstanceOfClass((ClassType)component.referenceType(), containerClass)) {
            ArrayReference componentsArray = (ArrayReference)component.invokeMethod(tawt, getComponents, Collections.emptyList(), 1);
            List<Value> components = componentsArray.getValues();
            logger.log(Level.FINE, "Have {0} component(s).", components.size());
            if (components.size() > 0) {
                JavaComponentInfo[] cis = new AWTComponentInfo[components.size()];
                int i = 0;
                for (Value cv : components) {
                    ObjectReference c = (ObjectReference)cv;
                    cis[i] = new AWTComponentInfo(t, c, shiftx, shifty);
                    ++i;
                }
                ci.setSubComponents(cis);
            }
        }
    }

    private static int[] createIntArrayFromString(String s) {
        int i1 = 0;
        int i2 = s.indexOf(91);
        int n = Integer.parseInt(s.substring(i1, i2));
        int[] array = new int[n];
        for (int i = 0; i < n; ++i) {
            i1 = i2 + 1;
            if ((i2 = s.indexOf(44, i1)) < 0) {
                i2 = s.indexOf(93, i1);
            }
            array[i] = Integer.parseInt(s.substring(i1, i2));
        }
        return array;
    }

    private static boolean isInstanceOfClass(ClassType c1, ClassType c2) {
        if (c1.equals(c2)) {
            return true;
        }
        if ((c1 = c1.superclass()) == null) {
            return false;
        }
        return RemoteAWTScreenshot.isInstanceOfClass(c1, c2);
    }

    public static class AWTComponentInfo
    extends JavaComponentInfo {
        private int shiftX;
        private int shiftY;
        private boolean visible;
        private VirtualMachine vm;
        private ClassType containerClass;
        private ClassType componentClass;
        private Method getBounds;
        private Method getComponents;
        private String addAtStr;
        private JavaComponentInfo.Stack addAt;
        private static final Action CBP_CUSTOMIZE_ACTION = new NodeAction(){

            public String getName() {
                return NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"CTL_Component_Breakpoint_Customize_Label");
            }

            protected boolean enable(Node[] activatedNodes) {
                return true;
            }

            protected boolean asynchronous() {
                return false;
            }

            protected void performAction(Node[] activatedNodes) {
                for (Node n : activatedNodes) {
                    ObjectReference component;
                    ComponentBreakpoint b;
                    JavaComponentInfo ci = (JavaComponentInfo)n.getLookup().lookup(JavaComponentInfo.class);
                    if (ci == null || (b = ComponentBreakpointActionProvider.findBreakpoint(component = ci.getComponent())) == null) continue;
                    ComponentBreakpointsActionsProvider.customize(b);
                }
            }

            public HelpCtx getHelpCtx() {
                return new HelpCtx("AWTComponentBreakpoint_Customize");
            }
        };

        public AWTComponentInfo(JPDAThreadImpl t, ObjectReference component) throws RetrievalException {
            this(t, component, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        public AWTComponentInfo(JPDAThreadImpl t, ObjectReference component, int shiftX, int shiftY) throws RetrievalException {
            super(t, component, RemoteServices.ServiceType.AWT);
            this.vm = this.getThread().getDebugger().getVirtualMachine();
            if (this.vm == null) {
                throw RetrievalException.disconnected();
            }
            try {
                this.containerClass = RemoteServices.getClass(this.vm, "java.awt.Container");
                this.componentClass = RemoteServices.getClass(this.vm, "java.awt.Component");
            }
            catch (InternalExceptionWrapper ex) {
                throw new RetrievalException(ex.getLocalizedMessage(), ex);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw new RetrievalException(ex.getLocalizedMessage(), ex);
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new RetrievalException(ex.getLocalizedMessage(), ex);
            }
            this.getBounds = this.componentClass.concreteMethodByName("getBounds", "()Ljava/awt/Rectangle;");
            this.getComponents = this.containerClass.concreteMethodByName("getComponents", "()[Ljava/awt/Component;");
            if (this.getComponents == null) {
                logger.fine("No getComponents() method!");
                String msg = NbBundle.getMessage(RemoteAWTScreenshot.class, (String)"MSG_ScreenshotNotTaken_MissingMethod", (Object)"java.awt.Container.getComponents()");
                throw new RetrievalException(msg);
            }
            this.shiftX = shiftX;
            this.shiftY = shiftY;
            this.visible = true;
            this.init();
        }

        public AWTComponentInfo(JPDAThreadImpl t, int[] allDataArray, int[] dposPtr, String allNames, int[] inamePtr, List<Value> allComponentsArray, int[] cposPtr, String componentsAddAt, int[] iaddPtr) throws RetrievalException {
            int n = cposPtr[0];
            cposPtr[0] = n + 1;
            super(t, (ObjectReference)allComponentsArray.get(n), RemoteServices.ServiceType.AWT);
            Rectangle bounds = new Rectangle();
            int dpos = dposPtr[0];
            bounds.x = allDataArray[dpos++];
            bounds.y = allDataArray[dpos++];
            bounds.width = allDataArray[dpos++];
            bounds.height = allDataArray[dpos++];
            this.setBounds(bounds);
            this.shiftX = allDataArray[dpos++];
            this.shiftY = allDataArray[dpos++];
            this.visible = allDataArray[dpos++] != 0;
            this.setWindowBounds(new Rectangle(this.shiftX, this.shiftY, bounds.width, bounds.height));
            int iname = allNames.indexOf(3, inamePtr[0]);
            String name = allNames.substring(inamePtr[0], iname);
            name = name.length() == 1 && name.charAt(0) == '\u0000' ? null : new String(name).intern();
            this.setName(name);
            inamePtr[0] = iname + 1;
            int iaddAt = componentsAddAt.indexOf(3, iaddPtr[0]);
            String addAt = componentsAddAt.substring(iaddPtr[0], iaddAt);
            if ("null".equals(addAt)) {
                addAt = null;
            }
            this.setAddAt(addAt);
            iaddPtr[0] = iaddAt + 1;
            int nsc = allDataArray[dpos++];
            dposPtr[0] = dpos;
            if (nsc > 0) {
                JavaComponentInfo[] cis = new AWTComponentInfo[nsc];
                for (int i = 0; i < nsc; ++i) {
                    cis[i] = new AWTComponentInfo(this.getThread(), allDataArray, dposPtr, allNames, inamePtr, allComponentsArray, cposPtr, componentsAddAt, iaddPtr);
                }
                this.setSubComponents(cis);
            }
            this.init();
        }

        private void setAddAt(String addAtStr) {
            this.addAtStr = addAtStr;
        }

        @Override
        public JavaComponentInfo.Stack getAddCallStack() {
            if (!FAST_SNAPSHOT_RETRIEVAL) {
                return super.getAddCallStack();
            }
            if (this.addAtStr == null) {
                return null;
            }
            if (this.addAt == null) {
                JavaComponentInfo.Stack.Frame f = JavaComponentInfo.Stack.Frame.parseLine(this.addAtStr);
                JavaComponentInfo.Stack.Frame[] frames = new JavaComponentInfo.Stack.Frame[]{f};
                this.addAt = new JavaComponentInfo.Stack(frames);
            }
            return this.addAt;
        }

        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public Action[] getActions(boolean context) {
            ObjectReference component = this.getComponent();
            ComponentBreakpoint b = ComponentBreakpointActionProvider.findBreakpoint(component);
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(GoToFieldDeclarationAction.get(GoToFieldDeclarationAction.class));
            actions.add(GoToSourceAction.get(GoToSourceAction.class));
            if (this.getAddCallStack() != null) {
                actions.add(GoToAddIntoHierarchyAction.get(GoToAddIntoHierarchyAction.class));
            }
            actions.add(null);
            actions.add(ShowListenersAction.get(ShowListenersAction.class));
            actions.add(CreateFixedWatchAction.get(CreateFixedWatchAction.class));
            actions.add(null);
            actions.add(ToggleComponentBreakpointAction.get(ToggleComponentBreakpointAction.class));
            if (b != null) {
                actions.add(CBP_CUSTOMIZE_ACTION);
            }
            actions.add(null);
            actions.add(PropertiesAction.get(PropertiesAction.class));
            return actions.toArray(new Action[0]);
        }

        @Override
        public ComponentInfo findAt(int x, int y) {
            Rectangle bounds = this.getBounds();
            if (!bounds.contains(x, y)) {
                return null;
            }
            x -= bounds.x;
            y -= bounds.y;
            JavaComponentInfo[] subComponents = this.getSubComponents();
            if (subComponents != null) {
                ComponentInfo invisible = null;
                for (int i = 0; i < subComponents.length; ++i) {
                    Rectangle sb = subComponents[i].getBounds();
                    if (!sb.contains(x, y)) continue;
                    if (subComponents[i] instanceof AWTComponentInfo && !((AWTComponentInfo)subComponents[i]).isVisible()) {
                        if (invisible != null) continue;
                        invisible = subComponents[i];
                        continue;
                    }
                    ComponentInfo tci = subComponents[i].findAt(x, y);
                    Rectangle tbounds = tci.getBounds();
                    if (tbounds.width >= bounds.width && tbounds.height >= bounds.height) continue;
                    return tci;
                }
                if (invisible != null) {
                    ComponentInfo tci = invisible.findAt(x, y);
                    Rectangle tbounds = tci.getBounds();
                    if (tbounds.width < bounds.width || tbounds.height < bounds.height) {
                        return tci;
                    }
                }
            }
            return this;
        }

        @Override
        protected void retrieve() throws RetrievalException {
            if (this.componentClass == null) {
                return;
            }
            try {
                RemoteAWTScreenshot.retrieveComponents(this, this.getThread(), this.vm, this.componentClass, this.containerClass, this.getComponent(), this.getComponents, this.getBounds, this.shiftX, this.shiftY);
                if (this.shiftX == Integer.MIN_VALUE && this.shiftY == Integer.MIN_VALUE) {
                    this.getBounds().x = 0;
                    this.getBounds().y = 0;
                }
            }
            catch (RetrievalException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RetrievalException(e.getMessage(), e);
            }
        }
    }
}

