/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import com.sun.el.parser.AstAssign;
import com.sun.el.parser.AstBracketSuffix;
import com.sun.el.parser.AstDeferredExpression;
import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstDynamicExpression;
import com.sun.el.parser.AstFunction;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstInteger;
import com.sun.el.parser.AstLambdaExpression;
import com.sun.el.parser.AstListData;
import com.sun.el.parser.AstMapData;
import com.sun.el.parser.AstMethodArguments;
import com.sun.el.parser.AstSemiColon;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionProposal;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.NodeUtil;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.completion.ELAssignedVariableCompletionItem;
import org.netbeans.modules.web.el.completion.ELElementHandle;
import org.netbeans.modules.web.el.completion.ELFunctionCompletionItem;
import org.netbeans.modules.web.el.completion.ELImplictObjectCompletionItem;
import org.netbeans.modules.web.el.completion.ELJavaCompletion;
import org.netbeans.modules.web.el.completion.ELJavaCompletionItem;
import org.netbeans.modules.web.el.completion.ELKeywordCompletionItem;
import org.netbeans.modules.web.el.completion.ELRawObjectPropertyCompletionItem;
import org.netbeans.modules.web.el.completion.ELResourceBundleCompletionItem;
import org.netbeans.modules.web.el.completion.ELResourceBundleKeyCompletionItem;
import org.netbeans.modules.web.el.completion.ELSanitizer;
import org.netbeans.modules.web.el.completion.ELStreamCompletionItem;
import org.netbeans.modules.web.el.completion.ELVariableCompletionItem;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class ELCodeCompletionHandler
implements CodeCompletionHandler2 {
    private static Set<String> keywordFixedTexts = null;

    private static synchronized Set<String> getKeywordFixedTexts() {
        if (keywordFixedTexts == null) {
            keywordFixedTexts = new HashSet<String>();
            for (ELTokenId elTokenId : ELTokenId.values()) {
                if (!ELTokenId.ELTokenCategories.KEYWORDS.hasCategory((TokenId)elTokenId)) continue;
                keywordFixedTexts.add(elTokenId.fixedText());
            }
        }
        return keywordFixedTexts;
    }

    public CodeCompletionResult complete(final CodeCompletionContext context) {
        ResourceBundles bundle;
        String bundleIdentifier;
        final ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(50);
        DefaultCompletionResult result = new DefaultCompletionResult(proposals, false);
        final ELElement element = ELCodeCompletionHandler.getElementAt(context.getParserResult(), context.getCaretOffset());
        if (element == null || !element.isValid()) {
            return CodeCompletionResult.NONE;
        }
        final Node target = this.getTargetNode(element, context.getCaretOffset());
        if (target == null) {
            return CodeCompletionResult.NONE;
        }
        AstPath path = new AstPath(element.getNode());
        final List<Node> rootToNode = path.rootToNode(target);
        if (rootToNode.isEmpty()) {
            return result;
        }
        final PrefixMatcher prefixMatcher = PrefixMatcher.create(target, context);
        if (prefixMatcher == null) {
            return CodeCompletionResult.NONE;
        }
        if (target instanceof AstString && (bundleIdentifier = (bundle = ResourceBundles.get(this.getFileObject(context))).findResourceBundleIdentifier(path)) != null) {
            this.proposeBundleKeysInArrayNotation(context, prefixMatcher, element, bundleIdentifier, (AstString)target, proposals);
            return proposals.isEmpty() ? CodeCompletionResult.NONE : result;
        }
        final Node nodeToResolve = ELCodeCompletionHandler.getNodeToResolve(target, rootToNode);
        final Map<AstIdentifier, Node> assignments = this.getAssignments(context.getParserResult(), context.getCaretOffset());
        final FileObject file = context.getParserResult().getSnapshot().getSource().getFileObject();
        JavaSource jsource = JavaSource.create((ClasspathInfo)ELTypeUtilities.getElimplExtendedCPI(file), (FileObject[])new FileObject[0]);
        try {
            jsource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationContext ccontext = CompilationContext.create(file, (CompilationInfo)info);
                    Node node = nodeToResolve instanceof AstIdentifier && assignments.containsKey((AstIdentifier)nodeToResolve) ? (Node)assignments.get((AstIdentifier)nodeToResolve) : nodeToResolve;
                    List<ELVariableResolver.VariableInfo> attrsObjects = Collections.emptyList();
                    if (ELTypeUtilities.isRawObjectReference(ccontext, node, false)) {
                        attrsObjects = ELVariableResolvers.getRawObjectProperties(ccontext, "attrs", context.getParserResult().getSnapshot());
                    }
                    Element resolved = null;
                    if (!ELCodeCompletionHandler.isInLambda(rootToNode)) {
                        resolved = ELTypeUtilities.resolveElement(ccontext, element, nodeToResolve, assignments, attrsObjects);
                    }
                    if (ELTypeUtilities.isStaticIterableElement(ccontext, node)) {
                        ELCodeCompletionHandler.this.proposeStream(ccontext, context, prefixMatcher, proposals);
                    } else if (ELTypeUtilities.isRawObjectReference(ccontext, node, true)) {
                        ELCodeCompletionHandler.this.proposeRawObjectProperties(ccontext, context, prefixMatcher, node, proposals);
                    } else if (ELTypeUtilities.isScopeObject(ccontext, node)) {
                        ELCodeCompletionHandler.this.proposeBeansFromScope(ccontext, context, prefixMatcher, element, node, proposals);
                    } else if (ELTypeUtilities.isResourceBundleVar(ccontext, node)) {
                        ELCodeCompletionHandler.this.proposeBundleKeysInDotNotation(context, prefixMatcher, element, node, proposals);
                    } else if (resolved == null) {
                        if (!(target instanceof AstDotSuffix) && !(node instanceof AstFunction)) {
                            ELCodeCompletionHandler.this.proposeFunctions(ccontext, context, prefixMatcher, element, proposals);
                            ELCodeCompletionHandler.this.proposeManagedBeans(ccontext, context, prefixMatcher, element, proposals);
                            ELCodeCompletionHandler.this.proposeBundles(ccontext, context, prefixMatcher, element, proposals);
                            ELCodeCompletionHandler.this.proposeVariables(ccontext, context, prefixMatcher, element, proposals);
                            ELCodeCompletionHandler.this.proposeImpicitObjects(ccontext, context, prefixMatcher, proposals);
                            ELCodeCompletionHandler.this.proposeKeywords(context, prefixMatcher, proposals);
                            ELCodeCompletionHandler.this.proposeAssignements(context, prefixMatcher, assignments, proposals);
                        }
                        if ("stream".equals(node.getImage())) {
                            ELCodeCompletionHandler.this.proposeOperators(ccontext, context, prefixMatcher, element, proposals, rootToNode, ELCodeCompletionHandler.isBracketProperty(target, rootToNode));
                        }
                        ELJavaCompletion.propose(ccontext, context, element, target, proposals);
                    } else {
                        ELCodeCompletionHandler.this.proposeMethods(ccontext, context, resolved, prefixMatcher, element, proposals, rootToNode, ELCodeCompletionHandler.isBracketProperty(target, rootToNode));
                        if (ELTypeUtilities.isIterableElement(ccontext, resolved)) {
                            ELCodeCompletionHandler.this.proposeStream(ccontext, context, prefixMatcher, proposals);
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return proposals.isEmpty() ? CodeCompletionResult.NONE : result;
    }

    private static boolean isBracketProperty(Node target, List<Node> rootToNode) {
        Node previous = rootToNode.get(rootToNode.size() - 1);
        return target instanceof AstString && previous instanceof AstBracketSuffix;
    }

    private static Node getNodeToResolve(Node target, List<Node> rootToNode) {
        Node previous = rootToNode.get(rootToNode.size() - 1);
        if (target instanceof AstString && previous instanceof AstBracketSuffix) {
            return rootToNode.get(rootToNode.size() - 2);
        }
        if (target instanceof AstIdentifier && (previous instanceof AstIdentifier || previous instanceof AstDotSuffix || NodeUtil.isMethodCall(previous) || target.jjtGetParent() instanceof AstSemiColon)) {
            return target;
        }
        for (int i = rootToNode.size() - 1; i >= 0; --i) {
            Node node = rootToNode.get(i);
            if (ELCodeCompletionHandler.isArrayIndexCall(rootToNode, i)) {
                return node;
            }
            if (node instanceof AstMethodArguments) {
                return rootToNode.get(i - 1);
            }
            if (node instanceof AstListData || node instanceof AstMapData) {
                return node;
            }
            if (node.jjtGetParent() instanceof AstSemiColon) {
                return previous;
            }
            if (!(node instanceof AstIdentifier) && !(node instanceof AstDotSuffix)) continue;
            return node;
        }
        return previous;
    }

    private static boolean isArrayIndexCall(List<Node> rootToNode, int nodeIndex) {
        for (int i = nodeIndex; i >= 0; --i) {
            if (!(rootToNode.get(nodeIndex) instanceof AstInteger) || !(rootToNode.get(i) instanceof AstBracketSuffix)) continue;
            return true;
        }
        return false;
    }

    private static ELElement getElementAt(ParserResult parserResult, int offset) {
        ELParserResult elParserResult = (ELParserResult)parserResult;
        ELElement result = elParserResult.getElementAt(offset);
        if (result == null || result.isValid()) {
            return result;
        }
        ELSanitizer sanitizer = new ELSanitizer(result, offset - result.getOriginalOffset().getStart());
        return sanitizer.sanitized();
    }

    private Map<AstIdentifier, Node> getAssignments(ParserResult parserResult, int offset) {
        HashMap<AstIdentifier, Node> result = new HashMap<AstIdentifier, Node>();
        ELParserResult elParserResult = (ELParserResult)parserResult;
        for (ELElement elElement : elParserResult.getElementsTo(offset)) {
            if (elElement.getError() != null) {
                elElement = ELCodeCompletionHandler.getElementAt(parserResult, offset);
            }
            if (elElement.getNode() == null) continue;
            AstPath astPath = new AstPath(elElement.getNode());
            for (Node node : astPath.rootToLeaf()) {
                if (!(node instanceof AstAssign)) continue;
                Node leftSide = node.jjtGetChild(0);
                Node leaf = ELCodeCompletionHandler.getLastAssigneableLeaf(elElement.getNode());
                Node targetNode = this.getTargetNode(elElement, elElement.getOriginalOffset().getStart() + leaf.endOffset());
                Node rightSide = ELCodeCompletionHandler.getNodeToResolve(targetNode, astPath.rootToNode(targetNode, true));
                if (!(leftSide instanceof AstIdentifier) || !(rightSide instanceof Node)) continue;
                result.put((AstIdentifier)leftSide, rightSide);
            }
        }
        return result;
    }

    private static boolean isInLambda(List<Node> rootToNode) {
        Node node;
        boolean inLambda = false;
        for (int i = rootToNode.size() - 1; i >= 0 && !((node = rootToNode.get(i)) instanceof AstDotSuffix); --i) {
            if (!(node instanceof AstLambdaExpression)) continue;
            inLambda = true;
        }
        return inLambda;
    }

    private static Node getLastAssigneableLeaf(Node root) {
        AstPath astPath = new AstPath(root);
        for (Node node : astPath.rootToLeaf()) {
            int i;
            if (!(node instanceof AstSemiColon) || (i = 0) >= node.jjtGetNumChildren()) continue;
            Node childNode = node.jjtGetChild(i);
            AstPath path = new AstPath(childNode);
            return ELCodeCompletionHandler.getNodeToResolve(childNode, path.rootToLeaf());
        }
        return ELCodeCompletionHandler.getNodeToResolve(root, astPath.rootToLeaf());
    }

    private Node getTargetNode(ELElement element, int offset) {
        Node result = element.findNodeAt(offset);
        if (result instanceof AstDeferredExpression || result instanceof AstDynamicExpression) {
            int relativeOffset = offset - element.getOriginalOffset().getStart();
            assert (relativeOffset >= 0);
            if (relativeOffset >= 2) {
                Node realTarget = element.findNodeAt(offset - 1);
                if (realTarget != null) {
                    result = realTarget;
                }
            } else {
                return null;
            }
        }
        return result;
    }

    private FileObject getFileObject(CodeCompletionContext context) {
        return context.getParserResult().getSnapshot().getSource().getFileObject();
    }

    private void proposeOperators(CompilationContext ccontext, CodeCompletionContext context, PrefixMatcher prefixMatcher, ELElement element, List<CompletionProposal> proposals, List<Node> rootToNode, boolean isBracketProperty) {
        TypeElement streamElement = ccontext.info().getElements().getTypeElement("com.sun.el.stream.Stream");
        if (streamElement != null) {
            this.proposeJavaMethodsForElements(ccontext, context, prefixMatcher, element, Arrays.asList(streamElement), isBracketProperty, proposals);
        }
    }

    private void proposeMethods(CompilationContext info, CodeCompletionContext context, Element resolved, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals, List<Node> rootToNode, boolean isBracketProperty) {
        List<Element> allTypes = ELTypeUtilities.getSuperTypesFor(info, resolved, elElement, rootToNode);
        this.proposeJavaMethodsForElements(info, context, prefix, elElement, allTypes, isBracketProperty, proposals);
    }

    private void proposeJavaMethodsForElements(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<Element> elements, boolean isBracketCall, List<CompletionProposal> proposals) {
        for (Element element : elements) {
            for (ExecutableElement enclosed : ElementFilter.methodsIn(element.getEnclosedElements())) {
                DefaultCompletionProposal completionItem;
                if (element.getSimpleName().contentEquals("Object") || !enclosed.getModifiers().contains((Object)Modifier.PUBLIC) || enclosed.getModifiers().contains((Object)Modifier.STATIC)) continue;
                boolean hasParameters = !enclosed.getParameters().isEmpty();
                String methodName = enclosed.getSimpleName().toString();
                String propertyName = RefactoringUtil.getPropertyName(methodName, enclosed.getReturnType(), true);
                if (hasParameters) {
                    propertyName = methodName;
                }
                if (!prefix.matches(propertyName) || ELCodeCompletionHandler.getKeywordFixedTexts().contains(propertyName) || ELCodeCompletionHandler.getKeywordFixedTexts().contains(methodName)) continue;
                if (ELPlugin.Query.isValidProperty(enclosed, context.getParserResult().getSnapshot().getSource(), info, context)) {
                    completionItem = new ELVariableCompletionItem(propertyName, ELTypeUtilities.getTypeNameFor(info, enclosed));
                    completionItem.setSmart(true);
                    completionItem.setAnchorOffset(context.getCaretOffset() - prefix.length());
                    if (this.contains(proposals, propertyName)) continue;
                    proposals.add((CompletionProposal)completionItem);
                    continue;
                }
                if (this.contains(proposals, propertyName)) continue;
                completionItem = !hasParameters ? new ELJavaCompletionItem(info, (Element)enclosed, elElement, isBracketCall) : new ELJavaCompletionItem(info, enclosed, methodName, elElement, isBracketCall);
                completionItem.setSmart(false);
                completionItem.setAnchorOffset(context.getCaretOffset() - prefix.length());
                proposals.add((CompletionProposal)completionItem);
            }
        }
    }

    private void proposeStream(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, List<CompletionProposal> proposals) {
        if (prefix.matches("stream")) {
            proposals.add((CompletionProposal)new ELStreamCompletionItem(context.getCaretOffset() - prefix.length()));
        }
    }

    private boolean contains(List<CompletionProposal> completionProposals, String proposalName) {
        if (proposalName == null || proposalName.isEmpty()) {
            return true;
        }
        for (CompletionProposal completionProposal : completionProposals) {
            if (!proposalName.equals(completionProposal.getName())) continue;
            return true;
        }
        return false;
    }

    private void proposeImpicitObjects(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, List<CompletionProposal> proposals) {
        for (ImplicitObject implicitObject : ELTypeUtilities.getImplicitObjects(info)) {
            if (!prefix.matches(implicitObject.getName())) continue;
            ELImplictObjectCompletionItem item = new ELImplictObjectCompletionItem(implicitObject.getName(), implicitObject.getClazz());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeKeywords(CodeCompletionContext context, PrefixMatcher prefix, List<CompletionProposal> proposals) {
        for (ELTokenId elToken : ELTokenId.values()) {
            if (!ELTokenId.ELTokenCategories.KEYWORDS.hasCategory((TokenId)elToken) || elToken.fixedText() == null || !prefix.matches(elToken.fixedText())) continue;
            ELKeywordCompletionItem item = new ELKeywordCompletionItem(elToken.fixedText());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeAssignements(CodeCompletionContext context, PrefixMatcher prefix, Map<AstIdentifier, Node> assignments, List<CompletionProposal> proposals) {
        for (Map.Entry<AstIdentifier, Node> entry : assignments.entrySet()) {
            AstIdentifier variable = entry.getKey();
            if (!prefix.matches(variable.getImage())) continue;
            ELAssignedVariableCompletionItem item = new ELAssignedVariableCompletionItem(variable.getImage());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeManagedBeans(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getManagedBeans(info, this.getFileObject(context))) {
            TypeElement element;
            if (!prefix.matches(bean.name) || (element = ELTypeUtilities.getElementForType(info, bean.clazz)) == null) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(info, (Element)element, bean.name, elElement);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            if (this.contains(proposals, bean.name)) continue;
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBeansFromScope(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, Node scopeNode, List<CompletionProposal> proposals) {
        String scope = scopeNode.getImage();
        String scopeString = "Scope";
        if (scope.endsWith("Scope")) {
            scope = scope.substring(0, scope.length() - "Scope".length());
        }
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getBeansInScope(info, scope, context.getParserResult().getSnapshot())) {
            if (!prefix.matches(bean.name)) continue;
            TypeElement element = ELTypeUtilities.getElementForType(info, bean.clazz);
            ELJavaCompletionItem item = new ELJavaCompletionItem(info, element, elElement);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeRawObjectProperties(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, Node scopeNode, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo property : ELVariableResolvers.getRawObjectProperties(info, scopeNode.getImage(), context.getParserResult().getSnapshot())) {
            if (!prefix.matches(property.name)) continue;
            ELRawObjectPropertyCompletionItem item = new ELRawObjectPropertyCompletionItem(property.name);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeVariables(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        for (ELVariableResolver.VariableInfo bean : ELVariableResolvers.getVariables(info, context.getParserResult().getSnapshot(), context.getCaretOffset())) {
            if (!prefix.matches(bean.name)) continue;
            if (bean.clazz == null) {
                ELVariableCompletionItem item = new ELVariableCompletionItem(bean.name, bean.expression);
                item.setAnchorOffset(context.getCaretOffset() - prefix.length());
                item.setSmart(true);
                proposals.add((CompletionProposal)item);
                continue;
            }
            TypeElement element = ELTypeUtilities.getElementForType(info, bean.clazz);
            if (element == null) continue;
            ELJavaCompletionItem item = new ELJavaCompletionItem(info, element, elElement);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundles(CompilationContext ccontext, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        for (ResourceBundle bundle : resourceBundles.getBundles(ccontext.context())) {
            if (!prefix.matches(bundle.getVar())) continue;
            ELResourceBundleCompletionItem item = new ELResourceBundleCompletionItem(ccontext.file(), bundle, resourceBundles);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundleKeysInArrayNotation(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, String bundleKey, AstString target, List<CompletionProposal> proposals) {
        if (target.getImage().isEmpty() || elElement.getOriginalOffset((Node)target).getStart() >= context.getCaretOffset()) {
            return;
        }
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        FileObject bundleFile = null;
        List<ResourceBundles.Location> bundleLocations = resourceBundles.getLocationsForBundleIdent(bundleKey);
        if (!bundleLocations.isEmpty()) {
            bundleFile = bundleLocations.get(0).getFile();
        }
        for (Map.Entry<String, String> entry : resourceBundles.getEntries(bundleKey).entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            ELResourceBundleKeyCompletionItem item = new ELResourceBundleKeyCompletionItem(entry.getKey(), entry.getValue(), elElement, bundleFile);
            item.setSmart(true);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeBundleKeysInDotNotation(CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, Node baseObjectNode, List<CompletionProposal> proposals) {
        String bundleKey = baseObjectNode.getImage();
        ResourceBundles resourceBundles = ResourceBundles.get(this.getFileObject(context));
        if (!resourceBundles.canHaveBundles()) {
            return;
        }
        FileObject bundleFile = null;
        List<ResourceBundles.Location> bundleLocations = resourceBundles.getLocationsForBundleIdent(bundleKey);
        if (!bundleLocations.isEmpty()) {
            bundleFile = bundleLocations.get(0).getFile();
        }
        for (Map.Entry<String, String> entry : resourceBundles.getEntries(bundleKey).entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            ELResourceBundleKeyCompletionItem item = new ELResourceBundleKeyCompletionItem(entry.getKey(), entry.getValue(), elElement, bundleFile);
            item.setSmart(true);
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    private void proposeFunctions(CompilationContext info, CodeCompletionContext context, PrefixMatcher prefix, ELElement elElement, List<CompletionProposal> proposals) {
        for (Function function : ELTypeUtilities.getELFunctions(info)) {
            if (!prefix.matches(function.getName())) continue;
            ELFunctionCompletionItem item = new ELFunctionCompletionItem(function.getName(), function.getReturnType(), function.getParameters(), function.getDescription());
            item.setAnchorOffset(context.getCaretOffset() - prefix.length());
            proposals.add((CompletionProposal)item);
        }
    }

    public String document(ParserResult info, ElementHandle element) {
        Documentation doc = this.documentElement(info, element, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return false;
            }
        });
        if (doc != null) {
            return doc.getContent();
        }
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        ELElement element = ELCodeCompletionHandler.getElementAt(info, caretOffset);
        if (element == null) {
            return null;
        }
        Node node = element.findNodeAt(caretOffset);
        if (node instanceof AstString) {
            int startOffset = element.getOriginalOffset(node).getStart();
            int end = caretOffset - startOffset;
            String image = node.getImage();
            if (end > 0 && !image.isEmpty()) {
                return image.substring(1, end);
            }
        }
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        assert (typedText.length() > 0);
        char last = typedText.charAt(typedText.length() - 1);
        switch (last) {
            case '.': {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    public Documentation documentElement(ParserResult info, ElementHandle element, Callable<Boolean> cancel) {
        if (!(element instanceof ELElementHandle)) {
            return null;
        }
        return ((ELElementHandle)element).document(info, cancel);
    }

    static class PrefixMatcher {
        private final String prefix;
        private final boolean exact;
        private final boolean caseSensitive;

        private PrefixMatcher(String value, boolean exact, boolean caseSensitive) {
            this.prefix = value;
            this.exact = exact;
            this.caseSensitive = caseSensitive;
        }

        static PrefixMatcher create(Node target, CodeCompletionContext context) {
            boolean isDoc;
            String prefix = context.getPrefix() != null ? context.getPrefix() : "";
            boolean bl = isDoc = context.getQueryType() == CodeCompletionHandler.QueryType.DOCUMENTATION;
            if (isDoc) {
                prefix = PrefixMatcher.getPrefixForDocumentation(target);
            }
            if (isDoc && prefix.isEmpty()) {
                return null;
            }
            return new PrefixMatcher(prefix, isDoc, context.isCaseSensitive());
        }

        static PrefixMatcher create(String prefix, CodeCompletionContext context) {
            return new PrefixMatcher(prefix, false, context.isCaseSensitive());
        }

        private static String getPrefixForDocumentation(Node target) {
            if (target instanceof AstString) {
                return ((AstString)target).getString();
            }
            return target.getImage() == null ? "" : target.getImage();
        }

        boolean matches(String str) {
            if (this.exact) {
                return this.prefix.equals(str);
            }
            if (this.caseSensitive) {
                return str.startsWith(this.prefix);
            }
            return str.toLowerCase().startsWith(this.prefix.toLowerCase());
        }

        int length() {
            return this.prefix.length();
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

