// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package datalabeling provides access to the Data Labeling API.
//
// For product documentation, see: https://cloud.google.com/data-labeling/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/datalabeling/v1beta1"
//	...
//	ctx := context.Background()
//	datalabelingService, err := datalabeling.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	datalabelingService, err := datalabeling.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	datalabelingService, err := datalabeling.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package datalabeling // import "google.golang.org/api/datalabeling/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "datalabeling:v1beta1"
const apiName = "datalabeling"
const apiVersion = "v1beta1"
const basePath = "https://datalabeling.googleapis.com/"
const basePathTemplate = "https://datalabeling.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://datalabeling.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.Background(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.AnnotationSpecSets = NewProjectsAnnotationSpecSetsService(s)
	rs.Datasets = NewProjectsDatasetsService(s)
	rs.EvaluationJobs = NewProjectsEvaluationJobsService(s)
	rs.Evaluations = NewProjectsEvaluationsService(s)
	rs.Instructions = NewProjectsInstructionsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	AnnotationSpecSets *ProjectsAnnotationSpecSetsService

	Datasets *ProjectsDatasetsService

	EvaluationJobs *ProjectsEvaluationJobsService

	Evaluations *ProjectsEvaluationsService

	Instructions *ProjectsInstructionsService

	Operations *ProjectsOperationsService
}

func NewProjectsAnnotationSpecSetsService(s *Service) *ProjectsAnnotationSpecSetsService {
	rs := &ProjectsAnnotationSpecSetsService{s: s}
	return rs
}

type ProjectsAnnotationSpecSetsService struct {
	s *Service
}

func NewProjectsDatasetsService(s *Service) *ProjectsDatasetsService {
	rs := &ProjectsDatasetsService{s: s}
	rs.AnnotatedDatasets = NewProjectsDatasetsAnnotatedDatasetsService(s)
	rs.DataItems = NewProjectsDatasetsDataItemsService(s)
	rs.Evaluations = NewProjectsDatasetsEvaluationsService(s)
	rs.Image = NewProjectsDatasetsImageService(s)
	rs.Text = NewProjectsDatasetsTextService(s)
	rs.Video = NewProjectsDatasetsVideoService(s)
	return rs
}

type ProjectsDatasetsService struct {
	s *Service

	AnnotatedDatasets *ProjectsDatasetsAnnotatedDatasetsService

	DataItems *ProjectsDatasetsDataItemsService

	Evaluations *ProjectsDatasetsEvaluationsService

	Image *ProjectsDatasetsImageService

	Text *ProjectsDatasetsTextService

	Video *ProjectsDatasetsVideoService
}

func NewProjectsDatasetsAnnotatedDatasetsService(s *Service) *ProjectsDatasetsAnnotatedDatasetsService {
	rs := &ProjectsDatasetsAnnotatedDatasetsService{s: s}
	rs.DataItems = NewProjectsDatasetsAnnotatedDatasetsDataItemsService(s)
	rs.Examples = NewProjectsDatasetsAnnotatedDatasetsExamplesService(s)
	rs.FeedbackThreads = NewProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService(s)
	return rs
}

type ProjectsDatasetsAnnotatedDatasetsService struct {
	s *Service

	DataItems *ProjectsDatasetsAnnotatedDatasetsDataItemsService

	Examples *ProjectsDatasetsAnnotatedDatasetsExamplesService

	FeedbackThreads *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService
}

func NewProjectsDatasetsAnnotatedDatasetsDataItemsService(s *Service) *ProjectsDatasetsAnnotatedDatasetsDataItemsService {
	rs := &ProjectsDatasetsAnnotatedDatasetsDataItemsService{s: s}
	return rs
}

type ProjectsDatasetsAnnotatedDatasetsDataItemsService struct {
	s *Service
}

func NewProjectsDatasetsAnnotatedDatasetsExamplesService(s *Service) *ProjectsDatasetsAnnotatedDatasetsExamplesService {
	rs := &ProjectsDatasetsAnnotatedDatasetsExamplesService{s: s}
	return rs
}

type ProjectsDatasetsAnnotatedDatasetsExamplesService struct {
	s *Service
}

func NewProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService(s *Service) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService {
	rs := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService{s: s}
	rs.FeedbackMessages = NewProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService(s)
	return rs
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService struct {
	s *Service

	FeedbackMessages *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService
}

func NewProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService(s *Service) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService {
	rs := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService{s: s}
	return rs
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService struct {
	s *Service
}

func NewProjectsDatasetsDataItemsService(s *Service) *ProjectsDatasetsDataItemsService {
	rs := &ProjectsDatasetsDataItemsService{s: s}
	return rs
}

type ProjectsDatasetsDataItemsService struct {
	s *Service
}

func NewProjectsDatasetsEvaluationsService(s *Service) *ProjectsDatasetsEvaluationsService {
	rs := &ProjectsDatasetsEvaluationsService{s: s}
	rs.ExampleComparisons = NewProjectsDatasetsEvaluationsExampleComparisonsService(s)
	return rs
}

type ProjectsDatasetsEvaluationsService struct {
	s *Service

	ExampleComparisons *ProjectsDatasetsEvaluationsExampleComparisonsService
}

func NewProjectsDatasetsEvaluationsExampleComparisonsService(s *Service) *ProjectsDatasetsEvaluationsExampleComparisonsService {
	rs := &ProjectsDatasetsEvaluationsExampleComparisonsService{s: s}
	return rs
}

type ProjectsDatasetsEvaluationsExampleComparisonsService struct {
	s *Service
}

func NewProjectsDatasetsImageService(s *Service) *ProjectsDatasetsImageService {
	rs := &ProjectsDatasetsImageService{s: s}
	return rs
}

type ProjectsDatasetsImageService struct {
	s *Service
}

func NewProjectsDatasetsTextService(s *Service) *ProjectsDatasetsTextService {
	rs := &ProjectsDatasetsTextService{s: s}
	return rs
}

type ProjectsDatasetsTextService struct {
	s *Service
}

func NewProjectsDatasetsVideoService(s *Service) *ProjectsDatasetsVideoService {
	rs := &ProjectsDatasetsVideoService{s: s}
	return rs
}

type ProjectsDatasetsVideoService struct {
	s *Service
}

func NewProjectsEvaluationJobsService(s *Service) *ProjectsEvaluationJobsService {
	rs := &ProjectsEvaluationJobsService{s: s}
	return rs
}

type ProjectsEvaluationJobsService struct {
	s *Service
}

func NewProjectsEvaluationsService(s *Service) *ProjectsEvaluationsService {
	rs := &ProjectsEvaluationsService{s: s}
	return rs
}

type ProjectsEvaluationsService struct {
	s *Service
}

func NewProjectsInstructionsService(s *Service) *ProjectsInstructionsService {
	rs := &ProjectsInstructionsService{s: s}
	return rs
}

type ProjectsInstructionsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleCloudDatalabelingV1alpha1CreateInstructionMetadata: Metadata of a
// CreateInstruction operation.
type GoogleCloudDatalabelingV1alpha1CreateInstructionMetadata struct {
	// CreateTime: Timestamp when create instruction request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Instruction: The name of the created Instruction.
	// projects/{project_id}/instructions/{instruction_id}
	Instruction string `json:"instruction,omitempty"`
	// PartialFailures: Partial failures encountered. E.g. single files that
	// couldn't be read. Status details field will contain standard GCP error
	// details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1CreateInstructionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1CreateInstructionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1ExportDataOperationMetadata: Metadata of an
// ExportData operation.
type GoogleCloudDatalabelingV1alpha1ExportDataOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when export dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be exported.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1ExportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1ExportDataOperationResponse: Response used
// for ExportDataset longrunning operation.
type GoogleCloudDatalabelingV1alpha1ExportDataOperationResponse struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// Dataset: Ouptut only. The name of dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ExportCount: Output only. Number of examples exported successfully.
	ExportCount int64 `json:"exportCount,omitempty"`
	// LabelStats: Output only. Statistic infos of labels in the exported dataset.
	LabelStats *GoogleCloudDatalabelingV1alpha1LabelStats `json:"labelStats,omitempty"`
	// OutputConfig: Output only. output_config in the ExportData request.
	OutputConfig *GoogleCloudDatalabelingV1alpha1OutputConfig `json:"outputConfig,omitempty"`
	// TotalCount: Output only. Total number of examples requested to export
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1ExportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1ExportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1GcsDestination: Export destination of the
// data.Only gcs path is allowed in output_uri.
type GoogleCloudDatalabelingV1alpha1GcsDestination struct {
	// MimeType: Required. The format of the gcs destination. Only "text/csv" and
	// "application/json" are supported.
	MimeType string `json:"mimeType,omitempty"`
	// OutputUri: Required. The output uri of destination file.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1GcsFolderDestination: Export folder
// destination of the data.
type GoogleCloudDatalabelingV1alpha1GcsFolderDestination struct {
	// OutputFolderUri: Required. Cloud Storage directory to export data to.
	OutputFolderUri string `json:"outputFolderUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputFolderUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputFolderUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1GcsFolderDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1GcsFolderDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig: Configuration for how
// human labeling task should be done.
type GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig struct {
	// AnnotatedDatasetDescription: Optional. A human-readable description for
	// AnnotatedDataset. The description can be up to 10000 characters long.
	AnnotatedDatasetDescription string `json:"annotatedDatasetDescription,omitempty"`
	// AnnotatedDatasetDisplayName: Required. A human-readable name for
	// AnnotatedDataset defined by users. Maximum of 64 characters .
	AnnotatedDatasetDisplayName string `json:"annotatedDatasetDisplayName,omitempty"`
	// ContributorEmails: Optional. If you want your own labeling contributors to
	// manage and work on this labeling request, you can set these contributors
	// here. We will give them access to the question types in crowdcompute. Note
	// that these emails must be registered in crowdcompute worker UI:
	// https://crowd-compute.appspot.com/
	ContributorEmails []string `json:"contributorEmails,omitempty"`
	// Instruction: Required. Instruction resource name.
	Instruction string `json:"instruction,omitempty"`
	// LabelGroup: Optional. A human-readable label used to logically group
	// labeling tasks. This string must match the regular expression
	// `[a-zA-Z\\d_-]{0,128}`.
	LabelGroup string `json:"labelGroup,omitempty"`
	// LanguageCode: Optional. The Language of this question, as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only
	// need to set this when task is language related. For example, French text
	// classification.
	LanguageCode string `json:"languageCode,omitempty"`
	// QuestionDuration: Optional. Maximum duration for contributors to answer a
	// question. Maximum is 3600 seconds. Default is 3600 seconds.
	QuestionDuration string `json:"questionDuration,omitempty"`
	// ReplicaCount: Optional. Replication of questions. Each question will be sent
	// to up to this number of contributors to label. Aggregated answers will be
	// returned. Default is set to 1. For image related labeling, valid values are
	// 1, 3, 5.
	ReplicaCount int64 `json:"replicaCount,omitempty"`
	// UserEmailAddress: Email of the user who started the labeling task and should
	// be notified by email. If empty no notification will be sent.
	UserEmailAddress string `json:"userEmailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AnnotatedDatasetDescription") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDatasetDescription") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1ImportDataOperationMetadata: Metadata of an
// ImportData operation.
type GoogleCloudDatalabelingV1alpha1ImportDataOperationMetadata struct {
	// CreateTime: Output only. Timestamp when import dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of imported dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1ImportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1ImportDataOperationResponse: Response used
// for ImportData longrunning operation.
type GoogleCloudDatalabelingV1alpha1ImportDataOperationResponse struct {
	// Dataset: Ouptut only. The name of imported dataset.
	Dataset string `json:"dataset,omitempty"`
	// ImportCount: Output only. Number of examples imported successfully.
	ImportCount int64 `json:"importCount,omitempty"`
	// TotalCount: Output only. Total number of examples requested to import
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1ImportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1ImportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelImageBoundingBoxOperationMetadata:
// Details of a LabelImageBoundingBox operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelImageBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelImageBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelImageBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelImageBoundingPolyOperationMetadata:
// Details of LabelImageBoundingPoly operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelImageBoundingPolyOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelImageBoundingPolyOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelImageBoundingPolyOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelImageClassificationOperationMetadata:
// Metadata of a LabelImageClassification operation.
type GoogleCloudDatalabelingV1alpha1LabelImageClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelImageClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelImageClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelImageOrientedBoundingBoxOperationMetadata
// : Details of a LabelImageOrientedBoundingBox operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelImageOrientedBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelImageOrientedBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelImageOrientedBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelImagePolylineOperationMetadata: Details
// of LabelImagePolyline operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelImagePolylineOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelImagePolylineOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelImagePolylineOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelImageSegmentationOperationMetadata:
// Details of a LabelImageSegmentation operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelImageSegmentationOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelImageSegmentationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelImageSegmentationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelOperationMetadata: Metadata of a
// labeling operation, such as LabelImage or LabelVideo. Next tag: 23
type GoogleCloudDatalabelingV1alpha1LabelOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when labeling request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be labeled.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ImageBoundingBoxDetails: Details of label image bounding box operation.
	ImageBoundingBoxDetails *GoogleCloudDatalabelingV1alpha1LabelImageBoundingBoxOperationMetadata `json:"imageBoundingBoxDetails,omitempty"`
	// ImageBoundingPolyDetails: Details of label image bounding poly operation.
	ImageBoundingPolyDetails *GoogleCloudDatalabelingV1alpha1LabelImageBoundingPolyOperationMetadata `json:"imageBoundingPolyDetails,omitempty"`
	// ImageClassificationDetails: Details of label image classification operation.
	ImageClassificationDetails *GoogleCloudDatalabelingV1alpha1LabelImageClassificationOperationMetadata `json:"imageClassificationDetails,omitempty"`
	// ImageOrientedBoundingBoxDetails: Details of label image oriented bounding
	// box operation.
	ImageOrientedBoundingBoxDetails *GoogleCloudDatalabelingV1alpha1LabelImageOrientedBoundingBoxOperationMetadata `json:"imageOrientedBoundingBoxDetails,omitempty"`
	// ImagePolylineDetails: Details of label image polyline operation.
	ImagePolylineDetails *GoogleCloudDatalabelingV1alpha1LabelImagePolylineOperationMetadata `json:"imagePolylineDetails,omitempty"`
	// ImageSegmentationDetails: Details of label image segmentation operation.
	ImageSegmentationDetails *GoogleCloudDatalabelingV1alpha1LabelImageSegmentationOperationMetadata `json:"imageSegmentationDetails,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ProgressPercent: Output only. Progress of label operation. Range: [0, 100].
	ProgressPercent int64 `json:"progressPercent,omitempty"`
	// TextClassificationDetails: Details of label text classification operation.
	TextClassificationDetails *GoogleCloudDatalabelingV1alpha1LabelTextClassificationOperationMetadata `json:"textClassificationDetails,omitempty"`
	// TextEntityExtractionDetails: Details of label text entity extraction
	// operation.
	TextEntityExtractionDetails *GoogleCloudDatalabelingV1alpha1LabelTextEntityExtractionOperationMetadata `json:"textEntityExtractionDetails,omitempty"`
	// VideoClassificationDetails: Details of label video classification operation.
	VideoClassificationDetails *GoogleCloudDatalabelingV1alpha1LabelVideoClassificationOperationMetadata `json:"videoClassificationDetails,omitempty"`
	// VideoEventDetails: Details of label video event operation.
	VideoEventDetails *GoogleCloudDatalabelingV1alpha1LabelVideoEventOperationMetadata `json:"videoEventDetails,omitempty"`
	// VideoObjectDetectionDetails: Details of label video object detection
	// operation.
	VideoObjectDetectionDetails *GoogleCloudDatalabelingV1alpha1LabelVideoObjectDetectionOperationMetadata `json:"videoObjectDetectionDetails,omitempty"`
	// VideoObjectTrackingDetails: Details of label video object tracking
	// operation.
	VideoObjectTrackingDetails *GoogleCloudDatalabelingV1alpha1LabelVideoObjectTrackingOperationMetadata `json:"videoObjectTrackingDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelStats: Statistics about annotation
// specs.
type GoogleCloudDatalabelingV1alpha1LabelStats struct {
	// ExampleCount: Map of each annotation spec's example count. Key is the
	// annotation spec name and value is the number of examples for that annotation
	// spec. If the annotated dataset does not have annotation spec, the map will
	// return a pair where the key is empty string and value is the total number of
	// annotations.
	ExampleCount map[string]string `json:"exampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelTextClassificationOperationMetadata:
// Details of a LabelTextClassification operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelTextClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelTextClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelTextClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelTextEntityExtractionOperationMetadata:
// Details of a LabelTextEntityExtraction operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelTextEntityExtractionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelTextEntityExtractionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelTextEntityExtractionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelVideoClassificationOperationMetadata:
// Details of a LabelVideoClassification operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelVideoClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelVideoClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelVideoClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelVideoEventOperationMetadata: Details of
// a LabelVideoEvent operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelVideoEventOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelVideoEventOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelVideoEventOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelVideoObjectDetectionOperationMetadata:
// Details of a LabelVideoObjectDetection operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelVideoObjectDetectionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelVideoObjectDetectionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelVideoObjectDetectionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1LabelVideoObjectTrackingOperationMetadata:
// Details of a LabelVideoObjectTracking operation metadata.
type GoogleCloudDatalabelingV1alpha1LabelVideoObjectTrackingOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1LabelVideoObjectTrackingOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1LabelVideoObjectTrackingOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1alpha1OutputConfig: The configuration of output
// data.
type GoogleCloudDatalabelingV1alpha1OutputConfig struct {
	// GcsDestination: Output to a file in Cloud Storage. Should be used for
	// labeling output other than image segmentation.
	GcsDestination *GoogleCloudDatalabelingV1alpha1GcsDestination `json:"gcsDestination,omitempty"`
	// GcsFolderDestination: Output to a folder in Cloud Storage. Should be used
	// for image segmentation or document de-identification labeling outputs.
	GcsFolderDestination *GoogleCloudDatalabelingV1alpha1GcsFolderDestination `json:"gcsFolderDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1alpha1OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1alpha1OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotatedDataset: AnnotatedDataset is a set
// holding annotations for data in a Dataset. Each labeling task will generate
// an AnnotatedDataset under the Dataset that the task is requested for.
type GoogleCloudDatalabelingV1beta1AnnotatedDataset struct {
	// AnnotationSource: Output only. Source of the annotation.
	//
	// Possible values:
	//   "ANNOTATION_SOURCE_UNSPECIFIED"
	//   "OPERATOR" - Answer is provided by a human contributor.
	AnnotationSource string `json:"annotationSource,omitempty"`
	// AnnotationType: Output only. Type of the annotation. It is specified when
	// starting labeling task.
	//
	// Possible values:
	//   "ANNOTATION_TYPE_UNSPECIFIED"
	//   "IMAGE_CLASSIFICATION_ANNOTATION" - Classification annotations in an
	// image. Allowed for continuous evaluation.
	//   "IMAGE_BOUNDING_BOX_ANNOTATION" - Bounding box annotations in an image. A
	// form of image object detection. Allowed for continuous evaluation.
	//   "IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION" - Oriented bounding box. The box
	// does not have to be parallel to horizontal line.
	//   "IMAGE_BOUNDING_POLY_ANNOTATION" - Bounding poly annotations in an image.
	//   "IMAGE_POLYLINE_ANNOTATION" - Polyline annotations in an image.
	//   "IMAGE_SEGMENTATION_ANNOTATION" - Segmentation annotations in an image.
	//   "VIDEO_SHOTS_CLASSIFICATION_ANNOTATION" - Classification annotations in
	// video shots.
	//   "VIDEO_OBJECT_TRACKING_ANNOTATION" - Video object tracking annotation.
	//   "VIDEO_OBJECT_DETECTION_ANNOTATION" - Video object detection annotation.
	//   "VIDEO_EVENT_ANNOTATION" - Video event annotation.
	//   "TEXT_CLASSIFICATION_ANNOTATION" - Classification for text. Allowed for
	// continuous evaluation.
	//   "TEXT_ENTITY_EXTRACTION_ANNOTATION" - Entity extraction for text.
	//   "GENERAL_CLASSIFICATION_ANNOTATION" - General classification. Allowed for
	// continuous evaluation.
	AnnotationType string `json:"annotationType,omitempty"`
	// BlockingResources: Output only. The names of any related resources that are
	// blocking changes to the annotated dataset.
	BlockingResources []string `json:"blockingResources,omitempty"`
	// CompletedExampleCount: Output only. Number of examples that have annotation
	// in the annotated dataset.
	CompletedExampleCount int64 `json:"completedExampleCount,omitempty,string"`
	// CreateTime: Output only. Time the AnnotatedDataset was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Output only. The description of the AnnotatedDataset. It is
	// specified in HumanAnnotationConfig when user starts a labeling task. Maximum
	// of 10000 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Output only. The display name of the AnnotatedDataset. It is
	// specified in HumanAnnotationConfig when user starts a labeling task. Maximum
	// of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// ExampleCount: Output only. Number of examples in the annotated dataset.
	ExampleCount int64 `json:"exampleCount,omitempty,string"`
	// LabelStats: Output only. Per label statistics.
	LabelStats *GoogleCloudDatalabelingV1beta1LabelStats `json:"labelStats,omitempty"`
	// Metadata: Output only. Additional information about AnnotatedDataset.
	Metadata *GoogleCloudDatalabelingV1beta1AnnotatedDatasetMetadata `json:"metadata,omitempty"`
	// Name: Output only. AnnotatedDataset resource name in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotatedDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotatedDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotatedDatasetMetadata: Metadata on
// AnnotatedDataset.
type GoogleCloudDatalabelingV1beta1AnnotatedDatasetMetadata struct {
	// BoundingPolyConfig: Configuration for image bounding box and bounding poly
	// task.
	BoundingPolyConfig *GoogleCloudDatalabelingV1beta1BoundingPolyConfig `json:"boundingPolyConfig,omitempty"`
	// EventConfig: Configuration for video event labeling task.
	EventConfig *GoogleCloudDatalabelingV1beta1EventConfig `json:"eventConfig,omitempty"`
	// HumanAnnotationConfig: HumanAnnotationConfig used when requesting the human
	// labeling task for this AnnotatedDataset.
	HumanAnnotationConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"humanAnnotationConfig,omitempty"`
	// ImageClassificationConfig: Configuration for image classification task.
	ImageClassificationConfig *GoogleCloudDatalabelingV1beta1ImageClassificationConfig `json:"imageClassificationConfig,omitempty"`
	// ObjectDetectionConfig: Configuration for video object detection task.
	ObjectDetectionConfig *GoogleCloudDatalabelingV1beta1ObjectDetectionConfig `json:"objectDetectionConfig,omitempty"`
	// ObjectTrackingConfig: Configuration for video object tracking task.
	ObjectTrackingConfig *GoogleCloudDatalabelingV1beta1ObjectTrackingConfig `json:"objectTrackingConfig,omitempty"`
	// PolylineConfig: Configuration for image polyline task.
	PolylineConfig *GoogleCloudDatalabelingV1beta1PolylineConfig `json:"polylineConfig,omitempty"`
	// SegmentationConfig: Configuration for image segmentation task.
	SegmentationConfig *GoogleCloudDatalabelingV1beta1SegmentationConfig `json:"segmentationConfig,omitempty"`
	// TextClassificationConfig: Configuration for text classification task.
	TextClassificationConfig *GoogleCloudDatalabelingV1beta1TextClassificationConfig `json:"textClassificationConfig,omitempty"`
	// TextEntityExtractionConfig: Configuration for text entity extraction task.
	TextEntityExtractionConfig *GoogleCloudDatalabelingV1beta1TextEntityExtractionConfig `json:"textEntityExtractionConfig,omitempty"`
	// VideoClassificationConfig: Configuration for video classification task.
	VideoClassificationConfig *GoogleCloudDatalabelingV1beta1VideoClassificationConfig `json:"videoClassificationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPolyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPolyConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotatedDatasetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotatedDatasetMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Annotation: Annotation for Example. Each
// example may have one or more annotations. For example in image
// classification problem, each image might have one or more labels. We call
// labels binded with this image an Annotation.
type GoogleCloudDatalabelingV1beta1Annotation struct {
	// AnnotationMetadata: Output only. Annotation metadata, including information
	// like votes for labels.
	AnnotationMetadata *GoogleCloudDatalabelingV1beta1AnnotationMetadata `json:"annotationMetadata,omitempty"`
	// AnnotationSentiment: Output only. Sentiment for this annotation.
	//
	// Possible values:
	//   "ANNOTATION_SENTIMENT_UNSPECIFIED"
	//   "NEGATIVE" - This annotation describes negatively about the data.
	//   "POSITIVE" - This label describes positively about the data.
	AnnotationSentiment string `json:"annotationSentiment,omitempty"`
	// AnnotationSource: Output only. The source of the annotation.
	//
	// Possible values:
	//   "ANNOTATION_SOURCE_UNSPECIFIED"
	//   "OPERATOR" - Answer is provided by a human contributor.
	AnnotationSource string `json:"annotationSource,omitempty"`
	// AnnotationValue: Output only. This is the actual annotation value, e.g
	// classification, bounding box values are stored here.
	AnnotationValue *GoogleCloudDatalabelingV1beta1AnnotationValue `json:"annotationValue,omitempty"`
	// Name: Output only. Unique name of this annotation, format is:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_data
	// set}/examples/{example_id}/annotations/{annotation_id}
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Annotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Annotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotationMetadata: Additional information
// associated with the annotation.
type GoogleCloudDatalabelingV1beta1AnnotationMetadata struct {
	// OperatorMetadata: Metadata related to human labeling.
	OperatorMetadata *GoogleCloudDatalabelingV1beta1OperatorMetadata `json:"operatorMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperatorMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperatorMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotationSpec: Container of information
// related to one possible annotation that can be used in a labeling task. For
// example, an image classification task where images are labeled as `dog` or
// `cat` must reference an AnnotationSpec for `dog` and an AnnotationSpec for
// `cat`.
type GoogleCloudDatalabelingV1beta1AnnotationSpec struct {
	// Description: Optional. User-provided description of the annotation
	// specification. The description can be up to 10,000 characters long.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the AnnotationSpec. Maximum of 64
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// Index: Output only. This is the integer index of the AnnotationSpec. The
	// index for the whole AnnotationSpecSet is sequential starting from 0. For
	// example, an AnnotationSpecSet with classes `dog` and `cat`, might contain
	// one AnnotationSpec with `{ display_name: "dog", index: 0 }` and one
	// AnnotationSpec with `{ display_name: "cat", index: 1 }`. This is especially
	// useful for model training as it encodes the string labels into numeric
	// values.
	Index int64 `json:"index,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotationSpecSet: An AnnotationSpecSet is a
// collection of label definitions. For example, in image classification tasks,
// you define a set of possible labels for images as an AnnotationSpecSet. An
// AnnotationSpecSet is immutable upon creation.
type GoogleCloudDatalabelingV1beta1AnnotationSpecSet struct {
	// AnnotationSpecs: Required. The array of AnnotationSpecs that you define when
	// you create the AnnotationSpecSet. These are the possible labels for the
	// labeling task.
	AnnotationSpecs []*GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpecs,omitempty"`
	// BlockingResources: Output only. The names of any related resources that are
	// blocking changes to the annotation spec set.
	BlockingResources []string `json:"blockingResources,omitempty"`
	// Description: Optional. User-provided description of the annotation
	// specification set. The description can be up to 10,000 characters long.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name for AnnotationSpecSet that you
	// define when you create it. Maximum of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. The AnnotationSpecSet resource name in the following
	// format: "projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotationSpecSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotationSpecSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotationSpecSetConfig: Annotation spec set
// with the setting of allowing multi labels or not.
type GoogleCloudDatalabelingV1beta1AnnotationSpecSetConfig struct {
	// AllowMultiLabel: Optional. If allow_multi_label is true, contributors are
	// able to choose multiple labels from one annotation spec set.
	AllowMultiLabel bool `json:"allowMultiLabel,omitempty"`
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMultiLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMultiLabel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotationSpecSetConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotationSpecSetConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1AnnotationValue: Annotation value for an
// example.
type GoogleCloudDatalabelingV1beta1AnnotationValue struct {
	// ImageBoundingPolyAnnotation: Annotation value for image bounding box,
	// oriented bounding box and polygon cases.
	ImageBoundingPolyAnnotation *GoogleCloudDatalabelingV1beta1ImageBoundingPolyAnnotation `json:"imageBoundingPolyAnnotation,omitempty"`
	// ImageClassificationAnnotation: Annotation value for image classification
	// case.
	ImageClassificationAnnotation *GoogleCloudDatalabelingV1beta1ImageClassificationAnnotation `json:"imageClassificationAnnotation,omitempty"`
	// ImagePolylineAnnotation: Annotation value for image polyline cases. Polyline
	// here is different from BoundingPoly. It is formed by line segments connected
	// to each other but not closed form(Bounding Poly). The line segments can
	// cross each other.
	ImagePolylineAnnotation *GoogleCloudDatalabelingV1beta1ImagePolylineAnnotation `json:"imagePolylineAnnotation,omitempty"`
	// ImageSegmentationAnnotation: Annotation value for image segmentation.
	ImageSegmentationAnnotation *GoogleCloudDatalabelingV1beta1ImageSegmentationAnnotation `json:"imageSegmentationAnnotation,omitempty"`
	// TextClassificationAnnotation: Annotation value for text classification case.
	TextClassificationAnnotation *GoogleCloudDatalabelingV1beta1TextClassificationAnnotation `json:"textClassificationAnnotation,omitempty"`
	// TextEntityExtractionAnnotation: Annotation value for text entity extraction
	// case.
	TextEntityExtractionAnnotation *GoogleCloudDatalabelingV1beta1TextEntityExtractionAnnotation `json:"textEntityExtractionAnnotation,omitempty"`
	// VideoClassificationAnnotation: Annotation value for video classification
	// case.
	VideoClassificationAnnotation *GoogleCloudDatalabelingV1beta1VideoClassificationAnnotation `json:"videoClassificationAnnotation,omitempty"`
	// VideoEventAnnotation: Annotation value for video event case.
	VideoEventAnnotation *GoogleCloudDatalabelingV1beta1VideoEventAnnotation `json:"videoEventAnnotation,omitempty"`
	// VideoObjectTrackingAnnotation: Annotation value for video object detection
	// and tracking case.
	VideoObjectTrackingAnnotation *GoogleCloudDatalabelingV1beta1VideoObjectTrackingAnnotation `json:"videoObjectTrackingAnnotation,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ImageBoundingPolyAnnotation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageBoundingPolyAnnotation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1AnnotationValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1AnnotationValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Attempt: Records a failed evaluation job run.
type GoogleCloudDatalabelingV1beta1Attempt struct {
	AttemptTime string `json:"attemptTime,omitempty"`
	// PartialFailures: Details of errors that occurred.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttemptTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttemptTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Attempt) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Attempt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1BigQuerySource: The BigQuery location for
// input data. If used in an EvaluationJob, this is where the service saves the
// prediction input and output sampled from the model version.
type GoogleCloudDatalabelingV1beta1BigQuerySource struct {
	// InputUri: Required. BigQuery URI to a table, up to 2,000 characters long. If
	// you specify the URI of a table that does not exist, Data Labeling Service
	// creates a table at the URI with the correct schema when you create your
	// EvaluationJob. If you specify the URI of a table that already exists, it
	// must have the correct schema
	// (/ml-engine/docs/continuous-evaluation/create-job#table-schema). Provide the
	// table URI in the following format: "bq://{your_project_id}/
	// {your_dataset_name}/{your_table_name}" Learn more
	// (/ml-engine/docs/continuous-evaluation/create-job#table-schema).
	InputUri string `json:"inputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1BigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions: Options
// regarding evaluation between bounding boxes.
type GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions struct {
	// IouThreshold: Minimum intersection-over-union (IOU)
	// (/vision/automl/object-detection/docs/evaluate#intersection-over-union)
	// required for 2 bounding boxes to be considered a match. This must be a
	// number between 0 and 1.
	IouThreshold float64 `json:"iouThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IouThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IouThreshold") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions
	var s1 struct {
		IouThreshold gensupport.JSONFloat64 `json:"iouThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IouThreshold = float64(s1.IouThreshold)
	return nil
}

// GoogleCloudDatalabelingV1beta1BoundingPoly: A bounding polygon in the image.
type GoogleCloudDatalabelingV1beta1BoundingPoly struct {
	// Vertices: The bounding polygon vertices.
	Vertices []*GoogleCloudDatalabelingV1beta1Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Vertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Vertices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1BoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1BoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1BoundingPolyConfig: Config for image bounding
// poly (and bounding box) human labeling task.
type GoogleCloudDatalabelingV1beta1BoundingPolyConfig struct {
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// InstructionMessage: Optional. Instruction message showed on contributors UI.
	InstructionMessage string `json:"instructionMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1BoundingPolyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1BoundingPolyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ClassificationMetadata: Metadata for
// classification annotations.
type GoogleCloudDatalabelingV1beta1ClassificationMetadata struct {
	// IsMultiLabel: Whether the classification task is multi-label or not.
	IsMultiLabel bool `json:"isMultiLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsMultiLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsMultiLabel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ClassificationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ClassificationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ClassificationMetrics: Metrics calculated for
// a classification model.
type GoogleCloudDatalabelingV1beta1ClassificationMetrics struct {
	// ConfusionMatrix: Confusion matrix of predicted labels vs. ground truth
	// labels.
	ConfusionMatrix *GoogleCloudDatalabelingV1beta1ConfusionMatrix `json:"confusionMatrix,omitempty"`
	// PrCurve: Precision-recall curve based on ground truth labels, predicted
	// labels, and scores for the predicted labels.
	PrCurve *GoogleCloudDatalabelingV1beta1PrCurve `json:"prCurve,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfusionMatrix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfusionMatrix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ClassificationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ClassificationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDatalabelingV1beta1ConfidenceMetricsEntry struct {
	// ConfidenceThreshold: Threshold used for this entry. For classification
	// tasks, this is a classification threshold: a predicted label is categorized
	// as positive or negative (in the context of this point on the PR curve) based
	// on whether the label's score meets this threshold. For image object
	// detection (bounding box) tasks, this is the intersection-over-union (IOU)
	// (/vision/automl/object-detection/docs/evaluate#intersection-over-union)
	// threshold for the context of this point on the PR curve.
	ConfidenceThreshold float64 `json:"confidenceThreshold,omitempty"`
	// F1Score: Harmonic mean of recall and precision.
	F1Score float64 `json:"f1Score,omitempty"`
	// F1ScoreAt1: The harmonic mean of recall_at1 and precision_at1.
	F1ScoreAt1 float64 `json:"f1ScoreAt1,omitempty"`
	// F1ScoreAt5: The harmonic mean of recall_at5 and precision_at5.
	F1ScoreAt5 float64 `json:"f1ScoreAt5,omitempty"`
	// Precision: Precision value.
	Precision float64 `json:"precision,omitempty"`
	// PrecisionAt1: Precision value for entries with label that has highest score.
	PrecisionAt1 float64 `json:"precisionAt1,omitempty"`
	// PrecisionAt5: Precision value for entries with label that has highest 5
	// scores.
	PrecisionAt5 float64 `json:"precisionAt5,omitempty"`
	// Recall: Recall value.
	Recall float64 `json:"recall,omitempty"`
	// RecallAt1: Recall value for entries with label that has highest score.
	RecallAt1 float64 `json:"recallAt1,omitempty"`
	// RecallAt5: Recall value for entries with label that has highest 5 scores.
	RecallAt5 float64 `json:"recallAt5,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceThreshold") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ConfidenceMetricsEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ConfidenceMetricsEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1ConfidenceMetricsEntry) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1ConfidenceMetricsEntry
	var s1 struct {
		ConfidenceThreshold gensupport.JSONFloat64 `json:"confidenceThreshold"`
		F1Score             gensupport.JSONFloat64 `json:"f1Score"`
		F1ScoreAt1          gensupport.JSONFloat64 `json:"f1ScoreAt1"`
		F1ScoreAt5          gensupport.JSONFloat64 `json:"f1ScoreAt5"`
		Precision           gensupport.JSONFloat64 `json:"precision"`
		PrecisionAt1        gensupport.JSONFloat64 `json:"precisionAt1"`
		PrecisionAt5        gensupport.JSONFloat64 `json:"precisionAt5"`
		Recall              gensupport.JSONFloat64 `json:"recall"`
		RecallAt1           gensupport.JSONFloat64 `json:"recallAt1"`
		RecallAt5           gensupport.JSONFloat64 `json:"recallAt5"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceThreshold = float64(s1.ConfidenceThreshold)
	s.F1Score = float64(s1.F1Score)
	s.F1ScoreAt1 = float64(s1.F1ScoreAt1)
	s.F1ScoreAt5 = float64(s1.F1ScoreAt5)
	s.Precision = float64(s1.Precision)
	s.PrecisionAt1 = float64(s1.PrecisionAt1)
	s.PrecisionAt5 = float64(s1.PrecisionAt5)
	s.Recall = float64(s1.Recall)
	s.RecallAt1 = float64(s1.RecallAt1)
	s.RecallAt5 = float64(s1.RecallAt5)
	return nil
}

// GoogleCloudDatalabelingV1beta1ConfusionMatrix: Confusion matrix of the model
// running the classification. Only applicable when the metrics entry
// aggregates multiple labels. Not applicable when the entry is for a single
// label.
type GoogleCloudDatalabelingV1beta1ConfusionMatrix struct {
	Row []*GoogleCloudDatalabelingV1beta1Row `json:"row,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Row") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Row") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ConfusionMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ConfusionMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDatalabelingV1beta1ConfusionMatrixEntry struct {
	// AnnotationSpec: The annotation spec of a predicted label.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// ItemCount: Number of items predicted to have this label. (The ground truth
	// label for these items is the `Row.annotationSpec` of this entry's parent.)
	ItemCount int64 `json:"itemCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ConfusionMatrixEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ConfusionMatrixEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1CreateAnnotationSpecSetRequest: Request
// message for CreateAnnotationSpecSet.
type GoogleCloudDatalabelingV1beta1CreateAnnotationSpecSetRequest struct {
	// AnnotationSpecSet: Required. Annotation spec set to create. Annotation specs
	// must be included. Only one annotation spec will be accepted for annotation
	// specs with same display_name.
	AnnotationSpecSet *GoogleCloudDatalabelingV1beta1AnnotationSpecSet `json:"annotationSpecSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1CreateAnnotationSpecSetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1CreateAnnotationSpecSetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1CreateDatasetRequest: Request message for
// CreateDataset.
type GoogleCloudDatalabelingV1beta1CreateDatasetRequest struct {
	// Dataset: Required. The dataset to be created.
	Dataset *GoogleCloudDatalabelingV1beta1Dataset `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1CreateDatasetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1CreateDatasetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1CreateEvaluationJobRequest: Request message
// for CreateEvaluationJob.
type GoogleCloudDatalabelingV1beta1CreateEvaluationJobRequest struct {
	// Job: Required. The evaluation job to create.
	Job *GoogleCloudDatalabelingV1beta1EvaluationJob `json:"job,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Job") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Job") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1CreateEvaluationJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1CreateEvaluationJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1CreateInstructionMetadata: Metadata of a
// CreateInstruction operation.
type GoogleCloudDatalabelingV1beta1CreateInstructionMetadata struct {
	// CreateTime: Timestamp when create instruction request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Instruction: The name of the created Instruction.
	// projects/{project_id}/instructions/{instruction_id}
	Instruction string `json:"instruction,omitempty"`
	// PartialFailures: Partial failures encountered. E.g. single files that
	// couldn't be read. Status details field will contain standard GCP error
	// details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1CreateInstructionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1CreateInstructionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1CreateInstructionRequest: Request message for
// CreateInstruction.
type GoogleCloudDatalabelingV1beta1CreateInstructionRequest struct {
	// Instruction: Required. Instruction of how to perform the labeling task.
	Instruction *GoogleCloudDatalabelingV1beta1Instruction `json:"instruction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instruction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instruction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1CreateInstructionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1CreateInstructionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1CsvInstruction: Deprecated: this instruction
// format is not supported any more. Instruction from a CSV file.
type GoogleCloudDatalabelingV1beta1CsvInstruction struct {
	// GcsFileUri: CSV file for the instruction. Only gcs path is allowed.
	GcsFileUri string `json:"gcsFileUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsFileUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsFileUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1CsvInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1CsvInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1DataItem: DataItem is a piece of data, without
// annotation. For example, an image.
type GoogleCloudDatalabelingV1beta1DataItem struct {
	// ImagePayload: The image payload, a container of the image bytes/uri.
	ImagePayload *GoogleCloudDatalabelingV1beta1ImagePayload `json:"imagePayload,omitempty"`
	// Name: Output only. Name of the data item, in format of:
	// projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}
	Name string `json:"name,omitempty"`
	// TextPayload: The text payload, a container of text content.
	TextPayload *GoogleCloudDatalabelingV1beta1TextPayload `json:"textPayload,omitempty"`
	// VideoPayload: The video payload, a container of the video uri.
	VideoPayload *GoogleCloudDatalabelingV1beta1VideoPayload `json:"videoPayload,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ImagePayload") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImagePayload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1DataItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1DataItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Dataset: Dataset is the resource to hold your
// data. You can request multiple labeling tasks for a dataset while each one
// will generate an AnnotatedDataset.
type GoogleCloudDatalabelingV1beta1Dataset struct {
	// BlockingResources: Output only. The names of any related resources that are
	// blocking changes to the dataset.
	BlockingResources []string `json:"blockingResources,omitempty"`
	// CreateTime: Output only. Time the dataset is created.
	CreateTime string `json:"createTime,omitempty"`
	// DataItemCount: Output only. The number of data items in the dataset.
	DataItemCount int64 `json:"dataItemCount,omitempty,string"`
	// Description: Optional. User-provided description of the annotation
	// specification set. The description can be up to 10000 characters long.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the dataset. Maximum of 64
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// InputConfigs: Output only. This is populated with the original input configs
	// where ImportData is called. It is available only after the clients import
	// data to this dataset.
	InputConfigs []*GoogleCloudDatalabelingV1beta1InputConfig `json:"inputConfigs,omitempty"`
	// LastMigrateTime: Last time that the Dataset is migrated to AI Platform V2.
	// If any of the AnnotatedDataset is migrated, the last_migration_time in
	// Dataset is also updated.
	LastMigrateTime string `json:"lastMigrateTime,omitempty"`
	// Name: Output only. Dataset resource name, format is:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlockingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Evaluation: Describes an evaluation between a
// machine learning model's predictions and ground truth labels. Created when
// an EvaluationJob runs successfully.
type GoogleCloudDatalabelingV1beta1Evaluation struct {
	// AnnotationType: Output only. Type of task that the model version being
	// evaluated performs, as defined in the
	// evaluationJobConfig.inputConfig.annotationType field of the evaluation job
	// that created this evaluation.
	//
	// Possible values:
	//   "ANNOTATION_TYPE_UNSPECIFIED"
	//   "IMAGE_CLASSIFICATION_ANNOTATION" - Classification annotations in an
	// image. Allowed for continuous evaluation.
	//   "IMAGE_BOUNDING_BOX_ANNOTATION" - Bounding box annotations in an image. A
	// form of image object detection. Allowed for continuous evaluation.
	//   "IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION" - Oriented bounding box. The box
	// does not have to be parallel to horizontal line.
	//   "IMAGE_BOUNDING_POLY_ANNOTATION" - Bounding poly annotations in an image.
	//   "IMAGE_POLYLINE_ANNOTATION" - Polyline annotations in an image.
	//   "IMAGE_SEGMENTATION_ANNOTATION" - Segmentation annotations in an image.
	//   "VIDEO_SHOTS_CLASSIFICATION_ANNOTATION" - Classification annotations in
	// video shots.
	//   "VIDEO_OBJECT_TRACKING_ANNOTATION" - Video object tracking annotation.
	//   "VIDEO_OBJECT_DETECTION_ANNOTATION" - Video object detection annotation.
	//   "VIDEO_EVENT_ANNOTATION" - Video event annotation.
	//   "TEXT_CLASSIFICATION_ANNOTATION" - Classification for text. Allowed for
	// continuous evaluation.
	//   "TEXT_ENTITY_EXTRACTION_ANNOTATION" - Entity extraction for text.
	//   "GENERAL_CLASSIFICATION_ANNOTATION" - General classification. Allowed for
	// continuous evaluation.
	AnnotationType string `json:"annotationType,omitempty"`
	// Config: Output only. Options used in the evaluation job that created this
	// evaluation.
	Config *GoogleCloudDatalabelingV1beta1EvaluationConfig `json:"config,omitempty"`
	// CreateTime: Output only. Timestamp for when this evaluation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EvaluatedItemCount: Output only. The number of items in the ground truth
	// dataset that were used for this evaluation. Only populated when the
	// evaulation is for certain AnnotationTypes.
	EvaluatedItemCount int64 `json:"evaluatedItemCount,omitempty,string"`
	// EvaluationJobRunTime: Output only. Timestamp for when the evaluation job
	// that created this evaluation ran.
	EvaluationJobRunTime string `json:"evaluationJobRunTime,omitempty"`
	// EvaluationMetrics: Output only. Metrics comparing predictions to ground
	// truth labels.
	EvaluationMetrics *GoogleCloudDatalabelingV1beta1EvaluationMetrics `json:"evaluationMetrics,omitempty"`
	// Name: Output only. Resource name of an evaluation. The name has the
	// following format: "projects/{project_id}/datasets/{dataset_id}/evaluations/
	// {evaluation_id}'
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Evaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Evaluation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1EvaluationConfig: Configuration details used
// for calculating evaluation metrics and creating an Evaluation.
type GoogleCloudDatalabelingV1beta1EvaluationConfig struct {
	// BoundingBoxEvaluationOptions: Only specify this field if the related model
	// performs image object detection (`IMAGE_BOUNDING_BOX_ANNOTATION`). Describes
	// how to evaluate bounding boxes.
	BoundingBoxEvaluationOptions *GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptions `json:"boundingBoxEvaluationOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BoundingBoxEvaluationOptions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingBoxEvaluationOptions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1EvaluationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1EvaluationJob: Defines an evaluation job that
// runs periodically to generate Evaluations. Creating an evaluation job
// (/ml-engine/docs/continuous-evaluation/create-job) is the starting point for
// using continuous evaluation.
type GoogleCloudDatalabelingV1beta1EvaluationJob struct {
	// AnnotationSpecSet: Required. Name of the AnnotationSpecSet describing all
	// the labels that your machine learning model outputs. You must create this
	// resource before you create an evaluation job and provide its name in the
	// following format:
	// "projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}"
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// Attempts: Output only. Every time the evaluation job runs and an error
	// occurs, the failed attempt is appended to this array.
	Attempts []*GoogleCloudDatalabelingV1beta1Attempt `json:"attempts,omitempty"`
	// CreateTime: Output only. Timestamp of when this evaluation job was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Required. Description of the job. The description can be up to
	// 25,000 characters long.
	Description string `json:"description,omitempty"`
	// EvaluationJobConfig: Required. Configuration details for the evaluation job.
	EvaluationJobConfig *GoogleCloudDatalabelingV1beta1EvaluationJobConfig `json:"evaluationJobConfig,omitempty"`
	// LabelMissingGroundTruth: Required. Whether you want Data Labeling Service to
	// provide ground truth labels for prediction input. If you want the service to
	// assign human labelers to annotate your data, set this to `true`. If you want
	// to provide your own ground truth labels in the evaluation job's BigQuery
	// table, set this to `false`.
	LabelMissingGroundTruth bool `json:"labelMissingGroundTruth,omitempty"`
	// ModelVersion: Required. The AI Platform Prediction model version
	// (/ml-engine/docs/prediction-overview) to be evaluated. Prediction input and
	// output is sampled from this model version. When creating an evaluation job,
	// specify the model version in the following format:
	// "projects/{project_id}/models/{model_name}/versions/{version_name}" There
	// can only be one evaluation job per model version.
	ModelVersion string `json:"modelVersion,omitempty"`
	// Name: Output only. After you create a job, Data Labeling Service assigns a
	// name to the job with the following format:
	// "projects/{project_id}/evaluationJobs/ {evaluation_job_id}"
	Name string `json:"name,omitempty"`
	// Schedule: Required. Describes the interval at which the job runs. This
	// interval must be at least 1 day, and it is rounded to the nearest day. For
	// example, if you specify a 50-hour interval, the job runs every 2 days. You
	// can provide the schedule in crontab format
	// (/scheduler/docs/configuring/cron-job-schedules) or in an English-like
	// format (/appengine/docs/standard/python/config/cronref#schedule_format).
	// Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
	// interval from this schedule is used, not the specific time of day.
	Schedule string `json:"schedule,omitempty"`
	// State: Output only. Describes the current state of the job.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "SCHEDULED" - The job is scheduled to run at the configured interval. You
	// can pause or delete the job. When the job is in this state, it samples
	// prediction input and output from your model version into your BigQuery table
	// as predictions occur.
	//   "RUNNING" - The job is currently running. When the job runs, Data Labeling
	// Service does several things: 1. If you have configured your job to use Data
	// Labeling Service for ground truth labeling, the service creates a Dataset
	// and a labeling task for all data sampled since the last time the job ran.
	// Human labelers provide ground truth labels for your data. Human labeling may
	// take hours, or even days, depending on how much data has been sampled. The
	// job remains in the `RUNNING` state during this time, and it can even be
	// running multiple times in parallel if it gets triggered again (for example
	// 24 hours later) before the earlier run has completed. When human labelers
	// have finished labeling the data, the next step occurs. If you have
	// configured your job to provide your own ground truth labels, Data Labeling
	// Service still creates a Dataset for newly sampled data, but it expects that
	// you have already added ground truth labels to the BigQuery table by this
	// time. The next step occurs immediately. 2. Data Labeling Service creates an
	// Evaluation by comparing your model version's predictions with the ground
	// truth labels. If the job remains in this state for a long time, it continues
	// to sample prediction data into your BigQuery table and will run again at the
	// next interval, even if it causes the job to run multiple times in parallel.
	//   "PAUSED" - The job is not sampling prediction input and output into your
	// BigQuery table and it will not run according to its schedule. You can resume
	// the job.
	//   "STOPPED" - The job has this state right before it is deleted.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1EvaluationJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig: Provides details for
// how an evaluation job sends email alerts based on the results of a run.
type GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig struct {
	// Email: Required. An email address to send alerts to.
	Email string `json:"email,omitempty"`
	// MinAcceptableMeanAveragePrecision: Required. A number between 0 and 1 that
	// describes a minimum mean average precision threshold. When the evaluation
	// job runs, if it calculates that your model version's predictions from the
	// recent interval have meanAveragePrecision below this threshold, then it
	// sends an alert to your specified email.
	MinAcceptableMeanAveragePrecision float64 `json:"minAcceptableMeanAveragePrecision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig
	var s1 struct {
		MinAcceptableMeanAveragePrecision gensupport.JSONFloat64 `json:"minAcceptableMeanAveragePrecision"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MinAcceptableMeanAveragePrecision = float64(s1.MinAcceptableMeanAveragePrecision)
	return nil
}

// GoogleCloudDatalabelingV1beta1EvaluationJobConfig: Configures specific
// details of how a continuous evaluation job works. Provide this configuration
// when you create an EvaluationJob.
type GoogleCloudDatalabelingV1beta1EvaluationJobConfig struct {
	// BigqueryImportKeys: Required. Prediction keys that tell Data Labeling
	// Service where to find the data for evaluation in your BigQuery table. When
	// the service samples prediction input and output from your model version and
	// saves it to BigQuery, the data gets stored as JSON strings in the BigQuery
	// table. These keys tell Data Labeling Service how to parse the JSON. You can
	// provide the following entries in this field: * `data_json_key`: the data key
	// for prediction input. You must provide either this key or
	// `reference_json_key`. * `reference_json_key`: the data reference key for
	// prediction input. You must provide either this key or `data_json_key`. *
	// `label_json_key`: the label key for prediction output. Required. *
	// `label_score_json_key`: the score key for prediction output. Required. *
	// `bounding_box_json_key`: the bounding box key for prediction output.
	// Required if your model version perform image object detection. Learn how to
	// configure prediction keys
	// (/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
	BigqueryImportKeys map[string]string `json:"bigqueryImportKeys,omitempty"`
	// BoundingPolyConfig: Specify this field if your model version performs image
	// object detection (bounding box detection). `annotationSpecSet` in this
	// configuration must match EvaluationJob.annotationSpecSet.
	BoundingPolyConfig *GoogleCloudDatalabelingV1beta1BoundingPolyConfig `json:"boundingPolyConfig,omitempty"`
	// EvaluationConfig: Required. Details for calculating evaluation metrics and
	// creating Evaulations. If your model version performs image object detection,
	// you must specify the `boundingBoxEvaluationOptions` field within this
	// configuration. Otherwise, provide an empty object for this configuration.
	EvaluationConfig *GoogleCloudDatalabelingV1beta1EvaluationConfig `json:"evaluationConfig,omitempty"`
	// EvaluationJobAlertConfig: Optional. Configuration details for evaluation job
	// alerts. Specify this field if you want to receive email alerts if the
	// evaluation job finds that your predictions have low mean average precision
	// during a run.
	EvaluationJobAlertConfig *GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfig `json:"evaluationJobAlertConfig,omitempty"`
	// ExampleCount: Required. The maximum number of predictions to sample and save
	// to BigQuery during each evaluation interval. This limit overrides
	// `example_sample_percentage`: even if the service has not sampled enough
	// predictions to fulfill `example_sample_perecentage` during an interval, it
	// stops sampling predictions when it meets this limit.
	ExampleCount int64 `json:"exampleCount,omitempty"`
	// ExampleSamplePercentage: Required. Fraction of predictions to sample and
	// save to BigQuery during each evaluation interval. For example, 0.1 means 10%
	// of predictions served by your model version get saved to BigQuery.
	ExampleSamplePercentage float64 `json:"exampleSamplePercentage,omitempty"`
	// HumanAnnotationConfig: Optional. Details for human annotation of your data.
	// If you set labelMissingGroundTruth to `true` for this evaluation job, then
	// you must specify this field. If you plan to provide your own ground truth
	// labels, then omit this field. Note that you must create an Instruction
	// resource before you can specify this field. Provide the name of the
	// instruction resource in the `instruction` field within this configuration.
	HumanAnnotationConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"humanAnnotationConfig,omitempty"`
	// ImageClassificationConfig: Specify this field if your model version performs
	// image classification or general classification. `annotationSpecSet` in this
	// configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel`
	// in this configuration must match `classificationMetadata.isMultiLabel` in
	// input_config.
	ImageClassificationConfig *GoogleCloudDatalabelingV1beta1ImageClassificationConfig `json:"imageClassificationConfig,omitempty"`
	// InputConfig: Rquired. Details for the sampled prediction input. Within this
	// configuration, there are requirements for several fields: * `dataType` must
	// be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`. * `annotationType` must be one
	// of `IMAGE_CLASSIFICATION_ANNOTATION`, `TEXT_CLASSIFICATION_ANNOTATION`,
	// `GENERAL_CLASSIFICATION_ANNOTATION`, or `IMAGE_BOUNDING_BOX_ANNOTATION`
	// (image object detection). * If your machine learning model performs
	// classification, you must specify `classificationMetadata.isMultiLabel`. *
	// You must specify `bigquerySource` (not `gcsSource`).
	InputConfig *GoogleCloudDatalabelingV1beta1InputConfig `json:"inputConfig,omitempty"`
	// TextClassificationConfig: Specify this field if your model version performs
	// text classification. `annotationSpecSet` in this configuration must match
	// EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration
	// must match `classificationMetadata.isMultiLabel` in input_config.
	TextClassificationConfig *GoogleCloudDatalabelingV1beta1TextClassificationConfig `json:"textClassificationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryImportKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryImportKeys") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1EvaluationJobConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationJobConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1EvaluationJobConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationJobConfig
	var s1 struct {
		ExampleSamplePercentage gensupport.JSONFloat64 `json:"exampleSamplePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExampleSamplePercentage = float64(s1.ExampleSamplePercentage)
	return nil
}

type GoogleCloudDatalabelingV1beta1EvaluationMetrics struct {
	ClassificationMetrics  *GoogleCloudDatalabelingV1beta1ClassificationMetrics  `json:"classificationMetrics,omitempty"`
	ObjectDetectionMetrics *GoogleCloudDatalabelingV1beta1ObjectDetectionMetrics `json:"objectDetectionMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClassificationMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClassificationMetrics") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1EvaluationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1EvaluationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1EventConfig: Config for video event human
// labeling task.
type GoogleCloudDatalabelingV1beta1EventConfig struct {
	// AnnotationSpecSets: Required. The list of annotation spec set resource name.
	// Similar to video classification, we support selecting event from multiple
	// AnnotationSpecSet at the same time.
	AnnotationSpecSets []string `json:"annotationSpecSets,omitempty"`
	// ClipLength: Videos will be cut to smaller clips to make it easier for
	// labelers to work on. Users can configure is field in seconds, if not set,
	// default value is 60s.
	ClipLength int64 `json:"clipLength,omitempty"`
	// OverlapLength: The overlap length between different video clips. Users can
	// configure is field in seconds, if not set, default value is 1s.
	OverlapLength int64 `json:"overlapLength,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSets") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1EventConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1EventConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Example: An Example is a piece of data and its
// annotation. For example, an image with label "house".
type GoogleCloudDatalabelingV1beta1Example struct {
	// Annotations: Output only. Annotations for the piece of data in Example. One
	// piece of data can have multiple annotations.
	Annotations []*GoogleCloudDatalabelingV1beta1Annotation `json:"annotations,omitempty"`
	// ImagePayload: The image payload, a container of the image bytes/uri.
	ImagePayload *GoogleCloudDatalabelingV1beta1ImagePayload `json:"imagePayload,omitempty"`
	// Name: Output only. Name of the example, in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}/examples/{example_id}
	Name string `json:"name,omitempty"`
	// TextPayload: The text payload, a container of the text content.
	TextPayload *GoogleCloudDatalabelingV1beta1TextPayload `json:"textPayload,omitempty"`
	// VideoPayload: The video payload, a container of the video uri.
	VideoPayload *GoogleCloudDatalabelingV1beta1VideoPayload `json:"videoPayload,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Example) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ExampleComparison: Example comparisons
// comparing ground truth output and predictions for a specific input.
type GoogleCloudDatalabelingV1beta1ExampleComparison struct {
	// GroundTruthExample: The ground truth output for the input.
	GroundTruthExample *GoogleCloudDatalabelingV1beta1Example `json:"groundTruthExample,omitempty"`
	// ModelCreatedExamples: Predictions by the model for the input.
	ModelCreatedExamples []*GoogleCloudDatalabelingV1beta1Example `json:"modelCreatedExamples,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroundTruthExample") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroundTruthExample") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ExampleComparison) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ExampleComparison
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ExportDataOperationMetadata: Metadata of an
// ExportData operation.
type GoogleCloudDatalabelingV1beta1ExportDataOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when export dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be exported.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ExportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ExportDataOperationResponse: Response used for
// ExportDataset longrunning operation.
type GoogleCloudDatalabelingV1beta1ExportDataOperationResponse struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// Dataset: Ouptut only. The name of dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ExportCount: Output only. Number of examples exported successfully.
	ExportCount int64 `json:"exportCount,omitempty"`
	// LabelStats: Output only. Statistic infos of labels in the exported dataset.
	LabelStats *GoogleCloudDatalabelingV1beta1LabelStats `json:"labelStats,omitempty"`
	// OutputConfig: Output only. output_config in the ExportData request.
	OutputConfig *GoogleCloudDatalabelingV1beta1OutputConfig `json:"outputConfig,omitempty"`
	// TotalCount: Output only. Total number of examples requested to export
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ExportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ExportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ExportDataRequest: Request message for
// ExportData API.
type GoogleCloudDatalabelingV1beta1ExportDataRequest struct {
	// AnnotatedDataset: Required. Annotated dataset resource name. DataItem in
	// Dataset and their annotations in specified annotated dataset will be
	// exported. It's in format of
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// Filter: Optional. Filter is not supported at this moment.
	Filter string `json:"filter,omitempty"`
	// OutputConfig: Required. Specify the output destination.
	OutputConfig *GoogleCloudDatalabelingV1beta1OutputConfig `json:"outputConfig,omitempty"`
	// UserEmailAddress: Email of the user who started the export task and should
	// be notified by email. If empty no notification will be sent.
	UserEmailAddress string `json:"userEmailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ExportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ExportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1FeedbackMessage: A feedback message inside a
// feedback thread.
type GoogleCloudDatalabelingV1beta1FeedbackMessage struct {
	// Body: String content of the feedback. Maximum of 10000 characters.
	Body string `json:"body,omitempty"`
	// CreateTime: Create time.
	CreateTime string `json:"createTime,omitempty"`
	// Image: The image storing this feedback if the feedback is an image
	// representing operator's comments.
	Image string `json:"image,omitempty"`
	// Name: Name of the feedback message in a feedback thread. Format:
	// 'project/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_data
	// set_id}/feedbackThreads/{feedback_thread_id}/feedbackMessage/{feedback_messag
	// e_id}'
	Name                      string                                                   `json:"name,omitempty"`
	OperatorFeedbackMetadata  *GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadata  `json:"operatorFeedbackMetadata,omitempty"`
	RequesterFeedbackMetadata *GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadata `json:"requesterFeedbackMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Body") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Body") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1FeedbackMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1FeedbackMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1FeedbackThread: A feedback thread of a certain
// labeling task on a certain annotated dataset.
type GoogleCloudDatalabelingV1beta1FeedbackThread struct {
	// FeedbackThreadMetadata: Metadata regarding the feedback thread.
	FeedbackThreadMetadata *GoogleCloudDatalabelingV1beta1FeedbackThreadMetadata `json:"feedbackThreadMetadata,omitempty"`
	// Name: Name of the feedback thread. Format:
	// 'project/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_data
	// set_id}/feedbackThreads/{feedback_thread_id}'
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackThreadMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackThreadMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1FeedbackThread) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1FeedbackThread
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDatalabelingV1beta1FeedbackThreadMetadata struct {
	// CreateTime: When the thread is created
	CreateTime string `json:"createTime,omitempty"`
	// LastUpdateTime: When the thread is last updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Possible values:
	//   "FEEDBACK_THREAD_STATUS_UNSPECIFIED"
	//   "NEW" - Feedback thread is created with no reply;
	//   "REPLIED" - Feedback thread is replied at least once;
	Status string `json:"status,omitempty"`
	// Thumbnail: An image thumbnail of this thread.
	Thumbnail string `json:"thumbnail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1FeedbackThreadMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1FeedbackThreadMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1GcsDestination: Export destination of the
// data.Only gcs path is allowed in output_uri.
type GoogleCloudDatalabelingV1beta1GcsDestination struct {
	// MimeType: Required. The format of the gcs destination. Only "text/csv" and
	// "application/json" are supported.
	MimeType string `json:"mimeType,omitempty"`
	// OutputUri: Required. The output uri of destination file.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1GcsFolderDestination: Export folder
// destination of the data.
type GoogleCloudDatalabelingV1beta1GcsFolderDestination struct {
	// OutputFolderUri: Required. Cloud Storage directory to export data to.
	OutputFolderUri string `json:"outputFolderUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputFolderUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputFolderUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1GcsFolderDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1GcsFolderDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1GcsSource: Source of the Cloud Storage file to
// be imported.
type GoogleCloudDatalabelingV1beta1GcsSource struct {
	// InputUri: Required. The input URI of source file. This must be a Cloud
	// Storage path (`gs://...`).
	InputUri string `json:"inputUri,omitempty"`
	// MimeType: Required. The format of the source file. Only "text/csv" is
	// supported.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1HumanAnnotationConfig: Configuration for how
// human labeling task should be done.
type GoogleCloudDatalabelingV1beta1HumanAnnotationConfig struct {
	// AnnotatedDatasetDescription: Optional. A human-readable description for
	// AnnotatedDataset. The description can be up to 10000 characters long.
	AnnotatedDatasetDescription string `json:"annotatedDatasetDescription,omitempty"`
	// AnnotatedDatasetDisplayName: Required. A human-readable name for
	// AnnotatedDataset defined by users. Maximum of 64 characters .
	AnnotatedDatasetDisplayName string `json:"annotatedDatasetDisplayName,omitempty"`
	// ContributorEmails: Optional. If you want your own labeling contributors to
	// manage and work on this labeling request, you can set these contributors
	// here. We will give them access to the question types in crowdcompute. Note
	// that these emails must be registered in crowdcompute worker UI:
	// https://crowd-compute.appspot.com/
	ContributorEmails []string `json:"contributorEmails,omitempty"`
	// Instruction: Required. Instruction resource name.
	Instruction string `json:"instruction,omitempty"`
	// LabelGroup: Optional. A human-readable label used to logically group
	// labeling tasks. This string must match the regular expression
	// `[a-zA-Z\\d_-]{0,128}`.
	LabelGroup string `json:"labelGroup,omitempty"`
	// LanguageCode: Optional. The Language of this question, as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only
	// need to set this when task is language related. For example, French text
	// classification.
	LanguageCode string `json:"languageCode,omitempty"`
	// QuestionDuration: Optional. Maximum duration for contributors to answer a
	// question. Maximum is 3600 seconds. Default is 3600 seconds.
	QuestionDuration string `json:"questionDuration,omitempty"`
	// ReplicaCount: Optional. Replication of questions. Each question will be sent
	// to up to this number of contributors to label. Aggregated answers will be
	// returned. Default is set to 1. For image related labeling, valid values are
	// 1, 3, 5.
	ReplicaCount int64 `json:"replicaCount,omitempty"`
	// UserEmailAddress: Email of the user who started the labeling task and should
	// be notified by email. If empty no notification will be sent.
	UserEmailAddress string `json:"userEmailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AnnotatedDatasetDescription") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDatasetDescription") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1HumanAnnotationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1HumanAnnotationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImageBoundingPolyAnnotation: Image bounding
// poly annotation. It represents a polygon including bounding box in the
// image.
type GoogleCloudDatalabelingV1beta1ImageBoundingPolyAnnotation struct {
	// AnnotationSpec: Label of object in this bounding polygon.
	AnnotationSpec         *GoogleCloudDatalabelingV1beta1AnnotationSpec         `json:"annotationSpec,omitempty"`
	BoundingPoly           *GoogleCloudDatalabelingV1beta1BoundingPoly           `json:"boundingPoly,omitempty"`
	NormalizedBoundingPoly *GoogleCloudDatalabelingV1beta1NormalizedBoundingPoly `json:"normalizedBoundingPoly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImageBoundingPolyAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImageBoundingPolyAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImageClassificationAnnotation: Image
// classification annotation definition.
type GoogleCloudDatalabelingV1beta1ImageClassificationAnnotation struct {
	// AnnotationSpec: Label of image.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImageClassificationAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImageClassificationAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImageClassificationConfig: Config for image
// classification human labeling task.
type GoogleCloudDatalabelingV1beta1ImageClassificationConfig struct {
	// AllowMultiLabel: Optional. If allow_multi_label is true, contributors are
	// able to choose multiple labels for one image.
	AllowMultiLabel bool `json:"allowMultiLabel,omitempty"`
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// AnswerAggregationType: Optional. The type of how to aggregate answers.
	//
	// Possible values:
	//   "STRING_AGGREGATION_TYPE_UNSPECIFIED"
	//   "MAJORITY_VOTE" - Majority vote to aggregate answers.
	//   "UNANIMOUS_VOTE" - Unanimous answers will be adopted.
	//   "NO_AGGREGATION" - Preserve all answers by crowd compute.
	AnswerAggregationType string `json:"answerAggregationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMultiLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMultiLabel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImageClassificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImageClassificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImagePayload: Container of information about
// an image.
type GoogleCloudDatalabelingV1beta1ImagePayload struct {
	// ImageThumbnail: A byte string of a thumbnail image.
	ImageThumbnail string `json:"imageThumbnail,omitempty"`
	// ImageUri: Image uri from the user bucket.
	ImageUri string `json:"imageUri,omitempty"`
	// MimeType: Image format.
	MimeType string `json:"mimeType,omitempty"`
	// SignedUri: Signed uri of the image file in the service bucket.
	SignedUri string `json:"signedUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageThumbnail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageThumbnail") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImagePayload) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImagePayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImagePolylineAnnotation: A polyline for the
// image annotation.
type GoogleCloudDatalabelingV1beta1ImagePolylineAnnotation struct {
	// AnnotationSpec: Label of this polyline.
	AnnotationSpec     *GoogleCloudDatalabelingV1beta1AnnotationSpec     `json:"annotationSpec,omitempty"`
	NormalizedPolyline *GoogleCloudDatalabelingV1beta1NormalizedPolyline `json:"normalizedPolyline,omitempty"`
	Polyline           *GoogleCloudDatalabelingV1beta1Polyline           `json:"polyline,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImagePolylineAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImagePolylineAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImageSegmentationAnnotation: Image
// segmentation annotation.
type GoogleCloudDatalabelingV1beta1ImageSegmentationAnnotation struct {
	// AnnotationColors: The mapping between rgb color and annotation spec. The key
	// is the rgb color represented in format of rgb(0, 0, 0). The value is the
	// AnnotationSpec.
	AnnotationColors map[string]GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationColors,omitempty"`
	// ImageBytes: A byte string of a full image's color map.
	ImageBytes string `json:"imageBytes,omitempty"`
	// MimeType: Image format.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationColors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationColors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImageSegmentationAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImageSegmentationAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImportDataOperationMetadata: Metadata of an
// ImportData operation.
type GoogleCloudDatalabelingV1beta1ImportDataOperationMetadata struct {
	// CreateTime: Output only. Timestamp when import dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of imported dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImportDataOperationResponse: Response used for
// ImportData longrunning operation.
type GoogleCloudDatalabelingV1beta1ImportDataOperationResponse struct {
	// Dataset: Ouptut only. The name of imported dataset.
	Dataset string `json:"dataset,omitempty"`
	// ImportCount: Output only. Number of examples imported successfully.
	ImportCount int64 `json:"importCount,omitempty"`
	// TotalCount: Output only. Total number of examples requested to import
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ImportDataRequest: Request message for
// ImportData API.
type GoogleCloudDatalabelingV1beta1ImportDataRequest struct {
	// InputConfig: Required. Specify the input source of the data.
	InputConfig *GoogleCloudDatalabelingV1beta1InputConfig `json:"inputConfig,omitempty"`
	// UserEmailAddress: Email of the user who started the import task and should
	// be notified by email. If empty no notification will be sent.
	UserEmailAddress string `json:"userEmailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ImportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ImportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1InputConfig: The configuration of input data,
// including data type, location, etc.
type GoogleCloudDatalabelingV1beta1InputConfig struct {
	// AnnotationType: Optional. The type of annotation to be performed on this
	// data. You must specify this field if you are using this InputConfig in an
	// EvaluationJob.
	//
	// Possible values:
	//   "ANNOTATION_TYPE_UNSPECIFIED"
	//   "IMAGE_CLASSIFICATION_ANNOTATION" - Classification annotations in an
	// image. Allowed for continuous evaluation.
	//   "IMAGE_BOUNDING_BOX_ANNOTATION" - Bounding box annotations in an image. A
	// form of image object detection. Allowed for continuous evaluation.
	//   "IMAGE_ORIENTED_BOUNDING_BOX_ANNOTATION" - Oriented bounding box. The box
	// does not have to be parallel to horizontal line.
	//   "IMAGE_BOUNDING_POLY_ANNOTATION" - Bounding poly annotations in an image.
	//   "IMAGE_POLYLINE_ANNOTATION" - Polyline annotations in an image.
	//   "IMAGE_SEGMENTATION_ANNOTATION" - Segmentation annotations in an image.
	//   "VIDEO_SHOTS_CLASSIFICATION_ANNOTATION" - Classification annotations in
	// video shots.
	//   "VIDEO_OBJECT_TRACKING_ANNOTATION" - Video object tracking annotation.
	//   "VIDEO_OBJECT_DETECTION_ANNOTATION" - Video object detection annotation.
	//   "VIDEO_EVENT_ANNOTATION" - Video event annotation.
	//   "TEXT_CLASSIFICATION_ANNOTATION" - Classification for text. Allowed for
	// continuous evaluation.
	//   "TEXT_ENTITY_EXTRACTION_ANNOTATION" - Entity extraction for text.
	//   "GENERAL_CLASSIFICATION_ANNOTATION" - General classification. Allowed for
	// continuous evaluation.
	AnnotationType string `json:"annotationType,omitempty"`
	// BigquerySource: Source located in BigQuery. You must specify this field if
	// you are using this InputConfig in an EvaluationJob.
	BigquerySource *GoogleCloudDatalabelingV1beta1BigQuerySource `json:"bigquerySource,omitempty"`
	// ClassificationMetadata: Optional. Metadata about annotations for the input.
	// You must specify this field if you are using this InputConfig in an
	// EvaluationJob for a model version that performs classification.
	ClassificationMetadata *GoogleCloudDatalabelingV1beta1ClassificationMetadata `json:"classificationMetadata,omitempty"`
	// DataType: Required. Data type must be specifed when user tries to import
	// data.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Data type is unspecified.
	//   "IMAGE" - Allowed for continuous evaluation.
	//   "VIDEO" - Video data type.
	//   "TEXT" - Allowed for continuous evaluation.
	//   "GENERAL_DATA" - Allowed for continuous evaluation.
	DataType string `json:"dataType,omitempty"`
	// GcsSource: Source located in Cloud Storage.
	GcsSource *GoogleCloudDatalabelingV1beta1GcsSource `json:"gcsSource,omitempty"`
	// TextMetadata: Required for text import, as language code must be specified.
	TextMetadata *GoogleCloudDatalabelingV1beta1TextMetadata `json:"textMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1InputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1InputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Instruction: Instruction of how to perform the
// labeling task for human operators. Currently only PDF instruction is
// supported.
type GoogleCloudDatalabelingV1beta1Instruction struct {
	// BlockingResources: Output only. The names of any related resources that are
	// blocking changes to the instruction.
	BlockingResources []string `json:"blockingResources,omitempty"`
	// CreateTime: Output only. Creation time of instruction.
	CreateTime string `json:"createTime,omitempty"`
	// CsvInstruction: Deprecated: this instruction format is not supported any
	// more. Instruction from a CSV file, such as for classification task. The CSV
	// file should have exact two columns, in the following format: * The first
	// column is labeled data, such as an image reference, text. * The second
	// column is comma separated labels associated with data.
	CsvInstruction *GoogleCloudDatalabelingV1beta1CsvInstruction `json:"csvInstruction,omitempty"`
	// DataType: Required. The data type of this instruction.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Data type is unspecified.
	//   "IMAGE" - Allowed for continuous evaluation.
	//   "VIDEO" - Video data type.
	//   "TEXT" - Allowed for continuous evaluation.
	//   "GENERAL_DATA" - Allowed for continuous evaluation.
	DataType string `json:"dataType,omitempty"`
	// Description: Optional. User-provided description of the instruction. The
	// description can be up to 10000 characters long.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the instruction. Maximum of 64
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. Instruction resource name, format:
	// projects/{project_id}/instructions/{instruction_id}
	Name string `json:"name,omitempty"`
	// PdfInstruction: Instruction from a PDF document. The PDF should be in a
	// Cloud Storage bucket.
	PdfInstruction *GoogleCloudDatalabelingV1beta1PdfInstruction `json:"pdfInstruction,omitempty"`
	// UpdateTime: Output only. Last update time of instruction.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BlockingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Instruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Instruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImageBoundingBoxOperationMetadata:
// Details of a LabelImageBoundingBox operation metadata.
type GoogleCloudDatalabelingV1beta1LabelImageBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImageBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImageBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImageBoundingPolyOperationMetadata:
// Details of LabelImageBoundingPoly operation metadata.
type GoogleCloudDatalabelingV1beta1LabelImageBoundingPolyOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImageBoundingPolyOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImageBoundingPolyOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImageClassificationOperationMetadata:
// Metadata of a LabelImageClassification operation.
type GoogleCloudDatalabelingV1beta1LabelImageClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImageClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImageClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImageOrientedBoundingBoxOperationMetadata:
//
//	Details of a LabelImageOrientedBoundingBox operation metadata.
type GoogleCloudDatalabelingV1beta1LabelImageOrientedBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImageOrientedBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImageOrientedBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImagePolylineOperationMetadata: Details
// of LabelImagePolyline operation metadata.
type GoogleCloudDatalabelingV1beta1LabelImagePolylineOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImagePolylineOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImagePolylineOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImageRequest: Request message for
// starting an image labeling task.
type GoogleCloudDatalabelingV1beta1LabelImageRequest struct {
	// BasicConfig: Required. Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// BoundingPolyConfig: Configuration for bounding box and bounding poly task.
	// One of image_classification_config, bounding_poly_config, polyline_config
	// and segmentation_config are required.
	BoundingPolyConfig *GoogleCloudDatalabelingV1beta1BoundingPolyConfig `json:"boundingPolyConfig,omitempty"`
	// Feature: Required. The type of image labeling task.
	//
	// Possible values:
	//   "FEATURE_UNSPECIFIED"
	//   "CLASSIFICATION" - Label whole image with one or more of labels.
	//   "BOUNDING_BOX" - Label image with bounding boxes for labels.
	//   "ORIENTED_BOUNDING_BOX" - Label oriented bounding box. The box does not
	// have to be parallel to horizontal line.
	//   "BOUNDING_POLY" - Label images with bounding poly. A bounding poly is a
	// plane figure that is bounded by a finite chain of straight line segments
	// closing in a loop.
	//   "POLYLINE" - Label images with polyline. Polyline is formed by connected
	// line segments which are not in closed form.
	//   "SEGMENTATION" - Label images with segmentation. Segmentation is different
	// from bounding poly since it is more fine-grained, pixel level annotation.
	Feature string `json:"feature,omitempty"`
	// ImageClassificationConfig: Configuration for image classification task. One
	// of image_classification_config, bounding_poly_config, polyline_config and
	// segmentation_config are required.
	ImageClassificationConfig *GoogleCloudDatalabelingV1beta1ImageClassificationConfig `json:"imageClassificationConfig,omitempty"`
	// PolylineConfig: Configuration for polyline task. One of
	// image_classification_config, bounding_poly_config, polyline_config and
	// segmentation_config are required.
	PolylineConfig *GoogleCloudDatalabelingV1beta1PolylineConfig `json:"polylineConfig,omitempty"`
	// SegmentationConfig: Configuration for segmentation task. One of
	// image_classification_config, bounding_poly_config, polyline_config and
	// segmentation_config are required.
	SegmentationConfig *GoogleCloudDatalabelingV1beta1SegmentationConfig `json:"segmentationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelImageSegmentationOperationMetadata:
// Details of a LabelImageSegmentation operation metadata.
type GoogleCloudDatalabelingV1beta1LabelImageSegmentationOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelImageSegmentationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelImageSegmentationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelOperationMetadata: Metadata of a labeling
// operation, such as LabelImage or LabelVideo. Next tag: 23
type GoogleCloudDatalabelingV1beta1LabelOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when labeling request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be labeled.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ImageBoundingBoxDetails: Details of label image bounding box operation.
	ImageBoundingBoxDetails *GoogleCloudDatalabelingV1beta1LabelImageBoundingBoxOperationMetadata `json:"imageBoundingBoxDetails,omitempty"`
	// ImageBoundingPolyDetails: Details of label image bounding poly operation.
	ImageBoundingPolyDetails *GoogleCloudDatalabelingV1beta1LabelImageBoundingPolyOperationMetadata `json:"imageBoundingPolyDetails,omitempty"`
	// ImageClassificationDetails: Details of label image classification operation.
	ImageClassificationDetails *GoogleCloudDatalabelingV1beta1LabelImageClassificationOperationMetadata `json:"imageClassificationDetails,omitempty"`
	// ImageOrientedBoundingBoxDetails: Details of label image oriented bounding
	// box operation.
	ImageOrientedBoundingBoxDetails *GoogleCloudDatalabelingV1beta1LabelImageOrientedBoundingBoxOperationMetadata `json:"imageOrientedBoundingBoxDetails,omitempty"`
	// ImagePolylineDetails: Details of label image polyline operation.
	ImagePolylineDetails *GoogleCloudDatalabelingV1beta1LabelImagePolylineOperationMetadata `json:"imagePolylineDetails,omitempty"`
	// ImageSegmentationDetails: Details of label image segmentation operation.
	ImageSegmentationDetails *GoogleCloudDatalabelingV1beta1LabelImageSegmentationOperationMetadata `json:"imageSegmentationDetails,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ProgressPercent: Output only. Progress of label operation. Range: [0, 100].
	ProgressPercent int64 `json:"progressPercent,omitempty"`
	// TextClassificationDetails: Details of label text classification operation.
	TextClassificationDetails *GoogleCloudDatalabelingV1beta1LabelTextClassificationOperationMetadata `json:"textClassificationDetails,omitempty"`
	// TextEntityExtractionDetails: Details of label text entity extraction
	// operation.
	TextEntityExtractionDetails *GoogleCloudDatalabelingV1beta1LabelTextEntityExtractionOperationMetadata `json:"textEntityExtractionDetails,omitempty"`
	// VideoClassificationDetails: Details of label video classification operation.
	VideoClassificationDetails *GoogleCloudDatalabelingV1beta1LabelVideoClassificationOperationMetadata `json:"videoClassificationDetails,omitempty"`
	// VideoEventDetails: Details of label video event operation.
	VideoEventDetails *GoogleCloudDatalabelingV1beta1LabelVideoEventOperationMetadata `json:"videoEventDetails,omitempty"`
	// VideoObjectDetectionDetails: Details of label video object detection
	// operation.
	VideoObjectDetectionDetails *GoogleCloudDatalabelingV1beta1LabelVideoObjectDetectionOperationMetadata `json:"videoObjectDetectionDetails,omitempty"`
	// VideoObjectTrackingDetails: Details of label video object tracking
	// operation.
	VideoObjectTrackingDetails *GoogleCloudDatalabelingV1beta1LabelVideoObjectTrackingOperationMetadata `json:"videoObjectTrackingDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelStats: Statistics about annotation specs.
type GoogleCloudDatalabelingV1beta1LabelStats struct {
	// ExampleCount: Map of each annotation spec's example count. Key is the
	// annotation spec name and value is the number of examples for that annotation
	// spec. If the annotated dataset does not have annotation spec, the map will
	// return a pair where the key is empty string and value is the total number of
	// annotations.
	ExampleCount map[string]string `json:"exampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelTextClassificationOperationMetadata:
// Details of a LabelTextClassification operation metadata.
type GoogleCloudDatalabelingV1beta1LabelTextClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelTextClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelTextClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelTextEntityExtractionOperationMetadata:
// Details of a LabelTextEntityExtraction operation metadata.
type GoogleCloudDatalabelingV1beta1LabelTextEntityExtractionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelTextEntityExtractionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelTextEntityExtractionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelTextRequest: Request message for
// LabelText.
type GoogleCloudDatalabelingV1beta1LabelTextRequest struct {
	// BasicConfig: Required. Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// Feature: Required. The type of text labeling task.
	//
	// Possible values:
	//   "FEATURE_UNSPECIFIED"
	//   "TEXT_CLASSIFICATION" - Label text content to one of more labels.
	//   "TEXT_ENTITY_EXTRACTION" - Label entities and their span in text.
	Feature string `json:"feature,omitempty"`
	// TextClassificationConfig: Configuration for text classification task. One of
	// text_classification_config and text_entity_extraction_config is required.
	TextClassificationConfig *GoogleCloudDatalabelingV1beta1TextClassificationConfig `json:"textClassificationConfig,omitempty"`
	// TextEntityExtractionConfig: Configuration for entity extraction task. One of
	// text_classification_config and text_entity_extraction_config is required.
	TextEntityExtractionConfig *GoogleCloudDatalabelingV1beta1TextEntityExtractionConfig `json:"textEntityExtractionConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelVideoClassificationOperationMetadata:
// Details of a LabelVideoClassification operation metadata.
type GoogleCloudDatalabelingV1beta1LabelVideoClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelVideoClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelVideoClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelVideoEventOperationMetadata: Details of a
// LabelVideoEvent operation metadata.
type GoogleCloudDatalabelingV1beta1LabelVideoEventOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelVideoEventOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelVideoEventOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelVideoObjectDetectionOperationMetadata:
// Details of a LabelVideoObjectDetection operation metadata.
type GoogleCloudDatalabelingV1beta1LabelVideoObjectDetectionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelVideoObjectDetectionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelVideoObjectDetectionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelVideoObjectTrackingOperationMetadata:
// Details of a LabelVideoObjectTracking operation metadata.
type GoogleCloudDatalabelingV1beta1LabelVideoObjectTrackingOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelVideoObjectTrackingOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelVideoObjectTrackingOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1LabelVideoRequest: Request message for
// LabelVideo.
type GoogleCloudDatalabelingV1beta1LabelVideoRequest struct {
	// BasicConfig: Required. Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1beta1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// EventConfig: Configuration for video event task. One of
	// video_classification_config, object_detection_config, object_tracking_config
	// and event_config is required.
	EventConfig *GoogleCloudDatalabelingV1beta1EventConfig `json:"eventConfig,omitempty"`
	// Feature: Required. The type of video labeling task.
	//
	// Possible values:
	//   "FEATURE_UNSPECIFIED"
	//   "CLASSIFICATION" - Label whole video or video segment with one or more
	// labels.
	//   "OBJECT_DETECTION" - Label objects with bounding box on image frames
	// extracted from the video.
	//   "OBJECT_TRACKING" - Label and track objects in video.
	//   "EVENT" - Label the range of video for the specified events.
	Feature string `json:"feature,omitempty"`
	// ObjectDetectionConfig: Configuration for video object detection task. One of
	// video_classification_config, object_detection_config, object_tracking_config
	// and event_config is required.
	ObjectDetectionConfig *GoogleCloudDatalabelingV1beta1ObjectDetectionConfig `json:"objectDetectionConfig,omitempty"`
	// ObjectTrackingConfig: Configuration for video object tracking task. One of
	// video_classification_config, object_detection_config, object_tracking_config
	// and event_config is required.
	ObjectTrackingConfig *GoogleCloudDatalabelingV1beta1ObjectTrackingConfig `json:"objectTrackingConfig,omitempty"`
	// VideoClassificationConfig: Configuration for video classification task. One
	// of video_classification_config, object_detection_config,
	// object_tracking_config and event_config is required.
	VideoClassificationConfig *GoogleCloudDatalabelingV1beta1VideoClassificationConfig `json:"videoClassificationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1LabelVideoRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1LabelVideoRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse: Results of
// listing annotated datasets for a dataset.
type GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse struct {
	// AnnotatedDatasets: The list of annotated datasets to return.
	AnnotatedDatasets []*GoogleCloudDatalabelingV1beta1AnnotatedDataset `json:"annotatedDatasets,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDatasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDatasets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse: Results of
// listing annotation spec set under a project.
type GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse struct {
	// AnnotationSpecSets: The list of annotation spec sets.
	AnnotationSpecSets []*GoogleCloudDatalabelingV1beta1AnnotationSpecSet `json:"annotationSpecSets,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSets") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListDataItemsResponse: Results of listing data
// items in a dataset.
type GoogleCloudDatalabelingV1beta1ListDataItemsResponse struct {
	// DataItems: The list of data items to return.
	DataItems []*GoogleCloudDatalabelingV1beta1DataItem `json:"dataItems,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataItems") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataItems") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListDataItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListDataItemsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListDatasetsResponse: Results of listing
// datasets within a project.
type GoogleCloudDatalabelingV1beta1ListDatasetsResponse struct {
	// Datasets: The list of datasets to return.
	Datasets []*GoogleCloudDatalabelingV1beta1Dataset `json:"datasets,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse: Results for
// listing evaluation jobs.
type GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse struct {
	// EvaluationJobs: The list of evaluation jobs to return.
	EvaluationJobs []*GoogleCloudDatalabelingV1beta1EvaluationJob `json:"evaluationJobs,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EvaluationJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationJobs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListExamplesResponse: Results of listing
// Examples in and annotated dataset.
type GoogleCloudDatalabelingV1beta1ListExamplesResponse struct {
	// Examples: The list of examples to return.
	Examples []*GoogleCloudDatalabelingV1beta1Example `json:"examples,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListExamplesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListExamplesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse: Results for
// listing FeedbackMessages.
type GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse struct {
	// FeedbackMessages: The list of feedback messages to return.
	FeedbackMessages []*GoogleCloudDatalabelingV1beta1FeedbackMessage `json:"feedbackMessages,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackMessages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackMessages") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse: Results for
// listing FeedbackThreads.
type GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse struct {
	// FeedbackThreads: The list of feedback threads to return.
	FeedbackThreads []*GoogleCloudDatalabelingV1beta1FeedbackThread `json:"feedbackThreads,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackThreads") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackThreads") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ListInstructionsResponse: Results of listing
// instructions under a project.
type GoogleCloudDatalabelingV1beta1ListInstructionsResponse struct {
	// Instructions: The list of Instructions to return.
	Instructions []*GoogleCloudDatalabelingV1beta1Instruction `json:"instructions,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Instructions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instructions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ListInstructionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ListInstructionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1NormalizedBoundingPoly: Normalized bounding
// polygon.
type GoogleCloudDatalabelingV1beta1NormalizedBoundingPoly struct {
	// NormalizedVertices: The bounding polygon normalized vertices.
	NormalizedVertices []*GoogleCloudDatalabelingV1beta1NormalizedVertex `json:"normalizedVertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedVertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedVertices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1NormalizedBoundingPoly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1NormalizedBoundingPoly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1NormalizedPolyline: Normalized polyline.
type GoogleCloudDatalabelingV1beta1NormalizedPolyline struct {
	// NormalizedVertices: The normalized polyline vertices.
	NormalizedVertices []*GoogleCloudDatalabelingV1beta1NormalizedVertex `json:"normalizedVertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedVertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedVertices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1NormalizedPolyline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1NormalizedPolyline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1NormalizedVertex: A vertex represents a 2D
// point in the image. NOTE: the normalized vertex coordinates are relative to
// the original image and range from 0 to 1.
type GoogleCloudDatalabelingV1beta1NormalizedVertex struct {
	// X: X coordinate.
	X float64 `json:"x,omitempty"`
	// Y: Y coordinate.
	Y float64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1NormalizedVertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1NormalizedVertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1NormalizedVertex) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1NormalizedVertex
	var s1 struct {
		X gensupport.JSONFloat64 `json:"x"`
		Y gensupport.JSONFloat64 `json:"y"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.X = float64(s1.X)
	s.Y = float64(s1.Y)
	return nil
}

// GoogleCloudDatalabelingV1beta1ObjectDetectionConfig: Config for video object
// detection human labeling task. Object detection will be conducted on the
// images extracted from the video, and those objects will be labeled with
// bounding boxes. User need to specify the number of images to be extracted
// per second as the extraction frame rate.
type GoogleCloudDatalabelingV1beta1ObjectDetectionConfig struct {
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// ExtractionFrameRate: Required. Number of frames per second to be extracted
	// from the video.
	ExtractionFrameRate float64 `json:"extractionFrameRate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ObjectDetectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ObjectDetectionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1ObjectDetectionConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1ObjectDetectionConfig
	var s1 struct {
		ExtractionFrameRate gensupport.JSONFloat64 `json:"extractionFrameRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ExtractionFrameRate = float64(s1.ExtractionFrameRate)
	return nil
}

// GoogleCloudDatalabelingV1beta1ObjectDetectionMetrics: Metrics calculated for
// an image object detection (bounding box) model.
type GoogleCloudDatalabelingV1beta1ObjectDetectionMetrics struct {
	// PrCurve: Precision-recall curve.
	PrCurve *GoogleCloudDatalabelingV1beta1PrCurve `json:"prCurve,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrCurve") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrCurve") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ObjectDetectionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ObjectDetectionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ObjectTrackingConfig: Config for video object
// tracking human labeling task.
type GoogleCloudDatalabelingV1beta1ObjectTrackingConfig struct {
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// ClipLength: Videos will be cut to smaller clips to make it easier for
	// labelers to work on. Users can configure is field in seconds, if not set,
	// default value is 20s.
	ClipLength int64 `json:"clipLength,omitempty"`
	// OverlapLength: The overlap length between different video clips. Users can
	// configure is field in seconds, if not set, default value is 0.3s.
	OverlapLength int64 `json:"overlapLength,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ObjectTrackingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ObjectTrackingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1ObjectTrackingFrame: Video frame level
// annotation for object detection and tracking.
type GoogleCloudDatalabelingV1beta1ObjectTrackingFrame struct {
	BoundingPoly           *GoogleCloudDatalabelingV1beta1BoundingPoly           `json:"boundingPoly,omitempty"`
	NormalizedBoundingPoly *GoogleCloudDatalabelingV1beta1NormalizedBoundingPoly `json:"normalizedBoundingPoly,omitempty"`
	// TimeOffset: The time offset of this frame relative to the beginning of the
	// video.
	TimeOffset string `json:"timeOffset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingPoly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingPoly") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1ObjectTrackingFrame) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1ObjectTrackingFrame
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadata: Metadata describing
// the feedback from the operator.
type GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadata struct {
}

// GoogleCloudDatalabelingV1beta1OperatorMetadata: General information useful
// for labels coming from contributors.
type GoogleCloudDatalabelingV1beta1OperatorMetadata struct {
	// Comments: Comments from contributors.
	Comments []string `json:"comments,omitempty"`
	// LabelVotes: The total number of contributors that choose this label.
	LabelVotes int64 `json:"labelVotes,omitempty"`
	// Score: Confidence score corresponding to a label. For examle, if 3
	// contributors have answered the question and 2 of them agree on the final
	// label, the confidence score will be 0.67 (2/3).
	Score float64 `json:"score,omitempty"`
	// TotalVotes: The total number of contributors that answer this question.
	TotalVotes int64 `json:"totalVotes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Comments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Comments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1OperatorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1OperatorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1OperatorMetadata) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1OperatorMetadata
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDatalabelingV1beta1OutputConfig: The configuration of output
// data.
type GoogleCloudDatalabelingV1beta1OutputConfig struct {
	// GcsDestination: Output to a file in Cloud Storage. Should be used for
	// labeling output other than image segmentation.
	GcsDestination *GoogleCloudDatalabelingV1beta1GcsDestination `json:"gcsDestination,omitempty"`
	// GcsFolderDestination: Output to a folder in Cloud Storage. Should be used
	// for image segmentation or document de-identification labeling outputs.
	GcsFolderDestination *GoogleCloudDatalabelingV1beta1GcsFolderDestination `json:"gcsFolderDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1PauseEvaluationJobRequest: Request message for
// PauseEvaluationJob.
type GoogleCloudDatalabelingV1beta1PauseEvaluationJobRequest struct {
}

// GoogleCloudDatalabelingV1beta1PdfInstruction: Instruction from a PDF file.
type GoogleCloudDatalabelingV1beta1PdfInstruction struct {
	// GcsFileUri: PDF file for the instruction. Only gcs path is allowed.
	GcsFileUri string `json:"gcsFileUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsFileUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsFileUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1PdfInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1PdfInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Polyline: A line with multiple line segments.
type GoogleCloudDatalabelingV1beta1Polyline struct {
	// Vertices: The polyline vertices.
	Vertices []*GoogleCloudDatalabelingV1beta1Vertex `json:"vertices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Vertices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Vertices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Polyline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Polyline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1PolylineConfig: Config for image polyline
// human labeling task.
type GoogleCloudDatalabelingV1beta1PolylineConfig struct {
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// InstructionMessage: Optional. Instruction message showed on contributors UI.
	InstructionMessage string `json:"instructionMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1PolylineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1PolylineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDatalabelingV1beta1PrCurve struct {
	// AnnotationSpec: The annotation spec of the label for which the
	// precision-recall curve calculated. If this field is empty, that means the
	// precision-recall curve is an aggregate curve for all labels.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// AreaUnderCurve: Area under the precision-recall curve. Not to be confused
	// with area under a receiver operating characteristic (ROC) curve.
	AreaUnderCurve float64 `json:"areaUnderCurve,omitempty"`
	// ConfidenceMetricsEntries: Entries that make up the precision-recall graph.
	// Each entry is a "point" on the graph drawn for a different
	// `confidence_threshold`.
	ConfidenceMetricsEntries []*GoogleCloudDatalabelingV1beta1ConfidenceMetricsEntry `json:"confidenceMetricsEntries,omitempty"`
	// MeanAveragePrecision: Mean average prcision of this curve.
	MeanAveragePrecision float64 `json:"meanAveragePrecision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1PrCurve) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1PrCurve
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1PrCurve) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1PrCurve
	var s1 struct {
		AreaUnderCurve       gensupport.JSONFloat64 `json:"areaUnderCurve"`
		MeanAveragePrecision gensupport.JSONFloat64 `json:"meanAveragePrecision"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AreaUnderCurve = float64(s1.AreaUnderCurve)
	s.MeanAveragePrecision = float64(s1.MeanAveragePrecision)
	return nil
}

// GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadata: Metadata describing
// the feedback from the labeling task requester.
type GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadata struct {
}

// GoogleCloudDatalabelingV1beta1ResumeEvaluationJobRequest: Request message
// ResumeEvaluationJob.
type GoogleCloudDatalabelingV1beta1ResumeEvaluationJobRequest struct {
}

// GoogleCloudDatalabelingV1beta1Row: A row in the confusion matrix. Each entry
// in this row has the same ground truth label.
type GoogleCloudDatalabelingV1beta1Row struct {
	// AnnotationSpec: The annotation spec of the ground truth label for this row.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// Entries: A list of the confusion matrix entries. One entry for each possible
	// predicted label.
	Entries []*GoogleCloudDatalabelingV1beta1ConfusionMatrixEntry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Row) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Row
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse: Results of
// searching evaluations.
type GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse struct {
	// Evaluations: The list of evaluations matching the search.
	Evaluations []*GoogleCloudDatalabelingV1beta1Evaluation `json:"evaluations,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Evaluations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Evaluations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1SearchExampleComparisonsRequest: Request
// message of SearchExampleComparisons.
type GoogleCloudDatalabelingV1beta1SearchExampleComparisonsRequest struct {
	// PageSize: Optional. Requested page size. Server may return fewer results
	// than requested. Default value is 100.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. A token identifying a page of results for the server to
	// return. Typically obtained by the nextPageToken of the response to a
	// previous search rquest. If you don't specify this field, the API call
	// requests the first page of the search.
	PageToken string `json:"pageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1SearchExampleComparisonsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1SearchExampleComparisonsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse: Results of
// searching example comparisons.
type GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse struct {
	// ExampleComparisons: A list of example comparisons matching the search
	// criteria.
	ExampleComparisons []*GoogleCloudDatalabelingV1beta1ExampleComparison `json:"exampleComparisons,omitempty"`
	// NextPageToken: A token to retrieve next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExampleComparisons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleComparisons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1SegmentationConfig: Config for image
// segmentation
type GoogleCloudDatalabelingV1beta1SegmentationConfig struct {
	// AnnotationSpecSet: Required. Annotation spec set resource name. format:
	// projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// InstructionMessage: Instruction message showed on labelers UI.
	InstructionMessage string `json:"instructionMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1SegmentationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1SegmentationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1SentimentConfig: Config for setting up
// sentiments.
type GoogleCloudDatalabelingV1beta1SentimentConfig struct {
	// EnableLabelSentimentSelection: If set to true, contributors will have the
	// option to select sentiment of the label they selected, to mark it as
	// negative or positive label. Default is false.
	EnableLabelSentimentSelection bool `json:"enableLabelSentimentSelection,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableLabelSentimentSelection") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableLabelSentimentSelection")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1SentimentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1SentimentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1SequentialSegment: Start and end position in a
// sequence (e.g. text segment).
type GoogleCloudDatalabelingV1beta1SequentialSegment struct {
	// End: End position (exclusive).
	End int64 `json:"end,omitempty"`
	// Start: Start position (inclusive).
	Start int64 `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1SequentialSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1SequentialSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TextClassificationAnnotation: Text
// classification annotation.
type GoogleCloudDatalabelingV1beta1TextClassificationAnnotation struct {
	// AnnotationSpec: Label of the text.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TextClassificationAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TextClassificationAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TextClassificationConfig: Config for text
// classification human labeling task.
type GoogleCloudDatalabelingV1beta1TextClassificationConfig struct {
	// AllowMultiLabel: Optional. If allow_multi_label is true, contributors are
	// able to choose multiple labels for one text segment.
	AllowMultiLabel bool `json:"allowMultiLabel,omitempty"`
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// SentimentConfig: Optional. Configs for sentiment selection. We deprecate
	// sentiment analysis in data labeling side as it is incompatible with uCAIP.
	SentimentConfig *GoogleCloudDatalabelingV1beta1SentimentConfig `json:"sentimentConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowMultiLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowMultiLabel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TextClassificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TextClassificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TextEntityExtractionAnnotation: Text entity
// extraction annotation.
type GoogleCloudDatalabelingV1beta1TextEntityExtractionAnnotation struct {
	// AnnotationSpec: Label of the text entities.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// SequentialSegment: Position of the entity.
	SequentialSegment *GoogleCloudDatalabelingV1beta1SequentialSegment `json:"sequentialSegment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TextEntityExtractionAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TextEntityExtractionAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TextEntityExtractionConfig: Config for text
// entity extraction human labeling task.
type GoogleCloudDatalabelingV1beta1TextEntityExtractionConfig struct {
	// AnnotationSpecSet: Required. Annotation spec set resource name.
	AnnotationSpecSet string `json:"annotationSpecSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TextEntityExtractionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TextEntityExtractionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TextMetadata: Metadata for the text.
type GoogleCloudDatalabelingV1beta1TextMetadata struct {
	// LanguageCode: The language of this text, as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TextMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TextMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TextPayload: Container of information about a
// piece of text.
type GoogleCloudDatalabelingV1beta1TextPayload struct {
	// TextContent: Text content.
	TextContent string `json:"textContent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TextContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TextContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TextPayload) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TextPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1TimeSegment: A time period inside of an
// example that has a time dimension (e.g. video).
type GoogleCloudDatalabelingV1beta1TimeSegment struct {
	// EndTimeOffset: End of the time segment (exclusive), represented as the
	// duration since the example start.
	EndTimeOffset string `json:"endTimeOffset,omitempty"`
	// StartTimeOffset: Start of the time segment (inclusive), represented as the
	// duration since the example start.
	StartTimeOffset string `json:"startTimeOffset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTimeOffset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTimeOffset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1TimeSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1TimeSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1Vertex: A vertex represents a 2D point in the
// image. NOTE: the vertex coordinates are in the same scale as the original
// image.
type GoogleCloudDatalabelingV1beta1Vertex struct {
	// X: X coordinate.
	X int64 `json:"x,omitempty"`
	// Y: Y coordinate.
	Y int64 `json:"y,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1Vertex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1Vertex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1VideoClassificationAnnotation: Video
// classification annotation.
type GoogleCloudDatalabelingV1beta1VideoClassificationAnnotation struct {
	// AnnotationSpec: Label of the segment specified by time_segment.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// TimeSegment: The time segment of the video to which the annotation applies.
	TimeSegment *GoogleCloudDatalabelingV1beta1TimeSegment `json:"timeSegment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1VideoClassificationAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoClassificationAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1VideoClassificationConfig: Config for video
// classification human labeling task. Currently two types of video
// classification are supported: 1. Assign labels on the entire video. 2. Split
// the video into multiple video clips based on camera shot, and assign labels
// on each video clip.
type GoogleCloudDatalabelingV1beta1VideoClassificationConfig struct {
	// AnnotationSpecSetConfigs: Required. The list of annotation spec set configs.
	// Since watching a video clip takes much longer time than an image, we support
	// label with multiple AnnotationSpecSet at the same time. Labels in each
	// AnnotationSpecSet will be shown in a group to contributors. Contributors can
	// select one or more (depending on whether to allow multi label) from each
	// group.
	AnnotationSpecSetConfigs []*GoogleCloudDatalabelingV1beta1AnnotationSpecSetConfig `json:"annotationSpecSetConfigs,omitempty"`
	// ApplyShotDetection: Optional. Option to apply shot detection on the video.
	ApplyShotDetection bool `json:"applyShotDetection,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpecSetConfigs")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpecSetConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1VideoClassificationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoClassificationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1VideoEventAnnotation: Video event annotation.
type GoogleCloudDatalabelingV1beta1VideoEventAnnotation struct {
	// AnnotationSpec: Label of the event in this annotation.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// TimeSegment: The time segment of the video to which the annotation applies.
	TimeSegment *GoogleCloudDatalabelingV1beta1TimeSegment `json:"timeSegment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1VideoEventAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoEventAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1VideoObjectTrackingAnnotation: Video object
// tracking annotation.
type GoogleCloudDatalabelingV1beta1VideoObjectTrackingAnnotation struct {
	// AnnotationSpec: Label of the object tracked in this annotation.
	AnnotationSpec *GoogleCloudDatalabelingV1beta1AnnotationSpec `json:"annotationSpec,omitempty"`
	// ObjectTrackingFrames: The list of frames where this object track appears.
	ObjectTrackingFrames []*GoogleCloudDatalabelingV1beta1ObjectTrackingFrame `json:"objectTrackingFrames,omitempty"`
	// TimeSegment: The time segment of the video to which object tracking applies.
	TimeSegment *GoogleCloudDatalabelingV1beta1TimeSegment `json:"timeSegment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1VideoObjectTrackingAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoObjectTrackingAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1beta1VideoPayload: Container of information of a
// video.
type GoogleCloudDatalabelingV1beta1VideoPayload struct {
	// FrameRate: FPS of the video.
	FrameRate float64 `json:"frameRate,omitempty"`
	// MimeType: Video format.
	MimeType string `json:"mimeType,omitempty"`
	// SignedUri: Signed uri of the video file in the service bucket.
	SignedUri string `json:"signedUri,omitempty"`
	// VideoThumbnails: The list of video thumbnails.
	VideoThumbnails []*GoogleCloudDatalabelingV1beta1VideoThumbnail `json:"videoThumbnails,omitempty"`
	// VideoUri: Video uri from the user bucket.
	VideoUri string `json:"videoUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FrameRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FrameRate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1VideoPayload) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDatalabelingV1beta1VideoPayload) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoPayload
	var s1 struct {
		FrameRate gensupport.JSONFloat64 `json:"frameRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FrameRate = float64(s1.FrameRate)
	return nil
}

// GoogleCloudDatalabelingV1beta1VideoThumbnail: Container of information of a
// video thumbnail.
type GoogleCloudDatalabelingV1beta1VideoThumbnail struct {
	// Thumbnail: A byte string of the video frame.
	Thumbnail string `json:"thumbnail,omitempty"`
	// TimeOffset: Time offset relative to the beginning of the video,
	// corresponding to the video frame where the thumbnail has been extracted
	// from.
	TimeOffset string `json:"timeOffset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Thumbnail") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Thumbnail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1beta1VideoThumbnail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1beta1VideoThumbnail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1CreateInstructionMetadata: Metadata of a
// CreateInstruction operation.
type GoogleCloudDatalabelingV1p1alpha1CreateInstructionMetadata struct {
	// CreateTime: Timestamp when create instruction request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Instruction: The name of the created Instruction.
	// projects/{project_id}/instructions/{instruction_id}
	Instruction string `json:"instruction,omitempty"`
	// PartialFailures: Partial failures encountered. E.g. single files that
	// couldn't be read. Status details field will contain standard GCP error
	// details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1CreateInstructionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1CreateInstructionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1ExportDataOperationMetadata: Metadata of an
// ExportData operation.
type GoogleCloudDatalabelingV1p1alpha1ExportDataOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when export dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be exported.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1ExportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1ExportDataOperationResponse: Response used
// for ExportDataset longrunning operation.
type GoogleCloudDatalabelingV1p1alpha1ExportDataOperationResponse struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// Dataset: Ouptut only. The name of dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ExportCount: Output only. Number of examples exported successfully.
	ExportCount int64 `json:"exportCount,omitempty"`
	// LabelStats: Output only. Statistic infos of labels in the exported dataset.
	LabelStats *GoogleCloudDatalabelingV1p1alpha1LabelStats `json:"labelStats,omitempty"`
	// OutputConfig: Output only. output_config in the ExportData request.
	OutputConfig *GoogleCloudDatalabelingV1p1alpha1OutputConfig `json:"outputConfig,omitempty"`
	// TotalCount: Output only. Total number of examples requested to export
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1ExportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1ExportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1GcsDestination: Export destination of the
// data.Only gcs path is allowed in output_uri.
type GoogleCloudDatalabelingV1p1alpha1GcsDestination struct {
	// MimeType: Required. The format of the gcs destination. Only "text/csv" and
	// "application/json" are supported.
	MimeType string `json:"mimeType,omitempty"`
	// OutputUri: Required. The output uri of destination file.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1GcsFolderDestination: Export folder
// destination of the data.
type GoogleCloudDatalabelingV1p1alpha1GcsFolderDestination struct {
	// OutputFolderUri: Required. Cloud Storage directory to export data to.
	OutputFolderUri string `json:"outputFolderUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputFolderUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputFolderUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1GcsFolderDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1GcsFolderDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1GenerateAnalysisReportOperationMetadata:
// Metadata of an GenerateAnalysisReport operation.
type GoogleCloudDatalabelingV1p1alpha1GenerateAnalysisReportOperationMetadata struct {
	// CreateTime: Timestamp when generate report request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: The name of the dataset for which the analysis report is generated.
	// Format: "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1GenerateAnalysisReportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1GenerateAnalysisReportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig: Configuration for
// how human labeling task should be done.
type GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig struct {
	// AnnotatedDatasetDescription: Optional. A human-readable description for
	// AnnotatedDataset. The description can be up to 10000 characters long.
	AnnotatedDatasetDescription string `json:"annotatedDatasetDescription,omitempty"`
	// AnnotatedDatasetDisplayName: Required. A human-readable name for
	// AnnotatedDataset defined by users. Maximum of 64 characters .
	AnnotatedDatasetDisplayName string `json:"annotatedDatasetDisplayName,omitempty"`
	// ContributorEmails: Optional. If you want your own labeling contributors to
	// manage and work on this labeling request, you can set these contributors
	// here. We will give them access to the question types in crowdcompute. Note
	// that these emails must be registered in crowdcompute worker UI:
	// https://crowd-compute.appspot.com/
	ContributorEmails []string `json:"contributorEmails,omitempty"`
	// Instruction: Required. Instruction resource name.
	Instruction string `json:"instruction,omitempty"`
	// LabelGroup: Optional. A human-readable label used to logically group
	// labeling tasks. This string must match the regular expression
	// `[a-zA-Z\\d_-]{0,128}`.
	LabelGroup string `json:"labelGroup,omitempty"`
	// LanguageCode: Optional. The Language of this question, as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only
	// need to set this when task is language related. For example, French text
	// classification.
	LanguageCode string `json:"languageCode,omitempty"`
	// QuestionDuration: Optional. Maximum duration for contributors to answer a
	// question. Maximum is 3600 seconds. Default is 3600 seconds.
	QuestionDuration string `json:"questionDuration,omitempty"`
	// ReplicaCount: Optional. Replication of questions. Each question will be sent
	// to up to this number of contributors to label. Aggregated answers will be
	// returned. Default is set to 1. For image related labeling, valid values are
	// 1, 3, 5.
	ReplicaCount int64 `json:"replicaCount,omitempty"`
	// UserEmailAddress: Email of the user who started the labeling task and should
	// be notified by email. If empty no notification will be sent.
	UserEmailAddress string `json:"userEmailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AnnotatedDatasetDescription") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDatasetDescription") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1ImportDataOperationMetadata: Metadata of an
// ImportData operation.
type GoogleCloudDatalabelingV1p1alpha1ImportDataOperationMetadata struct {
	// CreateTime: Output only. Timestamp when import dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of imported dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1ImportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1ImportDataOperationResponse: Response used
// for ImportData longrunning operation.
type GoogleCloudDatalabelingV1p1alpha1ImportDataOperationResponse struct {
	// Dataset: Ouptut only. The name of imported dataset.
	Dataset string `json:"dataset,omitempty"`
	// ImportCount: Output only. Number of examples imported successfully.
	ImportCount int64 `json:"importCount,omitempty"`
	// TotalCount: Output only. Total number of examples requested to import
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1ImportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1ImportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingBoxOperationMetadata:
// Details of a LabelImageBoundingBox operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingPolyOperationMetadata:
// Details of LabelImageBoundingPoly operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingPolyOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingPolyOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingPolyOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelImageClassificationOperationMetadata:
// Metadata of a LabelImageClassification operation.
type GoogleCloudDatalabelingV1p1alpha1LabelImageClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelImageClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelImageClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelImageOrientedBoundingBoxOperationMetada
// ta: Details of a LabelImageOrientedBoundingBox operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelImageOrientedBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelImageOrientedBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelImageOrientedBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelImagePolylineOperationMetadata:
// Details of LabelImagePolyline operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelImagePolylineOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelImagePolylineOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelImagePolylineOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelImageSegmentationOperationMetadata:
// Details of a LabelImageSegmentation operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelImageSegmentationOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelImageSegmentationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelImageSegmentationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelOperationMetadata: Metadata of a
// labeling operation, such as LabelImage or LabelVideo. Next tag: 23
type GoogleCloudDatalabelingV1p1alpha1LabelOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when labeling request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be labeled.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ImageBoundingBoxDetails: Details of label image bounding box operation.
	ImageBoundingBoxDetails *GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingBoxOperationMetadata `json:"imageBoundingBoxDetails,omitempty"`
	// ImageBoundingPolyDetails: Details of label image bounding poly operation.
	ImageBoundingPolyDetails *GoogleCloudDatalabelingV1p1alpha1LabelImageBoundingPolyOperationMetadata `json:"imageBoundingPolyDetails,omitempty"`
	// ImageClassificationDetails: Details of label image classification operation.
	ImageClassificationDetails *GoogleCloudDatalabelingV1p1alpha1LabelImageClassificationOperationMetadata `json:"imageClassificationDetails,omitempty"`
	// ImageOrientedBoundingBoxDetails: Details of label image oriented bounding
	// box operation.
	ImageOrientedBoundingBoxDetails *GoogleCloudDatalabelingV1p1alpha1LabelImageOrientedBoundingBoxOperationMetadata `json:"imageOrientedBoundingBoxDetails,omitempty"`
	// ImagePolylineDetails: Details of label image polyline operation.
	ImagePolylineDetails *GoogleCloudDatalabelingV1p1alpha1LabelImagePolylineOperationMetadata `json:"imagePolylineDetails,omitempty"`
	// ImageSegmentationDetails: Details of label image segmentation operation.
	ImageSegmentationDetails *GoogleCloudDatalabelingV1p1alpha1LabelImageSegmentationOperationMetadata `json:"imageSegmentationDetails,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ProgressPercent: Output only. Progress of label operation. Range: [0, 100].
	ProgressPercent int64 `json:"progressPercent,omitempty"`
	// TextClassificationDetails: Details of label text classification operation.
	TextClassificationDetails *GoogleCloudDatalabelingV1p1alpha1LabelTextClassificationOperationMetadata `json:"textClassificationDetails,omitempty"`
	// TextEntityExtractionDetails: Details of label text entity extraction
	// operation.
	TextEntityExtractionDetails *GoogleCloudDatalabelingV1p1alpha1LabelTextEntityExtractionOperationMetadata `json:"textEntityExtractionDetails,omitempty"`
	// VideoClassificationDetails: Details of label video classification operation.
	VideoClassificationDetails *GoogleCloudDatalabelingV1p1alpha1LabelVideoClassificationOperationMetadata `json:"videoClassificationDetails,omitempty"`
	// VideoEventDetails: Details of label video event operation.
	VideoEventDetails *GoogleCloudDatalabelingV1p1alpha1LabelVideoEventOperationMetadata `json:"videoEventDetails,omitempty"`
	// VideoObjectDetectionDetails: Details of label video object detection
	// operation.
	VideoObjectDetectionDetails *GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectDetectionOperationMetadata `json:"videoObjectDetectionDetails,omitempty"`
	// VideoObjectTrackingDetails: Details of label video object tracking
	// operation.
	VideoObjectTrackingDetails *GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectTrackingOperationMetadata `json:"videoObjectTrackingDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelStats: Statistics about annotation
// specs.
type GoogleCloudDatalabelingV1p1alpha1LabelStats struct {
	// ExampleCount: Map of each annotation spec's example count. Key is the
	// annotation spec name and value is the number of examples for that annotation
	// spec. If the annotated dataset does not have annotation spec, the map will
	// return a pair where the key is empty string and value is the total number of
	// annotations.
	ExampleCount map[string]string `json:"exampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelTextClassificationOperationMetadata:
// Details of a LabelTextClassification operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelTextClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelTextClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelTextClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelTextEntityExtractionOperationMetadata:
// Details of a LabelTextEntityExtraction operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelTextEntityExtractionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelTextEntityExtractionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelTextEntityExtractionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelVideoClassificationOperationMetadata:
// Details of a LabelVideoClassification operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelVideoClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelVideoClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelVideoClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelVideoEventOperationMetadata: Details
// of a LabelVideoEvent operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelVideoEventOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelVideoEventOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelVideoEventOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectDetectionOperationMetadata:
// Details of a LabelVideoObjectDetection operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectDetectionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectDetectionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectDetectionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectTrackingOperationMetadata:
// Details of a LabelVideoObjectTracking operation metadata.
type GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectTrackingOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p1alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectTrackingOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1LabelVideoObjectTrackingOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p1alpha1OutputConfig: The configuration of output
// data.
type GoogleCloudDatalabelingV1p1alpha1OutputConfig struct {
	// GcsDestination: Output to a file in Cloud Storage. Should be used for
	// labeling output other than image segmentation.
	GcsDestination *GoogleCloudDatalabelingV1p1alpha1GcsDestination `json:"gcsDestination,omitempty"`
	// GcsFolderDestination: Output to a folder in Cloud Storage. Should be used
	// for image segmentation or document de-identification labeling outputs.
	GcsFolderDestination *GoogleCloudDatalabelingV1p1alpha1GcsFolderDestination `json:"gcsFolderDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p1alpha1OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p1alpha1OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1CreateInstructionMetadata: Metadata of a
// CreateInstruction operation.
type GoogleCloudDatalabelingV1p2alpha1CreateInstructionMetadata struct {
	// CreateTime: Timestamp when create instruction request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Instruction: The name of the created Instruction.
	// projects/{project_id}/instructions/{instruction_id}
	Instruction string `json:"instruction,omitempty"`
	// PartialFailures: Partial failures encountered. E.g. single files that
	// couldn't be read. Status details field will contain standard GCP error
	// details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1CreateInstructionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1CreateInstructionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1ExportDataOperationMetadata: Metadata of an
// ExportData operation.
type GoogleCloudDatalabelingV1p2alpha1ExportDataOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when export dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be exported.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1ExportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1ExportDataOperationResponse: Response used
// for ExportDataset longrunning operation.
type GoogleCloudDatalabelingV1p2alpha1ExportDataOperationResponse struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// Dataset: Ouptut only. The name of dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ExportCount: Output only. Number of examples exported successfully.
	ExportCount int64 `json:"exportCount,omitempty"`
	// LabelStats: Output only. Statistic infos of labels in the exported dataset.
	LabelStats *GoogleCloudDatalabelingV1p2alpha1LabelStats `json:"labelStats,omitempty"`
	// OutputConfig: Output only. output_config in the ExportData request.
	OutputConfig *GoogleCloudDatalabelingV1p2alpha1OutputConfig `json:"outputConfig,omitempty"`
	// TotalCount: Output only. Total number of examples requested to export
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1ExportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1ExportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1GcsDestination: Export destination of the
// data.Only gcs path is allowed in output_uri.
type GoogleCloudDatalabelingV1p2alpha1GcsDestination struct {
	// MimeType: Required. The format of the gcs destination. Only "text/csv" and
	// "application/json" are supported.
	MimeType string `json:"mimeType,omitempty"`
	// OutputUri: Required. The output uri of destination file.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MimeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MimeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1GcsFolderDestination: Export folder
// destination of the data.
type GoogleCloudDatalabelingV1p2alpha1GcsFolderDestination struct {
	// OutputFolderUri: Required. Cloud Storage directory to export data to.
	OutputFolderUri string `json:"outputFolderUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputFolderUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputFolderUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1GcsFolderDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1GcsFolderDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig: Configuration for
// how human labeling task should be done.
type GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig struct {
	// AnnotatedDatasetDescription: Optional. A human-readable description for
	// AnnotatedDataset. The description can be up to 10000 characters long.
	AnnotatedDatasetDescription string `json:"annotatedDatasetDescription,omitempty"`
	// AnnotatedDatasetDisplayName: Required. A human-readable name for
	// AnnotatedDataset defined by users. Maximum of 64 characters .
	AnnotatedDatasetDisplayName string `json:"annotatedDatasetDisplayName,omitempty"`
	// ContributorEmails: Optional. If you want your own labeling contributors to
	// manage and work on this labeling request, you can set these contributors
	// here. We will give them access to the question types in crowdcompute. Note
	// that these emails must be registered in crowdcompute worker UI:
	// https://crowd-compute.appspot.com/
	ContributorEmails []string `json:"contributorEmails,omitempty"`
	// Instruction: Required. Instruction resource name.
	Instruction string `json:"instruction,omitempty"`
	// LabelGroup: Optional. A human-readable label used to logically group
	// labeling tasks. This string must match the regular expression
	// `[a-zA-Z\\d_-]{0,128}`.
	LabelGroup string `json:"labelGroup,omitempty"`
	// LanguageCode: Optional. The Language of this question, as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only
	// need to set this when task is language related. For example, French text
	// classification.
	LanguageCode string `json:"languageCode,omitempty"`
	// QuestionDuration: Optional. Maximum duration for contributors to answer a
	// question. Maximum is 3600 seconds. Default is 3600 seconds.
	QuestionDuration string `json:"questionDuration,omitempty"`
	// ReplicaCount: Optional. Replication of questions. Each question will be sent
	// to up to this number of contributors to label. Aggregated answers will be
	// returned. Default is set to 1. For image related labeling, valid values are
	// 1, 3, 5.
	ReplicaCount int64 `json:"replicaCount,omitempty"`
	// UserEmailAddress: Email of the user who started the labeling task and should
	// be notified by email. If empty no notification will be sent.
	UserEmailAddress string `json:"userEmailAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AnnotatedDatasetDescription") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDatasetDescription") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1ImportDataOperationMetadata: Metadata of an
// ImportData operation.
type GoogleCloudDatalabelingV1p2alpha1ImportDataOperationMetadata struct {
	// CreateTime: Output only. Timestamp when import dataset request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of imported dataset. "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1ImportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1ImportDataOperationResponse: Response used
// for ImportData longrunning operation.
type GoogleCloudDatalabelingV1p2alpha1ImportDataOperationResponse struct {
	// Dataset: Ouptut only. The name of imported dataset.
	Dataset string `json:"dataset,omitempty"`
	// ImportCount: Output only. Number of examples imported successfully.
	ImportCount int64 `json:"importCount,omitempty"`
	// TotalCount: Output only. Total number of examples requested to import
	TotalCount int64 `json:"totalCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1ImportDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1ImportDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingBoxOperationMetadata:
// Details of a LabelImageBoundingBox operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingPolyOperationMetadata:
// Details of LabelImageBoundingPoly operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingPolyOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingPolyOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingPolyOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelImageClassificationOperationMetadata:
// Metadata of a LabelImageClassification operation.
type GoogleCloudDatalabelingV1p2alpha1LabelImageClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelImageClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelImageClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelImageOrientedBoundingBoxOperationMetada
// ta: Details of a LabelImageOrientedBoundingBox operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelImageOrientedBoundingBoxOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelImageOrientedBoundingBoxOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelImageOrientedBoundingBoxOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelImagePolylineOperationMetadata:
// Details of LabelImagePolyline operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelImagePolylineOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelImagePolylineOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelImagePolylineOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelImageSegmentationOperationMetadata:
// Details of a LabelImageSegmentation operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelImageSegmentationOperationMetadata struct {
	// BasicConfig: Basic human annotation config.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelImageSegmentationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelImageSegmentationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelOperationMetadata: Metadata of a
// labeling operation, such as LabelImage or LabelVideo. Next tag: 23
type GoogleCloudDatalabelingV1p2alpha1LabelOperationMetadata struct {
	// AnnotatedDataset: Output only. The name of annotated dataset in format
	// "projects/*/datasets/*/annotatedDatasets/*".
	AnnotatedDataset string `json:"annotatedDataset,omitempty"`
	// CreateTime: Output only. Timestamp when labeling request was created.
	CreateTime string `json:"createTime,omitempty"`
	// Dataset: Output only. The name of dataset to be labeled.
	// "projects/*/datasets/*"
	Dataset string `json:"dataset,omitempty"`
	// ImageBoundingBoxDetails: Details of label image bounding box operation.
	ImageBoundingBoxDetails *GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingBoxOperationMetadata `json:"imageBoundingBoxDetails,omitempty"`
	// ImageBoundingPolyDetails: Details of label image bounding poly operation.
	ImageBoundingPolyDetails *GoogleCloudDatalabelingV1p2alpha1LabelImageBoundingPolyOperationMetadata `json:"imageBoundingPolyDetails,omitempty"`
	// ImageClassificationDetails: Details of label image classification operation.
	ImageClassificationDetails *GoogleCloudDatalabelingV1p2alpha1LabelImageClassificationOperationMetadata `json:"imageClassificationDetails,omitempty"`
	// ImageOrientedBoundingBoxDetails: Details of label image oriented bounding
	// box operation.
	ImageOrientedBoundingBoxDetails *GoogleCloudDatalabelingV1p2alpha1LabelImageOrientedBoundingBoxOperationMetadata `json:"imageOrientedBoundingBoxDetails,omitempty"`
	// ImagePolylineDetails: Details of label image polyline operation.
	ImagePolylineDetails *GoogleCloudDatalabelingV1p2alpha1LabelImagePolylineOperationMetadata `json:"imagePolylineDetails,omitempty"`
	// ImageSegmentationDetails: Details of label image segmentation operation.
	ImageSegmentationDetails *GoogleCloudDatalabelingV1p2alpha1LabelImageSegmentationOperationMetadata `json:"imageSegmentationDetails,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. Status details field will contain standard GCP
	// error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ProgressPercent: Output only. Progress of label operation. Range: [0, 100].
	ProgressPercent int64 `json:"progressPercent,omitempty"`
	// TextClassificationDetails: Details of label text classification operation.
	TextClassificationDetails *GoogleCloudDatalabelingV1p2alpha1LabelTextClassificationOperationMetadata `json:"textClassificationDetails,omitempty"`
	// TextEntityExtractionDetails: Details of label text entity extraction
	// operation.
	TextEntityExtractionDetails *GoogleCloudDatalabelingV1p2alpha1LabelTextEntityExtractionOperationMetadata `json:"textEntityExtractionDetails,omitempty"`
	// VideoClassificationDetails: Details of label video classification operation.
	VideoClassificationDetails *GoogleCloudDatalabelingV1p2alpha1LabelVideoClassificationOperationMetadata `json:"videoClassificationDetails,omitempty"`
	// VideoEventDetails: Details of label video event operation.
	VideoEventDetails *GoogleCloudDatalabelingV1p2alpha1LabelVideoEventOperationMetadata `json:"videoEventDetails,omitempty"`
	// VideoObjectDetectionDetails: Details of label video object detection
	// operation.
	VideoObjectDetectionDetails *GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectDetectionOperationMetadata `json:"videoObjectDetectionDetails,omitempty"`
	// VideoObjectTrackingDetails: Details of label video object tracking
	// operation.
	VideoObjectTrackingDetails *GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectTrackingOperationMetadata `json:"videoObjectTrackingDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatedDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatedDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelStats: Statistics about annotation
// specs.
type GoogleCloudDatalabelingV1p2alpha1LabelStats struct {
	// ExampleCount: Map of each annotation spec's example count. Key is the
	// annotation spec name and value is the number of examples for that annotation
	// spec. If the annotated dataset does not have annotation spec, the map will
	// return a pair where the key is empty string and value is the total number of
	// annotations.
	ExampleCount map[string]string `json:"exampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelTextClassificationOperationMetadata:
// Details of a LabelTextClassification operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelTextClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelTextClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelTextClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelTextEntityExtractionOperationMetadata:
// Details of a LabelTextEntityExtraction operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelTextEntityExtractionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelTextEntityExtractionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelTextEntityExtractionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelVideoClassificationOperationMetadata:
// Details of a LabelVideoClassification operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelVideoClassificationOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelVideoClassificationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelVideoClassificationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelVideoEventOperationMetadata: Details
// of a LabelVideoEvent operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelVideoEventOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelVideoEventOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelVideoEventOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectDetectionOperationMetadata:
// Details of a LabelVideoObjectDetection operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectDetectionOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectDetectionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectDetectionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectTrackingOperationMetadata:
// Details of a LabelVideoObjectTracking operation metadata.
type GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectTrackingOperationMetadata struct {
	// BasicConfig: Basic human annotation config used in labeling request.
	BasicConfig *GoogleCloudDatalabelingV1p2alpha1HumanAnnotationConfig `json:"basicConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectTrackingOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1LabelVideoObjectTrackingOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDatalabelingV1p2alpha1OutputConfig: The configuration of output
// data.
type GoogleCloudDatalabelingV1p2alpha1OutputConfig struct {
	// GcsDestination: Output to a file in Cloud Storage. Should be used for
	// labeling output other than image segmentation.
	GcsDestination *GoogleCloudDatalabelingV1p2alpha1GcsDestination `json:"gcsDestination,omitempty"`
	// GcsFolderDestination: Output to a folder in Cloud Storage. Should be used
	// for image segmentation or document de-identification labeling outputs.
	GcsFolderDestination *GoogleCloudDatalabelingV1p2alpha1GcsFolderDestination `json:"gcsFolderDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDatalabelingV1p2alpha1OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDatalabelingV1p2alpha1OutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsAnnotationSpecSetsCreateCall struct {
	s                                                            *Service
	parent                                                       string
	googleclouddatalabelingv1beta1createannotationspecsetrequest *GoogleCloudDatalabelingV1beta1CreateAnnotationSpecSetRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// Create: Creates an annotation spec set by providing a set of labels.
//
// - parent: AnnotationSpecSet resource parent, format: projects/{project_id}.
func (r *ProjectsAnnotationSpecSetsService) Create(parent string, googleclouddatalabelingv1beta1createannotationspecsetrequest *GoogleCloudDatalabelingV1beta1CreateAnnotationSpecSetRequest) *ProjectsAnnotationSpecSetsCreateCall {
	c := &ProjectsAnnotationSpecSetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1createannotationspecsetrequest = googleclouddatalabelingv1beta1createannotationspecsetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAnnotationSpecSetsCreateCall) Fields(s ...googleapi.Field) *ProjectsAnnotationSpecSetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAnnotationSpecSetsCreateCall) Context(ctx context.Context) *ProjectsAnnotationSpecSetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAnnotationSpecSetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAnnotationSpecSetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1createannotationspecsetrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotationSpecSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.annotationSpecSets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1AnnotationSpecSet.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAnnotationSpecSetsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1AnnotationSpecSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1AnnotationSpecSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAnnotationSpecSetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an annotation spec set by resource name.
//
//   - name: AnnotationSpec resource name, format:
//     `projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}`.
func (r *ProjectsAnnotationSpecSetsService) Delete(name string) *ProjectsAnnotationSpecSetsDeleteCall {
	c := &ProjectsAnnotationSpecSetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAnnotationSpecSetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsAnnotationSpecSetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAnnotationSpecSetsDeleteCall) Context(ctx context.Context) *ProjectsAnnotationSpecSetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAnnotationSpecSetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAnnotationSpecSetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.annotationSpecSets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAnnotationSpecSetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAnnotationSpecSetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an annotation spec set by resource name.
//
//   - name: AnnotationSpecSet resource name, format:
//     projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}.
func (r *ProjectsAnnotationSpecSetsService) Get(name string) *ProjectsAnnotationSpecSetsGetCall {
	c := &ProjectsAnnotationSpecSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAnnotationSpecSetsGetCall) Fields(s ...googleapi.Field) *ProjectsAnnotationSpecSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAnnotationSpecSetsGetCall) IfNoneMatch(entityTag string) *ProjectsAnnotationSpecSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAnnotationSpecSetsGetCall) Context(ctx context.Context) *ProjectsAnnotationSpecSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAnnotationSpecSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAnnotationSpecSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.annotationSpecSets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1AnnotationSpecSet.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAnnotationSpecSetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1AnnotationSpecSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1AnnotationSpecSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAnnotationSpecSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists annotation spec sets for a project. Pagination is supported.
//
//   - parent: Parent of AnnotationSpecSet resource, format:
//     projects/{project_id}.
func (r *ProjectsAnnotationSpecSetsService) List(parent string) *ProjectsAnnotationSpecSetsListCall {
	c := &ProjectsAnnotationSpecSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter is not supported at this
// moment.
func (c *ProjectsAnnotationSpecSetsListCall) Filter(filter string) *ProjectsAnnotationSpecSetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsAnnotationSpecSetsListCall) PageSize(pageSize int64) *ProjectsAnnotationSpecSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListAnnotationSpecSetsResponse.next_page_token of the previous
// [DataLabelingService.ListAnnotationSpecSets] call. Return first page if
// empty.
func (c *ProjectsAnnotationSpecSetsListCall) PageToken(pageToken string) *ProjectsAnnotationSpecSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAnnotationSpecSetsListCall) Fields(s ...googleapi.Field) *ProjectsAnnotationSpecSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAnnotationSpecSetsListCall) IfNoneMatch(entityTag string) *ProjectsAnnotationSpecSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAnnotationSpecSetsListCall) Context(ctx context.Context) *ProjectsAnnotationSpecSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAnnotationSpecSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAnnotationSpecSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotationSpecSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.annotationSpecSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAnnotationSpecSetsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.annotationSpecSets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAnnotationSpecSetsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListAnnotationSpecSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsCreateCall struct {
	s                                                  *Service
	parent                                             string
	googleclouddatalabelingv1beta1createdatasetrequest *GoogleCloudDatalabelingV1beta1CreateDatasetRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// Create: Creates dataset. If success return a Dataset resource.
//
// - parent: Dataset resource parent, format: projects/{project_id}.
func (r *ProjectsDatasetsService) Create(parent string, googleclouddatalabelingv1beta1createdatasetrequest *GoogleCloudDatalabelingV1beta1CreateDatasetRequest) *ProjectsDatasetsCreateCall {
	c := &ProjectsDatasetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1createdatasetrequest = googleclouddatalabelingv1beta1createdatasetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsCreateCall) Fields(s ...googleapi.Field) *ProjectsDatasetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsCreateCall) Context(ctx context.Context) *ProjectsDatasetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1createdatasetrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1Dataset.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a dataset by resource name.
//
//   - name: Dataset resource name, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsService) Delete(name string) *ProjectsDatasetsDeleteCall {
	c := &ProjectsDatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsDatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsDeleteCall) Context(ctx context.Context) *ProjectsDatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatasetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsExportDataCall struct {
	s                                               *Service
	name                                            string
	googleclouddatalabelingv1beta1exportdatarequest *GoogleCloudDatalabelingV1beta1ExportDataRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// ExportData: Exports data and annotations from dataset.
//
//   - name: Dataset resource name, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsService) ExportData(name string, googleclouddatalabelingv1beta1exportdatarequest *GoogleCloudDatalabelingV1beta1ExportDataRequest) *ProjectsDatasetsExportDataCall {
	c := &ProjectsDatasetsExportDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddatalabelingv1beta1exportdatarequest = googleclouddatalabelingv1beta1exportdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsExportDataCall) Fields(s ...googleapi.Field) *ProjectsDatasetsExportDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsExportDataCall) Context(ctx context.Context) *ProjectsDatasetsExportDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsExportDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsExportDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1exportdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:exportData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.exportData", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.exportData" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsExportDataCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.exportData", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets dataset by resource name.
//
//   - name: Dataset resource name, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsService) Get(name string) *ProjectsDatasetsGetCall {
	c := &ProjectsDatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsGetCall) Context(ctx context.Context) *ProjectsDatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1Dataset.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsImportDataCall struct {
	s                                               *Service
	name                                            string
	googleclouddatalabelingv1beta1importdatarequest *GoogleCloudDatalabelingV1beta1ImportDataRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// ImportData: Imports data into dataset based on source locations defined in
// request. It can be called multiple times for the same dataset. Each dataset
// can only have one long running operation running on it. For example, no
// labeling task (also long running operation) can be started while importing
// is still ongoing. Vice versa.
//
//   - name: Dataset resource name, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsService) ImportData(name string, googleclouddatalabelingv1beta1importdatarequest *GoogleCloudDatalabelingV1beta1ImportDataRequest) *ProjectsDatasetsImportDataCall {
	c := &ProjectsDatasetsImportDataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddatalabelingv1beta1importdatarequest = googleclouddatalabelingv1beta1importdatarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsImportDataCall) Fields(s ...googleapi.Field) *ProjectsDatasetsImportDataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsImportDataCall) Context(ctx context.Context) *ProjectsDatasetsImportDataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsImportDataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsImportDataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1importdatarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:importData")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.importData", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.importData" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsImportDataCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.importData", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists datasets under a project. Pagination is supported.
//
// - parent: Dataset resource parent, format: projects/{project_id}.
func (r *ProjectsDatasetsService) List(parent string) *ProjectsDatasetsListCall {
	c := &ProjectsDatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter on dataset is not
// supported at this moment.
func (c *ProjectsDatasetsListCall) Filter(filter string) *ProjectsDatasetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsListCall) PageSize(pageSize int64) *ProjectsDatasetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListDatasetsResponse.next_page_token of the previous
// [DataLabelingService.ListDatasets] call. Returns the first page if empty.
func (c *ProjectsDatasetsListCall) PageToken(pageToken string) *ProjectsDatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsListCall) Context(ctx context.Context) *ProjectsDatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListDatasetsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListDatasetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListDatasetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListDatasetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsAnnotatedDatasetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an annotated dataset by resource name.
//
//   - name: Name of the annotated dataset to delete, format:
//     projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
//     {annotated_dataset_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsService) Delete(name string) *ProjectsDatasetsAnnotatedDatasetsDeleteCall {
	c := &ProjectsDatasetsAnnotatedDatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsDeleteCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatasetsAnnotatedDatasetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an annotated dataset by resource name.
//
//   - name: Name of the annotated dataset to get, format:
//     projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
//     {annotated_dataset_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsService) Get(name string) *ProjectsDatasetsAnnotatedDatasetsGetCall {
	c := &ProjectsDatasetsAnnotatedDatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsGetCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1AnnotatedDataset.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1AnnotatedDataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1AnnotatedDataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists annotated datasets for a dataset. Pagination is supported.
//
//   - parent: Name of the dataset to list annotated datasets, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsService) List(parent string) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c := &ProjectsDatasetsAnnotatedDatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter is not supported at this
// moment.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) Filter(filter string) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) PageSize(pageSize int64) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListAnnotatedDatasetsResponse.next_page_token of the previous
// [DataLabelingService.ListAnnotatedDatasets] call. Return first page if
// empty.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) PageToken(pageToken string) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/annotatedDatasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsAnnotatedDatasetsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListAnnotatedDatasetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a data item in a dataset by resource name. This API can be called
// after data are imported into dataset.
//
//   - name: The name of the data item to get, format:
//     projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsDataItemsService) Get(name string) *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall {
	c := &ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.dataItems.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.dataItems.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1DataItem.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1DataItem, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1DataItem{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.dataItems.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsDataItemsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists data items in a dataset. This API can be called after data are
// imported into dataset. Pagination is supported.
//
//   - parent: Name of the dataset to list data items, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsDataItemsService) List(parent string) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c := &ProjectsDatasetsAnnotatedDatasetsDataItemsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter is not supported at this
// moment.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) Filter(filter string) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) PageSize(pageSize int64) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListDataItemsResponse.next_page_token of the previous
// [DataLabelingService.ListDataItems] call. Return first page if empty.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) PageToken(pageToken string) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dataItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.dataItems.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.dataItems.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListDataItemsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListDataItemsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListDataItemsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.dataItems.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsAnnotatedDatasetsDataItemsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListDataItemsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsAnnotatedDatasetsExamplesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an example by resource name, including both data and annotation.
//
//   - name: Name of example, format:
//     projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
//     {annotated_dataset_id}/examples/{example_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsExamplesService) Get(name string) *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall {
	c := &ProjectsDatasetsAnnotatedDatasetsExamplesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering
// Examples. Filter by annotation_spec.display_name is supported. Format
// "annotation_spec.display_name = {display_name}"
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) Filter(filter string) *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.examples.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.examples.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1Example.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1Example, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1Example{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.examples.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsExamplesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists examples in an annotated dataset. Pagination is supported.
//
// - parent: Example resource parent.
func (r *ProjectsDatasetsAnnotatedDatasetsExamplesService) List(parent string) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c := &ProjectsDatasetsAnnotatedDatasetsExamplesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering
// Examples. For annotated datasets that have annotation spec set, filter by
// annotation_spec.display_name is supported. Format
// "annotation_spec.display_name = {display_name}"
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) Filter(filter string) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) PageSize(pageSize int64) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListExamplesResponse.next_page_token of the previous
// [DataLabelingService.ListExamples] call. Return first page if empty.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) PageToken(pageToken string) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsExamplesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/examples")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.examples.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.examples.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListExamplesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListExamplesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListExamplesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.examples.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsAnnotatedDatasetsExamplesListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListExamplesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a FeedbackThread.
//
//   - name: Name of the FeedbackThread that is going to be deleted. Format:
//     'projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_d
//     ataset_id}/feedbackThreads/{feedback_thread_id}'.
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService) Delete(name string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a FeedbackThread object.
//
//   - name: Name of the feedback. Format:
//     'projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_d
//     ataset_id}/feedbackThreads/{feedback_thread_id}'.
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService) Get(name string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1FeedbackThread.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1FeedbackThread, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1FeedbackThread{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List FeedbackThreads with pagination.
//
//   - parent: FeedbackThread resource parent. Format:
//     "projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_d
//     ataset_id}".
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsService) List(parent string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) PageSize(pageSize int64) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListFeedbackThreads.next_page_token of the previous
// [DataLabelingService.ListFeedbackThreads] call. Return first page if empty.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) PageToken(pageToken string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/feedbackThreads")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListFeedbackThreadsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall struct {
	s                                             *Service
	parent                                        string
	googleclouddatalabelingv1beta1feedbackmessage *GoogleCloudDatalabelingV1beta1FeedbackMessage
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Create: Create a FeedbackMessage object.
//
//   - parent: FeedbackMessage resource parent, format:
//     projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_da
//     taset_id}/feedbackThreads/{feedback_thread_id}.
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService) Create(parent string, googleclouddatalabelingv1beta1feedbackmessage *GoogleCloudDatalabelingV1beta1FeedbackMessage) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1feedbackmessage = googleclouddatalabelingv1beta1feedbackmessage
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1feedbackmessage)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/feedbackMessages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a FeedbackMessage.
//
//   - name: Name of the FeedbackMessage that is going to be deleted. Format:
//     'projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_d
//     ataset_id}/feedbackThreads/{feedback_thread_id}/feedbackMessages/{feedback_
//     message_id}'.
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService) Delete(name string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a FeedbackMessage object.
//
//   - name: Name of the feedback. Format:
//     'projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_d
//     ataset_id}/feedbackThreads/{feedback_thread_id}/feedbackMessages/{feedback_
//     message_id}'.
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService) Get(name string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1FeedbackMessage.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1FeedbackMessage, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1FeedbackMessage{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List FeedbackMessages with pagination.
//
//   - parent: FeedbackMessage resource parent. Format:
//     "projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_d
//     ataset_id}/feedbackThreads/{feedback_thread_id}".
func (r *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesService) List(parent string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall {
	c := &ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) PageSize(pageSize int64) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListFeedbackMessages.next_page_token of the previous
// [DataLabelingService.ListFeedbackMessages] call. Return first page if empty.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) PageToken(pageToken string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) Context(ctx context.Context) *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/feedbackMessages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.annotatedDatasets.feedbackThreads.feedbackMessages.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsAnnotatedDatasetsFeedbackThreadsFeedbackMessagesListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsDataItemsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a data item in a dataset by resource name. This API can be called
// after data are imported into dataset.
//
//   - name: The name of the data item to get, format:
//     projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}.
func (r *ProjectsDatasetsDataItemsService) Get(name string) *ProjectsDatasetsDataItemsGetCall {
	c := &ProjectsDatasetsDataItemsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsDataItemsGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsDataItemsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsDataItemsGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsDataItemsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsDataItemsGetCall) Context(ctx context.Context) *ProjectsDatasetsDataItemsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsDataItemsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsDataItemsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.dataItems.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.dataItems.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1DataItem.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsDataItemsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1DataItem, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1DataItem{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.dataItems.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsDataItemsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists data items in a dataset. This API can be called after data are
// imported into dataset. Pagination is supported.
//
//   - parent: Name of the dataset to list data items, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsDataItemsService) List(parent string) *ProjectsDatasetsDataItemsListCall {
	c := &ProjectsDatasetsDataItemsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter is not supported at this
// moment.
func (c *ProjectsDatasetsDataItemsListCall) Filter(filter string) *ProjectsDatasetsDataItemsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsDatasetsDataItemsListCall) PageSize(pageSize int64) *ProjectsDatasetsDataItemsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListDataItemsResponse.next_page_token of the previous
// [DataLabelingService.ListDataItems] call. Return first page if empty.
func (c *ProjectsDatasetsDataItemsListCall) PageToken(pageToken string) *ProjectsDatasetsDataItemsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsDataItemsListCall) Fields(s ...googleapi.Field) *ProjectsDatasetsDataItemsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsDataItemsListCall) IfNoneMatch(entityTag string) *ProjectsDatasetsDataItemsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsDataItemsListCall) Context(ctx context.Context) *ProjectsDatasetsDataItemsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsDataItemsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsDataItemsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/dataItems")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.dataItems.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.dataItems.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListDataItemsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsDataItemsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListDataItemsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListDataItemsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.dataItems.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsDataItemsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListDataItemsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDatasetsEvaluationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an evaluation by resource name (to search, use
// projects.evaluations.search).
//
//   - name: Name of the evaluation. Format: "projects/{project_id}/datasets/
//     {dataset_id}/evaluations/{evaluation_id}'.
func (r *ProjectsDatasetsEvaluationsService) Get(name string) *ProjectsDatasetsEvaluationsGetCall {
	c := &ProjectsDatasetsEvaluationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsEvaluationsGetCall) Fields(s ...googleapi.Field) *ProjectsDatasetsEvaluationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDatasetsEvaluationsGetCall) IfNoneMatch(entityTag string) *ProjectsDatasetsEvaluationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsEvaluationsGetCall) Context(ctx context.Context) *ProjectsDatasetsEvaluationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsEvaluationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsEvaluationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.evaluations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.evaluations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1Evaluation.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsEvaluationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1Evaluation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1Evaluation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.evaluations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsEvaluationsExampleComparisonsSearchCall struct {
	s                                                             *Service
	parent                                                        string
	googleclouddatalabelingv1beta1searchexamplecomparisonsrequest *GoogleCloudDatalabelingV1beta1SearchExampleComparisonsRequest
	urlParams_                                                    gensupport.URLParams
	ctx_                                                          context.Context
	header_                                                       http.Header
}

// Search: Searches example comparisons from an evaluation. The return format
// is a list of example comparisons that show ground truth and prediction(s)
// for a single input. Search by providing an evaluation ID.
//
//   - parent: Name of the Evaluation resource to search for example comparisons
//     from. Format: "projects/{project_id}/datasets/{dataset_id}/evaluations/
//     {evaluation_id}".
func (r *ProjectsDatasetsEvaluationsExampleComparisonsService) Search(parent string, googleclouddatalabelingv1beta1searchexamplecomparisonsrequest *GoogleCloudDatalabelingV1beta1SearchExampleComparisonsRequest) *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall {
	c := &ProjectsDatasetsEvaluationsExampleComparisonsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1searchexamplecomparisonsrequest = googleclouddatalabelingv1beta1searchexamplecomparisonsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall) Fields(s ...googleapi.Field) *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall) Context(ctx context.Context) *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1searchexamplecomparisonsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/exampleComparisons:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.evaluations.exampleComparisons.search", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.evaluations.exampleComparisons.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.evaluations.exampleComparisons.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDatasetsEvaluationsExampleComparisonsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1SearchExampleComparisonsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleclouddatalabelingv1beta1searchexamplecomparisonsrequest.PageToken = pt }(c.googleclouddatalabelingv1beta1searchexamplecomparisonsrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleclouddatalabelingv1beta1searchexamplecomparisonsrequest.PageToken = x.NextPageToken
	}
}

type ProjectsDatasetsImageLabelCall struct {
	s                                               *Service
	parent                                          string
	googleclouddatalabelingv1beta1labelimagerequest *GoogleCloudDatalabelingV1beta1LabelImageRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Label: Starts a labeling task for image. The type of image labeling task is
// configured by feature in the request.
//
//   - parent: Name of the dataset to request labeling task, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsImageService) Label(parent string, googleclouddatalabelingv1beta1labelimagerequest *GoogleCloudDatalabelingV1beta1LabelImageRequest) *ProjectsDatasetsImageLabelCall {
	c := &ProjectsDatasetsImageLabelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1labelimagerequest = googleclouddatalabelingv1beta1labelimagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsImageLabelCall) Fields(s ...googleapi.Field) *ProjectsDatasetsImageLabelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsImageLabelCall) Context(ctx context.Context) *ProjectsDatasetsImageLabelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsImageLabelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsImageLabelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1labelimagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/image:label")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.image.label", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.image.label" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsImageLabelCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.image.label", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsTextLabelCall struct {
	s                                              *Service
	parent                                         string
	googleclouddatalabelingv1beta1labeltextrequest *GoogleCloudDatalabelingV1beta1LabelTextRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Label: Starts a labeling task for text. The type of text labeling task is
// configured by feature in the request.
//
//   - parent: Name of the data set to request labeling task, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsTextService) Label(parent string, googleclouddatalabelingv1beta1labeltextrequest *GoogleCloudDatalabelingV1beta1LabelTextRequest) *ProjectsDatasetsTextLabelCall {
	c := &ProjectsDatasetsTextLabelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1labeltextrequest = googleclouddatalabelingv1beta1labeltextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsTextLabelCall) Fields(s ...googleapi.Field) *ProjectsDatasetsTextLabelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsTextLabelCall) Context(ctx context.Context) *ProjectsDatasetsTextLabelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsTextLabelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsTextLabelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1labeltextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/text:label")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.text.label", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.text.label" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsTextLabelCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.text.label", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDatasetsVideoLabelCall struct {
	s                                               *Service
	parent                                          string
	googleclouddatalabelingv1beta1labelvideorequest *GoogleCloudDatalabelingV1beta1LabelVideoRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Label: Starts a labeling task for video. The type of video labeling task is
// configured by feature in the request.
//
//   - parent: Name of the dataset to request labeling task, format:
//     projects/{project_id}/datasets/{dataset_id}.
func (r *ProjectsDatasetsVideoService) Label(parent string, googleclouddatalabelingv1beta1labelvideorequest *GoogleCloudDatalabelingV1beta1LabelVideoRequest) *ProjectsDatasetsVideoLabelCall {
	c := &ProjectsDatasetsVideoLabelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1labelvideorequest = googleclouddatalabelingv1beta1labelvideorequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDatasetsVideoLabelCall) Fields(s ...googleapi.Field) *ProjectsDatasetsVideoLabelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDatasetsVideoLabelCall) Context(ctx context.Context) *ProjectsDatasetsVideoLabelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDatasetsVideoLabelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDatasetsVideoLabelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1labelvideorequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/video:label")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.video.label", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.datasets.video.label" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDatasetsVideoLabelCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.datasets.video.label", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationJobsCreateCall struct {
	s                                                        *Service
	parent                                                   string
	googleclouddatalabelingv1beta1createevaluationjobrequest *GoogleCloudDatalabelingV1beta1CreateEvaluationJobRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Create: Creates an evaluation job.
//
// - parent: Evaluation job resource parent. Format: "projects/{project_id}".
func (r *ProjectsEvaluationJobsService) Create(parent string, googleclouddatalabelingv1beta1createevaluationjobrequest *GoogleCloudDatalabelingV1beta1CreateEvaluationJobRequest) *ProjectsEvaluationJobsCreateCall {
	c := &ProjectsEvaluationJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1createevaluationjobrequest = googleclouddatalabelingv1beta1createevaluationjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsCreateCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsCreateCall) Context(ctx context.Context) *ProjectsEvaluationJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1createevaluationjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/evaluationJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1EvaluationJob.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsEvaluationJobsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1EvaluationJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1EvaluationJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Stops and deletes an evaluation job.
//
//   - name: Name of the evaluation job that is going to be deleted. Format:
//     "projects/{project_id}/evaluationJobs/{evaluation_job_id}".
func (r *ProjectsEvaluationJobsService) Delete(name string) *ProjectsEvaluationJobsDeleteCall {
	c := &ProjectsEvaluationJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsDeleteCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsDeleteCall) Context(ctx context.Context) *ProjectsEvaluationJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsEvaluationJobsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an evaluation job by resource name.
//
//   - name: Name of the evaluation job. Format: "projects/{project_id}
//     /evaluationJobs/{evaluation_job_id}".
func (r *ProjectsEvaluationJobsService) Get(name string) *ProjectsEvaluationJobsGetCall {
	c := &ProjectsEvaluationJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsGetCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsEvaluationJobsGetCall) IfNoneMatch(entityTag string) *ProjectsEvaluationJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsGetCall) Context(ctx context.Context) *ProjectsEvaluationJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1EvaluationJob.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsEvaluationJobsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1EvaluationJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1EvaluationJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all evaluation jobs within a project with possible filters.
// Pagination is supported.
//
// - parent: Evaluation job resource parent. Format: "projects/{project_id}".
func (r *ProjectsEvaluationJobsService) List(parent string) *ProjectsEvaluationJobsListCall {
	c := &ProjectsEvaluationJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": You can filter the jobs to list
// by model_id (also known as model_name, as described in
// EvaluationJob.modelVersion) or by evaluation job state (as described in
// EvaluationJob.state). To filter by both criteria, use the `AND` operator or
// the `OR` operator. For example, you can use the following string for your
// filter: "evaluation_job.model_id = {model_name} AND evaluation_job.state =
// {evaluation_job_state}"
func (c *ProjectsEvaluationJobsListCall) Filter(filter string) *ProjectsEvaluationJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsEvaluationJobsListCall) PageSize(pageSize int64) *ProjectsEvaluationJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by the
// nextPageToken in the response to the previous request. The request returns
// the first page if this is empty.
func (c *ProjectsEvaluationJobsListCall) PageToken(pageToken string) *ProjectsEvaluationJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsListCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsEvaluationJobsListCall) IfNoneMatch(entityTag string) *ProjectsEvaluationJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsListCall) Context(ctx context.Context) *ProjectsEvaluationJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/evaluationJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsEvaluationJobsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsEvaluationJobsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListEvaluationJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsEvaluationJobsPatchCall struct {
	s                                           *Service
	name                                        string
	googleclouddatalabelingv1beta1evaluationjob *GoogleCloudDatalabelingV1beta1EvaluationJob
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Patch: Updates an evaluation job. You can only update certain fields of the
// job's EvaluationJobConfig: `humanAnnotationConfig.instruction`,
// `exampleCount`, and `exampleSamplePercentage`. If you want to change any
// other aspect of the evaluation job, you must delete the job and create a new
// one.
//
//   - name: Output only. After you create a job, Data Labeling Service assigns a
//     name to the job with the following format:
//     "projects/{project_id}/evaluationJobs/ {evaluation_job_id}".
func (r *ProjectsEvaluationJobsService) Patch(name string, googleclouddatalabelingv1beta1evaluationjob *GoogleCloudDatalabelingV1beta1EvaluationJob) *ProjectsEvaluationJobsPatchCall {
	c := &ProjectsEvaluationJobsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddatalabelingv1beta1evaluationjob = googleclouddatalabelingv1beta1evaluationjob
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask for which fields
// to update. You can only provide the following fields: *
// `evaluationJobConfig.humanAnnotationConfig.instruction` *
// `evaluationJobConfig.exampleCount` *
// `evaluationJobConfig.exampleSamplePercentage` You can provide more than one
// of these fields by separating them with commas.
func (c *ProjectsEvaluationJobsPatchCall) UpdateMask(updateMask string) *ProjectsEvaluationJobsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsPatchCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsPatchCall) Context(ctx context.Context) *ProjectsEvaluationJobsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1evaluationjob)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1EvaluationJob.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsEvaluationJobsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1EvaluationJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1EvaluationJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationJobsPauseCall struct {
	s                                                       *Service
	name                                                    string
	googleclouddatalabelingv1beta1pauseevaluationjobrequest *GoogleCloudDatalabelingV1beta1PauseEvaluationJobRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// Pause: Pauses an evaluation job. Pausing an evaluation job that is already
// in a `PAUSED` state is a no-op.
//
//   - name: Name of the evaluation job that is going to be paused. Format:
//     "projects/{project_id}/evaluationJobs/{evaluation_job_id}".
func (r *ProjectsEvaluationJobsService) Pause(name string, googleclouddatalabelingv1beta1pauseevaluationjobrequest *GoogleCloudDatalabelingV1beta1PauseEvaluationJobRequest) *ProjectsEvaluationJobsPauseCall {
	c := &ProjectsEvaluationJobsPauseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddatalabelingv1beta1pauseevaluationjobrequest = googleclouddatalabelingv1beta1pauseevaluationjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsPauseCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsPauseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsPauseCall) Context(ctx context.Context) *ProjectsEvaluationJobsPauseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsPauseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsPauseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1pauseevaluationjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:pause")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.pause", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.pause" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsEvaluationJobsPauseCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.pause", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationJobsResumeCall struct {
	s                                                        *Service
	name                                                     string
	googleclouddatalabelingv1beta1resumeevaluationjobrequest *GoogleCloudDatalabelingV1beta1ResumeEvaluationJobRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Resume: Resumes a paused evaluation job. A deleted evaluation job can't be
// resumed. Resuming a running or scheduled evaluation job is a no-op.
//
//   - name: Name of the evaluation job that is going to be resumed. Format:
//     "projects/{project_id}/evaluationJobs/{evaluation_job_id}".
func (r *ProjectsEvaluationJobsService) Resume(name string, googleclouddatalabelingv1beta1resumeevaluationjobrequest *GoogleCloudDatalabelingV1beta1ResumeEvaluationJobRequest) *ProjectsEvaluationJobsResumeCall {
	c := &ProjectsEvaluationJobsResumeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddatalabelingv1beta1resumeevaluationjobrequest = googleclouddatalabelingv1beta1resumeevaluationjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationJobsResumeCall) Fields(s ...googleapi.Field) *ProjectsEvaluationJobsResumeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationJobsResumeCall) Context(ctx context.Context) *ProjectsEvaluationJobsResumeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationJobsResumeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationJobsResumeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1resumeevaluationjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:resume")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.resume", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluationJobs.resume" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsEvaluationJobsResumeCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluationJobs.resume", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsEvaluationsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches evaluations within a project.
//
//   - parent: Evaluation search parent (project ID). Format: "projects/
//     {project_id}".
func (r *ProjectsEvaluationsService) Search(parent string) *ProjectsEvaluationsSearchCall {
	c := &ProjectsEvaluationsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": To search evaluations, you can
// filter by the following: * evaluation_job.evaluation_job_id (the last part
// of EvaluationJob.name) * evaluation_job.model_id (the {model_name} portion
// of EvaluationJob.modelVersion) *
// evaluation_job.evaluation_job_run_time_start (Minimum threshold for the
// evaluationJobRunTime that created the evaluation) *
// evaluation_job.evaluation_job_run_time_end (Maximum threshold for the
// evaluationJobRunTime that created the evaluation) * evaluation_job.job_state
// (EvaluationJob.state) * annotation_spec.display_name (the Evaluation
// contains a metric for the annotation spec with this displayName) To filter
// by multiple critiera, use the `AND` operator or the `OR` operator. The
// following examples shows a string that filters by several critiera:
// "evaluation_job.evaluation_job_id = {evaluation_job_id} AND
// evaluation_job.model_id = {model_name} AND
// evaluation_job.evaluation_job_run_time_start = {timestamp_1} AND
// evaluation_job.evaluation_job_run_time_end = {timestamp_2} AND
// annotation_spec.display_name = {display_name}"
func (c *ProjectsEvaluationsSearchCall) Filter(filter string) *ProjectsEvaluationsSearchCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsEvaluationsSearchCall) PageSize(pageSize int64) *ProjectsEvaluationsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by the
// nextPageToken of the response to a previous search request. If you don't
// specify this field, the API call requests the first page of the search.
func (c *ProjectsEvaluationsSearchCall) PageToken(pageToken string) *ProjectsEvaluationsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsEvaluationsSearchCall) Fields(s ...googleapi.Field) *ProjectsEvaluationsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsEvaluationsSearchCall) IfNoneMatch(entityTag string) *ProjectsEvaluationsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsEvaluationsSearchCall) Context(ctx context.Context) *ProjectsEvaluationsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsEvaluationsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsEvaluationsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/evaluations:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluations.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.evaluations.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse.ServerResponse.Heade
// r or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsEvaluationsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.evaluations.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsEvaluationsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1SearchEvaluationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsInstructionsCreateCall struct {
	s                                                      *Service
	parent                                                 string
	googleclouddatalabelingv1beta1createinstructionrequest *GoogleCloudDatalabelingV1beta1CreateInstructionRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Create: Creates an instruction for how data should be labeled.
//
// - parent: Instruction resource parent, format: projects/{project_id}.
func (r *ProjectsInstructionsService) Create(parent string, googleclouddatalabelingv1beta1createinstructionrequest *GoogleCloudDatalabelingV1beta1CreateInstructionRequest) *ProjectsInstructionsCreateCall {
	c := &ProjectsInstructionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddatalabelingv1beta1createinstructionrequest = googleclouddatalabelingv1beta1createinstructionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstructionsCreateCall) Fields(s ...googleapi.Field) *ProjectsInstructionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstructionsCreateCall) Context(ctx context.Context) *ProjectsInstructionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstructionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstructionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddatalabelingv1beta1createinstructionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/instructions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.instructions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsInstructionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstructionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an instruction object by resource name.
//
//   - name: Instruction resource name, format:
//     projects/{project_id}/instructions/{instruction_id}.
func (r *ProjectsInstructionsService) Delete(name string) *ProjectsInstructionsDeleteCall {
	c := &ProjectsInstructionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstructionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsInstructionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstructionsDeleteCall) Context(ctx context.Context) *ProjectsInstructionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstructionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstructionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.instructions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsInstructionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstructionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an instruction by resource name.
//
//   - name: Instruction resource name, format:
//     projects/{project_id}/instructions/{instruction_id}.
func (r *ProjectsInstructionsService) Get(name string) *ProjectsInstructionsGetCall {
	c := &ProjectsInstructionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstructionsGetCall) Fields(s ...googleapi.Field) *ProjectsInstructionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsInstructionsGetCall) IfNoneMatch(entityTag string) *ProjectsInstructionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstructionsGetCall) Context(ctx context.Context) *ProjectsInstructionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstructionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstructionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.instructions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1Instruction.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsInstructionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1Instruction, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1Instruction{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstructionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists instructions for a project. Pagination is supported.
//
// - parent: Instruction resource parent, format: projects/{project_id}.
func (r *ProjectsInstructionsService) List(parent string) *ProjectsInstructionsListCall {
	c := &ProjectsInstructionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter is not supported at this
// moment.
func (c *ProjectsInstructionsListCall) Filter(filter string) *ProjectsInstructionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer results than requested. Default value is 100.
func (c *ProjectsInstructionsListCall) PageSize(pageSize int64) *ProjectsInstructionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results for the server to return. Typically obtained by
// ListInstructionsResponse.next_page_token of the previous
// [DataLabelingService.ListInstructions] call. Return first page if empty.
func (c *ProjectsInstructionsListCall) PageToken(pageToken string) *ProjectsInstructionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstructionsListCall) Fields(s ...googleapi.Field) *ProjectsInstructionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsInstructionsListCall) IfNoneMatch(entityTag string) *ProjectsInstructionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstructionsListCall) Context(ctx context.Context) *ProjectsInstructionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstructionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstructionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/instructions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.instructions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDatalabelingV1beta1ListInstructionsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsInstructionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDatalabelingV1beta1ListInstructionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDatalabelingV1beta1ListInstructionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.instructions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsInstructionsListCall) Pages(ctx context.Context, f func(*GoogleCloudDatalabelingV1beta1ListInstructionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsOperationsCancelCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsOperationsService) Cancel(name string) *ProjectsOperationsCancelCall {
	c := &ProjectsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsCancelCall) IfNoneMatch(entityTag string) *ProjectsOperationsCancelCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsCancelCall) Context(ctx context.Context) *ProjectsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsOperationsService) Delete(name string) *ProjectsOperationsDeleteCall {
	c := &ProjectsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsDeleteCall) Context(ctx context.Context) *ProjectsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsOperationsService) Get(name string) *ProjectsOperationsGetCall {
	c := &ProjectsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsGetCall) Context(ctx context.Context) *ProjectsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsOperationsService) List(name string) *ProjectsOperationsListCall {
	c := &ProjectsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsOperationsListCall) Filter(filter string) *ProjectsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsOperationsListCall) PageSize(pageSize int64) *ProjectsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsOperationsListCall) PageToken(pageToken string) *ProjectsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsOperationsListCall) Context(ctx context.Context) *ProjectsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "datalabeling.projects.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "datalabeling.projects.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
