---
title: Community

intro: |
  Since its launch in 2016, Open Policy Agent has steadily gained momentum as
  the de facto approach for establishing authorization policies
  across cloud native environments.
  Its remarkable growth and adoption is due in no small part to the amazing
  community that has grown up right alongside it.
  Leverage this list of community resources to maximize the value OPA can provide!

sections:

- title: Community Support
  items:
    - title: OPA Slack
      icon: /img/community-logos/slack.png
      note: |
        Primary channel for community support and OPA maintainer discussions.
        Join #help for support.
      link: https://slack.openpolicyagent.org/
      link_text: Join us on Slack
    - title: GitHub
      icon: /img/community-logos/github.png
      note: |
        Get involved with OPA development; request a feature, file a bug,
        or view the code.
      link: https://github.com/open-policy-agent
      link_text: Visit OPA on GitHub
    - title: OPA Knowledge Base
      icon: /img/community-logos/github-discussions.png
      note: |
        Community powered support for OPA and Rego. Ask questions about writing
        Rego files, implementing OPA, or share the configurations you are working on.
      link: https://github.com/open-policy-agent/community/discussions
      link_text: Ask a Question
    - title: Stack Overflow
      icon: /img/community-logos/stack-overflow.png
      note: |
        Ask the global developer community questions about OPA with the tag #open-policy-agent
      link: https://stackoverflow.com/questions/tagged/open-policy-agent
      link_text: Ask a Question

- title: Learn
  items:
    - title: Styra Academy
      icon: /img/community-logos/styra-academy.png
      note: |
        Learning portal with courses on OPA and Rego.
      link: https://academy.styra.com
      link_text: Visit Styra Academy
    - title: Awesome OPA
      icon: /img/logos/opa-no-text-color.png
      note: |
        Curated list of OPA links and resources.
      link: https://github.com/StyraInc/awesome-opa
      link_text: Visit Awesome OPA

- title: Contribute
  items:
    - title: GitHub
      icon: /img/community-logos/github.png
      note: |
        Get involved with OPA development on GitHub.
      link: https://www.openpolicyagent.org/docs/latest/contributing/
      link_text: Read our contributing docs
    - title: Blog Post
      icon: /img/community-logos/blog.png
      note: |
        Contribute to the official OPA blog. Write about special use cases,
        advance configurations, deployment strategies or the OPA community.
      link: mailto:devrel@styra.com?subject=Contribute%20to%20OPA%20Blog
      link_text: Chat to us about a post
    - title: Conference and Meetup CFPs
      icon: /img/community-logos/cfp.png
      note: |
        Want to share your OPA knowledge with the world? The OPA team is here
        to help. Let us know and we can review, suggest edits or help you practice.
      link: mailto:devrel@styra.com?subject=Write%20a%20CFP
      link_text: Write a CFP

- title: Social Channels
  items:
    - title: Twitter
      icon: /img/community-logos/twitter.png
      note: |
        Connect with us on Twitter to get the latest announcements.
      link: https://twitter.com/openpolicyagent
      link_text: Follow us on Twitter
    - title: Medium
      icon: /img/community-logos/medium.png
      note: |
        Sign up to receive OPA news, blogs, and tutorials.
      link: https://medium.com/open-policy-agent
      link_text: Read the OPA Blog
    - title: LinkedIn
      icon: /img/community-logos/linkedin.png
      note: |
        Follow Open Policy Agent on LinkedIn and connect with others
        working with OPA.
      link: https://www.linkedin.com/company/open-policy-agent/
      link_text: Follow us on LinkedIn

- title: Champions
  items:
    - title: Peter Macdonald
      icon: /img/community-logos/petermacdonald.jpg
      links:
        - icon: mastodon
          description: Mastodon
          url: https://hachyderm.io/@parcifal
          text: parcifal
        - icon: twitter
          description: Twitter
          url: https://twitter.com/_PeterM_
          text: _PeterM_
        - icon: github
          description: GitHub
          url: https://github.com/Parsifal-M
          text: Parsifal-M
    - title: John Reese
      icon: /img/community-logos/john-reese.png
      links:
        - icon: mastodon
          description: Mastodon
          url: https://hachyderm.io/@jpreese
          text: jpreese
        - icon: twitter
          description: Twitter
          url: https://twitter.com/johnpreese
          text: johnpreese
        - icon: github
          description: GitHub
          url: https://github.com/jpreese
          text: jpreese
    - title: Grant Shively
      icon: /img/community-logos/grant-shively.png
      links:
        - icon: github
          description: GitHub
          url: https://github.com/gshively11
          text: gshively11
    - title: Masayoshi Mizutani
      icon: /img/community-logos/mizutani-masayoshi.png
      links:
        - icon: twitter
          description: Twitter
          url: https://twitter.com/m_mizutani
          text: m-mizutani
        - icon: github
          description: GitHub
          url: https://github.com/m-mizutani
          text: m-mizutani

- title: Meetups
  items:
    - title: Amsterdam OPA Users
      icon: /img/community-logos/meetup.png
      link: https://www.meetup.com/opa-amsterdam/
      link_text: Join the Amsterdam Meetup
    - title: London OPA Meetup
      icon: /img/community-logos/meetup.png
      link: https://www.meetup.com/london-opa-meetup/
      link_text: Join the London Meetup
    - title: Stockholm OPA Users
      icon: /img/community-logos/meetup.png
      link: https://www.meetup.com/stockholm-opa-meetup/
      link_text: Join the Stockholm Meetup
    - title: Host your own!
      note: |
        Host a localized meetup in your area or virtually.
        Share what you've learned and connect with the OPA community!
      icon: /img/community-logos/meetup.png
      link: mailto:devrel@styra.com?subject=Host%20an%20OPA%20Meetup
      link_text: Host a Meetup
---
