// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qbusiness

import (
	"bytes"
	"fmt"
	"io"
	"sync"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream"
	"github.com/aws/aws-sdk-go/private/protocol/eventstream/eventstreamapi"
	"github.com/aws/aws-sdk-go/private/protocol/rest"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchDeleteDocument = "BatchDeleteDocument"

// BatchDeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteDocument for more information on using the BatchDeleteDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteDocumentRequest method.
//	req, resp := client.BatchDeleteDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument
func (c *QBusiness) BatchDeleteDocumentRequest(input *BatchDeleteDocumentInput) (req *request.Request, output *BatchDeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/documents/delete",
	}

	if input == nil {
		input = &BatchDeleteDocumentInput{}
	}

	output = &BatchDeleteDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteDocument API operation for QBusiness.
//
// Asynchronously deletes one or more documents added using the BatchPutDocument
// API from an Amazon Q Business index.
//
// You can see the progress of the deletion, and any error messages related
// to the process, by using CloudWatch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation BatchDeleteDocument for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchDeleteDocument
func (c *QBusiness) BatchDeleteDocument(input *BatchDeleteDocumentInput) (*BatchDeleteDocumentOutput, error) {
	req, out := c.BatchDeleteDocumentRequest(input)
	return out, req.Send()
}

// BatchDeleteDocumentWithContext is the same as BatchDeleteDocument with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) BatchDeleteDocumentWithContext(ctx aws.Context, input *BatchDeleteDocumentInput, opts ...request.Option) (*BatchDeleteDocumentOutput, error) {
	req, out := c.BatchDeleteDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutDocument = "BatchPutDocument"

// BatchPutDocumentRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutDocument for more information on using the BatchPutDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchPutDocumentRequest method.
//	req, resp := client.BatchPutDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument
func (c *QBusiness) BatchPutDocumentRequest(input *BatchPutDocumentInput) (req *request.Request, output *BatchPutDocumentOutput) {
	op := &request.Operation{
		Name:       opBatchPutDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/documents",
	}

	if input == nil {
		input = &BatchPutDocumentInput{}
	}

	output = &BatchPutDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutDocument API operation for QBusiness.
//
// Adds one or more documents to an Amazon Q Business index.
//
// You use this API to:
//
//   - ingest your structured and unstructured documents and documents stored
//     in an Amazon S3 bucket into an Amazon Q Business index.
//
//   - add custom attributes to documents in an Amazon Q Business index.
//
//   - attach an access control list to the documents added to an Amazon Q
//     Business index.
//
// You can see the progress of the deletion, and any error messages related
// to the process, by using CloudWatch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation BatchPutDocument for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/BatchPutDocument
func (c *QBusiness) BatchPutDocument(input *BatchPutDocumentInput) (*BatchPutDocumentOutput, error) {
	req, out := c.BatchPutDocumentRequest(input)
	return out, req.Send()
}

// BatchPutDocumentWithContext is the same as BatchPutDocument with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) BatchPutDocumentWithContext(ctx aws.Context, input *BatchPutDocumentInput, opts ...request.Option) (*BatchPutDocumentOutput, error) {
	req, out := c.BatchPutDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opChat = "Chat"

// ChatRequest generates a "aws/request.Request" representing the
// client's request for the Chat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Chat for more information on using the Chat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ChatRequest method.
//	req, resp := client.ChatRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/Chat
func (c *QBusiness) ChatRequest(input *ChatInput) (req *request.Request, output *ChatOutput) {
	op := &request.Operation{
		Name:       opChat,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/conversations",
	}

	if input == nil {
		input = &ChatInput{}
	}

	output = &ChatOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.UnmarshalMeta.PushBack(
		protocol.RequireHTTPMinProtocol{Major: 2}.Handler,
	)

	es := NewChatEventStream()
	output.eventStream = es

	req.Handlers.Sign.PushFront(es.setupInputPipe)
	req.Handlers.UnmarshalError.PushBackNamed(request.NamedHandler{
		Name: "InputPipeCloser",
		Fn: func(r *request.Request) {
			err := es.closeInputPipe()
			if err != nil {
				r.Error = awserr.New(eventstreamapi.InputWriterCloseErrorCode, err.Error(), r.Error)
			}
		},
	})
	req.Handlers.Build.PushBack(request.WithSetRequestHeaders(map[string]string{
		"Content-Type":         "application/vnd.amazon.eventstream",
		"X-Amz-Content-Sha256": "STREAMING-AWS4-HMAC-SHA256-EVENTS",
	}))
	req.Handlers.Build.Swap(restjson.BuildHandler.Name, rest.BuildHandler)
	eventstreamapi.ApplyHTTPTransportFixes(req)
	req.Handlers.Send.Swap(client.LogHTTPRequestHandler.Name, client.LogHTTPRequestHeaderHandler)
	req.Handlers.Unmarshal.PushBack(es.runInputStream)

	req.Handlers.Send.Swap(client.LogHTTPResponseHandler.Name, client.LogHTTPResponseHeaderHandler)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, rest.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBack(es.runOutputStream)
	req.Handlers.Unmarshal.PushBack(es.runOnStreamPartClose)
	return
}

// Chat API operation for QBusiness.
//
// Starts or continues a streaming Amazon Q Business conversation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation Chat for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - LicenseNotFoundException
//     You don't have permissions to perform the action because your license is
//     inactive. Ask your admin to activate your license and try again after your
//     licence is active.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/Chat
func (c *QBusiness) Chat(input *ChatInput) (*ChatOutput, error) {
	req, out := c.ChatRequest(input)
	return out, req.Send()
}

// ChatWithContext is the same as Chat with the addition of
// the ability to pass a context and additional request options.
//
// See Chat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ChatWithContext(ctx aws.Context, input *ChatInput, opts ...request.Option) (*ChatOutput, error) {
	req, out := c.ChatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

var _ awserr.Error
var _ time.Time

// ChatEventStream provides the event stream handling for the Chat.
//
// For testing and mocking the event stream this type should be initialized via
// the NewChatEventStream constructor function. Using the functional options
// to pass in nested mock behavior.
type ChatEventStream struct {

	// Writer is the EventStream writer for the ChatInputStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Writer.
	//
	// Must not be nil.
	Writer ChatInputStreamWriter

	inputWriter io.WriteCloser

	// Reader is the EventStream reader for the ChatOutputStream
	// events. This value is automatically set by the SDK when the API call is made
	// Use this member when unit testing your code with the SDK to mock out the
	// EventStream Reader.
	//
	// Must not be nil.
	Reader ChatOutputStreamReader

	outputReader io.ReadCloser

	done      chan struct{}
	closeOnce sync.Once
	err       *eventstreamapi.OnceError
}

// NewChatEventStream initializes an ChatEventStream.
// This function should only be used for testing and mocking the ChatEventStream
// stream within your application.
//
// The Writer member must be set before writing events to the stream.
//
// The Reader member must be set before reading events from the stream.
//
//	es := NewChatEventStream(func(o *ChatEventStream){
//	    es.Writer = myMockStreamWriter
//	    es.Reader = myMockStreamReader
//	})
func NewChatEventStream(opts ...func(*ChatEventStream)) *ChatEventStream {
	es := &ChatEventStream{
		done: make(chan struct{}),
		err:  eventstreamapi.NewOnceError(),
	}

	for _, fn := range opts {
		fn(es)
	}

	return es
}

func (es *ChatEventStream) runOnStreamPartClose(r *request.Request) {
	if es.done == nil {
		return
	}
	go es.waitStreamPartClose()

}

func (es *ChatEventStream) waitStreamPartClose() {
	var inputErrCh <-chan struct{}
	if v, ok := es.Writer.(interface{ ErrorSet() <-chan struct{} }); ok {
		inputErrCh = v.ErrorSet()
	}
	var outputErrCh <-chan struct{}
	if v, ok := es.Reader.(interface{ ErrorSet() <-chan struct{} }); ok {
		outputErrCh = v.ErrorSet()
	}
	var outputClosedCh <-chan struct{}
	if v, ok := es.Reader.(interface{ Closed() <-chan struct{} }); ok {
		outputClosedCh = v.Closed()
	}

	select {
	case <-es.done:
	case <-inputErrCh:
		es.err.SetError(es.Writer.Err())
		es.Close()
	case <-outputErrCh:
		es.err.SetError(es.Reader.Err())
		es.Close()
	case <-outputClosedCh:
		if err := es.Reader.Err(); err != nil {
			es.err.SetError(es.Reader.Err())
		}
		es.Close()
	}
}

func (es *ChatEventStream) setupInputPipe(r *request.Request) {
	inputReader, inputWriter := io.Pipe()
	r.SetStreamingBody(inputReader)
	es.inputWriter = inputWriter
}

// Closes the input-pipe writer
func (es *ChatEventStream) closeInputPipe() error {
	if es.inputWriter != nil {
		return es.inputWriter.Close()
	}
	return nil
}

// Send writes the event to the stream blocking until the event is written.
// Returns an error if the event was not written.
//
// These events are:
//
//   - AttachmentInputEvent
//   - AuthChallengeResponseEvent
//   - ConfigurationEvent
//   - EndOfInputEvent
//   - TextInputEvent
func (es *ChatEventStream) Send(ctx aws.Context, event ChatInputStreamEvent) error {
	return es.Writer.Send(ctx, event)
}

func (es *ChatEventStream) runInputStream(r *request.Request) {
	var opts []func(*eventstream.Encoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.EncodeWithLogger(r.Config.Logger))
	}
	var encoder eventstreamapi.Encoder = eventstream.NewEncoder(es.inputWriter, opts...)

	var closer aws.MultiCloser
	sigSeed, err := v4.GetSignedRequestSignature(r.HTTPRequest)
	if err != nil {
		r.Error = awserr.New(request.ErrCodeSerialization,
			"unable to get initial request's signature", err)
		return
	}
	signer := eventstreamapi.NewSignEncoder(
		v4.NewStreamSigner(r.ClientInfo.SigningRegion, r.ClientInfo.SigningName,
			sigSeed, r.Config.Credentials),
		encoder,
	)
	encoder = signer
	closer = append(closer, signer)
	closer = append(closer, es.inputWriter)

	eventWriter := eventstreamapi.NewEventWriter(encoder,
		protocol.HandlerPayloadMarshal{
			Marshalers: r.Handlers.BuildStream,
		},
		eventTypeForChatInputStreamEvent,
	)

	es.Writer = &writeChatInputStream{
		StreamWriter: eventstreamapi.NewStreamWriter(eventWriter, closer),
	}
}

// Events returns a channel to read events from.
//
// These events are:
//
//   - ActionReviewEvent
//   - AuthChallengeRequestEvent
//   - FailedAttachmentEvent
//   - MetadataEvent
//   - TextOutputEvent
//   - ChatOutputStreamUnknownEvent
func (es *ChatEventStream) Events() <-chan ChatOutputStreamEvent {
	return es.Reader.Events()
}

func (es *ChatEventStream) runOutputStream(r *request.Request) {
	var opts []func(*eventstream.Decoder)
	if r.Config.Logger != nil && r.Config.LogLevel.Matches(aws.LogDebugWithEventStreamBody) {
		opts = append(opts, eventstream.DecodeWithLogger(r.Config.Logger))
	}

	unmarshalerForEvent := unmarshalerForChatOutputStreamEvent{
		metadata: protocol.ResponseMetadata{
			StatusCode: r.HTTPResponse.StatusCode,
			RequestID:  r.RequestID,
		},
	}.UnmarshalerForEventName

	decoder := eventstream.NewDecoder(r.HTTPResponse.Body, opts...)
	eventReader := eventstreamapi.NewEventReader(decoder,
		protocol.HandlerPayloadUnmarshal{
			Unmarshalers: r.Handlers.UnmarshalStream,
		},
		unmarshalerForEvent,
	)

	es.outputReader = r.HTTPResponse.Body
	es.Reader = newReadChatOutputStream(eventReader)
}

// Close closes the stream. This will also cause the stream to be closed.
// Close must be called when done using the stream API. Not calling Close
// may result in resource leaks.
//
// Will close the underlying EventStream writer, and no more events can be
// sent.
//
// You can use the closing of the Reader's Events channel to terminate your
// application's read from the API's stream.
func (es *ChatEventStream) Close() (err error) {
	es.closeOnce.Do(es.safeClose)
	return es.Err()
}

func (es *ChatEventStream) safeClose() {
	if es.done != nil {
		close(es.done)
	}

	t := time.NewTicker(time.Second)
	defer t.Stop()
	writeCloseDone := make(chan error)
	go func() {
		if err := es.Writer.Close(); err != nil {
			es.err.SetError(err)
		}
		close(writeCloseDone)
	}()
	select {
	case <-t.C:
	case <-writeCloseDone:
	}
	if err := es.closeInputPipe(); err != nil {
		es.err.SetError(err)
	}

	es.Reader.Close()
	if es.outputReader != nil {
		es.outputReader.Close()
	}
}

// Err returns any error that occurred while reading or writing EventStream
// Events from the service API's response. Returns nil if there were no errors.
func (es *ChatEventStream) Err() error {
	if err := es.err.Err(); err != nil {
		return err
	}
	if err := es.Writer.Err(); err != nil {
		return err
	}
	if err := es.Reader.Err(); err != nil {
		return err
	}

	return nil
}

const opChatSync = "ChatSync"

// ChatSyncRequest generates a "aws/request.Request" representing the
// client's request for the ChatSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ChatSync for more information on using the ChatSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ChatSyncRequest method.
//	req, resp := client.ChatSyncRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync
func (c *QBusiness) ChatSyncRequest(input *ChatSyncInput) (req *request.Request, output *ChatSyncOutput) {
	op := &request.Operation{
		Name:       opChatSync,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/conversations?sync",
	}

	if input == nil {
		input = &ChatSyncInput{}
	}

	output = &ChatSyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ChatSync API operation for QBusiness.
//
// Starts or continues a non-streaming Amazon Q Business conversation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ChatSync for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - LicenseNotFoundException
//     You don't have permissions to perform the action because your license is
//     inactive. Ask your admin to activate your license and try again after your
//     licence is active.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ChatSync
func (c *QBusiness) ChatSync(input *ChatSyncInput) (*ChatSyncOutput, error) {
	req, out := c.ChatSyncRequest(input)
	return out, req.Send()
}

// ChatSyncWithContext is the same as ChatSync with the addition of
// the ability to pass a context and additional request options.
//
// See ChatSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ChatSyncWithContext(ctx aws.Context, input *ChatSyncInput, opts ...request.Option) (*ChatSyncOutput, error) {
	req, out := c.ChatSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationRequest method.
//	req, resp := client.CreateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication
func (c *QBusiness) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for QBusiness.
//
// Creates an Amazon Q Business application.
//
// There are new tiers for Amazon Q Business. Not all features in Amazon Q Business
// Pro are also available in Amazon Q Business Lite. For information on what's
// included in Amazon Q Business Lite and what's included in Amazon Q Business
// Pro, see Amazon Q Business tiers (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/what-is.html#tiers).
// You must use the Amazon Q Business console to assign subscription tiers to
// users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateApplication
func (c *QBusiness) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIndex = "CreateIndex"

// CreateIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIndex for more information on using the CreateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIndexRequest method.
//	req, resp := client.CreateIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex
func (c *QBusiness) CreateIndexRequest(input *CreateIndexInput) (req *request.Request, output *CreateIndexOutput) {
	op := &request.Operation{
		Name:       opCreateIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/indices",
	}

	if input == nil {
		input = &CreateIndexInput{}
	}

	output = &CreateIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIndex API operation for QBusiness.
//
// Creates an Amazon Q Business index.
//
// To determine if index creation has completed, check the Status field returned
// from a call to DescribeIndex. The Status field is set to ACTIVE when the
// index is ready to use.
//
// Once the index is active, you can index your documents using the BatchPutDocument
// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_BatchPutDocument.html)
// API or the CreateDataSource (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_CreateDataSource.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation CreateIndex for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateIndex
func (c *QBusiness) CreateIndex(input *CreateIndexInput) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	return out, req.Send()
}

// CreateIndexWithContext is the same as CreateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) CreateIndexWithContext(ctx aws.Context, input *CreateIndexInput, opts ...request.Option) (*CreateIndexOutput, error) {
	req, out := c.CreateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlugin = "CreatePlugin"

// CreatePluginRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlugin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlugin for more information on using the CreatePlugin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePluginRequest method.
//	req, resp := client.CreatePluginRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin
func (c *QBusiness) CreatePluginRequest(input *CreatePluginInput) (req *request.Request, output *CreatePluginOutput) {
	op := &request.Operation{
		Name:       opCreatePlugin,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/plugins",
	}

	if input == nil {
		input = &CreatePluginInput{}
	}

	output = &CreatePluginOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlugin API operation for QBusiness.
//
// Creates an Amazon Q Business plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation CreatePlugin for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreatePlugin
func (c *QBusiness) CreatePlugin(input *CreatePluginInput) (*CreatePluginOutput, error) {
	req, out := c.CreatePluginRequest(input)
	return out, req.Send()
}

// CreatePluginWithContext is the same as CreatePlugin with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlugin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) CreatePluginWithContext(ctx aws.Context, input *CreatePluginInput, opts ...request.Option) (*CreatePluginOutput, error) {
	req, out := c.CreatePluginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRetriever = "CreateRetriever"

// CreateRetrieverRequest generates a "aws/request.Request" representing the
// client's request for the CreateRetriever operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRetriever for more information on using the CreateRetriever
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRetrieverRequest method.
//	req, resp := client.CreateRetrieverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever
func (c *QBusiness) CreateRetrieverRequest(input *CreateRetrieverInput) (req *request.Request, output *CreateRetrieverOutput) {
	op := &request.Operation{
		Name:       opCreateRetriever,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/retrievers",
	}

	if input == nil {
		input = &CreateRetrieverInput{}
	}

	output = &CreateRetrieverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRetriever API operation for QBusiness.
//
// Adds a retriever to your Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation CreateRetriever for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateRetriever
func (c *QBusiness) CreateRetriever(input *CreateRetrieverInput) (*CreateRetrieverOutput, error) {
	req, out := c.CreateRetrieverRequest(input)
	return out, req.Send()
}

// CreateRetrieverWithContext is the same as CreateRetriever with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRetriever for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) CreateRetrieverWithContext(ctx aws.Context, input *CreateRetrieverInput, opts ...request.Option) (*CreateRetrieverOutput, error) {
	req, out := c.CreateRetrieverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserRequest method.
//	req, resp := client.CreateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser
func (c *QBusiness) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/users",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateUser API operation for QBusiness.
//
// Creates a universally unique identifier (UUID) mapped to a list of local
// user ids within an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateUser
func (c *QBusiness) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebExperience = "CreateWebExperience"

// CreateWebExperienceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebExperience operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWebExperience for more information on using the CreateWebExperience
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWebExperienceRequest method.
//	req, resp := client.CreateWebExperienceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience
func (c *QBusiness) CreateWebExperienceRequest(input *CreateWebExperienceInput) (req *request.Request, output *CreateWebExperienceOutput) {
	op := &request.Operation{
		Name:       opCreateWebExperience,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/experiences",
	}

	if input == nil {
		input = &CreateWebExperienceInput{}
	}

	output = &CreateWebExperienceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWebExperience API operation for QBusiness.
//
// Creates an Amazon Q Business web experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation CreateWebExperience for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/CreateWebExperience
func (c *QBusiness) CreateWebExperience(input *CreateWebExperienceInput) (*CreateWebExperienceOutput, error) {
	req, out := c.CreateWebExperienceRequest(input)
	return out, req.Send()
}

// CreateWebExperienceWithContext is the same as CreateWebExperience with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebExperience for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) CreateWebExperienceWithContext(ctx aws.Context, input *CreateWebExperienceInput, opts ...request.Option) (*CreateWebExperienceOutput, error) {
	req, out := c.CreateWebExperienceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationRequest method.
//	req, resp := client.DeleteApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication
func (c *QBusiness) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for QBusiness.
//
// Deletes an Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteApplication
func (c *QBusiness) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChatControlsConfiguration = "DeleteChatControlsConfiguration"

// DeleteChatControlsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChatControlsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChatControlsConfiguration for more information on using the DeleteChatControlsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChatControlsConfigurationRequest method.
//	req, resp := client.DeleteChatControlsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration
func (c *QBusiness) DeleteChatControlsConfigurationRequest(input *DeleteChatControlsConfigurationInput) (req *request.Request, output *DeleteChatControlsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteChatControlsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/chatcontrols",
	}

	if input == nil {
		input = &DeleteChatControlsConfigurationInput{}
	}

	output = &DeleteChatControlsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChatControlsConfiguration API operation for QBusiness.
//
// Deletes chat controls configured for an existing Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteChatControlsConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteChatControlsConfiguration
func (c *QBusiness) DeleteChatControlsConfiguration(input *DeleteChatControlsConfigurationInput) (*DeleteChatControlsConfigurationOutput, error) {
	req, out := c.DeleteChatControlsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteChatControlsConfigurationWithContext is the same as DeleteChatControlsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChatControlsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteChatControlsConfigurationWithContext(ctx aws.Context, input *DeleteChatControlsConfigurationInput, opts ...request.Option) (*DeleteChatControlsConfigurationOutput, error) {
	req, out := c.DeleteChatControlsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConversation = "DeleteConversation"

// DeleteConversationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConversation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConversation for more information on using the DeleteConversation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConversationRequest method.
//	req, resp := client.DeleteConversationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation
func (c *QBusiness) DeleteConversationRequest(input *DeleteConversationInput) (req *request.Request, output *DeleteConversationOutput) {
	op := &request.Operation{
		Name:       opDeleteConversation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/conversations/{conversationId}",
	}

	if input == nil {
		input = &DeleteConversationInput{}
	}

	output = &DeleteConversationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConversation API operation for QBusiness.
//
// Deletes an Amazon Q Business web experience conversation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteConversation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - LicenseNotFoundException
//     You don't have permissions to perform the action because your license is
//     inactive. Ask your admin to activate your license and try again after your
//     licence is active.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteConversation
func (c *QBusiness) DeleteConversation(input *DeleteConversationInput) (*DeleteConversationOutput, error) {
	req, out := c.DeleteConversationRequest(input)
	return out, req.Send()
}

// DeleteConversationWithContext is the same as DeleteConversation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConversation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteConversationWithContext(ctx aws.Context, input *DeleteConversationInput, opts ...request.Option) (*DeleteConversationOutput, error) {
	req, out := c.DeleteConversationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource
func (c *QBusiness) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataSource API operation for QBusiness.
//
// Deletes an Amazon Q Business data source connector. While the data source
// is being deleted, the Status field returned by a call to the DescribeDataSource
// API is set to DELETING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteDataSource
func (c *QBusiness) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGroupRequest method.
//	req, resp := client.DeleteGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup
func (c *QBusiness) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/groups/{groupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for QBusiness.
//
// Deletes a group so that all users and sub groups that belong to the group
// can no longer access documents only available to that group. For example,
// after deleting the group "Summer Interns", all interns who belonged to that
// group no longer see intern-only documents in their chat results.
//
// If you want to delete, update, or replace users or sub groups of a group,
// you need to use the PutGroup operation. For example, if a user in the group
// "Engineering" leaves the engineering team and another user takes their place,
// you provide an updated list of users or sub groups that belong to the "Engineering"
// group when calling PutGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteGroup
func (c *QBusiness) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIndex = "DeleteIndex"

// DeleteIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIndex for more information on using the DeleteIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIndexRequest method.
//	req, resp := client.DeleteIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex
func (c *QBusiness) DeleteIndexRequest(input *DeleteIndexInput) (req *request.Request, output *DeleteIndexOutput) {
	op := &request.Operation{
		Name:       opDeleteIndex,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}",
	}

	if input == nil {
		input = &DeleteIndexInput{}
	}

	output = &DeleteIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIndex API operation for QBusiness.
//
// Deletes an Amazon Q Business index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteIndex for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteIndex
func (c *QBusiness) DeleteIndex(input *DeleteIndexInput) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	return out, req.Send()
}

// DeleteIndexWithContext is the same as DeleteIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteIndexWithContext(ctx aws.Context, input *DeleteIndexInput, opts ...request.Option) (*DeleteIndexOutput, error) {
	req, out := c.DeleteIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlugin = "DeletePlugin"

// DeletePluginRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlugin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlugin for more information on using the DeletePlugin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePluginRequest method.
//	req, resp := client.DeletePluginRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin
func (c *QBusiness) DeletePluginRequest(input *DeletePluginInput) (req *request.Request, output *DeletePluginOutput) {
	op := &request.Operation{
		Name:       opDeletePlugin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/plugins/{pluginId}",
	}

	if input == nil {
		input = &DeletePluginInput{}
	}

	output = &DeletePluginOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlugin API operation for QBusiness.
//
// Deletes an Amazon Q Business plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeletePlugin for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeletePlugin
func (c *QBusiness) DeletePlugin(input *DeletePluginInput) (*DeletePluginOutput, error) {
	req, out := c.DeletePluginRequest(input)
	return out, req.Send()
}

// DeletePluginWithContext is the same as DeletePlugin with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlugin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeletePluginWithContext(ctx aws.Context, input *DeletePluginInput, opts ...request.Option) (*DeletePluginOutput, error) {
	req, out := c.DeletePluginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRetriever = "DeleteRetriever"

// DeleteRetrieverRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRetriever operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRetriever for more information on using the DeleteRetriever
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRetrieverRequest method.
//	req, resp := client.DeleteRetrieverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever
func (c *QBusiness) DeleteRetrieverRequest(input *DeleteRetrieverInput) (req *request.Request, output *DeleteRetrieverOutput) {
	op := &request.Operation{
		Name:       opDeleteRetriever,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/retrievers/{retrieverId}",
	}

	if input == nil {
		input = &DeleteRetrieverInput{}
	}

	output = &DeleteRetrieverOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRetriever API operation for QBusiness.
//
// Deletes the retriever used by an Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteRetriever for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteRetriever
func (c *QBusiness) DeleteRetriever(input *DeleteRetrieverInput) (*DeleteRetrieverOutput, error) {
	req, out := c.DeleteRetrieverRequest(input)
	return out, req.Send()
}

// DeleteRetrieverWithContext is the same as DeleteRetriever with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRetriever for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteRetrieverWithContext(ctx aws.Context, input *DeleteRetrieverInput, opts ...request.Option) (*DeleteRetrieverOutput, error) {
	req, out := c.DeleteRetrieverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserRequest method.
//	req, resp := client.DeleteUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser
func (c *QBusiness) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/users/{userId}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for QBusiness.
//
// Deletes a user by email id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteUser
func (c *QBusiness) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebExperience = "DeleteWebExperience"

// DeleteWebExperienceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebExperience operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWebExperience for more information on using the DeleteWebExperience
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWebExperienceRequest method.
//	req, resp := client.DeleteWebExperienceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience
func (c *QBusiness) DeleteWebExperienceRequest(input *DeleteWebExperienceInput) (req *request.Request, output *DeleteWebExperienceOutput) {
	op := &request.Operation{
		Name:       opDeleteWebExperience,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{applicationId}/experiences/{webExperienceId}",
	}

	if input == nil {
		input = &DeleteWebExperienceInput{}
	}

	output = &DeleteWebExperienceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWebExperience API operation for QBusiness.
//
// Deletes an Amazon Q Business web experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation DeleteWebExperience for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/DeleteWebExperience
func (c *QBusiness) DeleteWebExperience(input *DeleteWebExperienceInput) (*DeleteWebExperienceOutput, error) {
	req, out := c.DeleteWebExperienceRequest(input)
	return out, req.Send()
}

// DeleteWebExperienceWithContext is the same as DeleteWebExperience with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebExperience for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) DeleteWebExperienceWithContext(ctx aws.Context, input *DeleteWebExperienceInput, opts ...request.Option) (*DeleteWebExperienceOutput, error) {
	req, out := c.DeleteWebExperienceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationRequest method.
//	req, resp := client.GetApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication
func (c *QBusiness) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for QBusiness.
//
// Gets information about an existing Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetApplication
func (c *QBusiness) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChatControlsConfiguration = "GetChatControlsConfiguration"

// GetChatControlsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetChatControlsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChatControlsConfiguration for more information on using the GetChatControlsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChatControlsConfigurationRequest method.
//	req, resp := client.GetChatControlsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration
func (c *QBusiness) GetChatControlsConfigurationRequest(input *GetChatControlsConfigurationInput) (req *request.Request, output *GetChatControlsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetChatControlsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/chatcontrols",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetChatControlsConfigurationInput{}
	}

	output = &GetChatControlsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChatControlsConfiguration API operation for QBusiness.
//
// Gets information about an chat controls configured for an existing Amazon
// Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetChatControlsConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetChatControlsConfiguration
func (c *QBusiness) GetChatControlsConfiguration(input *GetChatControlsConfigurationInput) (*GetChatControlsConfigurationOutput, error) {
	req, out := c.GetChatControlsConfigurationRequest(input)
	return out, req.Send()
}

// GetChatControlsConfigurationWithContext is the same as GetChatControlsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetChatControlsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetChatControlsConfigurationWithContext(ctx aws.Context, input *GetChatControlsConfigurationInput, opts ...request.Option) (*GetChatControlsConfigurationOutput, error) {
	req, out := c.GetChatControlsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetChatControlsConfigurationPages iterates over the pages of a GetChatControlsConfiguration operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetChatControlsConfiguration method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetChatControlsConfiguration operation.
//	pageNum := 0
//	err := client.GetChatControlsConfigurationPages(params,
//	    func(page *qbusiness.GetChatControlsConfigurationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) GetChatControlsConfigurationPages(input *GetChatControlsConfigurationInput, fn func(*GetChatControlsConfigurationOutput, bool) bool) error {
	return c.GetChatControlsConfigurationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetChatControlsConfigurationPagesWithContext same as GetChatControlsConfigurationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetChatControlsConfigurationPagesWithContext(ctx aws.Context, input *GetChatControlsConfigurationInput, fn func(*GetChatControlsConfigurationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetChatControlsConfigurationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetChatControlsConfigurationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetChatControlsConfigurationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSourceRequest method.
//	req, resp := client.GetDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource
func (c *QBusiness) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for QBusiness.
//
// Gets information about an existing Amazon Q Business data source connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetDataSource
func (c *QBusiness) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGroupRequest method.
//	req, resp := client.GetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup
func (c *QBusiness) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/groups/{groupName}",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for QBusiness.
//
// Describes a group by group name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetGroup
func (c *QBusiness) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIndex = "GetIndex"

// GetIndexRequest generates a "aws/request.Request" representing the
// client's request for the GetIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIndex for more information on using the GetIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIndexRequest method.
//	req, resp := client.GetIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex
func (c *QBusiness) GetIndexRequest(input *GetIndexInput) (req *request.Request, output *GetIndexOutput) {
	op := &request.Operation{
		Name:       opGetIndex,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}",
	}

	if input == nil {
		input = &GetIndexInput{}
	}

	output = &GetIndexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIndex API operation for QBusiness.
//
// Gets information about an existing Amazon Q Business index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetIndex for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetIndex
func (c *QBusiness) GetIndex(input *GetIndexInput) (*GetIndexOutput, error) {
	req, out := c.GetIndexRequest(input)
	return out, req.Send()
}

// GetIndexWithContext is the same as GetIndex with the addition of
// the ability to pass a context and additional request options.
//
// See GetIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetIndexWithContext(ctx aws.Context, input *GetIndexInput, opts ...request.Option) (*GetIndexOutput, error) {
	req, out := c.GetIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPlugin = "GetPlugin"

// GetPluginRequest generates a "aws/request.Request" representing the
// client's request for the GetPlugin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlugin for more information on using the GetPlugin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPluginRequest method.
//	req, resp := client.GetPluginRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin
func (c *QBusiness) GetPluginRequest(input *GetPluginInput) (req *request.Request, output *GetPluginOutput) {
	op := &request.Operation{
		Name:       opGetPlugin,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/plugins/{pluginId}",
	}

	if input == nil {
		input = &GetPluginInput{}
	}

	output = &GetPluginOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlugin API operation for QBusiness.
//
// Gets information about an existing Amazon Q Business plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetPlugin for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetPlugin
func (c *QBusiness) GetPlugin(input *GetPluginInput) (*GetPluginOutput, error) {
	req, out := c.GetPluginRequest(input)
	return out, req.Send()
}

// GetPluginWithContext is the same as GetPlugin with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlugin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetPluginWithContext(ctx aws.Context, input *GetPluginInput, opts ...request.Option) (*GetPluginOutput, error) {
	req, out := c.GetPluginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRetriever = "GetRetriever"

// GetRetrieverRequest generates a "aws/request.Request" representing the
// client's request for the GetRetriever operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRetriever for more information on using the GetRetriever
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRetrieverRequest method.
//	req, resp := client.GetRetrieverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever
func (c *QBusiness) GetRetrieverRequest(input *GetRetrieverInput) (req *request.Request, output *GetRetrieverOutput) {
	op := &request.Operation{
		Name:       opGetRetriever,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/retrievers/{retrieverId}",
	}

	if input == nil {
		input = &GetRetrieverInput{}
	}

	output = &GetRetrieverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRetriever API operation for QBusiness.
//
// Gets information about an existing retriever used by an Amazon Q Business
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetRetriever for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetRetriever
func (c *QBusiness) GetRetriever(input *GetRetrieverInput) (*GetRetrieverOutput, error) {
	req, out := c.GetRetrieverRequest(input)
	return out, req.Send()
}

// GetRetrieverWithContext is the same as GetRetriever with the addition of
// the ability to pass a context and additional request options.
//
// See GetRetriever for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetRetrieverWithContext(ctx aws.Context, input *GetRetrieverInput, opts ...request.Option) (*GetRetrieverOutput, error) {
	req, out := c.GetRetrieverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUser for more information on using the GetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserRequest method.
//	req, resp := client.GetUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser
func (c *QBusiness) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/users/{userId}",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUser API operation for QBusiness.
//
// Describes the universally unique identifier (UUID) associated with a local
// user in a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetUser
func (c *QBusiness) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	return out, req.Send()
}

// GetUserWithContext is the same as GetUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetUserWithContext(ctx aws.Context, input *GetUserInput, opts ...request.Option) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebExperience = "GetWebExperience"

// GetWebExperienceRequest generates a "aws/request.Request" representing the
// client's request for the GetWebExperience operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWebExperience for more information on using the GetWebExperience
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWebExperienceRequest method.
//	req, resp := client.GetWebExperienceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience
func (c *QBusiness) GetWebExperienceRequest(input *GetWebExperienceInput) (req *request.Request, output *GetWebExperienceOutput) {
	op := &request.Operation{
		Name:       opGetWebExperience,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/experiences/{webExperienceId}",
	}

	if input == nil {
		input = &GetWebExperienceInput{}
	}

	output = &GetWebExperienceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebExperience API operation for QBusiness.
//
// Gets information about an existing Amazon Q Business web experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation GetWebExperience for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/GetWebExperience
func (c *QBusiness) GetWebExperience(input *GetWebExperienceInput) (*GetWebExperienceOutput, error) {
	req, out := c.GetWebExperienceRequest(input)
	return out, req.Send()
}

// GetWebExperienceWithContext is the same as GetWebExperience with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebExperience for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) GetWebExperienceWithContext(ctx aws.Context, input *GetWebExperienceInput, opts ...request.Option) (*GetWebExperienceOutput, error) {
	req, out := c.GetWebExperienceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications
func (c *QBusiness) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for QBusiness.
//
// Lists Amazon Q Business applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListApplications
func (c *QBusiness) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *qbusiness.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConversations = "ListConversations"

// ListConversationsRequest generates a "aws/request.Request" representing the
// client's request for the ListConversations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConversations for more information on using the ListConversations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConversationsRequest method.
//	req, resp := client.ListConversationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations
func (c *QBusiness) ListConversationsRequest(input *ListConversationsInput) (req *request.Request, output *ListConversationsOutput) {
	op := &request.Operation{
		Name:       opListConversations,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/conversations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConversationsInput{}
	}

	output = &ListConversationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConversations API operation for QBusiness.
//
// Lists one or more Amazon Q Business conversations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListConversations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - LicenseNotFoundException
//     You don't have permissions to perform the action because your license is
//     inactive. Ask your admin to activate your license and try again after your
//     licence is active.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListConversations
func (c *QBusiness) ListConversations(input *ListConversationsInput) (*ListConversationsOutput, error) {
	req, out := c.ListConversationsRequest(input)
	return out, req.Send()
}

// ListConversationsWithContext is the same as ListConversations with the addition of
// the ability to pass a context and additional request options.
//
// See ListConversations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListConversationsWithContext(ctx aws.Context, input *ListConversationsInput, opts ...request.Option) (*ListConversationsOutput, error) {
	req, out := c.ListConversationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConversationsPages iterates over the pages of a ListConversations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConversations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConversations operation.
//	pageNum := 0
//	err := client.ListConversationsPages(params,
//	    func(page *qbusiness.ListConversationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListConversationsPages(input *ListConversationsInput, fn func(*ListConversationsOutput, bool) bool) error {
	return c.ListConversationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConversationsPagesWithContext same as ListConversationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListConversationsPagesWithContext(ctx aws.Context, input *ListConversationsInput, fn func(*ListConversationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConversationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConversationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConversationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSourceSyncJobs = "ListDataSourceSyncJobs"

// ListDataSourceSyncJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSourceSyncJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSourceSyncJobs for more information on using the ListDataSourceSyncJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourceSyncJobsRequest method.
//	req, resp := client.ListDataSourceSyncJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs
func (c *QBusiness) ListDataSourceSyncJobsRequest(input *ListDataSourceSyncJobsInput) (req *request.Request, output *ListDataSourceSyncJobsOutput) {
	op := &request.Operation{
		Name:       opListDataSourceSyncJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/syncjobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourceSyncJobsInput{}
	}

	output = &ListDataSourceSyncJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSourceSyncJobs API operation for QBusiness.
//
// Get information about an Amazon Q Business data source connector synchronization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListDataSourceSyncJobs for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSourceSyncJobs
func (c *QBusiness) ListDataSourceSyncJobs(input *ListDataSourceSyncJobsInput) (*ListDataSourceSyncJobsOutput, error) {
	req, out := c.ListDataSourceSyncJobsRequest(input)
	return out, req.Send()
}

// ListDataSourceSyncJobsWithContext is the same as ListDataSourceSyncJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSourceSyncJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListDataSourceSyncJobsWithContext(ctx aws.Context, input *ListDataSourceSyncJobsInput, opts ...request.Option) (*ListDataSourceSyncJobsOutput, error) {
	req, out := c.ListDataSourceSyncJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourceSyncJobsPages iterates over the pages of a ListDataSourceSyncJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSourceSyncJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSourceSyncJobs operation.
//	pageNum := 0
//	err := client.ListDataSourceSyncJobsPages(params,
//	    func(page *qbusiness.ListDataSourceSyncJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListDataSourceSyncJobsPages(input *ListDataSourceSyncJobsInput, fn func(*ListDataSourceSyncJobsOutput, bool) bool) error {
	return c.ListDataSourceSyncJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourceSyncJobsPagesWithContext same as ListDataSourceSyncJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListDataSourceSyncJobsPagesWithContext(ctx aws.Context, input *ListDataSourceSyncJobsInput, fn func(*ListDataSourceSyncJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourceSyncJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourceSyncJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourceSyncJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources
func (c *QBusiness) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for QBusiness.
//
// Lists the Amazon Q Business data source connectors that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDataSources
func (c *QBusiness) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSources operation.
//	pageNum := 0
//	err := client.ListDataSourcesPages(params,
//	    func(page *qbusiness.ListDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDocuments = "ListDocuments"

// ListDocumentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocuments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocuments for more information on using the ListDocuments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDocumentsRequest method.
//	req, resp := client.ListDocumentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments
func (c *QBusiness) ListDocumentsRequest(input *ListDocumentsInput) (req *request.Request, output *ListDocumentsOutput) {
	op := &request.Operation{
		Name:       opListDocuments,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/index/{indexId}/documents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentsInput{}
	}

	output = &ListDocumentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocuments API operation for QBusiness.
//
// A list of documents attached to an index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListDocuments for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListDocuments
func (c *QBusiness) ListDocuments(input *ListDocumentsInput) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	return out, req.Send()
}

// ListDocumentsWithContext is the same as ListDocuments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocuments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListDocumentsWithContext(ctx aws.Context, input *ListDocumentsInput, opts ...request.Option) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentsPages iterates over the pages of a ListDocuments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocuments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDocuments operation.
//	pageNum := 0
//	err := client.ListDocumentsPages(params,
//	    func(page *qbusiness.ListDocumentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListDocumentsPages(input *ListDocumentsInput, fn func(*ListDocumentsOutput, bool) bool) error {
	return c.ListDocumentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentsPagesWithContext same as ListDocumentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListDocumentsPagesWithContext(ctx aws.Context, input *ListDocumentsInput, fn func(*ListDocumentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGroupsRequest method.
//	req, resp := client.ListGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups
func (c *QBusiness) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for QBusiness.
//
// Provides a list of groups that are mapped to users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListGroups
func (c *QBusiness) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGroups operation.
//	pageNum := 0
//	err := client.ListGroupsPages(params,
//	    func(page *qbusiness.ListGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIndices = "ListIndices"

// ListIndicesRequest generates a "aws/request.Request" representing the
// client's request for the ListIndices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIndices for more information on using the ListIndices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIndicesRequest method.
//	req, resp := client.ListIndicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices
func (c *QBusiness) ListIndicesRequest(input *ListIndicesInput) (req *request.Request, output *ListIndicesOutput) {
	op := &request.Operation{
		Name:       opListIndices,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/indices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIndicesInput{}
	}

	output = &ListIndicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIndices API operation for QBusiness.
//
// Lists the Amazon Q Business indices you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListIndices for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListIndices
func (c *QBusiness) ListIndices(input *ListIndicesInput) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	return out, req.Send()
}

// ListIndicesWithContext is the same as ListIndices with the addition of
// the ability to pass a context and additional request options.
//
// See ListIndices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListIndicesWithContext(ctx aws.Context, input *ListIndicesInput, opts ...request.Option) (*ListIndicesOutput, error) {
	req, out := c.ListIndicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIndicesPages iterates over the pages of a ListIndices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIndices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIndices operation.
//	pageNum := 0
//	err := client.ListIndicesPages(params,
//	    func(page *qbusiness.ListIndicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListIndicesPages(input *ListIndicesInput, fn func(*ListIndicesOutput, bool) bool) error {
	return c.ListIndicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIndicesPagesWithContext same as ListIndicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListIndicesPagesWithContext(ctx aws.Context, input *ListIndicesInput, fn func(*ListIndicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIndicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIndicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIndicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMessages = "ListMessages"

// ListMessagesRequest generates a "aws/request.Request" representing the
// client's request for the ListMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMessages for more information on using the ListMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMessagesRequest method.
//	req, resp := client.ListMessagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages
func (c *QBusiness) ListMessagesRequest(input *ListMessagesInput) (req *request.Request, output *ListMessagesOutput) {
	op := &request.Operation{
		Name:       opListMessages,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/conversations/{conversationId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMessagesInput{}
	}

	output = &ListMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMessages API operation for QBusiness.
//
// Gets a list of messages associated with an Amazon Q Business web experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListMessages for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - LicenseNotFoundException
//     You don't have permissions to perform the action because your license is
//     inactive. Ask your admin to activate your license and try again after your
//     licence is active.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListMessages
func (c *QBusiness) ListMessages(input *ListMessagesInput) (*ListMessagesOutput, error) {
	req, out := c.ListMessagesRequest(input)
	return out, req.Send()
}

// ListMessagesWithContext is the same as ListMessages with the addition of
// the ability to pass a context and additional request options.
//
// See ListMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListMessagesWithContext(ctx aws.Context, input *ListMessagesInput, opts ...request.Option) (*ListMessagesOutput, error) {
	req, out := c.ListMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMessagesPages iterates over the pages of a ListMessages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMessages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMessages operation.
//	pageNum := 0
//	err := client.ListMessagesPages(params,
//	    func(page *qbusiness.ListMessagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListMessagesPages(input *ListMessagesInput, fn func(*ListMessagesOutput, bool) bool) error {
	return c.ListMessagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMessagesPagesWithContext same as ListMessagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListMessagesPagesWithContext(ctx aws.Context, input *ListMessagesInput, fn func(*ListMessagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMessagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMessagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMessagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlugins = "ListPlugins"

// ListPluginsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlugins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlugins for more information on using the ListPlugins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPluginsRequest method.
//	req, resp := client.ListPluginsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins
func (c *QBusiness) ListPluginsRequest(input *ListPluginsInput) (req *request.Request, output *ListPluginsOutput) {
	op := &request.Operation{
		Name:       opListPlugins,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/plugins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPluginsInput{}
	}

	output = &ListPluginsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlugins API operation for QBusiness.
//
// Lists configured Amazon Q Business plugins.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListPlugins for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListPlugins
func (c *QBusiness) ListPlugins(input *ListPluginsInput) (*ListPluginsOutput, error) {
	req, out := c.ListPluginsRequest(input)
	return out, req.Send()
}

// ListPluginsWithContext is the same as ListPlugins with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlugins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListPluginsWithContext(ctx aws.Context, input *ListPluginsInput, opts ...request.Option) (*ListPluginsOutput, error) {
	req, out := c.ListPluginsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPluginsPages iterates over the pages of a ListPlugins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlugins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPlugins operation.
//	pageNum := 0
//	err := client.ListPluginsPages(params,
//	    func(page *qbusiness.ListPluginsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListPluginsPages(input *ListPluginsInput, fn func(*ListPluginsOutput, bool) bool) error {
	return c.ListPluginsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPluginsPagesWithContext same as ListPluginsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListPluginsPagesWithContext(ctx aws.Context, input *ListPluginsInput, fn func(*ListPluginsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPluginsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPluginsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPluginsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRetrievers = "ListRetrievers"

// ListRetrieversRequest generates a "aws/request.Request" representing the
// client's request for the ListRetrievers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRetrievers for more information on using the ListRetrievers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRetrieversRequest method.
//	req, resp := client.ListRetrieversRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers
func (c *QBusiness) ListRetrieversRequest(input *ListRetrieversInput) (req *request.Request, output *ListRetrieversOutput) {
	op := &request.Operation{
		Name:       opListRetrievers,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/retrievers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRetrieversInput{}
	}

	output = &ListRetrieversOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRetrievers API operation for QBusiness.
//
// Lists the retriever used by an Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListRetrievers for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListRetrievers
func (c *QBusiness) ListRetrievers(input *ListRetrieversInput) (*ListRetrieversOutput, error) {
	req, out := c.ListRetrieversRequest(input)
	return out, req.Send()
}

// ListRetrieversWithContext is the same as ListRetrievers with the addition of
// the ability to pass a context and additional request options.
//
// See ListRetrievers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListRetrieversWithContext(ctx aws.Context, input *ListRetrieversInput, opts ...request.Option) (*ListRetrieversOutput, error) {
	req, out := c.ListRetrieversRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRetrieversPages iterates over the pages of a ListRetrievers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRetrievers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRetrievers operation.
//	pageNum := 0
//	err := client.ListRetrieversPages(params,
//	    func(page *qbusiness.ListRetrieversOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListRetrieversPages(input *ListRetrieversInput, fn func(*ListRetrieversOutput, bool) bool) error {
	return c.ListRetrieversPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRetrieversPagesWithContext same as ListRetrieversPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListRetrieversPagesWithContext(ctx aws.Context, input *ListRetrieversInput, fn func(*ListRetrieversOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRetrieversInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRetrieversRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRetrieversOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource
func (c *QBusiness) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/tags/{resourceARN}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for QBusiness.
//
// Gets a list of tags associated with a specified resource. Amazon Q Business
// applications and data sources can have tags associated with them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListTagsForResource
func (c *QBusiness) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWebExperiences = "ListWebExperiences"

// ListWebExperiencesRequest generates a "aws/request.Request" representing the
// client's request for the ListWebExperiences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebExperiences for more information on using the ListWebExperiences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWebExperiencesRequest method.
//	req, resp := client.ListWebExperiencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences
func (c *QBusiness) ListWebExperiencesRequest(input *ListWebExperiencesInput) (req *request.Request, output *ListWebExperiencesOutput) {
	op := &request.Operation{
		Name:       opListWebExperiences,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{applicationId}/experiences",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWebExperiencesInput{}
	}

	output = &ListWebExperiencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebExperiences API operation for QBusiness.
//
// Lists one or more Amazon Q Business Web Experiences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation ListWebExperiences for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/ListWebExperiences
func (c *QBusiness) ListWebExperiences(input *ListWebExperiencesInput) (*ListWebExperiencesOutput, error) {
	req, out := c.ListWebExperiencesRequest(input)
	return out, req.Send()
}

// ListWebExperiencesWithContext is the same as ListWebExperiences with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebExperiences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListWebExperiencesWithContext(ctx aws.Context, input *ListWebExperiencesInput, opts ...request.Option) (*ListWebExperiencesOutput, error) {
	req, out := c.ListWebExperiencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWebExperiencesPages iterates over the pages of a ListWebExperiences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWebExperiences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWebExperiences operation.
//	pageNum := 0
//	err := client.ListWebExperiencesPages(params,
//	    func(page *qbusiness.ListWebExperiencesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QBusiness) ListWebExperiencesPages(input *ListWebExperiencesInput, fn func(*ListWebExperiencesOutput, bool) bool) error {
	return c.ListWebExperiencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWebExperiencesPagesWithContext same as ListWebExperiencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) ListWebExperiencesPagesWithContext(ctx aws.Context, input *ListWebExperiencesInput, fn func(*ListWebExperiencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWebExperiencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWebExperiencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWebExperiencesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutFeedback = "PutFeedback"

// PutFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the PutFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFeedback for more information on using the PutFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutFeedbackRequest method.
//	req, resp := client.PutFeedbackRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback
func (c *QBusiness) PutFeedbackRequest(input *PutFeedbackInput) (req *request.Request, output *PutFeedbackOutput) {
	op := &request.Operation{
		Name:       opPutFeedback,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/conversations/{conversationId}/messages/{messageId}/feedback",
	}

	if input == nil {
		input = &PutFeedbackInput{}
	}

	output = &PutFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutFeedback API operation for QBusiness.
//
// Enables your end user to provide feedback on their Amazon Q Business generated
// chat responses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation PutFeedback for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutFeedback
func (c *QBusiness) PutFeedback(input *PutFeedbackInput) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	return out, req.Send()
}

// PutFeedbackWithContext is the same as PutFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See PutFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) PutFeedbackWithContext(ctx aws.Context, input *PutFeedbackInput, opts ...request.Option) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutGroup = "PutGroup"

// PutGroupRequest generates a "aws/request.Request" representing the
// client's request for the PutGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutGroup for more information on using the PutGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutGroupRequest method.
//	req, resp := client.PutGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup
func (c *QBusiness) PutGroupRequest(input *PutGroupInput) (req *request.Request, output *PutGroupOutput) {
	op := &request.Operation{
		Name:       opPutGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/groups",
	}

	if input == nil {
		input = &PutGroupInput{}
	}

	output = &PutGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutGroup API operation for QBusiness.
//
// Create, or updates, a mapping of users—who have access to a document—to
// groups.
//
// You can also map sub groups to groups. For example, the group "Company Intellectual
// Property Teams" includes sub groups "Research" and "Engineering". These sub
// groups include their own list of users or people who work in these teams.
// Only users who work in research and engineering, and therefore belong in
// the intellectual property group, can see top-secret company documents in
// their Amazon Q Business chat results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation PutGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/PutGroup
func (c *QBusiness) PutGroup(input *PutGroupInput) (*PutGroupOutput, error) {
	req, out := c.PutGroupRequest(input)
	return out, req.Send()
}

// PutGroupWithContext is the same as PutGroup with the addition of
// the ability to pass a context and additional request options.
//
// See PutGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) PutGroupWithContext(ctx aws.Context, input *PutGroupInput, opts ...request.Option) (*PutGroupOutput, error) {
	req, out := c.PutGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDataSourceSyncJob = "StartDataSourceSyncJob"

// StartDataSourceSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDataSourceSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataSourceSyncJob for more information on using the StartDataSourceSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDataSourceSyncJobRequest method.
//	req, resp := client.StartDataSourceSyncJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob
func (c *QBusiness) StartDataSourceSyncJobRequest(input *StartDataSourceSyncJobInput) (req *request.Request, output *StartDataSourceSyncJobOutput) {
	op := &request.Operation{
		Name:       opStartDataSourceSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/startsync",
	}

	if input == nil {
		input = &StartDataSourceSyncJobInput{}
	}

	output = &StartDataSourceSyncJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataSourceSyncJob API operation for QBusiness.
//
// Starts a data source connector synchronization job. If a synchronization
// job is already in progress, Amazon Q Business returns a ConflictException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation StartDataSourceSyncJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StartDataSourceSyncJob
func (c *QBusiness) StartDataSourceSyncJob(input *StartDataSourceSyncJobInput) (*StartDataSourceSyncJobOutput, error) {
	req, out := c.StartDataSourceSyncJobRequest(input)
	return out, req.Send()
}

// StartDataSourceSyncJobWithContext is the same as StartDataSourceSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataSourceSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) StartDataSourceSyncJobWithContext(ctx aws.Context, input *StartDataSourceSyncJobInput, opts ...request.Option) (*StartDataSourceSyncJobOutput, error) {
	req, out := c.StartDataSourceSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDataSourceSyncJob = "StopDataSourceSyncJob"

// StopDataSourceSyncJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDataSourceSyncJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDataSourceSyncJob for more information on using the StopDataSourceSyncJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopDataSourceSyncJobRequest method.
//	req, resp := client.StopDataSourceSyncJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob
func (c *QBusiness) StopDataSourceSyncJobRequest(input *StopDataSourceSyncJobInput) (req *request.Request, output *StopDataSourceSyncJobOutput) {
	op := &request.Operation{
		Name:       opStopDataSourceSyncJob,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/stopsync",
	}

	if input == nil {
		input = &StopDataSourceSyncJobInput{}
	}

	output = &StopDataSourceSyncJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopDataSourceSyncJob API operation for QBusiness.
//
// Stops an Amazon Q Business data source connector synchronization job already
// in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation StopDataSourceSyncJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/StopDataSourceSyncJob
func (c *QBusiness) StopDataSourceSyncJob(input *StopDataSourceSyncJobInput) (*StopDataSourceSyncJobOutput, error) {
	req, out := c.StopDataSourceSyncJobRequest(input)
	return out, req.Send()
}

// StopDataSourceSyncJobWithContext is the same as StopDataSourceSyncJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDataSourceSyncJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) StopDataSourceSyncJobWithContext(ctx aws.Context, input *StopDataSourceSyncJobInput, opts ...request.Option) (*StopDataSourceSyncJobOutput, error) {
	req, out := c.StopDataSourceSyncJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource
func (c *QBusiness) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/tags/{resourceARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for QBusiness.
//
// Adds the specified tag to the specified Amazon Q Business application or
// data source resource. If the tag already exists, the existing value is replaced
// with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/TagResource
func (c *QBusiness) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource
func (c *QBusiness) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/tags/{resourceARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for QBusiness.
//
// Removes a tag from an Amazon Q Business application or a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UntagResource
func (c *QBusiness) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationRequest method.
//	req, resp := client.UpdateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication
func (c *QBusiness) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for QBusiness.
//
// Updates an existing Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateApplication
func (c *QBusiness) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChatControlsConfiguration = "UpdateChatControlsConfiguration"

// UpdateChatControlsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChatControlsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChatControlsConfiguration for more information on using the UpdateChatControlsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChatControlsConfigurationRequest method.
//	req, resp := client.UpdateChatControlsConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration
func (c *QBusiness) UpdateChatControlsConfigurationRequest(input *UpdateChatControlsConfigurationInput) (req *request.Request, output *UpdateChatControlsConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateChatControlsConfiguration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{applicationId}/chatcontrols",
	}

	if input == nil {
		input = &UpdateChatControlsConfigurationInput{}
	}

	output = &UpdateChatControlsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateChatControlsConfiguration API operation for QBusiness.
//
// Updates an set of chat controls configured for an existing Amazon Q Business
// application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateChatControlsConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateChatControlsConfiguration
func (c *QBusiness) UpdateChatControlsConfiguration(input *UpdateChatControlsConfigurationInput) (*UpdateChatControlsConfigurationOutput, error) {
	req, out := c.UpdateChatControlsConfigurationRequest(input)
	return out, req.Send()
}

// UpdateChatControlsConfigurationWithContext is the same as UpdateChatControlsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChatControlsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateChatControlsConfigurationWithContext(ctx aws.Context, input *UpdateChatControlsConfigurationInput, opts ...request.Option) (*UpdateChatControlsConfigurationOutput, error) {
	req, out := c.UpdateChatControlsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource
func (c *QBusiness) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataSource API operation for QBusiness.
//
// Updates an existing Amazon Q Business data source connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateDataSource
func (c *QBusiness) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIndex = "UpdateIndex"

// UpdateIndexRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIndex for more information on using the UpdateIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateIndexRequest method.
//	req, resp := client.UpdateIndexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex
func (c *QBusiness) UpdateIndexRequest(input *UpdateIndexInput) (req *request.Request, output *UpdateIndexOutput) {
	op := &request.Operation{
		Name:       opUpdateIndex,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/indices/{indexId}",
	}

	if input == nil {
		input = &UpdateIndexInput{}
	}

	output = &UpdateIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIndex API operation for QBusiness.
//
// Updates an Amazon Q Business index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateIndex for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateIndex
func (c *QBusiness) UpdateIndex(input *UpdateIndexInput) (*UpdateIndexOutput, error) {
	req, out := c.UpdateIndexRequest(input)
	return out, req.Send()
}

// UpdateIndexWithContext is the same as UpdateIndex with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateIndexWithContext(ctx aws.Context, input *UpdateIndexInput, opts ...request.Option) (*UpdateIndexOutput, error) {
	req, out := c.UpdateIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePlugin = "UpdatePlugin"

// UpdatePluginRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePlugin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePlugin for more information on using the UpdatePlugin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePluginRequest method.
//	req, resp := client.UpdatePluginRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin
func (c *QBusiness) UpdatePluginRequest(input *UpdatePluginInput) (req *request.Request, output *UpdatePluginOutput) {
	op := &request.Operation{
		Name:       opUpdatePlugin,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/plugins/{pluginId}",
	}

	if input == nil {
		input = &UpdatePluginInput{}
	}

	output = &UpdatePluginOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePlugin API operation for QBusiness.
//
// Updates an Amazon Q Business plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdatePlugin for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdatePlugin
func (c *QBusiness) UpdatePlugin(input *UpdatePluginInput) (*UpdatePluginOutput, error) {
	req, out := c.UpdatePluginRequest(input)
	return out, req.Send()
}

// UpdatePluginWithContext is the same as UpdatePlugin with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePlugin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdatePluginWithContext(ctx aws.Context, input *UpdatePluginInput, opts ...request.Option) (*UpdatePluginOutput, error) {
	req, out := c.UpdatePluginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRetriever = "UpdateRetriever"

// UpdateRetrieverRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRetriever operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRetriever for more information on using the UpdateRetriever
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRetrieverRequest method.
//	req, resp := client.UpdateRetrieverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever
func (c *QBusiness) UpdateRetrieverRequest(input *UpdateRetrieverInput) (req *request.Request, output *UpdateRetrieverOutput) {
	op := &request.Operation{
		Name:       opUpdateRetriever,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/retrievers/{retrieverId}",
	}

	if input == nil {
		input = &UpdateRetrieverInput{}
	}

	output = &UpdateRetrieverOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRetriever API operation for QBusiness.
//
// Updates the retriever used for your Amazon Q Business application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateRetriever for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateRetriever
func (c *QBusiness) UpdateRetriever(input *UpdateRetrieverInput) (*UpdateRetrieverOutput, error) {
	req, out := c.UpdateRetrieverRequest(input)
	return out, req.Send()
}

// UpdateRetrieverWithContext is the same as UpdateRetriever with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRetriever for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateRetrieverWithContext(ctx aws.Context, input *UpdateRetrieverInput, opts ...request.Option) (*UpdateRetrieverOutput, error) {
	req, out := c.UpdateRetrieverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRequest method.
//	req, resp := client.UpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser
func (c *QBusiness) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/users/{userId}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for QBusiness.
//
// Updates a information associated with a user id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Q Business service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateUser
func (c *QBusiness) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWebExperience = "UpdateWebExperience"

// UpdateWebExperienceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWebExperience operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWebExperience for more information on using the UpdateWebExperience
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWebExperienceRequest method.
//	req, resp := client.UpdateWebExperienceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience
func (c *QBusiness) UpdateWebExperienceRequest(input *UpdateWebExperienceInput) (req *request.Request, output *UpdateWebExperienceOutput) {
	op := &request.Operation{
		Name:       opUpdateWebExperience,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/experiences/{webExperienceId}",
	}

	if input == nil {
		input = &UpdateWebExperienceInput{}
	}

	output = &UpdateWebExperienceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWebExperience API operation for QBusiness.
//
// Updates an Amazon Q Business web experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QBusiness's
// API operation UpdateWebExperience for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you want to use doesn’t exist. Make sure you have provided
//     the correct resource and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Q Business
//     service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
//     for help.
//
//   - ConflictException
//     You are trying to perform an action that conflicts with the current status
//     of your resource. Fix any inconsistences with your resources and try again.
//
//   - ThrottlingException
//     The request was denied due to throttling. Reduce the number of requests and
//     try again.
//
//   - ValidationException
//     The input doesn't meet the constraints set by the Amazon Q Business service.
//     Provide the correct input and try again.
//
//   - AccessDeniedException
//     You don't have access to perform this action. Make sure you have the required
//     permission policies and user accounts and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qbusiness-2023-11-27/UpdateWebExperience
func (c *QBusiness) UpdateWebExperience(input *UpdateWebExperienceInput) (*UpdateWebExperienceOutput, error) {
	req, out := c.UpdateWebExperienceRequest(input)
	return out, req.Send()
}

// UpdateWebExperienceWithContext is the same as UpdateWebExperience with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWebExperience for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QBusiness) UpdateWebExperienceWithContext(ctx aws.Context, input *UpdateWebExperienceInput, opts ...request.Option) (*UpdateWebExperienceOutput, error) {
	req, out := c.UpdateWebExperienceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains details about the OpenAPI schema for a custom plugin. For more information,
// see custom plugin OpenAPI schemas (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/custom-plugin.html#plugins-api-schema).
// You can either include the schema directly in the payload field or you can
// upload it to an S3 bucket and specify the S3 bucket location in the s3 field.
type APISchema struct {
	_ struct{} `type:"structure"`

	// The JSON or YAML-formatted payload defining the OpenAPI schema for a custom
	// plugin.
	//
	// Payload is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by APISchema's
	// String and GoString methods.
	Payload *string `locationName:"payload" type:"string" sensitive:"true"`

	// Contains details about the S3 object containing the OpenAPI schema for a
	// custom plugin. The schema could be in either JSON or YAML format.
	S3 *S3 `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APISchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APISchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *APISchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "APISchema"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayload sets the Payload field's value.
func (s *APISchema) SetPayload(v string) *APISchema {
	s.Payload = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *APISchema) SetS3(v *S3) *APISchema {
	s.S3 = v
	return s
}

// Used to configure access permissions for a document.
type AccessConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of AccessControlList objects.
	//
	// AccessControls is a required field
	AccessControls []*AccessControl `locationName:"accessControls" type:"list" required:"true"`

	// Describes the member relation within the AccessControlList object.
	MemberRelation *string `locationName:"memberRelation" type:"string" enum:"MemberRelation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessConfiguration"}
	if s.AccessControls == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessControls"))
	}
	if s.AccessControls != nil {
		for i, v := range s.AccessControls {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControls", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControls sets the AccessControls field's value.
func (s *AccessConfiguration) SetAccessControls(v []*AccessControl) *AccessConfiguration {
	s.AccessControls = v
	return s
}

// SetMemberRelation sets the MemberRelation field's value.
func (s *AccessConfiguration) SetMemberRelation(v string) *AccessConfiguration {
	s.MemberRelation = &v
	return s
}

// A list of principals. Each principal can be either a USER or a GROUP and
// can be designated document access permissions of either ALLOW or DENY.
type AccessControl struct {
	_ struct{} `type:"structure"`

	// Describes the member relation within a principal list.
	MemberRelation *string `locationName:"memberRelation" type:"string" enum:"MemberRelation"`

	// Contains a list of principals, where a principal can be either a USER or
	// a GROUP. Each principal can be have the following type of document access:
	// ALLOW or DENY.
	//
	// Principals is a required field
	Principals []*Principal `locationName:"principals" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControl) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControl) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControl"}
	if s.Principals == nil {
		invalidParams.Add(request.NewErrParamRequired("Principals"))
	}
	if s.Principals != nil {
		for i, v := range s.Principals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Principals", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberRelation sets the MemberRelation field's value.
func (s *AccessControl) SetMemberRelation(v string) *AccessControl {
	s.MemberRelation = &v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *AccessControl) SetPrincipals(v []*Principal) *AccessControl {
	s.Principals = v
	return s
}

// You don't have access to perform this action. Make sure you have the required
// permission policies and user accounts and try again.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An output event that Amazon Q Business returns to an user who wants to perform
// a plugin action during a non-streaming chat conversation. It contains information
// about the selected action with a list of possible user input fields, some
// pre-populated by Amazon Q Business.
type ActionReview struct {
	_ struct{} `type:"structure"`

	// Field values that an end user needs to provide to Amazon Q Business for Amazon
	// Q Business to perform the requested plugin action.
	Payload map[string]*ActionReviewPayloadField `locationName:"payload" type:"map"`

	// A string used to retain information about the hierarchical contexts within
	// an action review payload.
	PayloadFieldNameSeparator *string `locationName:"payloadFieldNameSeparator" min:"1" type:"string"`

	// The identifier of the plugin associated with the action review.
	PluginId *string `locationName:"pluginId" min:"36" type:"string"`

	// The type of plugin.
	PluginType *string `locationName:"pluginType" type:"string" enum:"PluginType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReview) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *ActionReview) SetPayload(v map[string]*ActionReviewPayloadField) *ActionReview {
	s.Payload = v
	return s
}

// SetPayloadFieldNameSeparator sets the PayloadFieldNameSeparator field's value.
func (s *ActionReview) SetPayloadFieldNameSeparator(v string) *ActionReview {
	s.PayloadFieldNameSeparator = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *ActionReview) SetPluginId(v string) *ActionReview {
	s.PluginId = &v
	return s
}

// SetPluginType sets the PluginType field's value.
func (s *ActionReview) SetPluginType(v string) *ActionReview {
	s.PluginType = &v
	return s
}

// An output event that Amazon Q Business returns to an user who wants to perform
// a plugin action during a streaming chat conversation. It contains information
// about the selected action with a list of possible user input fields, some
// pre-populated by Amazon Q Business.
type ActionReviewEvent struct {
	_ struct{} `type:"structure"`

	// The identifier of the conversation with which the action review event is
	// associated.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// Field values that an end user needs to provide to Amazon Q Business for Amazon
	// Q Business to perform the requested plugin action.
	Payload map[string]*ActionReviewPayloadField `locationName:"payload" type:"map"`

	// A string used to retain information about the hierarchical contexts within
	// an action review event payload.
	PayloadFieldNameSeparator *string `locationName:"payloadFieldNameSeparator" min:"1" type:"string"`

	// The identifier of the plugin associated with the action review event.
	PluginId *string `locationName:"pluginId" min:"36" type:"string"`

	// The type of plugin.
	PluginType *string `locationName:"pluginType" type:"string" enum:"PluginType"`

	// The identifier of an Amazon Q Business AI generated associated with the action
	// review event.
	SystemMessageId *string `locationName:"systemMessageId" min:"36" type:"string"`

	// The identifier of the conversation with which the plugin action is associated.
	UserMessageId *string `locationName:"userMessageId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReviewEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReviewEvent) GoString() string {
	return s.String()
}

// SetConversationId sets the ConversationId field's value.
func (s *ActionReviewEvent) SetConversationId(v string) *ActionReviewEvent {
	s.ConversationId = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *ActionReviewEvent) SetPayload(v map[string]*ActionReviewPayloadField) *ActionReviewEvent {
	s.Payload = v
	return s
}

// SetPayloadFieldNameSeparator sets the PayloadFieldNameSeparator field's value.
func (s *ActionReviewEvent) SetPayloadFieldNameSeparator(v string) *ActionReviewEvent {
	s.PayloadFieldNameSeparator = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *ActionReviewEvent) SetPluginId(v string) *ActionReviewEvent {
	s.PluginId = &v
	return s
}

// SetPluginType sets the PluginType field's value.
func (s *ActionReviewEvent) SetPluginType(v string) *ActionReviewEvent {
	s.PluginType = &v
	return s
}

// SetSystemMessageId sets the SystemMessageId field's value.
func (s *ActionReviewEvent) SetSystemMessageId(v string) *ActionReviewEvent {
	s.SystemMessageId = &v
	return s
}

// SetUserMessageId sets the UserMessageId field's value.
func (s *ActionReviewEvent) SetUserMessageId(v string) *ActionReviewEvent {
	s.UserMessageId = &v
	return s
}

// The ActionReviewEvent is and event in the ChatOutputStream group of events.
func (s *ActionReviewEvent) eventChatOutputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ActionReviewEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ActionReviewEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ActionReviewEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// A user input field in an plugin action review payload.
type ActionReviewPayloadField struct {
	_ struct{} `type:"structure"`

	// The expected data format for the action review input field value. For example,
	// in PTO request, from and to would be of datetime allowed format.
	AllowedFormat *string `locationName:"allowedFormat" min:"1" type:"string"`

	// Information about the field values that an end user can use to provide to
	// Amazon Q Business for Amazon Q Business to perform the requested plugin action.
	AllowedValues []*ActionReviewPayloadFieldAllowedValue `locationName:"allowedValues" type:"list"`

	// The field level description of each action review input field. This could
	// be an explanation of the field. In the Amazon Q Business web experience,
	// these descriptions could be used to display as tool tips to help users understand
	// the field.
	DisplayDescription *string `locationName:"displayDescription" min:"1" type:"string"`

	// The name of the field.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The display order of fields in a payload.
	DisplayOrder *int64 `locationName:"displayOrder" type:"integer"`

	// Information about whether the field is required.
	Required *bool `locationName:"required" type:"boolean"`

	// The type of field.
	Type *string `locationName:"type" type:"string" enum:"ActionPayloadFieldType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReviewPayloadField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReviewPayloadField) GoString() string {
	return s.String()
}

// SetAllowedFormat sets the AllowedFormat field's value.
func (s *ActionReviewPayloadField) SetAllowedFormat(v string) *ActionReviewPayloadField {
	s.AllowedFormat = &v
	return s
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *ActionReviewPayloadField) SetAllowedValues(v []*ActionReviewPayloadFieldAllowedValue) *ActionReviewPayloadField {
	s.AllowedValues = v
	return s
}

// SetDisplayDescription sets the DisplayDescription field's value.
func (s *ActionReviewPayloadField) SetDisplayDescription(v string) *ActionReviewPayloadField {
	s.DisplayDescription = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ActionReviewPayloadField) SetDisplayName(v string) *ActionReviewPayloadField {
	s.DisplayName = &v
	return s
}

// SetDisplayOrder sets the DisplayOrder field's value.
func (s *ActionReviewPayloadField) SetDisplayOrder(v int64) *ActionReviewPayloadField {
	s.DisplayOrder = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ActionReviewPayloadField) SetRequired(v bool) *ActionReviewPayloadField {
	s.Required = &v
	return s
}

// SetType sets the Type field's value.
func (s *ActionReviewPayloadField) SetType(v string) *ActionReviewPayloadField {
	s.Type = &v
	return s
}

// Information about the field values that an end user can use to provide to
// Amazon Q Business for Amazon Q Business to perform the requested plugin action.
type ActionReviewPayloadFieldAllowedValue struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReviewPayloadFieldAllowedValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionReviewPayloadFieldAllowedValue) GoString() string {
	return s.String()
}

// Summary information for an Amazon Q Business application.
type Application struct {
	_ struct{} `type:"structure"`

	// The identifier for the Amazon Q Business application.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// The Unix timestamp when the Amazon Q Business application was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The name of the Amazon Q Business application.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The status of the Amazon Q Business application. The application is ready
	// to use when the status is ACTIVE.
	Status *string `locationName:"status" type:"string" enum:"ApplicationStatus"`

	// The Unix timestamp when the Amazon Q Business application was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Application) SetApplicationId(v string) *Application {
	s.ApplicationId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Application) SetCreatedAt(v time.Time) *Application {
	s.CreatedAt = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Application) SetDisplayName(v string) *Application {
	s.DisplayName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Application) SetStatus(v string) *Application {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Application) SetUpdatedAt(v time.Time) *Application {
	s.UpdatedAt = &v
	return s
}

// Configuration information about the file upload during chat feature for your
// application.
type AppliedAttachmentsConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about whether file upload during chat functionality is activated
	// for your application.
	AttachmentsControlMode *string `locationName:"attachmentsControlMode" type:"string" enum:"AttachmentsControlMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedAttachmentsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedAttachmentsConfiguration) GoString() string {
	return s.String()
}

// SetAttachmentsControlMode sets the AttachmentsControlMode field's value.
func (s *AppliedAttachmentsConfiguration) SetAttachmentsControlMode(v string) *AppliedAttachmentsConfiguration {
	s.AttachmentsControlMode = &v
	return s
}

// The creator mode specific admin controls configured for an Amazon Q Business
// application. Determines whether an end user can generate LLM-only responses
// when they use the web experience.
//
// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html)
// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
type AppliedCreatorModeConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about whether creator mode is enabled or disabled for an Amazon
	// Q Business application.
	//
	// CreatorModeControl is a required field
	CreatorModeControl *string `locationName:"creatorModeControl" type:"string" required:"true" enum:"CreatorModeControl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedCreatorModeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppliedCreatorModeConfiguration) GoString() string {
	return s.String()
}

// SetCreatorModeControl sets the CreatorModeControl field's value.
func (s *AppliedCreatorModeConfiguration) SetCreatorModeControl(v string) *AppliedCreatorModeConfiguration {
	s.CreatorModeControl = &v
	return s
}

// A file input event activated by a end user request to upload files into their
// web experience chat.
type AttachmentInputEvent struct {
	_ struct{} `type:"structure"`

	// A file directly uploaded into a web experience chat.
	Attachment *AttachmentInput_ `locationName:"attachment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentInputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentInputEvent) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *AttachmentInputEvent) SetAttachment(v *AttachmentInput_) *AttachmentInputEvent {
	s.Attachment = v
	return s
}

// The AttachmentInputEvent is and event in the ChatInputStream group of events.
func (s *AttachmentInputEvent) eventChatInputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AttachmentInputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AttachmentInputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AttachmentInputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// A file directly uploaded into a web experience chat.
type AttachmentInput_ struct {
	_ struct{} `type:"structure"`

	// The data contained within the uploaded file.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `locationName:"data" type:"blob" required:"true"`

	// The name of the file.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachmentInput_"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *AttachmentInput_) SetData(v []byte) *AttachmentInput_ {
	s.Data = v
	return s
}

// SetName sets the Name field's value.
func (s *AttachmentInput_) SetName(v string) *AttachmentInput_ {
	s.Name = &v
	return s
}

// The details of a file uploaded during chat.
type AttachmentOutput_ struct {
	_ struct{} `type:"structure"`

	// An error associated with a file uploaded during chat.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The name of a file uploaded during chat.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of a file uploaded during chat.
	Status *string `locationName:"status" type:"string" enum:"AttachmentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentOutput_) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *AttachmentOutput_) SetError(v *ErrorDetail) *AttachmentOutput_ {
	s.Error = v
	return s
}

// SetName sets the Name field's value.
func (s *AttachmentOutput_) SetName(v string) *AttachmentOutput_ {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AttachmentOutput_) SetStatus(v string) *AttachmentOutput_ {
	s.Status = &v
	return s
}

// Configuration information for the file upload during chat feature.
type AttachmentsConfiguration struct {
	_ struct{} `type:"structure"`

	// Status information about whether file upload functionality is activated or
	// deactivated for your end user.
	//
	// AttachmentsControlMode is a required field
	AttachmentsControlMode *string `locationName:"attachmentsControlMode" type:"string" required:"true" enum:"AttachmentsControlMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachmentsConfiguration"}
	if s.AttachmentsControlMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AttachmentsControlMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentsControlMode sets the AttachmentsControlMode field's value.
func (s *AttachmentsConfiguration) SetAttachmentsControlMode(v string) *AttachmentsConfiguration {
	s.AttachmentsControlMode = &v
	return s
}

// Enables filtering of responses based on document attributes or metadata fields.
type AttributeFilter struct {
	_ struct{} `type:"structure"`

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []*AttributeFilter `locationName:"andAllFilters" type:"list"`

	// Returns true when a document contains all the specified document attributes
	// or metadata fields. Supported for the following document attribute value
	// types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// stringListValue.
	ContainsAll *DocumentAttribute `locationName:"containsAll" type:"structure"`

	// Returns true when a document contains any of the specified document attributes
	// or metadata fields. Supported for the following document attribute value
	// types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue, longValue, stringListValue and stringValue.
	ContainsAny *DocumentAttribute `locationName:"containsAny" type:"structure"`

	// Performs an equals operation on two document attributes or metadata fields.
	// Supported for the following document attribute value types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue, longValue, stringListValue and stringValue.
	EqualsTo *DocumentAttribute `locationName:"equalsTo" type:"structure"`

	// Performs a greater than operation on two document attributes or metadata
	// fields. Supported for the following document attribute value types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	GreaterThan *DocumentAttribute `locationName:"greaterThan" type:"structure"`

	// Performs a greater or equals than operation on two document attributes or
	// metadata fields. Supported for the following document attribute value types
	// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	GreaterThanOrEquals *DocumentAttribute `locationName:"greaterThanOrEquals" type:"structure"`

	// Performs a less than operation on two document attributes or metadata fields.
	// Supported for the following document attribute value types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	LessThan *DocumentAttribute `locationName:"lessThan" type:"structure"`

	// Performs a less than or equals operation on two document attributes or metadata
	// fields.Supported for the following document attribute value type (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	LessThanOrEquals *DocumentAttribute `locationName:"lessThanOrEquals" type:"structure"`

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter `locationName:"notFilter" type:"structure"`

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []*AttributeFilter `locationName:"orAllFilters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeFilter"}
	if s.ContainsAll != nil {
		if err := s.ContainsAll.Validate(); err != nil {
			invalidParams.AddNested("ContainsAll", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainsAny != nil {
		if err := s.ContainsAny.Validate(); err != nil {
			invalidParams.AddNested("ContainsAny", err.(request.ErrInvalidParams))
		}
	}
	if s.EqualsTo != nil {
		if err := s.EqualsTo.Validate(); err != nil {
			invalidParams.AddNested("EqualsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEquals != nil {
		if err := s.GreaterThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThanOrEquals != nil {
		if err := s.LessThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.NotFilter != nil {
		if err := s.NotFilter.Validate(); err != nil {
			invalidParams.AddNested("NotFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.OrAllFilters != nil {
		for i, v := range s.OrAllFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAllFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndAllFilters sets the AndAllFilters field's value.
func (s *AttributeFilter) SetAndAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.AndAllFilters = v
	return s
}

// SetContainsAll sets the ContainsAll field's value.
func (s *AttributeFilter) SetContainsAll(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAll = v
	return s
}

// SetContainsAny sets the ContainsAny field's value.
func (s *AttributeFilter) SetContainsAny(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAny = v
	return s
}

// SetEqualsTo sets the EqualsTo field's value.
func (s *AttributeFilter) SetEqualsTo(v *DocumentAttribute) *AttributeFilter {
	s.EqualsTo = v
	return s
}

// SetGreaterThan sets the GreaterThan field's value.
func (s *AttributeFilter) SetGreaterThan(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThan = v
	return s
}

// SetGreaterThanOrEquals sets the GreaterThanOrEquals field's value.
func (s *AttributeFilter) SetGreaterThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThanOrEquals = v
	return s
}

// SetLessThan sets the LessThan field's value.
func (s *AttributeFilter) SetLessThan(v *DocumentAttribute) *AttributeFilter {
	s.LessThan = v
	return s
}

// SetLessThanOrEquals sets the LessThanOrEquals field's value.
func (s *AttributeFilter) SetLessThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.LessThanOrEquals = v
	return s
}

// SetNotFilter sets the NotFilter field's value.
func (s *AttributeFilter) SetNotFilter(v *AttributeFilter) *AttributeFilter {
	s.NotFilter = v
	return s
}

// SetOrAllFilters sets the OrAllFilters field's value.
func (s *AttributeFilter) SetOrAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.OrAllFilters = v
	return s
}

// A request made by Amazon Q Business to a third paty authentication server
// to authenticate a custom plugin user.
type AuthChallengeRequest struct {
	_ struct{} `type:"structure"`

	// The URL sent by Amazon Q Business to the third party authentication server
	// to authenticate a custom plugin user through an OAuth protocol.
	//
	// AuthorizationUrl is a required field
	AuthorizationUrl *string `locationName:"authorizationUrl" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeRequest) GoString() string {
	return s.String()
}

// SetAuthorizationUrl sets the AuthorizationUrl field's value.
func (s *AuthChallengeRequest) SetAuthorizationUrl(v string) *AuthChallengeRequest {
	s.AuthorizationUrl = &v
	return s
}

// An authentication verification event activated by an end user request to
// use a custom plugin.
type AuthChallengeRequestEvent struct {
	_ struct{} `type:"structure"`

	// The URL sent by Amazon Q Business to a third party authentication server
	// in response to an authentication verification event activated by an end user
	// request to use a custom plugin.
	//
	// AuthorizationUrl is a required field
	AuthorizationUrl *string `locationName:"authorizationUrl" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeRequestEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeRequestEvent) GoString() string {
	return s.String()
}

// SetAuthorizationUrl sets the AuthorizationUrl field's value.
func (s *AuthChallengeRequestEvent) SetAuthorizationUrl(v string) *AuthChallengeRequestEvent {
	s.AuthorizationUrl = &v
	return s
}

// The AuthChallengeRequestEvent is and event in the ChatOutputStream group of events.
func (s *AuthChallengeRequestEvent) eventChatOutputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AuthChallengeRequestEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AuthChallengeRequestEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AuthChallengeRequestEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Contains details of the authentication information received from a third
// party authentication server in response to an authentication challenge.
type AuthChallengeResponse struct {
	_ struct{} `type:"structure"`

	// The mapping of key-value pairs in an authentication challenge response.
	//
	// ResponseMap is a required field
	ResponseMap map[string]*string `locationName:"responseMap" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeResponse) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthChallengeResponse) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthChallengeResponse"}
	if s.ResponseMap == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponseMap"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResponseMap sets the ResponseMap field's value.
func (s *AuthChallengeResponse) SetResponseMap(v map[string]*string) *AuthChallengeResponse {
	s.ResponseMap = v
	return s
}

// An authentication verification event response by a third party authentication
// server to Amazon Q Business.
type AuthChallengeResponseEvent struct {
	_ struct{} `type:"structure"`

	// The mapping of key-value pairs in an authentication challenge response.
	//
	// ResponseMap is a required field
	ResponseMap map[string]*string `locationName:"responseMap" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeResponseEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthChallengeResponseEvent) GoString() string {
	return s.String()
}

// SetResponseMap sets the ResponseMap field's value.
func (s *AuthChallengeResponseEvent) SetResponseMap(v map[string]*string) *AuthChallengeResponseEvent {
	s.ResponseMap = v
	return s
}

// The AuthChallengeResponseEvent is and event in the ChatInputStream group of events.
func (s *AuthChallengeResponseEvent) eventChatInputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the AuthChallengeResponseEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *AuthChallengeResponseEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *AuthChallengeResponseEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Information about the basic authentication credentials used to configure
// a plugin.
type BasicAuthConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of an IAM role used by Amazon Q Business to access the basic authentication
	// credentials stored in a Secrets Manager secret.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the Secrets Manager secret that stores the basic authentication
	// credentials used for plugin configuration..
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasicAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasicAuthConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BasicAuthConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BasicAuthConfiguration"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *BasicAuthConfiguration) SetRoleArn(v string) *BasicAuthConfiguration {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *BasicAuthConfiguration) SetSecretArn(v string) *BasicAuthConfiguration {
	s.SecretArn = &v
	return s
}

type BatchDeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source sync during which the documents were deleted.
	DataSourceSyncId *string `locationName:"dataSourceSyncId" min:"36" type:"string"`

	// Documents deleted from the Amazon Q Business index.
	//
	// Documents is a required field
	Documents []*DeleteDocument `locationName:"documents" type:"list" required:"true"`

	// The identifier of the Amazon Q Business index that contains the documents
	// to delete.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteDocumentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceSyncId != nil && len(*s.DataSourceSyncId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceSyncId", 36))
	}
	if s.Documents == nil {
		invalidParams.Add(request.NewErrParamRequired("Documents"))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Documents != nil {
		for i, v := range s.Documents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Documents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *BatchDeleteDocumentInput) SetApplicationId(v string) *BatchDeleteDocumentInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceSyncId sets the DataSourceSyncId field's value.
func (s *BatchDeleteDocumentInput) SetDataSourceSyncId(v string) *BatchDeleteDocumentInput {
	s.DataSourceSyncId = &v
	return s
}

// SetDocuments sets the Documents field's value.
func (s *BatchDeleteDocumentInput) SetDocuments(v []*DeleteDocument) *BatchDeleteDocumentInput {
	s.Documents = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchDeleteDocumentInput) SetIndexId(v string) *BatchDeleteDocumentInput {
	s.IndexId = &v
	return s
}

type BatchDeleteDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A list of documents that couldn't be removed from the Amazon Q Business index.
	// Each entry contains an error message that indicates why the document couldn't
	// be removed from the index.
	FailedDocuments []*FailedDocument `locationName:"failedDocuments" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteDocumentOutput) GoString() string {
	return s.String()
}

// SetFailedDocuments sets the FailedDocuments field's value.
func (s *BatchDeleteDocumentOutput) SetFailedDocuments(v []*FailedDocument) *BatchDeleteDocumentOutput {
	s.FailedDocuments = v
	return s
}

type BatchPutDocumentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source sync during which the documents were added.
	DataSourceSyncId *string `locationName:"dataSourceSyncId" min:"36" type:"string"`

	// One or more documents to add to the index.
	//
	// Documents is a required field
	Documents []*Document `locationName:"documents" min:"1" type:"list" required:"true"`

	// The identifier of the Amazon Q Business index to add the documents to.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role with permission to access your
	// S3 bucket.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutDocumentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceSyncId != nil && len(*s.DataSourceSyncId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceSyncId", 36))
	}
	if s.Documents == nil {
		invalidParams.Add(request.NewErrParamRequired("Documents"))
	}
	if s.Documents != nil && len(s.Documents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Documents", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Documents != nil {
		for i, v := range s.Documents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Documents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *BatchPutDocumentInput) SetApplicationId(v string) *BatchPutDocumentInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceSyncId sets the DataSourceSyncId field's value.
func (s *BatchPutDocumentInput) SetDataSourceSyncId(v string) *BatchPutDocumentInput {
	s.DataSourceSyncId = &v
	return s
}

// SetDocuments sets the Documents field's value.
func (s *BatchPutDocumentInput) SetDocuments(v []*Document) *BatchPutDocumentInput {
	s.Documents = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *BatchPutDocumentInput) SetIndexId(v string) *BatchPutDocumentInput {
	s.IndexId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *BatchPutDocumentInput) SetRoleArn(v string) *BatchPutDocumentInput {
	s.RoleArn = &v
	return s
}

type BatchPutDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A list of documents that were not added to the Amazon Q Business index because
	// the document failed a validation check. Each document contains an error message
	// that indicates why the document couldn't be added to the index.
	FailedDocuments []*FailedDocument `locationName:"failedDocuments" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchPutDocumentOutput) GoString() string {
	return s.String()
}

// SetFailedDocuments sets the FailedDocuments field's value.
func (s *BatchPutDocumentOutput) SetFailedDocuments(v []*FailedDocument) *BatchPutDocumentOutput {
	s.FailedDocuments = v
	return s
}

// Provides information about the phrases blocked from chat by your chat control
// configuration.
type BlockedPhrasesConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of phrases blocked from a Amazon Q Business web experience chat.
	BlockedPhrases []*string `locationName:"blockedPhrases" type:"list"`

	// The configured custom message displayed to an end user informing them that
	// they've used a blocked phrase during chat.
	SystemMessageOverride *string `locationName:"systemMessageOverride" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockedPhrasesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockedPhrasesConfiguration) GoString() string {
	return s.String()
}

// SetBlockedPhrases sets the BlockedPhrases field's value.
func (s *BlockedPhrasesConfiguration) SetBlockedPhrases(v []*string) *BlockedPhrasesConfiguration {
	s.BlockedPhrases = v
	return s
}

// SetSystemMessageOverride sets the SystemMessageOverride field's value.
func (s *BlockedPhrasesConfiguration) SetSystemMessageOverride(v string) *BlockedPhrasesConfiguration {
	s.SystemMessageOverride = &v
	return s
}

// Updates a blocked phrases configuration in your Amazon Q Business application.
type BlockedPhrasesConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Creates or updates a blocked phrases configuration in your Amazon Q Business
	// application.
	BlockedPhrasesToCreateOrUpdate []*string `locationName:"blockedPhrasesToCreateOrUpdate" type:"list"`

	// Deletes a blocked phrases configuration in your Amazon Q Business application.
	BlockedPhrasesToDelete []*string `locationName:"blockedPhrasesToDelete" type:"list"`

	// The configured custom message displayed to your end user when they use blocked
	// phrase during chat.
	SystemMessageOverride *string `locationName:"systemMessageOverride" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockedPhrasesConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockedPhrasesConfigurationUpdate) GoString() string {
	return s.String()
}

// SetBlockedPhrasesToCreateOrUpdate sets the BlockedPhrasesToCreateOrUpdate field's value.
func (s *BlockedPhrasesConfigurationUpdate) SetBlockedPhrasesToCreateOrUpdate(v []*string) *BlockedPhrasesConfigurationUpdate {
	s.BlockedPhrasesToCreateOrUpdate = v
	return s
}

// SetBlockedPhrasesToDelete sets the BlockedPhrasesToDelete field's value.
func (s *BlockedPhrasesConfigurationUpdate) SetBlockedPhrasesToDelete(v []*string) *BlockedPhrasesConfigurationUpdate {
	s.BlockedPhrasesToDelete = v
	return s
}

// SetSystemMessageOverride sets the SystemMessageOverride field's value.
func (s *BlockedPhrasesConfigurationUpdate) SetSystemMessageOverride(v string) *BlockedPhrasesConfigurationUpdate {
	s.SystemMessageOverride = &v
	return s
}

type ChatInput struct {
	_ struct{} `type:"structure" payload:"InputStream"`

	// The identifier of the Amazon Q Business application linked to a streaming
	// Amazon Q Business conversation.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// A token that you provide to identify the chat input.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The identifier of the Amazon Q Business conversation.
	ConversationId *string `location:"querystring" locationName:"conversationId" min:"36" type:"string"`

	// The identifier used to associate a user message with a AI generated response.
	ParentMessageId *string `location:"querystring" locationName:"parentMessageId" min:"36" type:"string"`

	// The groups that a user associated with the chat input belongs to.
	UserGroups []*string `location:"querystring" locationName:"userGroups" type:"list"`

	// The identifier of the user attached to the chat input.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConversationId != nil && len(*s.ConversationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConversationId", 36))
	}
	if s.ParentMessageId != nil && len(*s.ParentMessageId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ParentMessageId", 36))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ChatInput) SetApplicationId(v string) *ChatInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ChatInput) SetClientToken(v string) *ChatInput {
	s.ClientToken = &v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *ChatInput) SetConversationId(v string) *ChatInput {
	s.ConversationId = &v
	return s
}

// SetParentMessageId sets the ParentMessageId field's value.
func (s *ChatInput) SetParentMessageId(v string) *ChatInput {
	s.ParentMessageId = &v
	return s
}

// SetUserGroups sets the UserGroups field's value.
func (s *ChatInput) SetUserGroups(v []*string) *ChatInput {
	s.UserGroups = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ChatInput) SetUserId(v string) *ChatInput {
	s.UserId = &v
	return s
}

// ChatInputStreamEvent groups together all EventStream
// events writes for ChatInputStream.
//
// These events are:
//
//   - AttachmentInputEvent
//   - AuthChallengeResponseEvent
//   - ConfigurationEvent
//   - EndOfInputEvent
//   - TextInputEvent
type ChatInputStreamEvent interface {
	eventChatInputStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// ChatInputStreamWriter provides the interface for writing events to the stream.
// The default implementation for this interface will be ChatInputStream.
//
// The writer's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - AttachmentInputEvent
//   - AuthChallengeResponseEvent
//   - ConfigurationEvent
//   - EndOfInputEvent
//   - TextInputEvent
type ChatInputStreamWriter interface {
	// Sends writes events to the stream blocking until the event has been
	// written. An error is returned if the write fails.
	Send(aws.Context, ChatInputStreamEvent) error

	// Close will stop the writer writing to the event stream.
	Close() error

	// Returns any error that has occurred while writing to the event stream.
	Err() error
}

type writeChatInputStream struct {
	*eventstreamapi.StreamWriter
}

func (w *writeChatInputStream) Send(ctx aws.Context, event ChatInputStreamEvent) error {
	return w.StreamWriter.Send(ctx, event)
}

func eventTypeForChatInputStreamEvent(event eventstreamapi.Marshaler) (string, error) {
	switch event.(type) {
	case *AttachmentInputEvent:
		return "attachmentEvent", nil
	case *AuthChallengeResponseEvent:
		return "authChallengeResponseEvent", nil
	case *ConfigurationEvent:
		return "configurationEvent", nil
	case *EndOfInputEvent:
		return "endOfInputEvent", nil
	case *TextInputEvent:
		return "textEvent", nil
	default:
		return "", awserr.New(
			request.ErrCodeSerialization,
			fmt.Sprintf("unknown event type, %T, for ChatInputStream", event),
			nil,
		)
	}
}

// Configuration information for Amazon Q Business conversation modes.
//
// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html)
// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
type ChatModeConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration information required to invoke chat in PLUGIN_MODE.
	PluginConfiguration *PluginConfiguration `locationName:"pluginConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatModeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatModeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatModeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatModeConfiguration"}
	if s.PluginConfiguration != nil {
		if err := s.PluginConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PluginConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPluginConfiguration sets the PluginConfiguration field's value.
func (s *ChatModeConfiguration) SetPluginConfiguration(v *PluginConfiguration) *ChatModeConfiguration {
	s.PluginConfiguration = v
	return s
}

type ChatOutput struct {
	_ struct{} `type:"structure" payload:"OutputStream"`

	eventStream *ChatEventStream
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatOutput) GoString() string {
	return s.String()
}

// GetStream returns the type to interact with the event stream.
func (s *ChatOutput) GetStream() *ChatEventStream {
	return s.eventStream
}

// ChatOutputStreamEvent groups together all EventStream
// events writes for ChatOutputStream.
//
// These events are:
//
//   - ActionReviewEvent
//   - AuthChallengeRequestEvent
//   - FailedAttachmentEvent
//   - MetadataEvent
//   - TextOutputEvent
type ChatOutputStreamEvent interface {
	eventChatOutputStream()
	eventstreamapi.Marshaler
	eventstreamapi.Unmarshaler
}

// ChatOutputStreamReader provides the interface for reading to the stream. The
// default implementation for this interface will be ChatOutputStream.
//
// The reader's Close method must allow multiple concurrent calls.
//
// These events are:
//
//   - ActionReviewEvent
//   - AuthChallengeRequestEvent
//   - FailedAttachmentEvent
//   - MetadataEvent
//   - TextOutputEvent
//   - ChatOutputStreamUnknownEvent
type ChatOutputStreamReader interface {
	// Returns a channel of events as they are read from the event stream.
	Events() <-chan ChatOutputStreamEvent

	// Close will stop the reader reading events from the stream.
	Close() error

	// Returns any error that has occurred while reading from the event stream.
	Err() error
}

type readChatOutputStream struct {
	eventReader *eventstreamapi.EventReader
	stream      chan ChatOutputStreamEvent
	err         *eventstreamapi.OnceError

	done      chan struct{}
	closeOnce sync.Once
}

func newReadChatOutputStream(eventReader *eventstreamapi.EventReader) *readChatOutputStream {
	r := &readChatOutputStream{
		eventReader: eventReader,
		stream:      make(chan ChatOutputStreamEvent),
		done:        make(chan struct{}),
		err:         eventstreamapi.NewOnceError(),
	}
	go r.readEventStream()

	return r
}

// Close will close the underlying event stream reader.
func (r *readChatOutputStream) Close() error {
	r.closeOnce.Do(r.safeClose)
	return r.Err()
}

func (r *readChatOutputStream) ErrorSet() <-chan struct{} {
	return r.err.ErrorSet()
}

func (r *readChatOutputStream) Closed() <-chan struct{} {
	return r.done
}

func (r *readChatOutputStream) safeClose() {
	close(r.done)
}

func (r *readChatOutputStream) Err() error {
	return r.err.Err()
}

func (r *readChatOutputStream) Events() <-chan ChatOutputStreamEvent {
	return r.stream
}

func (r *readChatOutputStream) readEventStream() {
	defer r.Close()
	defer close(r.stream)

	for {
		event, err := r.eventReader.ReadEvent()
		if err != nil {
			if err == io.EOF {
				return
			}
			select {
			case <-r.done:
				// If closed already ignore the error
				return
			default:
			}
			if _, ok := err.(*eventstreamapi.UnknownMessageTypeError); ok {
				continue
			}
			r.err.SetError(err)
			return
		}

		select {
		case r.stream <- event.(ChatOutputStreamEvent):
		case <-r.done:
			return
		}
	}
}

type unmarshalerForChatOutputStreamEvent struct {
	metadata protocol.ResponseMetadata
}

func (u unmarshalerForChatOutputStreamEvent) UnmarshalerForEventName(eventType string) (eventstreamapi.Unmarshaler, error) {
	switch eventType {
	case "actionReviewEvent":
		return &ActionReviewEvent{}, nil
	case "authChallengeRequestEvent":
		return &AuthChallengeRequestEvent{}, nil
	case "failedAttachmentEvent":
		return &FailedAttachmentEvent{}, nil
	case "metadataEvent":
		return &MetadataEvent{}, nil
	case "textEvent":
		return &TextOutputEvent{}, nil
	default:
		return &ChatOutputStreamUnknownEvent{Type: eventType}, nil
	}
}

// ChatOutputStreamUnknownEvent provides a failsafe event for the
// ChatOutputStream group of events when an unknown event is received.
type ChatOutputStreamUnknownEvent struct {
	Type    string
	Message eventstream.Message
}

// The ChatOutputStreamUnknownEvent is and event in the ChatOutputStream
// group of events.
func (s *ChatOutputStreamUnknownEvent) eventChatOutputStream() {}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (e *ChatOutputStreamUnknownEvent) MarshalEvent(pm protocol.PayloadMarshaler) (
	msg eventstream.Message, err error,
) {
	return e.Message.Clone(), nil
}

// UnmarshalEvent unmarshals the EventStream Message into the ChatOutputStream value.
// This method is only used internally within the SDK's EventStream handling.
func (e *ChatOutputStreamUnknownEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	e.Message = msg.Clone()
	return nil
}

type ChatSyncInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application linked to the Amazon
	// Q Business conversation.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// A list of files uploaded directly during chat. You can upload a maximum of
	// 5 files of upto 10 MB each.
	Attachments []*AttachmentInput_ `locationName:"attachments" min:"1" type:"list"`

	// Enables filtering of Amazon Q Business web experience responses based on
	// document attributes or metadata fields.
	AttributeFilter *AttributeFilter `locationName:"attributeFilter" type:"structure"`

	// An authentication verification event response by a third party authentication
	// server to Amazon Q Business.
	AuthChallengeResponse *AuthChallengeResponse `locationName:"authChallengeResponse" type:"structure"`

	// The chat modes available to an Amazon Q Business end user.
	//
	//    * RETRIEVAL_MODE - The default chat mode for an Amazon Q Business application.
	//    When this mode is enabled, Amazon Q Business generates responses only
	//    from data sources connected to an Amazon Q Business application.
	//
	//    * CREATOR_MODE - By selecting this mode, users can choose to generate
	//    responses only from the LLM knowledge, without consulting connected data
	//    sources, for a chat request.
	//
	//    * PLUGIN_MODE - By selecting this mode, users can choose to use plugins
	//    in chat.
	//
	// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html),
	// Plugins (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html),
	// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
	ChatMode *string `locationName:"chatMode" type:"string" enum:"ChatMode"`

	// The chat mode configuration for an Amazon Q Business application.
	ChatModeConfiguration *ChatModeConfiguration `locationName:"chatModeConfiguration" type:"structure"`

	// A token that you provide to identify a chat request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The identifier of the Amazon Q Business conversation.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// The identifier of the previous end user text input message in a conversation.
	ParentMessageId *string `locationName:"parentMessageId" min:"36" type:"string"`

	// The groups that a user associated with the chat input belongs to.
	UserGroups []*string `location:"querystring" locationName:"userGroups" type:"list"`

	// The identifier of the user attached to the chat input.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`

	// A end user message in a conversation.
	UserMessage *string `locationName:"userMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatSyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatSyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatSyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatSyncInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.Attachments != nil && len(s.Attachments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attachments", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConversationId != nil && len(*s.ConversationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConversationId", 36))
	}
	if s.ParentMessageId != nil && len(*s.ParentMessageId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ParentMessageId", 36))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.UserMessage != nil && len(*s.UserMessage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserMessage", 1))
	}
	if s.Attachments != nil {
		for i, v := range s.Attachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attachments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AttributeFilter != nil {
		if err := s.AttributeFilter.Validate(); err != nil {
			invalidParams.AddNested("AttributeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.AuthChallengeResponse != nil {
		if err := s.AuthChallengeResponse.Validate(); err != nil {
			invalidParams.AddNested("AuthChallengeResponse", err.(request.ErrInvalidParams))
		}
	}
	if s.ChatModeConfiguration != nil {
		if err := s.ChatModeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChatModeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ChatSyncInput) SetApplicationId(v string) *ChatSyncInput {
	s.ApplicationId = &v
	return s
}

// SetAttachments sets the Attachments field's value.
func (s *ChatSyncInput) SetAttachments(v []*AttachmentInput_) *ChatSyncInput {
	s.Attachments = v
	return s
}

// SetAttributeFilter sets the AttributeFilter field's value.
func (s *ChatSyncInput) SetAttributeFilter(v *AttributeFilter) *ChatSyncInput {
	s.AttributeFilter = v
	return s
}

// SetAuthChallengeResponse sets the AuthChallengeResponse field's value.
func (s *ChatSyncInput) SetAuthChallengeResponse(v *AuthChallengeResponse) *ChatSyncInput {
	s.AuthChallengeResponse = v
	return s
}

// SetChatMode sets the ChatMode field's value.
func (s *ChatSyncInput) SetChatMode(v string) *ChatSyncInput {
	s.ChatMode = &v
	return s
}

// SetChatModeConfiguration sets the ChatModeConfiguration field's value.
func (s *ChatSyncInput) SetChatModeConfiguration(v *ChatModeConfiguration) *ChatSyncInput {
	s.ChatModeConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ChatSyncInput) SetClientToken(v string) *ChatSyncInput {
	s.ClientToken = &v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *ChatSyncInput) SetConversationId(v string) *ChatSyncInput {
	s.ConversationId = &v
	return s
}

// SetParentMessageId sets the ParentMessageId field's value.
func (s *ChatSyncInput) SetParentMessageId(v string) *ChatSyncInput {
	s.ParentMessageId = &v
	return s
}

// SetUserGroups sets the UserGroups field's value.
func (s *ChatSyncInput) SetUserGroups(v []*string) *ChatSyncInput {
	s.UserGroups = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ChatSyncInput) SetUserId(v string) *ChatSyncInput {
	s.UserId = &v
	return s
}

// SetUserMessage sets the UserMessage field's value.
func (s *ChatSyncInput) SetUserMessage(v string) *ChatSyncInput {
	s.UserMessage = &v
	return s
}

type ChatSyncOutput struct {
	_ struct{} `type:"structure"`

	// A request from Amazon Q Business to the end user for information Amazon Q
	// Business needs to successfully complete a requested plugin action.
	ActionReview *ActionReview `locationName:"actionReview" type:"structure"`

	// An authentication verification event activated by an end user request to
	// use a custom plugin.
	AuthChallengeRequest *AuthChallengeRequest `locationName:"authChallengeRequest" type:"structure"`

	// The identifier of the Amazon Q Business conversation.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// A list of files which failed to upload during chat.
	FailedAttachments []*AttachmentOutput_ `locationName:"failedAttachments" type:"list"`

	// The source documents used to generate the conversation response.
	SourceAttributions []*SourceAttribution `locationName:"sourceAttributions" type:"list"`

	// An AI-generated message in a conversation.
	SystemMessage *string `locationName:"systemMessage" min:"1" type:"string"`

	// The identifier of an Amazon Q Business AI generated message within the conversation.
	SystemMessageId *string `locationName:"systemMessageId" min:"36" type:"string"`

	// The identifier of an Amazon Q Business end user text input message within
	// the conversation.
	UserMessageId *string `locationName:"userMessageId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatSyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatSyncOutput) GoString() string {
	return s.String()
}

// SetActionReview sets the ActionReview field's value.
func (s *ChatSyncOutput) SetActionReview(v *ActionReview) *ChatSyncOutput {
	s.ActionReview = v
	return s
}

// SetAuthChallengeRequest sets the AuthChallengeRequest field's value.
func (s *ChatSyncOutput) SetAuthChallengeRequest(v *AuthChallengeRequest) *ChatSyncOutput {
	s.AuthChallengeRequest = v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *ChatSyncOutput) SetConversationId(v string) *ChatSyncOutput {
	s.ConversationId = &v
	return s
}

// SetFailedAttachments sets the FailedAttachments field's value.
func (s *ChatSyncOutput) SetFailedAttachments(v []*AttachmentOutput_) *ChatSyncOutput {
	s.FailedAttachments = v
	return s
}

// SetSourceAttributions sets the SourceAttributions field's value.
func (s *ChatSyncOutput) SetSourceAttributions(v []*SourceAttribution) *ChatSyncOutput {
	s.SourceAttributions = v
	return s
}

// SetSystemMessage sets the SystemMessage field's value.
func (s *ChatSyncOutput) SetSystemMessage(v string) *ChatSyncOutput {
	s.SystemMessage = &v
	return s
}

// SetSystemMessageId sets the SystemMessageId field's value.
func (s *ChatSyncOutput) SetSystemMessageId(v string) *ChatSyncOutput {
	s.SystemMessageId = &v
	return s
}

// SetUserMessageId sets the UserMessageId field's value.
func (s *ChatSyncOutput) SetUserMessageId(v string) *ChatSyncOutput {
	s.UserMessageId = &v
	return s
}

// A configuration event activated by an end user request to select a specific
// chat mode.
type ConfigurationEvent struct {
	_ struct{} `type:"structure"`

	// Enables filtering of responses based on document attributes or metadata fields.
	AttributeFilter *AttributeFilter `locationName:"attributeFilter" type:"structure"`

	// The chat modes available to an Amazon Q Business end user.
	//
	//    * RETRIEVAL_MODE - The default chat mode for an Amazon Q Business application.
	//    When this mode is enabled, Amazon Q Business generates responses only
	//    from data sources connected to an Amazon Q Business application.
	//
	//    * CREATOR_MODE - By selecting this mode, users can choose to generate
	//    responses only from the LLM knowledge, without consulting connected data
	//    sources, for a chat request.
	//
	//    * PLUGIN_MODE - By selecting this mode, users can choose to use plugins
	//    in chat.
	//
	// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html),
	// Plugins (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html),
	// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
	ChatMode *string `locationName:"chatMode" type:"string" enum:"ChatMode"`

	// Configuration information for Amazon Q Business conversation modes.
	//
	// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html)
	// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
	ChatModeConfiguration *ChatModeConfiguration `locationName:"chatModeConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurationEvent) GoString() string {
	return s.String()
}

// SetAttributeFilter sets the AttributeFilter field's value.
func (s *ConfigurationEvent) SetAttributeFilter(v *AttributeFilter) *ConfigurationEvent {
	s.AttributeFilter = v
	return s
}

// SetChatMode sets the ChatMode field's value.
func (s *ConfigurationEvent) SetChatMode(v string) *ConfigurationEvent {
	s.ChatMode = &v
	return s
}

// SetChatModeConfiguration sets the ChatModeConfiguration field's value.
func (s *ConfigurationEvent) SetChatModeConfiguration(v *ChatModeConfiguration) *ConfigurationEvent {
	s.ChatModeConfiguration = v
	return s
}

// The ConfigurationEvent is and event in the ChatInputStream group of events.
func (s *ConfigurationEvent) eventChatInputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the ConfigurationEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *ConfigurationEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *ConfigurationEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// You are trying to perform an action that conflicts with the current status
// of your resource. Fix any inconsistences with your resources and try again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message describing a ConflictException.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A rule for configuring how Amazon Q Business responds when it encounters
// a a blocked topic. You can configure a custom message to inform your end
// users that they have asked about a restricted topic and suggest any next
// steps they should take.
type ContentBlockerRule struct {
	_ struct{} `type:"structure"`

	// The configured custom message displayed to an end user informing them that
	// they've used a blocked phrase during chat.
	SystemMessageOverride *string `locationName:"systemMessageOverride" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentBlockerRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentBlockerRule) GoString() string {
	return s.String()
}

// SetSystemMessageOverride sets the SystemMessageOverride field's value.
func (s *ContentBlockerRule) SetSystemMessageOverride(v string) *ContentBlockerRule {
	s.SystemMessageOverride = &v
	return s
}

// Rules for retrieving content from data sources connected to a Amazon Q Business
// application for a specific topic control configuration.
type ContentRetrievalRule struct {
	_ struct{} `type:"structure"`

	// Specifies data sources in a Amazon Q Business application to use for content
	// generation.
	EligibleDataSources []*EligibleDataSource `locationName:"eligibleDataSources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentRetrievalRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentRetrievalRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentRetrievalRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentRetrievalRule"}
	if s.EligibleDataSources != nil {
		for i, v := range s.EligibleDataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EligibleDataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEligibleDataSources sets the EligibleDataSources field's value.
func (s *ContentRetrievalRule) SetEligibleDataSources(v []*EligibleDataSource) *ContentRetrievalRule {
	s.EligibleDataSources = v
	return s
}

// A conversation in an Amazon Q Business application.
type Conversation struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business conversation.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// The start time of the conversation.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The title of the conversation.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Conversation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Conversation) GoString() string {
	return s.String()
}

// SetConversationId sets the ConversationId field's value.
func (s *Conversation) SetConversationId(v string) *Conversation {
	s.ConversationId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Conversation) SetStartTime(v time.Time) *Conversation {
	s.StartTime = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Conversation) SetTitle(v string) *Conversation {
	s.Title = &v
	return s
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// An option to allow end users to upload files directly during chat.
	AttachmentsConfiguration *AttachmentsConfiguration `locationName:"attachmentsConfiguration" type:"structure"`

	// A token that you provide to identify the request to create your Amazon Q
	// Business application.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description for the Amazon Q Business application.
	Description *string `locationName:"description" type:"string"`

	// A name for the Amazon Q Business application.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The identifier of the KMS key that is used to encrypt your data. Amazon Q
	// Business doesn't support asymmetric keys.
	EncryptionConfiguration *EncryptionConfiguration `locationName:"encryptionConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM Identity Center instance you are
	// either creating for—or connecting to—your Amazon Q Business application.
	IdentityCenterInstanceArn *string `locationName:"identityCenterInstanceArn" min:"10" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role with permissions to access
	// your Amazon CloudWatch logs and metrics.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A list of key-value pairs that identify or categorize your Amazon Q Business
	// application. You can also use tags to help control access to the application.
	// Tag keys and values can consist of Unicode letters, digits, white space,
	// and any of the following symbols: _ . : / = + - @.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IdentityCenterInstanceArn != nil && len(*s.IdentityCenterInstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityCenterInstanceArn", 10))
	}
	if s.AttachmentsConfiguration != nil {
		if err := s.AttachmentsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AttachmentsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachmentsConfiguration sets the AttachmentsConfiguration field's value.
func (s *CreateApplicationInput) SetAttachmentsConfiguration(v *AttachmentsConfiguration) *CreateApplicationInput {
	s.AttachmentsConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateApplicationInput) SetDisplayName(v string) *CreateApplicationInput {
	s.DisplayName = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *CreateApplicationInput) SetEncryptionConfiguration(v *EncryptionConfiguration) *CreateApplicationInput {
	s.EncryptionConfiguration = v
	return s
}

// SetIdentityCenterInstanceArn sets the IdentityCenterInstanceArn field's value.
func (s *CreateApplicationInput) SetIdentityCenterInstanceArn(v string) *CreateApplicationInput {
	s.IdentityCenterInstanceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateApplicationInput) SetRoleArn(v string) *CreateApplicationInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v []*Tag) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Q Business application.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The identifier of the Amazon Q Business application.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateApplicationOutput) SetApplicationArn(v string) *CreateApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

type CreateIndexInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application using the index.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The capacity units you want to provision for your index. You can add and
	// remove capacity to fit your usage needs.
	CapacityConfiguration *IndexCapacityConfiguration `locationName:"capacityConfiguration" type:"structure"`

	// A token that you provide to identify the request to create an index. Multiple
	// calls to the CreateIndex API with the same client token will create only
	// one index.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description for the Amazon Q Business index.
	Description *string `locationName:"description" type:"string"`

	// A name for the Amazon Q Business index.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that identify or categorize the index. You can
	// also use tags to help control access to the index. Tag keys and values can
	// consist of Unicode letters, digits, white space, and any of the following
	// symbols: _ . : / = + - @.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The index type that's suitable for your needs. For more information on what's
	// included in each type of index or index tier, see Amazon Q Business tiers
	// (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/what-is.html#tiers).
	Type *string `locationName:"type" type:"string" enum:"IndexType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIndexInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.CapacityConfiguration != nil {
		if err := s.CapacityConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CapacityConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateIndexInput) SetApplicationId(v string) *CreateIndexInput {
	s.ApplicationId = &v
	return s
}

// SetCapacityConfiguration sets the CapacityConfiguration field's value.
func (s *CreateIndexInput) SetCapacityConfiguration(v *IndexCapacityConfiguration) *CreateIndexInput {
	s.CapacityConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateIndexInput) SetClientToken(v string) *CreateIndexInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateIndexInput) SetDescription(v string) *CreateIndexInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateIndexInput) SetDisplayName(v string) *CreateIndexInput {
	s.DisplayName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIndexInput) SetTags(v []*Tag) *CreateIndexInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateIndexInput) SetType(v string) *CreateIndexInput {
	s.Type = &v
	return s
}

type CreateIndexOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Q Business index.
	IndexArn *string `locationName:"indexArn" type:"string"`

	// The identifier for the Amazon Q Business index.
	IndexId *string `locationName:"indexId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIndexOutput) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *CreateIndexOutput) SetIndexArn(v string) *CreateIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *CreateIndexOutput) SetIndexId(v string) *CreateIndexOutput {
	s.IndexId = &v
	return s
}

type CreatePluginInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application that will contain the plugin.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// Authentication configuration information for an Amazon Q Business plugin.
	//
	// AuthConfiguration is a required field
	AuthConfiguration *PluginAuthConfiguration `locationName:"authConfiguration" type:"structure" required:"true"`

	// A token that you provide to identify the request to create your Amazon Q
	// Business plugin.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Contains configuration for a custom plugin.
	CustomPluginConfiguration *CustomPluginConfiguration `locationName:"customPluginConfiguration" type:"structure"`

	// A the name for your plugin.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The source URL used for plugin configuration.
	ServerUrl *string `locationName:"serverUrl" min:"1" type:"string"`

	// A list of key-value pairs that identify or categorize the data source connector.
	// You can also use tags to help control access to the data source connector.
	// Tag keys and values can consist of Unicode letters, digits, white space,
	// and any of the following symbols: _ . : / = + - @.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The type of plugin you want to create.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"PluginType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePluginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePluginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePluginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePluginInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.AuthConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthConfiguration"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.ServerUrl != nil && len(*s.ServerUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerUrl", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.AuthConfiguration != nil {
		if err := s.AuthConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomPluginConfiguration != nil {
		if err := s.CustomPluginConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CustomPluginConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreatePluginInput) SetApplicationId(v string) *CreatePluginInput {
	s.ApplicationId = &v
	return s
}

// SetAuthConfiguration sets the AuthConfiguration field's value.
func (s *CreatePluginInput) SetAuthConfiguration(v *PluginAuthConfiguration) *CreatePluginInput {
	s.AuthConfiguration = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePluginInput) SetClientToken(v string) *CreatePluginInput {
	s.ClientToken = &v
	return s
}

// SetCustomPluginConfiguration sets the CustomPluginConfiguration field's value.
func (s *CreatePluginInput) SetCustomPluginConfiguration(v *CustomPluginConfiguration) *CreatePluginInput {
	s.CustomPluginConfiguration = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreatePluginInput) SetDisplayName(v string) *CreatePluginInput {
	s.DisplayName = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *CreatePluginInput) SetServerUrl(v string) *CreatePluginInput {
	s.ServerUrl = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePluginInput) SetTags(v []*Tag) *CreatePluginInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreatePluginInput) SetType(v string) *CreatePluginInput {
	s.Type = &v
	return s
}

type CreatePluginOutput struct {
	_ struct{} `type:"structure"`

	// The current status of a plugin. A plugin is modified asynchronously.
	BuildStatus *string `locationName:"buildStatus" type:"string" enum:"PluginBuildStatus"`

	// The Amazon Resource Name (ARN) of a plugin.
	PluginArn *string `locationName:"pluginArn" type:"string"`

	// The identifier of the plugin created.
	PluginId *string `locationName:"pluginId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePluginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePluginOutput) GoString() string {
	return s.String()
}

// SetBuildStatus sets the BuildStatus field's value.
func (s *CreatePluginOutput) SetBuildStatus(v string) *CreatePluginOutput {
	s.BuildStatus = &v
	return s
}

// SetPluginArn sets the PluginArn field's value.
func (s *CreatePluginOutput) SetPluginArn(v string) *CreatePluginOutput {
	s.PluginArn = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *CreatePluginOutput) SetPluginId(v string) *CreatePluginOutput {
	s.PluginId = &v
	return s
}

type CreateRetrieverInput struct {
	_ struct{} `type:"structure"`

	// The identifier of your Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// A token that you provide to identify the request to create your Amazon Q
	// Business application retriever.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Provides information on how the retriever used for your Amazon Q Business
	// application is configured.
	//
	// Configuration is a required field
	Configuration *RetrieverConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The name of your retriever.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The ARN of an IAM role used by Amazon Q Business to access the basic authentication
	// credentials stored in a Secrets Manager secret.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A list of key-value pairs that identify or categorize the retriever. You
	// can also use tags to help control access to the retriever. Tag keys and values
	// can consist of Unicode letters, digits, white space, and any of the following
	// symbols: _ . : / = + - @.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The type of retriever you are using.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"RetrieverType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRetrieverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRetrieverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRetrieverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRetrieverInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateRetrieverInput) SetApplicationId(v string) *CreateRetrieverInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRetrieverInput) SetClientToken(v string) *CreateRetrieverInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateRetrieverInput) SetConfiguration(v *RetrieverConfiguration) *CreateRetrieverInput {
	s.Configuration = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateRetrieverInput) SetDisplayName(v string) *CreateRetrieverInput {
	s.DisplayName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateRetrieverInput) SetRoleArn(v string) *CreateRetrieverInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRetrieverInput) SetTags(v []*Tag) *CreateRetrieverInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateRetrieverInput) SetType(v string) *CreateRetrieverInput {
	s.Type = &v
	return s
}

type CreateRetrieverOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role associated with a retriever.
	RetrieverArn *string `locationName:"retrieverArn" type:"string"`

	// The identifier of the retriever you are using.
	RetrieverId *string `locationName:"retrieverId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRetrieverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRetrieverOutput) GoString() string {
	return s.String()
}

// SetRetrieverArn sets the RetrieverArn field's value.
func (s *CreateRetrieverOutput) SetRetrieverArn(v string) *CreateRetrieverOutput {
	s.RetrieverArn = &v
	return s
}

// SetRetrieverId sets the RetrieverId field's value.
func (s *CreateRetrieverOutput) SetRetrieverId(v string) *CreateRetrieverOutput {
	s.RetrieverId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application for which the user mapping will be created.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// A token that you provide to identify the request to create your Amazon Q
	// Business user mapping.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The list of user aliases in the mapping.
	UserAliases []*UserAlias `locationName:"userAliases" type:"list"`

	// The user emails attached to a user mapping.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.UserAliases != nil {
		for i, v := range s.UserAliases {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAliases", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateUserInput) SetApplicationId(v string) *CreateUserInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateUserInput) SetClientToken(v string) *CreateUserInput {
	s.ClientToken = &v
	return s
}

// SetUserAliases sets the UserAliases field's value.
func (s *CreateUserInput) SetUserAliases(v []*UserAlias) *CreateUserInput {
	s.UserAliases = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserInput) SetUserId(v string) *CreateUserInput {
	s.UserId = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) GoString() string {
	return s.String()
}

type CreateWebExperienceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business web experience.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// A token you provide to identify a request to create an Amazon Q Business
	// web experience.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the service role attached to your web experience.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// Determines whether sample prompts are enabled in the web experience for an
	// end user.
	SamplePromptsControlMode *string `locationName:"samplePromptsControlMode" type:"string" enum:"WebExperienceSamplePromptsControlMode"`

	// A subtitle to personalize your Amazon Q Business web experience.
	Subtitle *string `locationName:"subtitle" type:"string"`

	// A list of key-value pairs that identify or categorize your Amazon Q Business
	// web experience. You can also use tags to help control access to the web experience.
	// Tag keys and values can consist of Unicode letters, digits, white space,
	// and any of the following symbols: _ . : / = + - @.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The title for your Amazon Q Business web experience.
	Title *string `locationName:"title" type:"string"`

	// The customized welcome message for end users of an Amazon Q Business web
	// experience.
	WelcomeMessage *string `locationName:"welcomeMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWebExperienceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWebExperienceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebExperienceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWebExperienceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateWebExperienceInput) SetApplicationId(v string) *CreateWebExperienceInput {
	s.ApplicationId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWebExperienceInput) SetClientToken(v string) *CreateWebExperienceInput {
	s.ClientToken = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateWebExperienceInput) SetRoleArn(v string) *CreateWebExperienceInput {
	s.RoleArn = &v
	return s
}

// SetSamplePromptsControlMode sets the SamplePromptsControlMode field's value.
func (s *CreateWebExperienceInput) SetSamplePromptsControlMode(v string) *CreateWebExperienceInput {
	s.SamplePromptsControlMode = &v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *CreateWebExperienceInput) SetSubtitle(v string) *CreateWebExperienceInput {
	s.Subtitle = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWebExperienceInput) SetTags(v []*Tag) *CreateWebExperienceInput {
	s.Tags = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateWebExperienceInput) SetTitle(v string) *CreateWebExperienceInput {
	s.Title = &v
	return s
}

// SetWelcomeMessage sets the WelcomeMessage field's value.
func (s *CreateWebExperienceInput) SetWelcomeMessage(v string) *CreateWebExperienceInput {
	s.WelcomeMessage = &v
	return s
}

type CreateWebExperienceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Q Business web experience.
	WebExperienceArn *string `locationName:"webExperienceArn" type:"string"`

	// The identifier of the Amazon Q Business web experience.
	WebExperienceId *string `locationName:"webExperienceId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWebExperienceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWebExperienceOutput) GoString() string {
	return s.String()
}

// SetWebExperienceArn sets the WebExperienceArn field's value.
func (s *CreateWebExperienceOutput) SetWebExperienceArn(v string) *CreateWebExperienceOutput {
	s.WebExperienceArn = &v
	return s
}

// SetWebExperienceId sets the WebExperienceId field's value.
func (s *CreateWebExperienceOutput) SetWebExperienceId(v string) *CreateWebExperienceOutput {
	s.WebExperienceId = &v
	return s
}

// Configuration information required to invoke chat in CREATOR_MODE.
//
// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html)
// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
type CreatorModeConfiguration struct {
	_ struct{} `type:"structure"`

	// Status information about whether CREATOR_MODE has been enabled or disabled.
	// The default status is DISABLED.
	//
	// CreatorModeControl is a required field
	CreatorModeControl *string `locationName:"creatorModeControl" type:"string" required:"true" enum:"CreatorModeControl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatorModeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatorModeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatorModeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatorModeConfiguration"}
	if s.CreatorModeControl == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorModeControl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorModeControl sets the CreatorModeControl field's value.
func (s *CreatorModeConfiguration) SetCreatorModeControl(v string) *CreatorModeConfiguration {
	s.CreatorModeControl = &v
	return s
}

// Configuration information required to create a custom plugin.
type CustomPluginConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	//
	// ApiSchema is a required field
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure" required:"true"`

	// The type of OpenAPI schema to use.
	//
	// ApiSchemaType is a required field
	ApiSchemaType *string `locationName:"apiSchemaType" type:"string" required:"true" enum:"APISchemaType"`

	// A description for your custom plugin configuration.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomPluginConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomPluginConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomPluginConfiguration"}
	if s.ApiSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiSchema"))
	}
	if s.ApiSchemaType == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiSchemaType"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ApiSchema != nil {
		if err := s.ApiSchema.Validate(); err != nil {
			invalidParams.AddNested("ApiSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiSchema sets the ApiSchema field's value.
func (s *CustomPluginConfiguration) SetApiSchema(v *APISchema) *CustomPluginConfiguration {
	s.ApiSchema = v
	return s
}

// SetApiSchemaType sets the ApiSchemaType field's value.
func (s *CustomPluginConfiguration) SetApiSchemaType(v string) *CustomPluginConfiguration {
	s.ApiSchemaType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomPluginConfiguration) SetDescription(v string) *CustomPluginConfiguration {
	s.Description = &v
	return s
}

// A data source in an Amazon Q Business application.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the Amazon Q Business data source was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The identifier of the Amazon Q Business data source.
	DataSourceId *string `locationName:"dataSourceId" min:"36" type:"string"`

	// The name of the Amazon Q Business data source.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The status of the Amazon Q Business data source.
	Status *string `locationName:"status" type:"string" enum:"DataSourceStatus"`

	// The type of the Amazon Q Business data source.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The Unix timestamp when the Amazon Q Business data source was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSource) SetCreatedAt(v time.Time) *DataSource {
	s.CreatedAt = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSource) SetDataSourceId(v string) *DataSource {
	s.DataSourceId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DataSource) SetDisplayName(v string) *DataSource {
	s.DisplayName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSource) SetStatus(v string) *DataSource {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSource) SetType(v string) *DataSource {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSource) SetUpdatedAt(v time.Time) *DataSource {
	s.UpdatedAt = &v
	return s
}

// Provides information about an Amazon Q Business data source connector synchronization
// job.
type DataSourceSyncJob struct {
	_ struct{} `type:"structure"`

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string `locationName:"dataSourceErrorCode" min:"1" type:"string"`

	// The Unix timestamp when the synchronization job completed.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// If the Status field is set to FAILED, the ErrorCode field indicates the reason
	// the synchronization failed.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The identifier of a data source synchronization job.
	ExecutionId *string `locationName:"executionId" min:"36" type:"string"`

	// Maps a batch delete document request to a specific data source sync job.
	// This is optional and should only be supplied when documents are deleted by
	// a data source connector.
	Metrics *DataSourceSyncJobMetrics `locationName:"metrics" type:"structure"`

	// The Unix time stamp when the data source synchronization job started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The status of the synchronization job. When the Status field is set to SUCCEEDED,
	// the synchronization job is done. If the status code is FAILED, the ErrorCode
	// and ErrorMessage fields give you the reason for the failure.
	Status *string `locationName:"status" type:"string" enum:"DataSourceSyncJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJob) GoString() string {
	return s.String()
}

// SetDataSourceErrorCode sets the DataSourceErrorCode field's value.
func (s *DataSourceSyncJob) SetDataSourceErrorCode(v string) *DataSourceSyncJob {
	s.DataSourceErrorCode = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DataSourceSyncJob) SetEndTime(v time.Time) *DataSourceSyncJob {
	s.EndTime = &v
	return s
}

// SetError sets the Error field's value.
func (s *DataSourceSyncJob) SetError(v *ErrorDetail) *DataSourceSyncJob {
	s.Error = v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DataSourceSyncJob) SetExecutionId(v string) *DataSourceSyncJob {
	s.ExecutionId = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *DataSourceSyncJob) SetMetrics(v *DataSourceSyncJobMetrics) *DataSourceSyncJob {
	s.Metrics = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DataSourceSyncJob) SetStartTime(v time.Time) *DataSourceSyncJob {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSyncJob) SetStatus(v string) *DataSourceSyncJob {
	s.Status = &v
	return s
}

// Maps a batch delete document request to a specific Amazon Q Business data
// source connector sync job.
type DataSourceSyncJobMetrics struct {
	_ struct{} `type:"structure"`

	// The current count of documents added from the data source during the data
	// source sync.
	DocumentsAdded *string `locationName:"documentsAdded" type:"string"`

	// The current count of documents deleted from the data source during the data
	// source sync.
	DocumentsDeleted *string `locationName:"documentsDeleted" type:"string"`

	// The current count of documents that failed to sync from the data source during
	// the data source sync.
	DocumentsFailed *string `locationName:"documentsFailed" type:"string"`

	// The current count of documents modified in the data source during the data
	// source sync.
	DocumentsModified *string `locationName:"documentsModified" type:"string"`

	// The current count of documents crawled by the ongoing sync job in the data
	// source.
	DocumentsScanned *string `locationName:"documentsScanned" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJobMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSyncJobMetrics) GoString() string {
	return s.String()
}

// SetDocumentsAdded sets the DocumentsAdded field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsAdded(v string) *DataSourceSyncJobMetrics {
	s.DocumentsAdded = &v
	return s
}

// SetDocumentsDeleted sets the DocumentsDeleted field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsDeleted(v string) *DataSourceSyncJobMetrics {
	s.DocumentsDeleted = &v
	return s
}

// SetDocumentsFailed sets the DocumentsFailed field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsFailed(v string) *DataSourceSyncJobMetrics {
	s.DocumentsFailed = &v
	return s
}

// SetDocumentsModified sets the DocumentsModified field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsModified(v string) *DataSourceSyncJobMetrics {
	s.DocumentsModified = &v
	return s
}

// SetDocumentsScanned sets the DocumentsScanned field's value.
func (s *DataSourceSyncJobMetrics) SetDocumentsScanned(v string) *DataSourceSyncJobMetrics {
	s.DocumentsScanned = &v
	return s
}

// Provides configuration information needed to connect to an Amazon VPC (Virtual
// Private Cloud).
type DataSourceVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Q Business to connect to the data source.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// A list of identifiers for subnets within your Amazon VPC. The subnets should
	// be able to connect to each other in the VPC, and they should have outgoing
	// access to the Internet through a NAT device.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceVpcConfiguration"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *DataSourceVpcConfiguration) SetSecurityGroupIds(v []*string) *DataSourceVpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DataSourceVpcConfiguration) SetSubnetIds(v []*string) *DataSourceVpcConfiguration {
	s.SubnetIds = v
	return s
}

// Provides information on boosting DATE type document attributes.
//
// For more information on how boosting document attributes work in Amazon Q
// Business, see Boosting using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
type DateAttributeBoostingConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the duration, in seconds, of a boost applies to a DATE type document
	// attribute.
	BoostingDurationInSeconds *int64 `locationName:"boostingDurationInSeconds" type:"long"`

	// Specifies how much a document attribute is boosted.
	//
	// BoostingLevel is a required field
	BoostingLevel *string `locationName:"boostingLevel" type:"string" required:"true" enum:"DocumentAttributeBoostingLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateAttributeBoostingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateAttributeBoostingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateAttributeBoostingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateAttributeBoostingConfiguration"}
	if s.BoostingLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("BoostingLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoostingDurationInSeconds sets the BoostingDurationInSeconds field's value.
func (s *DateAttributeBoostingConfiguration) SetBoostingDurationInSeconds(v int64) *DateAttributeBoostingConfiguration {
	s.BoostingDurationInSeconds = &v
	return s
}

// SetBoostingLevel sets the BoostingLevel field's value.
func (s *DateAttributeBoostingConfiguration) SetBoostingLevel(v string) *DateAttributeBoostingConfiguration {
	s.BoostingLevel = &v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApplicationInput) SetApplicationId(v string) *DeleteApplicationInput {
	s.ApplicationId = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteChatControlsConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application the chat controls have been configured
	// for.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChatControlsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChatControlsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChatControlsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChatControlsConfigurationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteChatControlsConfigurationInput) SetApplicationId(v string) *DeleteChatControlsConfigurationInput {
	s.ApplicationId = &v
	return s
}

type DeleteChatControlsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChatControlsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChatControlsConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteConversationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application associated with the conversation.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the Amazon Q Business web experience conversation being
	// deleted.
	//
	// ConversationId is a required field
	ConversationId *string `location:"uri" locationName:"conversationId" min:"36" type:"string" required:"true"`

	// The identifier of the user who is deleting the conversation.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConversationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConversationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConversationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConversationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ConversationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConversationId"))
	}
	if s.ConversationId != nil && len(*s.ConversationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConversationId", 36))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteConversationInput) SetApplicationId(v string) *DeleteConversationInput {
	s.ApplicationId = &v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *DeleteConversationInput) SetConversationId(v string) *DeleteConversationInput {
	s.ConversationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteConversationInput) SetUserId(v string) *DeleteConversationInput {
	s.UserId = &v
	return s
}

type DeleteConversationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConversationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConversationOutput) GoString() string {
	return s.String()
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application used with the data source
	// connector.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source connector that you want to delete.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" min:"36" type:"string" required:"true"`

	// The identifier of the index used with the data source connector.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteDataSourceInput) SetApplicationId(v string) *DeleteDataSourceInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceInput) SetDataSourceId(v string) *DeleteDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteDataSourceInput) SetIndexId(v string) *DeleteDataSourceInput {
	s.IndexId = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// A document deleted from an Amazon Q Business data source connector.
type DeleteDocument struct {
	_ struct{} `type:"structure"`

	// The identifier of the deleted document.
	//
	// DocumentId is a required field
	DocumentId *string `locationName:"documentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocument"}
	if s.DocumentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentId sets the DocumentId field's value.
func (s *DeleteDocument) SetDocumentId(v string) *DeleteDocument {
	s.DocumentId = &v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application in which the group mapping belongs.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source linked to the group
	//
	// A group can be tied to multiple data sources. You can delete a group from
	// accessing documents in a certain data source. For example, the groups "Research",
	// "Engineering", and "Sales and Marketing" are all tied to the company's documents
	// stored in the data sources Confluence and Salesforce. You want to delete
	// "Research" and "Engineering" groups from Salesforce, so that these groups
	// cannot access customer-related documents stored in Salesforce. Only "Sales
	// and Marketing" should access documents in the Salesforce data source.
	DataSourceId *string `location:"querystring" locationName:"dataSourceId" min:"36" type:"string"`

	// The name of the group you want to delete.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"groupName" min:"1" type:"string" required:"true"`

	// The identifier of the index you want to delete the group from.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteGroupInput) SetApplicationId(v string) *DeleteGroupInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteGroupInput) SetDataSourceId(v string) *DeleteGroupInput {
	s.DataSourceId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteGroupInput) SetIndexId(v string) *DeleteGroupInput {
	s.IndexId = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteIndexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application the Amazon Q Business
	// index is linked to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the Amazon Q Business index.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIndexInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteIndexInput) SetApplicationId(v string) *DeleteIndexInput {
	s.ApplicationId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *DeleteIndexInput) SetIndexId(v string) *DeleteIndexInput {
	s.IndexId = &v
	return s
}

type DeleteIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIndexOutput) GoString() string {
	return s.String()
}

type DeletePluginInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier the application attached to the Amazon Q Business plugin.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the plugin being deleted.
	//
	// PluginId is a required field
	PluginId *string `location:"uri" locationName:"pluginId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePluginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePluginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePluginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePluginInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.PluginId == nil {
		invalidParams.Add(request.NewErrParamRequired("PluginId"))
	}
	if s.PluginId != nil && len(*s.PluginId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PluginId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeletePluginInput) SetApplicationId(v string) *DeletePluginInput {
	s.ApplicationId = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *DeletePluginInput) SetPluginId(v string) *DeletePluginInput {
	s.PluginId = &v
	return s
}

type DeletePluginOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePluginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePluginOutput) GoString() string {
	return s.String()
}

type DeleteRetrieverInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application using the retriever.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the retriever being deleted.
	//
	// RetrieverId is a required field
	RetrieverId *string `location:"uri" locationName:"retrieverId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetrieverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetrieverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetrieverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRetrieverInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.RetrieverId == nil {
		invalidParams.Add(request.NewErrParamRequired("RetrieverId"))
	}
	if s.RetrieverId != nil && len(*s.RetrieverId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RetrieverId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteRetrieverInput) SetApplicationId(v string) *DeleteRetrieverInput {
	s.ApplicationId = &v
	return s
}

// SetRetrieverId sets the RetrieverId field's value.
func (s *DeleteRetrieverInput) SetRetrieverId(v string) *DeleteRetrieverInput {
	s.RetrieverId = &v
	return s
}

type DeleteRetrieverOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetrieverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRetrieverOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application from which the user is being deleted.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The user email being deleted.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteUserInput) SetApplicationId(v string) *DeleteUserInput {
	s.ApplicationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DeleteWebExperienceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application linked to the Amazon
	// Q Business web experience.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the Amazon Q Business web experience being deleted.
	//
	// WebExperienceId is a required field
	WebExperienceId *string `location:"uri" locationName:"webExperienceId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebExperienceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebExperienceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWebExperienceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWebExperienceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.WebExperienceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebExperienceId"))
	}
	if s.WebExperienceId != nil && len(*s.WebExperienceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WebExperienceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteWebExperienceInput) SetApplicationId(v string) *DeleteWebExperienceInput {
	s.ApplicationId = &v
	return s
}

// SetWebExperienceId sets the WebExperienceId field's value.
func (s *DeleteWebExperienceInput) SetWebExperienceId(v string) *DeleteWebExperienceInput {
	s.WebExperienceId = &v
	return s
}

type DeleteWebExperienceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebExperienceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWebExperienceOutput) GoString() string {
	return s.String()
}

// A document in an Amazon Q Business application.
type Document struct {
	_ struct{} `type:"structure"`

	// Configuration information for access permission to a document.
	AccessConfiguration *AccessConfiguration `locationName:"accessConfiguration" type:"structure"`

	// Custom attributes to apply to the document for refining Amazon Q Business
	// web experience responses.
	Attributes []*DocumentAttribute `locationName:"attributes" min:"1" type:"list"`

	// The contents of the document.
	Content *DocumentContent `locationName:"content" type:"structure"`

	// The file type of the document in the Blob field.
	//
	// If you want to index snippets or subsets of HTML documents instead of the
	// entirety of the HTML documents, you add the HTML start and closing tags (<HTML>content</HTML>)
	// around the content.
	ContentType *string `locationName:"contentType" type:"string" enum:"ContentType"`

	// The configuration information for altering document metadata and content
	// during the document ingestion process.
	DocumentEnrichmentConfiguration *DocumentEnrichmentConfiguration `locationName:"documentEnrichmentConfiguration" type:"structure"`

	// The identifier of the document.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The title of the document.
	Title *string `locationName:"title" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Document"}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.AccessConfiguration != nil {
		if err := s.AccessConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AccessConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentEnrichmentConfiguration != nil {
		if err := s.DocumentEnrichmentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DocumentEnrichmentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessConfiguration sets the AccessConfiguration field's value.
func (s *Document) SetAccessConfiguration(v *AccessConfiguration) *Document {
	s.AccessConfiguration = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Document) SetAttributes(v []*DocumentAttribute) *Document {
	s.Attributes = v
	return s
}

// SetContent sets the Content field's value.
func (s *Document) SetContent(v *DocumentContent) *Document {
	s.Content = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Document) SetContentType(v string) *Document {
	s.ContentType = &v
	return s
}

// SetDocumentEnrichmentConfiguration sets the DocumentEnrichmentConfiguration field's value.
func (s *Document) SetDocumentEnrichmentConfiguration(v *DocumentEnrichmentConfiguration) *Document {
	s.DocumentEnrichmentConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *Document) SetId(v string) *Document {
	s.Id = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Document) SetTitle(v string) *Document {
	s.Title = &v
	return s
}

// A document attribute or metadata field.
type DocumentAttribute struct {
	_ struct{} `type:"structure"`

	// The identifier for the attribute.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *DocumentAttributeValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DocumentAttribute) SetName(v string) *DocumentAttribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentAttribute) SetValue(v *DocumentAttributeValue) *DocumentAttribute {
	s.Value = v
	return s
}

// Provides information on boosting supported Amazon Q Business document attribute
// types. When an end user chat query matches document attributes that have
// been boosted, Amazon Q Business prioritizes generating responses from content
// that matches the boosted document attributes.
//
// For STRING and STRING_LIST type document attributes to be used for boosting
// on the console and the API, they must be enabled for search using the DocumentAttributeConfiguration
// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html)
// object of the UpdateIndex (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html)
// API. If you haven't enabled searching on these attributes, you can't boost
// attributes of these data types on either the console or the API.
//
// For more information on how boosting document attributes work in Amazon Q
// Business, see Boosting using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
type DocumentAttributeBoostingConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information on boosting DATE type document attributes.
	DateConfiguration *DateAttributeBoostingConfiguration `locationName:"dateConfiguration" type:"structure"`

	// Provides information on boosting NUMBER type document attributes.
	NumberConfiguration *NumberAttributeBoostingConfiguration `locationName:"numberConfiguration" type:"structure"`

	// Provides information on boosting STRING type document attributes.
	StringConfiguration *StringAttributeBoostingConfiguration `locationName:"stringConfiguration" type:"structure"`

	// Provides information on boosting STRING_LIST type document attributes.
	StringListConfiguration *StringListAttributeBoostingConfiguration `locationName:"stringListConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeBoostingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeBoostingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeBoostingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttributeBoostingConfiguration"}
	if s.DateConfiguration != nil {
		if err := s.DateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DateConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NumberConfiguration != nil {
		if err := s.NumberConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NumberConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StringConfiguration != nil {
		if err := s.StringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StringConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StringListConfiguration != nil {
		if err := s.StringListConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StringListConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateConfiguration sets the DateConfiguration field's value.
func (s *DocumentAttributeBoostingConfiguration) SetDateConfiguration(v *DateAttributeBoostingConfiguration) *DocumentAttributeBoostingConfiguration {
	s.DateConfiguration = v
	return s
}

// SetNumberConfiguration sets the NumberConfiguration field's value.
func (s *DocumentAttributeBoostingConfiguration) SetNumberConfiguration(v *NumberAttributeBoostingConfiguration) *DocumentAttributeBoostingConfiguration {
	s.NumberConfiguration = v
	return s
}

// SetStringConfiguration sets the StringConfiguration field's value.
func (s *DocumentAttributeBoostingConfiguration) SetStringConfiguration(v *StringAttributeBoostingConfiguration) *DocumentAttributeBoostingConfiguration {
	s.StringConfiguration = v
	return s
}

// SetStringListConfiguration sets the StringListConfiguration field's value.
func (s *DocumentAttributeBoostingConfiguration) SetStringListConfiguration(v *StringListAttributeBoostingConfiguration) *DocumentAttributeBoostingConfiguration {
	s.StringListConfiguration = v
	return s
}

// The condition used for the target document attribute or metadata field when
// ingesting documents into Amazon Q Business. You use this with DocumentAttributeTarget
// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html)
// to apply the condition.
//
// For example, you can create the 'Department' target field and have it prefill
// department names associated with the documents based on information in the
// 'Source_URI' field. Set the condition that if the 'Source_URI' field contains
// 'financial' in its URI value, then prefill the target field 'Department'
// with the target value 'Finance' for the document.
//
// Amazon Q Business can't create a target field if it has not already been
// created as an index field. After you create your index field, you can create
// a document metadata field using DocumentAttributeTarget. Amazon Q Business
// then will map your newly created metadata field to your index field.
type DocumentAttributeCondition struct {
	_ struct{} `type:"structure"`

	// The identifier of the document attribute used for the condition.
	//
	// For example, 'Source_URI' could be an identifier for the attribute or metadata
	// field that contains source URIs associated with the documents.
	//
	// Amazon Q Business currently doesn't support _document_body as an attribute
	// key used for the condition.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The identifier of the document attribute used for the condition.
	//
	// For example, 'Source_URI' could be an identifier for the attribute or metadata
	// field that contains source URIs associated with the documents.
	//
	// Amazon Q Business currently does not support _document_body as an attribute
	// key used for the condition.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"DocumentEnrichmentConditionOperator"`

	// The value of a document attribute. You can only provide one value for a document
	// attribute.
	Value *DocumentAttributeValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttributeCondition"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *DocumentAttributeCondition) SetKey(v string) *DocumentAttributeCondition {
	s.Key = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *DocumentAttributeCondition) SetOperator(v string) *DocumentAttributeCondition {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentAttributeCondition) SetValue(v *DocumentAttributeValue) *DocumentAttributeCondition {
	s.Value = v
	return s
}

// Configuration information for document attributes. Document attributes are
// metadata or fields associated with your documents. For example, the company
// department name associated with each document.
//
// For more information, see Understanding document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html).
type DocumentAttributeConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the document attribute.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about whether the document attribute can be used by an end user
	// to search for information on their web experience.
	Search *string `locationName:"search" type:"string" enum:"Status"`

	// The type of document attribute.
	Type *string `locationName:"type" type:"string" enum:"AttributeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttributeConfiguration"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DocumentAttributeConfiguration) SetName(v string) *DocumentAttributeConfiguration {
	s.Name = &v
	return s
}

// SetSearch sets the Search field's value.
func (s *DocumentAttributeConfiguration) SetSearch(v string) *DocumentAttributeConfiguration {
	s.Search = &v
	return s
}

// SetType sets the Type field's value.
func (s *DocumentAttributeConfiguration) SetType(v string) *DocumentAttributeConfiguration {
	s.Type = &v
	return s
}

// The target document attribute or metadata field you want to alter when ingesting
// documents into Amazon Q Business.
//
// For example, you can delete all customer identification numbers associated
// with the documents, stored in the document metadata field called 'Customer_ID'
// by setting the target key as 'Customer_ID' and the deletion flag to TRUE.
// This removes all customer ID values in the field 'Customer_ID'. This would
// scrub personally identifiable information from each document's metadata.
//
// Amazon Q Business can't create a target field if it has not already been
// created as an index field. After you create your index field, you can create
// a document metadata field using DocumentAttributeTarget (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html).
// Amazon Q Business will then map your newly created document attribute to
// your index field.
//
// You can also use this with DocumentAttributeCondition (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html).
type DocumentAttributeTarget struct {
	_ struct{} `type:"structure"`

	// TRUE to delete the existing target value for your specified target attribute
	// key. You cannot create a target value and set this to TRUE.
	AttributeValueOperator *string `locationName:"attributeValueOperator" type:"string" enum:"AttributeValueOperator"`

	// The identifier of the target document attribute or metadata field. For example,
	// 'Department' could be an identifier for the target attribute or metadata
	// field that includes the department names associated with the documents.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of a document attribute. You can only provide one value for a document
	// attribute.
	Value *DocumentAttributeValue `locationName:"value" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttributeTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttributeTarget"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeValueOperator sets the AttributeValueOperator field's value.
func (s *DocumentAttributeTarget) SetAttributeValueOperator(v string) *DocumentAttributeTarget {
	s.AttributeValueOperator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DocumentAttributeTarget) SetKey(v string) *DocumentAttributeTarget {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentAttributeTarget) SetValue(v *DocumentAttributeValue) *DocumentAttributeTarget {
	s.Value = v
	return s
}

// The value of a document attribute. You can only provide one value for a document
// attribute.
type DocumentAttributeValue struct {
	_ struct{} `type:"structure"`

	// A date expressed as an ISO 8601 string.
	//
	// It's important for the time zone to be included in the ISO 8601 date-time
	// format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time
	// format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European
	// Time.
	DateValue *time.Time `locationName:"dateValue" type:"timestamp"`

	// A long integer value.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// A list of strings.
	StringListValue []*string `locationName:"stringListValue" type:"list"`

	// A string.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValue) GoString() string {
	return s.String()
}

// SetDateValue sets the DateValue field's value.
func (s *DocumentAttributeValue) SetDateValue(v time.Time) *DocumentAttributeValue {
	s.DateValue = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *DocumentAttributeValue) SetLongValue(v int64) *DocumentAttributeValue {
	s.LongValue = &v
	return s
}

// SetStringListValue sets the StringListValue field's value.
func (s *DocumentAttributeValue) SetStringListValue(v []*string) *DocumentAttributeValue {
	s.StringListValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *DocumentAttributeValue) SetStringValue(v string) *DocumentAttributeValue {
	s.StringValue = &v
	return s
}

// The contents of a document.
type DocumentContent struct {
	_ struct{} `type:"structure"`

	// The contents of the document. Documents passed to the blob parameter must
	// be base64 encoded. Your code might not need to encode the document file bytes
	// if you're using an Amazon Web Services SDK to call Amazon Q Business APIs.
	// If you are calling the Amazon Q Business endpoint directly using REST, you
	// must base64 encode the contents before sending.
	// Blob is automatically base64 encoded/decoded by the SDK.
	Blob []byte `locationName:"blob" type:"blob"`

	// The path to the document in an Amazon S3 bucket.
	S3 *S3 `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentContent"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlob sets the Blob field's value.
func (s *DocumentContent) SetBlob(v []byte) *DocumentContent {
	s.Blob = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *DocumentContent) SetS3(v *S3) *DocumentContent {
	s.S3 = v
	return s
}

// The details of a document within an Amazon Q Business index.
type DocumentDetails struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the document was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The identifier of the document.
	DocumentId *string `locationName:"documentId" min:"1" type:"string"`

	// An error message associated with the document.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The current status of the document.
	Status *string `locationName:"status" type:"string" enum:"DocumentStatus"`

	// The timestamp for when the document was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentDetails) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DocumentDetails) SetCreatedAt(v time.Time) *DocumentDetails {
	s.CreatedAt = &v
	return s
}

// SetDocumentId sets the DocumentId field's value.
func (s *DocumentDetails) SetDocumentId(v string) *DocumentDetails {
	s.DocumentId = &v
	return s
}

// SetError sets the Error field's value.
func (s *DocumentDetails) SetError(v *ErrorDetail) *DocumentDetails {
	s.Error = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentDetails) SetStatus(v string) *DocumentDetails {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DocumentDetails) SetUpdatedAt(v time.Time) *DocumentDetails {
	s.UpdatedAt = &v
	return s
}

// Provides the configuration information for altering document metadata and
// content during the document ingestion process.
//
// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
type DocumentEnrichmentConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration information to alter document attributes or metadata fields
	// and content when ingesting documents into Amazon Q Business.
	InlineConfigurations []*InlineDocumentEnrichmentConfiguration `locationName:"inlineConfigurations" min:"1" type:"list"`

	// Provides the configuration information for invoking a Lambda function in
	// Lambda to alter document metadata and content when ingesting documents into
	// Amazon Q Business.
	//
	// You can configure your Lambda function using the PreExtractionHookConfiguration
	// parameter if you want to apply advanced alterations on the original or raw
	// documents.
	//
	// If you want to apply advanced alterations on the Amazon Q Business structured
	// documents, you must configure your Lambda function using PostExtractionHookConfiguration.
	//
	// You can only invoke one Lambda function. However, this function can invoke
	// other functions it requires.
	//
	// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
	PostExtractionHookConfiguration *HookConfiguration `locationName:"postExtractionHookConfiguration" type:"structure"`

	// Provides the configuration information for invoking a Lambda function in
	// Lambda to alter document metadata and content when ingesting documents into
	// Amazon Q Business.
	//
	// You can configure your Lambda function using the PreExtractionHookConfiguration
	// parameter if you want to apply advanced alterations on the original or raw
	// documents.
	//
	// If you want to apply advanced alterations on the Amazon Q Business structured
	// documents, you must configure your Lambda function using PostExtractionHookConfiguration.
	//
	// You can only invoke one Lambda function. However, this function can invoke
	// other functions it requires.
	//
	// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
	PreExtractionHookConfiguration *HookConfiguration `locationName:"preExtractionHookConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentEnrichmentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentEnrichmentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentEnrichmentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentEnrichmentConfiguration"}
	if s.InlineConfigurations != nil && len(s.InlineConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InlineConfigurations", 1))
	}
	if s.InlineConfigurations != nil {
		for i, v := range s.InlineConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InlineConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PostExtractionHookConfiguration != nil {
		if err := s.PostExtractionHookConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PostExtractionHookConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PreExtractionHookConfiguration != nil {
		if err := s.PreExtractionHookConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PreExtractionHookConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInlineConfigurations sets the InlineConfigurations field's value.
func (s *DocumentEnrichmentConfiguration) SetInlineConfigurations(v []*InlineDocumentEnrichmentConfiguration) *DocumentEnrichmentConfiguration {
	s.InlineConfigurations = v
	return s
}

// SetPostExtractionHookConfiguration sets the PostExtractionHookConfiguration field's value.
func (s *DocumentEnrichmentConfiguration) SetPostExtractionHookConfiguration(v *HookConfiguration) *DocumentEnrichmentConfiguration {
	s.PostExtractionHookConfiguration = v
	return s
}

// SetPreExtractionHookConfiguration sets the PreExtractionHookConfiguration field's value.
func (s *DocumentEnrichmentConfiguration) SetPreExtractionHookConfiguration(v *HookConfiguration) *DocumentEnrichmentConfiguration {
	s.PreExtractionHookConfiguration = v
	return s
}

// The identifier of the data source Amazon Q Business will generate responses
// from.
type EligibleDataSource struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source.
	DataSourceId *string `locationName:"dataSourceId" min:"36" type:"string"`

	// The identifier of the index the data source is attached to.
	IndexId *string `locationName:"indexId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EligibleDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EligibleDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EligibleDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EligibleDataSource"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *EligibleDataSource) SetDataSourceId(v string) *EligibleDataSource {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *EligibleDataSource) SetIndexId(v string) *EligibleDataSource {
	s.IndexId = &v
	return s
}

// Provides the identifier of the KMS key used to encrypt data indexed by Amazon
// Q Business. Amazon Q Business doesn't support asymmetric keys.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the KMS key. Amazon Q Business doesn't support asymmetric
	// keys.
	//
	// KmsKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EncryptionConfiguration's
	// String and GoString methods.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *EncryptionConfiguration) SetKmsKeyId(v string) *EncryptionConfiguration {
	s.KmsKeyId = &v
	return s
}

// The end of the streaming input for the Chat API.
type EndOfInputEvent struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndOfInputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndOfInputEvent) GoString() string {
	return s.String()
}

// The EndOfInputEvent is and event in the ChatInputStream group of events.
func (s *EndOfInputEvent) eventChatInputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the EndOfInputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *EndOfInputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *EndOfInputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	return msg, err
}

// Provides information about a data source sync error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The code associated with the data source sync error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// The message explaining the data source sync error.
	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// A failed file upload during web experience chat.
type FailedAttachmentEvent struct {
	_ struct{} `type:"structure"`

	// The details of a file uploaded during chat.
	Attachment *AttachmentOutput_ `locationName:"attachment" type:"structure"`

	// The identifier of the conversation associated with the failed file upload.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// The identifier of the AI-generated message associated with the file upload.
	SystemMessageId *string `locationName:"systemMessageId" min:"36" type:"string"`

	// The identifier of the end user chat message associated with the file upload.
	UserMessageId *string `locationName:"userMessageId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedAttachmentEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedAttachmentEvent) GoString() string {
	return s.String()
}

// SetAttachment sets the Attachment field's value.
func (s *FailedAttachmentEvent) SetAttachment(v *AttachmentOutput_) *FailedAttachmentEvent {
	s.Attachment = v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *FailedAttachmentEvent) SetConversationId(v string) *FailedAttachmentEvent {
	s.ConversationId = &v
	return s
}

// SetSystemMessageId sets the SystemMessageId field's value.
func (s *FailedAttachmentEvent) SetSystemMessageId(v string) *FailedAttachmentEvent {
	s.SystemMessageId = &v
	return s
}

// SetUserMessageId sets the UserMessageId field's value.
func (s *FailedAttachmentEvent) SetUserMessageId(v string) *FailedAttachmentEvent {
	s.UserMessageId = &v
	return s
}

// The FailedAttachmentEvent is and event in the ChatOutputStream group of events.
func (s *FailedAttachmentEvent) eventChatOutputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the FailedAttachmentEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *FailedAttachmentEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *FailedAttachmentEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// A list of documents that could not be removed from an Amazon Q Business index.
// Each entry contains an error message that indicates why the document couldn't
// be removed from the index.
type FailedDocument struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business data source connector that contains
	// the failed document.
	DataSourceId *string `locationName:"dataSourceId" min:"36" type:"string"`

	// An explanation for why the document couldn't be removed from the index.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The identifier of the document that couldn't be removed from the Amazon Q
	// Business index.
	Id *string `locationName:"id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedDocument) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *FailedDocument) SetDataSourceId(v string) *FailedDocument {
	s.DataSourceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *FailedDocument) SetError(v *ErrorDetail) *FailedDocument {
	s.Error = v
	return s
}

// SetId sets the Id field's value.
func (s *FailedDocument) SetId(v string) *FailedDocument {
	s.Id = &v
	return s
}

type GetApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationInput) SetApplicationId(v string) *GetApplicationInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Q Business application.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The identifier of the Amazon Q Business application.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// Settings for whether end users can upload files directly during chat.
	AttachmentsConfiguration *AppliedAttachmentsConfiguration `locationName:"attachmentsConfiguration" type:"structure"`

	// The Unix timestamp when the Amazon Q Business application was last updated.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A description for the Amazon Q Business application.
	Description *string `locationName:"description" type:"string"`

	// The name of the Amazon Q Business application.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The identifier of the Amazon Web Services KMS key that is used to encrypt
	// your data. Amazon Q Business doesn't support asymmetric keys.
	EncryptionConfiguration *EncryptionConfiguration `locationName:"encryptionConfiguration" type:"structure"`

	// If the Status field is set to ERROR, the ErrorMessage field contains a description
	// of the error that caused the synchronization to fail.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS IAM Identity Center instance attached
	// to your Amazon Q Business application.
	IdentityCenterApplicationArn *string `locationName:"identityCenterApplicationArn" min:"10" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM with permissions to access your
	// CloudWatch logs and metrics.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the Amazon Q Business application.
	Status *string `locationName:"status" type:"string" enum:"ApplicationStatus"`

	// The Unix timestamp when the Amazon Q Business application was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationOutput) SetApplicationArn(v string) *GetApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationOutput) SetApplicationId(v string) *GetApplicationOutput {
	s.ApplicationId = &v
	return s
}

// SetAttachmentsConfiguration sets the AttachmentsConfiguration field's value.
func (s *GetApplicationOutput) SetAttachmentsConfiguration(v *AppliedAttachmentsConfiguration) *GetApplicationOutput {
	s.AttachmentsConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetApplicationOutput) SetCreatedAt(v time.Time) *GetApplicationOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApplicationOutput) SetDescription(v string) *GetApplicationOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetApplicationOutput) SetDisplayName(v string) *GetApplicationOutput {
	s.DisplayName = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *GetApplicationOutput) SetEncryptionConfiguration(v *EncryptionConfiguration) *GetApplicationOutput {
	s.EncryptionConfiguration = v
	return s
}

// SetError sets the Error field's value.
func (s *GetApplicationOutput) SetError(v *ErrorDetail) *GetApplicationOutput {
	s.Error = v
	return s
}

// SetIdentityCenterApplicationArn sets the IdentityCenterApplicationArn field's value.
func (s *GetApplicationOutput) SetIdentityCenterApplicationArn(v string) *GetApplicationOutput {
	s.IdentityCenterApplicationArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetApplicationOutput) SetRoleArn(v string) *GetApplicationOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetApplicationOutput) SetStatus(v string) *GetApplicationOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetApplicationOutput) SetUpdatedAt(v time.Time) *GetApplicationOutput {
	s.UpdatedAt = &v
	return s
}

type GetChatControlsConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application for which the chat controls are configured.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The maximum number of configured chat controls to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business chat
	// controls configured.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChatControlsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChatControlsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChatControlsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChatControlsConfigurationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetChatControlsConfigurationInput) SetApplicationId(v string) *GetChatControlsConfigurationInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetChatControlsConfigurationInput) SetMaxResults(v int64) *GetChatControlsConfigurationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetChatControlsConfigurationInput) SetNextToken(v string) *GetChatControlsConfigurationInput {
	s.NextToken = &v
	return s
}

type GetChatControlsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The phrases blocked from chat by your chat control configuration.
	BlockedPhrases *BlockedPhrasesConfiguration `locationName:"blockedPhrases" type:"structure"`

	// The configuration details for CREATOR_MODE.
	CreatorModeConfiguration *AppliedCreatorModeConfiguration `locationName:"creatorModeConfiguration" type:"structure"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business chat
	// controls configured.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The response scope configured for a Amazon Q Business application. This determines
	// whether your application uses its retrieval augmented generation (RAG) system
	// to generate answers only from your enterprise data, or also uses the large
	// language models (LLM) knowledge to respons to end user questions in chat.
	ResponseScope *string `locationName:"responseScope" type:"string" enum:"ResponseScope"`

	// The topic specific controls configured for a Amazon Q Business application.
	TopicConfigurations []*TopicConfiguration `locationName:"topicConfigurations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChatControlsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChatControlsConfigurationOutput) GoString() string {
	return s.String()
}

// SetBlockedPhrases sets the BlockedPhrases field's value.
func (s *GetChatControlsConfigurationOutput) SetBlockedPhrases(v *BlockedPhrasesConfiguration) *GetChatControlsConfigurationOutput {
	s.BlockedPhrases = v
	return s
}

// SetCreatorModeConfiguration sets the CreatorModeConfiguration field's value.
func (s *GetChatControlsConfigurationOutput) SetCreatorModeConfiguration(v *AppliedCreatorModeConfiguration) *GetChatControlsConfigurationOutput {
	s.CreatorModeConfiguration = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetChatControlsConfigurationOutput) SetNextToken(v string) *GetChatControlsConfigurationOutput {
	s.NextToken = &v
	return s
}

// SetResponseScope sets the ResponseScope field's value.
func (s *GetChatControlsConfigurationOutput) SetResponseScope(v string) *GetChatControlsConfigurationOutput {
	s.ResponseScope = &v
	return s
}

// SetTopicConfigurations sets the TopicConfigurations field's value.
func (s *GetChatControlsConfigurationOutput) SetTopicConfigurations(v []*TopicConfiguration) *GetChatControlsConfigurationOutput {
	s.TopicConfigurations = v
	return s
}

type GetDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source connector.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" min:"36" type:"string" required:"true"`

	// The identfier of the index used with the data source connector.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDataSourceInput) SetApplicationId(v string) *GetDataSourceInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceInput) SetDataSourceId(v string) *GetDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *GetDataSourceInput) SetIndexId(v string) *GetDataSourceInput {
	s.IndexId = &v
	return s
}

type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// The Unix timestamp when the data source connector was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string `locationName:"dataSourceArn" type:"string"`

	// The identifier of the data source connector.
	DataSourceId *string `locationName:"dataSourceId" min:"36" type:"string"`

	// The description for the data source connector.
	Description *string `locationName:"description" type:"string"`

	// The name for the data source connector.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// Provides the configuration information for altering document metadata and
	// content during the document ingestion process.
	//
	// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
	DocumentEnrichmentConfiguration *DocumentEnrichmentConfiguration `locationName:"documentEnrichmentConfiguration" type:"structure"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// description of the error that caused the data source connector to fail.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The identifier of the index linked to the data source connector.
	IndexId *string `locationName:"indexId" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the role with permission to access the
	// data source and required resources.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the data source connector. When the Status field value
	// is FAILED, the ErrorMessage field contains a description of the error that
	// caused the data source connector to fail.
	Status *string `locationName:"status" type:"string" enum:"DataSourceStatus"`

	// The schedule for Amazon Q Business to update the index.
	SyncSchedule *string `locationName:"syncSchedule" type:"string"`

	// The type of the data source connector. For example, S3.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The Unix timestamp when the data source connector was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// Configuration information for an Amazon VPC (Virtual Private Cloud) to connect
	// to your data source.
	VpcConfiguration *DataSourceVpcConfiguration `locationName:"vpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetDataSourceOutput) SetApplicationId(v string) *GetDataSourceOutput {
	s.ApplicationId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDataSourceOutput) SetCreatedAt(v time.Time) *GetDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *GetDataSourceOutput) SetDataSourceArn(v string) *GetDataSourceOutput {
	s.DataSourceArn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceOutput) SetDataSourceId(v string) *GetDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDataSourceOutput) SetDescription(v string) *GetDataSourceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetDataSourceOutput) SetDisplayName(v string) *GetDataSourceOutput {
	s.DisplayName = &v
	return s
}

// SetDocumentEnrichmentConfiguration sets the DocumentEnrichmentConfiguration field's value.
func (s *GetDataSourceOutput) SetDocumentEnrichmentConfiguration(v *DocumentEnrichmentConfiguration) *GetDataSourceOutput {
	s.DocumentEnrichmentConfiguration = v
	return s
}

// SetError sets the Error field's value.
func (s *GetDataSourceOutput) SetError(v *ErrorDetail) *GetDataSourceOutput {
	s.Error = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *GetDataSourceOutput) SetIndexId(v string) *GetDataSourceOutput {
	s.IndexId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetDataSourceOutput) SetRoleArn(v string) *GetDataSourceOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDataSourceOutput) SetStatus(v string) *GetDataSourceOutput {
	s.Status = &v
	return s
}

// SetSyncSchedule sets the SyncSchedule field's value.
func (s *GetDataSourceOutput) SetSyncSchedule(v string) *GetDataSourceOutput {
	s.SyncSchedule = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetDataSourceOutput) SetType(v string) *GetDataSourceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDataSourceOutput) SetUpdatedAt(v time.Time) *GetDataSourceOutput {
	s.UpdatedAt = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *GetDataSourceOutput) SetVpcConfiguration(v *DataSourceVpcConfiguration) *GetDataSourceOutput {
	s.VpcConfiguration = v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application id the group is attached to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source the group is attached to.
	DataSourceId *string `location:"querystring" locationName:"dataSourceId" min:"36" type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"groupName" min:"1" type:"string" required:"true"`

	// The identifier of the index the group is attached to.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetGroupInput) SetApplicationId(v string) *GetGroupInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetGroupInput) SetDataSourceId(v string) *GetGroupInput {
	s.DataSourceId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *GetGroupInput) SetIndexId(v string) *GetGroupInput {
	s.IndexId = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the group.
	Status *GroupStatusDetail `locationName:"status" type:"structure"`

	// The status history of the group.
	StatusHistory []*GroupStatusDetail `locationName:"statusHistory" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetGroupOutput) SetStatus(v *GroupStatusDetail) *GetGroupOutput {
	s.Status = v
	return s
}

// SetStatusHistory sets the StatusHistory field's value.
func (s *GetGroupOutput) SetStatusHistory(v []*GroupStatusDetail) *GetGroupOutput {
	s.StatusHistory = v
	return s
}

type GetIndexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application connected to the index.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the Amazon Q Business index you want information on.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIndexInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetIndexInput) SetApplicationId(v string) *GetIndexInput {
	s.ApplicationId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *GetIndexInput) SetIndexId(v string) *GetIndexInput {
	s.IndexId = &v
	return s
}

type GetIndexOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application associated with the index.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// The storage capacity units chosen for your Amazon Q Business index.
	CapacityConfiguration *IndexCapacityConfiguration `locationName:"capacityConfiguration" type:"structure"`

	// The Unix timestamp when the Amazon Q Business index was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description for the Amazon Q Business index.
	Description *string `locationName:"description" type:"string"`

	// The name of the Amazon Q Business index.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// Configuration information for document attributes or metadata. Document metadata
	// are fields associated with your documents. For example, the company department
	// name associated with each document. For more information, see Understanding
	// document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes).
	DocumentAttributeConfigurations []*DocumentAttributeConfiguration `locationName:"documentAttributeConfigurations" min:"1" type:"list"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// message that explains why.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Q Business index.
	IndexArn *string `locationName:"indexArn" type:"string"`

	// The identifier of the Amazon Q Business index.
	IndexId *string `locationName:"indexId" min:"36" type:"string"`

	// Provides information about the number of documents indexed.
	IndexStatistics *IndexStatistics `locationName:"indexStatistics" type:"structure"`

	// The current status of the index. When the value is ACTIVE, the index is ready
	// for use. If the Status field value is FAILED, the ErrorMessage field contains
	// a message that explains why.
	Status *string `locationName:"status" type:"string" enum:"IndexStatus"`

	// The type of index attached to your Amazon Q Business application.
	Type *string `locationName:"type" type:"string" enum:"IndexType"`

	// The Unix timestamp when the Amazon Q Business index was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIndexOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetIndexOutput) SetApplicationId(v string) *GetIndexOutput {
	s.ApplicationId = &v
	return s
}

// SetCapacityConfiguration sets the CapacityConfiguration field's value.
func (s *GetIndexOutput) SetCapacityConfiguration(v *IndexCapacityConfiguration) *GetIndexOutput {
	s.CapacityConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetIndexOutput) SetCreatedAt(v time.Time) *GetIndexOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetIndexOutput) SetDescription(v string) *GetIndexOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetIndexOutput) SetDisplayName(v string) *GetIndexOutput {
	s.DisplayName = &v
	return s
}

// SetDocumentAttributeConfigurations sets the DocumentAttributeConfigurations field's value.
func (s *GetIndexOutput) SetDocumentAttributeConfigurations(v []*DocumentAttributeConfiguration) *GetIndexOutput {
	s.DocumentAttributeConfigurations = v
	return s
}

// SetError sets the Error field's value.
func (s *GetIndexOutput) SetError(v *ErrorDetail) *GetIndexOutput {
	s.Error = v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *GetIndexOutput) SetIndexArn(v string) *GetIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *GetIndexOutput) SetIndexId(v string) *GetIndexOutput {
	s.IndexId = &v
	return s
}

// SetIndexStatistics sets the IndexStatistics field's value.
func (s *GetIndexOutput) SetIndexStatistics(v *IndexStatistics) *GetIndexOutput {
	s.IndexStatistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetIndexOutput) SetStatus(v string) *GetIndexOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetIndexOutput) SetType(v string) *GetIndexOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetIndexOutput) SetUpdatedAt(v time.Time) *GetIndexOutput {
	s.UpdatedAt = &v
	return s
}

type GetPluginInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application which contains the plugin.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the plugin.
	//
	// PluginId is a required field
	PluginId *string `location:"uri" locationName:"pluginId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPluginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPluginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPluginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPluginInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.PluginId == nil {
		invalidParams.Add(request.NewErrParamRequired("PluginId"))
	}
	if s.PluginId != nil && len(*s.PluginId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PluginId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetPluginInput) SetApplicationId(v string) *GetPluginInput {
	s.ApplicationId = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *GetPluginInput) SetPluginId(v string) *GetPluginInput {
	s.PluginId = &v
	return s
}

type GetPluginOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application which contains the plugin.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// Authentication configuration information for an Amazon Q Business plugin.
	AuthConfiguration *PluginAuthConfiguration `locationName:"authConfiguration" type:"structure"`

	// The current status of a plugin. A plugin is modified asynchronously.
	BuildStatus *string `locationName:"buildStatus" type:"string" enum:"PluginBuildStatus"`

	// The timestamp for when the plugin was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Configuration information required to create a custom plugin.
	CustomPluginConfiguration *CustomPluginConfiguration `locationName:"customPluginConfiguration" type:"structure"`

	// The name of the plugin.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role with permission to access resources
	// needed to create the plugin.
	PluginArn *string `locationName:"pluginArn" type:"string"`

	// The identifier of the plugin.
	PluginId *string `locationName:"pluginId" min:"36" type:"string"`

	// The source URL used for plugin configuration.
	ServerUrl *string `locationName:"serverUrl" min:"1" type:"string"`

	// The current state of the plugin.
	State *string `locationName:"state" type:"string" enum:"PluginState"`

	// The type of the plugin.
	Type *string `locationName:"type" type:"string" enum:"PluginType"`

	// The timestamp for when the plugin was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPluginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPluginOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetPluginOutput) SetApplicationId(v string) *GetPluginOutput {
	s.ApplicationId = &v
	return s
}

// SetAuthConfiguration sets the AuthConfiguration field's value.
func (s *GetPluginOutput) SetAuthConfiguration(v *PluginAuthConfiguration) *GetPluginOutput {
	s.AuthConfiguration = v
	return s
}

// SetBuildStatus sets the BuildStatus field's value.
func (s *GetPluginOutput) SetBuildStatus(v string) *GetPluginOutput {
	s.BuildStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetPluginOutput) SetCreatedAt(v time.Time) *GetPluginOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomPluginConfiguration sets the CustomPluginConfiguration field's value.
func (s *GetPluginOutput) SetCustomPluginConfiguration(v *CustomPluginConfiguration) *GetPluginOutput {
	s.CustomPluginConfiguration = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetPluginOutput) SetDisplayName(v string) *GetPluginOutput {
	s.DisplayName = &v
	return s
}

// SetPluginArn sets the PluginArn field's value.
func (s *GetPluginOutput) SetPluginArn(v string) *GetPluginOutput {
	s.PluginArn = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *GetPluginOutput) SetPluginId(v string) *GetPluginOutput {
	s.PluginId = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *GetPluginOutput) SetServerUrl(v string) *GetPluginOutput {
	s.ServerUrl = &v
	return s
}

// SetState sets the State field's value.
func (s *GetPluginOutput) SetState(v string) *GetPluginOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetPluginOutput) SetType(v string) *GetPluginOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetPluginOutput) SetUpdatedAt(v time.Time) *GetPluginOutput {
	s.UpdatedAt = &v
	return s
}

type GetRetrieverInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application using the retriever.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the retriever.
	//
	// RetrieverId is a required field
	RetrieverId *string `location:"uri" locationName:"retrieverId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetrieverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetrieverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRetrieverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRetrieverInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.RetrieverId == nil {
		invalidParams.Add(request.NewErrParamRequired("RetrieverId"))
	}
	if s.RetrieverId != nil && len(*s.RetrieverId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RetrieverId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetRetrieverInput) SetApplicationId(v string) *GetRetrieverInput {
	s.ApplicationId = &v
	return s
}

// SetRetrieverId sets the RetrieverId field's value.
func (s *GetRetrieverInput) SetRetrieverId(v string) *GetRetrieverInput {
	s.RetrieverId = &v
	return s
}

type GetRetrieverOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application using the retriever.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// Provides information on how the retriever used for your Amazon Q Business
	// application is configured.
	Configuration *RetrieverConfiguration `locationName:"configuration" type:"structure"`

	// The Unix timestamp when the retriever was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The name of the retriever.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the retriever.
	RetrieverArn *string `locationName:"retrieverArn" type:"string"`

	// The identifier of the retriever.
	RetrieverId *string `locationName:"retrieverId" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the role with the permission to access
	// the retriever and required resources.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the retriever.
	Status *string `locationName:"status" type:"string" enum:"RetrieverStatus"`

	// The type of the retriever.
	Type *string `locationName:"type" type:"string" enum:"RetrieverType"`

	// The Unix timestamp when the retriever was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetrieverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetrieverOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetRetrieverOutput) SetApplicationId(v string) *GetRetrieverOutput {
	s.ApplicationId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetRetrieverOutput) SetConfiguration(v *RetrieverConfiguration) *GetRetrieverOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetRetrieverOutput) SetCreatedAt(v time.Time) *GetRetrieverOutput {
	s.CreatedAt = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetRetrieverOutput) SetDisplayName(v string) *GetRetrieverOutput {
	s.DisplayName = &v
	return s
}

// SetRetrieverArn sets the RetrieverArn field's value.
func (s *GetRetrieverOutput) SetRetrieverArn(v string) *GetRetrieverOutput {
	s.RetrieverArn = &v
	return s
}

// SetRetrieverId sets the RetrieverId field's value.
func (s *GetRetrieverOutput) SetRetrieverId(v string) *GetRetrieverOutput {
	s.RetrieverId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetRetrieverOutput) SetRoleArn(v string) *GetRetrieverOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetRetrieverOutput) SetStatus(v string) *GetRetrieverOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetRetrieverOutput) SetType(v string) *GetRetrieverOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetRetrieverOutput) SetUpdatedAt(v time.Time) *GetRetrieverOutput {
	s.UpdatedAt = &v
	return s
}

type GetUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application connected to the user.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The user email address attached to the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetUserInput) SetApplicationId(v string) *GetUserInput {
	s.ApplicationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserInput) SetUserId(v string) *GetUserInput {
	s.UserId = &v
	return s
}

type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// A list of user aliases attached to a user.
	UserAliases []*UserAlias `locationName:"userAliases" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUserOutput) GoString() string {
	return s.String()
}

// SetUserAliases sets the UserAliases field's value.
func (s *GetUserOutput) SetUserAliases(v []*UserAlias) *GetUserOutput {
	s.UserAliases = v
	return s
}

type GetWebExperienceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application linked to the web experience.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the Amazon Q Business web experience.
	//
	// WebExperienceId is a required field
	WebExperienceId *string `location:"uri" locationName:"webExperienceId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWebExperienceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWebExperienceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebExperienceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWebExperienceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.WebExperienceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebExperienceId"))
	}
	if s.WebExperienceId != nil && len(*s.WebExperienceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WebExperienceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetWebExperienceInput) SetApplicationId(v string) *GetWebExperienceInput {
	s.ApplicationId = &v
	return s
}

// SetWebExperienceId sets the WebExperienceId field's value.
func (s *GetWebExperienceInput) SetWebExperienceId(v string) *GetWebExperienceInput {
	s.WebExperienceId = &v
	return s
}

type GetWebExperienceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application linked to the web experience.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// The authentication configuration information for your Amazon Q Business web
	// experience.
	//
	// Deprecated: Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity Center for user management.
	AuthenticationConfiguration *WebExperienceAuthConfiguration `locationName:"authenticationConfiguration" deprecated:"true" type:"structure"`

	// The Unix timestamp when the Amazon Q Business web experience was last created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The endpoint of your Amazon Q Business web experience.
	DefaultEndpoint *string `locationName:"defaultEndpoint" min:"1" type:"string"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// description of the error that caused the data source connector to fail.
	Error *ErrorDetail `locationName:"error" type:"structure"`

	// The Amazon Resource Name (ARN) of the service role attached to your web experience.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// Determines whether sample prompts are enabled in the web experience for an
	// end user.
	SamplePromptsControlMode *string `locationName:"samplePromptsControlMode" type:"string" enum:"WebExperienceSamplePromptsControlMode"`

	// The current status of the Amazon Q Business web experience. When the Status
	// field value is FAILED, the ErrorMessage field contains a description of the
	// error that caused the data source connector to fail.
	Status *string `locationName:"status" type:"string" enum:"WebExperienceStatus"`

	// The subtitle for your Amazon Q Business web experience.
	Subtitle *string `locationName:"subtitle" type:"string"`

	// The title for your Amazon Q Business web experience.
	Title *string `locationName:"title" type:"string"`

	// The Unix timestamp when the Amazon Q Business web experience was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the role with the permission to access
	// the Amazon Q Business web experience and required resources.
	WebExperienceArn *string `locationName:"webExperienceArn" type:"string"`

	// The identifier of the Amazon Q Business web experience.
	WebExperienceId *string `locationName:"webExperienceId" min:"36" type:"string"`

	// The customized welcome message for end users of an Amazon Q Business web
	// experience.
	WelcomeMessage *string `locationName:"welcomeMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWebExperienceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWebExperienceOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetWebExperienceOutput) SetApplicationId(v string) *GetWebExperienceOutput {
	s.ApplicationId = &v
	return s
}

// SetAuthenticationConfiguration sets the AuthenticationConfiguration field's value.
func (s *GetWebExperienceOutput) SetAuthenticationConfiguration(v *WebExperienceAuthConfiguration) *GetWebExperienceOutput {
	s.AuthenticationConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetWebExperienceOutput) SetCreatedAt(v time.Time) *GetWebExperienceOutput {
	s.CreatedAt = &v
	return s
}

// SetDefaultEndpoint sets the DefaultEndpoint field's value.
func (s *GetWebExperienceOutput) SetDefaultEndpoint(v string) *GetWebExperienceOutput {
	s.DefaultEndpoint = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetWebExperienceOutput) SetError(v *ErrorDetail) *GetWebExperienceOutput {
	s.Error = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetWebExperienceOutput) SetRoleArn(v string) *GetWebExperienceOutput {
	s.RoleArn = &v
	return s
}

// SetSamplePromptsControlMode sets the SamplePromptsControlMode field's value.
func (s *GetWebExperienceOutput) SetSamplePromptsControlMode(v string) *GetWebExperienceOutput {
	s.SamplePromptsControlMode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWebExperienceOutput) SetStatus(v string) *GetWebExperienceOutput {
	s.Status = &v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *GetWebExperienceOutput) SetSubtitle(v string) *GetWebExperienceOutput {
	s.Subtitle = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GetWebExperienceOutput) SetTitle(v string) *GetWebExperienceOutput {
	s.Title = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetWebExperienceOutput) SetUpdatedAt(v time.Time) *GetWebExperienceOutput {
	s.UpdatedAt = &v
	return s
}

// SetWebExperienceArn sets the WebExperienceArn field's value.
func (s *GetWebExperienceOutput) SetWebExperienceArn(v string) *GetWebExperienceOutput {
	s.WebExperienceArn = &v
	return s
}

// SetWebExperienceId sets the WebExperienceId field's value.
func (s *GetWebExperienceOutput) SetWebExperienceId(v string) *GetWebExperienceOutput {
	s.WebExperienceId = &v
	return s
}

// SetWelcomeMessage sets the WelcomeMessage field's value.
func (s *GetWebExperienceOutput) SetWelcomeMessage(v string) *GetWebExperienceOutput {
	s.WelcomeMessage = &v
	return s
}

// A list of users or sub groups that belong to a group. This is for generating
// Amazon Q Business chat results only from document a user has access to.
type GroupMembers struct {
	_ struct{} `type:"structure"`

	// A list of sub groups that belong to a group. For example, the sub groups
	// "Research", "Engineering", and "Sales and Marketing" all belong to the group
	// "Company".
	MemberGroups []*MemberGroup `locationName:"memberGroups" min:"1" type:"list"`

	// A list of users that belong to a group. For example, a list of interns all
	// belong to the "Interns" group.
	MemberUsers []*MemberUser `locationName:"memberUsers" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMembers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupMembers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupMembers"}
	if s.MemberGroups != nil && len(s.MemberGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberGroups", 1))
	}
	if s.MemberUsers != nil && len(s.MemberUsers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberUsers", 1))
	}
	if s.MemberGroups != nil {
		for i, v := range s.MemberGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MemberGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MemberUsers != nil {
		for i, v := range s.MemberUsers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MemberUsers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemberGroups sets the MemberGroups field's value.
func (s *GroupMembers) SetMemberGroups(v []*MemberGroup) *GroupMembers {
	s.MemberGroups = v
	return s
}

// SetMemberUsers sets the MemberUsers field's value.
func (s *GroupMembers) SetMemberUsers(v []*MemberUser) *GroupMembers {
	s.MemberUsers = v
	return s
}

// Provides the details of a group's status.
type GroupStatusDetail struct {
	_ struct{} `type:"structure"`

	// The details of an error associated a group status.
	ErrorDetail *ErrorDetail `locationName:"errorDetail" type:"structure"`

	// The Unix timestamp when the Amazon Q Business application was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The status of a group.
	Status *string `locationName:"status" type:"string" enum:"GroupStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupStatusDetail) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *GroupStatusDetail) SetErrorDetail(v *ErrorDetail) *GroupStatusDetail {
	s.ErrorDetail = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GroupStatusDetail) SetLastUpdatedAt(v time.Time) *GroupStatusDetail {
	s.LastUpdatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GroupStatusDetail) SetStatus(v string) *GroupStatusDetail {
	s.Status = &v
	return s
}

// Summary information for groups.
type GroupSummary struct {
	_ struct{} `type:"structure"`

	// The name of the group the summary information is for.
	GroupName *string `locationName:"groupName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupSummary) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *GroupSummary) SetGroupName(v string) *GroupSummary {
	s.GroupName = &v
	return s
}

// Provides the configuration information for invoking a Lambda function in
// Lambda to alter document metadata and content when ingesting documents into
// Amazon Q Business.
//
// You can configure your Lambda function using the PreExtractionHookConfiguration
// parameter if you want to apply advanced alterations on the original or raw
// documents.
//
// If you want to apply advanced alterations on the Amazon Q Business structured
// documents, you must configure your Lambda function using PostExtractionHookConfiguration.
//
// You can only invoke one Lambda function. However, this function can invoke
// other functions it requires.
//
// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
type HookConfiguration struct {
	_ struct{} `type:"structure"`

	// The condition used for when a Lambda function should be invoked.
	//
	// For example, you can specify a condition that if there are empty date-time
	// values, then Amazon Q Business should invoke a function that inserts the
	// current date-time.
	InvocationCondition *DocumentAttributeCondition `locationName:"invocationCondition" type:"structure"`

	// The Amazon Resource Name (ARN) of a role with permission to run a Lambda
	// function during ingestion. For more information, see IAM roles for Custom
	// Document Enrichment (CDE) (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html#cde-iam-role).
	LambdaArn *string `locationName:"lambdaArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of a role with permission to run PreExtractionHookConfiguration
	// and PostExtractionHookConfiguration for altering document metadata and content
	// during the document ingestion process.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// Stores the original, raw documents or the structured, parsed documents before
	// and after altering them. For more information, see Data contracts for Lambda
	// functions (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts).
	S3BucketName *string `locationName:"s3BucketName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HookConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HookConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HookConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HookConfiguration"}
	if s.LambdaArn != nil && len(*s.LambdaArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaArn", 1))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 1))
	}
	if s.InvocationCondition != nil {
		if err := s.InvocationCondition.Validate(); err != nil {
			invalidParams.AddNested("InvocationCondition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvocationCondition sets the InvocationCondition field's value.
func (s *HookConfiguration) SetInvocationCondition(v *DocumentAttributeCondition) *HookConfiguration {
	s.InvocationCondition = v
	return s
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *HookConfiguration) SetLambdaArn(v string) *HookConfiguration {
	s.LambdaArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *HookConfiguration) SetRoleArn(v string) *HookConfiguration {
	s.RoleArn = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *HookConfiguration) SetS3BucketName(v string) *HookConfiguration {
	s.S3BucketName = &v
	return s
}

// Summary information for your Amazon Q Business index.
type Index struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the index was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The name of the index.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The identifier for the index.
	IndexId *string `locationName:"indexId" min:"36" type:"string"`

	// The current status of the index. When the status is ACTIVE, the index is
	// ready.
	Status *string `locationName:"status" type:"string" enum:"IndexStatus"`

	// The Unix timestamp when the index was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Index) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Index) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Index) SetCreatedAt(v time.Time) *Index {
	s.CreatedAt = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Index) SetDisplayName(v string) *Index {
	s.DisplayName = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *Index) SetIndexId(v string) *Index {
	s.IndexId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Index) SetStatus(v string) *Index {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Index) SetUpdatedAt(v time.Time) *Index {
	s.UpdatedAt = &v
	return s
}

// Provides information about index capacity configuration.
type IndexCapacityConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of storage units configured for an Amazon Q Business index.
	Units *int64 `locationName:"units" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexCapacityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexCapacityConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexCapacityConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexCapacityConfiguration"}
	if s.Units != nil && *s.Units < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Units", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnits sets the Units field's value.
func (s *IndexCapacityConfiguration) SetUnits(v int64) *IndexCapacityConfiguration {
	s.Units = &v
	return s
}

// Provides information about the number of documents in an index.
type IndexStatistics struct {
	_ struct{} `type:"structure"`

	// The number of documents indexed.
	TextDocumentStatistics *TextDocumentStatistics `locationName:"textDocumentStatistics" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexStatistics) GoString() string {
	return s.String()
}

// SetTextDocumentStatistics sets the TextDocumentStatistics field's value.
func (s *IndexStatistics) SetTextDocumentStatistics(v *TextDocumentStatistics) *IndexStatistics {
	s.TextDocumentStatistics = v
	return s
}

// Provides the configuration information for applying basic logic to alter
// document metadata and content when ingesting documents into Amazon Q Business.
//
// To apply advanced logic, to go beyond what you can do with basic logic, see
// HookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_HookConfiguration.html).
//
// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
type InlineDocumentEnrichmentConfiguration struct {
	_ struct{} `type:"structure"`

	// The condition used for the target document attribute or metadata field when
	// ingesting documents into Amazon Q Business. You use this with DocumentAttributeTarget
	// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html)
	// to apply the condition.
	//
	// For example, you can create the 'Department' target field and have it prefill
	// department names associated with the documents based on information in the
	// 'Source_URI' field. Set the condition that if the 'Source_URI' field contains
	// 'financial' in its URI value, then prefill the target field 'Department'
	// with the target value 'Finance' for the document.
	//
	// Amazon Q Business can't create a target field if it has not already been
	// created as an index field. After you create your index field, you can create
	// a document metadata field using DocumentAttributeTarget. Amazon Q Business
	// then will map your newly created metadata field to your index field.
	Condition *DocumentAttributeCondition `locationName:"condition" type:"structure"`

	// TRUE to delete content if the condition used for the target attribute is
	// met.
	DocumentContentOperator *string `locationName:"documentContentOperator" type:"string" enum:"DocumentContentOperator"`

	// The target document attribute or metadata field you want to alter when ingesting
	// documents into Amazon Q Business.
	//
	// For example, you can delete all customer identification numbers associated
	// with the documents, stored in the document metadata field called 'Customer_ID'
	// by setting the target key as 'Customer_ID' and the deletion flag to TRUE.
	// This removes all customer ID values in the field 'Customer_ID'. This would
	// scrub personally identifiable information from each document's metadata.
	//
	// Amazon Q Business can't create a target field if it has not already been
	// created as an index field. After you create your index field, you can create
	// a document metadata field using DocumentAttributeTarget (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html).
	// Amazon Q Business will then map your newly created document attribute to
	// your index field.
	//
	// You can also use this with DocumentAttributeCondition (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html).
	Target *DocumentAttributeTarget `locationName:"target" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InlineDocumentEnrichmentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InlineDocumentEnrichmentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InlineDocumentEnrichmentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InlineDocumentEnrichmentConfiguration"}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *InlineDocumentEnrichmentConfiguration) SetCondition(v *DocumentAttributeCondition) *InlineDocumentEnrichmentConfiguration {
	s.Condition = v
	return s
}

// SetDocumentContentOperator sets the DocumentContentOperator field's value.
func (s *InlineDocumentEnrichmentConfiguration) SetDocumentContentOperator(v string) *InlineDocumentEnrichmentConfiguration {
	s.DocumentContentOperator = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *InlineDocumentEnrichmentConfiguration) SetTarget(v *DocumentAttributeTarget) *InlineDocumentEnrichmentConfiguration {
	s.Target = v
	return s
}

// An issue occurred with the internal server used for your Amazon Q Business
// service. Wait some minutes and try again, or contact Support (http://aws.amazon.com/contact-us/)
// for help.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores an Amazon Kendra index as a retriever.
type KendraIndexConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Kendra index.
	//
	// IndexId is a required field
	IndexId *string `locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KendraIndexConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KendraIndexConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KendraIndexConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KendraIndexConfiguration"}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexId sets the IndexId field's value.
func (s *KendraIndexConfiguration) SetIndexId(v string) *KendraIndexConfiguration {
	s.IndexId = &v
	return s
}

// You don't have permissions to perform the action because your license is
// inactive. Ask your admin to activate your license and try again after your
// licence is active.
type LicenseNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseNotFoundException) GoString() string {
	return s.String()
}

func newErrorLicenseNotFoundException(v protocol.ResponseMetadata) error {
	return &LicenseNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LicenseNotFoundException) Code() string {
	return "LicenseNotFoundException"
}

// Message returns the exception's message.
func (s *LicenseNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LicenseNotFoundException) OrigErr() error {
	return nil
}

func (s *LicenseNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LicenseNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LicenseNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of Amazon Q Business applications to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business applications.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of summary information on the configuration of one or more Amazon
	// Q Business applications.
	Applications []*Application `locationName:"applications" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token. You can
	// use this token in a subsequent request to retrieve the next set of applications.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*Application) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListConversationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The maximum number of Amazon Q Business conversations to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business conversations.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The identifier of the user involved in the Amazon Q Business web experience
	// conversation.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConversationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConversationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConversationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConversationsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListConversationsInput) SetApplicationId(v string) *ListConversationsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConversationsInput) SetMaxResults(v int64) *ListConversationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConversationsInput) SetNextToken(v string) *ListConversationsInput {
	s.NextToken = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ListConversationsInput) SetUserId(v string) *ListConversationsInput {
	s.UserId = &v
	return s
}

type ListConversationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of summary information on the configuration of one or more Amazon
	// Q Business web experiences.
	Conversations []*Conversation `locationName:"conversations" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token, which
	// you can use in a later request to list the next set of messages.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConversationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConversationsOutput) GoString() string {
	return s.String()
}

// SetConversations sets the Conversations field's value.
func (s *ListConversationsOutput) SetConversations(v []*Conversation) *ListConversationsOutput {
	s.Conversations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConversationsOutput) SetNextToken(v string) *ListConversationsOutput {
	s.NextToken = &v
	return s
}

type ListDataSourceSyncJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application connected to the data
	// source.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source connector.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" min:"36" type:"string" required:"true"`

	// The end time of the data source connector sync.
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp"`

	// The identifier of the index used with the Amazon Q Business data source connector.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The maximum number of synchronization jobs to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incpmplete because there is more data to retriever,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of responses.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The start time of the data source connector sync.
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp"`

	// Only returns synchronization jobs with the Status field equal to the specified
	// status.
	StatusFilter *string `location:"querystring" locationName:"syncStatus" type:"string" enum:"DataSourceSyncJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourceSyncJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourceSyncJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDataSourceSyncJobsInput) SetApplicationId(v string) *ListDataSourceSyncJobsInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *ListDataSourceSyncJobsInput) SetDataSourceId(v string) *ListDataSourceSyncJobsInput {
	s.DataSourceId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ListDataSourceSyncJobsInput) SetEndTime(v time.Time) *ListDataSourceSyncJobsInput {
	s.EndTime = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListDataSourceSyncJobsInput) SetIndexId(v string) *ListDataSourceSyncJobsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourceSyncJobsInput) SetMaxResults(v int64) *ListDataSourceSyncJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourceSyncJobsInput) SetNextToken(v string) *ListDataSourceSyncJobsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListDataSourceSyncJobsInput) SetStartTime(v time.Time) *ListDataSourceSyncJobsInput {
	s.StartTime = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListDataSourceSyncJobsInput) SetStatusFilter(v string) *ListDataSourceSyncJobsInput {
	s.StatusFilter = &v
	return s
}

type ListDataSourceSyncJobsOutput struct {
	_ struct{} `type:"structure"`

	// A history of synchronization jobs for the data source connector.
	History []*DataSourceSyncJob `locationName:"history" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token. You can
	// use this token in any subsequent request to retrieve the next set of jobs.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourceSyncJobsOutput) GoString() string {
	return s.String()
}

// SetHistory sets the History field's value.
func (s *ListDataSourceSyncJobsOutput) SetHistory(v []*DataSourceSyncJob) *ListDataSourceSyncJobsOutput {
	s.History = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourceSyncJobsOutput) SetNextToken(v string) *ListDataSourceSyncJobsOutput {
	s.NextToken = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application linked to the data source
	// connectors.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the index used with one or more data source connectors.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The maximum number of data source connectors to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business data
	// source connectors.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDataSourcesInput) SetApplicationId(v string) *ListDataSourcesInput {
	s.ApplicationId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListDataSourcesInput) SetIndexId(v string) *ListDataSourcesInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// An array of summary information for one or more data source connector.
	DataSources []*DataSource `locationName:"dataSources" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token. You can
	// use this token in a subsequent request to retrieve the next set of data source
	// connectors.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetDataSources sets the DataSources field's value.
func (s *ListDataSourcesOutput) SetDataSources(v []*DataSource) *ListDataSourcesOutput {
	s.DataSources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

type ListDocumentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application id the documents are attached to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data sources the documents are attached to.
	DataSourceIds []*string `location:"querystring" locationName:"dataSourceIds" min:"1" type:"list"`

	// The identifier of the index the documents are attached to.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The maximum number of documents to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of documents.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceIds != nil && len(s.DataSourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceIds", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListDocumentsInput) SetApplicationId(v string) *ListDocumentsInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceIds sets the DataSourceIds field's value.
func (s *ListDocumentsInput) SetDataSourceIds(v []*string) *ListDocumentsInput {
	s.DataSourceIds = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListDocumentsInput) SetIndexId(v string) *ListDocumentsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentsInput) SetMaxResults(v int64) *ListDocumentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentsInput) SetNextToken(v string) *ListDocumentsInput {
	s.NextToken = &v
	return s
}

type ListDocumentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of document details.
	DocumentDetailList []*DocumentDetails `locationName:"documentDetailList" type:"list"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of documents.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDocumentsOutput) GoString() string {
	return s.String()
}

// SetDocumentDetailList sets the DocumentDetailList field's value.
func (s *ListDocumentsOutput) SetDocumentDetailList(v []*DocumentDetails) *ListDocumentsOutput {
	s.DocumentDetailList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentsOutput) SetNextToken(v string) *ListDocumentsOutput {
	s.NextToken = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application for getting a list of groups mapped to
	// users.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source for getting a list of groups mapped to
	// users.
	DataSourceId *string `location:"querystring" locationName:"dataSourceId" min:"36" type:"string"`

	// The identifier of the index for getting a list of groups mapped to users.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The maximum number of returned groups that are mapped to users.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of groups that are mapped
	// to users.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The timestamp identifier used for the latest PUT or DELETE action for mapping
	// users to their groups.
	//
	// UpdatedEarlierThan is a required field
	UpdatedEarlierThan *time.Time `location:"querystring" locationName:"updatedEarlierThan" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UpdatedEarlierThan == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatedEarlierThan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListGroupsInput) SetApplicationId(v string) *ListGroupsInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *ListGroupsInput) SetDataSourceId(v string) *ListGroupsInput {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *ListGroupsInput) SetIndexId(v string) *ListGroupsInput {
	s.IndexId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

// SetUpdatedEarlierThan sets the UpdatedEarlierThan field's value.
func (s *ListGroupsInput) SetUpdatedEarlierThan(v time.Time) *ListGroupsInput {
	s.UpdatedEarlierThan = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information for list of groups that are mapped to users.
	Items []*GroupSummary `locationName:"items" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token that you
	// can use in the subsequent request to retrieve the next set of groups that
	// are mapped to users.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListGroupsOutput) SetItems(v []*GroupSummary) *ListGroupsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListIndicesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application connected to the index.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The maximum number of indices to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business indices.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIndicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIndicesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListIndicesInput) SetApplicationId(v string) *ListIndicesInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIndicesInput) SetMaxResults(v int64) *ListIndicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesInput) SetNextToken(v string) *ListIndicesInput {
	s.NextToken = &v
	return s
}

type ListIndicesOutput struct {
	_ struct{} `type:"structure"`

	// An array of information on the items in one or more indexes.
	Indices []*Index `locationName:"indices" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token that you
	// can use in the subsequent request to retrieve the next set of indexes.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIndicesOutput) GoString() string {
	return s.String()
}

// SetIndices sets the Indices field's value.
func (s *ListIndicesOutput) SetIndices(v []*Index) *ListIndicesOutput {
	s.Indices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIndicesOutput) SetNextToken(v string) *ListIndicesOutput {
	s.NextToken = &v
	return s
}

type ListMessagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier for the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the Amazon Q Business web experience conversation.
	//
	// ConversationId is a required field
	ConversationId *string `location:"uri" locationName:"conversationId" min:"36" type:"string" required:"true"`

	// The maximum number of messages to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the number of retrievers returned exceeds maxResults, Amazon Q Business
	// returns a next token as a pagination token to retrieve the next set of messages.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The identifier of the user involved in the Amazon Q Business web experience
	// conversation.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMessagesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ConversationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConversationId"))
	}
	if s.ConversationId != nil && len(*s.ConversationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConversationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListMessagesInput) SetApplicationId(v string) *ListMessagesInput {
	s.ApplicationId = &v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *ListMessagesInput) SetConversationId(v string) *ListMessagesInput {
	s.ConversationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMessagesInput) SetMaxResults(v int64) *ListMessagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMessagesInput) SetNextToken(v string) *ListMessagesInput {
	s.NextToken = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ListMessagesInput) SetUserId(v string) *ListMessagesInput {
	s.UserId = &v
	return s
}

type ListMessagesOutput struct {
	_ struct{} `type:"structure"`

	// An array of information on one or more messages.
	Messages []*Message `locationName:"messages" type:"list"`

	// If the response is truncated, Amazon Q Business returns this token, which
	// you can use in a later request to list the next set of messages.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMessagesOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *ListMessagesOutput) SetMessages(v []*Message) *ListMessagesOutput {
	s.Messages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMessagesOutput) SetNextToken(v string) *ListMessagesOutput {
	s.NextToken = &v
	return s
}

type ListPluginsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the application the plugin is attached to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The maximum number of documents to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of plugins.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPluginsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPluginsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListPluginsInput) SetApplicationId(v string) *ListPluginsInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPluginsInput) SetMaxResults(v int64) *ListPluginsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPluginsInput) SetNextToken(v string) *ListPluginsInput {
	s.NextToken = &v
	return s
}

type ListPluginsOutput struct {
	_ struct{} `type:"structure"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of plugins.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Information about a configured plugin.
	Plugins []*Plugin `locationName:"plugins" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPluginsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPluginsOutput) SetNextToken(v string) *ListPluginsOutput {
	s.NextToken = &v
	return s
}

// SetPlugins sets the Plugins field's value.
func (s *ListPluginsOutput) SetPlugins(v []*Plugin) *ListPluginsOutput {
	s.Plugins = v
	return s
}

type ListRetrieversInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application using the retriever.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The maximum number of retrievers returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the number of retrievers returned exceeds maxResults, Amazon Q Business
	// returns a next token as a pagination token to retrieve the next set of retrievers.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetrieversInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetrieversInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRetrieversInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRetrieversInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListRetrieversInput) SetApplicationId(v string) *ListRetrieversInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRetrieversInput) SetMaxResults(v int64) *ListRetrieversInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRetrieversInput) SetNextToken(v string) *ListRetrieversInput {
	s.NextToken = &v
	return s
}

type ListRetrieversOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Q Business returns this token, which
	// you can use in a later request to list the next set of retrievers.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of summary information for one or more retrievers.
	Retrievers []*Retriever `locationName:"retrievers" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetrieversOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetrieversOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRetrieversOutput) SetNextToken(v string) *ListRetrieversOutput {
	s.NextToken = &v
	return s
}

// SetRetrievers sets the Retrievers field's value.
func (s *ListRetrieversOutput) SetRetrievers(v []*Retriever) *ListRetrieversOutput {
	s.Retrievers = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Q Business application or data
	// source to get a list of tags for.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"uri" locationName:"resourceARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the Amazon Q Business application or data
	// source.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWebExperiencesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application linked to the listed
	// web experiences.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The maximum number of Amazon Q Business Web Experiences to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the maxResults response was incomplete because there is more data to retrieve,
	// Amazon Q Business returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of Amazon Q Business conversations.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebExperiencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebExperiencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebExperiencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWebExperiencesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ListWebExperiencesInput) SetApplicationId(v string) *ListWebExperiencesInput {
	s.ApplicationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWebExperiencesInput) SetMaxResults(v int64) *ListWebExperiencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebExperiencesInput) SetNextToken(v string) *ListWebExperiencesInput {
	s.NextToken = &v
	return s
}

type ListWebExperiencesOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Q Business returns this token, which
	// you can use in a later request to list the next set of messages.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of summary information for one or more Amazon Q Business experiences.
	WebExperiences []*WebExperience `locationName:"webExperiences" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebExperiencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWebExperiencesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebExperiencesOutput) SetNextToken(v string) *ListWebExperiencesOutput {
	s.NextToken = &v
	return s
}

// SetWebExperiences sets the WebExperiences field's value.
func (s *ListWebExperiencesOutput) SetWebExperiences(v []*WebExperience) *ListWebExperiencesOutput {
	s.WebExperiences = v
	return s
}

// The sub groups that belong to a group.
type MemberGroup struct {
	_ struct{} `type:"structure"`

	// The name of the sub group.
	//
	// GroupName is a required field
	GroupName *string `locationName:"groupName" min:"1" type:"string" required:"true"`

	// The type of the sub group.
	Type *string `locationName:"type" type:"string" enum:"MembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberGroup"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *MemberGroup) SetGroupName(v string) *MemberGroup {
	s.GroupName = &v
	return s
}

// SetType sets the Type field's value.
func (s *MemberGroup) SetType(v string) *MemberGroup {
	s.Type = &v
	return s
}

// The users that belong to a group.
type MemberUser struct {
	_ struct{} `type:"structure"`

	// The type of the user.
	Type *string `locationName:"type" type:"string" enum:"MembershipType"`

	// The identifier of the user you want to map to a group.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemberUser) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemberUser) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemberUser"}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *MemberUser) SetType(v string) *MemberUser {
	s.Type = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *MemberUser) SetUserId(v string) *MemberUser {
	s.UserId = &v
	return s
}

// A message in an Amazon Q Business web experience.
type Message struct {
	_ struct{} `type:"structure"`

	// An output event that Amazon Q Business returns to an user who wants to perform
	// a plugin action during a non-streaming chat conversation. It contains information
	// about the selected action with a list of possible user input fields, some
	// pre-populated by Amazon Q Business.
	ActionReview *ActionReview `locationName:"actionReview" type:"structure"`

	// A file directly uploaded into an Amazon Q Business web experience chat.
	Attachments []*AttachmentOutput_ `locationName:"attachments" type:"list"`

	// The content of the Amazon Q Business web experience message.
	Body *string `locationName:"body" type:"string"`

	// The identifier of the Amazon Q Business web experience message.
	MessageId *string `locationName:"messageId" min:"1" type:"string"`

	// The source documents used to generate Amazon Q Business web experience message.
	SourceAttribution []*SourceAttribution `locationName:"sourceAttribution" type:"list"`

	// The timestamp of the first Amazon Q Business web experience message.
	Time *time.Time `locationName:"time" type:"timestamp"`

	// The type of Amazon Q Business message, whether HUMAN or AI generated.
	Type *string `locationName:"type" type:"string" enum:"MessageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Message) GoString() string {
	return s.String()
}

// SetActionReview sets the ActionReview field's value.
func (s *Message) SetActionReview(v *ActionReview) *Message {
	s.ActionReview = v
	return s
}

// SetAttachments sets the Attachments field's value.
func (s *Message) SetAttachments(v []*AttachmentOutput_) *Message {
	s.Attachments = v
	return s
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v string) *Message {
	s.Body = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *Message) SetMessageId(v string) *Message {
	s.MessageId = &v
	return s
}

// SetSourceAttribution sets the SourceAttribution field's value.
func (s *Message) SetSourceAttribution(v []*SourceAttribution) *Message {
	s.SourceAttribution = v
	return s
}

// SetTime sets the Time field's value.
func (s *Message) SetTime(v time.Time) *Message {
	s.Time = &v
	return s
}

// SetType sets the Type field's value.
func (s *Message) SetType(v string) *Message {
	s.Type = &v
	return s
}

// End user feedback on an AI-generated web experience chat message usefulness.
type MessageUsefulnessFeedback struct {
	_ struct{} `type:"structure"`

	// A comment given by an end user on the usefulness of an AI-generated chat
	// message.
	Comment *string `locationName:"comment" type:"string"`

	// The reason for a usefulness rating.
	Reason *string `locationName:"reason" type:"string" enum:"MessageUsefulnessReason"`

	// The timestamp for when the feedback was submitted.
	//
	// SubmittedAt is a required field
	SubmittedAt *time.Time `locationName:"submittedAt" type:"timestamp" required:"true"`

	// The usefulness value assigned by an end user to a message.
	//
	// Usefulness is a required field
	Usefulness *string `locationName:"usefulness" type:"string" required:"true" enum:"MessageUsefulness"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageUsefulnessFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MessageUsefulnessFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageUsefulnessFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageUsefulnessFeedback"}
	if s.SubmittedAt == nil {
		invalidParams.Add(request.NewErrParamRequired("SubmittedAt"))
	}
	if s.Usefulness == nil {
		invalidParams.Add(request.NewErrParamRequired("Usefulness"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *MessageUsefulnessFeedback) SetComment(v string) *MessageUsefulnessFeedback {
	s.Comment = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *MessageUsefulnessFeedback) SetReason(v string) *MessageUsefulnessFeedback {
	s.Reason = &v
	return s
}

// SetSubmittedAt sets the SubmittedAt field's value.
func (s *MessageUsefulnessFeedback) SetSubmittedAt(v time.Time) *MessageUsefulnessFeedback {
	s.SubmittedAt = &v
	return s
}

// SetUsefulness sets the Usefulness field's value.
func (s *MessageUsefulnessFeedback) SetUsefulness(v string) *MessageUsefulnessFeedback {
	s.Usefulness = &v
	return s
}

// A metadata event for a AI-generated text output message in a Amazon Q Business
// conversation, containing associated metadata generated.
type MetadataEvent struct {
	_ struct{} `type:"structure"`

	// The identifier of the conversation with which the generated metadata is associated.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// The final text output message generated by the system.
	FinalTextMessage *string `locationName:"finalTextMessage" min:"1" type:"string"`

	// The source documents used to generate the conversation response.
	SourceAttributions []*SourceAttribution `locationName:"sourceAttributions" type:"list"`

	// The identifier of an Amazon Q Business AI generated message within the conversation.
	SystemMessageId *string `locationName:"systemMessageId" min:"36" type:"string"`

	// The identifier of an Amazon Q Business end user text input message within
	// the conversation.
	UserMessageId *string `locationName:"userMessageId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetadataEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetadataEvent) GoString() string {
	return s.String()
}

// SetConversationId sets the ConversationId field's value.
func (s *MetadataEvent) SetConversationId(v string) *MetadataEvent {
	s.ConversationId = &v
	return s
}

// SetFinalTextMessage sets the FinalTextMessage field's value.
func (s *MetadataEvent) SetFinalTextMessage(v string) *MetadataEvent {
	s.FinalTextMessage = &v
	return s
}

// SetSourceAttributions sets the SourceAttributions field's value.
func (s *MetadataEvent) SetSourceAttributions(v []*SourceAttribution) *MetadataEvent {
	s.SourceAttributions = v
	return s
}

// SetSystemMessageId sets the SystemMessageId field's value.
func (s *MetadataEvent) SetSystemMessageId(v string) *MetadataEvent {
	s.SystemMessageId = &v
	return s
}

// SetUserMessageId sets the UserMessageId field's value.
func (s *MetadataEvent) SetUserMessageId(v string) *MetadataEvent {
	s.UserMessageId = &v
	return s
}

// The MetadataEvent is and event in the ChatOutputStream group of events.
func (s *MetadataEvent) eventChatOutputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the MetadataEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *MetadataEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *MetadataEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Configuration information for an Amazon Q Business index.
type NativeIndexConfiguration struct {
	_ struct{} `type:"structure"`

	// Overrides the default boosts applied by Amazon Q Business to supported document
	// attribute data types.
	BoostingOverride map[string]*DocumentAttributeBoostingConfiguration `locationName:"boostingOverride" min:"1" type:"map"`

	// The identifier for the Amazon Q Business index.
	//
	// IndexId is a required field
	IndexId *string `locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NativeIndexConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NativeIndexConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NativeIndexConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NativeIndexConfiguration"}
	if s.BoostingOverride != nil && len(s.BoostingOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BoostingOverride", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.BoostingOverride != nil {
		for i, v := range s.BoostingOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BoostingOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoostingOverride sets the BoostingOverride field's value.
func (s *NativeIndexConfiguration) SetBoostingOverride(v map[string]*DocumentAttributeBoostingConfiguration) *NativeIndexConfiguration {
	s.BoostingOverride = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *NativeIndexConfiguration) SetIndexId(v string) *NativeIndexConfiguration {
	s.IndexId = &v
	return s
}

// Information about invoking a custom plugin without any authentication or
// authorization requirement.
type NoAuthConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoAuthConfiguration) GoString() string {
	return s.String()
}

// Provides information on boosting NUMBER type document attributes.
//
// For more information on how boosting document attributes work in Amazon Q
// Business, see Boosting using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
type NumberAttributeBoostingConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the duration, in seconds, of a boost applies to a NUMBER type document
	// attribute.
	//
	// BoostingLevel is a required field
	BoostingLevel *string `locationName:"boostingLevel" type:"string" required:"true" enum:"DocumentAttributeBoostingLevel"`

	// Specifies how much a document attribute is boosted.
	BoostingType *string `locationName:"boostingType" type:"string" enum:"NumberAttributeBoostingType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NumberAttributeBoostingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NumberAttributeBoostingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NumberAttributeBoostingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NumberAttributeBoostingConfiguration"}
	if s.BoostingLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("BoostingLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoostingLevel sets the BoostingLevel field's value.
func (s *NumberAttributeBoostingConfiguration) SetBoostingLevel(v string) *NumberAttributeBoostingConfiguration {
	s.BoostingLevel = &v
	return s
}

// SetBoostingType sets the BoostingType field's value.
func (s *NumberAttributeBoostingConfiguration) SetBoostingType(v string) *NumberAttributeBoostingConfiguration {
	s.BoostingType = &v
	return s
}

// Information about the OAuth 2.0 authentication credential/token used to configure
// a plugin.
type OAuth2ClientCredentialConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0
	// authentication credentials stored in a Secrets Manager secret.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token
	// used for plugin configuration.
	//
	// SecretArn is a required field
	SecretArn *string `locationName:"secretArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OAuth2ClientCredentialConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OAuth2ClientCredentialConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OAuth2ClientCredentialConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OAuth2ClientCredentialConfiguration"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *OAuth2ClientCredentialConfiguration) SetRoleArn(v string) *OAuth2ClientCredentialConfiguration {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *OAuth2ClientCredentialConfiguration) SetSecretArn(v string) *OAuth2ClientCredentialConfiguration {
	s.SecretArn = &v
	return s
}

// Information about an Amazon Q Business plugin and its configuration.
type Plugin struct {
	_ struct{} `type:"structure"`

	// The status of the plugin.
	BuildStatus *string `locationName:"buildStatus" type:"string" enum:"PluginBuildStatus"`

	// The timestamp for when the plugin was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The name of the plugin.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The identifier of the plugin.
	PluginId *string `locationName:"pluginId" min:"36" type:"string"`

	// The plugin server URL used for configuration.
	ServerUrl *string `locationName:"serverUrl" min:"1" type:"string"`

	// The current status of the plugin.
	State *string `locationName:"state" type:"string" enum:"PluginState"`

	// The type of the plugin.
	Type *string `locationName:"type" type:"string" enum:"PluginType"`

	// The timestamp for when the plugin was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plugin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plugin) GoString() string {
	return s.String()
}

// SetBuildStatus sets the BuildStatus field's value.
func (s *Plugin) SetBuildStatus(v string) *Plugin {
	s.BuildStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Plugin) SetCreatedAt(v time.Time) *Plugin {
	s.CreatedAt = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Plugin) SetDisplayName(v string) *Plugin {
	s.DisplayName = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *Plugin) SetPluginId(v string) *Plugin {
	s.PluginId = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *Plugin) SetServerUrl(v string) *Plugin {
	s.ServerUrl = &v
	return s
}

// SetState sets the State field's value.
func (s *Plugin) SetState(v string) *Plugin {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Plugin) SetType(v string) *Plugin {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Plugin) SetUpdatedAt(v time.Time) *Plugin {
	s.UpdatedAt = &v
	return s
}

// Authentication configuration information for an Amazon Q Business plugin.
type PluginAuthConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the basic authentication credentials used to configure
	// a plugin.
	BasicAuthConfiguration *BasicAuthConfiguration `locationName:"basicAuthConfiguration" type:"structure"`

	// Information about invoking a custom plugin without any authentication.
	NoAuthConfiguration *NoAuthConfiguration `locationName:"noAuthConfiguration" type:"structure"`

	// Information about the OAuth 2.0 authentication credential/token used to configure
	// a plugin.
	OAuth2ClientCredentialConfiguration *OAuth2ClientCredentialConfiguration `locationName:"oAuth2ClientCredentialConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginAuthConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PluginAuthConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PluginAuthConfiguration"}
	if s.BasicAuthConfiguration != nil {
		if err := s.BasicAuthConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BasicAuthConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OAuth2ClientCredentialConfiguration != nil {
		if err := s.OAuth2ClientCredentialConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OAuth2ClientCredentialConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasicAuthConfiguration sets the BasicAuthConfiguration field's value.
func (s *PluginAuthConfiguration) SetBasicAuthConfiguration(v *BasicAuthConfiguration) *PluginAuthConfiguration {
	s.BasicAuthConfiguration = v
	return s
}

// SetNoAuthConfiguration sets the NoAuthConfiguration field's value.
func (s *PluginAuthConfiguration) SetNoAuthConfiguration(v *NoAuthConfiguration) *PluginAuthConfiguration {
	s.NoAuthConfiguration = v
	return s
}

// SetOAuth2ClientCredentialConfiguration sets the OAuth2ClientCredentialConfiguration field's value.
func (s *PluginAuthConfiguration) SetOAuth2ClientCredentialConfiguration(v *OAuth2ClientCredentialConfiguration) *PluginAuthConfiguration {
	s.OAuth2ClientCredentialConfiguration = v
	return s
}

// Configuration information required to invoke chat in PLUGIN_MODE.
//
// For more information, see Admin controls and guardrails (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/guardrails.html),
// Plugins (https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/plugins.html),
// and Conversation settings (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/using-web-experience.html#chat-source-scope).
type PluginConfiguration struct {
	_ struct{} `type:"structure"`

	// The identifier of the plugin you want to use.
	//
	// PluginId is a required field
	PluginId *string `locationName:"pluginId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PluginConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PluginConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PluginConfiguration"}
	if s.PluginId == nil {
		invalidParams.Add(request.NewErrParamRequired("PluginId"))
	}
	if s.PluginId != nil && len(*s.PluginId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PluginId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPluginId sets the PluginId field's value.
func (s *PluginConfiguration) SetPluginId(v string) *PluginConfiguration {
	s.PluginId = &v
	return s
}

// Provides user and group information used for filtering documents to use for
// generating Amazon Q Business conversation responses.
type Principal struct {
	_ struct{} `type:"structure"`

	// The group associated with the principal.
	Group *PrincipalGroup `locationName:"group" type:"structure"`

	// The user associated with the principal.
	User *PrincipalUser `locationName:"user" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Principal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Principal) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Principal) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Principal"}
	if s.Group != nil {
		if err := s.Group.Validate(); err != nil {
			invalidParams.AddNested("Group", err.(request.ErrInvalidParams))
		}
	}
	if s.User != nil {
		if err := s.User.Validate(); err != nil {
			invalidParams.AddNested("User", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *Principal) SetGroup(v *PrincipalGroup) *Principal {
	s.Group = v
	return s
}

// SetUser sets the User field's value.
func (s *Principal) SetUser(v *PrincipalUser) *Principal {
	s.User = v
	return s
}

// Provides information about a group associated with the principal.
type PrincipalGroup struct {
	_ struct{} `type:"structure"`

	// Provides information about whether to allow or deny access to the principal.
	//
	// Access is a required field
	Access *string `locationName:"access" type:"string" required:"true" enum:"ReadAccessType"`

	// The type of group.
	MembershipType *string `locationName:"membershipType" type:"string" enum:"MembershipType"`

	// The name of the group.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrincipalGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrincipalGroup"}
	if s.Access == nil {
		invalidParams.Add(request.NewErrParamRequired("Access"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccess sets the Access field's value.
func (s *PrincipalGroup) SetAccess(v string) *PrincipalGroup {
	s.Access = &v
	return s
}

// SetMembershipType sets the MembershipType field's value.
func (s *PrincipalGroup) SetMembershipType(v string) *PrincipalGroup {
	s.MembershipType = &v
	return s
}

// SetName sets the Name field's value.
func (s *PrincipalGroup) SetName(v string) *PrincipalGroup {
	s.Name = &v
	return s
}

// Provides information about a user associated with a principal.
type PrincipalUser struct {
	_ struct{} `type:"structure"`

	// Provides information about whether to allow or deny access to the principal.
	//
	// Access is a required field
	Access *string `locationName:"access" type:"string" required:"true" enum:"ReadAccessType"`

	// The identifier of the user.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The type of group.
	MembershipType *string `locationName:"membershipType" type:"string" enum:"MembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrincipalUser) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrincipalUser) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrincipalUser"}
	if s.Access == nil {
		invalidParams.Add(request.NewErrParamRequired("Access"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccess sets the Access field's value.
func (s *PrincipalUser) SetAccess(v string) *PrincipalUser {
	s.Access = &v
	return s
}

// SetId sets the Id field's value.
func (s *PrincipalUser) SetId(v string) *PrincipalUser {
	s.Id = &v
	return s
}

// SetMembershipType sets the MembershipType field's value.
func (s *PrincipalUser) SetMembershipType(v string) *PrincipalUser {
	s.MembershipType = &v
	return s
}

type PutFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application associated with the feedback.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the conversation the feedback is attached to.
	//
	// ConversationId is a required field
	ConversationId *string `location:"uri" locationName:"conversationId" min:"36" type:"string" required:"true"`

	// The timestamp for when the feedback was recorded.
	MessageCopiedAt *time.Time `locationName:"messageCopiedAt" type:"timestamp"`

	// The identifier of the chat message that the feedback was given for.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" min:"36" type:"string" required:"true"`

	// The feedback usefulness value given by the user to the chat message.
	MessageUsefulness *MessageUsefulnessFeedback `locationName:"messageUsefulness" type:"structure"`

	// The identifier of the user giving the feedback.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFeedbackInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ConversationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConversationId"))
	}
	if s.ConversationId != nil && len(*s.ConversationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ConversationId", 36))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 36))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.MessageUsefulness != nil {
		if err := s.MessageUsefulness.Validate(); err != nil {
			invalidParams.AddNested("MessageUsefulness", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutFeedbackInput) SetApplicationId(v string) *PutFeedbackInput {
	s.ApplicationId = &v
	return s
}

// SetConversationId sets the ConversationId field's value.
func (s *PutFeedbackInput) SetConversationId(v string) *PutFeedbackInput {
	s.ConversationId = &v
	return s
}

// SetMessageCopiedAt sets the MessageCopiedAt field's value.
func (s *PutFeedbackInput) SetMessageCopiedAt(v time.Time) *PutFeedbackInput {
	s.MessageCopiedAt = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *PutFeedbackInput) SetMessageId(v string) *PutFeedbackInput {
	s.MessageId = &v
	return s
}

// SetMessageUsefulness sets the MessageUsefulness field's value.
func (s *PutFeedbackInput) SetMessageUsefulness(v *MessageUsefulnessFeedback) *PutFeedbackInput {
	s.MessageUsefulness = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *PutFeedbackInput) SetUserId(v string) *PutFeedbackInput {
	s.UserId = &v
	return s
}

type PutFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFeedbackOutput) GoString() string {
	return s.String()
}

type PutGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application in which the user and group mapping belongs.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source for which you want to map users to their
	// groups. This is useful if a group is tied to multiple data sources, but you
	// only want the group to access documents of a certain data source. For example,
	// the groups "Research", "Engineering", and "Sales and Marketing" are all tied
	// to the company's documents stored in the data sources Confluence and Salesforce.
	// However, "Sales and Marketing" team only needs access to customer-related
	// documents stored in Salesforce.
	DataSourceId *string `locationName:"dataSourceId" min:"36" type:"string"`

	// A list of users or sub groups that belong to a group. This is for generating
	// Amazon Q Business chat results only from document a user has access to.
	//
	// GroupMembers is a required field
	GroupMembers *GroupMembers `locationName:"groupMembers" type:"structure" required:"true"`

	// The list that contains your users or sub groups that belong the same group.
	// For example, the group "Company" includes the user "CEO" and the sub groups
	// "Research", "Engineering", and "Sales and Marketing".
	//
	// If you have more than 1000 users and/or sub groups for a single group, you
	// need to provide the path to the S3 file that lists your users and sub groups
	// for a group. Your sub groups can contain more than 1000 users, but the list
	// of sub groups that belong to a group (and/or users) must be no more than
	// 1000.
	//
	// GroupName is a required field
	GroupName *string `locationName:"groupName" min:"1" type:"string" required:"true"`

	// The identifier of the index in which you want to map users to their groups.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The type of the group.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"MembershipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutGroupInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.GroupMembers == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupMembers"))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.GroupMembers != nil {
		if err := s.GroupMembers.Validate(); err != nil {
			invalidParams.AddNested("GroupMembers", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutGroupInput) SetApplicationId(v string) *PutGroupInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *PutGroupInput) SetDataSourceId(v string) *PutGroupInput {
	s.DataSourceId = &v
	return s
}

// SetGroupMembers sets the GroupMembers field's value.
func (s *PutGroupInput) SetGroupMembers(v *GroupMembers) *PutGroupInput {
	s.GroupMembers = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *PutGroupInput) SetGroupName(v string) *PutGroupInput {
	s.GroupName = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *PutGroupInput) SetIndexId(v string) *PutGroupInput {
	s.IndexId = &v
	return s
}

// SetType sets the Type field's value.
func (s *PutGroupInput) SetType(v string) *PutGroupInput {
	s.Type = &v
	return s
}

type PutGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGroupOutput) GoString() string {
	return s.String()
}

// The resource you want to use doesn’t exist. Make sure you have provided
// the correct resource and try again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message describing a ResourceNotFoundException.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary information for the retriever used for your Amazon Q Business application.
type Retriever struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application using the retriever.
	ApplicationId *string `locationName:"applicationId" min:"36" type:"string"`

	// The name of your retriever.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The identifier of the retriever used by your Amazon Q Business application.
	RetrieverId *string `locationName:"retrieverId" min:"36" type:"string"`

	// The status of your retriever.
	Status *string `locationName:"status" type:"string" enum:"RetrieverStatus"`

	// The type of your retriever.
	Type *string `locationName:"type" type:"string" enum:"RetrieverType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Retriever) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Retriever) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *Retriever) SetApplicationId(v string) *Retriever {
	s.ApplicationId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Retriever) SetDisplayName(v string) *Retriever {
	s.DisplayName = &v
	return s
}

// SetRetrieverId sets the RetrieverId field's value.
func (s *Retriever) SetRetrieverId(v string) *Retriever {
	s.RetrieverId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Retriever) SetStatus(v string) *Retriever {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Retriever) SetType(v string) *Retriever {
	s.Type = &v
	return s
}

// Provides information on how the retriever used for your Amazon Q Business
// application is configured.
type RetrieverConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides information on how the Amazon Kendra index used as a retriever for
	// your Amazon Q Business application is configured.
	KendraIndexConfiguration *KendraIndexConfiguration `locationName:"kendraIndexConfiguration" type:"structure"`

	// Provides information on how a Amazon Q Business index used as a retriever
	// for your Amazon Q Business application is configured.
	NativeIndexConfiguration *NativeIndexConfiguration `locationName:"nativeIndexConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieverConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrieverConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieverConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieverConfiguration"}
	if s.KendraIndexConfiguration != nil {
		if err := s.KendraIndexConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KendraIndexConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.NativeIndexConfiguration != nil {
		if err := s.NativeIndexConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NativeIndexConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKendraIndexConfiguration sets the KendraIndexConfiguration field's value.
func (s *RetrieverConfiguration) SetKendraIndexConfiguration(v *KendraIndexConfiguration) *RetrieverConfiguration {
	s.KendraIndexConfiguration = v
	return s
}

// SetNativeIndexConfiguration sets the NativeIndexConfiguration field's value.
func (s *RetrieverConfiguration) SetNativeIndexConfiguration(v *NativeIndexConfiguration) *RetrieverConfiguration {
	s.NativeIndexConfiguration = v
	return s
}

// Guardrail rules for an Amazon Q Business application. Amazon Q Business supports
// only one rule at a time.
type Rule struct {
	_ struct{} `type:"structure"`

	// Users and groups to be excluded from a rule.
	ExcludedUsersAndGroups *UsersAndGroups `locationName:"excludedUsersAndGroups" type:"structure"`

	// Users and groups to be included in a rule.
	IncludedUsersAndGroups *UsersAndGroups `locationName:"includedUsersAndGroups" type:"structure"`

	// The configuration information for a rule.
	RuleConfiguration *RuleConfiguration `locationName:"ruleConfiguration" type:"structure"`

	// The type of rule.
	//
	// RuleType is a required field
	RuleType *string `locationName:"ruleType" type:"string" required:"true" enum:"RuleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.RuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleType"))
	}
	if s.RuleConfiguration != nil {
		if err := s.RuleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RuleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExcludedUsersAndGroups sets the ExcludedUsersAndGroups field's value.
func (s *Rule) SetExcludedUsersAndGroups(v *UsersAndGroups) *Rule {
	s.ExcludedUsersAndGroups = v
	return s
}

// SetIncludedUsersAndGroups sets the IncludedUsersAndGroups field's value.
func (s *Rule) SetIncludedUsersAndGroups(v *UsersAndGroups) *Rule {
	s.IncludedUsersAndGroups = v
	return s
}

// SetRuleConfiguration sets the RuleConfiguration field's value.
func (s *Rule) SetRuleConfiguration(v *RuleConfiguration) *Rule {
	s.RuleConfiguration = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *Rule) SetRuleType(v string) *Rule {
	s.RuleType = &v
	return s
}

// Provides configuration information about a rule.
type RuleConfiguration struct {
	_ struct{} `type:"structure"`

	// A rule for configuring how Amazon Q Business responds when it encounters
	// a a blocked topic.
	ContentBlockerRule *ContentBlockerRule `locationName:"contentBlockerRule" type:"structure"`

	// Rules for retrieving content from data sources connected to a Amazon Q Business
	// application for a specific topic control configuration.
	ContentRetrievalRule *ContentRetrievalRule `locationName:"contentRetrievalRule" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleConfiguration"}
	if s.ContentRetrievalRule != nil {
		if err := s.ContentRetrievalRule.Validate(); err != nil {
			invalidParams.AddNested("ContentRetrievalRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentBlockerRule sets the ContentBlockerRule field's value.
func (s *RuleConfiguration) SetContentBlockerRule(v *ContentBlockerRule) *RuleConfiguration {
	s.ContentBlockerRule = v
	return s
}

// SetContentRetrievalRule sets the ContentRetrievalRule field's value.
func (s *RuleConfiguration) SetContentRetrievalRule(v *ContentRetrievalRule) *RuleConfiguration {
	s.ContentRetrievalRule = v
	return s
}

// Information required for Amazon Q Business to find a specific file in an
// Amazon S3 bucket.
type S3 struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that contains the file.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"1" type:"string" required:"true"`

	// The name of the file.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3) SetBucket(v string) *S3 {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3) SetKey(v string) *S3 {
	s.Key = &v
	return s
}

// Provides the SAML 2.0 compliant identity provider (IdP) configuration information
// Amazon Q Business needs to deploy a Amazon Q Business web experience.
type SamlConfiguration struct {
	_ struct{} `type:"structure"`

	// The metadata XML that your IdP generated.
	//
	// MetadataXML is a required field
	MetadataXML *string `locationName:"metadataXML" min:"1000" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role assumed by users when they
	// authenticate into their Amazon Q Business web experience, containing the
	// relevant Amazon Q Business permissions for conversing with Amazon Q Business.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The group attribute name in your IdP that maps to user groups.
	UserGroupAttribute *string `locationName:"userGroupAttribute" min:"1" type:"string"`

	// The user attribute name in your IdP that maps to the user email.
	//
	// UserIdAttribute is a required field
	UserIdAttribute *string `locationName:"userIdAttribute" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamlConfiguration"}
	if s.MetadataXML == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataXML"))
	}
	if s.MetadataXML != nil && len(*s.MetadataXML) < 1000 {
		invalidParams.Add(request.NewErrParamMinLen("MetadataXML", 1000))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.UserGroupAttribute != nil && len(*s.UserGroupAttribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserGroupAttribute", 1))
	}
	if s.UserIdAttribute == nil {
		invalidParams.Add(request.NewErrParamRequired("UserIdAttribute"))
	}
	if s.UserIdAttribute != nil && len(*s.UserIdAttribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserIdAttribute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataXML sets the MetadataXML field's value.
func (s *SamlConfiguration) SetMetadataXML(v string) *SamlConfiguration {
	s.MetadataXML = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SamlConfiguration) SetRoleArn(v string) *SamlConfiguration {
	s.RoleArn = &v
	return s
}

// SetUserGroupAttribute sets the UserGroupAttribute field's value.
func (s *SamlConfiguration) SetUserGroupAttribute(v string) *SamlConfiguration {
	s.UserGroupAttribute = &v
	return s
}

// SetUserIdAttribute sets the UserIdAttribute field's value.
func (s *SamlConfiguration) SetUserIdAttribute(v string) *SamlConfiguration {
	s.UserIdAttribute = &v
	return s
}

// You have exceeded the set limits for your Amazon Q Business service.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message describing a ServiceQuotaExceededException.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the relevant text excerpt from a source that was used to generate
// a citation text segment in an Amazon Q Business chat response.
type SnippetExcerpt struct {
	_ struct{} `type:"structure"`

	// The relevant text excerpt from a source that was used to generate a citation
	// text segment in an Amazon Q chat response.
	Text *string `locationName:"text" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnippetExcerpt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnippetExcerpt) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *SnippetExcerpt) SetText(v string) *SnippetExcerpt {
	s.Text = &v
	return s
}

// The documents used to generate an Amazon Q Business web experience response.
type SourceAttribution struct {
	_ struct{} `type:"structure"`

	// The number attached to a citation in an Amazon Q Business generated response.
	CitationNumber *int64 `locationName:"citationNumber" type:"integer"`

	// The content extract from the document on which the generated response is
	// based.
	Snippet *string `locationName:"snippet" min:"1" type:"string"`

	// A text extract from a source document that is used for source attribution.
	TextMessageSegments []*TextSegment `locationName:"textMessageSegments" type:"list"`

	// The title of the document which is the source for the Amazon Q Business generated
	// response.
	Title *string `locationName:"title" min:"1" type:"string"`

	// The Unix timestamp when the Amazon Q Business application was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The URL of the document which is the source for the Amazon Q Business generated
	// response.
	Url *string `locationName:"url" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceAttribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceAttribution) GoString() string {
	return s.String()
}

// SetCitationNumber sets the CitationNumber field's value.
func (s *SourceAttribution) SetCitationNumber(v int64) *SourceAttribution {
	s.CitationNumber = &v
	return s
}

// SetSnippet sets the Snippet field's value.
func (s *SourceAttribution) SetSnippet(v string) *SourceAttribution {
	s.Snippet = &v
	return s
}

// SetTextMessageSegments sets the TextMessageSegments field's value.
func (s *SourceAttribution) SetTextMessageSegments(v []*TextSegment) *SourceAttribution {
	s.TextMessageSegments = v
	return s
}

// SetTitle sets the Title field's value.
func (s *SourceAttribution) SetTitle(v string) *SourceAttribution {
	s.Title = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SourceAttribution) SetUpdatedAt(v time.Time) *SourceAttribution {
	s.UpdatedAt = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *SourceAttribution) SetUrl(v string) *SourceAttribution {
	s.Url = &v
	return s
}

type StartDataSourceSyncJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of Amazon Q Business application the data source is connected
	// to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source connector.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" min:"36" type:"string" required:"true"`

	// The identifier of the index used with the data source connector.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDataSourceSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDataSourceSyncJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StartDataSourceSyncJobInput) SetApplicationId(v string) *StartDataSourceSyncJobInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *StartDataSourceSyncJobInput) SetDataSourceId(v string) *StartDataSourceSyncJobInput {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *StartDataSourceSyncJobInput) SetIndexId(v string) *StartDataSourceSyncJobInput {
	s.IndexId = &v
	return s
}

type StartDataSourceSyncJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for a particular synchronization job.
	ExecutionId *string `locationName:"executionId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDataSourceSyncJobOutput) GoString() string {
	return s.String()
}

// SetExecutionId sets the ExecutionId field's value.
func (s *StartDataSourceSyncJobOutput) SetExecutionId(v string) *StartDataSourceSyncJobOutput {
	s.ExecutionId = &v
	return s
}

type StopDataSourceSyncJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Amazon Q Business application that the data source
	// is connected to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source connector.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" min:"36" type:"string" required:"true"`

	// The identifier of the index used with the Amazon Q Business data source connector.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDataSourceSyncJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDataSourceSyncJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *StopDataSourceSyncJobInput) SetApplicationId(v string) *StopDataSourceSyncJobInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *StopDataSourceSyncJobInput) SetDataSourceId(v string) *StopDataSourceSyncJobInput {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *StopDataSourceSyncJobInput) SetIndexId(v string) *StopDataSourceSyncJobInput {
	s.IndexId = &v
	return s
}

type StopDataSourceSyncJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDataSourceSyncJobOutput) GoString() string {
	return s.String()
}

// Provides information on boosting STRING type document attributes.
//
// For STRING and STRING_LIST type document attributes to be used for boosting
// on the console and the API, they must be enabled for search using the DocumentAttributeConfiguration
// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html)
// object of the UpdateIndex (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html)
// API. If you haven't enabled searching on these attributes, you can't boost
// attributes of these data types on either the console or the API.
//
// For more information on how boosting document attributes work in Amazon Q
// Business, see Boosting using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
type StringAttributeBoostingConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies specific values of a STRING type document attribute being boosted.
	AttributeValueBoosting map[string]*string `locationName:"attributeValueBoosting" min:"1" type:"map"`

	// Specifies how much a document attribute is boosted.
	//
	// BoostingLevel is a required field
	BoostingLevel *string `locationName:"boostingLevel" type:"string" required:"true" enum:"DocumentAttributeBoostingLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringAttributeBoostingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringAttributeBoostingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringAttributeBoostingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StringAttributeBoostingConfiguration"}
	if s.AttributeValueBoosting != nil && len(s.AttributeValueBoosting) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeValueBoosting", 1))
	}
	if s.BoostingLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("BoostingLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeValueBoosting sets the AttributeValueBoosting field's value.
func (s *StringAttributeBoostingConfiguration) SetAttributeValueBoosting(v map[string]*string) *StringAttributeBoostingConfiguration {
	s.AttributeValueBoosting = v
	return s
}

// SetBoostingLevel sets the BoostingLevel field's value.
func (s *StringAttributeBoostingConfiguration) SetBoostingLevel(v string) *StringAttributeBoostingConfiguration {
	s.BoostingLevel = &v
	return s
}

// Provides information on boosting STRING_LIST type document attributes.
//
// For STRING and STRING_LIST type document attributes to be used for boosting
// on the console and the API, they must be enabled for search using the DocumentAttributeConfiguration
// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html)
// object of the UpdateIndex (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html)
// API. If you haven't enabled searching on these attributes, you can't boost
// attributes of these data types on either the console or the API.
//
// For more information on how boosting document attributes work in Amazon Q
// Business, see Boosting using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html).
type StringListAttributeBoostingConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies how much a document attribute is boosted.
	//
	// BoostingLevel is a required field
	BoostingLevel *string `locationName:"boostingLevel" type:"string" required:"true" enum:"DocumentAttributeBoostingLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringListAttributeBoostingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StringListAttributeBoostingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StringListAttributeBoostingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StringListAttributeBoostingConfiguration"}
	if s.BoostingLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("BoostingLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBoostingLevel sets the BoostingLevel field's value.
func (s *StringListAttributeBoostingConfiguration) SetBoostingLevel(v string) *StringListAttributeBoostingConfiguration {
	s.BoostingLevel = &v
	return s
}

// A list of key/value pairs that identify an index, FAQ, or data source. Tag
// keys and values can consist of Unicode letters, digits, white space, and
// any of the following symbols: _ . : / = + - @.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. Keys are not case sensitive and must be unique for the
	// Amazon Q Business application or data source.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value associated with the tag. The value may be an empty string but it
	// can't be null.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Q Business application or data
	// source to tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"uri" locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// A list of tag keys to add to the Amazon Q Business application or data source.
	// If a tag already exists, the existing value is replaced with the new value.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Provides information about text documents in an index.
type TextDocumentStatistics struct {
	_ struct{} `type:"structure"`

	// The total size, in bytes, of the indexed documents.
	IndexedTextBytes *int64 `locationName:"indexedTextBytes" type:"long"`

	// The number of text documents indexed.
	IndexedTextDocumentCount *int64 `locationName:"indexedTextDocumentCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDocumentStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDocumentStatistics) GoString() string {
	return s.String()
}

// SetIndexedTextBytes sets the IndexedTextBytes field's value.
func (s *TextDocumentStatistics) SetIndexedTextBytes(v int64) *TextDocumentStatistics {
	s.IndexedTextBytes = &v
	return s
}

// SetIndexedTextDocumentCount sets the IndexedTextDocumentCount field's value.
func (s *TextDocumentStatistics) SetIndexedTextDocumentCount(v int64) *TextDocumentStatistics {
	s.IndexedTextDocumentCount = &v
	return s
}

// An input event for a end user message in an Amazon Q Business web experience.
type TextInputEvent struct {
	_ struct{} `type:"structure"`

	// A user message in a text message input event.
	//
	// UserMessage is a required field
	UserMessage *string `locationName:"userMessage" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputEvent) GoString() string {
	return s.String()
}

// SetUserMessage sets the UserMessage field's value.
func (s *TextInputEvent) SetUserMessage(v string) *TextInputEvent {
	s.UserMessage = &v
	return s
}

// The TextInputEvent is and event in the ChatInputStream group of events.
func (s *TextInputEvent) eventChatInputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TextInputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TextInputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TextInputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// An output event for an AI-generated response in an Amazon Q Business web
// experience.
type TextOutputEvent struct {
	_ struct{} `type:"structure"`

	// The identifier of the conversation with which the text output event is associated.
	ConversationId *string `locationName:"conversationId" min:"36" type:"string"`

	// An AI-generated message in a TextOutputEvent.
	SystemMessage *string `locationName:"systemMessage" min:"1" type:"string"`

	// The identifier of an AI-generated message in a TextOutputEvent.
	SystemMessageId *string `locationName:"systemMessageId" min:"36" type:"string"`

	// The identifier of an end user message in a TextOutputEvent.
	UserMessageId *string `locationName:"userMessageId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextOutputEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextOutputEvent) GoString() string {
	return s.String()
}

// SetConversationId sets the ConversationId field's value.
func (s *TextOutputEvent) SetConversationId(v string) *TextOutputEvent {
	s.ConversationId = &v
	return s
}

// SetSystemMessage sets the SystemMessage field's value.
func (s *TextOutputEvent) SetSystemMessage(v string) *TextOutputEvent {
	s.SystemMessage = &v
	return s
}

// SetSystemMessageId sets the SystemMessageId field's value.
func (s *TextOutputEvent) SetSystemMessageId(v string) *TextOutputEvent {
	s.SystemMessageId = &v
	return s
}

// SetUserMessageId sets the UserMessageId field's value.
func (s *TextOutputEvent) SetUserMessageId(v string) *TextOutputEvent {
	s.UserMessageId = &v
	return s
}

// The TextOutputEvent is and event in the ChatOutputStream group of events.
func (s *TextOutputEvent) eventChatOutputStream() {}

// UnmarshalEvent unmarshals the EventStream Message into the TextOutputEvent value.
// This method is only used internally within the SDK's EventStream handling.
func (s *TextOutputEvent) UnmarshalEvent(
	payloadUnmarshaler protocol.PayloadUnmarshaler,
	msg eventstream.Message,
) error {
	if err := payloadUnmarshaler.UnmarshalPayload(
		bytes.NewReader(msg.Payload), s,
	); err != nil {
		return err
	}
	return nil
}

// MarshalEvent marshals the type into an stream event value. This method
// should only used internally within the SDK's EventStream handling.
func (s *TextOutputEvent) MarshalEvent(pm protocol.PayloadMarshaler) (msg eventstream.Message, err error) {
	msg.Headers.Set(eventstreamapi.MessageTypeHeader, eventstream.StringValue(eventstreamapi.EventMessageType))
	var buf bytes.Buffer
	if err = pm.MarshalPayload(&buf, s); err != nil {
		return eventstream.Message{}, err
	}
	msg.Payload = buf.Bytes()
	return msg, err
}

// Provides information about a text extract in a chat response that can be
// attributed to a source document.
type TextSegment struct {
	_ struct{} `type:"structure"`

	// The zero-based location in the response string where the source attribution
	// starts.
	BeginOffset *int64 `locationName:"beginOffset" type:"integer"`

	// The zero-based location in the response string where the source attribution
	// ends.
	EndOffset *int64 `locationName:"endOffset" type:"integer"`

	// The relevant text excerpt from a source that was used to generate a citation
	// text segment in an Amazon Q Business chat response.
	SnippetExcerpt *SnippetExcerpt `locationName:"snippetExcerpt" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextSegment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextSegment) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *TextSegment) SetBeginOffset(v int64) *TextSegment {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *TextSegment) SetEndOffset(v int64) *TextSegment {
	s.EndOffset = &v
	return s
}

// SetSnippetExcerpt sets the SnippetExcerpt field's value.
func (s *TextSegment) SetSnippetExcerpt(v *SnippetExcerpt) *TextSegment {
	s.SnippetExcerpt = v
	return s
}

// The request was denied due to throttling. Reduce the number of requests and
// try again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The topic specific controls configured for an Amazon Q Business application.
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	// A description for your topic control configuration. Use this to outline how
	// the large language model (LLM) should use this topic control configuration.
	Description *string `locationName:"description" type:"string"`

	// A list of example phrases that you expect the end user to use in relation
	// to the topic.
	ExampleChatMessages []*string `locationName:"exampleChatMessages" type:"list"`

	// A name for your topic control configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Rules defined for a topic configuration.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TopicConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicConfiguration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *TopicConfiguration) SetDescription(v string) *TopicConfiguration {
	s.Description = &v
	return s
}

// SetExampleChatMessages sets the ExampleChatMessages field's value.
func (s *TopicConfiguration) SetExampleChatMessages(v []*string) *TopicConfiguration {
	s.ExampleChatMessages = v
	return s
}

// SetName sets the Name field's value.
func (s *TopicConfiguration) SetName(v string) *TopicConfiguration {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *TopicConfiguration) SetRules(v []*Rule) *TopicConfiguration {
	s.Rules = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Q Business application, or data
	// source to remove the tag from.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"uri" locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// A list of tag keys to remove from the Amazon Q Business application or data
	// source. If a tag key does not exist on the resource, it is ignored.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// An option to allow end users to upload files directly during chat.
	AttachmentsConfiguration *AttachmentsConfiguration `locationName:"attachmentsConfiguration" type:"structure"`

	// A description for the Amazon Q Business application.
	Description *string `locationName:"description" type:"string"`

	// A name for the Amazon Q Business application.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM Identity Center instance you are
	// either creating for—or connecting to—your Amazon Q Business application.
	IdentityCenterInstanceArn *string `locationName:"identityCenterInstanceArn" min:"10" type:"string"`

	// An Amazon Web Services Identity and Access Management (IAM) role that gives
	// Amazon Q Business permission to access Amazon CloudWatch logs and metrics.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IdentityCenterInstanceArn != nil && len(*s.IdentityCenterInstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityCenterInstanceArn", 10))
	}
	if s.AttachmentsConfiguration != nil {
		if err := s.AttachmentsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AttachmentsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationInput) SetApplicationId(v string) *UpdateApplicationInput {
	s.ApplicationId = &v
	return s
}

// SetAttachmentsConfiguration sets the AttachmentsConfiguration field's value.
func (s *UpdateApplicationInput) SetAttachmentsConfiguration(v *AttachmentsConfiguration) *UpdateApplicationInput {
	s.AttachmentsConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateApplicationInput) SetDisplayName(v string) *UpdateApplicationInput {
	s.DisplayName = &v
	return s
}

// SetIdentityCenterInstanceArn sets the IdentityCenterInstanceArn field's value.
func (s *UpdateApplicationInput) SetIdentityCenterInstanceArn(v string) *UpdateApplicationInput {
	s.IdentityCenterInstanceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateApplicationInput) SetRoleArn(v string) *UpdateApplicationInput {
	s.RoleArn = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

type UpdateChatControlsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application for which the chat controls are configured.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The phrases blocked from chat by your chat control configuration.
	BlockedPhrasesConfigurationUpdate *BlockedPhrasesConfigurationUpdate `locationName:"blockedPhrasesConfigurationUpdate" type:"structure"`

	// A token that you provide to identify the request to update a Amazon Q Business
	// application chat configuration.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration details for CREATOR_MODE.
	CreatorModeConfiguration *CreatorModeConfiguration `locationName:"creatorModeConfiguration" type:"structure"`

	// The response scope configured for your application. This determines whether
	// your application uses its retrieval augmented generation (RAG) system to
	// generate answers only from your enterprise data, or also uses the large language
	// models (LLM) knowledge to respons to end user questions in chat.
	ResponseScope *string `locationName:"responseScope" type:"string" enum:"ResponseScope"`

	// The configured topic specific chat controls you want to update.
	TopicConfigurationsToCreateOrUpdate []*TopicConfiguration `locationName:"topicConfigurationsToCreateOrUpdate" type:"list"`

	// The configured topic specific chat controls you want to delete.
	TopicConfigurationsToDelete []*TopicConfiguration `locationName:"topicConfigurationsToDelete" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChatControlsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChatControlsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChatControlsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChatControlsConfigurationInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.CreatorModeConfiguration != nil {
		if err := s.CreatorModeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CreatorModeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TopicConfigurationsToCreateOrUpdate != nil {
		for i, v := range s.TopicConfigurationsToCreateOrUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurationsToCreateOrUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TopicConfigurationsToDelete != nil {
		for i, v := range s.TopicConfigurationsToDelete {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurationsToDelete", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateChatControlsConfigurationInput) SetApplicationId(v string) *UpdateChatControlsConfigurationInput {
	s.ApplicationId = &v
	return s
}

// SetBlockedPhrasesConfigurationUpdate sets the BlockedPhrasesConfigurationUpdate field's value.
func (s *UpdateChatControlsConfigurationInput) SetBlockedPhrasesConfigurationUpdate(v *BlockedPhrasesConfigurationUpdate) *UpdateChatControlsConfigurationInput {
	s.BlockedPhrasesConfigurationUpdate = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateChatControlsConfigurationInput) SetClientToken(v string) *UpdateChatControlsConfigurationInput {
	s.ClientToken = &v
	return s
}

// SetCreatorModeConfiguration sets the CreatorModeConfiguration field's value.
func (s *UpdateChatControlsConfigurationInput) SetCreatorModeConfiguration(v *CreatorModeConfiguration) *UpdateChatControlsConfigurationInput {
	s.CreatorModeConfiguration = v
	return s
}

// SetResponseScope sets the ResponseScope field's value.
func (s *UpdateChatControlsConfigurationInput) SetResponseScope(v string) *UpdateChatControlsConfigurationInput {
	s.ResponseScope = &v
	return s
}

// SetTopicConfigurationsToCreateOrUpdate sets the TopicConfigurationsToCreateOrUpdate field's value.
func (s *UpdateChatControlsConfigurationInput) SetTopicConfigurationsToCreateOrUpdate(v []*TopicConfiguration) *UpdateChatControlsConfigurationInput {
	s.TopicConfigurationsToCreateOrUpdate = v
	return s
}

// SetTopicConfigurationsToDelete sets the TopicConfigurationsToDelete field's value.
func (s *UpdateChatControlsConfigurationInput) SetTopicConfigurationsToDelete(v []*TopicConfiguration) *UpdateChatControlsConfigurationInput {
	s.TopicConfigurationsToDelete = v
	return s
}

type UpdateChatControlsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChatControlsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChatControlsConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application the data source is attached
	// to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The identifier of the data source connector.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" min:"36" type:"string" required:"true"`

	// The description of the data source connector.
	Description *string `locationName:"description" type:"string"`

	// A name of the data source connector.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// Provides the configuration information for altering document metadata and
	// content during the document ingestion process.
	//
	// For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html).
	DocumentEnrichmentConfiguration *DocumentEnrichmentConfiguration `locationName:"documentEnrichmentConfiguration" type:"structure"`

	// The identifier of the index attached to the data source connector.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role with permission to access the
	// data source and required resources.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The chosen update frequency for your data source.
	SyncSchedule *string `locationName:"syncSchedule" type:"string"`

	// Provides configuration information needed to connect to an Amazon VPC (Virtual
	// Private Cloud).
	VpcConfiguration *DataSourceVpcConfiguration `locationName:"vpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.DocumentEnrichmentConfiguration != nil {
		if err := s.DocumentEnrichmentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DocumentEnrichmentConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateDataSourceInput) SetApplicationId(v string) *UpdateDataSourceInput {
	s.ApplicationId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceInput) SetDataSourceId(v string) *UpdateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateDataSourceInput) SetDisplayName(v string) *UpdateDataSourceInput {
	s.DisplayName = &v
	return s
}

// SetDocumentEnrichmentConfiguration sets the DocumentEnrichmentConfiguration field's value.
func (s *UpdateDataSourceInput) SetDocumentEnrichmentConfiguration(v *DocumentEnrichmentConfiguration) *UpdateDataSourceInput {
	s.DocumentEnrichmentConfiguration = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateDataSourceInput) SetIndexId(v string) *UpdateDataSourceInput {
	s.IndexId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateDataSourceInput) SetRoleArn(v string) *UpdateDataSourceInput {
	s.RoleArn = &v
	return s
}

// SetSyncSchedule sets the SyncSchedule field's value.
func (s *UpdateDataSourceInput) SetSyncSchedule(v string) *UpdateDataSourceInput {
	s.SyncSchedule = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *UpdateDataSourceInput) SetVpcConfiguration(v *DataSourceVpcConfiguration) *UpdateDataSourceInput {
	s.VpcConfiguration = v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

type UpdateIndexInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application connected to the index.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The storage capacity units you want to provision for your Amazon Q Business
	// index. You can add and remove capacity to fit your usage needs.
	CapacityConfiguration *IndexCapacityConfiguration `locationName:"capacityConfiguration" type:"structure"`

	// The description of the Amazon Q Business index.
	Description *string `locationName:"description" type:"string"`

	// The name of the Amazon Q Business index.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// Configuration information for document metadata or fields. Document metadata
	// are fields or attributes associated with your documents. For example, the
	// company department name associated with each document. For more information,
	// see Understanding document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes).
	DocumentAttributeConfigurations []*DocumentAttributeConfiguration `locationName:"documentAttributeConfigurations" min:"1" type:"list"`

	// The identifier of the Amazon Q Business index.
	//
	// IndexId is a required field
	IndexId *string `location:"uri" locationName:"indexId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIndexInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.DocumentAttributeConfigurations != nil && len(s.DocumentAttributeConfigurations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentAttributeConfigurations", 1))
	}
	if s.IndexId == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.CapacityConfiguration != nil {
		if err := s.CapacityConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CapacityConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentAttributeConfigurations != nil {
		for i, v := range s.DocumentAttributeConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentAttributeConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateIndexInput) SetApplicationId(v string) *UpdateIndexInput {
	s.ApplicationId = &v
	return s
}

// SetCapacityConfiguration sets the CapacityConfiguration field's value.
func (s *UpdateIndexInput) SetCapacityConfiguration(v *IndexCapacityConfiguration) *UpdateIndexInput {
	s.CapacityConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateIndexInput) SetDescription(v string) *UpdateIndexInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateIndexInput) SetDisplayName(v string) *UpdateIndexInput {
	s.DisplayName = &v
	return s
}

// SetDocumentAttributeConfigurations sets the DocumentAttributeConfigurations field's value.
func (s *UpdateIndexInput) SetDocumentAttributeConfigurations(v []*DocumentAttributeConfiguration) *UpdateIndexInput {
	s.DocumentAttributeConfigurations = v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UpdateIndexInput) SetIndexId(v string) *UpdateIndexInput {
	s.IndexId = &v
	return s
}

type UpdateIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIndexOutput) GoString() string {
	return s.String()
}

type UpdatePluginInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application the plugin is attached to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The authentication configuration the plugin is using.
	AuthConfiguration *PluginAuthConfiguration `locationName:"authConfiguration" type:"structure"`

	// The configuration for a custom plugin.
	CustomPluginConfiguration *CustomPluginConfiguration `locationName:"customPluginConfiguration" type:"structure"`

	// The name of the plugin.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The identifier of the plugin.
	//
	// PluginId is a required field
	PluginId *string `location:"uri" locationName:"pluginId" min:"36" type:"string" required:"true"`

	// The source URL used for plugin configuration.
	ServerUrl *string `locationName:"serverUrl" min:"1" type:"string"`

	// The status of the plugin.
	State *string `locationName:"state" type:"string" enum:"PluginState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePluginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePluginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePluginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePluginInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.PluginId == nil {
		invalidParams.Add(request.NewErrParamRequired("PluginId"))
	}
	if s.PluginId != nil && len(*s.PluginId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PluginId", 36))
	}
	if s.ServerUrl != nil && len(*s.ServerUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerUrl", 1))
	}
	if s.AuthConfiguration != nil {
		if err := s.AuthConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomPluginConfiguration != nil {
		if err := s.CustomPluginConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CustomPluginConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdatePluginInput) SetApplicationId(v string) *UpdatePluginInput {
	s.ApplicationId = &v
	return s
}

// SetAuthConfiguration sets the AuthConfiguration field's value.
func (s *UpdatePluginInput) SetAuthConfiguration(v *PluginAuthConfiguration) *UpdatePluginInput {
	s.AuthConfiguration = v
	return s
}

// SetCustomPluginConfiguration sets the CustomPluginConfiguration field's value.
func (s *UpdatePluginInput) SetCustomPluginConfiguration(v *CustomPluginConfiguration) *UpdatePluginInput {
	s.CustomPluginConfiguration = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdatePluginInput) SetDisplayName(v string) *UpdatePluginInput {
	s.DisplayName = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *UpdatePluginInput) SetPluginId(v string) *UpdatePluginInput {
	s.PluginId = &v
	return s
}

// SetServerUrl sets the ServerUrl field's value.
func (s *UpdatePluginInput) SetServerUrl(v string) *UpdatePluginInput {
	s.ServerUrl = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdatePluginInput) SetState(v string) *UpdatePluginInput {
	s.State = &v
	return s
}

type UpdatePluginOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePluginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePluginOutput) GoString() string {
	return s.String()
}

type UpdateRetrieverInput struct {
	_ struct{} `type:"structure"`

	// The identifier of your Amazon Q Business application.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// Provides information on how the retriever used for your Amazon Q Business
	// application is configured.
	Configuration *RetrieverConfiguration `locationName:"configuration" type:"structure"`

	// The name of your retriever.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The identifier of your retriever.
	//
	// RetrieverId is a required field
	RetrieverId *string `location:"uri" locationName:"retrieverId" min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role with permission to access the
	// retriever and required resources.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRetrieverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRetrieverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRetrieverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRetrieverInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.RetrieverId == nil {
		invalidParams.Add(request.NewErrParamRequired("RetrieverId"))
	}
	if s.RetrieverId != nil && len(*s.RetrieverId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RetrieverId", 36))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateRetrieverInput) SetApplicationId(v string) *UpdateRetrieverInput {
	s.ApplicationId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateRetrieverInput) SetConfiguration(v *RetrieverConfiguration) *UpdateRetrieverInput {
	s.Configuration = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateRetrieverInput) SetDisplayName(v string) *UpdateRetrieverInput {
	s.DisplayName = &v
	return s
}

// SetRetrieverId sets the RetrieverId field's value.
func (s *UpdateRetrieverInput) SetRetrieverId(v string) *UpdateRetrieverInput {
	s.RetrieverId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateRetrieverInput) SetRoleArn(v string) *UpdateRetrieverInput {
	s.RoleArn = &v
	return s
}

type UpdateRetrieverOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRetrieverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRetrieverOutput) GoString() string {
	return s.String()
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the application the user is attached to.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The user aliases attached to the user id that are to be deleted.
	UserAliasesToDelete []*UserAlias `locationName:"userAliasesToDelete" type:"list"`

	// The user aliases attached to the user id that are to be updated.
	UserAliasesToUpdate []*UserAlias `locationName:"userAliasesToUpdate" type:"list"`

	// The email id attached to the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.UserAliasesToDelete != nil {
		for i, v := range s.UserAliasesToDelete {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAliasesToDelete", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserAliasesToUpdate != nil {
		for i, v := range s.UserAliasesToUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UserAliasesToUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateUserInput) SetApplicationId(v string) *UpdateUserInput {
	s.ApplicationId = &v
	return s
}

// SetUserAliasesToDelete sets the UserAliasesToDelete field's value.
func (s *UpdateUserInput) SetUserAliasesToDelete(v []*UserAlias) *UpdateUserInput {
	s.UserAliasesToDelete = v
	return s
}

// SetUserAliasesToUpdate sets the UserAliasesToUpdate field's value.
func (s *UpdateUserInput) SetUserAliasesToUpdate(v []*UserAlias) *UpdateUserInput {
	s.UserAliasesToUpdate = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserInput) SetUserId(v string) *UpdateUserInput {
	s.UserId = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user aliases that have been to be added to a user id.
	UserAliasesAdded []*UserAlias `locationName:"userAliasesAdded" type:"list"`

	// The user aliases that have been deleted from a user id.
	UserAliasesDeleted []*UserAlias `locationName:"userAliasesDeleted" type:"list"`

	// The user aliases attached to a user id that have been updated.
	UserAliasesUpdated []*UserAlias `locationName:"userAliasesUpdated" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetUserAliasesAdded sets the UserAliasesAdded field's value.
func (s *UpdateUserOutput) SetUserAliasesAdded(v []*UserAlias) *UpdateUserOutput {
	s.UserAliasesAdded = v
	return s
}

// SetUserAliasesDeleted sets the UserAliasesDeleted field's value.
func (s *UpdateUserOutput) SetUserAliasesDeleted(v []*UserAlias) *UpdateUserOutput {
	s.UserAliasesDeleted = v
	return s
}

// SetUserAliasesUpdated sets the UserAliasesUpdated field's value.
func (s *UpdateUserOutput) SetUserAliasesUpdated(v []*UserAlias) *UpdateUserOutput {
	s.UserAliasesUpdated = v
	return s
}

type UpdateWebExperienceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Q Business application attached to the web experience.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" min:"36" type:"string" required:"true"`

	// The authentication configuration of the Amazon Q Business web experience.
	//
	// Deprecated: Property associated with legacy SAML IdP flow. Deprecated in favor of using AWS IAM Identity Center for user management.
	AuthenticationConfiguration *WebExperienceAuthConfiguration `locationName:"authenticationConfiguration" deprecated:"true" type:"structure"`

	// The Amazon Resource Name (ARN) of the role with permission to access the
	// Amazon Q Business web experience and required resources.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// Determines whether sample prompts are enabled in the web experience for an
	// end user.
	SamplePromptsControlMode *string `locationName:"samplePromptsControlMode" type:"string" enum:"WebExperienceSamplePromptsControlMode"`

	// The subtitle of the Amazon Q Business web experience.
	Subtitle *string `locationName:"subtitle" type:"string"`

	// The title of the Amazon Q Business web experience.
	Title *string `locationName:"title" type:"string"`

	// The identifier of the Amazon Q Business web experience.
	//
	// WebExperienceId is a required field
	WebExperienceId *string `location:"uri" locationName:"webExperienceId" min:"36" type:"string" required:"true"`

	// A customized welcome message for an end user in an Amazon Q Business web
	// experience.
	WelcomeMessage *string `locationName:"welcomeMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWebExperienceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWebExperienceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWebExperienceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWebExperienceInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 36))
	}
	if s.WebExperienceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebExperienceId"))
	}
	if s.WebExperienceId != nil && len(*s.WebExperienceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WebExperienceId", 36))
	}
	if s.AuthenticationConfiguration != nil {
		if err := s.AuthenticationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateWebExperienceInput) SetApplicationId(v string) *UpdateWebExperienceInput {
	s.ApplicationId = &v
	return s
}

// SetAuthenticationConfiguration sets the AuthenticationConfiguration field's value.
func (s *UpdateWebExperienceInput) SetAuthenticationConfiguration(v *WebExperienceAuthConfiguration) *UpdateWebExperienceInput {
	s.AuthenticationConfiguration = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateWebExperienceInput) SetRoleArn(v string) *UpdateWebExperienceInput {
	s.RoleArn = &v
	return s
}

// SetSamplePromptsControlMode sets the SamplePromptsControlMode field's value.
func (s *UpdateWebExperienceInput) SetSamplePromptsControlMode(v string) *UpdateWebExperienceInput {
	s.SamplePromptsControlMode = &v
	return s
}

// SetSubtitle sets the Subtitle field's value.
func (s *UpdateWebExperienceInput) SetSubtitle(v string) *UpdateWebExperienceInput {
	s.Subtitle = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdateWebExperienceInput) SetTitle(v string) *UpdateWebExperienceInput {
	s.Title = &v
	return s
}

// SetWebExperienceId sets the WebExperienceId field's value.
func (s *UpdateWebExperienceInput) SetWebExperienceId(v string) *UpdateWebExperienceInput {
	s.WebExperienceId = &v
	return s
}

// SetWelcomeMessage sets the WelcomeMessage field's value.
func (s *UpdateWebExperienceInput) SetWelcomeMessage(v string) *UpdateWebExperienceInput {
	s.WelcomeMessage = &v
	return s
}

type UpdateWebExperienceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWebExperienceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWebExperienceOutput) GoString() string {
	return s.String()
}

// Aliases attached to a user id within an Amazon Q Business application.
type UserAlias struct {
	_ struct{} `type:"structure"`

	// The identifier of the data source that the user aliases are associated with.
	DataSourceId *string `locationName:"dataSourceId" min:"36" type:"string"`

	// The identifier of the index that the user aliases are associated with.
	IndexId *string `locationName:"indexId" min:"36" type:"string"`

	// The identifier of the user id associated with the user aliases.
	//
	// UserId is a required field
	UserId *string `locationName:"userId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAlias) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserAlias) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserAlias"}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 36))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("IndexId", 36))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UserAlias) SetDataSourceId(v string) *UserAlias {
	s.DataSourceId = &v
	return s
}

// SetIndexId sets the IndexId field's value.
func (s *UserAlias) SetIndexId(v string) *UserAlias {
	s.IndexId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserAlias) SetUserId(v string) *UserAlias {
	s.UserId = &v
	return s
}

// Provides information about users and groups associated with a topic control
// rule.
type UsersAndGroups struct {
	_ struct{} `type:"structure"`

	// The user groups associated with a topic control rule.
	UserGroups []*string `locationName:"userGroups" type:"list"`

	// The user ids associated with a topic control rule.
	UserIds []*string `locationName:"userIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsersAndGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsersAndGroups) GoString() string {
	return s.String()
}

// SetUserGroups sets the UserGroups field's value.
func (s *UsersAndGroups) SetUserGroups(v []*string) *UsersAndGroups {
	s.UserGroups = v
	return s
}

// SetUserIds sets the UserIds field's value.
func (s *UsersAndGroups) SetUserIds(v []*string) *UsersAndGroups {
	s.UserIds = v
	return s
}

// The input doesn't meet the constraints set by the Amazon Q Business service.
// Provide the correct input and try again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The input field(s) that failed validation.
	Fields []*ValidationExceptionField `locationName:"fields" type:"list"`

	// The message describing the ValidationException.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The reason for the ValidationException.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by Amazon Q Business in
// a specified field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message about the validation exception.
	//
	// Message is a required field
	Message *string `locationName:"message" min:"1" type:"string" required:"true"`

	// The field name where the invalid entry was detected.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Provides information for an Amazon Q Business web experience.
type WebExperience struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the Amazon Q Business application was last updated.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The endpoint URLs for your Amazon Q Business web experience. The URLs are
	// unique and fully hosted by Amazon Web Services.
	DefaultEndpoint *string `locationName:"defaultEndpoint" min:"1" type:"string"`

	// The status of your Amazon Q Business web experience.
	Status *string `locationName:"status" type:"string" enum:"WebExperienceStatus"`

	// The Unix timestamp when your Amazon Q Business web experience was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The identifier of your Amazon Q Business web experience.
	WebExperienceId *string `locationName:"webExperienceId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebExperience) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebExperience) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WebExperience) SetCreatedAt(v time.Time) *WebExperience {
	s.CreatedAt = &v
	return s
}

// SetDefaultEndpoint sets the DefaultEndpoint field's value.
func (s *WebExperience) SetDefaultEndpoint(v string) *WebExperience {
	s.DefaultEndpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WebExperience) SetStatus(v string) *WebExperience {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *WebExperience) SetUpdatedAt(v time.Time) *WebExperience {
	s.UpdatedAt = &v
	return s
}

// SetWebExperienceId sets the WebExperienceId field's value.
func (s *WebExperience) SetWebExperienceId(v string) *WebExperience {
	s.WebExperienceId = &v
	return s
}

// Provides the authorization configuration information needed to deploy a Amazon
// Q Business web experience to end users.
type WebExperienceAuthConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides the SAML 2.0 compliant identity provider (IdP) configuration information
	// Amazon Q Business needs to deploy a Amazon Q Business web experience.
	SamlConfiguration *SamlConfiguration `locationName:"samlConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebExperienceAuthConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebExperienceAuthConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebExperienceAuthConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebExperienceAuthConfiguration"}
	if s.SamlConfiguration != nil {
		if err := s.SamlConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SamlConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSamlConfiguration sets the SamlConfiguration field's value.
func (s *WebExperienceAuthConfiguration) SetSamlConfiguration(v *SamlConfiguration) *WebExperienceAuthConfiguration {
	s.SamlConfiguration = v
	return s
}

const (
	// APISchemaTypeOpenApiV3 is a APISchemaType enum value
	APISchemaTypeOpenApiV3 = "OPEN_API_V3"
)

// APISchemaType_Values returns all elements of the APISchemaType enum
func APISchemaType_Values() []string {
	return []string{
		APISchemaTypeOpenApiV3,
	}
}

const (
	// ActionPayloadFieldTypeString is a ActionPayloadFieldType enum value
	ActionPayloadFieldTypeString = "STRING"

	// ActionPayloadFieldTypeNumber is a ActionPayloadFieldType enum value
	ActionPayloadFieldTypeNumber = "NUMBER"

	// ActionPayloadFieldTypeArray is a ActionPayloadFieldType enum value
	ActionPayloadFieldTypeArray = "ARRAY"

	// ActionPayloadFieldTypeBoolean is a ActionPayloadFieldType enum value
	ActionPayloadFieldTypeBoolean = "BOOLEAN"
)

// ActionPayloadFieldType_Values returns all elements of the ActionPayloadFieldType enum
func ActionPayloadFieldType_Values() []string {
	return []string{
		ActionPayloadFieldTypeString,
		ActionPayloadFieldTypeNumber,
		ActionPayloadFieldTypeArray,
		ActionPayloadFieldTypeBoolean,
	}
}

const (
	// ApplicationStatusCreating is a ApplicationStatus enum value
	ApplicationStatusCreating = "CREATING"

	// ApplicationStatusActive is a ApplicationStatus enum value
	ApplicationStatusActive = "ACTIVE"

	// ApplicationStatusDeleting is a ApplicationStatus enum value
	ApplicationStatusDeleting = "DELETING"

	// ApplicationStatusFailed is a ApplicationStatus enum value
	ApplicationStatusFailed = "FAILED"

	// ApplicationStatusUpdating is a ApplicationStatus enum value
	ApplicationStatusUpdating = "UPDATING"
)

// ApplicationStatus_Values returns all elements of the ApplicationStatus enum
func ApplicationStatus_Values() []string {
	return []string{
		ApplicationStatusCreating,
		ApplicationStatusActive,
		ApplicationStatusDeleting,
		ApplicationStatusFailed,
		ApplicationStatusUpdating,
	}
}

const (
	// AttachmentStatusFailed is a AttachmentStatus enum value
	AttachmentStatusFailed = "FAILED"

	// AttachmentStatusSucceeded is a AttachmentStatus enum value
	AttachmentStatusSucceeded = "SUCCEEDED"
)

// AttachmentStatus_Values returns all elements of the AttachmentStatus enum
func AttachmentStatus_Values() []string {
	return []string{
		AttachmentStatusFailed,
		AttachmentStatusSucceeded,
	}
}

const (
	// AttachmentsControlModeEnabled is a AttachmentsControlMode enum value
	AttachmentsControlModeEnabled = "ENABLED"

	// AttachmentsControlModeDisabled is a AttachmentsControlMode enum value
	AttachmentsControlModeDisabled = "DISABLED"
)

// AttachmentsControlMode_Values returns all elements of the AttachmentsControlMode enum
func AttachmentsControlMode_Values() []string {
	return []string{
		AttachmentsControlModeEnabled,
		AttachmentsControlModeDisabled,
	}
}

const (
	// AttributeTypeString is a AttributeType enum value
	AttributeTypeString = "STRING"

	// AttributeTypeStringList is a AttributeType enum value
	AttributeTypeStringList = "STRING_LIST"

	// AttributeTypeNumber is a AttributeType enum value
	AttributeTypeNumber = "NUMBER"

	// AttributeTypeDate is a AttributeType enum value
	AttributeTypeDate = "DATE"
)

// AttributeType_Values returns all elements of the AttributeType enum
func AttributeType_Values() []string {
	return []string{
		AttributeTypeString,
		AttributeTypeStringList,
		AttributeTypeNumber,
		AttributeTypeDate,
	}
}

const (
	// AttributeValueOperatorDelete is a AttributeValueOperator enum value
	AttributeValueOperatorDelete = "DELETE"
)

// AttributeValueOperator_Values returns all elements of the AttributeValueOperator enum
func AttributeValueOperator_Values() []string {
	return []string{
		AttributeValueOperatorDelete,
	}
}

const (
	// ChatModeRetrievalMode is a ChatMode enum value
	ChatModeRetrievalMode = "RETRIEVAL_MODE"

	// ChatModeCreatorMode is a ChatMode enum value
	ChatModeCreatorMode = "CREATOR_MODE"

	// ChatModePluginMode is a ChatMode enum value
	ChatModePluginMode = "PLUGIN_MODE"
)

// ChatMode_Values returns all elements of the ChatMode enum
func ChatMode_Values() []string {
	return []string{
		ChatModeRetrievalMode,
		ChatModeCreatorMode,
		ChatModePluginMode,
	}
}

const (
	// ContentTypePdf is a ContentType enum value
	ContentTypePdf = "PDF"

	// ContentTypeHtml is a ContentType enum value
	ContentTypeHtml = "HTML"

	// ContentTypeMsWord is a ContentType enum value
	ContentTypeMsWord = "MS_WORD"

	// ContentTypePlainText is a ContentType enum value
	ContentTypePlainText = "PLAIN_TEXT"

	// ContentTypePpt is a ContentType enum value
	ContentTypePpt = "PPT"

	// ContentTypeRtf is a ContentType enum value
	ContentTypeRtf = "RTF"

	// ContentTypeXml is a ContentType enum value
	ContentTypeXml = "XML"

	// ContentTypeXslt is a ContentType enum value
	ContentTypeXslt = "XSLT"

	// ContentTypeMsExcel is a ContentType enum value
	ContentTypeMsExcel = "MS_EXCEL"

	// ContentTypeCsv is a ContentType enum value
	ContentTypeCsv = "CSV"

	// ContentTypeJson is a ContentType enum value
	ContentTypeJson = "JSON"

	// ContentTypeMd is a ContentType enum value
	ContentTypeMd = "MD"
)

// ContentType_Values returns all elements of the ContentType enum
func ContentType_Values() []string {
	return []string{
		ContentTypePdf,
		ContentTypeHtml,
		ContentTypeMsWord,
		ContentTypePlainText,
		ContentTypePpt,
		ContentTypeRtf,
		ContentTypeXml,
		ContentTypeXslt,
		ContentTypeMsExcel,
		ContentTypeCsv,
		ContentTypeJson,
		ContentTypeMd,
	}
}

const (
	// CreatorModeControlEnabled is a CreatorModeControl enum value
	CreatorModeControlEnabled = "ENABLED"

	// CreatorModeControlDisabled is a CreatorModeControl enum value
	CreatorModeControlDisabled = "DISABLED"
)

// CreatorModeControl_Values returns all elements of the CreatorModeControl enum
func CreatorModeControl_Values() []string {
	return []string{
		CreatorModeControlEnabled,
		CreatorModeControlDisabled,
	}
}

const (
	// DataSourceStatusPendingCreation is a DataSourceStatus enum value
	DataSourceStatusPendingCreation = "PENDING_CREATION"

	// DataSourceStatusCreating is a DataSourceStatus enum value
	DataSourceStatusCreating = "CREATING"

	// DataSourceStatusActive is a DataSourceStatus enum value
	DataSourceStatusActive = "ACTIVE"

	// DataSourceStatusDeleting is a DataSourceStatus enum value
	DataSourceStatusDeleting = "DELETING"

	// DataSourceStatusFailed is a DataSourceStatus enum value
	DataSourceStatusFailed = "FAILED"

	// DataSourceStatusUpdating is a DataSourceStatus enum value
	DataSourceStatusUpdating = "UPDATING"
)

// DataSourceStatus_Values returns all elements of the DataSourceStatus enum
func DataSourceStatus_Values() []string {
	return []string{
		DataSourceStatusPendingCreation,
		DataSourceStatusCreating,
		DataSourceStatusActive,
		DataSourceStatusDeleting,
		DataSourceStatusFailed,
		DataSourceStatusUpdating,
	}
}

const (
	// DataSourceSyncJobStatusFailed is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusFailed = "FAILED"

	// DataSourceSyncJobStatusSucceeded is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSucceeded = "SUCCEEDED"

	// DataSourceSyncJobStatusSyncing is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSyncing = "SYNCING"

	// DataSourceSyncJobStatusIncomplete is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusIncomplete = "INCOMPLETE"

	// DataSourceSyncJobStatusStopping is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusStopping = "STOPPING"

	// DataSourceSyncJobStatusAborted is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusAborted = "ABORTED"

	// DataSourceSyncJobStatusSyncingIndexing is a DataSourceSyncJobStatus enum value
	DataSourceSyncJobStatusSyncingIndexing = "SYNCING_INDEXING"
)

// DataSourceSyncJobStatus_Values returns all elements of the DataSourceSyncJobStatus enum
func DataSourceSyncJobStatus_Values() []string {
	return []string{
		DataSourceSyncJobStatusFailed,
		DataSourceSyncJobStatusSucceeded,
		DataSourceSyncJobStatusSyncing,
		DataSourceSyncJobStatusIncomplete,
		DataSourceSyncJobStatusStopping,
		DataSourceSyncJobStatusAborted,
		DataSourceSyncJobStatusSyncingIndexing,
	}
}

const (
	// DocumentAttributeBoostingLevelNone is a DocumentAttributeBoostingLevel enum value
	DocumentAttributeBoostingLevelNone = "NONE"

	// DocumentAttributeBoostingLevelLow is a DocumentAttributeBoostingLevel enum value
	DocumentAttributeBoostingLevelLow = "LOW"

	// DocumentAttributeBoostingLevelMedium is a DocumentAttributeBoostingLevel enum value
	DocumentAttributeBoostingLevelMedium = "MEDIUM"

	// DocumentAttributeBoostingLevelHigh is a DocumentAttributeBoostingLevel enum value
	DocumentAttributeBoostingLevelHigh = "HIGH"

	// DocumentAttributeBoostingLevelVeryHigh is a DocumentAttributeBoostingLevel enum value
	DocumentAttributeBoostingLevelVeryHigh = "VERY_HIGH"
)

// DocumentAttributeBoostingLevel_Values returns all elements of the DocumentAttributeBoostingLevel enum
func DocumentAttributeBoostingLevel_Values() []string {
	return []string{
		DocumentAttributeBoostingLevelNone,
		DocumentAttributeBoostingLevelLow,
		DocumentAttributeBoostingLevelMedium,
		DocumentAttributeBoostingLevelHigh,
		DocumentAttributeBoostingLevelVeryHigh,
	}
}

const (
	// DocumentContentOperatorDelete is a DocumentContentOperator enum value
	DocumentContentOperatorDelete = "DELETE"
)

// DocumentContentOperator_Values returns all elements of the DocumentContentOperator enum
func DocumentContentOperator_Values() []string {
	return []string{
		DocumentContentOperatorDelete,
	}
}

const (
	// DocumentEnrichmentConditionOperatorGreaterThan is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorGreaterThan = "GREATER_THAN"

	// DocumentEnrichmentConditionOperatorGreaterThanOrEquals is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorGreaterThanOrEquals = "GREATER_THAN_OR_EQUALS"

	// DocumentEnrichmentConditionOperatorLessThan is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorLessThan = "LESS_THAN"

	// DocumentEnrichmentConditionOperatorLessThanOrEquals is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorLessThanOrEquals = "LESS_THAN_OR_EQUALS"

	// DocumentEnrichmentConditionOperatorEquals is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorEquals = "EQUALS"

	// DocumentEnrichmentConditionOperatorNotEquals is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorNotEquals = "NOT_EQUALS"

	// DocumentEnrichmentConditionOperatorContains is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorContains = "CONTAINS"

	// DocumentEnrichmentConditionOperatorNotContains is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorNotContains = "NOT_CONTAINS"

	// DocumentEnrichmentConditionOperatorExists is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorExists = "EXISTS"

	// DocumentEnrichmentConditionOperatorNotExists is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorNotExists = "NOT_EXISTS"

	// DocumentEnrichmentConditionOperatorBeginsWith is a DocumentEnrichmentConditionOperator enum value
	DocumentEnrichmentConditionOperatorBeginsWith = "BEGINS_WITH"
)

// DocumentEnrichmentConditionOperator_Values returns all elements of the DocumentEnrichmentConditionOperator enum
func DocumentEnrichmentConditionOperator_Values() []string {
	return []string{
		DocumentEnrichmentConditionOperatorGreaterThan,
		DocumentEnrichmentConditionOperatorGreaterThanOrEquals,
		DocumentEnrichmentConditionOperatorLessThan,
		DocumentEnrichmentConditionOperatorLessThanOrEquals,
		DocumentEnrichmentConditionOperatorEquals,
		DocumentEnrichmentConditionOperatorNotEquals,
		DocumentEnrichmentConditionOperatorContains,
		DocumentEnrichmentConditionOperatorNotContains,
		DocumentEnrichmentConditionOperatorExists,
		DocumentEnrichmentConditionOperatorNotExists,
		DocumentEnrichmentConditionOperatorBeginsWith,
	}
}

const (
	// DocumentStatusReceived is a DocumentStatus enum value
	DocumentStatusReceived = "RECEIVED"

	// DocumentStatusProcessing is a DocumentStatus enum value
	DocumentStatusProcessing = "PROCESSING"

	// DocumentStatusIndexed is a DocumentStatus enum value
	DocumentStatusIndexed = "INDEXED"

	// DocumentStatusUpdated is a DocumentStatus enum value
	DocumentStatusUpdated = "UPDATED"

	// DocumentStatusFailed is a DocumentStatus enum value
	DocumentStatusFailed = "FAILED"

	// DocumentStatusDeleting is a DocumentStatus enum value
	DocumentStatusDeleting = "DELETING"

	// DocumentStatusDeleted is a DocumentStatus enum value
	DocumentStatusDeleted = "DELETED"

	// DocumentStatusDocumentFailedToIndex is a DocumentStatus enum value
	DocumentStatusDocumentFailedToIndex = "DOCUMENT_FAILED_TO_INDEX"
)

// DocumentStatus_Values returns all elements of the DocumentStatus enum
func DocumentStatus_Values() []string {
	return []string{
		DocumentStatusReceived,
		DocumentStatusProcessing,
		DocumentStatusIndexed,
		DocumentStatusUpdated,
		DocumentStatusFailed,
		DocumentStatusDeleting,
		DocumentStatusDeleted,
		DocumentStatusDocumentFailedToIndex,
	}
}

const (
	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"

	// ErrorCodeInvalidRequest is a ErrorCode enum value
	ErrorCodeInvalidRequest = "InvalidRequest"

	// ErrorCodeResourceInactive is a ErrorCode enum value
	ErrorCodeResourceInactive = "ResourceInactive"

	// ErrorCodeResourceNotFound is a ErrorCode enum value
	ErrorCodeResourceNotFound = "ResourceNotFound"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeInternalError,
		ErrorCodeInvalidRequest,
		ErrorCodeResourceInactive,
		ErrorCodeResourceNotFound,
	}
}

const (
	// GroupStatusFailed is a GroupStatus enum value
	GroupStatusFailed = "FAILED"

	// GroupStatusSucceeded is a GroupStatus enum value
	GroupStatusSucceeded = "SUCCEEDED"

	// GroupStatusProcessing is a GroupStatus enum value
	GroupStatusProcessing = "PROCESSING"

	// GroupStatusDeleting is a GroupStatus enum value
	GroupStatusDeleting = "DELETING"

	// GroupStatusDeleted is a GroupStatus enum value
	GroupStatusDeleted = "DELETED"
)

// GroupStatus_Values returns all elements of the GroupStatus enum
func GroupStatus_Values() []string {
	return []string{
		GroupStatusFailed,
		GroupStatusSucceeded,
		GroupStatusProcessing,
		GroupStatusDeleting,
		GroupStatusDeleted,
	}
}

const (
	// IndexStatusCreating is a IndexStatus enum value
	IndexStatusCreating = "CREATING"

	// IndexStatusActive is a IndexStatus enum value
	IndexStatusActive = "ACTIVE"

	// IndexStatusDeleting is a IndexStatus enum value
	IndexStatusDeleting = "DELETING"

	// IndexStatusFailed is a IndexStatus enum value
	IndexStatusFailed = "FAILED"

	// IndexStatusUpdating is a IndexStatus enum value
	IndexStatusUpdating = "UPDATING"
)

// IndexStatus_Values returns all elements of the IndexStatus enum
func IndexStatus_Values() []string {
	return []string{
		IndexStatusCreating,
		IndexStatusActive,
		IndexStatusDeleting,
		IndexStatusFailed,
		IndexStatusUpdating,
	}
}

const (
	// IndexTypeEnterprise is a IndexType enum value
	IndexTypeEnterprise = "ENTERPRISE"

	// IndexTypeStarter is a IndexType enum value
	IndexTypeStarter = "STARTER"
)

// IndexType_Values returns all elements of the IndexType enum
func IndexType_Values() []string {
	return []string{
		IndexTypeEnterprise,
		IndexTypeStarter,
	}
}

const (
	// MemberRelationAnd is a MemberRelation enum value
	MemberRelationAnd = "AND"

	// MemberRelationOr is a MemberRelation enum value
	MemberRelationOr = "OR"
)

// MemberRelation_Values returns all elements of the MemberRelation enum
func MemberRelation_Values() []string {
	return []string{
		MemberRelationAnd,
		MemberRelationOr,
	}
}

const (
	// MembershipTypeIndex is a MembershipType enum value
	MembershipTypeIndex = "INDEX"

	// MembershipTypeDatasource is a MembershipType enum value
	MembershipTypeDatasource = "DATASOURCE"
)

// MembershipType_Values returns all elements of the MembershipType enum
func MembershipType_Values() []string {
	return []string{
		MembershipTypeIndex,
		MembershipTypeDatasource,
	}
}

const (
	// MessageTypeUser is a MessageType enum value
	MessageTypeUser = "USER"

	// MessageTypeSystem is a MessageType enum value
	MessageTypeSystem = "SYSTEM"
)

// MessageType_Values returns all elements of the MessageType enum
func MessageType_Values() []string {
	return []string{
		MessageTypeUser,
		MessageTypeSystem,
	}
}

const (
	// MessageUsefulnessUseful is a MessageUsefulness enum value
	MessageUsefulnessUseful = "USEFUL"

	// MessageUsefulnessNotUseful is a MessageUsefulness enum value
	MessageUsefulnessNotUseful = "NOT_USEFUL"
)

// MessageUsefulness_Values returns all elements of the MessageUsefulness enum
func MessageUsefulness_Values() []string {
	return []string{
		MessageUsefulnessUseful,
		MessageUsefulnessNotUseful,
	}
}

const (
	// MessageUsefulnessReasonNotFactuallyCorrect is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonNotFactuallyCorrect = "NOT_FACTUALLY_CORRECT"

	// MessageUsefulnessReasonHarmfulOrUnsafe is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonHarmfulOrUnsafe = "HARMFUL_OR_UNSAFE"

	// MessageUsefulnessReasonIncorrectOrMissingSources is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonIncorrectOrMissingSources = "INCORRECT_OR_MISSING_SOURCES"

	// MessageUsefulnessReasonNotHelpful is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonNotHelpful = "NOT_HELPFUL"

	// MessageUsefulnessReasonFactuallyCorrect is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonFactuallyCorrect = "FACTUALLY_CORRECT"

	// MessageUsefulnessReasonComplete is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonComplete = "COMPLETE"

	// MessageUsefulnessReasonRelevantSources is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonRelevantSources = "RELEVANT_SOURCES"

	// MessageUsefulnessReasonHelpful is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonHelpful = "HELPFUL"

	// MessageUsefulnessReasonNotBasedOnDocuments is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonNotBasedOnDocuments = "NOT_BASED_ON_DOCUMENTS"

	// MessageUsefulnessReasonNotComplete is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonNotComplete = "NOT_COMPLETE"

	// MessageUsefulnessReasonNotConcise is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonNotConcise = "NOT_CONCISE"

	// MessageUsefulnessReasonOther is a MessageUsefulnessReason enum value
	MessageUsefulnessReasonOther = "OTHER"
)

// MessageUsefulnessReason_Values returns all elements of the MessageUsefulnessReason enum
func MessageUsefulnessReason_Values() []string {
	return []string{
		MessageUsefulnessReasonNotFactuallyCorrect,
		MessageUsefulnessReasonHarmfulOrUnsafe,
		MessageUsefulnessReasonIncorrectOrMissingSources,
		MessageUsefulnessReasonNotHelpful,
		MessageUsefulnessReasonFactuallyCorrect,
		MessageUsefulnessReasonComplete,
		MessageUsefulnessReasonRelevantSources,
		MessageUsefulnessReasonHelpful,
		MessageUsefulnessReasonNotBasedOnDocuments,
		MessageUsefulnessReasonNotComplete,
		MessageUsefulnessReasonNotConcise,
		MessageUsefulnessReasonOther,
	}
}

const (
	// NumberAttributeBoostingTypePrioritizeLargerValues is a NumberAttributeBoostingType enum value
	NumberAttributeBoostingTypePrioritizeLargerValues = "PRIORITIZE_LARGER_VALUES"

	// NumberAttributeBoostingTypePrioritizeSmallerValues is a NumberAttributeBoostingType enum value
	NumberAttributeBoostingTypePrioritizeSmallerValues = "PRIORITIZE_SMALLER_VALUES"
)

// NumberAttributeBoostingType_Values returns all elements of the NumberAttributeBoostingType enum
func NumberAttributeBoostingType_Values() []string {
	return []string{
		NumberAttributeBoostingTypePrioritizeLargerValues,
		NumberAttributeBoostingTypePrioritizeSmallerValues,
	}
}

const (
	// PluginBuildStatusReady is a PluginBuildStatus enum value
	PluginBuildStatusReady = "READY"

	// PluginBuildStatusCreateInProgress is a PluginBuildStatus enum value
	PluginBuildStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// PluginBuildStatusCreateFailed is a PluginBuildStatus enum value
	PluginBuildStatusCreateFailed = "CREATE_FAILED"

	// PluginBuildStatusUpdateInProgress is a PluginBuildStatus enum value
	PluginBuildStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// PluginBuildStatusUpdateFailed is a PluginBuildStatus enum value
	PluginBuildStatusUpdateFailed = "UPDATE_FAILED"

	// PluginBuildStatusDeleteInProgress is a PluginBuildStatus enum value
	PluginBuildStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// PluginBuildStatusDeleteFailed is a PluginBuildStatus enum value
	PluginBuildStatusDeleteFailed = "DELETE_FAILED"
)

// PluginBuildStatus_Values returns all elements of the PluginBuildStatus enum
func PluginBuildStatus_Values() []string {
	return []string{
		PluginBuildStatusReady,
		PluginBuildStatusCreateInProgress,
		PluginBuildStatusCreateFailed,
		PluginBuildStatusUpdateInProgress,
		PluginBuildStatusUpdateFailed,
		PluginBuildStatusDeleteInProgress,
		PluginBuildStatusDeleteFailed,
	}
}

const (
	// PluginStateEnabled is a PluginState enum value
	PluginStateEnabled = "ENABLED"

	// PluginStateDisabled is a PluginState enum value
	PluginStateDisabled = "DISABLED"
)

// PluginState_Values returns all elements of the PluginState enum
func PluginState_Values() []string {
	return []string{
		PluginStateEnabled,
		PluginStateDisabled,
	}
}

const (
	// PluginTypeServiceNow is a PluginType enum value
	PluginTypeServiceNow = "SERVICE_NOW"

	// PluginTypeSalesforce is a PluginType enum value
	PluginTypeSalesforce = "SALESFORCE"

	// PluginTypeJira is a PluginType enum value
	PluginTypeJira = "JIRA"

	// PluginTypeZendesk is a PluginType enum value
	PluginTypeZendesk = "ZENDESK"

	// PluginTypeCustom is a PluginType enum value
	PluginTypeCustom = "CUSTOM"
)

// PluginType_Values returns all elements of the PluginType enum
func PluginType_Values() []string {
	return []string{
		PluginTypeServiceNow,
		PluginTypeSalesforce,
		PluginTypeJira,
		PluginTypeZendesk,
		PluginTypeCustom,
	}
}

const (
	// ReadAccessTypeAllow is a ReadAccessType enum value
	ReadAccessTypeAllow = "ALLOW"

	// ReadAccessTypeDeny is a ReadAccessType enum value
	ReadAccessTypeDeny = "DENY"
)

// ReadAccessType_Values returns all elements of the ReadAccessType enum
func ReadAccessType_Values() []string {
	return []string{
		ReadAccessTypeAllow,
		ReadAccessTypeDeny,
	}
}

const (
	// ResponseScopeEnterpriseContentOnly is a ResponseScope enum value
	ResponseScopeEnterpriseContentOnly = "ENTERPRISE_CONTENT_ONLY"

	// ResponseScopeExtendedKnowledgeEnabled is a ResponseScope enum value
	ResponseScopeExtendedKnowledgeEnabled = "EXTENDED_KNOWLEDGE_ENABLED"
)

// ResponseScope_Values returns all elements of the ResponseScope enum
func ResponseScope_Values() []string {
	return []string{
		ResponseScopeEnterpriseContentOnly,
		ResponseScopeExtendedKnowledgeEnabled,
	}
}

const (
	// RetrieverStatusCreating is a RetrieverStatus enum value
	RetrieverStatusCreating = "CREATING"

	// RetrieverStatusActive is a RetrieverStatus enum value
	RetrieverStatusActive = "ACTIVE"

	// RetrieverStatusFailed is a RetrieverStatus enum value
	RetrieverStatusFailed = "FAILED"
)

// RetrieverStatus_Values returns all elements of the RetrieverStatus enum
func RetrieverStatus_Values() []string {
	return []string{
		RetrieverStatusCreating,
		RetrieverStatusActive,
		RetrieverStatusFailed,
	}
}

const (
	// RetrieverTypeNativeIndex is a RetrieverType enum value
	RetrieverTypeNativeIndex = "NATIVE_INDEX"

	// RetrieverTypeKendraIndex is a RetrieverType enum value
	RetrieverTypeKendraIndex = "KENDRA_INDEX"
)

// RetrieverType_Values returns all elements of the RetrieverType enum
func RetrieverType_Values() []string {
	return []string{
		RetrieverTypeNativeIndex,
		RetrieverTypeKendraIndex,
	}
}

const (
	// RuleTypeContentBlockerRule is a RuleType enum value
	RuleTypeContentBlockerRule = "CONTENT_BLOCKER_RULE"

	// RuleTypeContentRetrievalRule is a RuleType enum value
	RuleTypeContentRetrievalRule = "CONTENT_RETRIEVAL_RULE"
)

// RuleType_Values returns all elements of the RuleType enum
func RuleType_Values() []string {
	return []string{
		RuleTypeContentBlockerRule,
		RuleTypeContentRetrievalRule,
	}
}

const (
	// StatusEnabled is a Status enum value
	StatusEnabled = "ENABLED"

	// StatusDisabled is a Status enum value
	StatusDisabled = "DISABLED"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusEnabled,
		StatusDisabled,
	}
}

const (
	// StringAttributeValueBoostingLevelLow is a StringAttributeValueBoostingLevel enum value
	StringAttributeValueBoostingLevelLow = "LOW"

	// StringAttributeValueBoostingLevelMedium is a StringAttributeValueBoostingLevel enum value
	StringAttributeValueBoostingLevelMedium = "MEDIUM"

	// StringAttributeValueBoostingLevelHigh is a StringAttributeValueBoostingLevel enum value
	StringAttributeValueBoostingLevelHigh = "HIGH"

	// StringAttributeValueBoostingLevelVeryHigh is a StringAttributeValueBoostingLevel enum value
	StringAttributeValueBoostingLevelVeryHigh = "VERY_HIGH"
)

// StringAttributeValueBoostingLevel_Values returns all elements of the StringAttributeValueBoostingLevel enum
func StringAttributeValueBoostingLevel_Values() []string {
	return []string{
		StringAttributeValueBoostingLevelLow,
		StringAttributeValueBoostingLevelMedium,
		StringAttributeValueBoostingLevelHigh,
		StringAttributeValueBoostingLevelVeryHigh,
	}
}

const (
	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonUnknownOperation,
	}
}

const (
	// WebExperienceSamplePromptsControlModeEnabled is a WebExperienceSamplePromptsControlMode enum value
	WebExperienceSamplePromptsControlModeEnabled = "ENABLED"

	// WebExperienceSamplePromptsControlModeDisabled is a WebExperienceSamplePromptsControlMode enum value
	WebExperienceSamplePromptsControlModeDisabled = "DISABLED"
)

// WebExperienceSamplePromptsControlMode_Values returns all elements of the WebExperienceSamplePromptsControlMode enum
func WebExperienceSamplePromptsControlMode_Values() []string {
	return []string{
		WebExperienceSamplePromptsControlModeEnabled,
		WebExperienceSamplePromptsControlModeDisabled,
	}
}

const (
	// WebExperienceStatusCreating is a WebExperienceStatus enum value
	WebExperienceStatusCreating = "CREATING"

	// WebExperienceStatusActive is a WebExperienceStatus enum value
	WebExperienceStatusActive = "ACTIVE"

	// WebExperienceStatusDeleting is a WebExperienceStatus enum value
	WebExperienceStatusDeleting = "DELETING"

	// WebExperienceStatusFailed is a WebExperienceStatus enum value
	WebExperienceStatusFailed = "FAILED"

	// WebExperienceStatusPendingAuthConfig is a WebExperienceStatus enum value
	WebExperienceStatusPendingAuthConfig = "PENDING_AUTH_CONFIG"
)

// WebExperienceStatus_Values returns all elements of the WebExperienceStatus enum
func WebExperienceStatus_Values() []string {
	return []string{
		WebExperienceStatusCreating,
		WebExperienceStatusActive,
		WebExperienceStatusDeleting,
		WebExperienceStatusFailed,
		WebExperienceStatusPendingAuthConfig,
	}
}
