// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/gkemulticloud/v1/attached_service.proto

package gkemulticloudpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AttachedClusters_CreateAttachedCluster_FullMethodName                  = "/google.cloud.gkemulticloud.v1.AttachedClusters/CreateAttachedCluster"
	AttachedClusters_UpdateAttachedCluster_FullMethodName                  = "/google.cloud.gkemulticloud.v1.AttachedClusters/UpdateAttachedCluster"
	AttachedClusters_ImportAttachedCluster_FullMethodName                  = "/google.cloud.gkemulticloud.v1.AttachedClusters/ImportAttachedCluster"
	AttachedClusters_GetAttachedCluster_FullMethodName                     = "/google.cloud.gkemulticloud.v1.AttachedClusters/GetAttachedCluster"
	AttachedClusters_ListAttachedClusters_FullMethodName                   = "/google.cloud.gkemulticloud.v1.AttachedClusters/ListAttachedClusters"
	AttachedClusters_DeleteAttachedCluster_FullMethodName                  = "/google.cloud.gkemulticloud.v1.AttachedClusters/DeleteAttachedCluster"
	AttachedClusters_GetAttachedServerConfig_FullMethodName                = "/google.cloud.gkemulticloud.v1.AttachedClusters/GetAttachedServerConfig"
	AttachedClusters_GenerateAttachedClusterInstallManifest_FullMethodName = "/google.cloud.gkemulticloud.v1.AttachedClusters/GenerateAttachedClusterInstallManifest"
	AttachedClusters_GenerateAttachedClusterAgentToken_FullMethodName      = "/google.cloud.gkemulticloud.v1.AttachedClusters/GenerateAttachedClusterAgentToken"
)

// AttachedClustersClient is the client API for AttachedClusters service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AttachedClustersClient interface {
	// Creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAttachedCluster(ctx context.Context, in *CreateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
	UpdateAttachedCluster(ctx context.Context, in *UpdateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// by importing an existing Fleet Membership resource.
	//
	// Attached Clusters created before the introduction of the Anthos Multi-Cloud
	// API can be imported through this method.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	ImportAttachedCluster(ctx context.Context, in *ImportAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	GetAttachedCluster(ctx context.Context, in *GetAttachedClusterRequest, opts ...grpc.CallOption) (*AttachedCluster, error)
	// Lists all [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]
	// resources on a given Google Cloud project and region.
	ListAttachedClusters(ctx context.Context, in *ListAttachedClustersRequest, opts ...grpc.CallOption) (*ListAttachedClustersResponse, error)
	// Deletes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAttachedCluster(ctx context.Context, in *DeleteAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns information, such as supported Kubernetes versions, on a given
	// Google Cloud location.
	GetAttachedServerConfig(ctx context.Context, in *GetAttachedServerConfigRequest, opts ...grpc.CallOption) (*AttachedServerConfig, error)
	// Generates the install manifest to be installed on the target cluster.
	GenerateAttachedClusterInstallManifest(ctx context.Context, in *GenerateAttachedClusterInstallManifestRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterInstallManifestResponse, error)
	// Generates an access token for a cluster agent.
	GenerateAttachedClusterAgentToken(ctx context.Context, in *GenerateAttachedClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterAgentTokenResponse, error)
}

type attachedClustersClient struct {
	cc grpc.ClientConnInterface
}

func NewAttachedClustersClient(cc grpc.ClientConnInterface) AttachedClustersClient {
	return &attachedClustersClient{cc}
}

func (c *attachedClustersClient) CreateAttachedCluster(ctx context.Context, in *CreateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AttachedClusters_CreateAttachedCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) UpdateAttachedCluster(ctx context.Context, in *UpdateAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AttachedClusters_UpdateAttachedCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) ImportAttachedCluster(ctx context.Context, in *ImportAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AttachedClusters_ImportAttachedCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GetAttachedCluster(ctx context.Context, in *GetAttachedClusterRequest, opts ...grpc.CallOption) (*AttachedCluster, error) {
	out := new(AttachedCluster)
	err := c.cc.Invoke(ctx, AttachedClusters_GetAttachedCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) ListAttachedClusters(ctx context.Context, in *ListAttachedClustersRequest, opts ...grpc.CallOption) (*ListAttachedClustersResponse, error) {
	out := new(ListAttachedClustersResponse)
	err := c.cc.Invoke(ctx, AttachedClusters_ListAttachedClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) DeleteAttachedCluster(ctx context.Context, in *DeleteAttachedClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AttachedClusters_DeleteAttachedCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GetAttachedServerConfig(ctx context.Context, in *GetAttachedServerConfigRequest, opts ...grpc.CallOption) (*AttachedServerConfig, error) {
	out := new(AttachedServerConfig)
	err := c.cc.Invoke(ctx, AttachedClusters_GetAttachedServerConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GenerateAttachedClusterInstallManifest(ctx context.Context, in *GenerateAttachedClusterInstallManifestRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterInstallManifestResponse, error) {
	out := new(GenerateAttachedClusterInstallManifestResponse)
	err := c.cc.Invoke(ctx, AttachedClusters_GenerateAttachedClusterInstallManifest_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *attachedClustersClient) GenerateAttachedClusterAgentToken(ctx context.Context, in *GenerateAttachedClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAttachedClusterAgentTokenResponse, error) {
	out := new(GenerateAttachedClusterAgentTokenResponse)
	err := c.cc.Invoke(ctx, AttachedClusters_GenerateAttachedClusterAgentToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AttachedClustersServer is the server API for AttachedClusters service.
// All implementations should embed UnimplementedAttachedClustersServer
// for forward compatibility
type AttachedClustersServer interface {
	// Creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAttachedCluster(context.Context, *CreateAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Updates an
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
	UpdateAttachedCluster(context.Context, *UpdateAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Imports creates a new
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
	// by importing an existing Fleet Membership resource.
	//
	// Attached Clusters created before the introduction of the Anthos Multi-Cloud
	// API can be imported through this method.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	ImportAttachedCluster(context.Context, *ImportAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Describes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	GetAttachedCluster(context.Context, *GetAttachedClusterRequest) (*AttachedCluster, error)
	// Lists all [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]
	// resources on a given Google Cloud project and region.
	ListAttachedClusters(context.Context, *ListAttachedClustersRequest) (*ListAttachedClustersResponse, error)
	// Deletes a specific
	// [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAttachedCluster(context.Context, *DeleteAttachedClusterRequest) (*longrunningpb.Operation, error)
	// Returns information, such as supported Kubernetes versions, on a given
	// Google Cloud location.
	GetAttachedServerConfig(context.Context, *GetAttachedServerConfigRequest) (*AttachedServerConfig, error)
	// Generates the install manifest to be installed on the target cluster.
	GenerateAttachedClusterInstallManifest(context.Context, *GenerateAttachedClusterInstallManifestRequest) (*GenerateAttachedClusterInstallManifestResponse, error)
	// Generates an access token for a cluster agent.
	GenerateAttachedClusterAgentToken(context.Context, *GenerateAttachedClusterAgentTokenRequest) (*GenerateAttachedClusterAgentTokenResponse, error)
}

// UnimplementedAttachedClustersServer should be embedded to have forward compatible implementations.
type UnimplementedAttachedClustersServer struct {
}

func (UnimplementedAttachedClustersServer) CreateAttachedCluster(context.Context, *CreateAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAttachedCluster not implemented")
}
func (UnimplementedAttachedClustersServer) UpdateAttachedCluster(context.Context, *UpdateAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttachedCluster not implemented")
}
func (UnimplementedAttachedClustersServer) ImportAttachedCluster(context.Context, *ImportAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAttachedCluster not implemented")
}
func (UnimplementedAttachedClustersServer) GetAttachedCluster(context.Context, *GetAttachedClusterRequest) (*AttachedCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttachedCluster not implemented")
}
func (UnimplementedAttachedClustersServer) ListAttachedClusters(context.Context, *ListAttachedClustersRequest) (*ListAttachedClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttachedClusters not implemented")
}
func (UnimplementedAttachedClustersServer) DeleteAttachedCluster(context.Context, *DeleteAttachedClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAttachedCluster not implemented")
}
func (UnimplementedAttachedClustersServer) GetAttachedServerConfig(context.Context, *GetAttachedServerConfigRequest) (*AttachedServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttachedServerConfig not implemented")
}
func (UnimplementedAttachedClustersServer) GenerateAttachedClusterInstallManifest(context.Context, *GenerateAttachedClusterInstallManifestRequest) (*GenerateAttachedClusterInstallManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAttachedClusterInstallManifest not implemented")
}
func (UnimplementedAttachedClustersServer) GenerateAttachedClusterAgentToken(context.Context, *GenerateAttachedClusterAgentTokenRequest) (*GenerateAttachedClusterAgentTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAttachedClusterAgentToken not implemented")
}

// UnsafeAttachedClustersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AttachedClustersServer will
// result in compilation errors.
type UnsafeAttachedClustersServer interface {
	mustEmbedUnimplementedAttachedClustersServer()
}

func RegisterAttachedClustersServer(s grpc.ServiceRegistrar, srv AttachedClustersServer) {
	s.RegisterService(&AttachedClusters_ServiceDesc, srv)
}

func _AttachedClusters_CreateAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).CreateAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_CreateAttachedCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).CreateAttachedCluster(ctx, req.(*CreateAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_UpdateAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).UpdateAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_UpdateAttachedCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).UpdateAttachedCluster(ctx, req.(*UpdateAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_ImportAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).ImportAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_ImportAttachedCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).ImportAttachedCluster(ctx, req.(*ImportAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GetAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GetAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_GetAttachedCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GetAttachedCluster(ctx, req.(*GetAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_ListAttachedClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttachedClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).ListAttachedClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_ListAttachedClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).ListAttachedClusters(ctx, req.(*ListAttachedClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_DeleteAttachedCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttachedClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).DeleteAttachedCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_DeleteAttachedCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).DeleteAttachedCluster(ctx, req.(*DeleteAttachedClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GetAttachedServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttachedServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GetAttachedServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_GetAttachedServerConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GetAttachedServerConfig(ctx, req.(*GetAttachedServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GenerateAttachedClusterInstallManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAttachedClusterInstallManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GenerateAttachedClusterInstallManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_GenerateAttachedClusterInstallManifest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GenerateAttachedClusterInstallManifest(ctx, req.(*GenerateAttachedClusterInstallManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AttachedClusters_GenerateAttachedClusterAgentToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAttachedClusterAgentTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AttachedClustersServer).GenerateAttachedClusterAgentToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AttachedClusters_GenerateAttachedClusterAgentToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AttachedClustersServer).GenerateAttachedClusterAgentToken(ctx, req.(*GenerateAttachedClusterAgentTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AttachedClusters_ServiceDesc is the grpc.ServiceDesc for AttachedClusters service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AttachedClusters_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkemulticloud.v1.AttachedClusters",
	HandlerType: (*AttachedClustersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAttachedCluster",
			Handler:    _AttachedClusters_CreateAttachedCluster_Handler,
		},
		{
			MethodName: "UpdateAttachedCluster",
			Handler:    _AttachedClusters_UpdateAttachedCluster_Handler,
		},
		{
			MethodName: "ImportAttachedCluster",
			Handler:    _AttachedClusters_ImportAttachedCluster_Handler,
		},
		{
			MethodName: "GetAttachedCluster",
			Handler:    _AttachedClusters_GetAttachedCluster_Handler,
		},
		{
			MethodName: "ListAttachedClusters",
			Handler:    _AttachedClusters_ListAttachedClusters_Handler,
		},
		{
			MethodName: "DeleteAttachedCluster",
			Handler:    _AttachedClusters_DeleteAttachedCluster_Handler,
		},
		{
			MethodName: "GetAttachedServerConfig",
			Handler:    _AttachedClusters_GetAttachedServerConfig_Handler,
		},
		{
			MethodName: "GenerateAttachedClusterInstallManifest",
			Handler:    _AttachedClusters_GenerateAttachedClusterInstallManifest_Handler,
		},
		{
			MethodName: "GenerateAttachedClusterAgentToken",
			Handler:    _AttachedClusters_GenerateAttachedClusterAgentToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkemulticloud/v1/attached_service.proto",
}
