// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package firebaseappdistribution provides access to the Firebase App Distribution API.
//
// For product documentation, see: https://firebase.google.com/products/app-distribution
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/firebaseappdistribution/v1"
//	...
//	ctx := context.Background()
//	firebaseappdistributionService, err := firebaseappdistribution.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	firebaseappdistributionService, err := firebaseappdistribution.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	firebaseappdistributionService, err := firebaseappdistribution.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package firebaseappdistribution // import "google.golang.org/api/firebaseappdistribution/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "firebaseappdistribution:v1"
const apiName = "firebaseappdistribution"
const apiVersion = "v1"
const basePath = "https://firebaseappdistribution.googleapis.com/"
const basePathTemplate = "https://firebaseappdistribution.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://firebaseappdistribution.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Media = NewMediaService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Media *MediaService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Apps = NewProjectsAppsService(s)
	rs.Groups = NewProjectsGroupsService(s)
	rs.Testers = NewProjectsTestersService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Apps *ProjectsAppsService

	Groups *ProjectsGroupsService

	Testers *ProjectsTestersService
}

func NewProjectsAppsService(s *Service) *ProjectsAppsService {
	rs := &ProjectsAppsService{s: s}
	rs.Releases = NewProjectsAppsReleasesService(s)
	return rs
}

type ProjectsAppsService struct {
	s *Service

	Releases *ProjectsAppsReleasesService
}

func NewProjectsAppsReleasesService(s *Service) *ProjectsAppsReleasesService {
	rs := &ProjectsAppsReleasesService{s: s}
	rs.FeedbackReports = NewProjectsAppsReleasesFeedbackReportsService(s)
	rs.Operations = NewProjectsAppsReleasesOperationsService(s)
	return rs
}

type ProjectsAppsReleasesService struct {
	s *Service

	FeedbackReports *ProjectsAppsReleasesFeedbackReportsService

	Operations *ProjectsAppsReleasesOperationsService
}

func NewProjectsAppsReleasesFeedbackReportsService(s *Service) *ProjectsAppsReleasesFeedbackReportsService {
	rs := &ProjectsAppsReleasesFeedbackReportsService{s: s}
	return rs
}

type ProjectsAppsReleasesFeedbackReportsService struct {
	s *Service
}

func NewProjectsAppsReleasesOperationsService(s *Service) *ProjectsAppsReleasesOperationsService {
	rs := &ProjectsAppsReleasesOperationsService{s: s}
	return rs
}

type ProjectsAppsReleasesOperationsService struct {
	s *Service
}

func NewProjectsGroupsService(s *Service) *ProjectsGroupsService {
	rs := &ProjectsGroupsService{s: s}
	return rs
}

type ProjectsGroupsService struct {
	s *Service
}

func NewProjectsTestersService(s *Service) *ProjectsTestersService {
	rs := &ProjectsTestersService{s: s}
	return rs
}

type ProjectsTestersService struct {
	s *Service
}

// GdataBlobstore2Info: Information to read/write to blobstore2.
type GdataBlobstore2Info struct {
	// BlobGeneration: The blob generation id.
	BlobGeneration int64 `json:"blobGeneration,omitempty,string"`
	// BlobId: The blob id, e.g., /blobstore/prod/playground/scotty
	BlobId string `json:"blobId,omitempty"`
	// DownloadReadHandle: Read handle passed from Bigstore -> Scotty for a GCS
	// download. This is a signed, serialized blobstore2.ReadHandle proto which
	// must never be set outside of Bigstore, and is not applicable to non-GCS
	// media downloads.
	DownloadReadHandle string `json:"downloadReadHandle,omitempty"`
	// ReadToken: The blob read token. Needed to read blobs that have not been
	// replicated. Might not be available until the final call.
	ReadToken string `json:"readToken,omitempty"`
	// UploadMetadataContainer: Metadata passed from Blobstore -> Scotty for a new
	// GCS upload. This is a signed, serialized blobstore2.BlobMetadataContainer
	// proto which must never be consumed outside of Bigstore, and is not
	// applicable to non-GCS media uploads.
	UploadMetadataContainer string `json:"uploadMetadataContainer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobGeneration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobGeneration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataBlobstore2Info) MarshalJSON() ([]byte, error) {
	type NoMethod GdataBlobstore2Info
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataCompositeMedia: A sequence of media data references representing
// composite data. Introduced to support Bigstore composite objects. For
// details, visit http://go/bigstore-composites.
type GdataCompositeMedia struct {
	// BlobRef: Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This
	// should be the byte representation of a blobstore.BlobRef. Since Blobstore is
	// deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
	// be represented in this field as v1 BlobRef.
	BlobRef string `json:"blobRef,omitempty"`
	// Blobstore2Info: Blobstore v2 info, set if reference_type is BLOBSTORE_REF
	// and it refers to a v2 blob.
	Blobstore2Info *GdataBlobstore2Info `json:"blobstore2Info,omitempty"`
	// CosmoBinaryReference: A binary data reference for a media download. Serves
	// as a technology-agnostic binary reference in some Google infrastructure.
	// This value is a serialized storage_cosmo.BinaryReference proto. Storing it
	// as bytes is a hack to get around the fact that the cosmo proto (as well as
	// others it includes) doesn't support JavaScript. This prevents us from
	// including the actual type of this field.
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`
	// Crc32cHash: crc32.c hash for the payload.
	Crc32cHash int64 `json:"crc32cHash,omitempty"`
	// Inline: Media data, set if reference_type is INLINE
	Inline string `json:"inline,omitempty"`
	// Length: Size of the data, in bytes
	Length int64 `json:"length,omitempty,string"`
	// Md5Hash: MD5 hash for the payload.
	Md5Hash string `json:"md5Hash,omitempty"`
	// ObjectId: Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
	ObjectId *GdataObjectId `json:"objectId,omitempty"`
	// Path: Path to the data, set if reference_type is PATH
	Path string `json:"path,omitempty"`
	// ReferenceType: Describes what the field reference contains.
	//
	// Possible values:
	//   "PATH" - Reference contains a GFS path or a local path.
	//   "BLOB_REF" - Reference points to a blobstore object. This could be either
	// a v1 blob_ref or a v2 blobstore2_info. Clients should check blobstore2_info
	// first, since v1 is being deprecated.
	//   "INLINE" - Data is included into this proto buffer
	//   "BIGSTORE_REF" - Reference points to a bigstore object
	//   "COSMO_BINARY_REFERENCE" - Indicates the data is stored in
	// cosmo_binary_reference.
	ReferenceType string `json:"referenceType,omitempty"`
	// Sha1Hash: SHA-1 hash for the payload.
	Sha1Hash string `json:"sha1Hash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlobRef") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlobRef") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataCompositeMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GdataCompositeMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataContentTypeInfo: Detailed Content-Type information from Scotty. The
// Content-Type of the media will typically be filled in by the header or
// Scotty's best_guess, but this extended information provides the backend with
// more information so that it can make a better decision if needed. This is
// only used on media upload requests from Scotty.
type GdataContentTypeInfo struct {
	// BestGuess: Scotty's best guess of what the content type of the file is.
	BestGuess string `json:"bestGuess,omitempty"`
	// FromBytes: The content type of the file derived by looking at specific bytes
	// (i.e. "magic bytes") of the actual file.
	FromBytes string `json:"fromBytes,omitempty"`
	// FromFileName: The content type of the file derived from the file extension
	// of the original file name used by the client.
	FromFileName string `json:"fromFileName,omitempty"`
	// FromHeader: The content type of the file as specified in the request
	// headers, multipart headers, or RUPIO start request.
	FromHeader string `json:"fromHeader,omitempty"`
	// FromUrlPath: The content type of the file derived from the file extension of
	// the URL path. The URL path is assumed to represent a file name (which is
	// typically only true for agents that are providing a REST API).
	FromUrlPath string `json:"fromUrlPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BestGuess") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BestGuess") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataContentTypeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GdataContentTypeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffChecksumsResponse: Backend response for a Diff get checksums
// response. For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type GdataDiffChecksumsResponse struct {
	// ChecksumsLocation: Exactly one of these fields must be populated. If
	// checksums_location is filled, the server will return the corresponding
	// contents to the user. If object_location is filled, the server will
	// calculate the checksums based on the content there and return that to the
	// user. For details on the format of the checksums, see
	// http://go/scotty-diff-protocol.
	ChecksumsLocation *GdataCompositeMedia `json:"checksumsLocation,omitempty"`
	// ChunkSizeBytes: The chunk size of checksums. Must be a multiple of 256KB.
	ChunkSizeBytes int64 `json:"chunkSizeBytes,omitempty,string"`
	// ObjectLocation: If set, calculate the checksums based on the contents and
	// return them to the caller.
	ObjectLocation *GdataCompositeMedia `json:"objectLocation,omitempty"`
	// ObjectSizeBytes: The total size of the server object.
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`
	// ObjectVersion: The object version of the object the checksums are being
	// returned for.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChecksumsLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChecksumsLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffChecksumsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffChecksumsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffDownloadResponse: Backend response for a Diff download response.
// For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type GdataDiffDownloadResponse struct {
	// ObjectLocation: The original object location.
	ObjectLocation *GdataCompositeMedia `json:"objectLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectLocation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffDownloadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffDownloadResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffUploadRequest: A Diff upload request. For details on the Scotty
// Diff protocol, visit http://go/scotty-diff-protocol.
type GdataDiffUploadRequest struct {
	// ChecksumsInfo: The location of the checksums for the new object. Agents must
	// clone the object located here, as the upload server will delete the contents
	// once a response is received. For details on the format of the checksums, see
	// http://go/scotty-diff-protocol.
	ChecksumsInfo *GdataCompositeMedia `json:"checksumsInfo,omitempty"`
	// ObjectInfo: The location of the new object. Agents must clone the object
	// located here, as the upload server will delete the contents once a response
	// is received.
	ObjectInfo *GdataCompositeMedia `json:"objectInfo,omitempty"`
	// ObjectVersion: The object version of the object that is the base version the
	// incoming diff script will be applied to. This field will always be filled
	// in.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChecksumsInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChecksumsInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffUploadRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffUploadRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffUploadResponse: Backend response for a Diff upload request. For
// details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
type GdataDiffUploadResponse struct {
	// ObjectVersion: The object version of the object at the server. Must be
	// included in the end notification response. The version in the end
	// notification response must correspond to the new version of the object that
	// is now stored at the server, after the upload.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// OriginalObject: The location of the original file for a diff upload request.
	// Must be filled in if responding to an upload start notification.
	OriginalObject *GdataCompositeMedia `json:"originalObject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffUploadResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDiffVersionResponse: Backend response for a Diff get version response.
// For details on the Scotty Diff protocol, visit
// http://go/scotty-diff-protocol.
type GdataDiffVersionResponse struct {
	// ObjectSizeBytes: The total size of the server object.
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`
	// ObjectVersion: The version of the object stored at the server.
	ObjectVersion string `json:"objectVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectSizeBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectSizeBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDiffVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDiffVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataDownloadParameters: Parameters specific to media downloads.
type GdataDownloadParameters struct {
	// AllowGzipCompression: A boolean to be returned in the response to Scotty.
	// Allows/disallows gzip encoding of the payload content when the server thinks
	// it's advantageous (hence, does not guarantee compression) which allows
	// Scotty to GZip the response to the client.
	AllowGzipCompression bool `json:"allowGzipCompression,omitempty"`
	// IgnoreRange: Determining whether or not Apiary should skip the inclusion of
	// any Content-Range header on its response to Scotty.
	IgnoreRange bool `json:"ignoreRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowGzipCompression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowGzipCompression") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataDownloadParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GdataDownloadParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataMedia: A reference to data stored on the filesystem, on GFS or in
// blobstore.
type GdataMedia struct {
	// Algorithm: Deprecated, use one of explicit hash type fields instead.
	// Algorithm used for calculating the hash. As of 2011/01/21, "MD5" is the only
	// possible value for this field. New values may be added at any time.
	Algorithm string `json:"algorithm,omitempty"`
	// BigstoreObjectRef: Use object_id instead.
	BigstoreObjectRef string `json:"bigstoreObjectRef,omitempty"`
	// BlobRef: Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This
	// should be the byte representation of a blobstore.BlobRef. Since Blobstore is
	// deprecating v1, use blobstore2_info instead. For now, any v2 blob will also
	// be represented in this field as v1 BlobRef.
	BlobRef string `json:"blobRef,omitempty"`
	// Blobstore2Info: Blobstore v2 info, set if reference_type is BLOBSTORE_REF
	// and it refers to a v2 blob.
	Blobstore2Info *GdataBlobstore2Info `json:"blobstore2Info,omitempty"`
	// CompositeMedia: A composite media composed of one or more media objects, set
	// if reference_type is COMPOSITE_MEDIA. The media length field must be set to
	// the sum of the lengths of all composite media objects. Note: All composite
	// media must have length specified.
	CompositeMedia []*GdataCompositeMedia `json:"compositeMedia,omitempty"`
	// ContentType: MIME type of the data
	ContentType string `json:"contentType,omitempty"`
	// ContentTypeInfo: Extended content type information provided for Scotty
	// uploads.
	ContentTypeInfo *GdataContentTypeInfo `json:"contentTypeInfo,omitempty"`
	// CosmoBinaryReference: A binary data reference for a media download. Serves
	// as a technology-agnostic binary reference in some Google infrastructure.
	// This value is a serialized storage_cosmo.BinaryReference proto. Storing it
	// as bytes is a hack to get around the fact that the cosmo proto (as well as
	// others it includes) doesn't support JavaScript. This prevents us from
	// including the actual type of this field.
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`
	// Crc32cHash: For Scotty Uploads: Scotty-provided hashes for uploads For
	// Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY
	// TEAM.) A Hash provided by the agent to be used to verify the data being
	// downloaded. Currently only supported for inline payloads. Further, only
	// crc32c_hash is currently supported.
	Crc32cHash int64 `json:"crc32cHash,omitempty"`
	// DiffChecksumsResponse: Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
	DiffChecksumsResponse *GdataDiffChecksumsResponse `json:"diffChecksumsResponse,omitempty"`
	// DiffDownloadResponse: Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
	DiffDownloadResponse *GdataDiffDownloadResponse `json:"diffDownloadResponse,omitempty"`
	// DiffUploadRequest: Set if reference_type is DIFF_UPLOAD_REQUEST.
	DiffUploadRequest *GdataDiffUploadRequest `json:"diffUploadRequest,omitempty"`
	// DiffUploadResponse: Set if reference_type is DIFF_UPLOAD_RESPONSE.
	DiffUploadResponse *GdataDiffUploadResponse `json:"diffUploadResponse,omitempty"`
	// DiffVersionResponse: Set if reference_type is DIFF_VERSION_RESPONSE.
	DiffVersionResponse *GdataDiffVersionResponse `json:"diffVersionResponse,omitempty"`
	// DownloadParameters: Parameters for a media download.
	DownloadParameters *GdataDownloadParameters `json:"downloadParameters,omitempty"`
	// Filename: Original file name
	Filename string `json:"filename,omitempty"`
	// Hash: Deprecated, use one of explicit hash type fields instead. These two
	// hash related fields will only be populated on Scotty based media uploads and
	// will contain the content of the hash group in the NotificationRequest:
	// http://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=class:Hash
	// Hex encoded hash value of the uploaded media.
	Hash string `json:"hash,omitempty"`
	// HashVerified: For Scotty uploads only. If a user sends a hash code and the
	// backend has requested that Scotty verify the upload against the client hash,
	// Scotty will perform the check on behalf of the backend and will reject it if
	// the hashes don't match. This is set to true if Scotty performed this
	// verification.
	HashVerified bool `json:"hashVerified,omitempty"`
	// Inline: Media data, set if reference_type is INLINE
	Inline string `json:"inline,omitempty"`
	// IsPotentialRetry: |is_potential_retry| is set false only when Scotty is
	// certain that it has not sent the request before. When a client resumes an
	// upload, this field must be set true in agent calls, because Scotty cannot be
	// certain that it has never sent the request before due to potential failure
	// in the session state persistence.
	IsPotentialRetry bool `json:"isPotentialRetry,omitempty"`
	// Length: Size of the data, in bytes
	Length int64 `json:"length,omitempty,string"`
	// Md5Hash: Scotty-provided MD5 hash for an upload.
	Md5Hash string `json:"md5Hash,omitempty"`
	// MediaId: Media id to forward to the operation GetMedia. Can be set if
	// reference_type is GET_MEDIA.
	MediaId string `json:"mediaId,omitempty"`
	// ObjectId: Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
	ObjectId *GdataObjectId `json:"objectId,omitempty"`
	// Path: Path to the data, set if reference_type is PATH
	Path string `json:"path,omitempty"`
	// ReferenceType: Describes what the field reference contains.
	//
	// Possible values:
	//   "PATH" - Reference contains a GFS path or a local path.
	//   "BLOB_REF" - Reference points to a blobstore object. This could be either
	// a v1 blob_ref or a v2 blobstore2_info. Clients should check blobstore2_info
	// first, since v1 is being deprecated.
	//   "INLINE" - Data is included into this proto buffer
	//   "GET_MEDIA" - Data should be accessed from the current service using the
	// operation GetMedia.
	//   "COMPOSITE_MEDIA" - The content for this media object is stored across
	// multiple partial media objects under the composite_media field.
	//   "BIGSTORE_REF" - Reference points to a bigstore object
	//   "DIFF_VERSION_RESPONSE" - Indicates the data is stored in
	// diff_version_response.
	//   "DIFF_CHECKSUMS_RESPONSE" - Indicates the data is stored in
	// diff_checksums_response.
	//   "DIFF_DOWNLOAD_RESPONSE" - Indicates the data is stored in
	// diff_download_response.
	//   "DIFF_UPLOAD_REQUEST" - Indicates the data is stored in
	// diff_upload_request.
	//   "DIFF_UPLOAD_RESPONSE" - Indicates the data is stored in
	// diff_upload_response.
	//   "COSMO_BINARY_REFERENCE" - Indicates the data is stored in
	// cosmo_binary_reference.
	//   "ARBITRARY_BYTES" - Informs Scotty to generate a response payload with the
	// size specified in the length field. The contents of the payload are
	// generated by Scotty and are undefined. This is useful for testing download
	// speeds between the user and Scotty without involving a real payload source.
	// Note: range is not supported when using arbitrary_bytes.
	ReferenceType string `json:"referenceType,omitempty"`
	// Sha1Hash: Scotty-provided SHA1 hash for an upload.
	Sha1Hash string `json:"sha1Hash,omitempty"`
	// Sha256Hash: Scotty-provided SHA256 hash for an upload.
	Sha256Hash string `json:"sha256Hash,omitempty"`
	// Timestamp: Time at which the media data was last updated, in milliseconds
	// since UNIX epoch
	Timestamp uint64 `json:"timestamp,omitempty,string"`
	// Token: A unique fingerprint/version id for the media data
	Token string `json:"token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Algorithm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GdataMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GdataObjectId: This is a copy of the tech.blob.ObjectId proto, which could
// not be used directly here due to transitive closure issues with JavaScript
// support; see http://b/8801763.
type GdataObjectId struct {
	// BucketName: The name of the bucket to which this object belongs.
	BucketName string `json:"bucketName,omitempty"`
	// Generation: Generation of the object. Generations are monotonically
	// increasing across writes, allowing them to be be compared to determine which
	// generation is newer. If this is omitted in a request, then you are
	// requesting the live object. See http://go/bigstore-versions
	Generation int64 `json:"generation,omitempty,string"`
	// ObjectName: The name of the object.
	ObjectName string `json:"objectName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GdataObjectId) MarshalJSON() ([]byte, error) {
	type NoMethod GdataObjectId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1AabInfo: Android App Bundle (AAB) information for a
// Firebase app.
type GoogleFirebaseAppdistroV1AabInfo struct {
	// IntegrationState: App bundle integration state. Only valid for android apps.
	//
	// Possible values:
	//   "AAB_INTEGRATION_STATE_UNSPECIFIED" - Aab integration state unspecified
	//   "INTEGRATED" - App can receive app bundle uploads
	//   "PLAY_ACCOUNT_NOT_LINKED" - Firebase project is not linked to a Play
	// developer account
	//   "NO_APP_WITH_GIVEN_BUNDLE_ID_IN_PLAY_ACCOUNT" - There is no app in linked
	// Play developer account with the same bundle id
	//   "APP_NOT_PUBLISHED" - The app in Play developer account is not in a
	// published state
	//   "AAB_STATE_UNAVAILABLE" - Play App status is unavailable
	//   "PLAY_IAS_TERMS_NOT_ACCEPTED" - Play IAS terms not accepted
	IntegrationState string `json:"integrationState,omitempty"`
	// Name: The name of the `AabInfo` resource. Format:
	// `projects/{project_number}/apps/{app}/aabInfo`
	Name string `json:"name,omitempty"`
	// TestCertificate: App bundle test certificate generated for the app. Set
	// after the first app bundle is uploaded for this app.
	TestCertificate *GoogleFirebaseAppdistroV1TestCertificate `json:"testCertificate,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IntegrationState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntegrationState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1AabInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1AabInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchAddTestersRequest: The Request message for
// batch adding testers
type GoogleFirebaseAppdistroV1BatchAddTestersRequest struct {
	// Emails: Required. The email addresses of the tester resources to create. A
	// maximum of 999 and a minimum of 1 tester can be created in a batch.
	Emails []string `json:"emails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Emails") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Emails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchAddTestersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchAddTestersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchAddTestersResponse: The Response message for
// `BatchAddTesters`.
type GoogleFirebaseAppdistroV1BatchAddTestersResponse struct {
	// Testers: The testers which are created and/or already exist
	Testers []*GoogleFirebaseAppdistroV1Tester `json:"testers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Testers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Testers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchAddTestersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchAddTestersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchDeleteReleasesRequest: The request message for
// `BatchDeleteReleases`.
type GoogleFirebaseAppdistroV1BatchDeleteReleasesRequest struct {
	// Names: Required. The names of the release resources to delete. Format:
	// `projects/{project_number}/apps/{app_id}/releases/{release_id}` A maximum of
	// 100 releases can be deleted per request.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchDeleteReleasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchDeleteReleasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchJoinGroupRequest: The request message for
// `BatchJoinGroup`
type GoogleFirebaseAppdistroV1BatchJoinGroupRequest struct {
	// CreateMissingTesters: Indicates whether to create tester resources based on
	// `emails` if they don't exist yet.
	CreateMissingTesters bool `json:"createMissingTesters,omitempty"`
	// Emails: Required. The emails of the testers to be added to the group. A
	// maximum of 999 and a minimum of 1 tester can be created in a batch.
	Emails []string `json:"emails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateMissingTesters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateMissingTesters") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchJoinGroupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchJoinGroupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchLeaveGroupRequest: Request message for
// `BatchLeaveGroup`
type GoogleFirebaseAppdistroV1BatchLeaveGroupRequest struct {
	// Emails: Required. The email addresses of the testers to be removed from the
	// group. A maximum of 999 and a minimum of 1 testers can be removed in a
	// batch.
	Emails []string `json:"emails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Emails") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Emails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchLeaveGroupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchLeaveGroupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchRemoveTestersRequest: The request message for
// `BatchRemoveTesters`.
type GoogleFirebaseAppdistroV1BatchRemoveTestersRequest struct {
	// Emails: Required. The email addresses of the tester resources to removed. A
	// maximum of 999 and a minimum of 1 testers can be deleted in a batch.
	Emails []string `json:"emails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Emails") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Emails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchRemoveTestersRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchRemoveTestersRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1BatchRemoveTestersResponse: The response message
// for `BatchRemoveTesters`
type GoogleFirebaseAppdistroV1BatchRemoveTestersResponse struct {
	// Emails: List of deleted tester emails
	Emails []string `json:"emails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Emails") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Emails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1BatchRemoveTestersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1BatchRemoveTestersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1DistributeReleaseRequest: The request message for
// `DistributeRelease`.
type GoogleFirebaseAppdistroV1DistributeReleaseRequest struct {
	// GroupAliases: Optional. A list of group aliases (IDs) to be given access to
	// this release. A combined maximum of 999 `testerEmails` and `groupAliases`
	// can be specified in a single request.
	GroupAliases []string `json:"groupAliases,omitempty"`
	// TesterEmails: Optional. A list of tester email addresses to be given access
	// to this release. A combined maximum of 999 `testerEmails` and `groupAliases`
	// can be specified in a single request.
	TesterEmails []string `json:"testerEmails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupAliases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupAliases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1DistributeReleaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1DistributeReleaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1DistributeReleaseResponse: The response message for
// `DistributeRelease`.
type GoogleFirebaseAppdistroV1DistributeReleaseResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleFirebaseAppdistroV1FeedbackReport: A feedback report submitted by a
// tester for a release.
type GoogleFirebaseAppdistroV1FeedbackReport struct {
	// CreateTime: Output only. The time when the feedback report was created.
	CreateTime string `json:"createTime,omitempty"`
	// FirebaseConsoleUri: Output only. A link to the Firebase console displaying
	// the feedback report.
	FirebaseConsoleUri string `json:"firebaseConsoleUri,omitempty"`
	// Name: The name of the feedback report resource. Format:
	// `projects/{project_number}/apps/{app}/releases/{release}/feedbackReports/{fee
	// dback_report}`
	Name string `json:"name,omitempty"`
	// ScreenshotUri: Output only. A signed link (which expires in one hour) that
	// lets you directly download the screenshot.
	ScreenshotUri string `json:"screenshotUri,omitempty"`
	// Tester: Output only. The resource name of the tester who submitted the
	// feedback report.
	Tester string `json:"tester,omitempty"`
	// Text: Output only. The text of the feedback report.
	Text string `json:"text,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1FeedbackReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1FeedbackReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1Group: A group which can contain testers. A group
// can be invited to test apps in a Firebase project.
type GoogleFirebaseAppdistroV1Group struct {
	// DisplayName: Required. The display name of the group.
	DisplayName string `json:"displayName,omitempty"`
	// InviteLinkCount: Output only. The number of invite links for this group.
	InviteLinkCount int64 `json:"inviteLinkCount,omitempty"`
	// Name: The name of the group resource. Format:
	// `projects/{project_number}/groups/{group_alias}`
	Name string `json:"name,omitempty"`
	// ReleaseCount: Output only. The number of releases this group is permitted to
	// access.
	ReleaseCount int64 `json:"releaseCount,omitempty"`
	// TesterCount: Output only. The number of testers who are members of this
	// group.
	TesterCount int64 `json:"testerCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1Group) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1Group
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1ListFeedbackReportsResponse: The response message
// for `ListFeedbackReports`.
type GoogleFirebaseAppdistroV1ListFeedbackReportsResponse struct {
	// FeedbackReports: The feedback reports
	FeedbackReports []*GoogleFirebaseAppdistroV1FeedbackReport `json:"feedbackReports,omitempty"`
	// NextPageToken: A short-lived token, which can be sent as `pageToken` to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackReports") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackReports") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1ListFeedbackReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1ListFeedbackReportsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1ListGroupsResponse: The response message for
// `ListGroups`.
type GoogleFirebaseAppdistroV1ListGroupsResponse struct {
	// Groups: The groups listed.
	Groups []*GoogleFirebaseAppdistroV1Group `json:"groups,omitempty"`
	// NextPageToken: A short-lived token, which can be sent as `pageToken` to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Groups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Groups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1ListGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1ListGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1ListReleasesResponse: The response message for
// `ListReleases`.
type GoogleFirebaseAppdistroV1ListReleasesResponse struct {
	// NextPageToken: A short-lived token, which can be sent as `pageToken` to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Releases: The releases
	Releases []*GoogleFirebaseAppdistroV1Release `json:"releases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1ListReleasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1ListReleasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1ListTestersResponse: The response message for
// `ListTesters`.
type GoogleFirebaseAppdistroV1ListTestersResponse struct {
	// NextPageToken: A short-lived token, which can be sent as `pageToken` to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Testers: The testers listed.
	Testers []*GoogleFirebaseAppdistroV1Tester `json:"testers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1ListTestersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1ListTestersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1Release: A release of a Firebase app.
type GoogleFirebaseAppdistroV1Release struct {
	// BinaryDownloadUri: Output only. A signed link (which expires in one hour) to
	// directly download the app binary (IPA/APK/AAB) file.
	BinaryDownloadUri string `json:"binaryDownloadUri,omitempty"`
	// BuildVersion: Output only. Build version of the release. For an Android
	// release, the build version is the `versionCode`. For an iOS release, the
	// build version is the `CFBundleVersion`.
	BuildVersion string `json:"buildVersion,omitempty"`
	// CreateTime: Output only. The time the release was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayVersion: Output only. Display version of the release. For an Android
	// release, the display version is the `versionName`. For an iOS release, the
	// display version is the `CFBundleShortVersionString`.
	DisplayVersion string `json:"displayVersion,omitempty"`
	// ExpireTime: Output only. The time the release will expire.
	ExpireTime string `json:"expireTime,omitempty"`
	// FirebaseConsoleUri: Output only. A link to the Firebase console displaying a
	// single release.
	FirebaseConsoleUri string `json:"firebaseConsoleUri,omitempty"`
	// Name: The name of the release resource. Format:
	// `projects/{project_number}/apps/{app_id}/releases/{release_id}`
	Name string `json:"name,omitempty"`
	// ReleaseNotes: Notes of the release.
	ReleaseNotes *GoogleFirebaseAppdistroV1ReleaseNotes `json:"releaseNotes,omitempty"`
	// TestingUri: Output only. A link to the release in the tester web clip or
	// Android app that lets testers (which were granted access to the app) view
	// release notes and install the app onto their devices.
	TestingUri string `json:"testingUri,omitempty"`
	// UpdateTime: Output only. The time the release was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BinaryDownloadUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinaryDownloadUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1Release) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1Release
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1ReleaseNotes: Notes that belong to a release.
type GoogleFirebaseAppdistroV1ReleaseNotes struct {
	// Text: The text of the release notes.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1ReleaseNotes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1ReleaseNotes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1TestCertificate: App bundle test certificate
type GoogleFirebaseAppdistroV1TestCertificate struct {
	// HashMd5: Hex string of MD5 hash of the test certificate used to resign the
	// AAB
	HashMd5 string `json:"hashMd5,omitempty"`
	// HashSha1: Hex string of SHA1 hash of the test certificate used to resign the
	// AAB
	HashSha1 string `json:"hashSha1,omitempty"`
	// HashSha256: Hex string of SHA256 hash of the test certificate used to resign
	// the AAB
	HashSha256 string `json:"hashSha256,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HashMd5") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HashMd5") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1TestCertificate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1TestCertificate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1Tester: A person that can be invited to test apps
// in a Firebase project.
type GoogleFirebaseAppdistroV1Tester struct {
	// DisplayName: The name of the tester associated with the Google account used
	// to accept the tester invitation.
	DisplayName string `json:"displayName,omitempty"`
	// Groups: The resource names of the groups this tester belongs to.
	Groups []string `json:"groups,omitempty"`
	// LastActivityTime: Output only. The time the tester was last active. This is
	// the most recent time the tester installed one of the apps. If they've never
	// installed one or if the release no longer exists, this is the time the
	// tester was added to the project.
	LastActivityTime string `json:"lastActivityTime,omitempty"`
	// Name: The name of the tester resource. Format:
	// `projects/{project_number}/testers/{email_address}`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1Tester) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1Tester
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1UploadReleaseMetadata: Operation metadata for
// `UploadRelease`.
type GoogleFirebaseAppdistroV1UploadReleaseMetadata struct {
}

// GoogleFirebaseAppdistroV1UploadReleaseRequest: Request message for
// `UploadRelease`.
type GoogleFirebaseAppdistroV1UploadReleaseRequest struct {
	// Blob: Binary to upload
	Blob *GdataMedia `json:"blob,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blob") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blob") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1UploadReleaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1UploadReleaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleFirebaseAppdistroV1UploadReleaseResponse: Response message for
// `UploadRelease`.
type GoogleFirebaseAppdistroV1UploadReleaseResponse struct {
	// Release: Release associated with the uploaded binary.
	Release *GoogleFirebaseAppdistroV1Release `json:"release,omitempty"`
	// Result: Result of upload release.
	//
	// Possible values:
	//   "UPLOAD_RELEASE_RESULT_UNSPECIFIED" - Upload binary result unspecified
	//   "RELEASE_CREATED" - Upload binary resulted in a new release
	//   "RELEASE_UPDATED" - Upload binary updated an existing release
	//   "RELEASE_UNMODIFIED" - Upload binary resulted in a no-op. A release with
	// the exact same binary already exists.
	Result string `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Release") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Release") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleFirebaseAppdistroV1UploadReleaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleFirebaseAppdistroV1UploadReleaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningCancelOperationRequest: The request message for
// Operations.CancelOperation.
type GoogleLongrunningCancelOperationRequest struct {
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningWaitOperationRequest: The request message for
// Operations.WaitOperation.
type GoogleLongrunningWaitOperationRequest struct {
	// Timeout: The maximum duration to wait before timing out. If left blank, the
	// wait will be at most the time permitted by the underlying HTTP/RPC protocol.
	// If RPC context deadline is also specified, the shorter one will be used.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Timeout") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Timeout") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningWaitOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningWaitOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type MediaUploadCall struct {
	s                                             *Service
	app                                           string
	googlefirebaseappdistrov1uploadreleaserequest *GoogleFirebaseAppdistroV1UploadReleaseRequest
	urlParams_                                    gensupport.URLParams
	mediaInfo_                                    *gensupport.MediaInfo
	ctx_                                          context.Context
	header_                                       http.Header
}

// Upload: Uploads a binary. Uploading a binary can result in a new release
// being created, an update to an existing release, or a no-op if a release
// with the same binary already exists.
//
//   - app: The name of the app resource. Format:
//     `projects/{project_number}/apps/{app_id}`.
func (r *MediaService) Upload(app string, googlefirebaseappdistrov1uploadreleaserequest *GoogleFirebaseAppdistroV1UploadReleaseRequest) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.app = app
	c.googlefirebaseappdistrov1uploadreleaserequest = googlefirebaseappdistrov1uploadreleaserequest
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk size
// may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the upload
// request will be determined by sniffing the contents of r, unless a
// MediaOption generated by googleapi.ContentType is supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be canceled
// with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType identifies the
// MIME media type of the upload, such as "image/png". If mediaType is "", it
// will be auto-detected. The provided ctx will supersede any context
// previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called after every
// chunk. It should be a low-latency function in order to not slow down the
// upload operation. This should only be called when using ResumableMedia (as
// opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1uploadreleaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+app}/releases:upload")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/v1/{+app}/releases:upload")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	newBody, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, newBody)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"app": c.app,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.media.upload", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.media.upload" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.media.upload", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsGetAabInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAabInfo: Gets Android App Bundle (AAB) information for a Firebase app.
//
//   - name: The name of the `AabInfo` resource to retrieve. Format:
//     `projects/{project_number}/apps/{app_id}/aabInfo`.
func (r *ProjectsAppsService) GetAabInfo(name string) *ProjectsAppsGetAabInfoCall {
	c := &ProjectsAppsGetAabInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsGetAabInfoCall) Fields(s ...googleapi.Field) *ProjectsAppsGetAabInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsGetAabInfoCall) IfNoneMatch(entityTag string) *ProjectsAppsGetAabInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsGetAabInfoCall) Context(ctx context.Context) *ProjectsAppsGetAabInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsGetAabInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsGetAabInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.getAabInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.getAabInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1AabInfo.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsGetAabInfoCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1AabInfo, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1AabInfo{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.getAabInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesBatchDeleteCall struct {
	s                                                   *Service
	parent                                              string
	googlefirebaseappdistrov1batchdeletereleasesrequest *GoogleFirebaseAppdistroV1BatchDeleteReleasesRequest
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// BatchDelete: Deletes releases. A maximum of 100 releases can be deleted per
// request.
//
//   - parent: The name of the app resource, which is the parent of the release
//     resources. Format: `projects/{project_number}/apps/{app_id}`.
func (r *ProjectsAppsReleasesService) BatchDelete(parent string, googlefirebaseappdistrov1batchdeletereleasesrequest *GoogleFirebaseAppdistroV1BatchDeleteReleasesRequest) *ProjectsAppsReleasesBatchDeleteCall {
	c := &ProjectsAppsReleasesBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappdistrov1batchdeletereleasesrequest = googlefirebaseappdistrov1batchdeletereleasesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesBatchDeleteCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesBatchDeleteCall) Context(ctx context.Context) *ProjectsAppsReleasesBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1batchdeletereleasesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/releases:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.batchDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsReleasesBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.batchDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesDistributeCall struct {
	s                                                 *Service
	name                                              string
	googlefirebaseappdistrov1distributereleaserequest *GoogleFirebaseAppdistroV1DistributeReleaseRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Distribute: Distributes a release to testers. This call does the following:
// 1. Creates testers for the specified emails, if none exist. 2. Adds the
// testers and groups to the release. 3. Sends new testers an invitation email.
// 4. Sends existing testers a new release email. The request will fail with a
// `INVALID_ARGUMENT` if it contains a group that doesn't exist.
//
//   - name: The name of the release resource to distribute. Format:
//     `projects/{project_number}/apps/{app_id}/releases/{release_id}`.
func (r *ProjectsAppsReleasesService) Distribute(name string, googlefirebaseappdistrov1distributereleaserequest *GoogleFirebaseAppdistroV1DistributeReleaseRequest) *ProjectsAppsReleasesDistributeCall {
	c := &ProjectsAppsReleasesDistributeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappdistrov1distributereleaserequest = googlefirebaseappdistrov1distributereleaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesDistributeCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesDistributeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesDistributeCall) Context(ctx context.Context) *ProjectsAppsReleasesDistributeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesDistributeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesDistributeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1distributereleaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:distribute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.distribute", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.distribute" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1DistributeReleaseResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesDistributeCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1DistributeReleaseResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1DistributeReleaseResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.distribute", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a release.
//
//   - name: The name of the release resource to retrieve. Format:
//     projects/{project_number}/apps/{app_id}/releases/{release_id}.
func (r *ProjectsAppsReleasesService) Get(name string) *ProjectsAppsReleasesGetCall {
	c := &ProjectsAppsReleasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesGetCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesGetCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesGetCall) Context(ctx context.Context) *ProjectsAppsReleasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1Release.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1Release, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1Release{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists releases. By default, sorts by `createTime` in descending order.
//
//   - parent: The name of the app resource, which is the parent of the release
//     resources. Format: `projects/{project_number}/apps/{app_id}`.
func (r *ProjectsAppsReleasesService) List(parent string) *ProjectsAppsReleasesListCall {
	c := &ProjectsAppsReleasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The expression to filter
// releases listed in the response. To learn more about filtering, refer to
// Google's AIP-160 standard (http://aip.dev/160). Supported fields: -
// `releaseNotes.text` supports `=` (can contain a wildcard character (`*`) at
// the beginning or end of the string) - `createTime` supports `<`, `<=`, `>`
// and `>=`, and expects an RFC-3339 formatted string Examples: - `createTime
// <= "2021-09-08T00:00:00+04:00" - `releaseNotes.text="fixes" AND createTime
// >= "2021-09-08T00:00:00.0Z" - `releaseNotes.text="*v1.0.0-rc*"
func (c *ProjectsAppsReleasesListCall) Filter(filter string) *ProjectsAppsReleasesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The fields used to order
// releases. Supported fields: - `createTime` To specify descending order for a
// field, append a "desc" suffix, for example, `createTime desc`. If this
// parameter is not set, releases are ordered by `createTime` in descending
// order.
func (c *ProjectsAppsReleasesListCall) OrderBy(orderBy string) *ProjectsAppsReleasesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// releases to return. The service may return fewer than this value. The valid
// range is [1-100]; If unspecified (0), at most 25 releases are returned.
// Values above 100 are coerced to 100.
func (c *ProjectsAppsReleasesListCall) PageSize(pageSize int64) *ProjectsAppsReleasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListReleases` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListReleases` must
// match the call that provided the page token.
func (c *ProjectsAppsReleasesListCall) PageToken(pageToken string) *ProjectsAppsReleasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesListCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesListCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesListCall) Context(ctx context.Context) *ProjectsAppsReleasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/releases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1ListReleasesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1ListReleasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1ListReleasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAppsReleasesListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppdistroV1ListReleasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAppsReleasesPatchCall struct {
	s                                *Service
	name                             string
	googlefirebaseappdistrov1release *GoogleFirebaseAppdistroV1Release
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Patch: Updates a release.
//
//   - name: The name of the release resource. Format:
//     `projects/{project_number}/apps/{app_id}/releases/{release_id}`.
func (r *ProjectsAppsReleasesService) Patch(name string, googlefirebaseappdistrov1release *GoogleFirebaseAppdistroV1Release) *ProjectsAppsReleasesPatchCall {
	c := &ProjectsAppsReleasesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappdistrov1release = googlefirebaseappdistrov1release
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsAppsReleasesPatchCall) UpdateMask(updateMask string) *ProjectsAppsReleasesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesPatchCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesPatchCall) Context(ctx context.Context) *ProjectsAppsReleasesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1release)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1Release.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1Release, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1Release{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesFeedbackReportsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a feedback report.
//
//   - name: The name of the feedback report to delete. Format:
//     projects/{project_number}/apps/{app}/releases/{release}/feedbackReports/{fe
//     edback_report}.
func (r *ProjectsAppsReleasesFeedbackReportsService) Delete(name string) *ProjectsAppsReleasesFeedbackReportsDeleteCall {
	c := &ProjectsAppsReleasesFeedbackReportsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesFeedbackReportsDeleteCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesFeedbackReportsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesFeedbackReportsDeleteCall) Context(ctx context.Context) *ProjectsAppsReleasesFeedbackReportsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesFeedbackReportsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesFeedbackReportsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.feedbackReports.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.feedbackReports.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsReleasesFeedbackReportsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.feedbackReports.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesFeedbackReportsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a feedback report.
//
//   - name: The name of the feedback report to retrieve. Format:
//     projects/{project_number}/apps/{app}/releases/{release}/feedbackReports/{fe
//     edback_report}.
func (r *ProjectsAppsReleasesFeedbackReportsService) Get(name string) *ProjectsAppsReleasesFeedbackReportsGetCall {
	c := &ProjectsAppsReleasesFeedbackReportsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesFeedbackReportsGetCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesFeedbackReportsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesFeedbackReportsGetCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesFeedbackReportsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesFeedbackReportsGetCall) Context(ctx context.Context) *ProjectsAppsReleasesFeedbackReportsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesFeedbackReportsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesFeedbackReportsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.feedbackReports.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.feedbackReports.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1FeedbackReport.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesFeedbackReportsGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1FeedbackReport, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1FeedbackReport{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.feedbackReports.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesFeedbackReportsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists feedback reports. By default, sorts by `createTime` in
// descending order.
//
//   - parent: The name of the release resource, which is the parent of the
//     feedback report resources. Format:
//     `projects/{project_number}/apps/{app}/releases/{release}`.
func (r *ProjectsAppsReleasesFeedbackReportsService) List(parent string) *ProjectsAppsReleasesFeedbackReportsListCall {
	c := &ProjectsAppsReleasesFeedbackReportsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Output only. The maximum
// number of feedback reports to return. The service may return fewer than this
// value. The valid range is [1-100]; If unspecified (0), at most 25 feedback
// reports are returned. Values above 100 are coerced to 100.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) PageSize(pageSize int64) *ProjectsAppsReleasesFeedbackReportsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Output only. A page
// token, received from a previous `ListFeedbackReports` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters provided
// to `ListFeedbackReports` must match the call that provided the page token.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) PageToken(pageToken string) *ProjectsAppsReleasesFeedbackReportsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesFeedbackReportsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesFeedbackReportsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) Context(ctx context.Context) *ProjectsAppsReleasesFeedbackReportsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesFeedbackReportsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feedbackReports")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.feedbackReports.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.feedbackReports.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1ListFeedbackReportsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1ListFeedbackReportsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1ListFeedbackReportsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.feedbackReports.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAppsReleasesFeedbackReportsListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppdistroV1ListFeedbackReportsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAppsReleasesOperationsCancelCall struct {
	s                                       *Service
	name                                    string
	googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsAppsReleasesOperationsService) Cancel(name string, googlelongrunningcanceloperationrequest *GoogleLongrunningCancelOperationRequest) *ProjectsAppsReleasesOperationsCancelCall {
	c := &ProjectsAppsReleasesOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningcanceloperationrequest = googlelongrunningcanceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesOperationsCancelCall) Context(ctx context.Context) *ProjectsAppsReleasesOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlelongrunningcanceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsReleasesOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsAppsReleasesOperationsService) Delete(name string) *ProjectsAppsReleasesOperationsDeleteCall {
	c := &ProjectsAppsReleasesOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesOperationsDeleteCall) Context(ctx context.Context) *ProjectsAppsReleasesOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAppsReleasesOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsAppsReleasesOperationsService) Get(name string) *ProjectsAppsReleasesOperationsGetCall {
	c := &ProjectsAppsReleasesOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesOperationsGetCall) Context(ctx context.Context) *ProjectsAppsReleasesOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAppsReleasesOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsAppsReleasesOperationsService) List(name string) *ProjectsAppsReleasesOperationsListCall {
	c := &ProjectsAppsReleasesOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsAppsReleasesOperationsListCall) Filter(filter string) *ProjectsAppsReleasesOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsAppsReleasesOperationsListCall) PageSize(pageSize int64) *ProjectsAppsReleasesOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsAppsReleasesOperationsListCall) PageToken(pageToken string) *ProjectsAppsReleasesOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesOperationsListCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAppsReleasesOperationsListCall) IfNoneMatch(entityTag string) *ProjectsAppsReleasesOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesOperationsListCall) Context(ctx context.Context) *ProjectsAppsReleasesOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAppsReleasesOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAppsReleasesOperationsWaitCall struct {
	s                                     *Service
	name                                  string
	googlelongrunningwaitoperationrequest *GoogleLongrunningWaitOperationRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Wait: Waits until the specified long-running operation is done or reaches at
// most a specified timeout, returning the latest state. If the operation is
// already done, the latest state is immediately returned. If the timeout
// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC timeout
// is used. If the server does not support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort
// basis. It may return the latest state before the specified timeout
// (including immediately), meaning even an immediate response is no guarantee
// that the operation is done.
//
// - name: The name of the operation resource to wait on.
func (r *ProjectsAppsReleasesOperationsService) Wait(name string, googlelongrunningwaitoperationrequest *GoogleLongrunningWaitOperationRequest) *ProjectsAppsReleasesOperationsWaitCall {
	c := &ProjectsAppsReleasesOperationsWaitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningwaitoperationrequest = googlelongrunningwaitoperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAppsReleasesOperationsWaitCall) Fields(s ...googleapi.Field) *ProjectsAppsReleasesOperationsWaitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAppsReleasesOperationsWaitCall) Context(ctx context.Context) *ProjectsAppsReleasesOperationsWaitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAppsReleasesOperationsWaitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAppsReleasesOperationsWaitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlelongrunningwaitoperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:wait")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.wait", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.apps.releases.operations.wait" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAppsReleasesOperationsWaitCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.apps.releases.operations.wait", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGroupsBatchJoinCall struct {
	s                                              *Service
	group                                          string
	googlefirebaseappdistrov1batchjoingrouprequest *GoogleFirebaseAppdistroV1BatchJoinGroupRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// BatchJoin: Batch adds members to a group. The testers will gain access to
// all releases that the groups have access to.
//
//   - group: The name of the group resource to which testers are added. Format:
//     `projects/{project_number}/groups/{group_alias}`.
func (r *ProjectsGroupsService) BatchJoin(group string, googlefirebaseappdistrov1batchjoingrouprequest *GoogleFirebaseAppdistroV1BatchJoinGroupRequest) *ProjectsGroupsBatchJoinCall {
	c := &ProjectsGroupsBatchJoinCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	c.googlefirebaseappdistrov1batchjoingrouprequest = googlefirebaseappdistrov1batchjoingrouprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsBatchJoinCall) Fields(s ...googleapi.Field) *ProjectsGroupsBatchJoinCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsBatchJoinCall) Context(ctx context.Context) *ProjectsGroupsBatchJoinCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsBatchJoinCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsBatchJoinCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1batchjoingrouprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+group}:batchJoin")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"group": c.group,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.batchJoin", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.batchJoin" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsGroupsBatchJoinCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.batchJoin", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGroupsBatchLeaveCall struct {
	s                                               *Service
	group                                           string
	googlefirebaseappdistrov1batchleavegrouprequest *GoogleFirebaseAppdistroV1BatchLeaveGroupRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// BatchLeave: Batch removed members from a group. The testers will lose access
// to all releases that the groups have access to.
//
//   - group: The name of the group resource from which testers are removed.
//     Format: `projects/{project_number}/groups/{group_alias}`.
func (r *ProjectsGroupsService) BatchLeave(group string, googlefirebaseappdistrov1batchleavegrouprequest *GoogleFirebaseAppdistroV1BatchLeaveGroupRequest) *ProjectsGroupsBatchLeaveCall {
	c := &ProjectsGroupsBatchLeaveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	c.googlefirebaseappdistrov1batchleavegrouprequest = googlefirebaseappdistrov1batchleavegrouprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsBatchLeaveCall) Fields(s ...googleapi.Field) *ProjectsGroupsBatchLeaveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsBatchLeaveCall) Context(ctx context.Context) *ProjectsGroupsBatchLeaveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsBatchLeaveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsBatchLeaveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1batchleavegrouprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+group}:batchLeave")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"group": c.group,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.batchLeave", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.batchLeave" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsGroupsBatchLeaveCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.batchLeave", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGroupsCreateCall struct {
	s                              *Service
	parent                         string
	googlefirebaseappdistrov1group *GoogleFirebaseAppdistroV1Group
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Create: Create a group.
//
//   - parent: The name of the project resource, which is the parent of the group
//     resource. Format: `projects/{project_number}`.
func (r *ProjectsGroupsService) Create(parent string, googlefirebaseappdistrov1group *GoogleFirebaseAppdistroV1Group) *ProjectsGroupsCreateCall {
	c := &ProjectsGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlefirebaseappdistrov1group = googlefirebaseappdistrov1group
	return c
}

// GroupId sets the optional parameter "groupId": The "alias" to use for the
// group, which will become the final component of the group's resource name.
// This value must be unique per project. The field is named `groupId` to
// comply with AIP guidance for user-specified IDs. This value should be 4-63
// characters, and valid characters are `/a-z-/`. If not set, it will be
// generated based on the display name.
func (c *ProjectsGroupsCreateCall) GroupId(groupId string) *ProjectsGroupsCreateCall {
	c.urlParams_.Set("groupId", groupId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsCreateCall) Context(ctx context.Context) *ProjectsGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1Group.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGroupsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a group.
//
//   - name: The name of the group resource. Format:
//     `projects/{project_number}/groups/{group_alias}`.
func (r *ProjectsGroupsService) Delete(name string) *ProjectsGroupsDeleteCall {
	c := &ProjectsGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsDeleteCall) Context(ctx context.Context) *ProjectsGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a group.
//
//   - name: The name of the group resource to retrieve. Format:
//     `projects/{project_number}/groups/{group_alias}`.
func (r *ProjectsGroupsService) Get(name string) *ProjectsGroupsGetCall {
	c := &ProjectsGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsGetCall) Context(ctx context.Context) *ProjectsGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1Group.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGroupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List groups.
//
//   - parent: The name of the project resource, which is the parent of the group
//     resources. Format: `projects/{project_number}`.
func (r *ProjectsGroupsService) List(parent string) *ProjectsGroupsListCall {
	c := &ProjectsGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// groups to return. The service may return fewer than this value. The valid
// range is [1-1000]; If unspecified (0), at most 25 groups are returned.
// Values above 1000 are coerced to 1000.
func (c *ProjectsGroupsListCall) PageSize(pageSize int64) *ProjectsGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListGroups` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListGroups` must
// match the call that provided the page token.
func (c *ProjectsGroupsListCall) PageToken(pageToken string) *ProjectsGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsListCall) Fields(s ...googleapi.Field) *ProjectsGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGroupsListCall) IfNoneMatch(entityTag string) *ProjectsGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsListCall) Context(ctx context.Context) *ProjectsGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1ListGroupsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGroupsListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1ListGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1ListGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsGroupsListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppdistroV1ListGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsGroupsPatchCall struct {
	s                              *Service
	name                           string
	googlefirebaseappdistrov1group *GoogleFirebaseAppdistroV1Group
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Patch: Update a group.
//
//   - name: The name of the group resource. Format:
//     `projects/{project_number}/groups/{group_alias}`.
func (r *ProjectsGroupsService) Patch(name string, googlefirebaseappdistrov1group *GoogleFirebaseAppdistroV1Group) *ProjectsGroupsPatchCall {
	c := &ProjectsGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappdistrov1group = googlefirebaseappdistrov1group
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsGroupsPatchCall) UpdateMask(updateMask string) *ProjectsGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGroupsPatchCall) Context(ctx context.Context) *ProjectsGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1group)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.groups.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1Group.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGroupsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.groups.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTestersBatchAddCall struct {
	s                                               *Service
	project                                         string
	googlefirebaseappdistrov1batchaddtestersrequest *GoogleFirebaseAppdistroV1BatchAddTestersRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// BatchAdd: Batch adds testers. This call adds testers for the specified
// emails if they don't already exist. Returns all testers specified in the
// request, including newly created and previously existing testers. This
// action is idempotent.
//
//   - project: The name of the project resource. Format:
//     `projects/{project_number}`.
func (r *ProjectsTestersService) BatchAdd(project string, googlefirebaseappdistrov1batchaddtestersrequest *GoogleFirebaseAppdistroV1BatchAddTestersRequest) *ProjectsTestersBatchAddCall {
	c := &ProjectsTestersBatchAddCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.googlefirebaseappdistrov1batchaddtestersrequest = googlefirebaseappdistrov1batchaddtestersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTestersBatchAddCall) Fields(s ...googleapi.Field) *ProjectsTestersBatchAddCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTestersBatchAddCall) Context(ctx context.Context) *ProjectsTestersBatchAddCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTestersBatchAddCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTestersBatchAddCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1batchaddtestersrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+project}/testers:batchAdd")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.batchAdd", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.testers.batchAdd" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1BatchAddTestersResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTestersBatchAddCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1BatchAddTestersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1BatchAddTestersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.batchAdd", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTestersBatchRemoveCall struct {
	s                                                  *Service
	project                                            string
	googlefirebaseappdistrov1batchremovetestersrequest *GoogleFirebaseAppdistroV1BatchRemoveTestersRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// BatchRemove: Batch removes testers. If found, this call deletes testers for
// the specified emails. Returns all deleted testers.
//
//   - project: The name of the project resource. Format:
//     `projects/{project_number}`.
func (r *ProjectsTestersService) BatchRemove(project string, googlefirebaseappdistrov1batchremovetestersrequest *GoogleFirebaseAppdistroV1BatchRemoveTestersRequest) *ProjectsTestersBatchRemoveCall {
	c := &ProjectsTestersBatchRemoveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.googlefirebaseappdistrov1batchremovetestersrequest = googlefirebaseappdistrov1batchremovetestersrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTestersBatchRemoveCall) Fields(s ...googleapi.Field) *ProjectsTestersBatchRemoveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTestersBatchRemoveCall) Context(ctx context.Context) *ProjectsTestersBatchRemoveCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTestersBatchRemoveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTestersBatchRemoveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1batchremovetestersrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+project}/testers:batchRemove")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.batchRemove", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.testers.batchRemove" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1BatchRemoveTestersResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTestersBatchRemoveCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1BatchRemoveTestersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1BatchRemoveTestersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.batchRemove", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsTestersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists testers and their resource ids.
//
//   - parent: The name of the project resource, which is the parent of the
//     tester resources. Format: `projects/{project_number}`.
func (r *ProjectsTestersService) List(parent string) *ProjectsTestersListCall {
	c := &ProjectsTestersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The expression to filter
// testers listed in the response. To learn more about filtering, refer to
// Google's AIP-160 standard (http://aip.dev/160). Supported fields: - `name` -
// `displayName` - `groups` Example: - `name =
// "projects/-/testers/*@example.com" - `displayName = "Joe Sixpack" -
// `groups = "projects/*/groups/qa-team"
func (c *ProjectsTestersListCall) Filter(filter string) *ProjectsTestersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// testers to return. The service may return fewer than this value. The valid
// range is [1-1000]; If unspecified (0), at most 10 testers are returned.
// Values above 1000 are coerced to 1000.
func (c *ProjectsTestersListCall) PageSize(pageSize int64) *ProjectsTestersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListTesters` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListTesters` must
// match the call that provided the page token.
func (c *ProjectsTestersListCall) PageToken(pageToken string) *ProjectsTestersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTestersListCall) Fields(s ...googleapi.Field) *ProjectsTestersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsTestersListCall) IfNoneMatch(entityTag string) *ProjectsTestersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTestersListCall) Context(ctx context.Context) *ProjectsTestersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTestersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTestersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/testers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.testers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1ListTestersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTestersListCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1ListTestersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1ListTestersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsTestersListCall) Pages(ctx context.Context, f func(*GoogleFirebaseAppdistroV1ListTestersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsTestersPatchCall struct {
	s                               *Service
	name                            string
	googlefirebaseappdistrov1tester *GoogleFirebaseAppdistroV1Tester
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Update a tester. If the testers joins a group they gain access to all
// releases that the group has access to.
//
//   - name: The name of the tester resource. Format:
//     `projects/{project_number}/testers/{email_address}`.
func (r *ProjectsTestersService) Patch(name string, googlefirebaseappdistrov1tester *GoogleFirebaseAppdistroV1Tester) *ProjectsTestersPatchCall {
	c := &ProjectsTestersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlefirebaseappdistrov1tester = googlefirebaseappdistrov1tester
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// update.
func (c *ProjectsTestersPatchCall) UpdateMask(updateMask string) *ProjectsTestersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsTestersPatchCall) Fields(s ...googleapi.Field) *ProjectsTestersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsTestersPatchCall) Context(ctx context.Context) *ProjectsTestersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsTestersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsTestersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlefirebaseappdistrov1tester)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "firebaseappdistribution.projects.testers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleFirebaseAppdistroV1Tester.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsTestersPatchCall) Do(opts ...googleapi.CallOption) (*GoogleFirebaseAppdistroV1Tester, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleFirebaseAppdistroV1Tester{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "firebaseappdistribution.projects.testers.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
