
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops create secret ciliumpassword

Create a Cilium IPsec configuration.

### Synopsis

Create a new Cilium IPsec configuration and store it in the state store. This is used by Cilium to encrypt communication between pods/nodes.

```
kops create secret ciliumpassword [CLUSTER] -f FILENAME [flags]
```

### Examples

```
  # Create a new Cilium IPsec configuration.
  kops create secret ciliumpassword -f /path/to/configuration.yaml \
  --name k8s-cluster.example.com --state s3://my-state-store
  
  # Create a new Cilium IPsec key via stdin.
  cat <<EOF | kops create secret ciliumpassword --name k8s-cluster.example.com --state s3://my-state-store -f -
  keys: $(echo "3 rfc4106(gcm(aes)) $(echo $(dd if=/dev/urandom count=20 bs=1 2> /dev/null| xxd -p -c 64)) 128")
  EOF
  
  # Replace an existing Cilium IPsec configuration secret
  kops create secret ciliumpassword -f /path/to/configuration.yaml --force \
  --name k8s-cluster.example.com --state s3://my-state-store
```

### Options

```
  -f, --filename string   Path to the Cilium IPsec configuration file
      --force             Force replace the secret if it already exists
  -h, --help              help for ciliumpassword
```

### Options inherited from parent commands

```
      --config string   yaml config file (default is $HOME/.kops.yaml)
      --name string     Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --state string    Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
  -v, --v Level         number for the log level verbosity
```

### SEE ALSO

* [kops create secret](kops_create_secret.md)	 - Create a secret.

