/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.spi.Name;

public abstract class AbstractQueryImpl
implements ExecutableQuery {
    protected final SessionImpl session;
    protected final ItemManager itemMgr;
    protected final SearchIndex index;
    protected final PropertyTypeRegistry propReg;
    private boolean documentOrder = true;
    private final Set variableNames = new HashSet();
    private final Map bindValues = new HashMap();

    public AbstractQueryImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg) {
        this.session = session;
        this.itemMgr = itemMgr;
        this.index = index;
        this.propReg = propReg;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    public void bindValue(Name varName, Value value) throws IllegalArgumentException, RepositoryException {
        if (!this.variableNames.contains(varName)) {
            throw new IllegalArgumentException("not a valid variable in this query");
        }
        this.bindValues.put(varName, value);
    }

    protected void addVariableName(Name varName) {
        this.variableNames.add(varName);
    }

    protected Map getBindVariableValues() {
        return Collections.unmodifiableMap(this.bindValues);
    }

    public abstract boolean needsSystemTree();

    public abstract Name[] getSelectorNames();
}

