/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import javax.jcr.Repository;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;
import org.apache.jackrabbit.servlet.AbstractRepositoryServlet;
import org.apache.jackrabbit.servlet.ContextRepositoryFactory;
import org.apache.jackrabbit.servlet.CrossContextRepositoryFactory;

public class ContextRepositoryServlet
extends AbstractRepositoryServlet {
    private static final long serialVersionUID = 6222606878557491477L;

    protected RepositoryFactory getRepositoryFactory() throws ServletException {
        String path = this.getInitParameter("path");
        String name = this.getInitParameter("name", Repository.class.getName());
        ServletContext context = this.getServletContext();
        if (path != null && context.equals(context.getContext(path))) {
            path = null;
        }
        if (path == null && name.equals(this.getAttributeName())) {
            throw new ServletException("Invalid configuration: Can not duplicate attribute " + name + " of servlet " + this.getServletName());
        }
        if (path != null) {
            return new CrossContextRepositoryFactory(context, path, name);
        }
        return new ContextRepositoryFactory(context, name);
    }
}

