// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/document.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/cloud/documentai/v1"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// When a raw document is supplied, this indicates the file format
type RawDocumentFileType int32

const (
	// No raw document specified or it is non-parsable
	RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_UNSPECIFIED RawDocumentFileType = 0
	// Adobe PDF format
	RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_PDF RawDocumentFileType = 1
	// Microsoft Word format
	RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_DOCX RawDocumentFileType = 2
	// Microsoft Excel format
	RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_XLSX RawDocumentFileType = 3
	// Microsoft Powerpoint format
	RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_PPTX RawDocumentFileType = 4
	// UTF-8 encoded text format
	RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_TEXT RawDocumentFileType = 5
)

// Enum value maps for RawDocumentFileType.
var (
	RawDocumentFileType_name = map[int32]string{
		0: "RAW_DOCUMENT_FILE_TYPE_UNSPECIFIED",
		1: "RAW_DOCUMENT_FILE_TYPE_PDF",
		2: "RAW_DOCUMENT_FILE_TYPE_DOCX",
		3: "RAW_DOCUMENT_FILE_TYPE_XLSX",
		4: "RAW_DOCUMENT_FILE_TYPE_PPTX",
		5: "RAW_DOCUMENT_FILE_TYPE_TEXT",
	}
	RawDocumentFileType_value = map[string]int32{
		"RAW_DOCUMENT_FILE_TYPE_UNSPECIFIED": 0,
		"RAW_DOCUMENT_FILE_TYPE_PDF":         1,
		"RAW_DOCUMENT_FILE_TYPE_DOCX":        2,
		"RAW_DOCUMENT_FILE_TYPE_XLSX":        3,
		"RAW_DOCUMENT_FILE_TYPE_PPTX":        4,
		"RAW_DOCUMENT_FILE_TYPE_TEXT":        5,
	}
)

func (x RawDocumentFileType) Enum() *RawDocumentFileType {
	p := new(RawDocumentFileType)
	*p = x
	return p
}

func (x RawDocumentFileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RawDocumentFileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_document_proto_enumTypes[0].Descriptor()
}

func (RawDocumentFileType) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_document_proto_enumTypes[0]
}

func (x RawDocumentFileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RawDocumentFileType.Descriptor instead.
func (RawDocumentFileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{0}
}

// Defines the structure for content warehouse document proto.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the document.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{document_id}.
	//
	// The name is ignored when creating a document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The reference ID set by customers. Must be unique per project and location.
	ReferenceId string `protobuf:"bytes,11,opt,name=reference_id,json=referenceId,proto3" json:"reference_id,omitempty"`
	// Required. Display name of the document given by the user. This name will be displayed
	// in the UI.
	// Customer can populate this field with the name of the document. This
	// differs from the 'title' field as 'title' is optional and stores the top
	// heading in the document.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Title that describes the document.
	// This is usually present in the top section of the document, and is a
	// mandatory field for the question-answering feature.
	Title string `protobuf:"bytes,18,opt,name=title,proto3" json:"title,omitempty"`
	// Uri to display the document, for example, in the UI.
	DisplayUri string `protobuf:"bytes,17,opt,name=display_uri,json=displayUri,proto3" json:"display_uri,omitempty"`
	// The Document schema name.
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_schema_id}.
	DocumentSchemaName string `protobuf:"bytes,3,opt,name=document_schema_name,json=documentSchemaName,proto3" json:"document_schema_name,omitempty"`
	// Types that are assignable to StructuredContent:
	//
	//	*Document_PlainText
	//	*Document_CloudAiDocument
	StructuredContent isDocument_StructuredContent `protobuf_oneof:"structured_content"`
	// A path linked to structured content file.
	StructuredContentUri string `protobuf:"bytes,16,opt,name=structured_content_uri,json=structuredContentUri,proto3" json:"structured_content_uri,omitempty"`
	// Raw document file.
	//
	// Types that are assignable to RawDocument:
	//
	//	*Document_RawDocumentPath
	//	*Document_InlineRawDocument
	RawDocument isDocument_RawDocument `protobuf_oneof:"raw_document"`
	// List of values that are user supplied metadata.
	Properties []*Property `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty"`
	// Output only. The time when the document is last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time when the document is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// This is used when DocAI was not used to load the document and parsing/
	// extracting is needed for the inline_raw_document.  For example, if
	// inline_raw_document is the byte representation of a PDF file, then
	// this should be set to: RAW_DOCUMENT_FILE_TYPE_PDF.
	RawDocumentFileType RawDocumentFileType `protobuf:"varint,10,opt,name=raw_document_file_type,json=rawDocumentFileType,proto3,enum=google.cloud.contentwarehouse.v1.RawDocumentFileType" json:"raw_document_file_type,omitempty"`
	// If true, makes the document visible to asynchronous policies and rules.
	AsyncEnabled bool `protobuf:"varint,12,opt,name=async_enabled,json=asyncEnabled,proto3" json:"async_enabled,omitempty"`
	// If true, text extraction will not be performed.
	TextExtractionDisabled bool `protobuf:"varint,19,opt,name=text_extraction_disabled,json=textExtractionDisabled,proto3" json:"text_extraction_disabled,omitempty"`
	// The user who creates the document.
	Creator string `protobuf:"bytes,13,opt,name=creator,proto3" json:"creator,omitempty"`
	// The user who lastly updates the document.
	Updater string `protobuf:"bytes,14,opt,name=updater,proto3" json:"updater,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{0}
}

func (x *Document) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Document) GetReferenceId() string {
	if x != nil {
		return x.ReferenceId
	}
	return ""
}

func (x *Document) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Document) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Document) GetDisplayUri() string {
	if x != nil {
		return x.DisplayUri
	}
	return ""
}

func (x *Document) GetDocumentSchemaName() string {
	if x != nil {
		return x.DocumentSchemaName
	}
	return ""
}

func (m *Document) GetStructuredContent() isDocument_StructuredContent {
	if m != nil {
		return m.StructuredContent
	}
	return nil
}

func (x *Document) GetPlainText() string {
	if x, ok := x.GetStructuredContent().(*Document_PlainText); ok {
		return x.PlainText
	}
	return ""
}

func (x *Document) GetCloudAiDocument() *v1.Document {
	if x, ok := x.GetStructuredContent().(*Document_CloudAiDocument); ok {
		return x.CloudAiDocument
	}
	return nil
}

func (x *Document) GetStructuredContentUri() string {
	if x != nil {
		return x.StructuredContentUri
	}
	return ""
}

func (m *Document) GetRawDocument() isDocument_RawDocument {
	if m != nil {
		return m.RawDocument
	}
	return nil
}

func (x *Document) GetRawDocumentPath() string {
	if x, ok := x.GetRawDocument().(*Document_RawDocumentPath); ok {
		return x.RawDocumentPath
	}
	return ""
}

func (x *Document) GetInlineRawDocument() []byte {
	if x, ok := x.GetRawDocument().(*Document_InlineRawDocument); ok {
		return x.InlineRawDocument
	}
	return nil
}

func (x *Document) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Document) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Document) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Document) GetRawDocumentFileType() RawDocumentFileType {
	if x != nil {
		return x.RawDocumentFileType
	}
	return RawDocumentFileType_RAW_DOCUMENT_FILE_TYPE_UNSPECIFIED
}

func (x *Document) GetAsyncEnabled() bool {
	if x != nil {
		return x.AsyncEnabled
	}
	return false
}

func (x *Document) GetTextExtractionDisabled() bool {
	if x != nil {
		return x.TextExtractionDisabled
	}
	return false
}

func (x *Document) GetCreator() string {
	if x != nil {
		return x.Creator
	}
	return ""
}

func (x *Document) GetUpdater() string {
	if x != nil {
		return x.Updater
	}
	return ""
}

type isDocument_StructuredContent interface {
	isDocument_StructuredContent()
}

type Document_PlainText struct {
	// Other document format, such as PPTX, XLXS
	PlainText string `protobuf:"bytes,15,opt,name=plain_text,json=plainText,proto3,oneof"`
}

type Document_CloudAiDocument struct {
	// Document AI format to save the structured content, including OCR.
	CloudAiDocument *v1.Document `protobuf:"bytes,4,opt,name=cloud_ai_document,json=cloudAiDocument,proto3,oneof"`
}

func (*Document_PlainText) isDocument_StructuredContent() {}

func (*Document_CloudAiDocument) isDocument_StructuredContent() {}

type isDocument_RawDocument interface {
	isDocument_RawDocument()
}

type Document_RawDocumentPath struct {
	// Raw document file in Cloud Storage path.
	RawDocumentPath string `protobuf:"bytes,5,opt,name=raw_document_path,json=rawDocumentPath,proto3,oneof"`
}

type Document_InlineRawDocument struct {
	// Raw document content.
	InlineRawDocument []byte `protobuf:"bytes,6,opt,name=inline_raw_document,json=inlineRawDocument,proto3,oneof"`
}

func (*Document_RawDocumentPath) isDocument_RawDocument() {}

func (*Document_InlineRawDocument) isDocument_RawDocument() {}

// References to the documents.
type DocumentReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the referenced document.
	DocumentName string `protobuf:"bytes,1,opt,name=document_name,json=documentName,proto3" json:"document_name,omitempty"`
	// display_name of the referenced document; this name does not need to be
	// consistent to the display_name in the Document proto, depending on the ACL
	// constraint.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Stores the subset of the referenced document's content.
	// This is useful to allow user peek the information of the referenced
	// document.
	Snippet string `protobuf:"bytes,3,opt,name=snippet,proto3" json:"snippet,omitempty"`
	// The document type of the document being referenced.
	DocumentIsFolder bool `protobuf:"varint,4,opt,name=document_is_folder,json=documentIsFolder,proto3" json:"document_is_folder,omitempty"`
	// Output only. The time when the document is last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time when the document is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the document is deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
}

func (x *DocumentReference) Reset() {
	*x = DocumentReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentReference) ProtoMessage() {}

func (x *DocumentReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentReference.ProtoReflect.Descriptor instead.
func (*DocumentReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{1}
}

func (x *DocumentReference) GetDocumentName() string {
	if x != nil {
		return x.DocumentName
	}
	return ""
}

func (x *DocumentReference) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DocumentReference) GetSnippet() string {
	if x != nil {
		return x.Snippet
	}
	return ""
}

func (x *DocumentReference) GetDocumentIsFolder() bool {
	if x != nil {
		return x.DocumentIsFolder
	}
	return false
}

func (x *DocumentReference) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DocumentReference) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DocumentReference) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

// Property of a document.
type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Must match the name of a PropertyDefinition in the DocumentSchema.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of the property.
	// Must match the property_options type of the matching PropertyDefinition.
	// Value of the Property parsed into a specific data type.
	// Specific type value(s) obtained from Document AIs Property.mention_text
	// field.
	//
	// Types that are assignable to Values:
	//
	//	*Property_IntegerValues
	//	*Property_FloatValues
	//	*Property_TextValues
	//	*Property_EnumValues
	//	*Property_PropertyValues
	//	*Property_DateTimeValues
	//	*Property_MapProperty
	//	*Property_TimestampValues
	Values isProperty_Values `protobuf_oneof:"values"`
}

func (x *Property) Reset() {
	*x = Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{2}
}

func (x *Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Property) GetValues() isProperty_Values {
	if m != nil {
		return m.Values
	}
	return nil
}

func (x *Property) GetIntegerValues() *IntegerArray {
	if x, ok := x.GetValues().(*Property_IntegerValues); ok {
		return x.IntegerValues
	}
	return nil
}

func (x *Property) GetFloatValues() *FloatArray {
	if x, ok := x.GetValues().(*Property_FloatValues); ok {
		return x.FloatValues
	}
	return nil
}

func (x *Property) GetTextValues() *TextArray {
	if x, ok := x.GetValues().(*Property_TextValues); ok {
		return x.TextValues
	}
	return nil
}

func (x *Property) GetEnumValues() *EnumArray {
	if x, ok := x.GetValues().(*Property_EnumValues); ok {
		return x.EnumValues
	}
	return nil
}

func (x *Property) GetPropertyValues() *PropertyArray {
	if x, ok := x.GetValues().(*Property_PropertyValues); ok {
		return x.PropertyValues
	}
	return nil
}

func (x *Property) GetDateTimeValues() *DateTimeArray {
	if x, ok := x.GetValues().(*Property_DateTimeValues); ok {
		return x.DateTimeValues
	}
	return nil
}

func (x *Property) GetMapProperty() *MapProperty {
	if x, ok := x.GetValues().(*Property_MapProperty); ok {
		return x.MapProperty
	}
	return nil
}

func (x *Property) GetTimestampValues() *TimestampArray {
	if x, ok := x.GetValues().(*Property_TimestampValues); ok {
		return x.TimestampValues
	}
	return nil
}

type isProperty_Values interface {
	isProperty_Values()
}

type Property_IntegerValues struct {
	// Integer property values.
	IntegerValues *IntegerArray `protobuf:"bytes,2,opt,name=integer_values,json=integerValues,proto3,oneof"`
}

type Property_FloatValues struct {
	// Float property values.
	FloatValues *FloatArray `protobuf:"bytes,3,opt,name=float_values,json=floatValues,proto3,oneof"`
}

type Property_TextValues struct {
	// String/text property values.
	TextValues *TextArray `protobuf:"bytes,4,opt,name=text_values,json=textValues,proto3,oneof"`
}

type Property_EnumValues struct {
	// Enum property values.
	EnumValues *EnumArray `protobuf:"bytes,5,opt,name=enum_values,json=enumValues,proto3,oneof"`
}

type Property_PropertyValues struct {
	// Nested structured data property values.
	PropertyValues *PropertyArray `protobuf:"bytes,6,opt,name=property_values,json=propertyValues,proto3,oneof"`
}

type Property_DateTimeValues struct {
	// Date time property values.
	// It is not supported by CMEK compliant deployment.
	DateTimeValues *DateTimeArray `protobuf:"bytes,7,opt,name=date_time_values,json=dateTimeValues,proto3,oneof"`
}

type Property_MapProperty struct {
	// Map property values.
	MapProperty *MapProperty `protobuf:"bytes,8,opt,name=map_property,json=mapProperty,proto3,oneof"`
}

type Property_TimestampValues struct {
	// Timestamp property values.
	// It is not supported by CMEK compliant deployment.
	TimestampValues *TimestampArray `protobuf:"bytes,9,opt,name=timestamp_values,json=timestampValues,proto3,oneof"`
}

func (*Property_IntegerValues) isProperty_Values() {}

func (*Property_FloatValues) isProperty_Values() {}

func (*Property_TextValues) isProperty_Values() {}

func (*Property_EnumValues) isProperty_Values() {}

func (*Property_PropertyValues) isProperty_Values() {}

func (*Property_DateTimeValues) isProperty_Values() {}

func (*Property_MapProperty) isProperty_Values() {}

func (*Property_TimestampValues) isProperty_Values() {}

// Integer values.
type IntegerArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of integer values.
	Values []int32 `protobuf:"varint,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *IntegerArray) Reset() {
	*x = IntegerArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntegerArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntegerArray) ProtoMessage() {}

func (x *IntegerArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntegerArray.ProtoReflect.Descriptor instead.
func (*IntegerArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{3}
}

func (x *IntegerArray) GetValues() []int32 {
	if x != nil {
		return x.Values
	}
	return nil
}

// Float values.
type FloatArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of float values.
	Values []float32 `protobuf:"fixed32,1,rep,packed,name=values,proto3" json:"values,omitempty"`
}

func (x *FloatArray) Reset() {
	*x = FloatArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatArray) ProtoMessage() {}

func (x *FloatArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatArray.ProtoReflect.Descriptor instead.
func (*FloatArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{4}
}

func (x *FloatArray) GetValues() []float32 {
	if x != nil {
		return x.Values
	}
	return nil
}

// String/text values.
type TextArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of text values.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *TextArray) Reset() {
	*x = TextArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextArray) ProtoMessage() {}

func (x *TextArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextArray.ProtoReflect.Descriptor instead.
func (*TextArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{5}
}

func (x *TextArray) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Enum values.
type EnumArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of enum values.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *EnumArray) Reset() {
	*x = EnumArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumArray) ProtoMessage() {}

func (x *EnumArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumArray.ProtoReflect.Descriptor instead.
func (*EnumArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{6}
}

func (x *EnumArray) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// DateTime values.
type DateTimeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of datetime values.
	// Both OffsetDateTime and ZonedDateTime are supported.
	Values []*datetime.DateTime `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *DateTimeArray) Reset() {
	*x = DateTimeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeArray) ProtoMessage() {}

func (x *DateTimeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeArray.ProtoReflect.Descriptor instead.
func (*DateTimeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{7}
}

func (x *DateTimeArray) GetValues() []*datetime.DateTime {
	if x != nil {
		return x.Values
	}
	return nil
}

// Timestamp values.
type TimestampArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of timestamp values.
	Values []*TimestampValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *TimestampArray) Reset() {
	*x = TimestampArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampArray) ProtoMessage() {}

func (x *TimestampArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampArray.ProtoReflect.Descriptor instead.
func (*TimestampArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{8}
}

func (x *TimestampArray) GetValues() []*TimestampValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// Timestamp value type.
type TimestampValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*TimestampValue_TimestampValue
	//	*TimestampValue_TextValue
	Value isTimestampValue_Value `protobuf_oneof:"value"`
}

func (x *TimestampValue) Reset() {
	*x = TimestampValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampValue) ProtoMessage() {}

func (x *TimestampValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampValue.ProtoReflect.Descriptor instead.
func (*TimestampValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{9}
}

func (m *TimestampValue) GetValue() isTimestampValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *TimestampValue) GetTimestampValue() *timestamppb.Timestamp {
	if x, ok := x.GetValue().(*TimestampValue_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *TimestampValue) GetTextValue() string {
	if x, ok := x.GetValue().(*TimestampValue_TextValue); ok {
		return x.TextValue
	}
	return ""
}

type isTimestampValue_Value interface {
	isTimestampValue_Value()
}

type TimestampValue_TimestampValue struct {
	// Timestamp value
	TimestampValue *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type TimestampValue_TextValue struct {
	// The string must represent a valid instant in UTC and is parsed using
	// java.time.format.DateTimeFormatter.ISO_INSTANT.
	// e.g. "2013-09-29T18:46:19Z"
	TextValue string `protobuf:"bytes,2,opt,name=text_value,json=textValue,proto3,oneof"`
}

func (*TimestampValue_TimestampValue) isTimestampValue_Value() {}

func (*TimestampValue_TextValue) isTimestampValue_Value() {}

// Property values.
type PropertyArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of property values.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *PropertyArray) Reset() {
	*x = PropertyArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PropertyArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PropertyArray) ProtoMessage() {}

func (x *PropertyArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PropertyArray.ProtoReflect.Descriptor instead.
func (*PropertyArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{10}
}

func (x *PropertyArray) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Map property value.
// Represents a structured entries of key value pairs, consisting of field names
// which map to dynamically typed values.
type MapProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unordered map of dynamically typed values.
	Fields map[string]*Value `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *MapProperty) Reset() {
	*x = MapProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapProperty) ProtoMessage() {}

func (x *MapProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapProperty.ProtoReflect.Descriptor instead.
func (*MapProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{11}
}

func (x *MapProperty) GetFields() map[string]*Value {
	if x != nil {
		return x.Fields
	}
	return nil
}

// `Value` represents a dynamically typed value which can be either be
// a float, a integer, a string, or a datetime value. A producer of value is
// expected to set one of these variants. Absence of any variant indicates an
// error.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of value.
	//
	// Types that are assignable to Kind:
	//
	//	*Value_FloatValue
	//	*Value_IntValue
	//	*Value_StringValue
	//	*Value_EnumValue
	//	*Value_DatetimeValue
	//	*Value_TimestampValue
	//	*Value_BooleanValue
	Kind isValue_Kind `protobuf_oneof:"kind"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{12}
}

func (m *Value) GetKind() isValue_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Value) GetFloatValue() float32 {
	if x, ok := x.GetKind().(*Value_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *Value) GetIntValue() int32 {
	if x, ok := x.GetKind().(*Value_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetKind().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetEnumValue() *EnumValue {
	if x, ok := x.GetKind().(*Value_EnumValue); ok {
		return x.EnumValue
	}
	return nil
}

func (x *Value) GetDatetimeValue() *datetime.DateTime {
	if x, ok := x.GetKind().(*Value_DatetimeValue); ok {
		return x.DatetimeValue
	}
	return nil
}

func (x *Value) GetTimestampValue() *TimestampValue {
	if x, ok := x.GetKind().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *Value) GetBooleanValue() bool {
	if x, ok := x.GetKind().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

type isValue_Kind interface {
	isValue_Kind()
}

type Value_FloatValue struct {
	// Represents a float value.
	FloatValue float32 `protobuf:"fixed32,1,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type Value_IntValue struct {
	// Represents a integer value.
	IntValue int32 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type Value_StringValue struct {
	// Represents a string value.
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_EnumValue struct {
	// Represents an enum value.
	EnumValue *EnumValue `protobuf:"bytes,4,opt,name=enum_value,json=enumValue,proto3,oneof"`
}

type Value_DatetimeValue struct {
	// Represents a datetime value.
	DatetimeValue *datetime.DateTime `protobuf:"bytes,5,opt,name=datetime_value,json=datetimeValue,proto3,oneof"`
}

type Value_TimestampValue struct {
	// Represents a timestamp value.
	TimestampValue *TimestampValue `protobuf:"bytes,6,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type Value_BooleanValue struct {
	// Represents a boolean value.
	BooleanValue bool `protobuf:"varint,7,opt,name=boolean_value,json=booleanValue,proto3,oneof"`
}

func (*Value_FloatValue) isValue_Kind() {}

func (*Value_IntValue) isValue_Kind() {}

func (*Value_StringValue) isValue_Kind() {}

func (*Value_EnumValue) isValue_Kind() {}

func (*Value_DatetimeValue) isValue_Kind() {}

func (*Value_TimestampValue) isValue_Kind() {}

func (*Value_BooleanValue) isValue_Kind() {}

// Represents the string value of the enum field.
type EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String value of the enum field. This must match defined set of enums
	// in document schema using EnumTypeOptions.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *EnumValue) Reset() {
	*x = EnumValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumValue) ProtoMessage() {}

func (x *EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumValue.ProtoReflect.Descriptor instead.
func (*EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP(), []int{13}
}

func (x *EnumValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_contentwarehouse_v1_document_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_document_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc4, 0x09, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x72, 0x69, 0x12, 0x65, 0x0a, 0x14, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x12, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x52, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x61, 0x69, 0x5f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x41, 0x69, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x11,
	0x72, 0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0f, 0x72, 0x61, 0x77, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x30, 0x0a, 0x13, 0x69, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x16,
	0x72, 0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x13, 0x72, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x73, 0x79, 0x6e,
	0x63, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x38, 0x0a,
	0x18, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x16, 0x74, 0x65, 0x78, 0x74, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x3a, 0xba, 0x01, 0xea, 0x41,
	0xb6, 0x01, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x2f, 0x7b, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x42, 0x14, 0x0a, 0x12, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x0e,
	0x0a, 0x0c, 0x72, 0x61, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x9b,
	0x03, 0x0a, 0x11, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x73, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x73,
	0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xe5, 0x05, 0x0a,
	0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x67, 0x65, 0x72, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0c, 0x66,
	0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48,
	0x00, 0x52, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x4e,
	0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x4e,
	0x0a, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x41, 0x72, 0x72, 0x61, 0x79,
	0x48, 0x00, 0x52, 0x0a, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x5a,
	0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x10, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0c, 0x6d, 0x61, 0x70, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0b,
	0x6d, 0x61, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x5d, 0x0a, 0x10, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x22, 0x26, 0x0a, 0x0c, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x05, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x24, 0x0a, 0x0a,
	0x46, 0x6c, 0x6f, 0x61, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x22, 0x23, 0x0a, 0x09, 0x54, 0x65, 0x78, 0x74, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x23, 0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x3e, 0x0a, 0x0d,
	0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x2d, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x5a, 0x0a, 0x0e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x48,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x81, 0x01, 0x0a, 0x0e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x48, 0x00, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x5b, 0x0a, 0x0d,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x4a, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xc4, 0x01, 0x0a, 0x0b, 0x4d, 0x61,
	0x70, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x51, 0x0a, 0x06, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x62, 0x0a, 0x0b,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x88, 0x03, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x66, 0x6c,
	0x6f, 0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x48,
	0x00, 0x52, 0x0a, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a,
	0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x3e, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00,
	0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x5b, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d,
	0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x21, 0x0a, 0x09, 0x45,
	0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x2a, 0xe1,
	0x01, 0x0a, 0x13, 0x52, 0x61, 0x77, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x4f,
	0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e,
	0x0a, 0x1a, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x44, 0x46, 0x10, 0x01, 0x12, 0x1f,
	0x0a, 0x1b, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x4f, 0x43, 0x58, 0x10, 0x02, 0x12,
	0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x58, 0x4c, 0x53, 0x58, 0x10, 0x03,
	0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x50, 0x54, 0x58, 0x10,
	0x04, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x57, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x45, 0x58, 0x54,
	0x10, 0x05, 0x42, 0x89, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_document_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_document_proto_rawDescData = file_google_cloud_contentwarehouse_v1_document_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_document_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_document_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_document_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_document_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_document_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_document_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_contentwarehouse_v1_document_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_contentwarehouse_v1_document_proto_goTypes = []interface{}{
	(RawDocumentFileType)(0),      // 0: google.cloud.contentwarehouse.v1.RawDocumentFileType
	(*Document)(nil),              // 1: google.cloud.contentwarehouse.v1.Document
	(*DocumentReference)(nil),     // 2: google.cloud.contentwarehouse.v1.DocumentReference
	(*Property)(nil),              // 3: google.cloud.contentwarehouse.v1.Property
	(*IntegerArray)(nil),          // 4: google.cloud.contentwarehouse.v1.IntegerArray
	(*FloatArray)(nil),            // 5: google.cloud.contentwarehouse.v1.FloatArray
	(*TextArray)(nil),             // 6: google.cloud.contentwarehouse.v1.TextArray
	(*EnumArray)(nil),             // 7: google.cloud.contentwarehouse.v1.EnumArray
	(*DateTimeArray)(nil),         // 8: google.cloud.contentwarehouse.v1.DateTimeArray
	(*TimestampArray)(nil),        // 9: google.cloud.contentwarehouse.v1.TimestampArray
	(*TimestampValue)(nil),        // 10: google.cloud.contentwarehouse.v1.TimestampValue
	(*PropertyArray)(nil),         // 11: google.cloud.contentwarehouse.v1.PropertyArray
	(*MapProperty)(nil),           // 12: google.cloud.contentwarehouse.v1.MapProperty
	(*Value)(nil),                 // 13: google.cloud.contentwarehouse.v1.Value
	(*EnumValue)(nil),             // 14: google.cloud.contentwarehouse.v1.EnumValue
	nil,                           // 15: google.cloud.contentwarehouse.v1.MapProperty.FieldsEntry
	(*v1.Document)(nil),           // 16: google.cloud.documentai.v1.Document
	(*timestamppb.Timestamp)(nil), // 17: google.protobuf.Timestamp
	(*datetime.DateTime)(nil),     // 18: google.type.DateTime
}
var file_google_cloud_contentwarehouse_v1_document_proto_depIdxs = []int32{
	16, // 0: google.cloud.contentwarehouse.v1.Document.cloud_ai_document:type_name -> google.cloud.documentai.v1.Document
	3,  // 1: google.cloud.contentwarehouse.v1.Document.properties:type_name -> google.cloud.contentwarehouse.v1.Property
	17, // 2: google.cloud.contentwarehouse.v1.Document.update_time:type_name -> google.protobuf.Timestamp
	17, // 3: google.cloud.contentwarehouse.v1.Document.create_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.cloud.contentwarehouse.v1.Document.raw_document_file_type:type_name -> google.cloud.contentwarehouse.v1.RawDocumentFileType
	17, // 5: google.cloud.contentwarehouse.v1.DocumentReference.update_time:type_name -> google.protobuf.Timestamp
	17, // 6: google.cloud.contentwarehouse.v1.DocumentReference.create_time:type_name -> google.protobuf.Timestamp
	17, // 7: google.cloud.contentwarehouse.v1.DocumentReference.delete_time:type_name -> google.protobuf.Timestamp
	4,  // 8: google.cloud.contentwarehouse.v1.Property.integer_values:type_name -> google.cloud.contentwarehouse.v1.IntegerArray
	5,  // 9: google.cloud.contentwarehouse.v1.Property.float_values:type_name -> google.cloud.contentwarehouse.v1.FloatArray
	6,  // 10: google.cloud.contentwarehouse.v1.Property.text_values:type_name -> google.cloud.contentwarehouse.v1.TextArray
	7,  // 11: google.cloud.contentwarehouse.v1.Property.enum_values:type_name -> google.cloud.contentwarehouse.v1.EnumArray
	11, // 12: google.cloud.contentwarehouse.v1.Property.property_values:type_name -> google.cloud.contentwarehouse.v1.PropertyArray
	8,  // 13: google.cloud.contentwarehouse.v1.Property.date_time_values:type_name -> google.cloud.contentwarehouse.v1.DateTimeArray
	12, // 14: google.cloud.contentwarehouse.v1.Property.map_property:type_name -> google.cloud.contentwarehouse.v1.MapProperty
	9,  // 15: google.cloud.contentwarehouse.v1.Property.timestamp_values:type_name -> google.cloud.contentwarehouse.v1.TimestampArray
	18, // 16: google.cloud.contentwarehouse.v1.DateTimeArray.values:type_name -> google.type.DateTime
	10, // 17: google.cloud.contentwarehouse.v1.TimestampArray.values:type_name -> google.cloud.contentwarehouse.v1.TimestampValue
	17, // 18: google.cloud.contentwarehouse.v1.TimestampValue.timestamp_value:type_name -> google.protobuf.Timestamp
	3,  // 19: google.cloud.contentwarehouse.v1.PropertyArray.properties:type_name -> google.cloud.contentwarehouse.v1.Property
	15, // 20: google.cloud.contentwarehouse.v1.MapProperty.fields:type_name -> google.cloud.contentwarehouse.v1.MapProperty.FieldsEntry
	14, // 21: google.cloud.contentwarehouse.v1.Value.enum_value:type_name -> google.cloud.contentwarehouse.v1.EnumValue
	18, // 22: google.cloud.contentwarehouse.v1.Value.datetime_value:type_name -> google.type.DateTime
	10, // 23: google.cloud.contentwarehouse.v1.Value.timestamp_value:type_name -> google.cloud.contentwarehouse.v1.TimestampValue
	13, // 24: google.cloud.contentwarehouse.v1.MapProperty.FieldsEntry.value:type_name -> google.cloud.contentwarehouse.v1.Value
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_document_proto_init() }
func file_google_cloud_contentwarehouse_v1_document_proto_init() {
	if File_google_cloud_contentwarehouse_v1_document_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntegerArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FloatArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnumArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PropertyArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnumValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Document_PlainText)(nil),
		(*Document_CloudAiDocument)(nil),
		(*Document_RawDocumentPath)(nil),
		(*Document_InlineRawDocument)(nil),
	}
	file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Property_IntegerValues)(nil),
		(*Property_FloatValues)(nil),
		(*Property_TextValues)(nil),
		(*Property_EnumValues)(nil),
		(*Property_PropertyValues)(nil),
		(*Property_DateTimeValues)(nil),
		(*Property_MapProperty)(nil),
		(*Property_TimestampValues)(nil),
	}
	file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*TimestampValue_TimestampValue)(nil),
		(*TimestampValue_TextValue)(nil),
	}
	file_google_cloud_contentwarehouse_v1_document_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*Value_FloatValue)(nil),
		(*Value_IntValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_EnumValue)(nil),
		(*Value_DatetimeValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_BooleanValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_document_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_document_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_document_proto_depIdxs,
		EnumInfos:         file_google_cloud_contentwarehouse_v1_document_proto_enumTypes,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_document_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_document_proto = out.File
	file_google_cloud_contentwarehouse_v1_document_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_document_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_document_proto_depIdxs = nil
}
