/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.util.ByteVector;

public final class SignatureWriter
extends AttributeWriter {
    @Nonnegative
    private final int signatureIndex;

    public SignatureWriter(@Nonnull ConstantPoolGeneration cp, @Nonnull String signature) {
        super(cp, "Signature");
        this.signatureIndex = cp.newUTF8(signature);
    }

    @Override
    @Nonnegative
    public int getSize() {
        return 8;
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        super.put(out);
        out.putShort(this.signatureIndex);
    }
}

