/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class OutputFile
extends PrintWriter {
    private static final Pattern PATH_SEPARATOR = Pattern.compile("/");
    @Nonnull
    private final String relPathToOutDir;
    private final boolean withPrettyPrint;

    public OutputFile(@Nonnull File file) throws IOException {
        super(file, "UTF-8");
        this.relPathToOutDir = "";
        this.withPrettyPrint = false;
    }

    public OutputFile(@Nonnull String outputDir, @Nonnull String sourceFilePath) throws IOException {
        super(OutputFile.getOutputFileCreatingDirIfNeeded(outputDir, sourceFilePath));
        this.relPathToOutDir = OutputFile.getRelativeSubPathToOutputDir(sourceFilePath);
        this.withPrettyPrint = true;
    }

    @Nonnull
    private static File getOutputFileCreatingDirIfNeeded(@Nonnull String outputDir, @Nonnull String sourceFilePath) {
        File outputFile = OutputFile.getOutputFile(outputDir, sourceFilePath);
        File parentDir = outputFile.getParentFile();
        if (!parentDir.exists()) {
            boolean outputDirCreated = parentDir.mkdirs();
            assert (outputDirCreated) : "Failed to create output dir: " + outputDir;
        }
        return outputFile;
    }

    @Nonnull
    static File getOutputFile(@Nonnull String outputDir, @Nonnull String sourceFilePath) {
        int p = sourceFilePath.lastIndexOf(46);
        String outputFileName = sourceFilePath.substring(0, p) + ".html";
        File outputFile = new File(outputDir, outputFileName);
        return outputFile;
    }

    @Nonnull
    private static String getRelativeSubPathToOutputDir(@Nonnull String filePath) {
        StringBuilder cssRelPath = new StringBuilder();
        int n = PATH_SEPARATOR.split(filePath).length;
        for (int i = 1; i < n; ++i) {
            cssRelPath.append("../");
        }
        return cssRelPath.toString();
    }

    public void writeCommonHeader(@Nonnull String pageTitle) {
        this.println("<!DOCTYPE html>");
        this.println("<html>");
        this.println("<head>");
        this.println("  <title>" + pageTitle + "</title>");
        this.println("  <meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>");
        this.println("  <link rel='stylesheet' type='text/css' href='" + this.relPathToOutDir + "coverage.css'/>");
        this.println("  <link rel='shortcut icon' type='image/png' href='" + this.relPathToOutDir + "logo.png'/>");
        this.println("  <script type='text/javascript' src='" + this.relPathToOutDir + "coverage.js'></script>");
        if (this.withPrettyPrint) {
            this.println("  <script type='text/javascript' src='" + this.relPathToOutDir + "prettify.js'></script>");
        }
        this.println("</head>");
        this.println(this.withPrettyPrint ? "<body onload='prettyPrint()'>" : "<body>");
    }

    public void writeCommonFooter() {
        this.println("</body>");
        this.println("</html>");
    }
}

