/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClassIdentification {
    @Nullable
    public final ClassLoader loader;
    @Nonnull
    public final String name;

    public ClassIdentification(@Nullable ClassLoader loader, @Nonnull String name) {
        this.loader = loader;
        this.name = name;
    }

    @Nonnull
    public Class<?> getLoadedClass() {
        try {
            return Class.forName(this.name, false, this.loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassIdentification other = (ClassIdentification)o;
        return this.loader == other.loader && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.loader == null ? this.name.hashCode() : 31 * this.loader.hashCode() + this.name.hashCode();
    }
}

