/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CodeCoverage;
import mockit.internal.ClassIdentification;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.startup.ClassLoadingBridgeFields;
import mockit.internal.startup.JMockitInitialization;
import mockit.internal.state.CachedClassfiles;

public final class Startup {
    public static boolean initializing;
    @Nullable
    private static Instrumentation instrumentation;

    private Startup() {
    }

    public static void premain(@Nullable String agentArgs, @Nonnull Instrumentation inst) {
        if (!Startup.activateCodeCoverageIfRequested(agentArgs, inst)) {
            ClassLoadingBridgeFields.createSyntheticFieldsInJREClassToHoldClassLoadingBridges(inst);
            instrumentation = inst;
            Startup.initialize(inst);
        }
    }

    private static void initialize(@Nonnull Instrumentation inst) {
        inst.addTransformer(CachedClassfiles.INSTANCE, true);
        Startup.applyStartupFakes(inst);
        inst.addTransformer(new ExpectationsTransformer());
    }

    private static void applyStartupFakes(@Nonnull Instrumentation inst) {
        initializing = true;
        try {
            JMockitInitialization.initialize(inst);
        }
        finally {
            initializing = false;
        }
    }

    private static boolean activateCodeCoverageIfRequested(@Nullable String agentArgs, @Nonnull Instrumentation inst) {
        if ("coverage".equals(agentArgs)) {
            try {
                CodeCoverage coverage = CodeCoverage.create(true);
                inst.addTransformer(coverage);
                return true;
            }
            catch (Throwable t) {
                try {
                    PrintWriter out = new PrintWriter("coverage-failure.txt");
                    t.printStackTrace(out);
                    out.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Nonnull
    public static Instrumentation instrumentation() {
        return instrumentation;
    }

    public static void verifyInitialization() {
        if (instrumentation == null) {
            throw new IllegalStateException("JMockit didn't get initialized; please check the -javaagent JVM initialization parameter was used");
        }
    }

    public static void retransformClass(@Nonnull Class<?> aClass) {
        try {
            instrumentation.retransformClasses(aClass);
        }
        catch (UnmodifiableClassException unmodifiableClassException) {
            // empty catch block
        }
    }

    public static void redefineMethods(@Nonnull ClassIdentification classToRedefine, @Nonnull byte[] modifiedClassfile) {
        Class<?> loadedClass = classToRedefine.getLoadedClass();
        Startup.redefineMethods(loadedClass, modifiedClassfile);
    }

    public static void redefineMethods(@Nonnull Class<?> classToRedefine, @Nonnull byte[] modifiedClassfile) {
        Startup.redefineMethods(new ClassDefinition(classToRedefine, modifiedClassfile));
    }

    public static void redefineMethods(ClassDefinition ... classDefs) {
        try {
            instrumentation.redefineClasses(classDefs);
        }
        catch (ClassNotFoundException | UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        catch (InternalError ignore) {
            for (ClassDefinition classDef : classDefs) {
                Startup.detectMissingDependenciesIfAny(classDef.getDefinitionClass());
            }
        }
    }

    private static void detectMissingDependenciesIfAny(@Nonnull Class<?> mockedClass) {
        try {
            Class.forName(mockedClass.getName(), false, mockedClass.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Unable to mock " + mockedClass + " due to a missing dependency", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Nullable
    public static Class<?> getClassIfLoaded(@Nonnull String classDescOrName) {
        Class[] loadedClasses;
        String className = classDescOrName.replace('/', '.');
        for (Class aClass : loadedClasses = instrumentation.getAllLoadedClasses()) {
            if (!aClass.getName().equals(className)) continue;
            return aClass;
        }
        return null;
    }
}

