/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.ClassFile;
import mockit.internal.ClassIdentification;
import mockit.internal.capturing.CaptureTransformer;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;

public final class MockFixture {
    @Nonnull
    private final Map<ClassIdentification, byte[]> transformedClasses = new HashMap<ClassIdentification, byte[]>(2);
    @Nonnull
    private final Map<Class<?>, byte[]> redefinedClasses = new ConcurrentHashMap(8);
    @Nonnull
    private final Map<Class<?>, String> realClassesToFakeClasses = new IdentityHashMap(8);
    @Nonnull
    private final List<Class<?>> mockedClasses = new ArrayList();
    @Nonnull
    private final Map<Type, InstanceFactory> mockedTypesAndInstances = new IdentityHashMap<Type, InstanceFactory>();
    @Nonnull
    private final List<CaptureTransformer<?>> captureTransformers = new ArrayList();

    MockFixture() {
    }

    public void addTransformedClass(@Nonnull ClassIdentification classId, @Nonnull byte[] pretransformClassfile) {
        this.transformedClasses.put(classId, pretransformClassfile);
    }

    public void addRedefinedClass(@Nonnull ClassDefinition newClassDefinition) {
        this.redefinedClasses.put(newClassDefinition.getDefinitionClass(), newClassDefinition.getDefinitionClassFile());
    }

    public void registerMockedClass(@Nonnull Class<?> mockedType) {
        if (!this.isMockedClass(mockedType)) {
            if (Proxy.isProxyClass(mockedType)) {
                mockedType = mockedType.getInterfaces()[0];
            }
            this.mockedClasses.add(mockedType);
        }
    }

    private boolean isMockedClass(@Nonnull Class<?> targetClass) {
        int n = this.mockedClasses.size();
        for (int i = 0; i < n; ++i) {
            Class<?> mockedClass = this.mockedClasses.get(i);
            if (mockedClass != targetClass) continue;
            return true;
        }
        return false;
    }

    public void redefineClasses(ClassDefinition ... definitions) {
        Startup.redefineMethods(definitions);
        for (ClassDefinition def : definitions) {
            this.addRedefinedClass(def);
        }
    }

    public void redefineMethods(@Nonnull Map<Class<?>, byte[]> modifiedClassfiles) {
        ClassDefinition[] classDefs = new ClassDefinition[modifiedClassfiles.size()];
        int i = 0;
        for (Map.Entry<Class<?>, byte[]> classAndBytecode : modifiedClassfiles.entrySet()) {
            Class<?> modifiedClass = classAndBytecode.getKey();
            byte[] modifiedClassfile = classAndBytecode.getValue();
            ClassDefinition classDef = new ClassDefinition(modifiedClass, modifiedClassfile);
            classDefs[i++] = classDef;
            this.addRedefinedClass(classDef);
        }
        Startup.redefineMethods(classDefs);
    }

    public boolean isStillMocked(@Nullable Object instance, @Nonnull String classDesc) {
        if (instance == null) {
            Class targetClass = ClassLoad.loadByInternalName(classDesc);
            return Utilities.isClassAssignableTo(this.mockedClasses, targetClass);
        }
        Class<?> targetClass = instance.getClass();
        return this.mockedTypesAndInstances.containsKey(targetClass) || this.isInstanceOfMockedClass(instance);
    }

    public boolean isInstanceOfMockedClass(@Nonnull Object mockedInstance) {
        Class<?> mockedClass = mockedInstance.getClass();
        return Utilities.findClassAssignableFrom(this.mockedClasses, mockedClass) != null;
    }

    public void registerInstanceFactoryForMockedType(@Nonnull Class<?> mockedType, @Nonnull InstanceFactory mockedInstanceFactory) {
        this.registerMockedClass(mockedType);
        this.mockedTypesAndInstances.put(mockedType, mockedInstanceFactory);
    }

    @Nullable
    public InstanceFactory findInstanceFactory(@Nonnull Type mockedType) {
        InstanceFactory instanceFactory = this.mockedTypesAndInstances.get(mockedType);
        if (instanceFactory != null) {
            return instanceFactory;
        }
        Class<?> mockedClass = Utilities.getClassType(mockedType);
        instanceFactory = this.mockedTypesAndInstances.get(mockedClass);
        if (instanceFactory != null) {
            return instanceFactory;
        }
        boolean abstractType = mockedClass.isInterface() || Modifier.isAbstract(mockedClass.getModifiers());
        for (Map.Entry<Type, InstanceFactory> entry : this.mockedTypesAndInstances.entrySet()) {
            Type registeredMockedType = entry.getKey();
            Class<?> registeredMockedClass = Utilities.getClassType(registeredMockedType);
            if (abstractType) {
                registeredMockedClass = GeneratedClasses.getMockedClassOrInterfaceType(registeredMockedClass);
            }
            if (!mockedClass.isAssignableFrom(registeredMockedClass)) continue;
            instanceFactory = entry.getValue();
            break;
        }
        return instanceFactory;
    }

    public void addRedefinedClass(@Nonnull String fakeClassInternalName, @Nonnull ClassDefinition classDef) {
        Class<?> redefinedClass = classDef.getDefinitionClass();
        String previousNames = this.realClassesToFakeClasses.put(redefinedClass, fakeClassInternalName);
        if (previousNames != null) {
            this.realClassesToFakeClasses.put(redefinedClass, previousNames + ' ' + fakeClassInternalName);
        }
        this.addRedefinedClass(classDef);
    }

    void restoreTransformedClasses(@Nonnull Set<ClassIdentification> previousTransformedClasses) {
        if (!this.transformedClasses.isEmpty()) {
            Set<ClassIdentification> classesToRestore;
            if (previousTransformedClasses.isEmpty()) {
                classesToRestore = this.transformedClasses.keySet();
            } else {
                classesToRestore = this.getTransformedClasses();
                classesToRestore.removeAll(previousTransformedClasses);
            }
            if (!classesToRestore.isEmpty()) {
                this.restoreAndRemoveTransformedClasses(classesToRestore);
            }
        }
    }

    @Nonnull
    Set<ClassIdentification> getTransformedClasses() {
        return this.transformedClasses.isEmpty() ? Collections.emptySet() : new HashSet<ClassIdentification>(this.transformedClasses.keySet());
    }

    @Nonnull
    Map<Class<?>, byte[]> getRedefinedClasses() {
        return this.redefinedClasses.isEmpty() ? Collections.emptyMap() : new HashMap(this.redefinedClasses);
    }

    private void restoreAndRemoveTransformedClasses(@Nonnull Set<ClassIdentification> classesToRestore) {
        for (ClassIdentification transformedClassId : classesToRestore) {
            byte[] definitionToRestore = this.transformedClasses.get(transformedClassId);
            Startup.redefineMethods(transformedClassId, definitionToRestore);
        }
        this.transformedClasses.keySet().removeAll(classesToRestore);
    }

    void restoreRedefinedClasses(@Nonnull Map<?, byte[]> previousDefinitions) {
        if (this.redefinedClasses.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Class<?>, byte[]>> itr = this.redefinedClasses.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Class<?>, byte[]> entry = itr.next();
            Class<?> redefinedClass = entry.getKey();
            byte[] currentDefinition = entry.getValue();
            byte[] previousDefinition = previousDefinitions.get(redefinedClass);
            if (previousDefinition == null) {
                this.restoreDefinition(redefinedClass);
                itr.remove();
                continue;
            }
            if (currentDefinition == previousDefinition) continue;
            Startup.redefineMethods(redefinedClass, previousDefinition);
            entry.setValue(previousDefinition);
        }
    }

    private void restoreDefinition(@Nonnull Class<?> redefinedClass) {
        if (!GeneratedClasses.isGeneratedImplementationClass(redefinedClass)) {
            byte[] previousDefinition = ClassFile.getClassFile(redefinedClass);
            Startup.redefineMethods(redefinedClass, previousDefinition);
        }
        this.removeMockedClass(redefinedClass);
        this.discardStateForCorrespondingFakeClassIfAny(redefinedClass);
    }

    private void removeMockedClass(@Nonnull Class<?> mockedClass) {
        this.mockedTypesAndInstances.remove(mockedClass);
        this.mockedClasses.remove(mockedClass);
    }

    private void discardStateForCorrespondingFakeClassIfAny(@Nonnull Class<?> redefinedClass) {
        String mockClassesInternalNames = this.realClassesToFakeClasses.remove(redefinedClass);
        TestRun.getFakeStates().removeClassState(redefinedClass, mockClassesInternalNames);
    }

    void removeMockedClasses(@Nonnull List<Class<?>> previousMockedClasses) {
        int currentMockedClassCount = this.mockedClasses.size();
        if (currentMockedClassCount > 0) {
            int previousMockedClassCount = previousMockedClasses.size();
            if (previousMockedClassCount == 0) {
                this.mockedClasses.clear();
                this.mockedTypesAndInstances.clear();
            } else if (previousMockedClassCount < currentMockedClassCount) {
                this.mockedClasses.retainAll(previousMockedClasses);
                this.mockedTypesAndInstances.keySet().retainAll(previousMockedClasses);
            }
        }
    }

    @Nullable
    public byte[] getRedefinedClassfile(@Nonnull Class<?> redefinedClass) {
        return this.redefinedClasses.get(redefinedClass);
    }

    public boolean containsRedefinedClass(@Nonnull Class<?> redefinedClass) {
        return this.redefinedClasses.containsKey(redefinedClass);
    }

    @Nonnull
    public List<Class<?>> getMockedClasses() {
        return this.mockedClasses.isEmpty() ? Collections.emptyList() : new ArrayList(this.mockedClasses);
    }

    public void addCaptureTransformer(@Nonnull CaptureTransformer<?> transformer) {
        this.captureTransformers.add(transformer);
    }

    int getCaptureTransformerCount() {
        return this.captureTransformers.size();
    }

    void removeCaptureTransformers(int previousTransformerCount) {
        int currentTransformerCount = this.captureTransformers.size();
        for (int i = currentTransformerCount - 1; i >= previousTransformerCount; --i) {
            CaptureTransformer<?> transformer = this.captureTransformers.get(i);
            transformer.deactivate();
            Startup.instrumentation().removeTransformer(transformer);
            this.captureTransformers.remove(i);
        }
    }

    @Nullable
    public CaptureOfNewInstances findCaptureOfImplementations(@Nonnull Class<?> capturedType) {
        for (CaptureTransformer<?> captureTransformer : this.captureTransformers) {
            CaptureOfNewInstances capture = (CaptureOfNewInstances)captureTransformer.getCaptureOfImplementationsIfApplicable(capturedType);
            if (capture == null) continue;
            return capture;
        }
        return null;
    }

    public boolean isCaptured(@Nonnull Object mockedInstance) {
        Class<?> mockedClass = GeneratedClasses.getMockedClass(mockedInstance);
        CaptureOfNewInstances capture = this.findCaptureOfImplementations(mockedClass);
        return capture != null;
    }

    public boolean areCapturedClasses(@Nonnull Class<?> mockedClass1, @Nonnull Class<?> mockedClass2) {
        for (CaptureTransformer<?> captureTransformer : this.captureTransformers) {
            if (!captureTransformer.areCapturedClasses(mockedClass1, mockedClass2)) continue;
            return true;
        }
        return false;
    }
}

