// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// Sample represents each record value encountered within a profiled program.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSample function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Sample struct {
	orig  *internal.Sample
	state *internal.State
}

func newSample(orig *internal.Sample, state *internal.State) Sample {
	return Sample{orig: orig, state: state}
}

// NewSample creates a new empty Sample.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewSample() Sample {
	return newSample(internal.NewSample(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Sample) MoveTo(dest Sample) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.orig == dest.orig {
		return
	}
	internal.DeleteSample(dest.orig, false)
	*dest.orig, *ms.orig = *ms.orig, *dest.orig
}

// StackIndex returns the stackindex associated with this Sample.
func (ms Sample) StackIndex() int32 {
	return ms.orig.StackIndex
}

// SetStackIndex replaces the stackindex associated with this Sample.
func (ms Sample) SetStackIndex(v int32) {
	ms.state.AssertMutable()
	ms.orig.StackIndex = v
}

// Values returns the Values associated with this Sample.
func (ms Sample) Values() pcommon.Int64Slice {
	return pcommon.Int64Slice(internal.NewInt64SliceWrapper(&ms.orig.Values, ms.state))
}

// AttributeIndices returns the AttributeIndices associated with this Sample.
func (ms Sample) AttributeIndices() pcommon.Int32Slice {
	return pcommon.Int32Slice(internal.NewInt32SliceWrapper(&ms.orig.AttributeIndices, ms.state))
}

// LinkIndex returns the linkindex associated with this Sample.
func (ms Sample) LinkIndex() int32 {
	return ms.orig.LinkIndex
}

// SetLinkIndex replaces the linkindex associated with this Sample.
func (ms Sample) SetLinkIndex(v int32) {
	ms.state.AssertMutable()
	ms.orig.LinkIndex = v
}

// TimestampsUnixNano returns the TimestampsUnixNano associated with this Sample.
func (ms Sample) TimestampsUnixNano() pcommon.UInt64Slice {
	return pcommon.UInt64Slice(internal.NewUInt64SliceWrapper(&ms.orig.TimestampsUnixNano, ms.state))
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Sample) CopyTo(dest Sample) {
	dest.state.AssertMutable()
	internal.CopySample(dest.orig, ms.orig)
}
