// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/analytics/admin/v1beta/analytics_admin.proto

package admin

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for GetAccount RPC.
type GetAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the account to lookup.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccountRequest) Reset() {
	*x = GetAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountRequest) ProtoMessage() {}

func (x *GetAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountRequest.ProtoReflect.Descriptor instead.
func (*GetAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{0}
}

func (x *GetAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccounts RPC.
type ListAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccounts` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccounts` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Accounts in the
	// results. Accounts can be inspected to determine whether they are deleted or
	// not.
	ShowDeleted bool `protobuf:"varint,3,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListAccountsRequest) Reset() {
	*x = ListAccountsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsRequest) ProtoMessage() {}

func (x *ListAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{1}
}

func (x *ListAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAccountsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Request message for ListAccounts RPC.
type ListAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountsResponse) Reset() {
	*x = ListAccountsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountsResponse) ProtoMessage() {}

func (x *ListAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{2}
}

func (x *ListAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteAccount RPC.
type DeleteAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Account to soft-delete.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccountRequest) Reset() {
	*x = DeleteAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccountRequest) ProtoMessage() {}

func (x *DeleteAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccountRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAccount RPC.
type UpdateAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to update.
	// The account's `name` field is used to identify the account.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccountRequest) Reset() {
	*x = UpdateAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountRequest) ProtoMessage() {}

func (x *UpdateAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAccountRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *UpdateAccountRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account to create.
	Account *Account `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Redirect URI where the user will be sent after accepting Terms of Service.
	// Must be configured in Developers Console as a Redirect URI
	RedirectUri string `protobuf:"bytes,2,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
}

func (x *ProvisionAccountTicketRequest) Reset() {
	*x = ProvisionAccountTicketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketRequest) ProtoMessage() {}

func (x *ProvisionAccountTicketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketRequest.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{5}
}

func (x *ProvisionAccountTicketRequest) GetAccount() *Account {
	if x != nil {
		return x.Account
	}
	return nil
}

func (x *ProvisionAccountTicketRequest) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

// Response message for ProvisionAccountTicket RPC.
type ProvisionAccountTicketResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The param to be passed in the ToS link.
	AccountTicketId string `protobuf:"bytes,1,opt,name=account_ticket_id,json=accountTicketId,proto3" json:"account_ticket_id,omitempty"`
}

func (x *ProvisionAccountTicketResponse) Reset() {
	*x = ProvisionAccountTicketResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionAccountTicketResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionAccountTicketResponse) ProtoMessage() {}

func (x *ProvisionAccountTicketResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionAccountTicketResponse.ProtoReflect.Descriptor instead.
func (*ProvisionAccountTicketResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{6}
}

func (x *ProvisionAccountTicketResponse) GetAccountTicketId() string {
	if x != nil {
		return x.AccountTicketId
	}
	return ""
}

// Request message for GetProperty RPC.
type GetPropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the property to lookup.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPropertyRequest) Reset() {
	*x = GetPropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPropertyRequest) ProtoMessage() {}

func (x *GetPropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPropertyRequest.ProtoReflect.Descriptor instead.
func (*GetPropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{7}
}

func (x *GetPropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListProperties RPC.
type ListPropertiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An expression for filtering the results of the request.
	// Fields eligible for filtering are:
	// `parent:`(The resource name of the parent account/property) or
	// `ancestor:`(The resource name of the parent account) or
	// `firebase_project:`(The id or number of the linked firebase project).
	// Some examples of filters:
	//
	// ```
	// | Filter                      | Description                               |
	// |-----------------------------|-------------------------------------------|
	// | parent:accounts/123         | The account with account id: 123.       |
	// | parent:properties/123       | The property with property id: 123.       |
	// | ancestor:accounts/123       | The account with account id: 123.         |
	// | firebase_project:project-id | The firebase project with id: project-id. |
	// | firebase_project:123        | The firebase project with number: 123.    |
	// ```
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListProperties` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Whether to include soft-deleted (ie: "trashed") Properties in the
	// results. Properties can be inspected to determine whether they are deleted
	// or not.
	ShowDeleted bool `protobuf:"varint,4,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListPropertiesRequest) Reset() {
	*x = ListPropertiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesRequest) ProtoMessage() {}

func (x *ListPropertiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesRequest.ProtoReflect.Descriptor instead.
func (*ListPropertiesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{8}
}

func (x *ListPropertiesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPropertiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPropertiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPropertiesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for ListProperties RPC.
type ListPropertiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that matched the filter criteria and were accessible to the caller.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPropertiesResponse) Reset() {
	*x = ListPropertiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPropertiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPropertiesResponse) ProtoMessage() {}

func (x *ListPropertiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPropertiesResponse.ProtoReflect.Descriptor instead.
func (*ListPropertiesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{9}
}

func (x *ListPropertiesResponse) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ListPropertiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for UpdateProperty RPC.
type UpdatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to update.
	// The property's `name` field is used to identify the property to be
	// updated.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePropertyRequest) Reset() {
	*x = UpdatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePropertyRequest) ProtoMessage() {}

func (x *UpdatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePropertyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{10}
}

func (x *UpdatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

func (x *UpdatePropertyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateProperty RPC.
type CreatePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property to create.
	// Note: the supplied property must specify its parent.
	Property *Property `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
}

func (x *CreatePropertyRequest) Reset() {
	*x = CreatePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePropertyRequest) ProtoMessage() {}

func (x *CreatePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePropertyRequest.ProtoReflect.Descriptor instead.
func (*CreatePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{11}
}

func (x *CreatePropertyRequest) GetProperty() *Property {
	if x != nil {
		return x.Property
	}
	return nil
}

// Request message for DeleteProperty RPC.
type DeletePropertyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Property to soft-delete.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeletePropertyRequest) Reset() {
	*x = DeletePropertyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePropertyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePropertyRequest) ProtoMessage() {}

func (x *DeletePropertyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePropertyRequest.ProtoReflect.Descriptor instead.
func (*DeletePropertyRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{12}
}

func (x *DeletePropertyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateFirebaseLink RPC
type CreateFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Firebase link to create.
	FirebaseLink *FirebaseLink `protobuf:"bytes,2,opt,name=firebase_link,json=firebaseLink,proto3" json:"firebase_link,omitempty"`
}

func (x *CreateFirebaseLinkRequest) Reset() {
	*x = CreateFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFirebaseLinkRequest) ProtoMessage() {}

func (x *CreateFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{13}
}

func (x *CreateFirebaseLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFirebaseLinkRequest) GetFirebaseLink() *FirebaseLink {
	if x != nil {
		return x.FirebaseLink
	}
	return nil
}

// Request message for DeleteFirebaseLink RPC
type DeleteFirebaseLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id}
	// Example: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFirebaseLinkRequest) Reset() {
	*x = DeleteFirebaseLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFirebaseLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFirebaseLinkRequest) ProtoMessage() {}

func (x *DeleteFirebaseLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFirebaseLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteFirebaseLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteFirebaseLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListFirebaseLinks RPC
type ListFirebaseLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: properties/{property_id}
	// Example: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return. The service may return
	// fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListFirebaseLinks` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListProperties` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFirebaseLinksRequest) Reset() {
	*x = ListFirebaseLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksRequest) ProtoMessage() {}

func (x *ListFirebaseLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksRequest.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{15}
}

func (x *ListFirebaseLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFirebaseLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFirebaseLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListFirebaseLinks RPC
type ListFirebaseLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of FirebaseLinks. This will have at most one value.
	FirebaseLinks []*FirebaseLink `protobuf:"bytes,1,rep,name=firebase_links,json=firebaseLinks,proto3" json:"firebase_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	// Currently, Google Analytics supports only one FirebaseLink per property,
	// so this will never be populated.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFirebaseLinksResponse) Reset() {
	*x = ListFirebaseLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFirebaseLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFirebaseLinksResponse) ProtoMessage() {}

func (x *ListFirebaseLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFirebaseLinksResponse.ProtoReflect.Descriptor instead.
func (*ListFirebaseLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{16}
}

func (x *ListFirebaseLinksResponse) GetFirebaseLinks() []*FirebaseLink {
	if x != nil {
		return x.FirebaseLinks
	}
	return nil
}

func (x *ListFirebaseLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateGoogleAdsLink RPC
type CreateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The GoogleAdsLink to create.
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,2,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
}

func (x *CreateGoogleAdsLinkRequest) Reset() {
	*x = CreateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *CreateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{17}
}

func (x *CreateGoogleAdsLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

// Request message for UpdateGoogleAdsLink RPC
type UpdateGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GoogleAdsLink to update
	GoogleAdsLink *GoogleAdsLink `protobuf:"bytes,1,opt,name=google_ads_link,json=googleAdsLink,proto3" json:"google_ads_link,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGoogleAdsLinkRequest) Reset() {
	*x = UpdateGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGoogleAdsLinkRequest) ProtoMessage() {}

func (x *UpdateGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{18}
}

func (x *UpdateGoogleAdsLinkRequest) GetGoogleAdsLink() *GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLink
	}
	return nil
}

func (x *UpdateGoogleAdsLinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteGoogleAdsLink RPC.
type DeleteGoogleAdsLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234/googleAdsLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGoogleAdsLinkRequest) Reset() {
	*x = DeleteGoogleAdsLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGoogleAdsLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGoogleAdsLinkRequest) ProtoMessage() {}

func (x *DeleteGoogleAdsLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGoogleAdsLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteGoogleAdsLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteGoogleAdsLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListGoogleAdsLinks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGoogleAdsLinks` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGoogleAdsLinksRequest) Reset() {
	*x = ListGoogleAdsLinksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksRequest) ProtoMessage() {}

func (x *ListGoogleAdsLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksRequest.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{20}
}

func (x *ListGoogleAdsLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGoogleAdsLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGoogleAdsLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListGoogleAdsLinks RPC.
type ListGoogleAdsLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAdsLink `protobuf:"bytes,1,rep,name=google_ads_links,json=googleAdsLinks,proto3" json:"google_ads_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGoogleAdsLinksResponse) Reset() {
	*x = ListGoogleAdsLinksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGoogleAdsLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGoogleAdsLinksResponse) ProtoMessage() {}

func (x *ListGoogleAdsLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGoogleAdsLinksResponse.ProtoReflect.Descriptor instead.
func (*ListGoogleAdsLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{21}
}

func (x *ListGoogleAdsLinksResponse) GetGoogleAdsLinks() []*GoogleAdsLink {
	if x != nil {
		return x.GoogleAdsLinks
	}
	return nil
}

func (x *ListGoogleAdsLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataSharingSettings RPC.
type GetDataSharingSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format: accounts/{account}/dataSharingSettings
	// Example: "accounts/1000/dataSharingSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSharingSettingsRequest) Reset() {
	*x = GetDataSharingSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataSharingSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSharingSettingsRequest) ProtoMessage() {}

func (x *GetDataSharingSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSharingSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataSharingSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{22}
}

func (x *GetDataSharingSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAccountSummaries RPC.
type ListAccountSummariesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of AccountSummary resources to return. The service may
	// return fewer than this value, even if there are additional pages.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccountSummaries` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListAccountSummaries`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccountSummariesRequest) Reset() {
	*x = ListAccountSummariesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesRequest) ProtoMessage() {}

func (x *ListAccountSummariesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesRequest.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{23}
}

func (x *ListAccountSummariesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountSummariesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAccountSummaries RPC.
type ListAccountSummariesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Account summaries of all accounts the caller has access to.
	AccountSummaries []*AccountSummary `protobuf:"bytes,1,rep,name=account_summaries,json=accountSummaries,proto3" json:"account_summaries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountSummariesResponse) Reset() {
	*x = ListAccountSummariesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountSummariesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountSummariesResponse) ProtoMessage() {}

func (x *ListAccountSummariesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountSummariesResponse.ProtoReflect.Descriptor instead.
func (*ListAccountSummariesResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{24}
}

func (x *ListAccountSummariesResponse) GetAccountSummaries() []*AccountSummary {
	if x != nil {
		return x.AccountSummaries
	}
	return nil
}

func (x *ListAccountSummariesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for AcknowledgeUserDataCollection RPC.
type AcknowledgeUserDataCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The property for which to acknowledge user data collection.
	Property string `protobuf:"bytes,1,opt,name=property,proto3" json:"property,omitempty"`
	// Required. An acknowledgement that the caller of this method understands the terms
	// of user data collection.
	//
	// This field must contain the exact value:
	// "I acknowledge that I have the necessary privacy disclosures and rights
	// from my end users for the collection and processing of their data,
	// including the association of such data with the visitation information
	// Google Analytics collects from my site and/or app property."
	Acknowledgement string `protobuf:"bytes,2,opt,name=acknowledgement,proto3" json:"acknowledgement,omitempty"`
}

func (x *AcknowledgeUserDataCollectionRequest) Reset() {
	*x = AcknowledgeUserDataCollectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcknowledgeUserDataCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeUserDataCollectionRequest) ProtoMessage() {}

func (x *AcknowledgeUserDataCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeUserDataCollectionRequest.ProtoReflect.Descriptor instead.
func (*AcknowledgeUserDataCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{25}
}

func (x *AcknowledgeUserDataCollectionRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *AcknowledgeUserDataCollectionRequest) GetAcknowledgement() string {
	if x != nil {
		return x.Acknowledgement
	}
	return ""
}

// Response message for AcknowledgeUserDataCollection RPC.
type AcknowledgeUserDataCollectionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AcknowledgeUserDataCollectionResponse) Reset() {
	*x = AcknowledgeUserDataCollectionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcknowledgeUserDataCollectionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeUserDataCollectionResponse) ProtoMessage() {}

func (x *AcknowledgeUserDataCollectionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeUserDataCollectionResponse.ProtoReflect.Descriptor instead.
func (*AcknowledgeUserDataCollectionResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{26}
}

// Request message for SearchChangeHistoryEvents RPC.
type SearchChangeHistoryEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account resource for which to return change history resources.
	Account string `protobuf:"bytes,1,opt,name=account,proto3" json:"account,omitempty"`
	// Optional. Resource name for a child property. If set, only return changes
	// made to this property or its child resources.
	Property string `protobuf:"bytes,2,opt,name=property,proto3" json:"property,omitempty"`
	// Optional. If set, only return changes if they are for a resource that matches at
	// least one of these types.
	ResourceType []ChangeHistoryResourceType `protobuf:"varint,3,rep,packed,name=resource_type,json=resourceType,proto3,enum=google.analytics.admin.v1beta.ChangeHistoryResourceType" json:"resource_type,omitempty"`
	// Optional. If set, only return changes that match one or more of these types of
	// actions.
	Action []ActionType `protobuf:"varint,4,rep,packed,name=action,proto3,enum=google.analytics.admin.v1beta.ActionType" json:"action,omitempty"`
	// Optional. If set, only return changes if they are made by a user in this list.
	ActorEmail []string `protobuf:"bytes,5,rep,name=actor_email,json=actorEmail,proto3" json:"actor_email,omitempty"`
	// Optional. If set, only return changes made after this time (inclusive).
	EarliestChangeTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=earliest_change_time,json=earliestChangeTime,proto3" json:"earliest_change_time,omitempty"`
	// Optional. If set, only return changes made before this time (inclusive).
	LatestChangeTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=latest_change_time,json=latestChangeTime,proto3" json:"latest_change_time,omitempty"`
	// Optional. The maximum number of ChangeHistoryEvent items to return.
	// The service may return fewer than this value, even if there are additional
	// pages. If unspecified, at most 50 items will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `SearchChangeHistoryEvents` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters provided to `SearchChangeHistoryEvents` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,9,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsRequest) Reset() {
	*x = SearchChangeHistoryEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsRequest) ProtoMessage() {}

func (x *SearchChangeHistoryEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsRequest.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{27}
}

func (x *SearchChangeHistoryEventsRequest) GetAccount() string {
	if x != nil {
		return x.Account
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetProperty() string {
	if x != nil {
		return x.Property
	}
	return ""
}

func (x *SearchChangeHistoryEventsRequest) GetResourceType() []ChangeHistoryResourceType {
	if x != nil {
		return x.ResourceType
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetAction() []ActionType {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetActorEmail() []string {
	if x != nil {
		return x.ActorEmail
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetEarliestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetLatestChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestChangeTime
	}
	return nil
}

func (x *SearchChangeHistoryEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchChangeHistoryEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SearchAccounts RPC.
type SearchChangeHistoryEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results that were accessible to the caller.
	ChangeHistoryEvents []*ChangeHistoryEvent `protobuf:"bytes,1,rep,name=change_history_events,json=changeHistoryEvents,proto3" json:"change_history_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchChangeHistoryEventsResponse) Reset() {
	*x = SearchChangeHistoryEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchChangeHistoryEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchChangeHistoryEventsResponse) ProtoMessage() {}

func (x *SearchChangeHistoryEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchChangeHistoryEventsResponse.ProtoReflect.Descriptor instead.
func (*SearchChangeHistoryEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{28}
}

func (x *SearchChangeHistoryEventsResponse) GetChangeHistoryEvents() []*ChangeHistoryEvent {
	if x != nil {
		return x.ChangeHistoryEvents
	}
	return nil
}

func (x *SearchChangeHistoryEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetMeasurementProtocolSecret RPC.
type GetMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the measurement protocol secret to lookup.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMeasurementProtocolSecretRequest) Reset() {
	*x = GetMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *GetMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*GetMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{29}
}

func (x *GetMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateMeasurementProtocolSecret RPC
type CreateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this secret will be created.
	// Format: properties/{property}/dataStreams/{dataStream}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The measurement protocol secret to create.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,2,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
}

func (x *CreateMeasurementProtocolSecretRequest) Reset() {
	*x = CreateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *CreateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*CreateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{30}
}

func (x *CreateMeasurementProtocolSecretRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

// Request message for DeleteMeasurementProtocolSecret RPC
type DeleteMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MeasurementProtocolSecret to delete.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMeasurementProtocolSecretRequest) Reset() {
	*x = DeleteMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *DeleteMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*DeleteMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteMeasurementProtocolSecretRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateMeasurementProtocolSecret RPC
type UpdateMeasurementProtocolSecretRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The measurement protocol secret to update.
	MeasurementProtocolSecret *MeasurementProtocolSecret `protobuf:"bytes,1,opt,name=measurement_protocol_secret,json=measurementProtocolSecret,proto3" json:"measurement_protocol_secret,omitempty"`
	// The list of fields to be updated. Omitted fields will not be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateMeasurementProtocolSecretRequest) Reset() {
	*x = UpdateMeasurementProtocolSecretRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMeasurementProtocolSecretRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMeasurementProtocolSecretRequest) ProtoMessage() {}

func (x *UpdateMeasurementProtocolSecretRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMeasurementProtocolSecretRequest.ProtoReflect.Descriptor instead.
func (*UpdateMeasurementProtocolSecretRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{32}
}

func (x *UpdateMeasurementProtocolSecretRequest) GetMeasurementProtocolSecret() *MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecret
	}
	return nil
}

func (x *UpdateMeasurementProtocolSecretRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent stream.
	// Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 10 resources will be returned.
	// The maximum value is 10. Higher values will be coerced to the maximum.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListMeasurementProtocolSecrets`
	// call. Provide this to retrieve the subsequent page. When paginating, all
	// other parameters provided to `ListMeasurementProtocolSecrets` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsRequest) Reset() {
	*x = ListMeasurementProtocolSecretsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsRequest) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsRequest.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{33}
}

func (x *ListMeasurementProtocolSecretsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMeasurementProtocolSecretsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListMeasurementProtocolSecret RPC
type ListMeasurementProtocolSecretsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of secrets for the parent stream specified in the request.
	MeasurementProtocolSecrets []*MeasurementProtocolSecret `protobuf:"bytes,1,rep,name=measurement_protocol_secrets,json=measurementProtocolSecrets,proto3" json:"measurement_protocol_secrets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMeasurementProtocolSecretsResponse) Reset() {
	*x = ListMeasurementProtocolSecretsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMeasurementProtocolSecretsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMeasurementProtocolSecretsResponse) ProtoMessage() {}

func (x *ListMeasurementProtocolSecretsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMeasurementProtocolSecretsResponse.ProtoReflect.Descriptor instead.
func (*ListMeasurementProtocolSecretsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{34}
}

func (x *ListMeasurementProtocolSecretsResponse) GetMeasurementProtocolSecrets() []*MeasurementProtocolSecret {
	if x != nil {
		return x.MeasurementProtocolSecrets
	}
	return nil
}

func (x *ListMeasurementProtocolSecretsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateConversionEvent RPC
type CreateConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversion event to create.
	ConversionEvent *ConversionEvent `protobuf:"bytes,1,opt,name=conversion_event,json=conversionEvent,proto3" json:"conversion_event,omitempty"`
	// Required. The resource name of the parent property where this conversion event will
	// be created. Format: properties/123
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateConversionEventRequest) Reset() {
	*x = CreateConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConversionEventRequest) ProtoMessage() {}

func (x *CreateConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConversionEventRequest.ProtoReflect.Descriptor instead.
func (*CreateConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{35}
}

func (x *CreateConversionEventRequest) GetConversionEvent() *ConversionEvent {
	if x != nil {
		return x.ConversionEvent
	}
	return nil
}

func (x *CreateConversionEventRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for GetConversionEvent RPC
type GetConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to retrieve.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversionEventRequest) Reset() {
	*x = GetConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversionEventRequest) ProtoMessage() {}

func (x *GetConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversionEventRequest.ProtoReflect.Descriptor instead.
func (*GetConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{36}
}

func (x *GetConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteConversionEvent RPC
type DeleteConversionEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the conversion event to delete.
	// Format: properties/{property}/conversionEvents/{conversion_event}
	// Example: "properties/123/conversionEvents/456"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversionEventRequest) Reset() {
	*x = DeleteConversionEventRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversionEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversionEventRequest) ProtoMessage() {}

func (x *DeleteConversionEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversionEventRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversionEventRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{37}
}

func (x *DeleteConversionEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListConversionEvents RPC
type ListConversionEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent property.
	// Example: 'properties/123'
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200; (higher values will be coerced to the maximum)
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListConversionEvents` call.
	// Provide this to retrieve the subsequent page.
	// When paginating, all other parameters provided to `ListConversionEvents`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversionEventsRequest) Reset() {
	*x = ListConversionEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsRequest) ProtoMessage() {}

func (x *ListConversionEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsRequest.ProtoReflect.Descriptor instead.
func (*ListConversionEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{38}
}

func (x *ListConversionEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversionEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversionEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListConversionEvents RPC.
type ListConversionEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The requested conversion events
	ConversionEvents []*ConversionEvent `protobuf:"bytes,1,rep,name=conversion_events,json=conversionEvents,proto3" json:"conversion_events,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversionEventsResponse) Reset() {
	*x = ListConversionEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversionEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversionEventsResponse) ProtoMessage() {}

func (x *ListConversionEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversionEventsResponse.ProtoReflect.Descriptor instead.
func (*ListConversionEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{39}
}

func (x *ListConversionEventsResponse) GetConversionEvents() []*ConversionEvent {
	if x != nil {
		return x.ConversionEvents
	}
	return nil
}

func (x *ListConversionEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateCustomDimension RPC.
type CreateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomDimension to create.
	CustomDimension *CustomDimension `protobuf:"bytes,2,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
}

func (x *CreateCustomDimensionRequest) Reset() {
	*x = CreateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomDimensionRequest) ProtoMessage() {}

func (x *CreateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{40}
}

func (x *CreateCustomDimensionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

// Request message for UpdateCustomDimension RPC.
type UpdateCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomDimension to update
	CustomDimension *CustomDimension `protobuf:"bytes,1,opt,name=custom_dimension,json=customDimension,proto3" json:"custom_dimension,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomDimensionRequest) Reset() {
	*x = UpdateCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomDimensionRequest) ProtoMessage() {}

func (x *UpdateCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{41}
}

func (x *UpdateCustomDimensionRequest) GetCustomDimension() *CustomDimension {
	if x != nil {
		return x.CustomDimension
	}
	return nil
}

func (x *UpdateCustomDimensionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomDimensions RPC.
type ListCustomDimensionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomDimensions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomDimensions`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomDimensionsRequest) Reset() {
	*x = ListCustomDimensionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsRequest) ProtoMessage() {}

func (x *ListCustomDimensionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{42}
}

func (x *ListCustomDimensionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomDimensionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomDimensionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomDimensions RPC.
type ListCustomDimensionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomDimensions.
	CustomDimensions []*CustomDimension `protobuf:"bytes,1,rep,name=custom_dimensions,json=customDimensions,proto3" json:"custom_dimensions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomDimensionsResponse) Reset() {
	*x = ListCustomDimensionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomDimensionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomDimensionsResponse) ProtoMessage() {}

func (x *ListCustomDimensionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomDimensionsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomDimensionsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{43}
}

func (x *ListCustomDimensionsResponse) GetCustomDimensions() []*CustomDimension {
	if x != nil {
		return x.CustomDimensions
	}
	return nil
}

func (x *ListCustomDimensionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomDimension RPC.
type ArchiveCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to archive.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomDimensionRequest) Reset() {
	*x = ArchiveCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomDimensionRequest) ProtoMessage() {}

func (x *ArchiveCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{44}
}

func (x *ArchiveCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomDimension RPC.
type GetCustomDimensionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomDimension to get.
	// Example format: properties/1234/customDimensions/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomDimensionRequest) Reset() {
	*x = GetCustomDimensionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomDimensionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomDimensionRequest) ProtoMessage() {}

func (x *GetCustomDimensionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomDimensionRequest.ProtoReflect.Descriptor instead.
func (*GetCustomDimensionRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{45}
}

func (x *GetCustomDimensionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateCustomMetric RPC.
type CreateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CustomMetric to create.
	CustomMetric *CustomMetric `protobuf:"bytes,2,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
}

func (x *CreateCustomMetricRequest) Reset() {
	*x = CreateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCustomMetricRequest) ProtoMessage() {}

func (x *CreateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*CreateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{46}
}

func (x *CreateCustomMetricRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

// Request message for UpdateCustomMetric RPC.
type UpdateCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CustomMetric to update
	CustomMetric *CustomMetric `protobuf:"bytes,1,opt,name=custom_metric,json=customMetric,proto3" json:"custom_metric,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCustomMetricRequest) Reset() {
	*x = UpdateCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCustomMetricRequest) ProtoMessage() {}

func (x *UpdateCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*UpdateCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateCustomMetricRequest) GetCustomMetric() *CustomMetric {
	if x != nil {
		return x.CustomMetric
	}
	return nil
}

func (x *UpdateCustomMetricRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCustomMetrics RPC.
type ListCustomMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListCustomMetrics` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCustomMetrics` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCustomMetricsRequest) Reset() {
	*x = ListCustomMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsRequest) ProtoMessage() {}

func (x *ListCustomMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsRequest.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{48}
}

func (x *ListCustomMetricsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCustomMetricsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCustomMetricsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCustomMetrics RPC.
type ListCustomMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CustomMetrics.
	CustomMetrics []*CustomMetric `protobuf:"bytes,1,rep,name=custom_metrics,json=customMetrics,proto3" json:"custom_metrics,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCustomMetricsResponse) Reset() {
	*x = ListCustomMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCustomMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCustomMetricsResponse) ProtoMessage() {}

func (x *ListCustomMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCustomMetricsResponse.ProtoReflect.Descriptor instead.
func (*ListCustomMetricsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{49}
}

func (x *ListCustomMetricsResponse) GetCustomMetrics() []*CustomMetric {
	if x != nil {
		return x.CustomMetrics
	}
	return nil
}

func (x *ListCustomMetricsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for ArchiveCustomMetric RPC.
type ArchiveCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to archive.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ArchiveCustomMetricRequest) Reset() {
	*x = ArchiveCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveCustomMetricRequest) ProtoMessage() {}

func (x *ArchiveCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*ArchiveCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{50}
}

func (x *ArchiveCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetCustomMetric RPC.
type GetCustomMetricRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CustomMetric to get.
	// Example format: properties/1234/customMetrics/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCustomMetricRequest) Reset() {
	*x = GetCustomMetricRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCustomMetricRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCustomMetricRequest) ProtoMessage() {}

func (x *GetCustomMetricRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCustomMetricRequest.ProtoReflect.Descriptor instead.
func (*GetCustomMetricRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{51}
}

func (x *GetCustomMetricRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetDataRetentionSettings RPC.
type GetDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the settings to lookup.
	// Format:
	// properties/{property}/dataRetentionSettings
	// Example: "properties/1000/dataRetentionSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataRetentionSettingsRequest) Reset() {
	*x = GetDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataRetentionSettingsRequest) ProtoMessage() {}

func (x *GetDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{52}
}

func (x *GetDataRetentionSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataRetentionSettings RPC.
type UpdateDataRetentionSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The settings to update.
	// The `name` field is used to identify the settings to be updated.
	DataRetentionSettings *DataRetentionSettings `protobuf:"bytes,1,opt,name=data_retention_settings,json=dataRetentionSettings,proto3" json:"data_retention_settings,omitempty"`
	// Required. The list of fields to be updated. Field names must be in snake case
	// (e.g., "field_to_update"). Omitted fields will not be updated. To replace
	// the entire entity, use one path with the string "*" to match all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataRetentionSettingsRequest) Reset() {
	*x = UpdateDataRetentionSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataRetentionSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataRetentionSettingsRequest) ProtoMessage() {}

func (x *UpdateDataRetentionSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataRetentionSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataRetentionSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{53}
}

func (x *UpdateDataRetentionSettingsRequest) GetDataRetentionSettings() *DataRetentionSettings {
	if x != nil {
		return x.DataRetentionSettings
	}
	return nil
}

func (x *UpdateDataRetentionSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for CreateDataStream RPC.
type CreateDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DataStream to create.
	DataStream *DataStream `protobuf:"bytes,2,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
}

func (x *CreateDataStreamRequest) Reset() {
	*x = CreateDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataStreamRequest) ProtoMessage() {}

func (x *CreateDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{54}
}

func (x *CreateDataStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataStreamRequest) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

// Request message for DeleteDataStream RPC.
type DeleteDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DataStream to delete.
	// Example format: properties/1234/dataStreams/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataStreamRequest) Reset() {
	*x = DeleteDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataStreamRequest) ProtoMessage() {}

func (x *DeleteDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataStreamRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{55}
}

func (x *DeleteDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateDataStream RPC.
type UpdateDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DataStream to update
	DataStream *DataStream `protobuf:"bytes,1,opt,name=data_stream,json=dataStream,proto3" json:"data_stream,omitempty"`
	// Required. The list of fields to be updated. Omitted fields will not be updated.
	// To replace the entire entity, use one path with the string "*" to match
	// all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataStreamRequest) Reset() {
	*x = UpdateDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataStreamRequest) ProtoMessage() {}

func (x *UpdateDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataStreamRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{56}
}

func (x *UpdateDataStreamRequest) GetDataStream() *DataStream {
	if x != nil {
		return x.DataStream
	}
	return nil
}

func (x *UpdateDataStreamRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListDataStreams RPC.
type ListDataStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Example format: properties/1234
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of resources to return.
	// If unspecified, at most 50 resources will be returned.
	// The maximum value is 200 (higher values will be coerced to the maximum).
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDataStreams` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDataStreams` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataStreamsRequest) Reset() {
	*x = ListDataStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataStreamsRequest) ProtoMessage() {}

func (x *ListDataStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataStreamsRequest.ProtoReflect.Descriptor instead.
func (*ListDataStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{57}
}

func (x *ListDataStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataStreamsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataStreamsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDataStreams RPC.
type ListDataStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of DataStreams.
	DataStreams []*DataStream `protobuf:"bytes,1,rep,name=data_streams,json=dataStreams,proto3" json:"data_streams,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataStreamsResponse) Reset() {
	*x = ListDataStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataStreamsResponse) ProtoMessage() {}

func (x *ListDataStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataStreamsResponse.ProtoReflect.Descriptor instead.
func (*ListDataStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{58}
}

func (x *ListDataStreamsResponse) GetDataStreams() []*DataStream {
	if x != nil {
		return x.DataStreams
	}
	return nil
}

func (x *ListDataStreamsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetDataStream RPC.
type GetDataStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DataStream to get.
	// Example format: properties/1234/dataStreams/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataStreamRequest) Reset() {
	*x = GetDataStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataStreamRequest) ProtoMessage() {}

func (x *GetDataStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataStreamRequest.ProtoReflect.Descriptor instead.
func (*GetDataStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP(), []int{59}
}

func (x *GetDataStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_analytics_admin_v1beta_analytics_admin_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1beta_analytics_admin_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x56, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x74,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x22, 0x82, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a,
	0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x84, 0x01, 0x0a, 0x1d, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x22, 0x4c, 0x0a,
	0x1e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x2a, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b,
	0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x89, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x61, 0x0a,
	0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x22, 0x5b, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x01,
	0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x63,
	0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x46,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x66, 0x69, 0x72,
	0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xc4, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x59,
	0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xb4, 0x01, 0x0a, 0x1a, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x65, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a,
	0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6e, 0x0a,
	0x1d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x59, 0x0a,
	0x1b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x11, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x52, 0x10, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa1, 0x01,
	0x0a, 0x24, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65,
	0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x2d, 0x0a, 0x0f, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x27, 0x0a, 0x25, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf1, 0x04, 0x0a, 0x20, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x47, 0x0a, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x62, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x63, 0x74, 0x6f,
	0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x51, 0x0a, 0x14, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65,
	0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb2,
	0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x15, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x13, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x7a, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39,
	0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x80, 0x02, 0x0a, 0x26, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x7d, 0x0a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x22, 0x7d, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x39, 0x0a, 0x37, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xe4, 0x01, 0x0a, 0x26, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7d, 0x0a, 0x1b,
	0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x19, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbc, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x57, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x12, 0x37, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcc, 0x01, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x7a, 0x0a, 0x1c, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x52, 0x1a, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12,
	0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x69,
	0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01, 0x0a, 0x1c, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbb, 0x01, 0x0a, 0x1c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x10, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x12, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6a, 0x0a, 0x1d, 0x41, 0x72, 0x63,
	0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f,
	0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x01,
	0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0xaf,
	0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0d,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xa2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x64, 0x0a, 0x1a, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x72, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35,
	0x0a, 0x33, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x22,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x71, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x5f,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa7, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9e, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8f, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a, 0x14,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xeb, 0x4c, 0x0a, 0x15, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x90, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x28, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x18, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x12, 0x12, 0x10, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x86, 0x01, 0x0a, 0x0d,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1b, 0x2a, 0x19, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb6, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x32, 0x21, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0xda, 0x41, 0x13, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc9, 0x01,
	0x0a, 0x16, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x22, 0x27, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xb1, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x20, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1a, 0x12, 0x18, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x95, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x1d, 0x12, 0x1b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x99, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0xa0, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x22, 0x12, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3a,
	0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda, 0x41, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x12, 0x9b, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x2a, 0x1b,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x32, 0x24, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0xda, 0x41, 0x14, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x12, 0xd6, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0xa2, 0x01, 0x0a,
	0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xc4, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61,
	0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xde, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x5e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3f, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a,
	0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0xf3, 0x01, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4f, 0x32, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0xda, 0x41, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12,
	0xa5, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0xc8, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf3, 0x01,
	0x0a, 0x1c, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x55, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x86, 0x02, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb5, 0x02, 0x0a,
	0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x65, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x73, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0xda,
	0x41, 0x22, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x12, 0xd7, 0x01, 0x0a, 0x1f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d,
	0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x2a,
	0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd7,
	0x02, 0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x22, 0xb2, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x81, 0x01, 0x32, 0x62, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x1b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0xda, 0x41,
	0x27, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xf4, 0x01, 0x0a, 0x1d, 0x41, 0x63, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x6b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x55, 0x73, 0x65, 0x72, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x01, 0x2a, 0x12,
	0xe1, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x3a, 0x01, 0x2a, 0x12, 0xe8, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x62, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x42, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x3a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0xbd,
	0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22,
	0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xab,
	0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd0, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xe8, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x62, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x2e,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x10,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xfe, 0x01, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x10, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x1c, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xd0, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb8,
	0x01, 0x0a, 0x16, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd6, 0x01, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22,
	0x2b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x0d, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0xda, 0x41, 0x14, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x12, 0xe9, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0xda, 0x41, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc4,
	0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12,
	0x2b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xaf, 0x01, 0x0a, 0x13, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x45, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb1, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x22,
	0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd2, 0x01, 0x0a, 0x18,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x40,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xa9, 0x02, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x90, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x64, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x23, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xca, 0x01, 0x0a,
	0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x22, 0x29, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x9c, 0x01, 0x0a, 0x10, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x38,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x2a, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x22, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x32, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x17, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xbc, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa9, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12,
	0x29, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x1a, 0x84, 0x01, 0xca, 0x41, 0x1d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x61, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x65, 0x64, 0x69, 0x74, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x7e, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x13, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescData = file_google_analytics_admin_v1beta_analytics_admin_proto_rawDesc
)

func file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescData)
	})
	return file_google_analytics_admin_v1beta_analytics_admin_proto_rawDescData
}

var file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 60)
var file_google_analytics_admin_v1beta_analytics_admin_proto_goTypes = []interface{}{
	(*GetAccountRequest)(nil),                      // 0: google.analytics.admin.v1beta.GetAccountRequest
	(*ListAccountsRequest)(nil),                    // 1: google.analytics.admin.v1beta.ListAccountsRequest
	(*ListAccountsResponse)(nil),                   // 2: google.analytics.admin.v1beta.ListAccountsResponse
	(*DeleteAccountRequest)(nil),                   // 3: google.analytics.admin.v1beta.DeleteAccountRequest
	(*UpdateAccountRequest)(nil),                   // 4: google.analytics.admin.v1beta.UpdateAccountRequest
	(*ProvisionAccountTicketRequest)(nil),          // 5: google.analytics.admin.v1beta.ProvisionAccountTicketRequest
	(*ProvisionAccountTicketResponse)(nil),         // 6: google.analytics.admin.v1beta.ProvisionAccountTicketResponse
	(*GetPropertyRequest)(nil),                     // 7: google.analytics.admin.v1beta.GetPropertyRequest
	(*ListPropertiesRequest)(nil),                  // 8: google.analytics.admin.v1beta.ListPropertiesRequest
	(*ListPropertiesResponse)(nil),                 // 9: google.analytics.admin.v1beta.ListPropertiesResponse
	(*UpdatePropertyRequest)(nil),                  // 10: google.analytics.admin.v1beta.UpdatePropertyRequest
	(*CreatePropertyRequest)(nil),                  // 11: google.analytics.admin.v1beta.CreatePropertyRequest
	(*DeletePropertyRequest)(nil),                  // 12: google.analytics.admin.v1beta.DeletePropertyRequest
	(*CreateFirebaseLinkRequest)(nil),              // 13: google.analytics.admin.v1beta.CreateFirebaseLinkRequest
	(*DeleteFirebaseLinkRequest)(nil),              // 14: google.analytics.admin.v1beta.DeleteFirebaseLinkRequest
	(*ListFirebaseLinksRequest)(nil),               // 15: google.analytics.admin.v1beta.ListFirebaseLinksRequest
	(*ListFirebaseLinksResponse)(nil),              // 16: google.analytics.admin.v1beta.ListFirebaseLinksResponse
	(*CreateGoogleAdsLinkRequest)(nil),             // 17: google.analytics.admin.v1beta.CreateGoogleAdsLinkRequest
	(*UpdateGoogleAdsLinkRequest)(nil),             // 18: google.analytics.admin.v1beta.UpdateGoogleAdsLinkRequest
	(*DeleteGoogleAdsLinkRequest)(nil),             // 19: google.analytics.admin.v1beta.DeleteGoogleAdsLinkRequest
	(*ListGoogleAdsLinksRequest)(nil),              // 20: google.analytics.admin.v1beta.ListGoogleAdsLinksRequest
	(*ListGoogleAdsLinksResponse)(nil),             // 21: google.analytics.admin.v1beta.ListGoogleAdsLinksResponse
	(*GetDataSharingSettingsRequest)(nil),          // 22: google.analytics.admin.v1beta.GetDataSharingSettingsRequest
	(*ListAccountSummariesRequest)(nil),            // 23: google.analytics.admin.v1beta.ListAccountSummariesRequest
	(*ListAccountSummariesResponse)(nil),           // 24: google.analytics.admin.v1beta.ListAccountSummariesResponse
	(*AcknowledgeUserDataCollectionRequest)(nil),   // 25: google.analytics.admin.v1beta.AcknowledgeUserDataCollectionRequest
	(*AcknowledgeUserDataCollectionResponse)(nil),  // 26: google.analytics.admin.v1beta.AcknowledgeUserDataCollectionResponse
	(*SearchChangeHistoryEventsRequest)(nil),       // 27: google.analytics.admin.v1beta.SearchChangeHistoryEventsRequest
	(*SearchChangeHistoryEventsResponse)(nil),      // 28: google.analytics.admin.v1beta.SearchChangeHistoryEventsResponse
	(*GetMeasurementProtocolSecretRequest)(nil),    // 29: google.analytics.admin.v1beta.GetMeasurementProtocolSecretRequest
	(*CreateMeasurementProtocolSecretRequest)(nil), // 30: google.analytics.admin.v1beta.CreateMeasurementProtocolSecretRequest
	(*DeleteMeasurementProtocolSecretRequest)(nil), // 31: google.analytics.admin.v1beta.DeleteMeasurementProtocolSecretRequest
	(*UpdateMeasurementProtocolSecretRequest)(nil), // 32: google.analytics.admin.v1beta.UpdateMeasurementProtocolSecretRequest
	(*ListMeasurementProtocolSecretsRequest)(nil),  // 33: google.analytics.admin.v1beta.ListMeasurementProtocolSecretsRequest
	(*ListMeasurementProtocolSecretsResponse)(nil), // 34: google.analytics.admin.v1beta.ListMeasurementProtocolSecretsResponse
	(*CreateConversionEventRequest)(nil),           // 35: google.analytics.admin.v1beta.CreateConversionEventRequest
	(*GetConversionEventRequest)(nil),              // 36: google.analytics.admin.v1beta.GetConversionEventRequest
	(*DeleteConversionEventRequest)(nil),           // 37: google.analytics.admin.v1beta.DeleteConversionEventRequest
	(*ListConversionEventsRequest)(nil),            // 38: google.analytics.admin.v1beta.ListConversionEventsRequest
	(*ListConversionEventsResponse)(nil),           // 39: google.analytics.admin.v1beta.ListConversionEventsResponse
	(*CreateCustomDimensionRequest)(nil),           // 40: google.analytics.admin.v1beta.CreateCustomDimensionRequest
	(*UpdateCustomDimensionRequest)(nil),           // 41: google.analytics.admin.v1beta.UpdateCustomDimensionRequest
	(*ListCustomDimensionsRequest)(nil),            // 42: google.analytics.admin.v1beta.ListCustomDimensionsRequest
	(*ListCustomDimensionsResponse)(nil),           // 43: google.analytics.admin.v1beta.ListCustomDimensionsResponse
	(*ArchiveCustomDimensionRequest)(nil),          // 44: google.analytics.admin.v1beta.ArchiveCustomDimensionRequest
	(*GetCustomDimensionRequest)(nil),              // 45: google.analytics.admin.v1beta.GetCustomDimensionRequest
	(*CreateCustomMetricRequest)(nil),              // 46: google.analytics.admin.v1beta.CreateCustomMetricRequest
	(*UpdateCustomMetricRequest)(nil),              // 47: google.analytics.admin.v1beta.UpdateCustomMetricRequest
	(*ListCustomMetricsRequest)(nil),               // 48: google.analytics.admin.v1beta.ListCustomMetricsRequest
	(*ListCustomMetricsResponse)(nil),              // 49: google.analytics.admin.v1beta.ListCustomMetricsResponse
	(*ArchiveCustomMetricRequest)(nil),             // 50: google.analytics.admin.v1beta.ArchiveCustomMetricRequest
	(*GetCustomMetricRequest)(nil),                 // 51: google.analytics.admin.v1beta.GetCustomMetricRequest
	(*GetDataRetentionSettingsRequest)(nil),        // 52: google.analytics.admin.v1beta.GetDataRetentionSettingsRequest
	(*UpdateDataRetentionSettingsRequest)(nil),     // 53: google.analytics.admin.v1beta.UpdateDataRetentionSettingsRequest
	(*CreateDataStreamRequest)(nil),                // 54: google.analytics.admin.v1beta.CreateDataStreamRequest
	(*DeleteDataStreamRequest)(nil),                // 55: google.analytics.admin.v1beta.DeleteDataStreamRequest
	(*UpdateDataStreamRequest)(nil),                // 56: google.analytics.admin.v1beta.UpdateDataStreamRequest
	(*ListDataStreamsRequest)(nil),                 // 57: google.analytics.admin.v1beta.ListDataStreamsRequest
	(*ListDataStreamsResponse)(nil),                // 58: google.analytics.admin.v1beta.ListDataStreamsResponse
	(*GetDataStreamRequest)(nil),                   // 59: google.analytics.admin.v1beta.GetDataStreamRequest
	(*Account)(nil),                                // 60: google.analytics.admin.v1beta.Account
	(*fieldmaskpb.FieldMask)(nil),                  // 61: google.protobuf.FieldMask
	(*Property)(nil),                               // 62: google.analytics.admin.v1beta.Property
	(*FirebaseLink)(nil),                           // 63: google.analytics.admin.v1beta.FirebaseLink
	(*GoogleAdsLink)(nil),                          // 64: google.analytics.admin.v1beta.GoogleAdsLink
	(*AccountSummary)(nil),                         // 65: google.analytics.admin.v1beta.AccountSummary
	(ChangeHistoryResourceType)(0),                 // 66: google.analytics.admin.v1beta.ChangeHistoryResourceType
	(ActionType)(0),                                // 67: google.analytics.admin.v1beta.ActionType
	(*timestamppb.Timestamp)(nil),                  // 68: google.protobuf.Timestamp
	(*ChangeHistoryEvent)(nil),                     // 69: google.analytics.admin.v1beta.ChangeHistoryEvent
	(*MeasurementProtocolSecret)(nil),              // 70: google.analytics.admin.v1beta.MeasurementProtocolSecret
	(*ConversionEvent)(nil),                        // 71: google.analytics.admin.v1beta.ConversionEvent
	(*CustomDimension)(nil),                        // 72: google.analytics.admin.v1beta.CustomDimension
	(*CustomMetric)(nil),                           // 73: google.analytics.admin.v1beta.CustomMetric
	(*DataRetentionSettings)(nil),                  // 74: google.analytics.admin.v1beta.DataRetentionSettings
	(*DataStream)(nil),                             // 75: google.analytics.admin.v1beta.DataStream
	(*emptypb.Empty)(nil),                          // 76: google.protobuf.Empty
	(*DataSharingSettings)(nil),                    // 77: google.analytics.admin.v1beta.DataSharingSettings
}
var file_google_analytics_admin_v1beta_analytics_admin_proto_depIdxs = []int32{
	60, // 0: google.analytics.admin.v1beta.ListAccountsResponse.accounts:type_name -> google.analytics.admin.v1beta.Account
	60, // 1: google.analytics.admin.v1beta.UpdateAccountRequest.account:type_name -> google.analytics.admin.v1beta.Account
	61, // 2: google.analytics.admin.v1beta.UpdateAccountRequest.update_mask:type_name -> google.protobuf.FieldMask
	60, // 3: google.analytics.admin.v1beta.ProvisionAccountTicketRequest.account:type_name -> google.analytics.admin.v1beta.Account
	62, // 4: google.analytics.admin.v1beta.ListPropertiesResponse.properties:type_name -> google.analytics.admin.v1beta.Property
	62, // 5: google.analytics.admin.v1beta.UpdatePropertyRequest.property:type_name -> google.analytics.admin.v1beta.Property
	61, // 6: google.analytics.admin.v1beta.UpdatePropertyRequest.update_mask:type_name -> google.protobuf.FieldMask
	62, // 7: google.analytics.admin.v1beta.CreatePropertyRequest.property:type_name -> google.analytics.admin.v1beta.Property
	63, // 8: google.analytics.admin.v1beta.CreateFirebaseLinkRequest.firebase_link:type_name -> google.analytics.admin.v1beta.FirebaseLink
	63, // 9: google.analytics.admin.v1beta.ListFirebaseLinksResponse.firebase_links:type_name -> google.analytics.admin.v1beta.FirebaseLink
	64, // 10: google.analytics.admin.v1beta.CreateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1beta.GoogleAdsLink
	64, // 11: google.analytics.admin.v1beta.UpdateGoogleAdsLinkRequest.google_ads_link:type_name -> google.analytics.admin.v1beta.GoogleAdsLink
	61, // 12: google.analytics.admin.v1beta.UpdateGoogleAdsLinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	64, // 13: google.analytics.admin.v1beta.ListGoogleAdsLinksResponse.google_ads_links:type_name -> google.analytics.admin.v1beta.GoogleAdsLink
	65, // 14: google.analytics.admin.v1beta.ListAccountSummariesResponse.account_summaries:type_name -> google.analytics.admin.v1beta.AccountSummary
	66, // 15: google.analytics.admin.v1beta.SearchChangeHistoryEventsRequest.resource_type:type_name -> google.analytics.admin.v1beta.ChangeHistoryResourceType
	67, // 16: google.analytics.admin.v1beta.SearchChangeHistoryEventsRequest.action:type_name -> google.analytics.admin.v1beta.ActionType
	68, // 17: google.analytics.admin.v1beta.SearchChangeHistoryEventsRequest.earliest_change_time:type_name -> google.protobuf.Timestamp
	68, // 18: google.analytics.admin.v1beta.SearchChangeHistoryEventsRequest.latest_change_time:type_name -> google.protobuf.Timestamp
	69, // 19: google.analytics.admin.v1beta.SearchChangeHistoryEventsResponse.change_history_events:type_name -> google.analytics.admin.v1beta.ChangeHistoryEvent
	70, // 20: google.analytics.admin.v1beta.CreateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1beta.MeasurementProtocolSecret
	70, // 21: google.analytics.admin.v1beta.UpdateMeasurementProtocolSecretRequest.measurement_protocol_secret:type_name -> google.analytics.admin.v1beta.MeasurementProtocolSecret
	61, // 22: google.analytics.admin.v1beta.UpdateMeasurementProtocolSecretRequest.update_mask:type_name -> google.protobuf.FieldMask
	70, // 23: google.analytics.admin.v1beta.ListMeasurementProtocolSecretsResponse.measurement_protocol_secrets:type_name -> google.analytics.admin.v1beta.MeasurementProtocolSecret
	71, // 24: google.analytics.admin.v1beta.CreateConversionEventRequest.conversion_event:type_name -> google.analytics.admin.v1beta.ConversionEvent
	71, // 25: google.analytics.admin.v1beta.ListConversionEventsResponse.conversion_events:type_name -> google.analytics.admin.v1beta.ConversionEvent
	72, // 26: google.analytics.admin.v1beta.CreateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1beta.CustomDimension
	72, // 27: google.analytics.admin.v1beta.UpdateCustomDimensionRequest.custom_dimension:type_name -> google.analytics.admin.v1beta.CustomDimension
	61, // 28: google.analytics.admin.v1beta.UpdateCustomDimensionRequest.update_mask:type_name -> google.protobuf.FieldMask
	72, // 29: google.analytics.admin.v1beta.ListCustomDimensionsResponse.custom_dimensions:type_name -> google.analytics.admin.v1beta.CustomDimension
	73, // 30: google.analytics.admin.v1beta.CreateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1beta.CustomMetric
	73, // 31: google.analytics.admin.v1beta.UpdateCustomMetricRequest.custom_metric:type_name -> google.analytics.admin.v1beta.CustomMetric
	61, // 32: google.analytics.admin.v1beta.UpdateCustomMetricRequest.update_mask:type_name -> google.protobuf.FieldMask
	73, // 33: google.analytics.admin.v1beta.ListCustomMetricsResponse.custom_metrics:type_name -> google.analytics.admin.v1beta.CustomMetric
	74, // 34: google.analytics.admin.v1beta.UpdateDataRetentionSettingsRequest.data_retention_settings:type_name -> google.analytics.admin.v1beta.DataRetentionSettings
	61, // 35: google.analytics.admin.v1beta.UpdateDataRetentionSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	75, // 36: google.analytics.admin.v1beta.CreateDataStreamRequest.data_stream:type_name -> google.analytics.admin.v1beta.DataStream
	75, // 37: google.analytics.admin.v1beta.UpdateDataStreamRequest.data_stream:type_name -> google.analytics.admin.v1beta.DataStream
	61, // 38: google.analytics.admin.v1beta.UpdateDataStreamRequest.update_mask:type_name -> google.protobuf.FieldMask
	75, // 39: google.analytics.admin.v1beta.ListDataStreamsResponse.data_streams:type_name -> google.analytics.admin.v1beta.DataStream
	0,  // 40: google.analytics.admin.v1beta.AnalyticsAdminService.GetAccount:input_type -> google.analytics.admin.v1beta.GetAccountRequest
	1,  // 41: google.analytics.admin.v1beta.AnalyticsAdminService.ListAccounts:input_type -> google.analytics.admin.v1beta.ListAccountsRequest
	3,  // 42: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteAccount:input_type -> google.analytics.admin.v1beta.DeleteAccountRequest
	4,  // 43: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateAccount:input_type -> google.analytics.admin.v1beta.UpdateAccountRequest
	5,  // 44: google.analytics.admin.v1beta.AnalyticsAdminService.ProvisionAccountTicket:input_type -> google.analytics.admin.v1beta.ProvisionAccountTicketRequest
	23, // 45: google.analytics.admin.v1beta.AnalyticsAdminService.ListAccountSummaries:input_type -> google.analytics.admin.v1beta.ListAccountSummariesRequest
	7,  // 46: google.analytics.admin.v1beta.AnalyticsAdminService.GetProperty:input_type -> google.analytics.admin.v1beta.GetPropertyRequest
	8,  // 47: google.analytics.admin.v1beta.AnalyticsAdminService.ListProperties:input_type -> google.analytics.admin.v1beta.ListPropertiesRequest
	11, // 48: google.analytics.admin.v1beta.AnalyticsAdminService.CreateProperty:input_type -> google.analytics.admin.v1beta.CreatePropertyRequest
	12, // 49: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteProperty:input_type -> google.analytics.admin.v1beta.DeletePropertyRequest
	10, // 50: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateProperty:input_type -> google.analytics.admin.v1beta.UpdatePropertyRequest
	13, // 51: google.analytics.admin.v1beta.AnalyticsAdminService.CreateFirebaseLink:input_type -> google.analytics.admin.v1beta.CreateFirebaseLinkRequest
	14, // 52: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteFirebaseLink:input_type -> google.analytics.admin.v1beta.DeleteFirebaseLinkRequest
	15, // 53: google.analytics.admin.v1beta.AnalyticsAdminService.ListFirebaseLinks:input_type -> google.analytics.admin.v1beta.ListFirebaseLinksRequest
	17, // 54: google.analytics.admin.v1beta.AnalyticsAdminService.CreateGoogleAdsLink:input_type -> google.analytics.admin.v1beta.CreateGoogleAdsLinkRequest
	18, // 55: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateGoogleAdsLink:input_type -> google.analytics.admin.v1beta.UpdateGoogleAdsLinkRequest
	19, // 56: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteGoogleAdsLink:input_type -> google.analytics.admin.v1beta.DeleteGoogleAdsLinkRequest
	20, // 57: google.analytics.admin.v1beta.AnalyticsAdminService.ListGoogleAdsLinks:input_type -> google.analytics.admin.v1beta.ListGoogleAdsLinksRequest
	22, // 58: google.analytics.admin.v1beta.AnalyticsAdminService.GetDataSharingSettings:input_type -> google.analytics.admin.v1beta.GetDataSharingSettingsRequest
	29, // 59: google.analytics.admin.v1beta.AnalyticsAdminService.GetMeasurementProtocolSecret:input_type -> google.analytics.admin.v1beta.GetMeasurementProtocolSecretRequest
	33, // 60: google.analytics.admin.v1beta.AnalyticsAdminService.ListMeasurementProtocolSecrets:input_type -> google.analytics.admin.v1beta.ListMeasurementProtocolSecretsRequest
	30, // 61: google.analytics.admin.v1beta.AnalyticsAdminService.CreateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1beta.CreateMeasurementProtocolSecretRequest
	31, // 62: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteMeasurementProtocolSecret:input_type -> google.analytics.admin.v1beta.DeleteMeasurementProtocolSecretRequest
	32, // 63: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateMeasurementProtocolSecret:input_type -> google.analytics.admin.v1beta.UpdateMeasurementProtocolSecretRequest
	25, // 64: google.analytics.admin.v1beta.AnalyticsAdminService.AcknowledgeUserDataCollection:input_type -> google.analytics.admin.v1beta.AcknowledgeUserDataCollectionRequest
	27, // 65: google.analytics.admin.v1beta.AnalyticsAdminService.SearchChangeHistoryEvents:input_type -> google.analytics.admin.v1beta.SearchChangeHistoryEventsRequest
	35, // 66: google.analytics.admin.v1beta.AnalyticsAdminService.CreateConversionEvent:input_type -> google.analytics.admin.v1beta.CreateConversionEventRequest
	36, // 67: google.analytics.admin.v1beta.AnalyticsAdminService.GetConversionEvent:input_type -> google.analytics.admin.v1beta.GetConversionEventRequest
	37, // 68: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteConversionEvent:input_type -> google.analytics.admin.v1beta.DeleteConversionEventRequest
	38, // 69: google.analytics.admin.v1beta.AnalyticsAdminService.ListConversionEvents:input_type -> google.analytics.admin.v1beta.ListConversionEventsRequest
	40, // 70: google.analytics.admin.v1beta.AnalyticsAdminService.CreateCustomDimension:input_type -> google.analytics.admin.v1beta.CreateCustomDimensionRequest
	41, // 71: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateCustomDimension:input_type -> google.analytics.admin.v1beta.UpdateCustomDimensionRequest
	42, // 72: google.analytics.admin.v1beta.AnalyticsAdminService.ListCustomDimensions:input_type -> google.analytics.admin.v1beta.ListCustomDimensionsRequest
	44, // 73: google.analytics.admin.v1beta.AnalyticsAdminService.ArchiveCustomDimension:input_type -> google.analytics.admin.v1beta.ArchiveCustomDimensionRequest
	45, // 74: google.analytics.admin.v1beta.AnalyticsAdminService.GetCustomDimension:input_type -> google.analytics.admin.v1beta.GetCustomDimensionRequest
	46, // 75: google.analytics.admin.v1beta.AnalyticsAdminService.CreateCustomMetric:input_type -> google.analytics.admin.v1beta.CreateCustomMetricRequest
	47, // 76: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateCustomMetric:input_type -> google.analytics.admin.v1beta.UpdateCustomMetricRequest
	48, // 77: google.analytics.admin.v1beta.AnalyticsAdminService.ListCustomMetrics:input_type -> google.analytics.admin.v1beta.ListCustomMetricsRequest
	50, // 78: google.analytics.admin.v1beta.AnalyticsAdminService.ArchiveCustomMetric:input_type -> google.analytics.admin.v1beta.ArchiveCustomMetricRequest
	51, // 79: google.analytics.admin.v1beta.AnalyticsAdminService.GetCustomMetric:input_type -> google.analytics.admin.v1beta.GetCustomMetricRequest
	52, // 80: google.analytics.admin.v1beta.AnalyticsAdminService.GetDataRetentionSettings:input_type -> google.analytics.admin.v1beta.GetDataRetentionSettingsRequest
	53, // 81: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateDataRetentionSettings:input_type -> google.analytics.admin.v1beta.UpdateDataRetentionSettingsRequest
	54, // 82: google.analytics.admin.v1beta.AnalyticsAdminService.CreateDataStream:input_type -> google.analytics.admin.v1beta.CreateDataStreamRequest
	55, // 83: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteDataStream:input_type -> google.analytics.admin.v1beta.DeleteDataStreamRequest
	56, // 84: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateDataStream:input_type -> google.analytics.admin.v1beta.UpdateDataStreamRequest
	57, // 85: google.analytics.admin.v1beta.AnalyticsAdminService.ListDataStreams:input_type -> google.analytics.admin.v1beta.ListDataStreamsRequest
	59, // 86: google.analytics.admin.v1beta.AnalyticsAdminService.GetDataStream:input_type -> google.analytics.admin.v1beta.GetDataStreamRequest
	60, // 87: google.analytics.admin.v1beta.AnalyticsAdminService.GetAccount:output_type -> google.analytics.admin.v1beta.Account
	2,  // 88: google.analytics.admin.v1beta.AnalyticsAdminService.ListAccounts:output_type -> google.analytics.admin.v1beta.ListAccountsResponse
	76, // 89: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteAccount:output_type -> google.protobuf.Empty
	60, // 90: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateAccount:output_type -> google.analytics.admin.v1beta.Account
	6,  // 91: google.analytics.admin.v1beta.AnalyticsAdminService.ProvisionAccountTicket:output_type -> google.analytics.admin.v1beta.ProvisionAccountTicketResponse
	24, // 92: google.analytics.admin.v1beta.AnalyticsAdminService.ListAccountSummaries:output_type -> google.analytics.admin.v1beta.ListAccountSummariesResponse
	62, // 93: google.analytics.admin.v1beta.AnalyticsAdminService.GetProperty:output_type -> google.analytics.admin.v1beta.Property
	9,  // 94: google.analytics.admin.v1beta.AnalyticsAdminService.ListProperties:output_type -> google.analytics.admin.v1beta.ListPropertiesResponse
	62, // 95: google.analytics.admin.v1beta.AnalyticsAdminService.CreateProperty:output_type -> google.analytics.admin.v1beta.Property
	62, // 96: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteProperty:output_type -> google.analytics.admin.v1beta.Property
	62, // 97: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateProperty:output_type -> google.analytics.admin.v1beta.Property
	63, // 98: google.analytics.admin.v1beta.AnalyticsAdminService.CreateFirebaseLink:output_type -> google.analytics.admin.v1beta.FirebaseLink
	76, // 99: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteFirebaseLink:output_type -> google.protobuf.Empty
	16, // 100: google.analytics.admin.v1beta.AnalyticsAdminService.ListFirebaseLinks:output_type -> google.analytics.admin.v1beta.ListFirebaseLinksResponse
	64, // 101: google.analytics.admin.v1beta.AnalyticsAdminService.CreateGoogleAdsLink:output_type -> google.analytics.admin.v1beta.GoogleAdsLink
	64, // 102: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateGoogleAdsLink:output_type -> google.analytics.admin.v1beta.GoogleAdsLink
	76, // 103: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteGoogleAdsLink:output_type -> google.protobuf.Empty
	21, // 104: google.analytics.admin.v1beta.AnalyticsAdminService.ListGoogleAdsLinks:output_type -> google.analytics.admin.v1beta.ListGoogleAdsLinksResponse
	77, // 105: google.analytics.admin.v1beta.AnalyticsAdminService.GetDataSharingSettings:output_type -> google.analytics.admin.v1beta.DataSharingSettings
	70, // 106: google.analytics.admin.v1beta.AnalyticsAdminService.GetMeasurementProtocolSecret:output_type -> google.analytics.admin.v1beta.MeasurementProtocolSecret
	34, // 107: google.analytics.admin.v1beta.AnalyticsAdminService.ListMeasurementProtocolSecrets:output_type -> google.analytics.admin.v1beta.ListMeasurementProtocolSecretsResponse
	70, // 108: google.analytics.admin.v1beta.AnalyticsAdminService.CreateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1beta.MeasurementProtocolSecret
	76, // 109: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteMeasurementProtocolSecret:output_type -> google.protobuf.Empty
	70, // 110: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateMeasurementProtocolSecret:output_type -> google.analytics.admin.v1beta.MeasurementProtocolSecret
	26, // 111: google.analytics.admin.v1beta.AnalyticsAdminService.AcknowledgeUserDataCollection:output_type -> google.analytics.admin.v1beta.AcknowledgeUserDataCollectionResponse
	28, // 112: google.analytics.admin.v1beta.AnalyticsAdminService.SearchChangeHistoryEvents:output_type -> google.analytics.admin.v1beta.SearchChangeHistoryEventsResponse
	71, // 113: google.analytics.admin.v1beta.AnalyticsAdminService.CreateConversionEvent:output_type -> google.analytics.admin.v1beta.ConversionEvent
	71, // 114: google.analytics.admin.v1beta.AnalyticsAdminService.GetConversionEvent:output_type -> google.analytics.admin.v1beta.ConversionEvent
	76, // 115: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteConversionEvent:output_type -> google.protobuf.Empty
	39, // 116: google.analytics.admin.v1beta.AnalyticsAdminService.ListConversionEvents:output_type -> google.analytics.admin.v1beta.ListConversionEventsResponse
	72, // 117: google.analytics.admin.v1beta.AnalyticsAdminService.CreateCustomDimension:output_type -> google.analytics.admin.v1beta.CustomDimension
	72, // 118: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateCustomDimension:output_type -> google.analytics.admin.v1beta.CustomDimension
	43, // 119: google.analytics.admin.v1beta.AnalyticsAdminService.ListCustomDimensions:output_type -> google.analytics.admin.v1beta.ListCustomDimensionsResponse
	76, // 120: google.analytics.admin.v1beta.AnalyticsAdminService.ArchiveCustomDimension:output_type -> google.protobuf.Empty
	72, // 121: google.analytics.admin.v1beta.AnalyticsAdminService.GetCustomDimension:output_type -> google.analytics.admin.v1beta.CustomDimension
	73, // 122: google.analytics.admin.v1beta.AnalyticsAdminService.CreateCustomMetric:output_type -> google.analytics.admin.v1beta.CustomMetric
	73, // 123: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateCustomMetric:output_type -> google.analytics.admin.v1beta.CustomMetric
	49, // 124: google.analytics.admin.v1beta.AnalyticsAdminService.ListCustomMetrics:output_type -> google.analytics.admin.v1beta.ListCustomMetricsResponse
	76, // 125: google.analytics.admin.v1beta.AnalyticsAdminService.ArchiveCustomMetric:output_type -> google.protobuf.Empty
	73, // 126: google.analytics.admin.v1beta.AnalyticsAdminService.GetCustomMetric:output_type -> google.analytics.admin.v1beta.CustomMetric
	74, // 127: google.analytics.admin.v1beta.AnalyticsAdminService.GetDataRetentionSettings:output_type -> google.analytics.admin.v1beta.DataRetentionSettings
	74, // 128: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateDataRetentionSettings:output_type -> google.analytics.admin.v1beta.DataRetentionSettings
	75, // 129: google.analytics.admin.v1beta.AnalyticsAdminService.CreateDataStream:output_type -> google.analytics.admin.v1beta.DataStream
	76, // 130: google.analytics.admin.v1beta.AnalyticsAdminService.DeleteDataStream:output_type -> google.protobuf.Empty
	75, // 131: google.analytics.admin.v1beta.AnalyticsAdminService.UpdateDataStream:output_type -> google.analytics.admin.v1beta.DataStream
	58, // 132: google.analytics.admin.v1beta.AnalyticsAdminService.ListDataStreams:output_type -> google.analytics.admin.v1beta.ListDataStreamsResponse
	75, // 133: google.analytics.admin.v1beta.AnalyticsAdminService.GetDataStream:output_type -> google.analytics.admin.v1beta.DataStream
	87, // [87:134] is the sub-list for method output_type
	40, // [40:87] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1beta_analytics_admin_proto_init() }
func file_google_analytics_admin_v1beta_analytics_admin_proto_init() {
	if File_google_analytics_admin_v1beta_analytics_admin_proto != nil {
		return
	}
	file_google_analytics_admin_v1beta_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionAccountTicketResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPropertiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePropertyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFirebaseLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFirebaseLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGoogleAdsLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGoogleAdsLinksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataSharingSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountSummariesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcknowledgeUserDataCollectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AcknowledgeUserDataCollectionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchChangeHistoryEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMeasurementProtocolSecretRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMeasurementProtocolSecretsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConversionEventRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConversionEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomDimensionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomDimensionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCustomMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCustomMetricRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataRetentionSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1beta_analytics_admin_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   60,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_analytics_admin_v1beta_analytics_admin_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1beta_analytics_admin_proto_depIdxs,
		MessageInfos:      file_google_analytics_admin_v1beta_analytics_admin_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1beta_analytics_admin_proto = out.File
	file_google_analytics_admin_v1beta_analytics_admin_proto_rawDesc = nil
	file_google_analytics_admin_v1beta_analytics_admin_proto_goTypes = nil
	file_google_analytics_admin_v1beta_analytics_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyticsAdminServiceClient is the client API for AnalyticsAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyticsAdminServiceClient interface {
	// Lookup for a single Account.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an GA4 Property.
	DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Updates a property.
	UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or via this API) before MeasurementProtocolSecret resources may be created.
	AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error)
	// Creates a CustomDimension.
	CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
}

type analyticsAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsAdminServiceClient(cc grpc.ClientConnInterface) AnalyticsAdminServiceClient {
	return &analyticsAdminServiceClient{cc}
}

func (c *analyticsAdminServiceClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error) {
	out := new(ProvisionAccountTicketResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ProvisionAccountTicket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error) {
	out := new(ListAccountSummariesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListAccountSummaries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error) {
	out := new(ListPropertiesResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListProperties", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateProperty", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteFirebaseLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error) {
	out := new(ListFirebaseLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListFirebaseLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteGoogleAdsLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error) {
	out := new(ListGoogleAdsLinksResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListGoogleAdsLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error) {
	out := new(DataSharingSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetDataSharingSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error) {
	out := new(ListMeasurementProtocolSecretsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListMeasurementProtocolSecrets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateMeasurementProtocolSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error) {
	out := new(AcknowledgeUserDataCollectionResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/AcknowledgeUserDataCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error) {
	out := new(SearchChangeHistoryEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/SearchChangeHistoryEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteConversionEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error) {
	out := new(ListConversionEventsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListConversionEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error) {
	out := new(ListCustomDimensionsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListCustomDimensions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ArchiveCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetCustomDimension", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error) {
	out := new(ListCustomMetricsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListCustomMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ArchiveCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetCustomMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateDataRetentionSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error) {
	out := new(ListDataStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/ListDataStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, "/google.analytics.admin.v1beta.AnalyticsAdminService/GetDataStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsAdminServiceServer is the server API for AnalyticsAdminService service.
type AnalyticsAdminServiceServer interface {
	// Lookup for a single Account.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA4 properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// UserLinks) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error)
	// Lookup for a single "GA4" Property.
	GetProperty(context.Context, *GetPropertyRequest) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Only "GA4" properties will be returned.
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error)
	// Creates an "GA4" property with the specified location and attributes.
	CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, UserLinks)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found, or is not an GA4 Property.
	DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error)
	// Updates a property.
	UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error)
	// Lookup for a single "GA4" MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or via this API) before MeasurementProtocolSecret resources may be created.
	AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error)
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error)
	// Retrieve a single conversion event.
	GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error)
	// Deletes a conversion event in a property.
	DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error)
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error)
	// Creates a CustomDimension.
	CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error)
}

// UnimplementedAnalyticsAdminServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyticsAdminServiceServer struct {
}

func (*UnimplementedAnalyticsAdminServiceServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccount not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionAccountTicket not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountSummaries not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetProperty(context.Context, *GetPropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProperties not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProperty not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirebaseLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirebaseLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleAdsLink not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleAdsLinks not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataSharingSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMeasurementProtocolSecrets not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMeasurementProtocolSecret not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeUserDataCollection not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchChangeHistoryEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionEvent not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionEvents not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomDimensions not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomDimension not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomMetrics not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomMetric not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataRetentionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataRetentionSettings not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataStream not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataStreams not implemented")
}
func (*UnimplementedAnalyticsAdminServiceServer) GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataStream not implemented")
}

func RegisterAnalyticsAdminServiceServer(s *grpc.Server, srv AnalyticsAdminServiceServer) {
	s.RegisterService(&_AnalyticsAdminService_serviceDesc, srv)
}

func _AnalyticsAdminService_GetAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, req.(*GetAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, req.(*ListAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, req.(*DeleteAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, req.(*UpdateAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ProvisionAccountTicket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionAccountTicketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ProvisionAccountTicket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, req.(*ProvisionAccountTicketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccountSummaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountSummariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListAccountSummaries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, req.(*ListAccountSummariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, req.(*GetPropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, req.(*ListPropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, req.(*CreatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, req.(*DeletePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateProperty",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, req.(*UpdatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, req.(*CreateFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteFirebaseLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, req.(*DeleteFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListFirebaseLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirebaseLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListFirebaseLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, req.(*ListFirebaseLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, req.(*CreateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, req.(*UpdateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteGoogleAdsLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, req.(*DeleteGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListGoogleAdsLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoogleAdsLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListGoogleAdsLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, req.(*ListGoogleAdsLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataSharingSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSharingSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetDataSharingSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, req.(*GetDataSharingSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, req.(*GetMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMeasurementProtocolSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListMeasurementProtocolSecrets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, req.(*ListMeasurementProtocolSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, req.(*CreateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, req.(*DeleteMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateMeasurementProtocolSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, req.(*UpdateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_AcknowledgeUserDataCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeUserDataCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).AcknowledgeUserDataCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/AcknowledgeUserDataCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).AcknowledgeUserDataCollection(ctx, req.(*AcknowledgeUserDataCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_SearchChangeHistoryEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchChangeHistoryEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/SearchChangeHistoryEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, req.(*SearchChangeHistoryEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, req.(*CreateConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, req.(*GetConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteConversionEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, req.(*DeleteConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListConversionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListConversionEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, req.(*ListConversionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, req.(*CreateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, req.(*UpdateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomDimensions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomDimensionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListCustomDimensions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, req.(*ListCustomDimensionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ArchiveCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, req.(*ArchiveCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetCustomDimension",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, req.(*GetCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, req.(*CreateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, req.(*UpdateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListCustomMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, req.(*ListCustomMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ArchiveCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, req.(*ArchiveCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetCustomMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, req.(*GetCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetDataRetentionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, req.(*GetDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateDataRetentionSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, req.(*UpdateDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/CreateDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDataStream(ctx, req.(*CreateDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/DeleteDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDataStream(ctx, req.(*DeleteDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/UpdateDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataStream(ctx, req.(*UpdateDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/ListDataStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDataStreams(ctx, req.(*ListDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.analytics.admin.v1beta.AnalyticsAdminService/GetDataStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataStream(ctx, req.(*GetDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnalyticsAdminService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.admin.v1beta.AnalyticsAdminService",
	HandlerType: (*AnalyticsAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccount",
			Handler:    _AnalyticsAdminService_GetAccount_Handler,
		},
		{
			MethodName: "ListAccounts",
			Handler:    _AnalyticsAdminService_ListAccounts_Handler,
		},
		{
			MethodName: "DeleteAccount",
			Handler:    _AnalyticsAdminService_DeleteAccount_Handler,
		},
		{
			MethodName: "UpdateAccount",
			Handler:    _AnalyticsAdminService_UpdateAccount_Handler,
		},
		{
			MethodName: "ProvisionAccountTicket",
			Handler:    _AnalyticsAdminService_ProvisionAccountTicket_Handler,
		},
		{
			MethodName: "ListAccountSummaries",
			Handler:    _AnalyticsAdminService_ListAccountSummaries_Handler,
		},
		{
			MethodName: "GetProperty",
			Handler:    _AnalyticsAdminService_GetProperty_Handler,
		},
		{
			MethodName: "ListProperties",
			Handler:    _AnalyticsAdminService_ListProperties_Handler,
		},
		{
			MethodName: "CreateProperty",
			Handler:    _AnalyticsAdminService_CreateProperty_Handler,
		},
		{
			MethodName: "DeleteProperty",
			Handler:    _AnalyticsAdminService_DeleteProperty_Handler,
		},
		{
			MethodName: "UpdateProperty",
			Handler:    _AnalyticsAdminService_UpdateProperty_Handler,
		},
		{
			MethodName: "CreateFirebaseLink",
			Handler:    _AnalyticsAdminService_CreateFirebaseLink_Handler,
		},
		{
			MethodName: "DeleteFirebaseLink",
			Handler:    _AnalyticsAdminService_DeleteFirebaseLink_Handler,
		},
		{
			MethodName: "ListFirebaseLinks",
			Handler:    _AnalyticsAdminService_ListFirebaseLinks_Handler,
		},
		{
			MethodName: "CreateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_CreateGoogleAdsLink_Handler,
		},
		{
			MethodName: "UpdateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_UpdateGoogleAdsLink_Handler,
		},
		{
			MethodName: "DeleteGoogleAdsLink",
			Handler:    _AnalyticsAdminService_DeleteGoogleAdsLink_Handler,
		},
		{
			MethodName: "ListGoogleAdsLinks",
			Handler:    _AnalyticsAdminService_ListGoogleAdsLinks_Handler,
		},
		{
			MethodName: "GetDataSharingSettings",
			Handler:    _AnalyticsAdminService_GetDataSharingSettings_Handler,
		},
		{
			MethodName: "GetMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "ListMeasurementProtocolSecrets",
			Handler:    _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler,
		},
		{
			MethodName: "CreateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "DeleteMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "UpdateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "AcknowledgeUserDataCollection",
			Handler:    _AnalyticsAdminService_AcknowledgeUserDataCollection_Handler,
		},
		{
			MethodName: "SearchChangeHistoryEvents",
			Handler:    _AnalyticsAdminService_SearchChangeHistoryEvents_Handler,
		},
		{
			MethodName: "CreateConversionEvent",
			Handler:    _AnalyticsAdminService_CreateConversionEvent_Handler,
		},
		{
			MethodName: "GetConversionEvent",
			Handler:    _AnalyticsAdminService_GetConversionEvent_Handler,
		},
		{
			MethodName: "DeleteConversionEvent",
			Handler:    _AnalyticsAdminService_DeleteConversionEvent_Handler,
		},
		{
			MethodName: "ListConversionEvents",
			Handler:    _AnalyticsAdminService_ListConversionEvents_Handler,
		},
		{
			MethodName: "CreateCustomDimension",
			Handler:    _AnalyticsAdminService_CreateCustomDimension_Handler,
		},
		{
			MethodName: "UpdateCustomDimension",
			Handler:    _AnalyticsAdminService_UpdateCustomDimension_Handler,
		},
		{
			MethodName: "ListCustomDimensions",
			Handler:    _AnalyticsAdminService_ListCustomDimensions_Handler,
		},
		{
			MethodName: "ArchiveCustomDimension",
			Handler:    _AnalyticsAdminService_ArchiveCustomDimension_Handler,
		},
		{
			MethodName: "GetCustomDimension",
			Handler:    _AnalyticsAdminService_GetCustomDimension_Handler,
		},
		{
			MethodName: "CreateCustomMetric",
			Handler:    _AnalyticsAdminService_CreateCustomMetric_Handler,
		},
		{
			MethodName: "UpdateCustomMetric",
			Handler:    _AnalyticsAdminService_UpdateCustomMetric_Handler,
		},
		{
			MethodName: "ListCustomMetrics",
			Handler:    _AnalyticsAdminService_ListCustomMetrics_Handler,
		},
		{
			MethodName: "ArchiveCustomMetric",
			Handler:    _AnalyticsAdminService_ArchiveCustomMetric_Handler,
		},
		{
			MethodName: "GetCustomMetric",
			Handler:    _AnalyticsAdminService_GetCustomMetric_Handler,
		},
		{
			MethodName: "GetDataRetentionSettings",
			Handler:    _AnalyticsAdminService_GetDataRetentionSettings_Handler,
		},
		{
			MethodName: "UpdateDataRetentionSettings",
			Handler:    _AnalyticsAdminService_UpdateDataRetentionSettings_Handler,
		},
		{
			MethodName: "CreateDataStream",
			Handler:    _AnalyticsAdminService_CreateDataStream_Handler,
		},
		{
			MethodName: "DeleteDataStream",
			Handler:    _AnalyticsAdminService_DeleteDataStream_Handler,
		},
		{
			MethodName: "UpdateDataStream",
			Handler:    _AnalyticsAdminService_UpdateDataStream_Handler,
		},
		{
			MethodName: "ListDataStreams",
			Handler:    _AnalyticsAdminService_ListDataStreams_Handler,
		},
		{
			MethodName: "GetDataStream",
			Handler:    _AnalyticsAdminService_GetDataStream_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/admin/v1beta/analytics_admin.proto",
}
