// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

package clusterpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudRedisCluster_ListClusters_FullMethodName                   = "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters"
	CloudRedisCluster_GetCluster_FullMethodName                     = "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster"
	CloudRedisCluster_UpdateCluster_FullMethodName                  = "/google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster"
	CloudRedisCluster_DeleteCluster_FullMethodName                  = "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster"
	CloudRedisCluster_CreateCluster_FullMethodName                  = "/google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster"
	CloudRedisCluster_GetClusterCertificateAuthority_FullMethodName = "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetClusterCertificateAuthority"
	CloudRedisCluster_RescheduleClusterMaintenance_FullMethodName   = "/google.cloud.redis.cluster.v1.CloudRedisCluster/RescheduleClusterMaintenance"
	CloudRedisCluster_ListBackupCollections_FullMethodName          = "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackupCollections"
	CloudRedisCluster_GetBackupCollection_FullMethodName            = "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackupCollection"
	CloudRedisCluster_ListBackups_FullMethodName                    = "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackups"
	CloudRedisCluster_GetBackup_FullMethodName                      = "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackup"
	CloudRedisCluster_DeleteBackup_FullMethodName                   = "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteBackup"
	CloudRedisCluster_ExportBackup_FullMethodName                   = "/google.cloud.redis.cluster.v1.CloudRedisCluster/ExportBackup"
	CloudRedisCluster_BackupCluster_FullMethodName                  = "/google.cloud.redis.cluster.v1.CloudRedisCluster/BackupCluster"
)

// CloudRedisClusterClient is the client API for CloudRedisCluster service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudRedisClusterClient interface {
	// Lists all Redis clusters owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific Redis cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Updates the metadata and configuration of a specific Redis cluster.
	//
	// Completed longrunning.Operation will contain the new cluster object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a specific Redis cluster. Cluster stops serving and data is
	// deleted.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Redis cluster based on the specified properties.
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// cluster will be fully functional. The completed longrunning.Operation will
	// contain the new cluster object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of certificate authority information for Redis cluster.
	GetClusterCertificateAuthority(ctx context.Context, in *GetClusterCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error)
	// Reschedules upcoming maintenance event.
	RescheduleClusterMaintenance(ctx context.Context, in *RescheduleClusterMaintenanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all backup collections owned by a consumer project in either the
	// specified location (region) or all locations.
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListBackupCollections(ctx context.Context, in *ListBackupCollectionsRequest, opts ...grpc.CallOption) (*ListBackupCollectionsResponse, error)
	// Get a backup collection.
	GetBackupCollection(ctx context.Context, in *GetBackupCollectionRequest, opts ...grpc.CallOption) (*BackupCollection, error)
	// Lists all backups owned by a backup collection.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Deletes a specific backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a specific backup to a customer target Cloud Storage URI.
	ExportBackup(ctx context.Context, in *ExportBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Backup Redis Cluster.
	// If this is the first time a backup is being created, a backup collection
	// will be created at the backend, and this backup belongs to this collection.
	// Both collection and backup will have a resource name. Backup will be
	// executed for each shard. A replica (primary if nonHA) will be selected to
	// perform the execution. Backup call will be rejected if there is an ongoing
	// backup or update operation. Be aware that during preview, if the cluster's
	// internal software version is too old, critical update will be performed
	// before actual backup. Once the internal software version is updated to the
	// minimum version required by the backup feature, subsequent backups will not
	// require critical update. After preview, there will be no critical update
	// needed for backup.
	BackupCluster(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type cloudRedisClusterClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudRedisClusterClient(cc grpc.ClientConnInterface) CloudRedisClusterClient {
	return &cloudRedisClusterClient{cc}
}

func (c *cloudRedisClusterClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, CloudRedisCluster_ListClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, CloudRedisCluster_GetCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_UpdateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_DeleteCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_CreateCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetClusterCertificateAuthority(ctx context.Context, in *GetClusterCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error) {
	out := new(CertificateAuthority)
	err := c.cc.Invoke(ctx, CloudRedisCluster_GetClusterCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) RescheduleClusterMaintenance(ctx context.Context, in *RescheduleClusterMaintenanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_RescheduleClusterMaintenance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) ListBackupCollections(ctx context.Context, in *ListBackupCollectionsRequest, opts ...grpc.CallOption) (*ListBackupCollectionsResponse, error) {
	out := new(ListBackupCollectionsResponse)
	err := c.cc.Invoke(ctx, CloudRedisCluster_ListBackupCollections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetBackupCollection(ctx context.Context, in *GetBackupCollectionRequest, opts ...grpc.CallOption) (*BackupCollection, error) {
	out := new(BackupCollection)
	err := c.cc.Invoke(ctx, CloudRedisCluster_GetBackupCollection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, CloudRedisCluster_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, CloudRedisCluster_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) ExportBackup(ctx context.Context, in *ExportBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_ExportBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) BackupCluster(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudRedisCluster_BackupCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisClusterServer is the server API for CloudRedisCluster service.
// All implementations should embed UnimplementedCloudRedisClusterServer
// for forward compatibility
type CloudRedisClusterServer interface {
	// Lists all Redis clusters owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific Redis cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Updates the metadata and configuration of a specific Redis cluster.
	//
	// Completed longrunning.Operation will contain the new cluster object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a specific Redis cluster. Cluster stops serving and data is
	// deleted.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Creates a Redis cluster based on the specified properties.
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// cluster will be fully functional. The completed longrunning.Operation will
	// contain the new cluster object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Gets the details of certificate authority information for Redis cluster.
	GetClusterCertificateAuthority(context.Context, *GetClusterCertificateAuthorityRequest) (*CertificateAuthority, error)
	// Reschedules upcoming maintenance event.
	RescheduleClusterMaintenance(context.Context, *RescheduleClusterMaintenanceRequest) (*longrunningpb.Operation, error)
	// Lists all backup collections owned by a consumer project in either the
	// specified location (region) or all locations.
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListBackupCollections(context.Context, *ListBackupCollectionsRequest) (*ListBackupCollectionsResponse, error)
	// Get a backup collection.
	GetBackupCollection(context.Context, *GetBackupCollectionRequest) (*BackupCollection, error)
	// Lists all backups owned by a backup collection.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Deletes a specific backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Exports a specific backup to a customer target Cloud Storage URI.
	ExportBackup(context.Context, *ExportBackupRequest) (*longrunningpb.Operation, error)
	// Backup Redis Cluster.
	// If this is the first time a backup is being created, a backup collection
	// will be created at the backend, and this backup belongs to this collection.
	// Both collection and backup will have a resource name. Backup will be
	// executed for each shard. A replica (primary if nonHA) will be selected to
	// perform the execution. Backup call will be rejected if there is an ongoing
	// backup or update operation. Be aware that during preview, if the cluster's
	// internal software version is too old, critical update will be performed
	// before actual backup. Once the internal software version is updated to the
	// minimum version required by the backup feature, subsequent backups will not
	// require critical update. After preview, there will be no critical update
	// needed for backup.
	BackupCluster(context.Context, *BackupClusterRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCloudRedisClusterServer should be embedded to have forward compatible implementations.
type UnimplementedCloudRedisClusterServer struct {
}

func (UnimplementedCloudRedisClusterServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (UnimplementedCloudRedisClusterServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (UnimplementedCloudRedisClusterServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (UnimplementedCloudRedisClusterServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (UnimplementedCloudRedisClusterServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (UnimplementedCloudRedisClusterServer) GetClusterCertificateAuthority(context.Context, *GetClusterCertificateAuthorityRequest) (*CertificateAuthority, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterCertificateAuthority not implemented")
}
func (UnimplementedCloudRedisClusterServer) RescheduleClusterMaintenance(context.Context, *RescheduleClusterMaintenanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RescheduleClusterMaintenance not implemented")
}
func (UnimplementedCloudRedisClusterServer) ListBackupCollections(context.Context, *ListBackupCollectionsRequest) (*ListBackupCollectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupCollections not implemented")
}
func (UnimplementedCloudRedisClusterServer) GetBackupCollection(context.Context, *GetBackupCollectionRequest) (*BackupCollection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupCollection not implemented")
}
func (UnimplementedCloudRedisClusterServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedCloudRedisClusterServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedCloudRedisClusterServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedCloudRedisClusterServer) ExportBackup(context.Context, *ExportBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportBackup not implemented")
}
func (UnimplementedCloudRedisClusterServer) BackupCluster(context.Context, *BackupClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BackupCluster not implemented")
}

// UnsafeCloudRedisClusterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudRedisClusterServer will
// result in compilation errors.
type UnsafeCloudRedisClusterServer interface {
	mustEmbedUnimplementedCloudRedisClusterServer()
}

func RegisterCloudRedisClusterServer(s grpc.ServiceRegistrar, srv CloudRedisClusterServer) {
	s.RegisterService(&CloudRedisCluster_ServiceDesc, srv)
}

func _CloudRedisCluster_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_ListClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_GetCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_UpdateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_DeleteCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_CreateCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetClusterCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetClusterCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_GetClusterCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetClusterCertificateAuthority(ctx, req.(*GetClusterCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_RescheduleClusterMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RescheduleClusterMaintenanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).RescheduleClusterMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_RescheduleClusterMaintenance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).RescheduleClusterMaintenance(ctx, req.(*RescheduleClusterMaintenanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_ListBackupCollections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupCollectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListBackupCollections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_ListBackupCollections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListBackupCollections(ctx, req.(*ListBackupCollectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetBackupCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetBackupCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_GetBackupCollection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetBackupCollection(ctx, req.(*GetBackupCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_ExportBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ExportBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_ExportBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ExportBackup(ctx, req.(*ExportBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_BackupCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).BackupCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudRedisCluster_BackupCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).BackupCluster(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudRedisCluster_ServiceDesc is the grpc.ServiceDesc for CloudRedisCluster service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudRedisCluster_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.cluster.v1.CloudRedisCluster",
	HandlerType: (*CloudRedisClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _CloudRedisCluster_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _CloudRedisCluster_GetCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _CloudRedisCluster_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _CloudRedisCluster_DeleteCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _CloudRedisCluster_CreateCluster_Handler,
		},
		{
			MethodName: "GetClusterCertificateAuthority",
			Handler:    _CloudRedisCluster_GetClusterCertificateAuthority_Handler,
		},
		{
			MethodName: "RescheduleClusterMaintenance",
			Handler:    _CloudRedisCluster_RescheduleClusterMaintenance_Handler,
		},
		{
			MethodName: "ListBackupCollections",
			Handler:    _CloudRedisCluster_ListBackupCollections_Handler,
		},
		{
			MethodName: "GetBackupCollection",
			Handler:    _CloudRedisCluster_GetBackupCollection_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _CloudRedisCluster_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _CloudRedisCluster_GetBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _CloudRedisCluster_DeleteBackup_Handler,
		},
		{
			MethodName: "ExportBackup",
			Handler:    _CloudRedisCluster_ExportBackup_Handler,
		},
		{
			MethodName: "BackupCluster",
			Handler:    _CloudRedisCluster_BackupCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/cluster/v1/cloud_redis_cluster.proto",
}
