// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/notebooks/v1/managed_service.proto

package notebookspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ManagedNotebookService_ListRuntimes_FullMethodName                = "/google.cloud.notebooks.v1.ManagedNotebookService/ListRuntimes"
	ManagedNotebookService_GetRuntime_FullMethodName                  = "/google.cloud.notebooks.v1.ManagedNotebookService/GetRuntime"
	ManagedNotebookService_CreateRuntime_FullMethodName               = "/google.cloud.notebooks.v1.ManagedNotebookService/CreateRuntime"
	ManagedNotebookService_UpdateRuntime_FullMethodName               = "/google.cloud.notebooks.v1.ManagedNotebookService/UpdateRuntime"
	ManagedNotebookService_DeleteRuntime_FullMethodName               = "/google.cloud.notebooks.v1.ManagedNotebookService/DeleteRuntime"
	ManagedNotebookService_StartRuntime_FullMethodName                = "/google.cloud.notebooks.v1.ManagedNotebookService/StartRuntime"
	ManagedNotebookService_StopRuntime_FullMethodName                 = "/google.cloud.notebooks.v1.ManagedNotebookService/StopRuntime"
	ManagedNotebookService_SwitchRuntime_FullMethodName               = "/google.cloud.notebooks.v1.ManagedNotebookService/SwitchRuntime"
	ManagedNotebookService_ResetRuntime_FullMethodName                = "/google.cloud.notebooks.v1.ManagedNotebookService/ResetRuntime"
	ManagedNotebookService_UpgradeRuntime_FullMethodName              = "/google.cloud.notebooks.v1.ManagedNotebookService/UpgradeRuntime"
	ManagedNotebookService_ReportRuntimeEvent_FullMethodName          = "/google.cloud.notebooks.v1.ManagedNotebookService/ReportRuntimeEvent"
	ManagedNotebookService_RefreshRuntimeTokenInternal_FullMethodName = "/google.cloud.notebooks.v1.ManagedNotebookService/RefreshRuntimeTokenInternal"
	ManagedNotebookService_DiagnoseRuntime_FullMethodName             = "/google.cloud.notebooks.v1.ManagedNotebookService/DiagnoseRuntime"
)

// ManagedNotebookServiceClient is the client API for ManagedNotebookService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ManagedNotebookServiceClient interface {
	// Lists Runtimes in a given project and location.
	ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error)
	// Gets details of a single Runtime. The location must be a regional endpoint
	// rather than zonal.
	GetRuntime(ctx context.Context, in *GetRuntimeRequest, opts ...grpc.CallOption) (*Runtime, error)
	// Creates a new Runtime in a given project and location.
	CreateRuntime(ctx context.Context, in *CreateRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update Notebook Runtime configuration.
	UpdateRuntime(ctx context.Context, in *UpdateRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Runtime.
	DeleteRuntime(ctx context.Context, in *DeleteRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a Managed Notebook Runtime.
	// Perform "Start" on GPU instances; "Resume" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StartRuntime(ctx context.Context, in *StartRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a Managed Notebook Runtime.
	// Perform "Stop" on GPU instances; "Suspend" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StopRuntime(ctx context.Context, in *StopRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Switch a Managed Notebook Runtime.
	SwitchRuntime(ctx context.Context, in *SwitchRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resets a Managed Notebook Runtime.
	ResetRuntime(ctx context.Context, in *ResetRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upgrades a Managed Notebook Runtime to the latest version.
	UpgradeRuntime(ctx context.Context, in *UpgradeRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Report and process a runtime event.
	ReportRuntimeEvent(ctx context.Context, in *ReportRuntimeEventRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an access token for the consumer service account that the customer
	// attached to the runtime. Only accessible from the tenant instance.
	RefreshRuntimeTokenInternal(ctx context.Context, in *RefreshRuntimeTokenInternalRequest, opts ...grpc.CallOption) (*RefreshRuntimeTokenInternalResponse, error)
	// Creates a Diagnostic File and runs Diagnostic Tool given a Runtime.
	DiagnoseRuntime(ctx context.Context, in *DiagnoseRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type managedNotebookServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedNotebookServiceClient(cc grpc.ClientConnInterface) ManagedNotebookServiceClient {
	return &managedNotebookServiceClient{cc}
}

func (c *managedNotebookServiceClient) ListRuntimes(ctx context.Context, in *ListRuntimesRequest, opts ...grpc.CallOption) (*ListRuntimesResponse, error) {
	out := new(ListRuntimesResponse)
	err := c.cc.Invoke(ctx, ManagedNotebookService_ListRuntimes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) GetRuntime(ctx context.Context, in *GetRuntimeRequest, opts ...grpc.CallOption) (*Runtime, error) {
	out := new(Runtime)
	err := c.cc.Invoke(ctx, ManagedNotebookService_GetRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) CreateRuntime(ctx context.Context, in *CreateRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_CreateRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) UpdateRuntime(ctx context.Context, in *UpdateRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_UpdateRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) DeleteRuntime(ctx context.Context, in *DeleteRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_DeleteRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) StartRuntime(ctx context.Context, in *StartRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_StartRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) StopRuntime(ctx context.Context, in *StopRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_StopRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) SwitchRuntime(ctx context.Context, in *SwitchRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_SwitchRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) ResetRuntime(ctx context.Context, in *ResetRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_ResetRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) UpgradeRuntime(ctx context.Context, in *UpgradeRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_UpgradeRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) ReportRuntimeEvent(ctx context.Context, in *ReportRuntimeEventRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_ReportRuntimeEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) RefreshRuntimeTokenInternal(ctx context.Context, in *RefreshRuntimeTokenInternalRequest, opts ...grpc.CallOption) (*RefreshRuntimeTokenInternalResponse, error) {
	out := new(RefreshRuntimeTokenInternalResponse)
	err := c.cc.Invoke(ctx, ManagedNotebookService_RefreshRuntimeTokenInternal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedNotebookServiceClient) DiagnoseRuntime(ctx context.Context, in *DiagnoseRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ManagedNotebookService_DiagnoseRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedNotebookServiceServer is the server API for ManagedNotebookService service.
// All implementations should embed UnimplementedManagedNotebookServiceServer
// for forward compatibility
type ManagedNotebookServiceServer interface {
	// Lists Runtimes in a given project and location.
	ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error)
	// Gets details of a single Runtime. The location must be a regional endpoint
	// rather than zonal.
	GetRuntime(context.Context, *GetRuntimeRequest) (*Runtime, error)
	// Creates a new Runtime in a given project and location.
	CreateRuntime(context.Context, *CreateRuntimeRequest) (*longrunningpb.Operation, error)
	// Update Notebook Runtime configuration.
	UpdateRuntime(context.Context, *UpdateRuntimeRequest) (*longrunningpb.Operation, error)
	// Deletes a single Runtime.
	DeleteRuntime(context.Context, *DeleteRuntimeRequest) (*longrunningpb.Operation, error)
	// Starts a Managed Notebook Runtime.
	// Perform "Start" on GPU instances; "Resume" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StartRuntime(context.Context, *StartRuntimeRequest) (*longrunningpb.Operation, error)
	// Stops a Managed Notebook Runtime.
	// Perform "Stop" on GPU instances; "Suspend" on CPU instances
	// See:
	// https://cloud.google.com/compute/docs/instances/stop-start-instance
	// https://cloud.google.com/compute/docs/instances/suspend-resume-instance
	StopRuntime(context.Context, *StopRuntimeRequest) (*longrunningpb.Operation, error)
	// Switch a Managed Notebook Runtime.
	SwitchRuntime(context.Context, *SwitchRuntimeRequest) (*longrunningpb.Operation, error)
	// Resets a Managed Notebook Runtime.
	ResetRuntime(context.Context, *ResetRuntimeRequest) (*longrunningpb.Operation, error)
	// Upgrades a Managed Notebook Runtime to the latest version.
	UpgradeRuntime(context.Context, *UpgradeRuntimeRequest) (*longrunningpb.Operation, error)
	// Report and process a runtime event.
	ReportRuntimeEvent(context.Context, *ReportRuntimeEventRequest) (*longrunningpb.Operation, error)
	// Gets an access token for the consumer service account that the customer
	// attached to the runtime. Only accessible from the tenant instance.
	RefreshRuntimeTokenInternal(context.Context, *RefreshRuntimeTokenInternalRequest) (*RefreshRuntimeTokenInternalResponse, error)
	// Creates a Diagnostic File and runs Diagnostic Tool given a Runtime.
	DiagnoseRuntime(context.Context, *DiagnoseRuntimeRequest) (*longrunningpb.Operation, error)
}

// UnimplementedManagedNotebookServiceServer should be embedded to have forward compatible implementations.
type UnimplementedManagedNotebookServiceServer struct {
}

func (UnimplementedManagedNotebookServiceServer) ListRuntimes(context.Context, *ListRuntimesRequest) (*ListRuntimesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuntimes not implemented")
}
func (UnimplementedManagedNotebookServiceServer) GetRuntime(context.Context, *GetRuntimeRequest) (*Runtime, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) CreateRuntime(context.Context, *CreateRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) UpdateRuntime(context.Context, *UpdateRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) DeleteRuntime(context.Context, *DeleteRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) StartRuntime(context.Context, *StartRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) StopRuntime(context.Context, *StopRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) SwitchRuntime(context.Context, *SwitchRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SwitchRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) ResetRuntime(context.Context, *ResetRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) UpgradeRuntime(context.Context, *UpgradeRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeRuntime not implemented")
}
func (UnimplementedManagedNotebookServiceServer) ReportRuntimeEvent(context.Context, *ReportRuntimeEventRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportRuntimeEvent not implemented")
}
func (UnimplementedManagedNotebookServiceServer) RefreshRuntimeTokenInternal(context.Context, *RefreshRuntimeTokenInternalRequest) (*RefreshRuntimeTokenInternalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefreshRuntimeTokenInternal not implemented")
}
func (UnimplementedManagedNotebookServiceServer) DiagnoseRuntime(context.Context, *DiagnoseRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiagnoseRuntime not implemented")
}

// UnsafeManagedNotebookServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ManagedNotebookServiceServer will
// result in compilation errors.
type UnsafeManagedNotebookServiceServer interface {
	mustEmbedUnimplementedManagedNotebookServiceServer()
}

func RegisterManagedNotebookServiceServer(s grpc.ServiceRegistrar, srv ManagedNotebookServiceServer) {
	s.RegisterService(&ManagedNotebookService_ServiceDesc, srv)
}

func _ManagedNotebookService_ListRuntimes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuntimesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).ListRuntimes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_ListRuntimes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).ListRuntimes(ctx, req.(*ListRuntimesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_GetRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).GetRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_GetRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).GetRuntime(ctx, req.(*GetRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_CreateRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).CreateRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_CreateRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).CreateRuntime(ctx, req.(*CreateRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_UpdateRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).UpdateRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_UpdateRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).UpdateRuntime(ctx, req.(*UpdateRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_DeleteRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).DeleteRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_DeleteRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).DeleteRuntime(ctx, req.(*DeleteRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_StartRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).StartRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_StartRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).StartRuntime(ctx, req.(*StartRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_StopRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).StopRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_StopRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).StopRuntime(ctx, req.(*StopRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_SwitchRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SwitchRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).SwitchRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_SwitchRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).SwitchRuntime(ctx, req.(*SwitchRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_ResetRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).ResetRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_ResetRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).ResetRuntime(ctx, req.(*ResetRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_UpgradeRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).UpgradeRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_UpgradeRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).UpgradeRuntime(ctx, req.(*UpgradeRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_ReportRuntimeEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRuntimeEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).ReportRuntimeEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_ReportRuntimeEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).ReportRuntimeEvent(ctx, req.(*ReportRuntimeEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_RefreshRuntimeTokenInternal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefreshRuntimeTokenInternalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).RefreshRuntimeTokenInternal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_RefreshRuntimeTokenInternal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).RefreshRuntimeTokenInternal(ctx, req.(*RefreshRuntimeTokenInternalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedNotebookService_DiagnoseRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedNotebookServiceServer).DiagnoseRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ManagedNotebookService_DiagnoseRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedNotebookServiceServer).DiagnoseRuntime(ctx, req.(*DiagnoseRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ManagedNotebookService_ServiceDesc is the grpc.ServiceDesc for ManagedNotebookService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ManagedNotebookService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.notebooks.v1.ManagedNotebookService",
	HandlerType: (*ManagedNotebookServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRuntimes",
			Handler:    _ManagedNotebookService_ListRuntimes_Handler,
		},
		{
			MethodName: "GetRuntime",
			Handler:    _ManagedNotebookService_GetRuntime_Handler,
		},
		{
			MethodName: "CreateRuntime",
			Handler:    _ManagedNotebookService_CreateRuntime_Handler,
		},
		{
			MethodName: "UpdateRuntime",
			Handler:    _ManagedNotebookService_UpdateRuntime_Handler,
		},
		{
			MethodName: "DeleteRuntime",
			Handler:    _ManagedNotebookService_DeleteRuntime_Handler,
		},
		{
			MethodName: "StartRuntime",
			Handler:    _ManagedNotebookService_StartRuntime_Handler,
		},
		{
			MethodName: "StopRuntime",
			Handler:    _ManagedNotebookService_StopRuntime_Handler,
		},
		{
			MethodName: "SwitchRuntime",
			Handler:    _ManagedNotebookService_SwitchRuntime_Handler,
		},
		{
			MethodName: "ResetRuntime",
			Handler:    _ManagedNotebookService_ResetRuntime_Handler,
		},
		{
			MethodName: "UpgradeRuntime",
			Handler:    _ManagedNotebookService_UpgradeRuntime_Handler,
		},
		{
			MethodName: "ReportRuntimeEvent",
			Handler:    _ManagedNotebookService_ReportRuntimeEvent_Handler,
		},
		{
			MethodName: "RefreshRuntimeTokenInternal",
			Handler:    _ManagedNotebookService_RefreshRuntimeTokenInternal_Handler,
		},
		{
			MethodName: "DiagnoseRuntime",
			Handler:    _ManagedNotebookService_DiagnoseRuntime_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/notebooks/v1/managed_service.proto",
}
