/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.lower;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigWriter;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.type.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public class LowerSignature {
    final Set<ClassSymbol> classes = new LinkedHashSet<ClassSymbol>();

    public Sig.TySig signature(Type ty) {
        switch (ty.tyKind()) {
            case CLASS_TY: {
                return this.classTySig((Type.ClassTy)ty);
            }
            case TY_VAR: {
                return this.tyVarSig((Type.TyVar)ty);
            }
            case ARRAY_TY: {
                return this.arrayTySig((Type.ArrayTy)ty);
            }
            case PRIM_TY: {
                return this.refBaseTy((Type.PrimTy)ty);
            }
            case VOID_TY: {
                return Sig.VOID;
            }
            case WILD_TY: {
                return this.wildTy((Type.WildTy)ty);
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private Sig.BaseTySig refBaseTy(Type.PrimTy t) {
        return new Sig.BaseTySig(t.primkind());
    }

    private Sig.ArrayTySig arrayTySig(Type.ArrayTy t) {
        return new Sig.ArrayTySig(this.signature(t.elementType()));
    }

    private Sig.TyVarSig tyVarSig(Type.TyVar t) {
        return new Sig.TyVarSig(t.sym().name());
    }

    private Sig.ClassTySig classTySig(Type.ClassTy t) {
        this.classes.add(t.sym());
        ImmutableList.Builder classes = ImmutableList.builder();
        UnmodifiableIterator it = t.classes().iterator();
        Type.ClassTy.SimpleClassTy curr = (Type.ClassTy.SimpleClassTy)it.next();
        while (curr.targs().isEmpty() && it.hasNext()) {
            curr = (Type.ClassTy.SimpleClassTy)it.next();
        }
        String pkg = curr.sym().packageName();
        classes.add((Object)new Sig.SimpleClassTySig(curr.sym().simpleName(), this.tyArgSigs(curr)));
        while (it.hasNext()) {
            Type.ClassTy.SimpleClassTy outer = curr;
            curr = (Type.ClassTy.SimpleClassTy)it.next();
            String shortname = curr.sym().binaryName().substring(outer.sym().binaryName().length() + 1);
            classes.add((Object)new Sig.SimpleClassTySig(shortname, this.tyArgSigs(curr)));
        }
        return new Sig.ClassTySig(pkg, (ImmutableList<Sig.SimpleClassTySig>)classes.build());
    }

    private ImmutableList<Sig.TySig> tyArgSigs(Type.ClassTy.SimpleClassTy part) {
        ImmutableList.Builder tyargs = ImmutableList.builder();
        for (Type targ : part.targs()) {
            tyargs.add((Object)this.signature(targ));
        }
        return tyargs.build();
    }

    private Sig.TySig wildTy(Type.WildTy ty) {
        switch (ty.boundKind()) {
            case NONE: {
                return new Sig.WildTyArgSig();
            }
            case UPPER: {
                return new Sig.UpperBoundTySig(this.signature(((Type.WildUpperBoundedTy)ty).bound()));
            }
            case LOWER: {
                return new Sig.LowerBoundTySig(this.signature(((Type.WildLowerBoundedTy)ty).bound()));
            }
        }
        throw new AssertionError((Object)ty.boundKind());
    }

    public @Nullable String methodSignature(Env<ClassSymbol, TypeBoundClass> env, TypeBoundClass.MethodInfo method, ClassSymbol sym) {
        if (!this.needsMethodSig(sym, env, method)) {
            return null;
        }
        ImmutableList<Sig.TyParamSig> typarams = this.tyParamSig((Map<TyVarSymbol, TypeBoundClass.TyVarInfo>)method.tyParams(), env);
        ImmutableList.Builder fparams = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo t : method.parameters()) {
            if (t.synthetic()) continue;
            fparams.add((Object)this.signature(t.type()));
        }
        Sig.TySig ret = this.signature(method.returnType());
        ImmutableList.Builder excn = ImmutableList.builder();
        boolean needsExnSig = false;
        for (Type e : method.exceptions()) {
            if (!this.needsSig(e)) continue;
            needsExnSig = true;
            break;
        }
        if (needsExnSig) {
            for (Type e : method.exceptions()) {
                excn.add((Object)this.signature(e));
            }
        }
        Sig.MethodSig sig = new Sig.MethodSig(typarams, (ImmutableList<Sig.TySig>)fparams.build(), ret, (ImmutableList<Sig.TySig>)excn.build());
        return SigWriter.method(sig);
    }

    private boolean needsMethodSig(ClassSymbol sym, Env<ClassSymbol, TypeBoundClass> env, TypeBoundClass.MethodInfo m) {
        if ((env.getNonNull(sym).access() & 0x4000) == 16384 && m.name().equals("<init>")) {
            return true;
        }
        if (!m.tyParams().isEmpty()) {
            return true;
        }
        if (m.returnType() != null && this.needsSig(m.returnType())) {
            return true;
        }
        for (Object t : m.parameters()) {
            if (((TypeBoundClass.ParamInfo)t).synthetic() || !this.needsSig(((TypeBoundClass.ParamInfo)t).type())) continue;
            return true;
        }
        for (Object t : m.exceptions()) {
            if (!this.needsSig((Type)t)) continue;
            return true;
        }
        return false;
    }

    public @Nullable String classSignature(SourceTypeBoundClass info, Env<ClassSymbol, TypeBoundClass> env) {
        if (!this.classNeedsSig(info)) {
            return null;
        }
        ImmutableList<Sig.TyParamSig> typarams = this.tyParamSig((Map<TyVarSymbol, TypeBoundClass.TyVarInfo>)info.typeParameterTypes(), env);
        Sig.ClassTySig xtnd = this.classTySig((Type.ClassTy)info.superClassType());
        ImmutableList.Builder impl = ImmutableList.builder();
        for (Type i : info.interfaceTypes()) {
            impl.add((Object)this.classTySig((Type.ClassTy)i));
        }
        Sig.ClassSig sig = new Sig.ClassSig(typarams, xtnd, (ImmutableList<Sig.ClassTySig>)impl.build());
        return SigWriter.classSig(sig);
    }

    public @Nullable String fieldSignature(Type type) {
        return this.needsSig(type) ? SigWriter.type(this.signature(type)) : null;
    }

    private boolean classNeedsSig(SourceTypeBoundClass ci) {
        if (!ci.typeParameters().isEmpty()) {
            return true;
        }
        if (ci.superClassType() != null && this.needsSig(ci.superClassType())) {
            return true;
        }
        for (Type i : ci.interfaceTypes()) {
            if (!this.needsSig(i)) continue;
            return true;
        }
        return false;
    }

    private boolean needsSig(Type ty) {
        switch (ty.tyKind()) {
            case PRIM_TY: 
            case VOID_TY: {
                return false;
            }
            case CLASS_TY: {
                for (Type.ClassTy.SimpleClassTy s : ((Type.ClassTy)ty).classes()) {
                    if (s.targs().isEmpty()) continue;
                    return true;
                }
                return false;
            }
            case ARRAY_TY: {
                return this.needsSig(((Type.ArrayTy)ty).elementType());
            }
            case TY_VAR: {
                return true;
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private ImmutableList<Sig.TyParamSig> tyParamSig(Map<TyVarSymbol, TypeBoundClass.TyVarInfo> px, Env<ClassSymbol, TypeBoundClass> env) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<TyVarSymbol, TypeBoundClass.TyVarInfo> entry : px.entrySet()) {
            result.add((Object)this.tyParamSig(entry.getKey(), entry.getValue(), env));
        }
        return result.build();
    }

    private Sig.TyParamSig tyParamSig(TyVarSymbol sym, TypeBoundClass.TyVarInfo info, Env<ClassSymbol, TypeBoundClass> env) {
        String identifier = sym.name();
        Sig.TySig cbound = null;
        ImmutableList.Builder ibounds = ImmutableList.builder();
        if (info.upperBound().bounds().isEmpty()) {
            cbound = new Sig.ClassTySig("java/lang", (ImmutableList<Sig.SimpleClassTySig>)ImmutableList.of((Object)new Sig.SimpleClassTySig("Object", (ImmutableList<Sig.TySig>)ImmutableList.of())));
        } else {
            boolean first = true;
            for (Type bound : info.upperBound().bounds()) {
                Sig.TySig sig = this.signature(bound);
                if (first && !this.isInterface(bound, env)) {
                    cbound = sig;
                    continue;
                }
                ibounds.add((Object)sig);
                first = false;
            }
        }
        return new Sig.TyParamSig(identifier, cbound, (ImmutableList<Sig.TySig>)ibounds.build());
    }

    private boolean isInterface(Type type, Env<ClassSymbol, TypeBoundClass> env) {
        return type.tyKind() == Type.TyKind.CLASS_TY && env.getNonNull(((Type.ClassTy)type).sym()).kind() == TurbineTyKind.INTERFACE;
    }

    public String descriptor(ClassSymbol sym) {
        this.classes.add(sym);
        return sym.binaryName();
    }

    String objectType(ClassSymbol sym) {
        return "L" + this.descriptor(sym) + ";";
    }
}

