/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum UiMode implements ResourceEnum
{
    NORMAL("", "Normal", 1),
    CAR("car", "Car Dock", 8),
    DESK("desk", "Desk Dock", 8),
    TELEVISION("television", "Television", 13),
    APPLIANCE("appliance", "Appliance", 16),
    WATCH("watch", "Watch", 20),
    VR_HEADSET("vrheadset", "VR Headset", 26);

    private final String mValue;
    private final String mDisplayValue;
    private final int mSince;

    private UiMode(String value, String display, int since) {
        this.mValue = value;
        this.mDisplayValue = display;
        this.mSince = since;
    }

    public static UiMode getEnum(String value) {
        for (UiMode mode : UiMode.values()) {
            if (!mode.mValue.equals(value)) continue;
            return mode;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    public int since() {
        return this.mSince;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mDisplayValue;
    }

    public static int getIndex(UiMode value) {
        return value == null ? -1 : value.ordinal();
    }

    public static UiMode getByIndex(int index) {
        UiMode[] values = UiMode.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return this == NORMAL;
    }

    @Override
    public boolean isValidValueForDevice() {
        return this != NORMAL;
    }
}

