/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.JimfsFileSystem;
import com.google.common.jimfs.JimfsFileSystemProvider;
import com.google.common.jimfs.JimfsFileSystems;
import com.google.common.jimfs.SystemJimfsFileSystemProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.UUID;

public final class Jimfs {
    public static final String URI_SCHEME = "jimfs";

    private Jimfs() {
    }

    public static FileSystem newFileSystem() {
        return Jimfs.newFileSystem(Jimfs.newRandomFileSystemName());
    }

    public static FileSystem newFileSystem(String name) {
        return Jimfs.newFileSystem(name, Configuration.forCurrentPlatform());
    }

    public static FileSystem newFileSystem(Configuration configuration) {
        return Jimfs.newFileSystem(Jimfs.newRandomFileSystemName(), configuration);
    }

    public static FileSystem newFileSystem(String name, Configuration configuration) {
        try {
            URI uri = new URI(URI_SCHEME, name, null, null);
            return Jimfs.newFileSystem(uri, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @VisibleForTesting
    static FileSystem newFileSystem(URI uri, Configuration config) {
        Preconditions.checkArgument((boolean)URI_SCHEME.equals(uri.getScheme()), (String)"uri (%s) must have scheme %s", (Object[])new Object[]{uri, URI_SCHEME});
        try {
            JimfsFileSystem fileSystem = JimfsFileSystems.newFileSystem(JimfsFileSystemProvider.instance(), uri, config);
            ImmutableMap env = ImmutableMap.of((Object)"fileSystem", (Object)fileSystem);
            FileSystems.newFileSystem(uri, env, SystemJimfsFileSystemProvider.class.getClassLoader());
            return fileSystem;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String newRandomFileSystemName() {
        return UUID.randomUUID().toString();
    }
}

