/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.io.IOException;
import java.util.List;

class LazyStringListCodec
implements ObjectCodec<LazyStringList> {
    private static final UnmodifiableLazyStringList EMPTY_UNMODIFIABLE = new UnmodifiableLazyStringList(LazyStringArrayList.EMPTY);

    LazyStringListCodec() {
    }

    @Override
    public Class<LazyStringList> getEncodedClass() {
        return LazyStringList.class;
    }

    @Override
    public List<Class<? extends LazyStringList>> additionalEncodedClasses() {
        return ImmutableList.of(UnmodifiableLazyStringList.class, LazyStringArrayList.class);
    }

    @Override
    public void serialize(SerializationContext context, LazyStringList obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.size());
        for (String item : obj) {
            context.serialize(item, codedOut);
        }
    }

    @Override
    public UnmodifiableLazyStringList deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        if (size == 0) {
            return EMPTY_UNMODIFIABLE;
        }
        LazyStringArrayList list = new LazyStringArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add((Object)((String)context.deserialize(codedIn)));
        }
        return new UnmodifiableLazyStringList((LazyStringList)list);
    }
}

