/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.io.ByteSource;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianUtils {
    private LittleEndianUtils() {
    }

    public static long readUnsigned4Le(ByteSource bytes) throws IOException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        if (bytes.size() < 4L) {
            throw new EOFException("Not enough data: 4 bytes expected, " + bytes.size() + " available.");
        }
        byte[] b = bytes.read();
        Verify.verify((b.length >= 4 ? 1 : 0) != 0);
        long r = (long)(b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16) | ((long)b[3] & 0xFFL) << 24;
        Verify.verify((r >= 0L ? 1 : 0) != 0);
        Verify.verify((r <= 0xFFFFFFFFL ? 1 : 0) != 0);
        return r;
    }

    public static int readUnsigned2Le(ByteSource bytes) throws IOException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        if (bytes.size() < 2L) {
            throw new EOFException("Not enough data: 2 bytes expected, " + bytes.size() + " available.");
        }
        byte[] b = bytes.read();
        Verify.verify((b.length >= 2 ? 1 : 0) != 0);
        int r = b[0] & 0xFF | (b[1] & 0xFF) << 8;
        Verify.verify((r >= 0 ? 1 : 0) != 0);
        Verify.verify((r <= 65535 ? 1 : 0) != 0);
        return r;
    }

    public static void writeUnsigned4Le(OutputStream output, long value) throws IOException {
        Preconditions.checkNotNull((Object)output, (Object)"output == null");
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"value (%s) < 0", (Object[])new Object[]{value});
        Preconditions.checkArgument((value <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"value (%s) > 0x00000000ffffffffL", (Object[])new Object[]{value});
        output.write((byte)(value & 0xFFL));
        output.write((byte)(value >> 8 & 0xFFL));
        output.write((byte)(value >> 16 & 0xFFL));
        output.write((byte)(value >> 24 & 0xFFL));
    }

    public static void writeUnsigned2Le(OutputStream output, int value) throws IOException {
        Preconditions.checkNotNull((Object)output, (Object)"output == null");
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (String)"value (%s) < 0", (Object[])new Object[]{value});
        Preconditions.checkArgument((value <= 65535 ? 1 : 0) != 0, (String)"value (%s) > 0x0000ffff", (Object[])new Object[]{value});
        output.write((byte)(value & 0xFF));
        output.write((byte)(value >> 8 & 0xFF));
    }
}

