/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import lombok.ast.ClassDeclaration;
import lombok.ast.Identifier;
import lombok.ast.Node;

public class OverrideConcreteDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"OverrideAbstract", (String)"Not overriding abstract methods on older platforms", (String)"To improve the usability of some APIs, some methods that used to be `abstract` have been made concrete by adding default implementations. This means that when compiling with new versions of the SDK, your code does not have to override these methods.\n\nHowever, if your code is also targeting older versions of the platform where these methods were still `abstract`, the code will crash. You must override all methods that used to be abstract in any versions targeted by your application's `minSdkVersion`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(OverrideConcreteDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String NOTIFICATION_LISTENER_SERVICE_FQN = "android.service.notification.NotificationListenerService";
    public static final String STATUS_BAR_NOTIFICATION_FQN = "android.service.notification.StatusBarNotification";
    private static final String ON_NOTIFICATION_POSTED = "onNotificationPosted";
    private static final String ON_NOTIFICATION_REMOVED = "onNotificationRemoved";
    private static final int CONCRETE_IN = 21;

    public List<String> applicableSuperClasses() {
        return Collections.singletonList(NOTIFICATION_LISTENER_SERVICE_FQN);
    }

    public void checkClass(JavaContext context, ClassDeclaration node, Node declarationOrAnonymous, JavaParser.ResolvedClass resolvedClass) {
        String[] methodNames;
        if (node == null) {
            return;
        }
        int flags = node.astModifiers().getEffectiveModifierFlags();
        if ((flags & 0x400) != 0) {
            return;
        }
        int minSdk = Math.max(context.getProject().getMinSdk(), OverrideConcreteDetector.getTargetApi(node));
        if (minSdk >= 21) {
            return;
        }
        for (String methodName : methodNames = new String[]{ON_NOTIFICATION_POSTED, ON_NOTIFICATION_REMOVED}) {
            boolean found = false;
            for (JavaParser.ResolvedMethod method : resolvedClass.getMethods(methodName, true)) {
                JavaParser.ResolvedClass containingClass = method.getContainingClass();
                if (containingClass.matches(NOTIFICATION_LISTENER_SERVICE_FQN) || (method.getModifiers() & 0x400) != 0 || method.getArgumentCount() != 1 || !method.getArgumentType(0).matchesName(STATUS_BAR_NOTIFICATION_FQN)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String message = String.format("Must override `%1$s.%2$s(%3$s)`: Method was abstract until %4$d, and your `minSdkVersion` is %5$d", NOTIFICATION_LISTENER_SERVICE_FQN, methodName, STATUS_BAR_NOTIFICATION_FQN, 21, minSdk);
            Identifier nameNode = node.astName();
            context.report(ISSUE, (Node)node, context.getLocation((Node)nameNode), message);
            break;
        }
    }

    private static int getTargetApi(ClassDeclaration node) {
        while (node != null) {
            int targetApi = ApiDetector.getTargetApi(node.astModifiers());
            if (targetApi != -1) {
                return targetApi;
            }
            node = JavaContext.findSurroundingClass((Node)node.getParent());
        }
        return -1;
    }
}

