/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicyAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.UnusedReturnValueMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.type.TypeKind;

public abstract class AbstractReturnValueIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.NewClassTreeMatcher,
ResultUsePolicyAnalyzer<ExpressionTree, VisitorState> {
    private final Supplier<UnusedReturnValueMatcher> unusedReturnValueMatcher = Suppliers.memoize(() -> UnusedReturnValueMatcher.get((boolean)this.allowInExceptionThrowers()));
    private final Supplier<Matcher<ExpressionTree>> matcher = Suppliers.memoize(() -> Matchers.allOf((Matcher[])new Matcher[]{(Matcher)this.unusedReturnValueMatcher.get(), this::isCheckReturnValue}));
    private final Supplier<Matcher<MemberReferenceTree>> lostReferenceTreeMatcher = Suppliers.memoize(() -> Matchers.allOf((Matcher[])new Matcher[]{(Matcher & Serializable)(t, s) -> AbstractReturnValueIgnored.isObjectReturningMethodReferenceExpression(t, s), Matchers.not((Matcher & Serializable)(t, s) -> AbstractReturnValueIgnored.isExemptedInterfaceType(ASTHelpers.getType((Tree)t), s)), Matchers.not((Matcher & Serializable)(t, s) -> Matchers.isThrowingFunctionalInterface((Type)ASTHelpers.getType((Tree)t), (VisitorState)s)), this.specializedMatcher()}));
    private final ConstantExpressions constantExpressions;
    private static final ImmutableSet<String> EXEMPTED_TYPES = ImmutableSet.of((Object)"org.mockito.stubbing.Answer", (Object)"graphql.schema.DataFetcher", (Object)"org.jmock.lib.action.CustomAction", (Object)"net.sf.cglib.proxy.MethodInterceptor", (Object)"org.aopalliance.intercept.MethodInterceptor", (Object)InvocationHandler.class.getName(), (Object[])new String[0]);
    private static final Matcher<ExpressionTree> MOCKITO_VERIFY = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify");
    private static final com.google.errorprone.suppliers.Supplier<Name> NAME_OF_IS_TRUE = VisitorState.memoize((com.google.errorprone.suppliers.Supplier & Serializable)state -> state.getName("isTrue"));

    protected AbstractReturnValueIgnored() {
        this(ConstantExpressions.fromFlags(ErrorProneFlags.empty()));
    }

    protected AbstractReturnValueIgnored(ConstantExpressions constantExpressions) {
        this.constantExpressions = constantExpressions;
    }

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description description;
        Description description2 = description = this.matcher.get().matches((Tree)methodInvocationTree, state) ? this.describeReturnValueIgnored(methodInvocationTree, state) : Description.NO_MATCH;
        if (!description.equals(Description.NO_MATCH)) {
            return description;
        }
        return this.checkLostType(methodInvocationTree, state);
    }

    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        return this.matcher.get().matches((Tree)newClassTree, state) ? this.describeReturnValueIgnored(newClassTree, state) : Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Description description;
        Description description2 = description = this.matcher.get().matches((Tree)tree, state) ? this.describeReturnValueIgnored(tree, state) : Description.NO_MATCH;
        if (!this.lostType(state).isPresent() || !description.equals(Description.NO_MATCH)) {
            return description;
        }
        if (this.lostReferenceTreeMatcher.get().matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return description;
    }

    @Override
    public boolean isCovered(ExpressionTree tree, VisitorState state) {
        return this.isCheckReturnValue(tree, state);
    }

    @Override
    public ResultUsePolicy getMethodPolicy(ExpressionTree expression, VisitorState state) {
        return this.isCheckReturnValue(expression, state) ? ResultUsePolicy.EXPECTED : ResultUsePolicy.UNSPECIFIED;
    }

    private boolean isCheckReturnValue(ExpressionTree tree, VisitorState state) {
        return this.specializedMatcher().matches((Tree)tree, state);
    }

    protected abstract Matcher<? super ExpressionTree> specializedMatcher();

    protected Optional<Type> lostType(VisitorState state) {
        return Optional.empty();
    }

    protected String lostTypeMessage(String returnedType, String declaredReturnType) {
        return String.format("Returning %s from method that returns %s.", returnedType, declaredReturnType);
    }

    protected boolean allowInExceptionThrowers() {
        return true;
    }

    protected Description describeReturnValueIgnored(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return this.buildDescription(methodInvocationTree).addAllFixes(this.fixesAtCallSite(methodInvocationTree, state)).setMessage(this.getMessage(ASTHelpers.getSymbol((MethodInvocationTree)methodInvocationTree).getSimpleName())).build();
    }

    final ImmutableList<Fix> fixesAtCallSite(ExpressionTree invocationTree, VisitorState state) {
        ExpressionTree maybeMethodSelectOnMock;
        ExpressionTree maybeCallToMock;
        Preconditions.checkArgument((invocationTree.getKind() == Tree.Kind.METHOD_INVOCATION || invocationTree.getKind() == Tree.Kind.NEW_CLASS ? 1 : 0) != 0, (String)"unexpected kind: %s", (Object)((Object)invocationTree.getKind()));
        Tree parent = state.getPath().getParentPath().getLeaf();
        Type resultType = ASTHelpers.getType((Tree)invocationTree);
        ExpressionTree identifierExpr = invocationTree.getKind() == Tree.Kind.METHOD_INVOCATION ? ASTHelpers.getRootAssignable((MethodInvocationTree)((MethodInvocationTree)invocationTree)) : null;
        Symbol symbol = ASTHelpers.getSymbol((Tree)identifierExpr);
        Type identifierType = ASTHelpers.getType((Tree)identifierExpr);
        ImmutableMap.Builder fixes = ImmutableMap.builder();
        if (MOCKITO_VERIFY.matches((Tree)invocationTree, state) && (maybeCallToMock = ((MethodInvocationTree)invocationTree).getArguments().get(0)).getKind() == Tree.Kind.METHOD_INVOCATION && (maybeMethodSelectOnMock = ((MethodInvocationTree)maybeCallToMock).getMethodSelect()).getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree maybeSelectOnMock = (MemberSelectTree)maybeMethodSelectOnMock;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.postfixWith((Tree)maybeSelectOnMock.getExpression(), ")");
            int closingParen = Lists.reverse((java.util.List)state.getOffsetTokensForNode((Tree)invocationTree)).stream().filter(t -> t.kind() == Tokens.TokenKind.RPAREN).findFirst().get().pos();
            fix.replace(closingParen, closingParen + 1, "");
            fixes.put((Object)String.format("Verify that %s was called", maybeSelectOnMock.getIdentifier()), (Object)fix.build());
        }
        boolean considerBlanketFixes = true;
        if (resultType != null && resultType.getKind() == TypeKind.BOOLEAN) {
            SuggestedFix.Builder fix;
            if (state.errorProneOptions().isTestOnlyTarget()) {
                fix = SuggestedFix.builder();
                fix.prefixWith((Tree)invocationTree, SuggestedFixes.qualifyStaticImport((String)"com.google.common.truth.Truth.assertThat", (SuggestedFix.Builder)fix, (VisitorState)state) + "(").postfixWith((Tree)invocationTree, ").isTrue()");
                fixes.put((Object)"Assert that the result is true", (Object)fix.build());
            } else {
                fix = SuggestedFix.builder();
                fix.prefixWith((Tree)invocationTree, SuggestedFixes.qualifyStaticImport((String)"com.google.common.base.Verify.verify", (SuggestedFix.Builder)fix, (VisitorState)state) + "(").postfixWith((Tree)invocationTree, ")");
                fixes.put((Object)"Insert a runtime check that the result is true", (Object)fix.build());
            }
        } else if (resultType != null && ASTHelpers.matchingMethods((Name)((Name)NAME_OF_IS_TRUE.get(state)), m -> ((List)m.getParameters()).isEmpty(), (Type)resultType, (Types)state.getTypes()).anyMatch(m -> true)) {
            fixes.put((Object)"Assert that the result is true", (Object)SuggestedFix.postfixWith((Tree)invocationTree, (String)".isTrue()"));
            considerBlanketFixes = false;
        }
        if (identifierExpr != null && symbol != null && !symbol.name.contentEquals("this") && resultType != null && state.getTypes().isAssignable(resultType, identifierType)) {
            fixes.put((Object)"Assign result back to variable", (Object)SuggestedFix.prefixWith((Tree)invocationTree, (String)(state.getSourceForNode((Tree)identifierExpr) + " = ")));
        }
        if (parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT && !this.constantExpressions.constantExpression(invocationTree, state).isPresent() && considerBlanketFixes) {
            ImmutableSet identifiersInScope = (ImmutableSet)FindIdentifiers.findAllIdents((VisitorState)state).stream().map(v -> v.name.toString()).collect(ImmutableSet.toImmutableSet());
            Stream.concat(Stream.of("unused"), IntStream.range(2, 10).mapToObj(i -> "unused" + i)).filter(n -> !identifiersInScope.contains(n)).findFirst().ifPresent(n -> fixes.put((Object)"Suppress error by assigning to a variable", (Object)SuggestedFix.prefixWith((Tree)parent, (String)String.format("var %s = ", n))));
        }
        if (parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT && considerBlanketFixes) {
            if (this.constantExpressions.constantExpression(invocationTree, state).isPresent()) {
                fixes.put((Object)"Delete call", (Object)SuggestedFix.delete((Tree)parent));
            } else {
                fixes.put((Object)"Delete call and any side effects", (Object)SuggestedFix.delete((Tree)parent));
            }
        }
        return (ImmutableList)fixes.buildOrThrow().entrySet().stream().map(e -> SuggestedFix.builder().merge((SuggestedFix)e.getValue()).setShortDescription((String)e.getKey()).build()).collect(ImmutableList.toImmutableList());
    }

    protected Description describeReturnValueIgnored(MemberReferenceTree memberReferenceTree, VisitorState state) {
        return this.buildDescription(memberReferenceTree).setMessage(this.getMessage(state.getName(AbstractReturnValueIgnored.descriptiveNameForMemberReference(memberReferenceTree, state)))).build();
    }

    protected Description describeReturnValueIgnored(NewClassTree newClassTree, VisitorState state) {
        return this.buildDescription(newClassTree).setMessage(String.format("Ignored return value of '%s'", state.getSourceForNode((Tree)newClassTree.getIdentifier()))).build();
    }

    private static String descriptiveNameForMemberReference(MemberReferenceTree memberReferenceTree, VisitorState state) {
        if (memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW) {
            return state.getSourceForNode((Tree)memberReferenceTree.getQualifierExpression());
        }
        return memberReferenceTree.getName().toString();
    }

    protected String getMessage(javax.lang.model.element.Name name) {
        return this.message();
    }

    private Description checkLostType(MethodInvocationTree tree, VisitorState state) {
        Optional<Type> optionalType = this.lostType(state);
        if (!optionalType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type lostType = optionalType.get();
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Type returnType = ASTHelpers.getResultType((ExpressionTree)tree);
        Type returnedFutureType = state.getTypes().asSuper(returnType, lostType.tsym);
        if (returnedFutureType != null && !returnedFutureType.hasTag(TypeTag.ERROR) && !returnedFutureType.isRaw()) {
            if (ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnedFutureType.getTypeArguments().get(0), (Types)state.getTypes()), (Type)lostType, (VisitorState)state)) {
                return this.buildDescription(tree).setMessage(String.format("Method returns a nested type, %s", returnType)).build();
            }
            Type methodReturnType = sym.getReturnType();
            java.util.List typeParameters = sym.getTypeParameters();
            HashSet<Symbol.TypeVariableSymbol> returnTypeChoosing = new HashSet<Symbol.TypeVariableSymbol>();
            for (Symbol.TypeVariableSymbol tvs : typeParameters) {
                ArrayDeque<Symbol.TypeVariableSymbol> queue = new ArrayDeque<Symbol.TypeVariableSymbol>();
                queue.add(tvs);
                while (!queue.isEmpty()) {
                    Symbol.TypeVariableSymbol currentTypeParam = (Symbol.TypeVariableSymbol)queue.remove();
                    for (Type typeParam : methodReturnType.getTypeArguments()) {
                        if (typeParam.tsym != currentTypeParam) continue;
                        returnTypeChoosing.add(tvs);
                    }
                    for (Type toAdd : currentTypeParam.getBounds()) {
                        if (!(toAdd.tsym instanceof Symbol.TypeVariableSymbol)) continue;
                        queue.add((Symbol.TypeVariableSymbol)toAdd.tsym);
                    }
                }
            }
            if (!returnTypeChoosing.isEmpty()) {
                ListMultimap<Symbol.TypeVariableSymbol, TypeInfo> resolved = AbstractReturnValueIgnored.getResolvedGenerics(tree);
                for (Symbol.TypeVariableSymbol returnTypeChoosingSymbol : returnTypeChoosing) {
                    java.util.List types = resolved.get((Object)returnTypeChoosingSymbol);
                    for (TypeInfo type : types) {
                        if (!ASTHelpers.isSubtype((Type)type.resolvedVariableType, (Type)lostType, (VisitorState)state)) continue;
                        return this.buildDescription(type.tree).setMessage(String.format("Invocation produces a nested type - Type variable %s, as part of return type %s resolved to %s.", returnTypeChoosingSymbol, methodReturnType, type.resolvedVariableType)).build();
                    }
                }
            }
        }
        Matcher[] matcherArray = new Matcher[3];
        Matcher[] matcherArray2 = new Matcher[2];
        matcherArray2[0] = Matchers.parentNode(AbstractReturnValueIgnored::isObjectReturningLambdaExpression);
        matcherArray2[1] = Matchers.not((arg_0, arg_1) -> ((UnusedReturnValueMatcher)this.unusedReturnValueMatcher.get()).isAllowed(arg_0, arg_1));
        matcherArray[0] = Matchers.allOf((Matcher[])matcherArray2);
        matcherArray[1] = this.specializedMatcher();
        matcherArray[2] = Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)t), (VisitorState)s));
        if (Matchers.allOf((Matcher[])matcherArray).matches((Tree)tree, state)) {
            return this.describeReturnValueIgnored(tree, state);
        }
        return Description.NO_MATCH;
    }

    private static ListMultimap<Symbol.TypeVariableSymbol, TypeInfo> getResolvedGenerics(MethodInvocationTree tree) {
        Type type = ASTHelpers.getType((Tree)tree.getMethodSelect());
        ImmutableListMultimap subst = ASTHelpers.getTypeSubstitution((Type)type, (Symbol)ASTHelpers.getSymbol((MethodInvocationTree)tree));
        return (ListMultimap)subst.entries().stream().map(e -> new TypeInfo((Symbol.TypeVariableSymbol)e.getKey(), (Type)e.getValue(), tree)).collect(Multimaps.toMultimap(k -> k.sym, k -> k, () -> ((MultimapBuilder.ListMultimapBuilder)MultimapBuilder.linkedHashKeys().arrayListValues()).build()));
    }

    private static boolean isObjectReturningMethodReferenceExpression(MemberReferenceTree tree, VisitorState state) {
        return AbstractReturnValueIgnored.functionalInterfaceReturnsObject(ASTHelpers.getType((Tree)tree), state);
    }

    private static boolean isObjectReturningLambdaExpression(Tree tree, VisitorState state) {
        if (!(tree instanceof LambdaExpressionTree)) {
            return false;
        }
        Type type = ASTHelpers.getType((Tree)tree);
        return AbstractReturnValueIgnored.functionalInterfaceReturnsObject(type, state) && !AbstractReturnValueIgnored.isExemptedInterfaceType(type, state);
    }

    private static boolean functionalInterfaceReturnsObject(Type interfaceType, VisitorState state) {
        Type objectType = state.getSymtab().objectType;
        return ASTHelpers.isSubtype((Type)objectType, (Type)ASTHelpers.getUpperBound((Type)state.getTypes().findDescriptorType(interfaceType).getReturnType(), (Types)state.getTypes()), (VisitorState)state);
    }

    private static boolean isExemptedInterfaceType(Type type, VisitorState state) {
        return EXEMPTED_TYPES.stream().map(arg_0 -> ((VisitorState)state).getTypeFromString(arg_0)).anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)t, (VisitorState)state));
    }

    private static boolean isExemptedInterfaceMethod(Symbol.MethodSymbol symbol, VisitorState state) {
        return AbstractReturnValueIgnored.isExemptedInterfaceType(ASTHelpers.enclosingClass((Symbol)symbol).type, state);
    }

    public Description matchReturn(ReturnTree tree, VisitorState state) {
        Optional<Type> optionalType = this.lostType(state);
        if (!optionalType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type objectType = state.getSymtab().objectType;
        Type lostType = optionalType.get();
        Type resultType = ASTHelpers.getResultType((ExpressionTree)tree.getExpression());
        if (resultType == null) {
            return Description.NO_MATCH;
        }
        if (resultType.getKind() == TypeKind.NULL || resultType.getKind() == TypeKind.NONE) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype((Type)resultType, (Type)lostType, (VisitorState)state)) {
            for (Tree enclosing : state.getPath()) {
                if (enclosing instanceof MethodTree) {
                    MethodTree methodTree = (MethodTree)enclosing;
                    Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)methodTree);
                    if (!ASTHelpers.isSubtype((Type)objectType, (Type)symbol.getReturnType(), (VisitorState)state) || AbstractReturnValueIgnored.isExemptedInterfaceMethod(symbol, state)) break;
                    return this.buildDescription(tree).setMessage(this.lostTypeMessage(resultType.toString(), symbol.getReturnType().toString())).build();
                }
                if (!(enclosing instanceof LambdaExpressionTree)) continue;
                LambdaExpressionTree lambdaTree = (LambdaExpressionTree)enclosing;
                if (!AbstractReturnValueIgnored.isObjectReturningLambdaExpression(lambdaTree, state)) break;
                return this.buildDescription(tree).setMessage(this.lostTypeMessage(resultType.toString(), "Object")).build();
            }
        }
        return Description.NO_MATCH;
    }

    private static final class TypeInfo {
        private final Symbol.TypeVariableSymbol sym;
        private final Type resolvedVariableType;
        private final Tree tree;

        private TypeInfo(Symbol.TypeVariableSymbol sym, Type resolvedVariableType, Tree tree) {
            this.sym = sym;
            this.resolvedVariableType = resolvedVariableType;
            this.tree = tree;
        }
    }
}

