/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(summary="Thread pool size will never go beyond corePoolSize if an unbounded queue is used", severity=BugPattern.SeverityLevel.WARNING)
public final class ErroneousThreadPoolConstructorChecker
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> THREAD_POOL_CONSTRUCTOR_MATCHER = Matchers.constructor().forClass("java.util.concurrent.ThreadPoolExecutor");
    private static final Matcher<ExpressionTree> UNBOUNDED_WORK_QUEUE_CONSTRUCTOR_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.util.concurrent.LinkedBlockingDeque").withNoParameters(), Matchers.constructor().forClass("java.util.concurrent.LinkedBlockingDeque").withParameters("java.util.Collection", new String[0]), Matchers.constructor().forClass("java.util.concurrent.LinkedBlockingQueue").withNoParameters(), Matchers.constructor().forClass("java.util.concurrent.LinkedBlockingQueue").withParameters("java.util.Collection", new String[0]), Matchers.constructor().forClass("java.util.concurrent.LinkedTransferQueue"), Matchers.constructor().forClass("java.util.concurrent.PriorityBlockingQueue")});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!THREAD_POOL_CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() < 2) {
            return Description.NO_MATCH;
        }
        Integer corePoolSize = (Integer)ASTHelpers.constValue((Tree)arguments.get(0), Integer.class);
        Integer maximumPoolSize = (Integer)ASTHelpers.constValue((Tree)arguments.get(1), Integer.class);
        if (corePoolSize == null || maximumPoolSize == null || corePoolSize.equals(maximumPoolSize)) {
            return Description.NO_MATCH;
        }
        if (corePoolSize == 0 && maximumPoolSize == 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree workQueueExpressionTree = arguments.get(4);
        if (!UNBOUNDED_WORK_QUEUE_CONSTRUCTOR_MATCHER.matches((Tree)workQueueExpressionTree, state)) {
            return Description.NO_MATCH;
        }
        String maximumPoolSizeReplacement = corePoolSize == 0 ? "1" : state.getSourceForNode((Tree)arguments.get(0));
        SuggestedFix maximumPoolSizeReplacementFix = SuggestedFix.builder().replace((Tree)arguments.get(1), maximumPoolSizeReplacement).build();
        SuggestedFix corePoolSizeReplacementFix = SuggestedFix.builder().replace((Tree)arguments.get(0), state.getSourceForNode((Tree)arguments.get(1))).build();
        return this.buildDescription(tree).addFix((Fix)maximumPoolSizeReplacementFix).addFix((Fix)corePoolSizeReplacementFix).build();
    }
}

