/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import java.util.Optional;

@BugPattern(summary="This fuzzy equality check is using a tolerance less than the gap to the next number. You may want a less restrictive tolerance, or to assert equality.", severity=BugPattern.SeverityLevel.WARNING, tags={"Simplification"})
public final class FloatingPointAssertionWithinEpsilon
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String DESCRIPTION = "This fuzzy equality check is using a tolerance less than the gap to the next number (which is ~%.2g). You may want a less restrictive tolerance, or to assert equality.";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (FloatingPointType floatingPointType : FloatingPointType.values()) {
            Optional<Description> description = floatingPointType.match(this, tree, state);
            if (!description.isPresent()) continue;
            return description.get();
        }
        return Description.NO_MATCH;
    }

    private static enum FloatingPointType {
        FLOAT(TypeTag.FLOAT, "float", "com.google.common.truth.FloatSubject", "TolerantFloatComparison"){

            @Override
            Float nextNumber(Number actual) {
                float number = actual.floatValue();
                return Float.valueOf(Math.min(Math.nextUp(number) - number, number - Math.nextDown(number)));
            }

            @Override
            boolean isIntolerantComparison(Number tolerance, Number actual) {
                return tolerance.floatValue() != 0.0f && tolerance.floatValue() < this.nextNumber(actual).floatValue();
            }

            @Override
            Optional<String> suffixLiteralIfPossible(LiteralTree literal, VisitorState state) {
                return Optional.of(1.removeSuffixes(state.getSourceForNode((Tree)literal)) + "f");
            }
        }
        ,
        DOUBLE(TypeTag.DOUBLE, "double", "com.google.common.truth.DoubleSubject", "TolerantDoubleComparison"){

            @Override
            Double nextNumber(Number actual) {
                double number = actual.doubleValue();
                return Math.min(Math.nextUp(number) - number, number - Math.nextDown(number));
            }

            @Override
            boolean isIntolerantComparison(Number tolerance, Number actual) {
                return tolerance.doubleValue() != 0.0 && tolerance.doubleValue() < this.nextNumber(actual);
            }

            @Override
            Optional<String> suffixLiteralIfPossible(LiteralTree literal, VisitorState state) {
                double asDouble;
                String literalString = 2.removeSuffixes(state.getSourceForNode((Tree)literal));
                try {
                    asDouble = Double.parseDouble(literalString);
                }
                catch (NumberFormatException nfe) {
                    return Optional.empty();
                }
                if (asDouble == ((Number)ASTHelpers.constValue((Tree)literal, Number.class)).doubleValue()) {
                    return Optional.of(literalString.contains(".") ? literalString : literalString + "d");
                }
                return Optional.empty();
            }
        };

        private final TypeTag typeTag;
        private final String typeName;
        private final Matcher<MethodInvocationTree> truthOfCall;
        private final Matcher<ExpressionTree> junitWithoutMessage;
        private final Matcher<ExpressionTree> junitWithMessage;

        private FloatingPointType(TypeTag typeTag, String typeName, String subjectClass, String tolerantSubclass) {
            this.typeTag = typeTag;
            this.typeName = typeName;
            String tolerantClass = subjectClass + "." + tolerantSubclass;
            this.truthOfCall = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(tolerantClass).named("of").withParameters(typeName, new String[0]), Matchers.receiverOfInvocation((Matcher)MethodMatchers.instanceMethod().onDescendantOf(subjectClass).namedAnyOf(new String[]{"isWithin", "isNotWithin"}).withParameters(typeName, new String[0]))});
            this.junitWithoutMessage = MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals").withParameters(typeName, new String[]{typeName, typeName});
            this.junitWithMessage = MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertEquals").withParameters("java.lang.String", new String[]{typeName, typeName, typeName});
        }

        abstract Number nextNumber(Number var1);

        abstract boolean isIntolerantComparison(Number var1, Number var2);

        abstract Optional<String> suffixLiteralIfPossible(LiteralTree var1, VisitorState var2);

        private Optional<Description> match(BugChecker bugChecker, MethodInvocationTree tree, VisitorState state) {
            if (this.junitWithoutMessage.matches((Tree)tree, state)) {
                return this.check(tree.getArguments().get(2), tree.getArguments().get(0)).map(tolerance -> FloatingPointType.suggestJunitFix(bugChecker, tree).setMessage(String.format(FloatingPointAssertionWithinEpsilon.DESCRIPTION, tolerance)).build());
            }
            if (this.junitWithMessage.matches((Tree)tree, state)) {
                return this.check(tree.getArguments().get(3), tree.getArguments().get(1)).map(tolerance -> FloatingPointType.suggestJunitFix(bugChecker, tree).setMessage(String.format(FloatingPointAssertionWithinEpsilon.DESCRIPTION, tolerance)).build());
            }
            if (this.truthOfCall.matches((Tree)tree, state)) {
                return this.check(FloatingPointType.getReceiverArgument(tree), (ExpressionTree)Iterables.getOnlyElement(tree.getArguments())).map(tolerance -> this.suggestTruthFix(bugChecker, tree, state).setMessage(String.format(FloatingPointAssertionWithinEpsilon.DESCRIPTION, tolerance)).build());
            }
            return Optional.empty();
        }

        private Optional<Double> check(ExpressionTree toleranceArgument, ExpressionTree actualArgument) {
            Number actual = (Number)ASTHelpers.constValue((Tree)actualArgument, Number.class);
            Number tolerance = (Number)ASTHelpers.constValue((Tree)toleranceArgument, Number.class);
            if (actual == null || tolerance == null) {
                return Optional.empty();
            }
            return this.isIntolerantComparison(tolerance, actual) ? Optional.of(this.nextNumber(actual).doubleValue()) : Optional.empty();
        }

        private static ExpressionTree getReceiverArgument(MethodInvocationTree tree) {
            ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            return (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        }

        private static Description.Builder suggestJunitFix(BugChecker bugChecker, MethodInvocationTree tree) {
            SuggestedFix fix = SuggestedFix.replace((Tree)((Tree)Iterables.getLast(tree.getArguments())), (String)"0");
            return bugChecker.buildDescription((Tree)tree).addFix((Fix)fix);
        }

        private Description.Builder suggestTruthFix(BugChecker bugChecker, MethodInvocationTree tree, VisitorState state) {
            ExpressionTree within = ASTHelpers.getReceiver((ExpressionTree)tree);
            ExpressionTree assertion = ASTHelpers.getReceiver((ExpressionTree)within);
            String replacementMethod = ASTHelpers.getSymbol((Tree)within).getSimpleName().toString().contains("Not") ? "isNotEqualTo" : "isEqualTo";
            ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
            SuggestedFix fix = SuggestedFix.replace((Tree)tree, (String)String.format("%s.%s(%s)", state.getSourceForNode((Tree)assertion), replacementMethod, this.castArgumentIfNecessary(argument, state)));
            return bugChecker.buildDescription((Tree)tree).addFix((Fix)fix);
        }

        private String castArgumentIfNecessary(ExpressionTree tree, VisitorState state) {
            Optional<String> suffixed;
            String source = state.getSourceForNode((Tree)tree);
            Type type = ASTHelpers.getType((Tree)tree);
            if (state.getTypes().unboxedTypeOrType(type).getTag() == this.typeTag) {
                return source;
            }
            if (tree instanceof LiteralTree && (suffixed = this.suffixLiteralIfPossible((LiteralTree)tree, state)).isPresent()) {
                return suffixed.get();
            }
            if (ASTHelpers.requiresParentheses((ExpressionTree)tree, (VisitorState)state)) {
                return String.format("(%s) (%s)", this.typeName, source);
            }
            return String.format("(%s) %s", this.typeName, source);
        }

        static String removeSuffixes(String source) {
            return source.replaceAll("[fFdDlL]$", "");
        }
    }
}

