/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;

public final class ImmutableCollections {
    public static final ImmutableMap<String, String> MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP = ImmutableMap.builder().put((Object)BiMap.class.getName(), (Object)ImmutableBiMap.class.getName()).put((Object)ListMultimap.class.getName(), (Object)ImmutableListMultimap.class.getName()).put((Object)Multimap.class.getName(), (Object)ImmutableMultimap.class.getName()).put((Object)Multiset.class.getName(), (Object)ImmutableMultiset.class.getName()).put((Object)RangeMap.class.getName(), (Object)ImmutableRangeMap.class.getName()).put((Object)RangeSet.class.getName(), (Object)ImmutableRangeSet.class.getName()).put((Object)SetMultimap.class.getName(), (Object)ImmutableSetMultimap.class.getName()).put((Object)SortedMultiset.class.getName(), (Object)ImmutableSortedMultiset.class.getName()).put((Object)Table.class.getName(), (Object)ImmutableTable.class.getName()).put((Object)Collection.class.getName(), (Object)ImmutableCollection.class.getName()).put((Object)List.class.getName(), (Object)ImmutableList.class.getName()).put((Object)Map.class.getName(), (Object)ImmutableMap.class.getName()).put((Object)NavigableMap.class.getName(), (Object)ImmutableSortedMap.class.getName()).put((Object)NavigableSet.class.getName(), (Object)ImmutableSortedSet.class.getName()).put((Object)Set.class.getName(), (Object)ImmutableSet.class.getName()).put((Object)EnumSet.class.getName(), (Object)ImmutableSet.class.getName()).put((Object)ArrayList.class.getName(), (Object)ImmutableList.class.getName()).put((Object)HashMap.class.getName(), (Object)ImmutableMap.class.getName()).put((Object)HashSet.class.getName(), (Object)ImmutableSet.class.getName()).put((Object)EnumMap.class.getName(), (Object)ImmutableMap.class.getName()).buildOrThrow();

    private ImmutableCollections() {
    }

    public static boolean isImmutableType(Type type) {
        return MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.containsValue((Object)ImmutableCollections.getTypeQualifiedName(type));
    }

    static Optional<String> mutableToImmutable(String fullyQualifiedClassName) {
        return Optional.ofNullable((String)MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.get((Object)fullyQualifiedClassName));
    }

    private static String getTypeQualifiedName(Type type) {
        return type.tsym.getQualifiedName().toString();
    }
}

